/*
 * Decompiled with CFR 0.152.
 */
package gnu.cajo.utils;

import gnu.cajo.invoke.Remote;
import gnu.cajo.invoke.RemoteInvoke;
import gnu.cajo.utils.ItemServer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.rmi.MarshalledObject;

public final class Multicast
implements Runnable {
    private Object callback;
    private Thread thread;
    public final InetAddress host;
    public final String address;
    public final int port;
    public InetAddress iaddr;
    public RemoteInvoke item;

    public Multicast() throws UnknownHostException {
        this(null, "224.0.23.162", 1198);
    }

    public Multicast(String address, int port) throws UnknownHostException {
        this(null, address, port);
    }

    public Multicast(String host, String address, int port) throws UnknownHostException {
        if (host == null) {
            host = InetAddress.getLocalHost().getHostAddress();
        }
        this.host = InetAddress.getByName(host);
        this.address = address;
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void announce(Object item, int ttl) throws IOException {
        InetAddress group = InetAddress.getByName(this.address);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (!(item instanceof Remote)) {
            item = new Remote(item);
        }
        try {
            Remote.invoke(item, "startThread", null);
            Remote.invoke(item, "setProxy", new MarshalledObject<Object>(item));
        }
        catch (Exception x) {
            // empty catch block
        }
        ((Remote)item).zedmob(baos);
        byte[] packet = baos.toByteArray();
        baos.close();
        MulticastSocket ms = new MulticastSocket();
        try {
            ms.setInterface(this.host);
            ms.setTimeToLive(ttl);
            ms.send(new DatagramPacket(packet, packet.length, group, this.port));
        }
        finally {
            ms.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void announce(Object item, int ttl, Object proxy) throws IOException {
        InetAddress group = InetAddress.getByName(this.address);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (!(item instanceof Remote)) {
            item = new Remote(item);
        }
        try {
            Remote.invoke(proxy, "setItem", item);
        }
        catch (Exception x) {
            // empty catch block
        }
        try {
            Remote.invoke(item, "startThread", null);
            Remote.invoke(item, "setProxy", new MarshalledObject<Object>(proxy));
        }
        catch (Exception x) {
            // empty catch block
        }
        ((Remote)item).zedmob(baos);
        byte[] packet = baos.toByteArray();
        baos.close();
        MulticastSocket ms = new MulticastSocket();
        try {
            ms.setInterface(this.host);
            ms.setTimeToLive(ttl);
            ms.send(new DatagramPacket(packet, packet.length, group, this.port));
        }
        finally {
            ms.close();
        }
    }

    public void listen(Object callback) {
        if (this.thread != null) {
            throw new IllegalArgumentException("Already listening");
        }
        this.callback = callback;
        this.thread = new Thread(this);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            MulticastSocket ms = new MulticastSocket(this.port);
            ms.setInterface(this.host);
            ms.joinGroup(InetAddress.getByName(this.address));
            DatagramPacket dp = new DatagramPacket(new byte[65280], 65280);
            while (!this.thread.isInterrupted()) {
                try {
                    ms.receive(dp);
                    ByteArrayInputStream bais = new ByteArrayInputStream(dp.getData());
                    try {
                        this.item = (RemoteInvoke)Remote.zedmob(bais);
                        this.iaddr = dp.getAddress();
                        Object quit = Remote.invoke(this.callback, "multicast", this);
                        this.item = null;
                        if (quit == null) continue;
                        break;
                    }
                    catch (Exception x) {
                        x.printStackTrace();
                    }
                    finally {
                        bais.close();
                    }
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
            ms.close();
            ms = null;
            this.thread = null;
        }
        catch (IOException x) {
            x.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            args = new String[]{"///main"};
        }
        String clientHost = args.length > 1 ? args[1] : null;
        int clientPort = args.length > 2 ? Integer.parseInt(args[2]) : 0;
        String localHost = args.length > 3 ? args[3] : null;
        int localPort = args.length > 4 ? Integer.parseInt(args[4]) : 0;
        Remote.config(localHost, localPort, clientHost, clientPort);
        ItemServer.acceptProxies();
        Remote item = new Remote(Remote.getItem(args[0]));
        if (args.length > 5) {
            Remote.invoke(item, "setProxy", Remote.getItem(args[5]));
        }
        Multicast m = new Multicast();
        m.announce(ItemServer.bind(item, "main"), 16);
        m.listen(item);
    }
}

