(ns net.project-fifo.libsniffle.iprangea
  (:use 
   [net.project-fifo.libsniffle.connection :only [list-to-str  str-to-bin]])
  (:require
   [net.project-fifo.libsniffle.connection :as connection]))

(defn- send [server & args]
  (connection/send server (vec (concat [:iprange] args))))

(defn- str-to-ip [s]
  (let [[a b c d] (map #(Integer/parseInt %) (clojure.core/re-seq  #"[^.]+" s))]
    (unchecked-add 
     (unchecked-add 
      (unchecked-add
       (unchecked-int  (bit-shift-left a 24))
       (unchecked-int (bit-shift-left b 16)))
      (unchecked-int (bit-shift-left c 8)))
     (unchecked-int d))))

(defn- ip-to-str [ip]
  (let [a (bit-and (bit-shift-right ip 24) 0xFF)
        b (bit-and (bit-shift-right ip 16) 0xFF)
        c (bit-and (bit-shift-right ip 8) 0xFF)
        d (bit-and ip 0xFF)]
    (str a "." b "." c "." d)))

(defn create [server name network gateway netmask first last tag]
  (second (send server :create (str-to-bin name) 
                (str-to-ip network) (str-to-ip gateway) (str-to-ip netmask) 
                (str-to-ip first) (str-to-ip last) 
                (str-to-bin tag))))

(defn delete [server range]
  (second  (send server :delete (str-to-bin range))))

(defn get [server range]
  (let [r (second (second (send server :get (str-to-bin range))))]
    (if (= r :not_found)
      r
      (let [[_ name network gateway netmask first last current tag free] r]
        [(list-to-str name) 
         (ip-to-str network) 
         (ip-to-str gateway) 
         (ip-to-str netmask) 
         (ip-to-str first) 
         (ip-to-str last) 
         (ip-to-str current) 
         (list-to-str tag) 
         (map ip-to-str free)]))))

(defn release [server range ip]
  (second (send server :release (str-to-bin range) (str-to-ip ip))))

(defn claim [server range]
  (let [r (second (second (send server :claim (str-to-bin range))))]
    (if (= r :not_found)
      r
      (let [[ip netmask gateway] r]
        [(ip-to-str ip) 
         (ip-to-str gateway) 
         (ip-to-str netmask)]))))

(defn list 
  ([server]
     (let [[_ [_ r]] (send server :list)]
       (map list-to-str r)))
  ([server user]
     (let [[_ [_ r]] (send server :list user)]
       (map list-to-str r))))