(ns net.project-fifo.libsniffle.connection
  (:import (java.net Socket)
           (java.io DataOutputStream DataInputStream))
  (:require
   [com.trottercashion.bert-clj.bert :as bert]))

(defn send [server message]
  (let [socket (Socket. (:name server) (:port server))
        in (DataInputStream. (.getInputStream socket))
        out (DataOutputStream. (.getOutputStream socket))
        bert-msg (bert/encode message)]
    (.write out (byte-array (map byte bert-msg)) 0 (count bert-msg))
    (let [len 10240
          a (byte-array len)
          read (.read in a 0 len)]
      (bert/decode (take read a)))))

(defn list-to-str [l]
  (apply str (map (fn [c] (char c)) l)))

(defn str-to-bin [s]
  (map (comp byte int) (seq s)))

(declare erlangify-tuple-list)

(defn erlangify-value [v]
  (cond 
   (string? v) (str-to-bin v)
   (vector? v) (vector (map erlangify-value v))
   (seq? v) (map erlangify-value v)
   :else v))

(defn- erlangify-tuple [[k v]]
  [(str-to-bin k)
   (cond
       (list? v) (erlangify-tuple-list v)
     (string? v) (str-to-bin v)
     :else v)])

(defn erlangify-tuple-list [spec]
  (map erlangify-tuple spec))

(declare clojurefy-tuple-list)

(defn- clojurefy-tuple [[k v]]
  [(list-to-str k) 
   (cond 
    (and (seq? v) (vector? (first v))) (clojurefy-tuple-list v)
    (and (seq? v) (number? (first v))) (list-to-str v)
    :else v)])

(defn clojurefy-tuple-list [l]
  (map clojurefy-tuple l))