(ns net.project-fifo.libsnarl.user
  (:use 
   [net.project-fifo.libsnarl.connection :only 
    [list-to-str str-to-bin erlangify-tuple-list clojurefy-tuple-list erlangify-value]])
  (:require
   [net.project-fifo.libsnarl.connection :as connection]))

(defn- send-to-server [server & args]
  (second (connection/send-to-server server (vec (concat [:user] args)))))


(defn auth [server login password]
  (second (send-to-server server :auth 
                (str-to-bin login)
                (str-to-bin password))))


(defn allowed [server user permission]
  (second (send-to-server server :allowed 
                (str-to-bin user)
                (erlangify-value permission))))

(defn list-user [server]
  (second (send-to-server server :list)))

(defn get-user [server user]
  (second (send-to-server server :get (str-to-bin user))))

(defn add [server user]
  (second (send-to-server server :add (str-to-bin user))))

(defn delete [server user]
  (second (send-to-server server :delete (str-to-bin user))))

(defn grant [server user permission]
  (second (send-to-server server :grant (str-to-bin user) (map erlangify-value permission))))

(defn revoke [server user permission]
  (second (send-to-server server :revoke (str-to-bin user) (map erlangify-value permission))))

(defn passwd [server user passwd]
  (second (send-to-server server :passwd (str-to-bin user) (str-to-bin passwd))))

(defn join [server user group]
  (second (send-to-server server :join (str-to-bin user) (str-to-bin group))))

(defn leave [server user group]
  (second (send-to-server server :leave (str-to-bin user) (str-to-bin group))))


