(ns net.project-fifo.libsnarl.group
  (:use 
   [net.project-fifo.libsnarl.connection :only 
    [list-to-str str-to-bin erlangify-tuple-list clojurefy-tuple-list erlangify-value]])
  (:require
   [net.project-fifo.libsnarl.connection :as connection]))

(defn- send-to-server [server & args]
  (second (connection/send-to-server server (vec (concat [:group] args)))))

(defn list-groups [server]
  (second (send-to-server server :list)))

(defn get-group [server group]
  (second (send-to-server server :get (str-to-bin group))))

(defn add [server group]
  (second (send-to-server server :add (str-to-bin group))))

(defn delete [server group]
  (second (send-to-server server :delete (str-to-bin group))))

(defn grant [server group permission]
  (second (send-to-server server :grant (str-to-bin group) (map erlangify-value permission))))

(defn revoke [server group permission]
  (second (send-to-server server :revoke (str-to-bin group) (map erlangify-value permission))))
