// Copyright 2011 The Closure Library Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS-IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/**
 * @fileoverview Date/time formatting symbols for all locales.
 *
 * This file is autogenerated by scripts
 *   i18n/tools/generate_datetime_constants.py --for_closure
 *
 * This file contains symbols for locales that are not covered by
 * datetimesymbols.js.
 * Before checkin, this file could have been manually edited. This is
 * to incorporate changes before we could correct CLDR. All manual
 * modification must be documented in this section, and should be
 * removed after those changes lands to CLDR.
 */

goog.provide('goog.i18n.DateTimeSymbolsExt');
goog.provide('goog.i18n.DateTimeSymbols_aa');
goog.provide('goog.i18n.DateTimeSymbols_aa_DJ');
goog.provide('goog.i18n.DateTimeSymbols_aa_ER');
goog.provide('goog.i18n.DateTimeSymbols_aa_ET');
goog.provide('goog.i18n.DateTimeSymbols_af');
goog.provide('goog.i18n.DateTimeSymbols_af_NA');
goog.provide('goog.i18n.DateTimeSymbols_af_ZA');
goog.provide('goog.i18n.DateTimeSymbols_ak');
goog.provide('goog.i18n.DateTimeSymbols_ak_GH');
goog.provide('goog.i18n.DateTimeSymbols_am_ET');
goog.provide('goog.i18n.DateTimeSymbols_ar_AE');
goog.provide('goog.i18n.DateTimeSymbols_ar_BH');
goog.provide('goog.i18n.DateTimeSymbols_ar_DZ');
goog.provide('goog.i18n.DateTimeSymbols_ar_EG');
goog.provide('goog.i18n.DateTimeSymbols_ar_IQ');
goog.provide('goog.i18n.DateTimeSymbols_ar_JO');
goog.provide('goog.i18n.DateTimeSymbols_ar_KW');
goog.provide('goog.i18n.DateTimeSymbols_ar_LB');
goog.provide('goog.i18n.DateTimeSymbols_ar_LY');
goog.provide('goog.i18n.DateTimeSymbols_ar_MA');
goog.provide('goog.i18n.DateTimeSymbols_ar_OM');
goog.provide('goog.i18n.DateTimeSymbols_ar_QA');
goog.provide('goog.i18n.DateTimeSymbols_ar_SA');
goog.provide('goog.i18n.DateTimeSymbols_ar_SD');
goog.provide('goog.i18n.DateTimeSymbols_ar_SY');
goog.provide('goog.i18n.DateTimeSymbols_ar_TN');
goog.provide('goog.i18n.DateTimeSymbols_ar_YE');
goog.provide('goog.i18n.DateTimeSymbols_as');
goog.provide('goog.i18n.DateTimeSymbols_as_IN');
goog.provide('goog.i18n.DateTimeSymbols_az');
goog.provide('goog.i18n.DateTimeSymbols_az_AZ');
goog.provide('goog.i18n.DateTimeSymbols_az_Arab');
goog.provide('goog.i18n.DateTimeSymbols_az_Arab_IR');
goog.provide('goog.i18n.DateTimeSymbols_az_Cyrl');
goog.provide('goog.i18n.DateTimeSymbols_az_Cyrl_AZ');
goog.provide('goog.i18n.DateTimeSymbols_az_IR');
goog.provide('goog.i18n.DateTimeSymbols_az_Latn');
goog.provide('goog.i18n.DateTimeSymbols_az_Latn_AZ');
goog.provide('goog.i18n.DateTimeSymbols_be');
goog.provide('goog.i18n.DateTimeSymbols_be_BY');
goog.provide('goog.i18n.DateTimeSymbols_bg_BG');
goog.provide('goog.i18n.DateTimeSymbols_bn_BD');
goog.provide('goog.i18n.DateTimeSymbols_bn_IN');
goog.provide('goog.i18n.DateTimeSymbols_bo');
goog.provide('goog.i18n.DateTimeSymbols_bo_CN');
goog.provide('goog.i18n.DateTimeSymbols_bo_IN');
goog.provide('goog.i18n.DateTimeSymbols_bs');
goog.provide('goog.i18n.DateTimeSymbols_bs_BA');
goog.provide('goog.i18n.DateTimeSymbols_byn');
goog.provide('goog.i18n.DateTimeSymbols_byn_ER');
goog.provide('goog.i18n.DateTimeSymbols_ca_ES');
goog.provide('goog.i18n.DateTimeSymbols_cch');
goog.provide('goog.i18n.DateTimeSymbols_cch_NG');
goog.provide('goog.i18n.DateTimeSymbols_cs_CZ');
goog.provide('goog.i18n.DateTimeSymbols_cy');
goog.provide('goog.i18n.DateTimeSymbols_cy_GB');
goog.provide('goog.i18n.DateTimeSymbols_da_DK');
goog.provide('goog.i18n.DateTimeSymbols_de_BE');
goog.provide('goog.i18n.DateTimeSymbols_de_DE');
goog.provide('goog.i18n.DateTimeSymbols_de_LI');
goog.provide('goog.i18n.DateTimeSymbols_de_LU');
goog.provide('goog.i18n.DateTimeSymbols_dv');
goog.provide('goog.i18n.DateTimeSymbols_dv_MV');
goog.provide('goog.i18n.DateTimeSymbols_dz');
goog.provide('goog.i18n.DateTimeSymbols_dz_BT');
goog.provide('goog.i18n.DateTimeSymbols_ee');
goog.provide('goog.i18n.DateTimeSymbols_ee_GH');
goog.provide('goog.i18n.DateTimeSymbols_ee_TG');
goog.provide('goog.i18n.DateTimeSymbols_el_CY');
goog.provide('goog.i18n.DateTimeSymbols_el_GR');
goog.provide('goog.i18n.DateTimeSymbols_el_POLYTON');
goog.provide('goog.i18n.DateTimeSymbols_en_AS');
goog.provide('goog.i18n.DateTimeSymbols_en_BE');
goog.provide('goog.i18n.DateTimeSymbols_en_BW');
goog.provide('goog.i18n.DateTimeSymbols_en_BZ');
goog.provide('goog.i18n.DateTimeSymbols_en_CA');
goog.provide('goog.i18n.DateTimeSymbols_en_Dsrt');
goog.provide('goog.i18n.DateTimeSymbols_en_Dsrt_US');
goog.provide('goog.i18n.DateTimeSymbols_en_GU');
goog.provide('goog.i18n.DateTimeSymbols_en_HK');
goog.provide('goog.i18n.DateTimeSymbols_en_JM');
goog.provide('goog.i18n.DateTimeSymbols_en_MH');
goog.provide('goog.i18n.DateTimeSymbols_en_MP');
goog.provide('goog.i18n.DateTimeSymbols_en_MT');
goog.provide('goog.i18n.DateTimeSymbols_en_NA');
goog.provide('goog.i18n.DateTimeSymbols_en_NZ');
goog.provide('goog.i18n.DateTimeSymbols_en_PH');
goog.provide('goog.i18n.DateTimeSymbols_en_PK');
goog.provide('goog.i18n.DateTimeSymbols_en_Shaw');
goog.provide('goog.i18n.DateTimeSymbols_en_TT');
goog.provide('goog.i18n.DateTimeSymbols_en_UM');
goog.provide('goog.i18n.DateTimeSymbols_en_VI');
goog.provide('goog.i18n.DateTimeSymbols_en_ZW');
goog.provide('goog.i18n.DateTimeSymbols_eo');
goog.provide('goog.i18n.DateTimeSymbols_es_AR');
goog.provide('goog.i18n.DateTimeSymbols_es_BO');
goog.provide('goog.i18n.DateTimeSymbols_es_CL');
goog.provide('goog.i18n.DateTimeSymbols_es_CO');
goog.provide('goog.i18n.DateTimeSymbols_es_CR');
goog.provide('goog.i18n.DateTimeSymbols_es_DO');
goog.provide('goog.i18n.DateTimeSymbols_es_EC');
goog.provide('goog.i18n.DateTimeSymbols_es_ES');
goog.provide('goog.i18n.DateTimeSymbols_es_GT');
goog.provide('goog.i18n.DateTimeSymbols_es_HN');
goog.provide('goog.i18n.DateTimeSymbols_es_MX');
goog.provide('goog.i18n.DateTimeSymbols_es_NI');
goog.provide('goog.i18n.DateTimeSymbols_es_PA');
goog.provide('goog.i18n.DateTimeSymbols_es_PE');
goog.provide('goog.i18n.DateTimeSymbols_es_PR');
goog.provide('goog.i18n.DateTimeSymbols_es_PY');
goog.provide('goog.i18n.DateTimeSymbols_es_SV');
goog.provide('goog.i18n.DateTimeSymbols_es_US');
goog.provide('goog.i18n.DateTimeSymbols_es_UY');
goog.provide('goog.i18n.DateTimeSymbols_es_VE');
goog.provide('goog.i18n.DateTimeSymbols_et_EE');
goog.provide('goog.i18n.DateTimeSymbols_eu_ES');
goog.provide('goog.i18n.DateTimeSymbols_fa_AF');
goog.provide('goog.i18n.DateTimeSymbols_fa_IR');
goog.provide('goog.i18n.DateTimeSymbols_fi_FI');
goog.provide('goog.i18n.DateTimeSymbols_fil_PH');
goog.provide('goog.i18n.DateTimeSymbols_fo');
goog.provide('goog.i18n.DateTimeSymbols_fo_FO');
goog.provide('goog.i18n.DateTimeSymbols_fr_BE');
goog.provide('goog.i18n.DateTimeSymbols_fr_CH');
goog.provide('goog.i18n.DateTimeSymbols_fr_FR');
goog.provide('goog.i18n.DateTimeSymbols_fr_LU');
goog.provide('goog.i18n.DateTimeSymbols_fr_MC');
goog.provide('goog.i18n.DateTimeSymbols_fr_SN');
goog.provide('goog.i18n.DateTimeSymbols_fur');
goog.provide('goog.i18n.DateTimeSymbols_fur_IT');
goog.provide('goog.i18n.DateTimeSymbols_ga');
goog.provide('goog.i18n.DateTimeSymbols_ga_IE');
goog.provide('goog.i18n.DateTimeSymbols_gaa');
goog.provide('goog.i18n.DateTimeSymbols_gaa_GH');
goog.provide('goog.i18n.DateTimeSymbols_gez');
goog.provide('goog.i18n.DateTimeSymbols_gez_ER');
goog.provide('goog.i18n.DateTimeSymbols_gez_ET');
goog.provide('goog.i18n.DateTimeSymbols_gl_ES');
goog.provide('goog.i18n.DateTimeSymbols_gsw_CH');
goog.provide('goog.i18n.DateTimeSymbols_gu_IN');
goog.provide('goog.i18n.DateTimeSymbols_gv');
goog.provide('goog.i18n.DateTimeSymbols_gv_GB');
goog.provide('goog.i18n.DateTimeSymbols_ha');
goog.provide('goog.i18n.DateTimeSymbols_ha_Arab');
goog.provide('goog.i18n.DateTimeSymbols_ha_Arab_NG');
goog.provide('goog.i18n.DateTimeSymbols_ha_Arab_SD');
goog.provide('goog.i18n.DateTimeSymbols_ha_GH');
goog.provide('goog.i18n.DateTimeSymbols_ha_Latn');
goog.provide('goog.i18n.DateTimeSymbols_ha_Latn_GH');
goog.provide('goog.i18n.DateTimeSymbols_ha_Latn_NE');
goog.provide('goog.i18n.DateTimeSymbols_ha_Latn_NG');
goog.provide('goog.i18n.DateTimeSymbols_ha_NE');
goog.provide('goog.i18n.DateTimeSymbols_ha_NG');
goog.provide('goog.i18n.DateTimeSymbols_ha_SD');
goog.provide('goog.i18n.DateTimeSymbols_haw');
goog.provide('goog.i18n.DateTimeSymbols_haw_US');
goog.provide('goog.i18n.DateTimeSymbols_he_IL');
goog.provide('goog.i18n.DateTimeSymbols_hi_IN');
goog.provide('goog.i18n.DateTimeSymbols_hr_HR');
goog.provide('goog.i18n.DateTimeSymbols_hu_HU');
goog.provide('goog.i18n.DateTimeSymbols_hy');
goog.provide('goog.i18n.DateTimeSymbols_hy_AM');
goog.provide('goog.i18n.DateTimeSymbols_ia');
goog.provide('goog.i18n.DateTimeSymbols_id_ID');
goog.provide('goog.i18n.DateTimeSymbols_ig');
goog.provide('goog.i18n.DateTimeSymbols_ig_NG');
goog.provide('goog.i18n.DateTimeSymbols_ii');
goog.provide('goog.i18n.DateTimeSymbols_ii_CN');
goog.provide('goog.i18n.DateTimeSymbols_is_IS');
goog.provide('goog.i18n.DateTimeSymbols_it_CH');
goog.provide('goog.i18n.DateTimeSymbols_it_IT');
goog.provide('goog.i18n.DateTimeSymbols_iu');
goog.provide('goog.i18n.DateTimeSymbols_ja_JP');
goog.provide('goog.i18n.DateTimeSymbols_ka');
goog.provide('goog.i18n.DateTimeSymbols_ka_GE');
goog.provide('goog.i18n.DateTimeSymbols_kaj');
goog.provide('goog.i18n.DateTimeSymbols_kaj_NG');
goog.provide('goog.i18n.DateTimeSymbols_kam');
goog.provide('goog.i18n.DateTimeSymbols_kam_KE');
goog.provide('goog.i18n.DateTimeSymbols_kcg');
goog.provide('goog.i18n.DateTimeSymbols_kcg_NG');
goog.provide('goog.i18n.DateTimeSymbols_kfo');
goog.provide('goog.i18n.DateTimeSymbols_kfo_CI');
goog.provide('goog.i18n.DateTimeSymbols_kk');
goog.provide('goog.i18n.DateTimeSymbols_kk_Cyrl');
goog.provide('goog.i18n.DateTimeSymbols_kk_Cyrl_KZ');
goog.provide('goog.i18n.DateTimeSymbols_kk_KZ');
goog.provide('goog.i18n.DateTimeSymbols_kl');
goog.provide('goog.i18n.DateTimeSymbols_kl_GL');
goog.provide('goog.i18n.DateTimeSymbols_km');
goog.provide('goog.i18n.DateTimeSymbols_km_KH');
goog.provide('goog.i18n.DateTimeSymbols_kn_IN');
goog.provide('goog.i18n.DateTimeSymbols_ko_KR');
goog.provide('goog.i18n.DateTimeSymbols_kok');
goog.provide('goog.i18n.DateTimeSymbols_kok_IN');
goog.provide('goog.i18n.DateTimeSymbols_kpe');
goog.provide('goog.i18n.DateTimeSymbols_kpe_GN');
goog.provide('goog.i18n.DateTimeSymbols_kpe_LR');
goog.provide('goog.i18n.DateTimeSymbols_ku');
goog.provide('goog.i18n.DateTimeSymbols_ku_Arab');
goog.provide('goog.i18n.DateTimeSymbols_ku_Arab_IQ');
goog.provide('goog.i18n.DateTimeSymbols_ku_Arab_IR');
goog.provide('goog.i18n.DateTimeSymbols_ku_IQ');
goog.provide('goog.i18n.DateTimeSymbols_ku_IR');
goog.provide('goog.i18n.DateTimeSymbols_ku_Latn');
goog.provide('goog.i18n.DateTimeSymbols_ku_Latn_SY');
goog.provide('goog.i18n.DateTimeSymbols_ku_Latn_TR');
goog.provide('goog.i18n.DateTimeSymbols_ku_SY');
goog.provide('goog.i18n.DateTimeSymbols_ku_TR');
goog.provide('goog.i18n.DateTimeSymbols_kw');
goog.provide('goog.i18n.DateTimeSymbols_kw_GB');
goog.provide('goog.i18n.DateTimeSymbols_ky');
goog.provide('goog.i18n.DateTimeSymbols_ky_KG');
goog.provide('goog.i18n.DateTimeSymbols_ln_CD');
goog.provide('goog.i18n.DateTimeSymbols_ln_CG');
goog.provide('goog.i18n.DateTimeSymbols_lo');
goog.provide('goog.i18n.DateTimeSymbols_lo_LA');
goog.provide('goog.i18n.DateTimeSymbols_lt_LT');
goog.provide('goog.i18n.DateTimeSymbols_lv_LV');
goog.provide('goog.i18n.DateTimeSymbols_mk');
goog.provide('goog.i18n.DateTimeSymbols_mk_MK');
goog.provide('goog.i18n.DateTimeSymbols_ml_IN');
goog.provide('goog.i18n.DateTimeSymbols_mn');
goog.provide('goog.i18n.DateTimeSymbols_mn_CN');
goog.provide('goog.i18n.DateTimeSymbols_mn_Cyrl');
goog.provide('goog.i18n.DateTimeSymbols_mn_Cyrl_MN');
goog.provide('goog.i18n.DateTimeSymbols_mn_MN');
goog.provide('goog.i18n.DateTimeSymbols_mn_Mong');
goog.provide('goog.i18n.DateTimeSymbols_mn_Mong_CN');
goog.provide('goog.i18n.DateTimeSymbols_mr_IN');
goog.provide('goog.i18n.DateTimeSymbols_ms_BN');
goog.provide('goog.i18n.DateTimeSymbols_ms_MY');
goog.provide('goog.i18n.DateTimeSymbols_mt_MT');
goog.provide('goog.i18n.DateTimeSymbols_my');
goog.provide('goog.i18n.DateTimeSymbols_my_MM');
goog.provide('goog.i18n.DateTimeSymbols_nb');
goog.provide('goog.i18n.DateTimeSymbols_nb_NO');
goog.provide('goog.i18n.DateTimeSymbols_nds');
goog.provide('goog.i18n.DateTimeSymbols_nds_DE');
goog.provide('goog.i18n.DateTimeSymbols_ne');
goog.provide('goog.i18n.DateTimeSymbols_ne_IN');
goog.provide('goog.i18n.DateTimeSymbols_ne_NP');
goog.provide('goog.i18n.DateTimeSymbols_nl_BE');
goog.provide('goog.i18n.DateTimeSymbols_nl_NL');
goog.provide('goog.i18n.DateTimeSymbols_nn');
goog.provide('goog.i18n.DateTimeSymbols_nn_NO');
goog.provide('goog.i18n.DateTimeSymbols_nr');
goog.provide('goog.i18n.DateTimeSymbols_nr_ZA');
goog.provide('goog.i18n.DateTimeSymbols_nso');
goog.provide('goog.i18n.DateTimeSymbols_nso_ZA');
goog.provide('goog.i18n.DateTimeSymbols_ny');
goog.provide('goog.i18n.DateTimeSymbols_ny_MW');
goog.provide('goog.i18n.DateTimeSymbols_oc');
goog.provide('goog.i18n.DateTimeSymbols_oc_FR');
goog.provide('goog.i18n.DateTimeSymbols_om');
goog.provide('goog.i18n.DateTimeSymbols_om_ET');
goog.provide('goog.i18n.DateTimeSymbols_om_KE');
goog.provide('goog.i18n.DateTimeSymbols_or_IN');
goog.provide('goog.i18n.DateTimeSymbols_pa');
goog.provide('goog.i18n.DateTimeSymbols_pa_Arab');
goog.provide('goog.i18n.DateTimeSymbols_pa_Arab_PK');
goog.provide('goog.i18n.DateTimeSymbols_pa_Guru');
goog.provide('goog.i18n.DateTimeSymbols_pa_Guru_IN');
goog.provide('goog.i18n.DateTimeSymbols_pa_IN');
goog.provide('goog.i18n.DateTimeSymbols_pa_PK');
goog.provide('goog.i18n.DateTimeSymbols_pl_PL');
goog.provide('goog.i18n.DateTimeSymbols_ps');
goog.provide('goog.i18n.DateTimeSymbols_ps_AF');
goog.provide('goog.i18n.DateTimeSymbols_ro_MD');
goog.provide('goog.i18n.DateTimeSymbols_ro_RO');
goog.provide('goog.i18n.DateTimeSymbols_ru_RU');
goog.provide('goog.i18n.DateTimeSymbols_ru_UA');
goog.provide('goog.i18n.DateTimeSymbols_rw');
goog.provide('goog.i18n.DateTimeSymbols_rw_RW');
goog.provide('goog.i18n.DateTimeSymbols_sa');
goog.provide('goog.i18n.DateTimeSymbols_sa_IN');
goog.provide('goog.i18n.DateTimeSymbols_se');
goog.provide('goog.i18n.DateTimeSymbols_se_FI');
goog.provide('goog.i18n.DateTimeSymbols_se_NO');
goog.provide('goog.i18n.DateTimeSymbols_sh');
goog.provide('goog.i18n.DateTimeSymbols_sh_BA');
goog.provide('goog.i18n.DateTimeSymbols_sh_CS');
goog.provide('goog.i18n.DateTimeSymbols_sh_YU');
goog.provide('goog.i18n.DateTimeSymbols_si');
goog.provide('goog.i18n.DateTimeSymbols_si_LK');
goog.provide('goog.i18n.DateTimeSymbols_sid');
goog.provide('goog.i18n.DateTimeSymbols_sid_ET');
goog.provide('goog.i18n.DateTimeSymbols_sk_SK');
goog.provide('goog.i18n.DateTimeSymbols_sl_SI');
goog.provide('goog.i18n.DateTimeSymbols_so');
goog.provide('goog.i18n.DateTimeSymbols_so_DJ');
goog.provide('goog.i18n.DateTimeSymbols_so_ET');
goog.provide('goog.i18n.DateTimeSymbols_so_KE');
goog.provide('goog.i18n.DateTimeSymbols_so_SO');
goog.provide('goog.i18n.DateTimeSymbols_sq_AL');
goog.provide('goog.i18n.DateTimeSymbols_sr_BA');
goog.provide('goog.i18n.DateTimeSymbols_sr_CS');
goog.provide('goog.i18n.DateTimeSymbols_sr_Cyrl');
goog.provide('goog.i18n.DateTimeSymbols_sr_Cyrl_BA');
goog.provide('goog.i18n.DateTimeSymbols_sr_Cyrl_CS');
goog.provide('goog.i18n.DateTimeSymbols_sr_Cyrl_ME');
goog.provide('goog.i18n.DateTimeSymbols_sr_Cyrl_RS');
goog.provide('goog.i18n.DateTimeSymbols_sr_Cyrl_YU');
goog.provide('goog.i18n.DateTimeSymbols_sr_Latn');
goog.provide('goog.i18n.DateTimeSymbols_sr_Latn_BA');
goog.provide('goog.i18n.DateTimeSymbols_sr_Latn_CS');
goog.provide('goog.i18n.DateTimeSymbols_sr_Latn_ME');
goog.provide('goog.i18n.DateTimeSymbols_sr_Latn_RS');
goog.provide('goog.i18n.DateTimeSymbols_sr_Latn_YU');
goog.provide('goog.i18n.DateTimeSymbols_sr_ME');
goog.provide('goog.i18n.DateTimeSymbols_sr_RS');
goog.provide('goog.i18n.DateTimeSymbols_sr_YU');
goog.provide('goog.i18n.DateTimeSymbols_ss');
goog.provide('goog.i18n.DateTimeSymbols_ss_SZ');
goog.provide('goog.i18n.DateTimeSymbols_ss_ZA');
goog.provide('goog.i18n.DateTimeSymbols_st');
goog.provide('goog.i18n.DateTimeSymbols_st_LS');
goog.provide('goog.i18n.DateTimeSymbols_st_ZA');
goog.provide('goog.i18n.DateTimeSymbols_sv_FI');
goog.provide('goog.i18n.DateTimeSymbols_sv_SE');
goog.provide('goog.i18n.DateTimeSymbols_sw_KE');
goog.provide('goog.i18n.DateTimeSymbols_sw_TZ');
goog.provide('goog.i18n.DateTimeSymbols_syr');
goog.provide('goog.i18n.DateTimeSymbols_syr_SY');
goog.provide('goog.i18n.DateTimeSymbols_ta_IN');
goog.provide('goog.i18n.DateTimeSymbols_te_IN');
goog.provide('goog.i18n.DateTimeSymbols_tg');
goog.provide('goog.i18n.DateTimeSymbols_tg_Cyrl');
goog.provide('goog.i18n.DateTimeSymbols_tg_Cyrl_TJ');
goog.provide('goog.i18n.DateTimeSymbols_tg_TJ');
goog.provide('goog.i18n.DateTimeSymbols_th_TH');
goog.provide('goog.i18n.DateTimeSymbols_ti');
goog.provide('goog.i18n.DateTimeSymbols_ti_ER');
goog.provide('goog.i18n.DateTimeSymbols_ti_ET');
goog.provide('goog.i18n.DateTimeSymbols_tig');
goog.provide('goog.i18n.DateTimeSymbols_tig_ER');
goog.provide('goog.i18n.DateTimeSymbols_tl_PH');
goog.provide('goog.i18n.DateTimeSymbols_tn');
goog.provide('goog.i18n.DateTimeSymbols_tn_ZA');
goog.provide('goog.i18n.DateTimeSymbols_to');
goog.provide('goog.i18n.DateTimeSymbols_to_TO');
goog.provide('goog.i18n.DateTimeSymbols_tr_TR');
goog.provide('goog.i18n.DateTimeSymbols_trv');
goog.provide('goog.i18n.DateTimeSymbols_trv_TW');
goog.provide('goog.i18n.DateTimeSymbols_ts');
goog.provide('goog.i18n.DateTimeSymbols_ts_ZA');
goog.provide('goog.i18n.DateTimeSymbols_tt');
goog.provide('goog.i18n.DateTimeSymbols_tt_RU');
goog.provide('goog.i18n.DateTimeSymbols_ug');
goog.provide('goog.i18n.DateTimeSymbols_ug_Arab');
goog.provide('goog.i18n.DateTimeSymbols_ug_Arab_CN');
goog.provide('goog.i18n.DateTimeSymbols_ug_CN');
goog.provide('goog.i18n.DateTimeSymbols_uk_UA');
goog.provide('goog.i18n.DateTimeSymbols_ur_IN');
goog.provide('goog.i18n.DateTimeSymbols_ur_PK');
goog.provide('goog.i18n.DateTimeSymbols_uz');
goog.provide('goog.i18n.DateTimeSymbols_uz_AF');
goog.provide('goog.i18n.DateTimeSymbols_uz_Arab');
goog.provide('goog.i18n.DateTimeSymbols_uz_Arab_AF');
goog.provide('goog.i18n.DateTimeSymbols_uz_Cyrl');
goog.provide('goog.i18n.DateTimeSymbols_uz_Cyrl_UZ');
goog.provide('goog.i18n.DateTimeSymbols_uz_Latn');
goog.provide('goog.i18n.DateTimeSymbols_uz_Latn_UZ');
goog.provide('goog.i18n.DateTimeSymbols_uz_UZ');
goog.provide('goog.i18n.DateTimeSymbols_ve');
goog.provide('goog.i18n.DateTimeSymbols_ve_ZA');
goog.provide('goog.i18n.DateTimeSymbols_vi_VN');
goog.provide('goog.i18n.DateTimeSymbols_wal');
goog.provide('goog.i18n.DateTimeSymbols_wal_ET');
goog.provide('goog.i18n.DateTimeSymbols_wo');
goog.provide('goog.i18n.DateTimeSymbols_wo_Latn');
goog.provide('goog.i18n.DateTimeSymbols_wo_Latn_SN');
goog.provide('goog.i18n.DateTimeSymbols_wo_SN');
goog.provide('goog.i18n.DateTimeSymbols_xh');
goog.provide('goog.i18n.DateTimeSymbols_xh_ZA');
goog.provide('goog.i18n.DateTimeSymbols_yo');
goog.provide('goog.i18n.DateTimeSymbols_yo_NG');
goog.provide('goog.i18n.DateTimeSymbols_zh_Hans');
goog.provide('goog.i18n.DateTimeSymbols_zh_Hans_CN');
goog.provide('goog.i18n.DateTimeSymbols_zh_Hans_HK');
goog.provide('goog.i18n.DateTimeSymbols_zh_Hans_MO');
goog.provide('goog.i18n.DateTimeSymbols_zh_Hans_SG');
goog.provide('goog.i18n.DateTimeSymbols_zh_Hant');
goog.provide('goog.i18n.DateTimeSymbols_zh_Hant_HK');
goog.provide('goog.i18n.DateTimeSymbols_zh_Hant_MO');
goog.provide('goog.i18n.DateTimeSymbols_zh_Hant_TW');
goog.provide('goog.i18n.DateTimeSymbols_zh_MO');
goog.provide('goog.i18n.DateTimeSymbols_zh_SG');
goog.provide('goog.i18n.DateTimeSymbols_zu');
goog.provide('goog.i18n.DateTimeSymbols_zu_ZA');

goog.require('goog.i18n.DateTimeSymbols');

/**
 * Date/time formatting symbols for locale aa.
 */
goog.i18n.DateTimeSymbols_aa = {
  ERAS: ['Yaasuusuk Duma', 'Yaasuusuk Wadir'],
  ERANAMES: ['Yaasuusuk Duma', 'Yaasuusuk Wadir'],
  NARROWMONTHS: ['Q', 'N', 'C', 'A', 'C', 'Q', 'Q', 'L', 'W', 'D', 'X', 'K'],
  STANDALONENARROWMONTHS: ['Q', 'N', 'C', 'A', 'C', 'Q', 'Q', 'L', 'W', 'D',
      'X', 'K'],
  MONTHS: ['Qunxa Garablu', 'Kudo', 'Ciggilta Kudo', 'Agda Baxis', 'Caxah Alsa',
      'Qasa Dirri', 'Qado Dirri', 'Liiqen', 'Waysu', 'Diteli', 'Ximoli',
      'Kaxxa Garablu'],
  STANDALONEMONTHS: ['Qunxa Garablu', 'Kudo', 'Ciggilta Kudo', 'Agda Baxis',
      'Caxah Alsa', 'Qasa Dirri', 'Qado Dirri', 'Liiqen', 'Waysu', 'Diteli',
      'Ximoli', 'Kaxxa Garablu'],
  SHORTMONTHS: ['Qun', 'Nah', 'Cig', 'Agd', 'Cax', 'Qas', 'Qad', 'Leq', 'Way',
      'Dit', 'Xim', 'Kax'],
  STANDALONESHORTMONTHS: ['Qun', 'Nah', 'Cig', 'Agd', 'Cax', 'Qas', 'Qad',
      'Leq', 'Way', 'Dit', 'Xim', 'Kax'],
  WEEKDAYS: ['Acaada', 'Etleeni', 'Talaata', 'Arbaqa', 'Kamiisi', 'Gumqata',
      'Sabti'],
  STANDALONEWEEKDAYS: ['Acaada', 'Etleeni', 'Talaata', 'Arbaqa', 'Kamiisi',
      'Gumqata', 'Sabti'],
  SHORTWEEKDAYS: ['Aca', 'Etl', 'Tal', 'Arb', 'Kam', 'Gum', 'Sab'],
  STANDALONESHORTWEEKDAYS: ['Aca', 'Etl', 'Tal', 'Arb', 'Kam', 'Gum', 'Sab'],
  NARROWWEEKDAYS: ['A', 'E', 'T', 'A', 'K', 'G', 'S'],
  STANDALONENARROWWEEKDAYS: ['A', 'E', 'T', 'A', 'K', 'G', 'S'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['saaku', 'carra'],
  DATEFORMATS: ['EEEE, MMMM dd, y', 'dd MMMM y', 'dd-MMM-y', 'dd/MM/yy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale aa_DJ.
 */
goog.i18n.DateTimeSymbols_aa_DJ = {
  ERAS: ['Yaasuusuk Duma', 'Yaasuusuk Wadir'],
  ERANAMES: ['Yaasuusuk Duma', 'Yaasuusuk Wadir'],
  NARROWMONTHS: ['Q', 'N', 'C', 'A', 'C', 'Q', 'Q', 'L', 'W', 'D', 'X', 'K'],
  STANDALONENARROWMONTHS: ['Q', 'N', 'C', 'A', 'C', 'Q', 'Q', 'L', 'W', 'D',
      'X', 'K'],
  MONTHS: ['Qunxa Garablu', 'Naharsi Kudo', 'Ciggilta Kudo', 'Agda Baxisso',
      'Caxah Alsa', 'Qasa Dirri', 'Qado Dirri', 'Leqeeni', 'Waysu', 'Diteli',
      'Ximoli', 'Kaxxa Garablu'],
  STANDALONEMONTHS: ['Qunxa Garablu', 'Naharsi Kudo', 'Ciggilta Kudo',
      'Agda Baxisso', 'Caxah Alsa', 'Qasa Dirri', 'Qado Dirri', 'Leqeeni',
      'Waysu', 'Diteli', 'Ximoli', 'Kaxxa Garablu'],
  SHORTMONTHS: ['Qun', 'Nah', 'Cig', 'Agd', 'Cax', 'Qas', 'Qad', 'Leq', 'Way',
      'Dit', 'Xim', 'Kax'],
  STANDALONESHORTMONTHS: ['Qun', 'Nah', 'Cig', 'Agd', 'Cax', 'Qas', 'Qad',
      'Leq', 'Way', 'Dit', 'Xim', 'Kax'],
  WEEKDAYS: ['Acaada', 'Etleeni', 'Talaata', 'Arbaqa', 'Kamiisi', 'Gumqata',
      'Sabti'],
  STANDALONEWEEKDAYS: ['Acaada', 'Etleeni', 'Talaata', 'Arbaqa', 'Kamiisi',
      'Gumqata', 'Sabti'],
  SHORTWEEKDAYS: ['Aca', 'Etl', 'Tal', 'Arb', 'Kam', 'Gum', 'Sab'],
  STANDALONESHORTWEEKDAYS: ['Aca', 'Etl', 'Tal', 'Arb', 'Kam', 'Gum', 'Sab'],
  NARROWWEEKDAYS: ['A', 'E', 'T', 'A', 'K', 'G', 'S'],
  STANDALONENARROWWEEKDAYS: ['A', 'E', 'T', 'A', 'K', 'G', 'S'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['saaku', 'carra'],
  DATEFORMATS: ['EEEE, MMMM dd, y', 'dd MMMM y', 'dd-MMM-y', 'dd/MM/yy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 5,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 1
};


/**
 * Date/time formatting symbols for locale aa_ER.
 */
goog.i18n.DateTimeSymbols_aa_ER = goog.i18n.DateTimeSymbols_aa;


/**
 * Date/time formatting symbols for locale aa_ET.
 */
goog.i18n.DateTimeSymbols_aa_ET = goog.i18n.DateTimeSymbols_aa;


/**
 * Date/time formatting symbols for locale af.
 */
goog.i18n.DateTimeSymbols_af = {
  ERAS: ['v.C.', 'n.C.'],
  ERANAMES: ['voor Christus', 'na Christus'],
  NARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['Januarie', 'Februarie', 'Maart', 'April', 'Mei', 'Junie', 'Julie',
      'Augustus', 'September', 'Oktober', 'November', 'Desember'],
  STANDALONEMONTHS: ['Januarie', 'Februarie', 'Maart', 'April', 'Mei', 'Junie',
      'Julie', 'Augustus', 'September', 'Oktober', 'November', 'Desember'],
  SHORTMONTHS: ['Jan', 'Feb', 'Mar', 'Apr', 'Mei', 'Jun', 'Jul', 'Aug', 'Sep',
      'Okt', 'Nov', 'Des'],
  STANDALONESHORTMONTHS: ['Jan', 'Feb', 'Mar', 'Apr', 'Mei', 'Jun', 'Jul',
      'Aug', 'Sep', 'Okt', 'Nov', 'Des'],
  WEEKDAYS: ['Sondag', 'Maandag', 'Dinsdag', 'Woensdag', 'Donderdag', 'Vrydag',
      'Saterdag'],
  STANDALONEWEEKDAYS: ['Sondag', 'Maandag', 'Dinsdag', 'Woensdag', 'Donderdag',
      'Vrydag', 'Saterdag'],
  SHORTWEEKDAYS: ['So', 'Ma', 'Di', 'Wo', 'Do', 'Vr', 'Sa'],
  STANDALONESHORTWEEKDAYS: ['So', 'Ma', 'Di', 'Wo', 'Do', 'Vr', 'Sa'],
  NARROWWEEKDAYS: ['S', 'M', 'D', 'W', 'D', 'V', 'S'],
  STANDALONENARROWWEEKDAYS: ['S', 'M', 'D', 'W', 'D', 'V', 'S'],
  SHORTQUARTERS: ['K1', 'K2', 'K3', 'K4'],
  QUARTERS: ['1ste kwartaal', '2de kwartaal', '3de kwartaal', '4de kwartaal'],
  AMPMS: ['vm.', 'nm.'],
  DATEFORMATS: ['EEEE dd MMMM y', 'dd MMMM y', 'dd MMM y', 'yyyy-MM-dd'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale af_NA.
 */
goog.i18n.DateTimeSymbols_af_NA = {
  ERAS: ['v.C.', 'n.C.'],
  ERANAMES: ['voor Christus', 'na Christus'],
  NARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['Januarie', 'Februarie', 'Maart', 'April', 'Mei', 'Junie', 'Julie',
      'Augustus', 'September', 'Oktober', 'November', 'Desember'],
  STANDALONEMONTHS: ['Januarie', 'Februarie', 'Maart', 'April', 'Mei', 'Junie',
      'Julie', 'Augustus', 'September', 'Oktober', 'November', 'Desember'],
  SHORTMONTHS: ['Jan', 'Feb', 'Mar', 'Apr', 'Mei', 'Jun', 'Jul', 'Aug', 'Sep',
      'Okt', 'Nov', 'Des'],
  STANDALONESHORTMONTHS: ['Jan', 'Feb', 'Mar', 'Apr', 'Mei', 'Jun', 'Jul',
      'Aug', 'Sep', 'Okt', 'Nov', 'Des'],
  WEEKDAYS: ['Sondag', 'Maandag', 'Dinsdag', 'Woensdag', 'Donderdag', 'Vrydag',
      'Saterdag'],
  STANDALONEWEEKDAYS: ['Sondag', 'Maandag', 'Dinsdag', 'Woensdag', 'Donderdag',
      'Vrydag', 'Saterdag'],
  SHORTWEEKDAYS: ['So', 'Ma', 'Di', 'Wo', 'Do', 'Vr', 'Sa'],
  STANDALONESHORTWEEKDAYS: ['So', 'Ma', 'Di', 'Wo', 'Do', 'Vr', 'Sa'],
  NARROWWEEKDAYS: ['S', 'M', 'D', 'W', 'D', 'V', 'S'],
  STANDALONENARROWWEEKDAYS: ['S', 'M', 'D', 'W', 'D', 'V', 'S'],
  SHORTQUARTERS: ['K1', 'K2', 'K3', 'K4'],
  QUARTERS: ['1ste kwartaal', '2de kwartaal', '3de kwartaal', '4de kwartaal'],
  AMPMS: ['vm.', 'nm.'],
  DATEFORMATS: ['EEEE d MMMM y', 'd MMMM y', 'd MMM y', 'yyyy-MM-dd'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale af_ZA.
 */
goog.i18n.DateTimeSymbols_af_ZA = goog.i18n.DateTimeSymbols_af;


/**
 * Date/time formatting symbols for locale ak.
 */
goog.i18n.DateTimeSymbols_ak = {
  ERAS: ['AK', 'KE'],
  ERANAMES: ['Ansa Kristo', 'Kristo Ekyiri'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['Sanda-Ɔpɛpɔn', 'Kwakwar-Ɔgyefuo', 'Ebɔw-Ɔbenem',
      'Ebɔbira-Oforisuo', 'Esusow Aketseaba-Kɔtɔnimba',
      'Obirade-Ayɛwohomumu', 'Ayɛwoho-Kitawonsa', 'Difuu-Ɔsandaa',
      'Fankwa-Ɛbɔ', 'Ɔbɛsɛ-Ahinime', 'Ɔberɛfɛw-Obubuo',
      'Mumu-Ɔpɛnimba'],
  STANDALONEMONTHS: ['Sanda-Ɔpɛpɔn', 'Kwakwar-Ɔgyefuo', 'Ebɔw-Ɔbenem',
      'Ebɔbira-Oforisuo', 'Esusow Aketseaba-Kɔtɔnimba',
      'Obirade-Ayɛwohomumu', 'Ayɛwoho-Kitawonsa', 'Difuu-Ɔsandaa',
      'Fankwa-Ɛbɔ', 'Ɔbɛsɛ-Ahinime', 'Ɔberɛfɛw-Obubuo',
      'Mumu-Ɔpɛnimba'],
  SHORTMONTHS: ['S-Ɔ', 'K-Ɔ', 'E-Ɔ', 'E-O', 'E-K', 'O-A', 'A-K', 'D-Ɔ',
      'F-Ɛ', 'Ɔ-A', 'Ɔ-O', 'M-Ɔ'],
  STANDALONESHORTMONTHS: ['S-Ɔ', 'K-Ɔ', 'E-Ɔ', 'E-O', 'E-K', 'O-A', 'A-K',
      'D-Ɔ', 'F-Ɛ', 'Ɔ-A', 'Ɔ-O', 'M-Ɔ'],
  WEEKDAYS: ['Kwesida', 'Dwowda', 'Benada', 'Wukuda', 'Yawda', 'Fida',
      'Memeneda'],
  STANDALONEWEEKDAYS: ['Kwesida', 'Dwowda', 'Benada', 'Wukuda', 'Yawda', 'Fida',
      'Memeneda'],
  SHORTWEEKDAYS: ['Kwe', 'Dwo', 'Ben', 'Wuk', 'Yaw', 'Fia', 'Mem'],
  STANDALONESHORTWEEKDAYS: ['Kwe', 'Dwo', 'Ben', 'Wuk', 'Yaw', 'Fia', 'Mem'],
  NARROWWEEKDAYS: ['K', 'D', 'B', 'W', 'Y', 'F', 'M'],
  STANDALONENARROWWEEKDAYS: ['K', 'D', 'B', 'W', 'Y', 'F', 'M'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['AN', 'EW'],
  DATEFORMATS: ['EEEE, y MMMM dd', 'y MMMM d', 'y MMM d', 'yy/MM/dd'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale ak_GH.
 */
goog.i18n.DateTimeSymbols_ak_GH = goog.i18n.DateTimeSymbols_ak;


/**
 * Date/time formatting symbols for locale am_ET.
 */
goog.i18n.DateTimeSymbols_am_ET = {
  ERAS: ['ዓ/ዓ', 'ዓ/ም'],
  ERANAMES: ['ዓመተ ዓለም', 'ዓመተ ምሕረት'],
  NARROWMONTHS: ['ጃ', 'ፌ', 'ማ', 'ኤ', 'ሜ', 'ጁ', 'ጁ', 'ኦ', 'ሴ',
      'ኦ', 'ኖ', 'ዲ'],
  STANDALONENARROWMONTHS: ['ጃ', 'ፌ', 'ማ', 'ኤ', 'ሜ', 'ጁ', 'ጁ',
      'ኦ', 'ሴ', 'ኦ', 'ኖ', 'ዲ'],
  MONTHS: ['ጃንዩወሪ', 'ፌብሩወሪ', 'ማርች', 'ኤፕረል',
      'ሜይ', 'ጁን', 'ጁላይ', 'ኦገስት', 'ሴፕቴምበር',
      'ኦክተውበር', 'ኖቬምበር', 'ዲሴምበር'],
  STANDALONEMONTHS: ['ጃንዩወሪ', 'ፌብሩወሪ', 'ማርች',
      'ኤፕረል', 'ሜይ', 'ጁን', 'ጁላይ', 'ኦገስት',
      'ሴፕቴምበር', 'ኦክተውበር', 'ኖቬምበር',
      'ዲሴምበር'],
  SHORTMONTHS: ['ጃንዩ', 'ፌብሩ', 'ማርች', 'ኤፕረ', 'ሜይ',
      'ጁን', 'ጁላይ', 'ኦገስ', 'ሴፕቴ', 'ኦክተ', 'ኖቬም',
      'ዲሴም'],
  STANDALONESHORTMONTHS: ['ጃንዩ', 'ፌብሩ', 'ማርች', 'ኤፕረ',
      'ሜይ', 'ጁን', 'ጁላይ', 'ኦገስ', 'ሴፕቴ', 'ኦክተ',
      'ኖቬም', 'ዲሴም'],
  WEEKDAYS: ['እሑድ', 'ሰኞ', 'ማክሰኞ', 'ረቡዕ', 'ሐሙስ',
      'ዓርብ', 'ቅዳሜ'],
  STANDALONEWEEKDAYS: ['እሑድ', 'ሰኞ', 'ማክሰኞ', 'ረቡዕ',
      'ሐሙስ', 'ዓርብ', 'ቅዳሜ'],
  SHORTWEEKDAYS: ['እሑድ', 'ሰኞ', 'ማክሰ', 'ረቡዕ', 'ሐሙስ',
      'ዓርብ', 'ቅዳሜ'],
  STANDALONESHORTWEEKDAYS: ['እሑድ', 'ሰኞ', 'ማክሰ', 'ረቡዕ',
      'ሐሙስ', 'ዓርብ', 'ቅዳሜ'],
  NARROWWEEKDAYS: ['እ', 'ሰ', 'ማ', 'ረ', 'ሐ', 'ዓ', 'ቅ'],
  STANDALONENARROWWEEKDAYS: ['እ', 'ሰ', 'ማ', 'ረ', 'ሐ', 'ዓ', 'ቅ'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['ጡዋት', 'ከሳዓት'],
  DATEFORMATS: ['EEEE, d MMMM y', 'd MMMM y', 'd MMM y', 'dd/MM/yyyy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 5,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 1
};


/**
 * Date/time formatting symbols for locale ar_AE.
 */
goog.i18n.DateTimeSymbols_ar_AE = {
  ERAS: ['ق.م', 'م'],
  ERANAMES: ['قبل الميلاد', 'ميلادي'],
  NARROWMONTHS: ['ي', 'ف', 'م', 'أ', 'و', 'ن', 'ل', 'غ', 'س', 'ك',
      'ب', 'د'],
  STANDALONENARROWMONTHS: ['ي', 'ف', 'م', 'أ', 'و', 'ن', 'ل', 'غ', 'س',
      'ك', 'ب', 'د'],
  MONTHS: ['يناير', 'فبراير', 'مارس', 'أبريل', 'مايو',
      'يونيو', 'يوليو', 'أغسطس', 'سبتمبر', 'أكتوبر',
      'نوفمبر', 'ديسمبر'],
  STANDALONEMONTHS: ['يناير', 'فبراير', 'مارس', 'أبريل',
      'مايو', 'يونيو', 'يوليو', 'أغسطس', 'سبتمبر',
      'أكتوبر', 'نوفمبر', 'ديسمبر'],
  SHORTMONTHS: ['يناير', 'فبراير', 'مارس', 'أبريل',
      'مايو', 'يونيو', 'يوليو', 'أغسطس', 'سبتمبر',
      'أكتوبر', 'نوفمبر', 'ديسمبر'],
  STANDALONESHORTMONTHS: ['يناير', 'فبراير', 'مارس',
      'أبريل', 'مايو', 'يونيو', 'يوليو', 'أغسطس',
      'سبتمبر', 'أكتوبر', 'نوفمبر', 'ديسمبر'],
  WEEKDAYS: ['الأحد', 'الإثنين', 'الثلاثاء',
      'الأربعاء', 'الخميس', 'الجمعة', 'السبت'],
  STANDALONEWEEKDAYS: ['الأحد', 'الإثنين', 'الثلاثاء',
      'الأربعاء', 'الخميس', 'الجمعة', 'السبت'],
  SHORTWEEKDAYS: ['أحد', 'إثنين', 'ثلاثاء', 'أربعاء',
      'خميس', 'جمعة', 'سبت'],
  STANDALONESHORTWEEKDAYS: ['أحد', 'إثنين', 'ثلاثاء',
      'أربعاء', 'خميس', 'جمعة', 'سبت'],
  NARROWWEEKDAYS: ['ح', 'ن', 'ث', 'ر', 'خ', 'ج', 'س'],
  STANDALONENARROWWEEKDAYS: ['ح', 'ن', 'ث', 'ر', 'خ', 'ج', 'س'],
  SHORTQUARTERS: ['الربع الأول', 'الربع الثاني',
      'الربع الثالث', 'الربع الرابع'],
  QUARTERS: ['الربع الأول', 'الربع الثاني',
      'الربع الثالث', 'الربع الرابع'],
  AMPMS: ['ص', 'م'],
  DATEFORMATS: ['EEEE، d MMMM، y', 'd MMMM، y', 'dd‏/MM‏/yyyy',
      'd‏/M‏/yyyy'],
  TIMEFORMATS: ['zzzz h:mm:ss a', 'z h:mm:ss a', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [4, 5],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale ar_BH.
 */
goog.i18n.DateTimeSymbols_ar_BH = {
  ERAS: ['ق.م', 'م'],
  ERANAMES: ['قبل الميلاد', 'ميلادي'],
  NARROWMONTHS: ['ي', 'ف', 'م', 'أ', 'و', 'ن', 'ل', 'غ', 'س', 'ك',
      'ب', 'د'],
  STANDALONENARROWMONTHS: ['ي', 'ف', 'م', 'أ', 'و', 'ن', 'ل', 'غ', 'س',
      'ك', 'ب', 'د'],
  MONTHS: ['يناير', 'فبراير', 'مارس', 'أبريل', 'مايو',
      'يونيو', 'يوليو', 'أغسطس', 'سبتمبر', 'أكتوبر',
      'نوفمبر', 'ديسمبر'],
  STANDALONEMONTHS: ['يناير', 'فبراير', 'مارس', 'أبريل',
      'مايو', 'يونيو', 'يوليو', 'أغسطس', 'سبتمبر',
      'أكتوبر', 'نوفمبر', 'ديسمبر'],
  SHORTMONTHS: ['يناير', 'فبراير', 'مارس', 'أبريل',
      'مايو', 'يونيو', 'يوليو', 'أغسطس', 'سبتمبر',
      'أكتوبر', 'نوفمبر', 'ديسمبر'],
  STANDALONESHORTMONTHS: ['يناير', 'فبراير', 'مارس',
      'أبريل', 'مايو', 'يونيو', 'يوليو', 'أغسطس',
      'سبتمبر', 'أكتوبر', 'نوفمبر', 'ديسمبر'],
  WEEKDAYS: ['الأحد', 'الإثنين', 'الثلاثاء',
      'الأربعاء', 'الخميس', 'الجمعة', 'السبت'],
  STANDALONEWEEKDAYS: ['الأحد', 'الإثنين', 'الثلاثاء',
      'الأربعاء', 'الخميس', 'الجمعة', 'السبت'],
  SHORTWEEKDAYS: ['أحد', 'إثنين', 'ثلاثاء', 'أربعاء',
      'خميس', 'جمعة', 'سبت'],
  STANDALONESHORTWEEKDAYS: ['أحد', 'إثنين', 'ثلاثاء',
      'أربعاء', 'خميس', 'جمعة', 'سبت'],
  NARROWWEEKDAYS: ['ح', 'ن', 'ث', 'ر', 'خ', 'ج', 'س'],
  STANDALONENARROWWEEKDAYS: ['ح', 'ن', 'ث', 'ر', 'خ', 'ج', 'س'],
  SHORTQUARTERS: ['الربع الأول', 'الربع الثاني',
      'الربع الثالث', 'الربع الرابع'],
  QUARTERS: ['الربع الأول', 'الربع الثاني',
      'الربع الثالث', 'الربع الرابع'],
  AMPMS: ['ص', 'م'],
  DATEFORMATS: ['EEEE، d MMMM، y', 'd MMMM، y', 'dd‏/MM‏/yyyy',
      'd‏/M‏/yyyy'],
  TIMEFORMATS: ['zzzz h:mm:ss a', 'z h:mm:ss a', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 5,
  WEEKENDRANGE: [4, 5],
  FIRSTWEEKCUTOFFDAY: 1
};


/**
 * Date/time formatting symbols for locale ar_DZ.
 */
goog.i18n.DateTimeSymbols_ar_DZ = {
  ERAS: ['ق.م', 'م'],
  ERANAMES: ['قبل الميلاد', 'ميلادي'],
  NARROWMONTHS: ['ي', 'ف', 'م', 'أ', 'و', 'ن', 'ل', 'غ', 'س', 'ك',
      'ب', 'د'],
  STANDALONENARROWMONTHS: ['ي', 'ف', 'م', 'أ', 'و', 'ن', 'ل', 'غ', 'س',
      'ك', 'ب', 'د'],
  MONTHS: ['يناير', 'فبراير', 'مارس', 'أبريل', 'مايو',
      'يونيو', 'يوليو', 'أغسطس', 'سبتمبر', 'أكتوبر',
      'نوفمبر', 'ديسمبر'],
  STANDALONEMONTHS: ['يناير', 'فبراير', 'مارس', 'أبريل',
      'مايو', 'يونيو', 'يوليو', 'أغسطس', 'سبتمبر',
      'أكتوبر', 'نوفمبر', 'ديسمبر'],
  SHORTMONTHS: ['يناير', 'فبراير', 'مارس', 'أبريل',
      'مايو', 'يونيو', 'يوليو', 'أغسطس', 'سبتمبر',
      'أكتوبر', 'نوفمبر', 'ديسمبر'],
  STANDALONESHORTMONTHS: ['يناير', 'فبراير', 'مارس',
      'أبريل', 'مايو', 'يونيو', 'يوليو', 'أغسطس',
      'سبتمبر', 'أكتوبر', 'نوفمبر', 'ديسمبر'],
  WEEKDAYS: ['الأحد', 'الإثنين', 'الثلاثاء',
      'الأربعاء', 'الخميس', 'الجمعة', 'السبت'],
  STANDALONEWEEKDAYS: ['الأحد', 'الإثنين', 'الثلاثاء',
      'الأربعاء', 'الخميس', 'الجمعة', 'السبت'],
  SHORTWEEKDAYS: ['أحد', 'إثنين', 'ثلاثاء', 'أربعاء',
      'خميس', 'جمعة', 'سبت'],
  STANDALONESHORTWEEKDAYS: ['أحد', 'إثنين', 'ثلاثاء',
      'أربعاء', 'خميس', 'جمعة', 'سبت'],
  NARROWWEEKDAYS: ['ح', 'ن', 'ث', 'ر', 'خ', 'ج', 'س'],
  STANDALONENARROWWEEKDAYS: ['ح', 'ن', 'ث', 'ر', 'خ', 'ج', 'س'],
  SHORTQUARTERS: ['الربع الأول', 'الربع الثاني',
      'الربع الثالث', 'الربع الرابع'],
  QUARTERS: ['الربع الأول', 'الربع الثاني',
      'الربع الثالث', 'الربع الرابع'],
  AMPMS: ['ص', 'م'],
  DATEFORMATS: ['EEEE، d MMMM، y', 'd MMMM، y', 'yyyy/MM/dd', 'yyyy/M/d'],
  TIMEFORMATS: ['zzzz h:mm:ss a', 'z h:mm:ss a', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 5,
  WEEKENDRANGE: [3, 4],
  FIRSTWEEKCUTOFFDAY: 1
};


/**
 * Date/time formatting symbols for locale ar_EG.
 */
goog.i18n.DateTimeSymbols_ar_EG = {
  ERAS: ['ق.م', 'م'],
  ERANAMES: ['قبل الميلاد', 'ميلادي'],
  NARROWMONTHS: ['ي', 'ف', 'م', 'أ', 'و', 'ن', 'ل', 'غ', 'س', 'ك',
      'ب', 'د'],
  STANDALONENARROWMONTHS: ['ي', 'ف', 'م', 'أ', 'و', 'ن', 'ل', 'غ', 'س',
      'ك', 'ب', 'د'],
  MONTHS: ['يناير', 'فبراير', 'مارس', 'أبريل', 'مايو',
      'يونيو', 'يوليو', 'أغسطس', 'سبتمبر', 'أكتوبر',
      'نوفمبر', 'ديسمبر'],
  STANDALONEMONTHS: ['يناير', 'فبراير', 'مارس', 'أبريل',
      'مايو', 'يونيو', 'يوليو', 'أغسطس', 'سبتمبر',
      'أكتوبر', 'نوفمبر', 'ديسمبر'],
  SHORTMONTHS: ['يناير', 'فبراير', 'مارس', 'أبريل',
      'مايو', 'يونيو', 'يوليو', 'أغسطس', 'سبتمبر',
      'أكتوبر', 'نوفمبر', 'ديسمبر'],
  STANDALONESHORTMONTHS: ['يناير', 'فبراير', 'مارس',
      'أبريل', 'مايو', 'يونيو', 'يوليو', 'أغسطس',
      'سبتمبر', 'أكتوبر', 'نوفمبر', 'ديسمبر'],
  WEEKDAYS: ['الأحد', 'الإثنين', 'الثلاثاء',
      'الأربعاء', 'الخميس', 'الجمعة', 'السبت'],
  STANDALONEWEEKDAYS: ['الأحد', 'الإثنين', 'الثلاثاء',
      'الأربعاء', 'الخميس', 'الجمعة', 'السبت'],
  SHORTWEEKDAYS: ['أحد', 'إثنين', 'ثلاثاء', 'أربعاء',
      'خميس', 'جمعة', 'سبت'],
  STANDALONESHORTWEEKDAYS: ['أحد', 'إثنين', 'ثلاثاء',
      'أربعاء', 'خميس', 'جمعة', 'سبت'],
  NARROWWEEKDAYS: ['ح', 'ن', 'ث', 'ر', 'خ', 'ج', 'س'],
  STANDALONENARROWWEEKDAYS: ['ح', 'ن', 'ث', 'ر', 'خ', 'ج', 'س'],
  SHORTQUARTERS: ['الربع الأول', 'الربع الثاني',
      'الربع الثالث', 'الربع الرابع'],
  QUARTERS: ['الربع الأول', 'الربع الثاني',
      'الربع الثالث', 'الربع الرابع'],
  AMPMS: ['ص', 'م'],
  DATEFORMATS: ['EEEE، d MMMM، y', 'd MMMM، y', 'dd‏/MM‏/yyyy',
      'd‏/M‏/yyyy'],
  TIMEFORMATS: ['zzzz h:mm:ss a', 'z h:mm:ss a', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 5,
  WEEKENDRANGE: [4, 5],
  FIRSTWEEKCUTOFFDAY: 1
};


/**
 * Date/time formatting symbols for locale ar_IQ.
 */
goog.i18n.DateTimeSymbols_ar_IQ = {
  ERAS: ['ق.م', 'م'],
  ERANAMES: ['قبل الميلاد', 'ميلادي'],
  NARROWMONTHS: ['ي', 'ف', 'م', 'أ', 'و', 'ن', 'ل', 'غ', 'س', 'ك',
      'ب', 'د'],
  STANDALONENARROWMONTHS: ['ي', 'ف', 'م', 'أ', 'و', 'ن', 'ل', 'غ', 'س',
      'ك', 'ب', 'د'],
  MONTHS: ['يناير', 'فبراير', 'مارس', 'أبريل', 'مايو',
      'يونيو', 'يوليو', 'أغسطس', 'سبتمبر', 'أكتوبر',
      'نوفمبر', 'ديسمبر'],
  STANDALONEMONTHS: ['يناير', 'فبراير', 'مارس', 'أبريل',
      'مايو', 'يونيو', 'يوليو', 'أغسطس', 'سبتمبر',
      'أكتوبر', 'نوفمبر', 'ديسمبر'],
  SHORTMONTHS: ['يناير', 'فبراير', 'مارس', 'أبريل',
      'مايو', 'يونيو', 'يوليو', 'أغسطس', 'سبتمبر',
      'أكتوبر', 'نوفمبر', 'ديسمبر'],
  STANDALONESHORTMONTHS: ['يناير', 'فبراير', 'مارس',
      'أبريل', 'مايو', 'يونيو', 'يوليو', 'أغسطس',
      'سبتمبر', 'أكتوبر', 'نوفمبر', 'ديسمبر'],
  WEEKDAYS: ['الأحد', 'الإثنين', 'الثلاثاء',
      'الأربعاء', 'الخميس', 'الجمعة', 'السبت'],
  STANDALONEWEEKDAYS: ['الأحد', 'الإثنين', 'الثلاثاء',
      'الأربعاء', 'الخميس', 'الجمعة', 'السبت'],
  SHORTWEEKDAYS: ['أحد', 'إثنين', 'ثلاثاء', 'أربعاء',
      'خميس', 'جمعة', 'سبت'],
  STANDALONESHORTWEEKDAYS: ['أحد', 'إثنين', 'ثلاثاء',
      'أربعاء', 'خميس', 'جمعة', 'سبت'],
  NARROWWEEKDAYS: ['ح', 'ن', 'ث', 'ر', 'خ', 'ج', 'س'],
  STANDALONENARROWWEEKDAYS: ['ح', 'ن', 'ث', 'ر', 'خ', 'ج', 'س'],
  SHORTQUARTERS: ['الربع الأول', 'الربع الثاني',
      'الربع الثالث', 'الربع الرابع'],
  QUARTERS: ['الربع الأول', 'الربع الثاني',
      'الربع الثالث', 'الربع الرابع'],
  AMPMS: ['ص', 'م'],
  DATEFORMATS: ['EEEE، d MMMM، y', 'd MMMM، y', 'dd‏/MM‏/yyyy',
      'd‏/M‏/yyyy'],
  TIMEFORMATS: ['zzzz h:mm:ss a', 'z h:mm:ss a', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 5,
  WEEKENDRANGE: [4, 5],
  FIRSTWEEKCUTOFFDAY: 1
};


/**
 * Date/time formatting symbols for locale ar_JO.
 */
goog.i18n.DateTimeSymbols_ar_JO = {
  ERAS: ['ق.م', 'م'],
  ERANAMES: ['قبل الميلاد', 'ميلادي'],
  NARROWMONTHS: ['ي', 'ف', 'م', 'أ', 'و', 'ن', 'ل', 'غ', 'س', 'ك',
      'ب', 'د'],
  STANDALONENARROWMONTHS: ['ي', 'ف', 'م', 'أ', 'و', 'ن', 'ل', 'غ', 'س',
      'ك', 'ب', 'د'],
  MONTHS: ['كانون الثاني', 'شباط', 'آذار', 'نيسان',
      'أيار', 'حزيران', 'تموز', 'آب', 'أيلول',
      'تشرين الأول', 'تشرين الثاني',
      'كانون الأول'],
  STANDALONEMONTHS: ['كانون الثاني', 'شباط', 'آذار',
      'نيسان', 'أيار', 'حزيران', 'تموز', 'آب',
      'أيلول', 'تشرين الأول', 'تشرين الثاني',
      'كانون الأول'],
  SHORTMONTHS: ['كانون الثاني', 'شباط', 'آذار', 'نيسان',
      'أيار', 'حزيران', 'تموز', 'آب', 'أيلول',
      'تشرين الأول', 'تشرين الثاني',
      'كانون الأول'],
  STANDALONESHORTMONTHS: ['كانون الثاني', 'شباط', 'آذار',
      'نيسان', 'أيار', 'حزيران', 'تموز', 'آب',
      'أيلول', 'تشرين الأول', 'تشرين الثاني',
      'كانون الأول'],
  WEEKDAYS: ['الأحد', 'الإثنين', 'الثلاثاء',
      'الأربعاء', 'الخميس', 'الجمعة', 'السبت'],
  STANDALONEWEEKDAYS: ['الأحد', 'الإثنين', 'الثلاثاء',
      'الأربعاء', 'الخميس', 'الجمعة', 'السبت'],
  SHORTWEEKDAYS: ['الأحد', 'الاثنين', 'الثلاثاء',
      'الأربعاء', 'الخميس', 'الجمعة', 'السبت'],
  STANDALONESHORTWEEKDAYS: ['الأحد', 'الاثنين', 'الثلاثاء',
      'الأربعاء', 'الخميس', 'الجمعة', 'السبت'],
  NARROWWEEKDAYS: ['ح', 'ن', 'ث', 'ر', 'خ', 'ج', 'س'],
  STANDALONENARROWWEEKDAYS: ['ح', 'ن', 'ث', 'ر', 'خ', 'ج', 'س'],
  SHORTQUARTERS: ['الربع الأول', 'الربع الثاني',
      'الربع الثالث', 'الربع الرابع'],
  QUARTERS: ['الربع الأول', 'الربع الثاني',
      'الربع الثالث', 'الربع الرابع'],
  AMPMS: ['ص', 'م'],
  DATEFORMATS: ['EEEE، d MMMM، y', 'd MMMM، y', 'dd‏/MM‏/yyyy',
      'd‏/M‏/yyyy'],
  TIMEFORMATS: ['zzzz h:mm:ss a', 'z h:mm:ss a', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 5,
  WEEKENDRANGE: [4, 5],
  FIRSTWEEKCUTOFFDAY: 1
};


/**
 * Date/time formatting symbols for locale ar_KW.
 */
goog.i18n.DateTimeSymbols_ar_KW = {
  ERAS: ['ق.م', 'م'],
  ERANAMES: ['قبل الميلاد', 'ميلادي'],
  NARROWMONTHS: ['ي', 'ف', 'م', 'أ', 'و', 'ن', 'ل', 'غ', 'س', 'ك',
      'ب', 'د'],
  STANDALONENARROWMONTHS: ['ي', 'ف', 'م', 'أ', 'و', 'ن', 'ل', 'غ', 'س',
      'ك', 'ب', 'د'],
  MONTHS: ['يناير', 'فبراير', 'مارس', 'أبريل', 'مايو',
      'يونيو', 'يوليو', 'أغسطس', 'سبتمبر', 'أكتوبر',
      'نوفمبر', 'ديسمبر'],
  STANDALONEMONTHS: ['يناير', 'فبراير', 'مارس', 'أبريل',
      'مايو', 'يونيو', 'يوليو', 'أغسطس', 'سبتمبر',
      'أكتوبر', 'نوفمبر', 'ديسمبر'],
  SHORTMONTHS: ['يناير', 'فبراير', 'مارس', 'أبريل',
      'مايو', 'يونيو', 'يوليو', 'أغسطس', 'سبتمبر',
      'أكتوبر', 'نوفمبر', 'ديسمبر'],
  STANDALONESHORTMONTHS: ['يناير', 'فبراير', 'مارس',
      'أبريل', 'مايو', 'يونيو', 'يوليو', 'أغسطس',
      'سبتمبر', 'أكتوبر', 'نوفمبر', 'ديسمبر'],
  WEEKDAYS: ['الأحد', 'الإثنين', 'الثلاثاء',
      'الأربعاء', 'الخميس', 'الجمعة', 'السبت'],
  STANDALONEWEEKDAYS: ['الأحد', 'الإثنين', 'الثلاثاء',
      'الأربعاء', 'الخميس', 'الجمعة', 'السبت'],
  SHORTWEEKDAYS: ['أحد', 'إثنين', 'ثلاثاء', 'أربعاء',
      'خميس', 'جمعة', 'سبت'],
  STANDALONESHORTWEEKDAYS: ['أحد', 'إثنين', 'ثلاثاء',
      'أربعاء', 'خميس', 'جمعة', 'سبت'],
  NARROWWEEKDAYS: ['ح', 'ن', 'ث', 'ر', 'خ', 'ج', 'س'],
  STANDALONENARROWWEEKDAYS: ['ح', 'ن', 'ث', 'ر', 'خ', 'ج', 'س'],
  SHORTQUARTERS: ['الربع الأول', 'الربع الثاني',
      'الربع الثالث', 'الربع الرابع'],
  QUARTERS: ['الربع الأول', 'الربع الثاني',
      'الربع الثالث', 'الربع الرابع'],
  AMPMS: ['ص', 'م'],
  DATEFORMATS: ['EEEE، d MMMM، y', 'd MMMM، y', 'dd‏/MM‏/yyyy',
      'd‏/M‏/yyyy'],
  TIMEFORMATS: ['zzzz h:mm:ss a', 'z h:mm:ss a', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 5,
  WEEKENDRANGE: [3, 4],
  FIRSTWEEKCUTOFFDAY: 1
};


/**
 * Date/time formatting symbols for locale ar_LB.
 */
goog.i18n.DateTimeSymbols_ar_LB = {
  ERAS: ['ق.م', 'م'],
  ERANAMES: ['قبل الميلاد', 'ميلادي'],
  NARROWMONTHS: ['ي', 'ف', 'م', 'أ', 'و', 'ن', 'ل', 'غ', 'س', 'ك',
      'ب', 'د'],
  STANDALONENARROWMONTHS: ['ي', 'ف', 'م', 'أ', 'و', 'ن', 'ل', 'غ', 'س',
      'ك', 'ب', 'د'],
  MONTHS: ['كانون الثاني', 'شباط', 'آذار', 'نيسان',
      'أيار', 'حزيران', 'تموز', 'آب', 'أيلول',
      'تشرين الأول', 'تشرين الثاني',
      'كانون الأول'],
  STANDALONEMONTHS: ['كانون الثاني', 'شباط', 'آذار',
      'نيسان', 'أيار', 'حزيران', 'تموز', 'آب',
      'أيلول', 'تشرين الأول', 'تشرين الثاني',
      'كانون الأول'],
  SHORTMONTHS: ['كانون الثاني', 'شباط', 'آذار', 'نيسان',
      'أيار', 'حزيران', 'تموز', 'آب', 'أيلول',
      'تشرين الأول', 'تشرين الثاني',
      'كانون الأول'],
  STANDALONESHORTMONTHS: ['كانون الثاني', 'شباط', 'آذار',
      'نيسان', 'أيار', 'حزيران', 'تموز', 'آب',
      'أيلول', 'تشرين الأول', 'تشرين الثاني',
      'كانون الأول'],
  WEEKDAYS: ['الأحد', 'الإثنين', 'الثلاثاء',
      'الأربعاء', 'الخميس', 'الجمعة', 'السبت'],
  STANDALONEWEEKDAYS: ['الأحد', 'الإثنين', 'الثلاثاء',
      'الأربعاء', 'الخميس', 'الجمعة', 'السبت'],
  SHORTWEEKDAYS: ['الأحد', 'الاثنين', 'الثلاثاء',
      'الأربعاء', 'الخميس', 'الجمعة', 'السبت'],
  STANDALONESHORTWEEKDAYS: ['الأحد', 'الاثنين', 'الثلاثاء',
      'الأربعاء', 'الخميس', 'الجمعة', 'السبت'],
  NARROWWEEKDAYS: ['ح', 'ن', 'ث', 'ر', 'خ', 'ج', 'س'],
  STANDALONENARROWWEEKDAYS: ['ح', 'ن', 'ث', 'ر', 'خ', 'ج', 'س'],
  SHORTQUARTERS: ['الربع الأول', 'الربع الثاني',
      'الربع الثالث', 'الربع الرابع'],
  QUARTERS: ['الربع الأول', 'الربع الثاني',
      'الربع الثالث', 'الربع الرابع'],
  AMPMS: ['ص', 'م'],
  DATEFORMATS: ['EEEE، d MMMM، y', 'd MMMM، y', 'dd‏/MM‏/yyyy',
      'd‏/M‏/yyyy'],
  TIMEFORMATS: ['zzzz h:mm:ss a', 'z h:mm:ss a', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale ar_LY.
 */
goog.i18n.DateTimeSymbols_ar_LY = {
  ERAS: ['ق.م', 'م'],
  ERANAMES: ['قبل الميلاد', 'ميلادي'],
  NARROWMONTHS: ['ي', 'ف', 'م', 'أ', 'و', 'ن', 'ل', 'غ', 'س', 'ك',
      'ب', 'د'],
  STANDALONENARROWMONTHS: ['ي', 'ف', 'م', 'أ', 'و', 'ن', 'ل', 'غ', 'س',
      'ك', 'ب', 'د'],
  MONTHS: ['يناير', 'فبراير', 'مارس', 'أبريل', 'مايو',
      'يونيو', 'يوليو', 'أغسطس', 'سبتمبر', 'أكتوبر',
      'نوفمبر', 'ديسمبر'],
  STANDALONEMONTHS: ['يناير', 'فبراير', 'مارس', 'أبريل',
      'مايو', 'يونيو', 'يوليو', 'أغسطس', 'سبتمبر',
      'أكتوبر', 'نوفمبر', 'ديسمبر'],
  SHORTMONTHS: ['يناير', 'فبراير', 'مارس', 'أبريل',
      'مايو', 'يونيو', 'يوليو', 'أغسطس', 'سبتمبر',
      'أكتوبر', 'نوفمبر', 'ديسمبر'],
  STANDALONESHORTMONTHS: ['يناير', 'فبراير', 'مارس',
      'أبريل', 'مايو', 'يونيو', 'يوليو', 'أغسطس',
      'سبتمبر', 'أكتوبر', 'نوفمبر', 'ديسمبر'],
  WEEKDAYS: ['الأحد', 'الإثنين', 'الثلاثاء',
      'الأربعاء', 'الخميس', 'الجمعة', 'السبت'],
  STANDALONEWEEKDAYS: ['الأحد', 'الإثنين', 'الثلاثاء',
      'الأربعاء', 'الخميس', 'الجمعة', 'السبت'],
  SHORTWEEKDAYS: ['أحد', 'إثنين', 'ثلاثاء', 'أربعاء',
      'خميس', 'جمعة', 'سبت'],
  STANDALONESHORTWEEKDAYS: ['أحد', 'إثنين', 'ثلاثاء',
      'أربعاء', 'خميس', 'جمعة', 'سبت'],
  NARROWWEEKDAYS: ['ح', 'ن', 'ث', 'ر', 'خ', 'ج', 'س'],
  STANDALONENARROWWEEKDAYS: ['ح', 'ن', 'ث', 'ر', 'خ', 'ج', 'س'],
  SHORTQUARTERS: ['الربع الأول', 'الربع الثاني',
      'الربع الثالث', 'الربع الرابع'],
  QUARTERS: ['الربع الأول', 'الربع الثاني',
      'الربع الثالث', 'الربع الرابع'],
  AMPMS: ['ص', 'م'],
  DATEFORMATS: ['EEEE، d MMMM، y', 'd MMMM، y', 'dd‏/MM‏/yyyy',
      'd‏/M‏/yyyy'],
  TIMEFORMATS: ['zzzz h:mm:ss a', 'z h:mm:ss a', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 5,
  WEEKENDRANGE: [4, 5],
  FIRSTWEEKCUTOFFDAY: 1
};


/**
 * Date/time formatting symbols for locale ar_MA.
 */
goog.i18n.DateTimeSymbols_ar_MA = {
  ERAS: ['ق.م', 'م'],
  ERANAMES: ['قبل الميلاد', 'ميلادي'],
  NARROWMONTHS: ['ي', 'ف', 'م', 'أ', 'و', 'ن', 'ل', 'غ', 'س', 'ك',
      'ب', 'د'],
  STANDALONENARROWMONTHS: ['ي', 'ف', 'م', 'أ', 'و', 'ن', 'ل', 'غ', 'س',
      'ك', 'ب', 'د'],
  MONTHS: ['يناير', 'فبراير', 'مارس', 'أبريل', 'مايو',
      'يونيو', 'يوليو', 'أغسطس', 'سبتمبر', 'أكتوبر',
      'نوفمبر', 'ديسمبر'],
  STANDALONEMONTHS: ['يناير', 'فبراير', 'مارس', 'أبريل',
      'مايو', 'يونيو', 'يوليو', 'أغسطس', 'سبتمبر',
      'أكتوبر', 'نوفمبر', 'ديسمبر'],
  SHORTMONTHS: ['يناير', 'فبراير', 'مارس', 'أبريل',
      'مايو', 'يونيو', 'يوليو', 'أغسطس', 'سبتمبر',
      'أكتوبر', 'نوفمبر', 'ديسمبر'],
  STANDALONESHORTMONTHS: ['يناير', 'فبراير', 'مارس',
      'أبريل', 'مايو', 'يونيو', 'يوليو', 'أغسطس',
      'سبتمبر', 'أكتوبر', 'نوفمبر', 'ديسمبر'],
  WEEKDAYS: ['الأحد', 'الإثنين', 'الثلاثاء',
      'الأربعاء', 'الخميس', 'الجمعة', 'السبت'],
  STANDALONEWEEKDAYS: ['الأحد', 'الإثنين', 'الثلاثاء',
      'الأربعاء', 'الخميس', 'الجمعة', 'السبت'],
  SHORTWEEKDAYS: ['أحد', 'إثنين', 'ثلاثاء', 'أربعاء',
      'خميس', 'جمعة', 'سبت'],
  STANDALONESHORTWEEKDAYS: ['أحد', 'إثنين', 'ثلاثاء',
      'أربعاء', 'خميس', 'جمعة', 'سبت'],
  NARROWWEEKDAYS: ['ح', 'ن', 'ث', 'ر', 'خ', 'ج', 'س'],
  STANDALONENARROWWEEKDAYS: ['ح', 'ن', 'ث', 'ر', 'خ', 'ج', 'س'],
  SHORTQUARTERS: ['الربع الأول', 'الربع الثاني',
      'الربع الثالث', 'الربع الرابع'],
  QUARTERS: ['الربع الأول', 'الربع الثاني',
      'الربع الثالث', 'الربع الرابع'],
  AMPMS: ['ص', 'م'],
  DATEFORMATS: ['EEEE، d MMMM، y', 'd MMMM، y', 'yyyy/MM/dd', 'yyyy/M/d'],
  TIMEFORMATS: ['zzzz h:mm:ss a', 'z h:mm:ss a', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 5,
  WEEKENDRANGE: [4, 5],
  FIRSTWEEKCUTOFFDAY: 1
};


/**
 * Date/time formatting symbols for locale ar_OM.
 */
goog.i18n.DateTimeSymbols_ar_OM = {
  ERAS: ['ق.م', 'م'],
  ERANAMES: ['قبل الميلاد', 'ميلادي'],
  NARROWMONTHS: ['ي', 'ف', 'م', 'أ', 'و', 'ن', 'ل', 'غ', 'س', 'ك',
      'ب', 'د'],
  STANDALONENARROWMONTHS: ['ي', 'ف', 'م', 'أ', 'و', 'ن', 'ل', 'غ', 'س',
      'ك', 'ب', 'د'],
  MONTHS: ['يناير', 'فبراير', 'مارس', 'أبريل', 'مايو',
      'يونيو', 'يوليو', 'أغسطس', 'سبتمبر', 'أكتوبر',
      'نوفمبر', 'ديسمبر'],
  STANDALONEMONTHS: ['يناير', 'فبراير', 'مارس', 'أبريل',
      'مايو', 'يونيو', 'يوليو', 'أغسطس', 'سبتمبر',
      'أكتوبر', 'نوفمبر', 'ديسمبر'],
  SHORTMONTHS: ['يناير', 'فبراير', 'مارس', 'أبريل',
      'مايو', 'يونيو', 'يوليو', 'أغسطس', 'سبتمبر',
      'أكتوبر', 'نوفمبر', 'ديسمبر'],
  STANDALONESHORTMONTHS: ['يناير', 'فبراير', 'مارس',
      'أبريل', 'مايو', 'يونيو', 'يوليو', 'أغسطس',
      'سبتمبر', 'أكتوبر', 'نوفمبر', 'ديسمبر'],
  WEEKDAYS: ['الأحد', 'الإثنين', 'الثلاثاء',
      'الأربعاء', 'الخميس', 'الجمعة', 'السبت'],
  STANDALONEWEEKDAYS: ['الأحد', 'الإثنين', 'الثلاثاء',
      'الأربعاء', 'الخميس', 'الجمعة', 'السبت'],
  SHORTWEEKDAYS: ['أحد', 'إثنين', 'ثلاثاء', 'أربعاء',
      'خميس', 'جمعة', 'سبت'],
  STANDALONESHORTWEEKDAYS: ['أحد', 'إثنين', 'ثلاثاء',
      'أربعاء', 'خميس', 'جمعة', 'سبت'],
  NARROWWEEKDAYS: ['ح', 'ن', 'ث', 'ر', 'خ', 'ج', 'س'],
  STANDALONENARROWWEEKDAYS: ['ح', 'ن', 'ث', 'ر', 'خ', 'ج', 'س'],
  SHORTQUARTERS: ['الربع الأول', 'الربع الثاني',
      'الربع الثالث', 'الربع الرابع'],
  QUARTERS: ['الربع الأول', 'الربع الثاني',
      'الربع الثالث', 'الربع الرابع'],
  AMPMS: ['ص', 'م'],
  DATEFORMATS: ['EEEE، d MMMM، y', 'd MMMM، y', 'dd‏/MM‏/yyyy',
      'd‏/M‏/yyyy'],
  TIMEFORMATS: ['zzzz h:mm:ss a', 'z h:mm:ss a', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 5,
  WEEKENDRANGE: [3, 4],
  FIRSTWEEKCUTOFFDAY: 1
};


/**
 * Date/time formatting symbols for locale ar_QA.
 */
goog.i18n.DateTimeSymbols_ar_QA = {
  ERAS: ['ق.م', 'م'],
  ERANAMES: ['قبل الميلاد', 'ميلادي'],
  NARROWMONTHS: ['ي', 'ف', 'م', 'أ', 'و', 'ن', 'ل', 'غ', 'س', 'ك',
      'ب', 'د'],
  STANDALONENARROWMONTHS: ['ي', 'ف', 'م', 'أ', 'و', 'ن', 'ل', 'غ', 'س',
      'ك', 'ب', 'د'],
  MONTHS: ['يناير', 'فبراير', 'مارس', 'أبريل', 'مايو',
      'يونيو', 'يوليو', 'أغسطس', 'سبتمبر', 'أكتوبر',
      'نوفمبر', 'ديسمبر'],
  STANDALONEMONTHS: ['يناير', 'فبراير', 'مارس', 'أبريل',
      'مايو', 'يونيو', 'يوليو', 'أغسطس', 'سبتمبر',
      'أكتوبر', 'نوفمبر', 'ديسمبر'],
  SHORTMONTHS: ['يناير', 'فبراير', 'مارس', 'أبريل',
      'مايو', 'يونيو', 'يوليو', 'أغسطس', 'سبتمبر',
      'أكتوبر', 'نوفمبر', 'ديسمبر'],
  STANDALONESHORTMONTHS: ['يناير', 'فبراير', 'مارس',
      'أبريل', 'مايو', 'يونيو', 'يوليو', 'أغسطس',
      'سبتمبر', 'أكتوبر', 'نوفمبر', 'ديسمبر'],
  WEEKDAYS: ['الأحد', 'الإثنين', 'الثلاثاء',
      'الأربعاء', 'الخميس', 'الجمعة', 'السبت'],
  STANDALONEWEEKDAYS: ['الأحد', 'الإثنين', 'الثلاثاء',
      'الأربعاء', 'الخميس', 'الجمعة', 'السبت'],
  SHORTWEEKDAYS: ['الأحد', 'الاثنين', 'الثلاثاء',
      'الأربعاء', 'الخميس', 'الجمعة', 'السبت'],
  STANDALONESHORTWEEKDAYS: ['الأحد', 'الاثنين', 'الثلاثاء',
      'الأربعاء', 'الخميس', 'الجمعة', 'السبت'],
  NARROWWEEKDAYS: ['ح', 'ن', 'ث', 'ر', 'خ', 'ج', 'س'],
  STANDALONENARROWWEEKDAYS: ['ح', 'ن', 'ث', 'ر', 'خ', 'ج', 'س'],
  SHORTQUARTERS: ['الربع الأول', 'الربع الثاني',
      'الربع الثالث', 'الربع الرابع'],
  QUARTERS: ['الربع الأول', 'الربع الثاني',
      'الربع الثالث', 'الربع الرابع'],
  AMPMS: ['ص', 'م'],
  DATEFORMATS: ['EEEE، d MMMM، y', 'd MMMM، y', 'dd‏/MM‏/yyyy',
      'd‏/M‏/yyyy'],
  TIMEFORMATS: ['zzzz h:mm:ss a', 'z h:mm:ss a', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 5,
  WEEKENDRANGE: [4, 5],
  FIRSTWEEKCUTOFFDAY: 1
};


/**
 * Date/time formatting symbols for locale ar_SA.
 */
goog.i18n.DateTimeSymbols_ar_SA = {
  ERAS: ['ق.م', 'م'],
  ERANAMES: ['قبل الميلاد', 'ميلادي'],
  NARROWMONTHS: ['ي', 'ف', 'م', 'أ', 'و', 'ن', 'ل', 'غ', 'س', 'ك',
      'ب', 'د'],
  STANDALONENARROWMONTHS: ['ي', 'ف', 'م', 'أ', 'و', 'ن', 'ل', 'غ', 'س',
      'ك', 'ب', 'د'],
  MONTHS: ['يناير', 'فبراير', 'مارس', 'أبريل', 'مايو',
      'يونيو', 'يوليو', 'أغسطس', 'سبتمبر', 'أكتوبر',
      'نوفمبر', 'ديسمبر'],
  STANDALONEMONTHS: ['يناير', 'فبراير', 'مارس', 'أبريل',
      'مايو', 'يونيو', 'يوليو', 'أغسطس', 'سبتمبر',
      'أكتوبر', 'نوفمبر', 'ديسمبر'],
  SHORTMONTHS: ['يناير', 'فبراير', 'مارس', 'أبريل',
      'مايو', 'يونيو', 'يوليو', 'أغسطس', 'سبتمبر',
      'أكتوبر', 'نوفمبر', 'ديسمبر'],
  STANDALONESHORTMONTHS: ['يناير', 'فبراير', 'مارس',
      'أبريل', 'مايو', 'يونيو', 'يوليو', 'أغسطس',
      'سبتمبر', 'أكتوبر', 'نوفمبر', 'ديسمبر'],
  WEEKDAYS: ['الأحد', 'الإثنين', 'الثلاثاء',
      'الأربعاء', 'الخميس', 'الجمعة', 'السبت'],
  STANDALONEWEEKDAYS: ['الأحد', 'الإثنين', 'الثلاثاء',
      'الأربعاء', 'الخميس', 'الجمعة', 'السبت'],
  SHORTWEEKDAYS: ['الأحد', 'الاثنين', 'الثلاثاء',
      'الأربعاء', 'الخميس', 'الجمعة', 'السبت'],
  STANDALONESHORTWEEKDAYS: ['الأحد', 'الاثنين', 'الثلاثاء',
      'الأربعاء', 'الخميس', 'الجمعة', 'السبت'],
  NARROWWEEKDAYS: ['ح', 'ن', 'ث', 'ر', 'خ', 'ج', 'س'],
  STANDALONENARROWWEEKDAYS: ['ح', 'ن', 'ث', 'ر', 'خ', 'ج', 'س'],
  SHORTQUARTERS: ['الربع الأول', 'الربع الثاني',
      'الربع الثالث', 'الربع الرابع'],
  QUARTERS: ['الربع الأول', 'الربع الثاني',
      'الربع الثالث', 'الربع الرابع'],
  AMPMS: ['ص', 'م'],
  DATEFORMATS: ['EEEE، d MMMM، y', 'd MMMM، y', 'dd‏/MM‏/yyyy',
      'd‏/M‏/yyyy'],
  TIMEFORMATS: ['zzzz h:mm:ss a', 'z h:mm:ss a', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 5,
  WEEKENDRANGE: [3, 4],
  FIRSTWEEKCUTOFFDAY: 1
};


/**
 * Date/time formatting symbols for locale ar_SD.
 */
goog.i18n.DateTimeSymbols_ar_SD = {
  ERAS: ['ق.م', 'م'],
  ERANAMES: ['قبل الميلاد', 'ميلادي'],
  NARROWMONTHS: ['ي', 'ف', 'م', 'أ', 'و', 'ن', 'ل', 'غ', 'س', 'ك',
      'ب', 'د'],
  STANDALONENARROWMONTHS: ['ي', 'ف', 'م', 'أ', 'و', 'ن', 'ل', 'غ', 'س',
      'ك', 'ب', 'د'],
  MONTHS: ['يناير', 'فبراير', 'مارس', 'أبريل', 'مايو',
      'يونيو', 'يوليو', 'أغسطس', 'سبتمبر', 'أكتوبر',
      'نوفمبر', 'ديسمبر'],
  STANDALONEMONTHS: ['يناير', 'فبراير', 'مارس', 'أبريل',
      'مايو', 'يونيو', 'يوليو', 'أغسطس', 'سبتمبر',
      'أكتوبر', 'نوفمبر', 'ديسمبر'],
  SHORTMONTHS: ['يناير', 'فبراير', 'مارس', 'أبريل',
      'مايو', 'يونيو', 'يوليو', 'أغسطس', 'سبتمبر',
      'أكتوبر', 'نوفمبر', 'ديسمبر'],
  STANDALONESHORTMONTHS: ['يناير', 'فبراير', 'مارس',
      'أبريل', 'مايو', 'يونيو', 'يوليو', 'أغسطس',
      'سبتمبر', 'أكتوبر', 'نوفمبر', 'ديسمبر'],
  WEEKDAYS: ['الأحد', 'الإثنين', 'الثلاثاء',
      'الأربعاء', 'الخميس', 'الجمعة', 'السبت'],
  STANDALONEWEEKDAYS: ['الأحد', 'الإثنين', 'الثلاثاء',
      'الأربعاء', 'الخميس', 'الجمعة', 'السبت'],
  SHORTWEEKDAYS: ['أحد', 'إثنين', 'ثلاثاء', 'أربعاء',
      'خميس', 'جمعة', 'سبت'],
  STANDALONESHORTWEEKDAYS: ['أحد', 'إثنين', 'ثلاثاء',
      'أربعاء', 'خميس', 'جمعة', 'سبت'],
  NARROWWEEKDAYS: ['ح', 'ن', 'ث', 'ر', 'خ', 'ج', 'س'],
  STANDALONENARROWWEEKDAYS: ['ح', 'ن', 'ث', 'ر', 'خ', 'ج', 'س'],
  SHORTQUARTERS: ['الربع الأول', 'الربع الثاني',
      'الربع الثالث', 'الربع الرابع'],
  QUARTERS: ['الربع الأول', 'الربع الثاني',
      'الربع الثالث', 'الربع الرابع'],
  AMPMS: ['ص', 'م'],
  DATEFORMATS: ['EEEE، d MMMM، y', 'd MMMM، y', 'dd‏/MM‏/yyyy',
      'd‏/M‏/yyyy'],
  TIMEFORMATS: ['zzzz h:mm:ss a', 'z h:mm:ss a', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 5,
  WEEKENDRANGE: [3, 4],
  FIRSTWEEKCUTOFFDAY: 1
};


/**
 * Date/time formatting symbols for locale ar_SY.
 */
goog.i18n.DateTimeSymbols_ar_SY = {
  ERAS: ['ق.م', 'م'],
  ERANAMES: ['قبل الميلاد', 'ميلادي'],
  NARROWMONTHS: ['ي', 'ف', 'م', 'أ', 'و', 'ن', 'ل', 'غ', 'س', 'ك',
      'ب', 'د'],
  STANDALONENARROWMONTHS: ['ي', 'ف', 'م', 'أ', 'و', 'ن', 'ل', 'غ', 'س',
      'ك', 'ب', 'د'],
  MONTHS: ['كانون الثاني', 'شباط', 'آذار', 'نيسان',
      'أيار', 'حزيران', 'تموز', 'آب', 'أيلول',
      'تشرين الأول', 'تشرين الثاني',
      'كانون الأول'],
  STANDALONEMONTHS: ['كانون الثاني', 'شباط', 'آذار',
      'نيسان', 'أيار', 'حزيران', 'تموز', 'آب',
      'أيلول', 'تشرين الأول', 'تشرين الثاني',
      'كانون الأول'],
  SHORTMONTHS: ['كانون الثاني', 'شباط', 'آذار', 'نيسان',
      'أيار', 'حزيران', 'تموز', 'آب', 'أيلول',
      'تشرين الأول', 'تشرين الثاني',
      'كانون الأول'],
  STANDALONESHORTMONTHS: ['كانون الثاني', 'شباط', 'آذار',
      'نيسان', 'أيار', 'حزيران', 'تموز', 'آب',
      'أيلول', 'تشرين الأول', 'تشرين الثاني',
      'كانون الأول'],
  WEEKDAYS: ['الأحد', 'الإثنين', 'الثلاثاء',
      'الأربعاء', 'الخميس', 'الجمعة', 'السبت'],
  STANDALONEWEEKDAYS: ['الأحد', 'الإثنين', 'الثلاثاء',
      'الأربعاء', 'الخميس', 'الجمعة', 'السبت'],
  SHORTWEEKDAYS: ['الأحد', 'الاثنين', 'الثلاثاء',
      'الأربعاء', 'الخميس', 'الجمعة', 'السبت'],
  STANDALONESHORTWEEKDAYS: ['الأحد', 'الاثنين', 'الثلاثاء',
      'الأربعاء', 'الخميس', 'الجمعة', 'السبت'],
  NARROWWEEKDAYS: ['ح', 'ن', 'ث', 'ر', 'خ', 'ج', 'س'],
  STANDALONENARROWWEEKDAYS: ['ح', 'ن', 'ث', 'ر', 'خ', 'ج', 'س'],
  SHORTQUARTERS: ['الربع الأول', 'الربع الثاني',
      'الربع الثالث', 'الربع الرابع'],
  QUARTERS: ['الربع الأول', 'الربع الثاني',
      'الربع الثالث', 'الربع الرابع'],
  AMPMS: ['ص', 'م'],
  DATEFORMATS: ['EEEE، d MMMM، y', 'd MMMM، y', 'dd‏/MM‏/yyyy',
      'd‏/M‏/yyyy'],
  TIMEFORMATS: ['zzzz h:mm:ss a', 'z h:mm:ss a', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [4, 5],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale ar_TN.
 */
goog.i18n.DateTimeSymbols_ar_TN = {
  ERAS: ['ق.م', 'م'],
  ERANAMES: ['قبل الميلاد', 'ميلادي'],
  NARROWMONTHS: ['ي', 'ف', 'م', 'أ', 'و', 'ن', 'ل', 'غ', 'س', 'ك',
      'ب', 'د'],
  STANDALONENARROWMONTHS: ['ي', 'ف', 'م', 'أ', 'و', 'ن', 'ل', 'غ', 'س',
      'ك', 'ب', 'د'],
  MONTHS: ['يناير', 'فبراير', 'مارس', 'أبريل', 'مايو',
      'يونيو', 'يوليو', 'أغسطس', 'سبتمبر', 'أكتوبر',
      'نوفمبر', 'ديسمبر'],
  STANDALONEMONTHS: ['يناير', 'فبراير', 'مارس', 'أبريل',
      'مايو', 'يونيو', 'يوليو', 'أغسطس', 'سبتمبر',
      'أكتوبر', 'نوفمبر', 'ديسمبر'],
  SHORTMONTHS: ['يناير', 'فبراير', 'مارس', 'أبريل',
      'مايو', 'يونيو', 'يوليو', 'أغسطس', 'سبتمبر',
      'أكتوبر', 'نوفمبر', 'ديسمبر'],
  STANDALONESHORTMONTHS: ['يناير', 'فبراير', 'مارس',
      'أبريل', 'مايو', 'يونيو', 'يوليو', 'أغسطس',
      'سبتمبر', 'أكتوبر', 'نوفمبر', 'ديسمبر'],
  WEEKDAYS: ['الأحد', 'الإثنين', 'الثلاثاء',
      'الأربعاء', 'الخميس', 'الجمعة', 'السبت'],
  STANDALONEWEEKDAYS: ['الأحد', 'الإثنين', 'الثلاثاء',
      'الأربعاء', 'الخميس', 'الجمعة', 'السبت'],
  SHORTWEEKDAYS: ['الأحد', 'الاثنين', 'الثلاثاء',
      'الأربعاء', 'الخميس', 'الجمعة', 'السبت'],
  STANDALONESHORTWEEKDAYS: ['الأحد', 'الاثنين', 'الثلاثاء',
      'الأربعاء', 'الخميس', 'الجمعة', 'السبت'],
  NARROWWEEKDAYS: ['ح', 'ن', 'ث', 'ر', 'خ', 'ج', 'س'],
  STANDALONENARROWWEEKDAYS: ['ح', 'ن', 'ث', 'ر', 'خ', 'ج', 'س'],
  SHORTQUARTERS: ['الربع الأول', 'الربع الثاني',
      'الربع الثالث', 'الربع الرابع'],
  QUARTERS: ['الربع الأول', 'الربع الثاني',
      'الربع الثالث', 'الربع الرابع'],
  AMPMS: ['ص', 'م'],
  DATEFORMATS: ['EEEE، d MMMM، y', 'd MMMM، y', 'yyyy/MM/dd', 'yyyy/M/d'],
  TIMEFORMATS: ['zzzz h:mm:ss a', 'z h:mm:ss a', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 5,
  WEEKENDRANGE: [4, 5],
  FIRSTWEEKCUTOFFDAY: 1
};


/**
 * Date/time formatting symbols for locale ar_YE.
 */
goog.i18n.DateTimeSymbols_ar_YE = {
  ERAS: ['ق.م', 'م'],
  ERANAMES: ['قبل الميلاد', 'ميلادي'],
  NARROWMONTHS: ['ي', 'ف', 'م', 'أ', 'و', 'ن', 'ل', 'غ', 'س', 'ك',
      'ب', 'د'],
  STANDALONENARROWMONTHS: ['ي', 'ف', 'م', 'أ', 'و', 'ن', 'ل', 'غ', 'س',
      'ك', 'ب', 'د'],
  MONTHS: ['يناير', 'فبراير', 'مارس', 'أبريل', 'مايو',
      'يونيو', 'يوليو', 'أغسطس', 'سبتمبر', 'أكتوبر',
      'نوفمبر', 'ديسمبر'],
  STANDALONEMONTHS: ['يناير', 'فبراير', 'مارس', 'أبريل',
      'مايو', 'يونيو', 'يوليو', 'أغسطس', 'سبتمبر',
      'أكتوبر', 'نوفمبر', 'ديسمبر'],
  SHORTMONTHS: ['يناير', 'فبراير', 'مارس', 'أبريل',
      'مايو', 'يونيو', 'يوليو', 'أغسطس', 'سبتمبر',
      'أكتوبر', 'نوفمبر', 'ديسمبر'],
  STANDALONESHORTMONTHS: ['يناير', 'فبراير', 'مارس',
      'أبريل', 'مايو', 'يونيو', 'يوليو', 'أغسطس',
      'سبتمبر', 'أكتوبر', 'نوفمبر', 'ديسمبر'],
  WEEKDAYS: ['الأحد', 'الإثنين', 'الثلاثاء',
      'الأربعاء', 'الخميس', 'الجمعة', 'السبت'],
  STANDALONEWEEKDAYS: ['الأحد', 'الإثنين', 'الثلاثاء',
      'الأربعاء', 'الخميس', 'الجمعة', 'السبت'],
  SHORTWEEKDAYS: ['الأحد', 'الاثنين', 'الثلاثاء',
      'الأربعاء', 'الخميس', 'الجمعة', 'السبت'],
  STANDALONESHORTWEEKDAYS: ['الأحد', 'الاثنين', 'الثلاثاء',
      'الأربعاء', 'الخميس', 'الجمعة', 'السبت'],
  NARROWWEEKDAYS: ['ح', 'ن', 'ث', 'ر', 'خ', 'ج', 'س'],
  STANDALONENARROWWEEKDAYS: ['ح', 'ن', 'ث', 'ر', 'خ', 'ج', 'س'],
  SHORTQUARTERS: ['الربع الأول', 'الربع الثاني',
      'الربع الثالث', 'الربع الرابع'],
  QUARTERS: ['الربع الأول', 'الربع الثاني',
      'الربع الثالث', 'الربع الرابع'],
  AMPMS: ['ص', 'م'],
  DATEFORMATS: ['EEEE، d MMMM، y', 'd MMMM، y', 'dd‏/MM‏/yyyy',
      'd‏/M‏/yyyy'],
  TIMEFORMATS: ['zzzz h:mm:ss a', 'z h:mm:ss a', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 5,
  WEEKENDRANGE: [3, 4],
  FIRSTWEEKCUTOFFDAY: 1
};


/**
 * Date/time formatting symbols for locale as.
 */
goog.i18n.DateTimeSymbols_as = {
  ERAS: ['BCE', 'CE'],
  ERANAMES: ['BCE', 'CE'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['জানুৱাৰী', 'ফেব্ৰুৱাৰী',
      'মাৰ্চ', 'এপ্ৰিল', 'মে', 'জুন',
      'জুলাই', 'আগষ্ট', 'ছেপ্তেম্বৰ',
      'অক্টোবৰ', 'নৱেম্বৰ',
      'ডিচেম্বৰ'],
  STANDALONEMONTHS: ['জানুৱাৰী',
      'ফেব্ৰুৱাৰী', 'মাৰ্চ', 'এপ্ৰিল',
      'মে', 'জুন', 'জুলাই', 'আগষ্ট',
      'ছেপ্তেম্বৰ', 'অক্টোবৰ',
      'নৱেম্বৰ', 'ডিচেম্বৰ'],
  SHORTMONTHS: ['জানু', 'ফেব্ৰু', 'মাৰ্চ',
      'এপ্ৰিল', 'মে', 'জুন', 'জুলাই', 'আগ',
      'সেপ্ট', 'অক্টো', 'নভে', 'ডিসে'],
  STANDALONESHORTMONTHS: ['জানু', 'ফেব্ৰু',
      'মাৰ্চ', 'এপ্ৰিল', 'মে', 'জুন',
      'জুলাই', 'আগ', 'সেপ্ট', 'অক্টো',
      'নভে', 'ডিসে'],
  WEEKDAYS: ['দেওবাৰ', 'সোমবাৰ',
      'মঙ্গলবাৰ', 'বুধবাৰ',
      'বৃহষ্পতিবাৰ', 'শুক্ৰবাৰ',
      'শনিবাৰ'],
  STANDALONEWEEKDAYS: ['দেওবাৰ', 'সোমবাৰ',
      'মঙ্গলবাৰ', 'বুধবাৰ',
      'বৃহষ্পতিবাৰ', 'শুক্ৰবাৰ',
      'শনিবাৰ'],
  SHORTWEEKDAYS: ['ৰবি', 'সোম', 'মঙ্গল', 'বুধ',
      'বৃহষ্পতি', 'শুক্ৰ', 'শনি'],
  STANDALONESHORTWEEKDAYS: ['ৰবি', 'সোম', 'মঙ্গল',
      'বুধ', 'বৃহষ্পতি', 'শুক্ৰ', 'শনি'],
  NARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONENARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTQUARTERS: ['প্ৰথম প্ৰহৰ',
      'দ্বিতীয় প্ৰহৰ',
      'তৃতীয় প্ৰহৰ', 'চতুৰ্থ প্ৰহৰ'],
  QUARTERS: ['প্ৰথম প্ৰহৰ',
      'দ্বিতীয় প্ৰহৰ',
      'তৃতীয় প্ৰহৰ', 'চতুৰ্থ প্ৰহৰ'],
  AMPMS: ['পূৰ্বাহ্ণ', 'অপৰাহ্ণ'],
  DATEFORMATS: ['EEEE, d MMMM, y', 'd MMMM, y', 'dd-MM-yyyy', 'd-M-yyyy'],
  TIMEFORMATS: ['h.mm.ss a zzzz', 'h.mm.ss a z', 'h.mm.ss a', 'h.mm. a'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [6, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale as_IN.
 */
goog.i18n.DateTimeSymbols_as_IN = goog.i18n.DateTimeSymbols_as;


/**
 * Date/time formatting symbols for locale az.
 */
goog.i18n.DateTimeSymbols_az = {
  ERAS: ['e.ə.', 'b.e.'],
  ERANAMES: ['eramızdan əvvəl', 'bizim eramızın'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['Yanvar', 'Fevral', 'Mart', 'Aprel', 'May', 'İyun', 'İyul',
      'Avqust', 'Sentyabr', 'Oktyabr', 'Noyabr', 'Dekabr'],
  STANDALONEMONTHS: ['Yanvar', 'Fevral', 'Mart', 'Aprel', 'May', 'İyun',
      'İyul', 'Avqust', 'Sentyabr', 'Oktyabr', 'Noyabr', 'Dekabr'],
  SHORTMONTHS: ['yan', 'fev', 'mar', 'apr', 'may', 'iyn', 'iyl', 'avq', 'sen',
      'okt', 'noy', 'dek'],
  STANDALONESHORTMONTHS: ['yan', 'fev', 'mar', 'apr', 'may', 'iyn', 'iyl',
      'avq', 'sen', 'okt', 'noy', 'dek'],
  WEEKDAYS: ['bazar', 'bazar ertəsi', 'çərşənbə axşamı',
      'çərşənbə', 'cümə axşamı', 'cümə', 'şənbə'],
  STANDALONEWEEKDAYS: ['bazar', 'bazar ertəsi', 'çərşənbə axşamı',
      'çərşənbə', 'cümə axşamı', 'cümə', 'şənbə'],
  SHORTWEEKDAYS: ['B.', 'B.E.', 'Ç.A.', 'Ç.', 'C.A.', 'C', 'Ş.'],
  STANDALONESHORTWEEKDAYS: ['B.', 'B.E.', 'Ç.A.', 'Ç.', 'C.A.', 'C', 'Ş.'],
  NARROWWEEKDAYS: ['7', '1', '2', '3', '4', '5', '6'],
  STANDALONENARROWWEEKDAYS: ['7', '1', '2', '3', '4', '5', '6'],
  SHORTQUARTERS: ['1-ci kv.', '2-ci kv.', '3-cü kv.', '4-cü kv.'],
  QUARTERS: ['1-ci kvartal', '2-ci kvartal', '3-cü kvartal', '4-cü kvartal'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, d, MMMM, y', 'd MMMM , y', 'd MMM, y', 'yy/MM/dd'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale az_AZ.
 */
goog.i18n.DateTimeSymbols_az_AZ = goog.i18n.DateTimeSymbols_az;


/**
 * Date/time formatting symbols for locale az_Arab.
 */
goog.i18n.DateTimeSymbols_az_Arab = goog.i18n.DateTimeSymbols_az;


/**
 * Date/time formatting symbols for locale az_Arab_IR.
 */
goog.i18n.DateTimeSymbols_az_Arab_IR = goog.i18n.DateTimeSymbols_az;


/**
 * Date/time formatting symbols for locale az_Cyrl.
 */
goog.i18n.DateTimeSymbols_az_Cyrl = {
  ERAS: ['e.ə.', 'b.e.'],
  ERANAMES: ['eramızdan əvvəl', 'bizim eramızın'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['јанвар', 'феврал', 'март', 'апрел', 'май',
      'ијун', 'ијул', 'август', 'сентјабр',
      'октјабр', 'нојабр', 'декабр'],
  STANDALONEMONTHS: ['јанвар', 'феврал', 'март', 'апрел',
      'май', 'ијун', 'ијул', 'август', 'сентјабр',
      'октјабр', 'нојабр', 'декабр'],
  SHORTMONTHS: ['yan', 'fev', 'mar', 'apr', 'may', 'iyn', 'iyl', 'avq', 'sen',
      'okt', 'noy', 'dek'],
  STANDALONESHORTMONTHS: ['yan', 'fev', 'mar', 'apr', 'may', 'iyn', 'iyl',
      'avq', 'sen', 'okt', 'noy', 'dek'],
  WEEKDAYS: ['базар', 'базар ертәси',
      'чәршәнбә ахшамы', 'чәршәнбә',
      'ҹүмә ахшамы', 'ҹүмә', 'шәнбә'],
  STANDALONEWEEKDAYS: ['базар', 'базар ертәси',
      'чәршәнбә ахшамы', 'чәршәнбә',
      'ҹүмә ахшамы', 'ҹүмә', 'шәнбә'],
  SHORTWEEKDAYS: ['B.', 'B.E.', 'Ç.A.', 'Ç.', 'C.A.', 'C', 'Ş.'],
  STANDALONESHORTWEEKDAYS: ['B.', 'B.E.', 'Ç.A.', 'Ç.', 'C.A.', 'C', 'Ş.'],
  NARROWWEEKDAYS: ['7', '1', '2', '3', '4', '5', '6'],
  STANDALONENARROWWEEKDAYS: ['7', '1', '2', '3', '4', '5', '6'],
  SHORTQUARTERS: ['1-ci kv.', '2-ci kv.', '3-cü kv.', '4-cü kv.'],
  QUARTERS: ['1-ci kvartal', '2-ci kvartal', '3-cü kvartal', '4-cü kvartal'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, d, MMMM, y', 'd MMMM , y', 'd MMM, y', 'yy/MM/dd'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale az_Cyrl_AZ.
 */
goog.i18n.DateTimeSymbols_az_Cyrl_AZ = goog.i18n.DateTimeSymbols_az_Cyrl;


/**
 * Date/time formatting symbols for locale az_IR.
 */
goog.i18n.DateTimeSymbols_az_IR = goog.i18n.DateTimeSymbols_az;


/**
 * Date/time formatting symbols for locale az_Latn.
 */
goog.i18n.DateTimeSymbols_az_Latn = goog.i18n.DateTimeSymbols_az;


/**
 * Date/time formatting symbols for locale az_Latn_AZ.
 */
goog.i18n.DateTimeSymbols_az_Latn_AZ = goog.i18n.DateTimeSymbols_az;


/**
 * Date/time formatting symbols for locale be.
 */
goog.i18n.DateTimeSymbols_be = {
  ERAS: ['да н.э.', 'н.э.'],
  ERANAMES: ['да н.э.', 'н.э.'],
  NARROWMONTHS: ['с', 'л', 'с', 'к', 'т', 'ч', 'л', 'ж', 'в', 'к',
      'л', 'с'],
  STANDALONENARROWMONTHS: ['с', 'л', 'с', 'к', 'м', 'ч', 'л', 'ж', 'в',
      'к', 'л', 'с'],
  MONTHS: ['студзень', 'люты', 'сакавік', 'красавік',
      'май', 'чэрвень', 'ліпень', 'жнівень',
      'верасень', 'кастрычнік', 'лістапад',
      'снежань'],
  STANDALONEMONTHS: ['студзень', 'люты', 'сакавік',
      'красавік', 'травень', 'чэрвень', 'ліпень',
      'жнівень', 'верасень', 'кастрычнік',
      'лістапад', 'снежань'],
  SHORTMONTHS: ['сту', 'лют', 'сак', 'кра', 'май', 'чэр',
      'ліп', 'жні', 'вер', 'кас', 'ліс', 'сне'],
  STANDALONESHORTMONTHS: ['сту', 'лют', 'сак', 'кра', 'тра',
      'чэр', 'ліп', 'жні', 'вер', 'кас', 'ліс', 'сне'],
  WEEKDAYS: ['нядзеля', 'панядзелак', 'аўторак',
      'серада', 'чацвер', 'пятніца', 'субота'],
  STANDALONEWEEKDAYS: ['нядзеля', 'панядзелак',
      'аўторак', 'серада', 'чацвер', 'пятніца',
      'субота'],
  SHORTWEEKDAYS: ['нд', 'пн', 'аў', 'ср', 'чц', 'пт', 'сб'],
  STANDALONESHORTWEEKDAYS: ['нд', 'пн', 'аў', 'ср', 'чц', 'пт',
      'сб'],
  NARROWWEEKDAYS: ['н', 'п', 'а', 'с', 'ч', 'п', 'с'],
  STANDALONENARROWWEEKDAYS: ['н', 'п', 'а', 'с', 'ч', 'п', 'с'],
  SHORTQUARTERS: ['1-шы кв.', '2-гі кв.', '3-ці кв.',
      '4-ты кв.'],
  QUARTERS: ['1-шы квартал', '2-гі квартал',
      '3-ці квартал', '4-ты квартал'],
  AMPMS: ['да палудня', 'пасля палудня'],
  DATEFORMATS: ['EEEE, d MMMM y', 'd MMMM y', 'd.M.yyyy', 'd.M.yy'],
  TIMEFORMATS: ['HH.mm.ss zzzz', 'HH.mm.ss z', 'HH.mm.ss', 'HH.mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale be_BY.
 */
goog.i18n.DateTimeSymbols_be_BY = goog.i18n.DateTimeSymbols_be;


/**
 * Date/time formatting symbols for locale bg_BG.
 */
goog.i18n.DateTimeSymbols_bg_BG = {
  ERAS: ['пр. н. е.', 'от н. е.'],
  ERANAMES: ['пр.Хр.', 'сл.Хр.'],
  NARROWMONTHS: ['я', 'ф', 'м', 'а', 'м', 'ю', 'ю', 'а', 'с', 'о',
      'н', 'д'],
  STANDALONENARROWMONTHS: ['я', 'ф', 'м', 'а', 'м', 'ю', 'ю', 'а', 'с',
      'о', 'н', 'д'],
  MONTHS: ['януари', 'февруари', 'март', 'април',
      'май', 'юни', 'юли', 'август', 'септември',
      'октомври', 'ноември', 'декември'],
  STANDALONEMONTHS: ['януари', 'февруари', 'март',
      'април', 'май', 'юни', 'юли', 'август',
      'септември', 'октомври', 'ноември',
      'декември'],
  SHORTMONTHS: ['ян.', 'февр.', 'март', 'апр.', 'май', 'юни',
      'юли', 'авг.', 'септ.', 'окт.', 'ноем.', 'дек.'],
  STANDALONESHORTMONTHS: ['ян.', 'февр.', 'март', 'апр.', 'май',
      'юни', 'юли', 'авг.', 'септ.', 'окт.', 'ноем.',
      'дек.'],
  WEEKDAYS: ['неделя', 'понеделник', 'вторник',
      'сряда', 'четвъртък', 'петък', 'събота'],
  STANDALONEWEEKDAYS: ['неделя', 'понеделник', 'вторник',
      'сряда', 'четвъртък', 'петък', 'събота'],
  SHORTWEEKDAYS: ['нд', 'пн', 'вт', 'ср', 'чт', 'пт', 'сб'],
  STANDALONESHORTWEEKDAYS: ['нд', 'пн', 'вт', 'ср', 'чт', 'пт',
      'сб'],
  NARROWWEEKDAYS: ['н', 'п', 'в', 'с', 'ч', 'п', 'с'],
  STANDALONENARROWWEEKDAYS: ['н', 'п', 'в', 'с', 'ч', 'п', 'с'],
  SHORTQUARTERS: ['I трим.', 'II трим.', 'III трим.',
      'IV трим.'],
  QUARTERS: ['1-во тримесечие', '2-ро тримесечие',
      '3-то тримесечие', '4-то тримесечие'],
  AMPMS: ['пр. об.', 'сл. об.'],
  DATEFORMATS: ['dd MMMM y, EEEE', 'dd MMMM y', 'dd.MM.yyyy', 'dd.MM.yy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale bn_BD.
 */
goog.i18n.DateTimeSymbols_bn_BD = {
  ERAS: ['খৃষ্টপূর্ব', 'খৃষ্টাব্দ'],
  ERANAMES: ['খৃষ্টপূর্ব', 'খৃষ্টাব্দ'],
  NARROWMONTHS: ['জা', 'ফে', 'মা', 'এ', 'মে', 'জুন',
      'জু', 'আ', 'সে', 'অ', 'ন', 'ডি'],
  STANDALONENARROWMONTHS: ['জা', 'ফে', 'মা', 'এ', 'মে',
      'জুন', 'জু', 'আ', 'সে', 'অ', 'ন', 'ডি'],
  MONTHS: ['জানুয়ারী', 'ফেব্রুয়ারী',
      'মার্চ', 'এপ্রিল', 'মে', 'জুন',
      'জুলাই', 'আগস্ট', 'সেপ্টেম্বর',
      'অক্টোবর', 'নভেম্বর',
      'ডিসেম্বর'],
  STANDALONEMONTHS: ['জানুয়ারী',
      'ফেব্রুয়ারী', 'মার্চ',
      'এপ্রিল', 'মে', 'জুন', 'জুলাই',
      'আগস্ট', 'সেপ্টেম্বর',
      'অক্টোবর', 'নভেম্বর',
      'ডিসেম্বর'],
  SHORTMONTHS: ['জানুয়ারী',
      'ফেব্রুয়ারী', 'মার্চ',
      'এপ্রিল', 'মে', 'জুন', 'জুলাই',
      'আগস্ট', 'সেপ্টেম্বর',
      'অক্টোবর', 'নভেম্বর',
      'ডিসেম্বর'],
  STANDALONESHORTMONTHS: ['জানুয়ারী',
      'ফেব্রুয়ারী', 'মার্চ',
      'এপ্রিল', 'মে', 'জুন', 'জুলাই',
      'আগস্ট', 'সেপ্টেম্বর',
      'অক্টোবর', 'নভেম্বর',
      'ডিসেম্বর'],
  WEEKDAYS: ['রবিবার', 'সোমবার',
      'মঙ্গলবার', 'বুধবার',
      'বৃহষ্পতিবার', 'শুক্রবার',
      'শনিবার'],
  STANDALONEWEEKDAYS: ['রবিবার', 'সোমবার',
      'মঙ্গলবার', 'বুধবার',
      'বৃহষ্পতিবার', 'শুক্রবার',
      'শনিবার'],
  SHORTWEEKDAYS: ['রবি', 'সোম', 'মঙ্গল', 'বুধ',
      'বৃহস্পতি', 'শুক্র', 'শনি'],
  STANDALONESHORTWEEKDAYS: ['রবি', 'সোম', 'মঙ্গল',
      'বুধ', 'বৃহস্পতি', 'শুক্র', 'শনি'],
  NARROWWEEKDAYS: ['র', 'সো', 'ম', 'বু', 'বৃ', 'শু', 'শ'],
  STANDALONENARROWWEEKDAYS: ['র', 'সো', 'ম', 'বু', 'বৃ',
      'শু', 'শ'],
  SHORTQUARTERS: ['চতুর্থাংশ ১',
      'চতুর্থাংশ ২', 'চতুর্থাংশ ৩',
      'চতুর্থাংশ ৪'],
  QUARTERS: ['প্রথম চতুর্থাংশ',
      'দ্বিতীয় চতুর্থাংশ',
      'তৃতীয় চতুর্থাংশ',
      'চতুর্থ চতুর্থাংশ'],
  AMPMS: ['am', 'pm'],
  DATEFORMATS: ['EEEE, d MMMM, y', 'd MMMM, y', 'd MMM, y', 'd/M/yy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale bn_IN.
 */
goog.i18n.DateTimeSymbols_bn_IN = {
  ERAS: ['খৃষ্টপূর্ব', 'খৃষ্টাব্দ'],
  ERANAMES: ['খৃষ্টপূর্ব', 'খৃষ্টাব্দ'],
  NARROWMONTHS: ['জা', 'ফে', 'মা', 'এ', 'মে', 'জুন',
      'জু', 'আ', 'সে', 'অ', 'ন', 'ডি'],
  STANDALONENARROWMONTHS: ['জা', 'ফে', 'মা', 'এ', 'মে',
      'জুন', 'জু', 'আ', 'সে', 'অ', 'ন', 'ডি'],
  MONTHS: ['জানুয়ারী', 'ফেব্রুয়ারী',
      'মার্চ', 'এপ্রিল', 'মে', 'জুন',
      'জুলাই', 'আগস্ট', 'সেপ্টেম্বর',
      'অক্টোবর', 'নভেম্বর',
      'ডিসেম্বর'],
  STANDALONEMONTHS: ['জানুয়ারী',
      'ফেব্রুয়ারী', 'মার্চ',
      'এপ্রিল', 'মে', 'জুন', 'জুলাই',
      'আগস্ট', 'সেপ্টেম্বর',
      'অক্টোবর', 'নভেম্বর',
      'ডিসেম্বর'],
  SHORTMONTHS: ['জানুয়ারী',
      'ফেব্রুয়ারী', 'মার্চ',
      'এপ্রিল', 'মে', 'জুন', 'জুলাই',
      'আগস্ট', 'সেপ্টেম্বর',
      'অক্টোবর', 'নভেম্বর',
      'ডিসেম্বর'],
  STANDALONESHORTMONTHS: ['জানুয়ারী',
      'ফেব্রুয়ারী', 'মার্চ',
      'এপ্রিল', 'মে', 'জুন', 'জুলাই',
      'আগস্ট', 'সেপ্টেম্বর',
      'অক্টোবর', 'নভেম্বর',
      'ডিসেম্বর'],
  WEEKDAYS: ['রবিবার', 'সোমবার',
      'মঙ্গলবার', 'বুধবার',
      'বৃহষ্পতিবার', 'শুক্রবার',
      'শনিবার'],
  STANDALONEWEEKDAYS: ['রবিবার', 'সোমবার',
      'মঙ্গলবার', 'বুধবার',
      'বৃহষ্পতিবার', 'শুক্রবার',
      'শনিবার'],
  SHORTWEEKDAYS: ['রবি', 'সোম', 'মঙ্গল', 'বুধ',
      'বৃহস্পতি', 'শুক্র', 'শনি'],
  STANDALONESHORTWEEKDAYS: ['রবি', 'সোম', 'মঙ্গল',
      'বুধ', 'বৃহস্পতি', 'শুক্র', 'শনি'],
  NARROWWEEKDAYS: ['র', 'সো', 'ম', 'বু', 'বৃ', 'শু', 'শ'],
  STANDALONENARROWWEEKDAYS: ['র', 'সো', 'ম', 'বু', 'বৃ',
      'শু', 'শ'],
  SHORTQUARTERS: ['ত্রৈমাসিক', 'ষাণ্মাসিক',
      'চতুর্থাংশ ৩', 'বার্ষিক'],
  QUARTERS: ['ত্রৈমাসিক', 'ষাণ্মাসিক',
      'তৃতীয় চতুর্থাংশ',
      'বার্ষিক'],
  AMPMS: ['am', 'pm'],
  DATEFORMATS: ['EEEE, d MMMM, y', 'd MMMM, y', 'd MMM, y', 'd/M/yy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [6, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale bo.
 */
goog.i18n.DateTimeSymbols_bo = {
  ERAS: ['སྤྱི་ལོ་སྔོན།', 'སྤྱི་ལོ།'],
  ERANAMES: ['སྤྱི་ལོ་སྔོན།',
      'སྤྱི་ལོ།'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['ཟླ་བ་དང་པོ་',
      'ཟླ་བ་གཉིས་པ་',
      'ཟླ་བ་སུམ་པ་', 'ཟླ་བ་བཞི་པ་',
      'ཟླ་བ་ལྔ་པ་', 'ཟླ་བ་དྲུག་པ་',
      'ཟླ་བ་བདུན་པ་',
      'ཟླ་བ་བརྒྱད་པ་',
      'ཟླ་བ་དགུ་པ་', 'ཟླ་བ་བཅུ་པ་',
      'ཟླ་བ་བཅུ་གཅིག་པ་',
      'ཟླ་བ་བཅུ་གཉིས་པ་'],
  STANDALONEMONTHS: ['ཟླ་བ་དང་པོ་',
      'ཟླ་བ་གཉིས་པ་',
      'ཟླ་བ་སུམ་པ་', 'ཟླ་བ་བཞི་པ་',
      'ཟླ་བ་ལྔ་པ་', 'ཟླ་བ་དྲུག་པ་',
      'ཟླ་བ་བདུན་པ་',
      'ཟླ་བ་བརྒྱད་པ་',
      'ཟླ་བ་དགུ་པ་', 'ཟླ་བ་བཅུ་པ་',
      'ཟླ་བ་བཅུ་གཅིག་པ་',
      'ཟླ་བ་བཅུ་གཉིས་པ་'],
  SHORTMONTHS: ['ཟླ་༡', 'ཟླ་༢', 'ཟླ་༣', 'ཟླ་༤',
      'ཟླ་༥', 'ཟླ་༦', 'ཟླ་༧', 'ཟླ་༨',
      'ཟླ་༩', 'ཟླ་༡༠', 'ཟླ་༡༡', 'ཟླ་༡༢'],
  STANDALONESHORTMONTHS: ['ཟླ་༡', 'ཟླ་༢', 'ཟླ་༣',
      'ཟླ་༤', 'ཟླ་༥', 'ཟླ་༦', 'ཟླ་༧',
      'ཟླ་༨', 'ཟླ་༩', 'ཟླ་༡༠', 'ཟླ་༡༡',
      'ཟླ་༡༢'],
  WEEKDAYS: ['གཟའ་ཉི་མ་', 'གཟའ་ཟླ་བ་',
      'གཟའ་མིག་དམར་', 'གཟའ་ཧླག་པ་',
      'གཟའ་ཕུར་བུ་', 'གཟའ་སངས་',
      'གཟའ་སྤེན་པ་'],
  STANDALONEWEEKDAYS: ['གཟའ་ཉི་མ་',
      'གཟའ་ཟླ་བ་', 'གཟའ་མིག་དམར་',
      'གཟའ་ཧླག་པ་', 'གཟའ་ཕུར་བུ་',
      'གཟའ་སངས་', 'གཟའ་སྤེན་པ་'],
  SHORTWEEKDAYS: ['ཉི་མ་', 'ཟླ་བ་',
      'མིག་དམར་', 'ཧླག་པ་', 'ཕུར་བུ་',
      'སངས་', 'སྤེན་པ་'],
  STANDALONESHORTWEEKDAYS: ['ཉི་མ་', 'ཟླ་བ་',
      'མིག་དམར་', 'ཧླག་པ་', 'ཕུར་བུ་',
      'སངས་', 'སྤེན་པ་'],
  NARROWWEEKDAYS: ['ཉི', 'ཟླ', 'མི', 'ཧླ', 'ཕུ', 'ས',
      'སྤེ'],
  STANDALONENARROWWEEKDAYS: ['ཉི', 'ཟླ', 'མི', 'ཧླ', 'ཕུ',
      'ས', 'སྤེ'],
  SHORTQUARTERS: ['དུས་ཚིགས་དང་པོ།',
      'དུས་ཚིགས་གཉིས་པ།',
      '་དུས་ཚིགས་གསུམ་པ།',
      'དུས་ཚིགས་བཞི་པ།'],
  QUARTERS: ['དུས་ཚིགས་དང་པོ།',
      'དུས་ཚིགས་གཉིས་པ།',
      '་དུས་ཚིགས་གསུམ་པ།',
      'དུས་ཚིགས་བཞི་པ།'],
  AMPMS: ['སྔ་དྲོ་', 'ཕྱི་དྲོ་'],
  DATEFORMATS: ['EEEE, y MMMM dd',
      'སྦྱི་ལོ་y MMMMའི་ཙེས་dད',
      'y ལོ་འི་MMMཙེས་d', 'yyyy-MM-dd'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale bo_CN.
 */
goog.i18n.DateTimeSymbols_bo_CN = goog.i18n.DateTimeSymbols_bo;


/**
 * Date/time formatting symbols for locale bo_IN.
 */
goog.i18n.DateTimeSymbols_bo_IN = goog.i18n.DateTimeSymbols_bo;


/**
 * Date/time formatting symbols for locale bs.
 */
goog.i18n.DateTimeSymbols_bs = {
  ERAS: ['BC', 'AD'],
  ERANAMES: ['BC', 'AD'],
  NARROWMONTHS: ['j', 'f', 'm', 'a', 'm', 'j', 'j', 'a', 's', 'o', 'n', 'd'],
  STANDALONENARROWMONTHS: ['j', 'f', 'm', 'a', 'm', 'j', 'j', 'a', 's', 'o',
      'n', 'd'],
  MONTHS: ['januar', 'februar', 'mart', 'april', 'maj', 'juni', 'juli',
      'avgust', 'septembar', 'oktobar', 'novembar', 'decembar'],
  STANDALONEMONTHS: ['januar', 'februar', 'mart', 'april', 'maj', 'juni',
      'juli', 'avgust', 'septembar', 'oktobar', 'novembar', 'decembar'],
  SHORTMONTHS: ['jan', 'feb', 'mar', 'apr', 'maj', 'jun', 'jul', 'avg', 'sep',
      'okt', 'nov', 'dec'],
  STANDALONESHORTMONTHS: ['jan', 'feb', 'mar', 'apr', 'maj', 'jun', 'jul',
      'avg', 'sep', 'okt', 'nov', 'dec'],
  WEEKDAYS: ['nedjelja', 'ponedjeljak', 'utorak', 'srijeda', 'četvrtak',
      'petak', 'subota'],
  STANDALONEWEEKDAYS: ['nedjelja', 'ponedjeljak', 'utorak', 'srijeda',
      'četvrtak', 'petak', 'subota'],
  SHORTWEEKDAYS: ['ned', 'pon', 'uto', 'sri', 'čet', 'pet', 'sub'],
  STANDALONESHORTWEEKDAYS: ['ned', 'pon', 'uto', 'sri', 'čet', 'pet', 'sub'],
  NARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONENARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTQUARTERS: ['K1', 'K2', 'K3', 'K4'],
  QUARTERS: ['Prvi kvartal', 'Drugi kvartal', 'Treći kvartal',
      'Četvrti kvartal'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, dd. MMMM y.', 'dd. MMMM y.', 'dd.MM.y.', 'dd.MM.yy.'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale bs_BA.
 */
goog.i18n.DateTimeSymbols_bs_BA = goog.i18n.DateTimeSymbols_bs;


/**
 * Date/time formatting symbols for locale byn.
 */
goog.i18n.DateTimeSymbols_byn = {
  ERAS: ['ይጅ', 'ኣድ'],
  ERANAMES: ['ይጅ', 'ኣድ'],
  NARROWMONTHS: ['ል', 'ካ', 'ክ', 'ፋ', 'ክ', 'ም', 'ኰ', 'ማ', 'ያ',
      'መ', 'ም', 'ተ'],
  STANDALONENARROWMONTHS: ['ል', 'ካ', 'ክ', 'ፋ', 'ክ', 'ም', 'ኰ',
      'ማ', 'ያ', 'መ', 'ም', 'ተ'],
  MONTHS: ['ልደትሪ', 'ካብኽብቲ', 'ክብላ', 'ፋጅኺሪ',
      'ክቢቅሪ', 'ምኪኤል ትጟኒሪ', 'ኰርኩ',
      'ማርያም ትሪ', 'ያኸኒ መሳቅለሪ', 'መተሉ',
      'ምኪኤል መሽወሪ', 'ተሕሳስሪ'],
  STANDALONEMONTHS: ['ልደትሪ', 'ካብኽብቲ', 'ክብላ',
      'ፋጅኺሪ', 'ክቢቅሪ', 'ምኪኤል ትጟኒሪ', 'ኰርኩ',
      'ማርያም ትሪ', 'ያኸኒ መሳቅለሪ', 'መተሉ',
      'ምኪኤል መሽወሪ', 'ተሕሳስሪ'],
  SHORTMONTHS: ['ልደት', 'ካብኽ', 'ክብላ', 'ፋጅኺ', 'ክቢቅ',
      'ም/ት', 'ኰር', 'ማርያ', 'ያኸኒ', 'መተሉ', 'ም/ም',
      'ተሕሳ'],
  STANDALONESHORTMONTHS: ['ልደት', 'ካብኽ', 'ክብላ', 'ፋጅኺ',
      'ክቢቅ', 'ም/ት', 'ኰር', 'ማርያ', 'ያኸኒ', 'መተሉ',
      'ም/ም', 'ተሕሳ'],
  WEEKDAYS: ['ሰንበር ቅዳዅ', 'ሰኑ', 'ሰሊጝ',
      'ለጓ ወሪ ለብዋ', 'ኣምድ', 'ኣርብ',
      'ሰንበር ሽጓዅ'],
  STANDALONEWEEKDAYS: ['ሰንበር ቅዳዅ', 'ሰኑ', 'ሰሊጝ',
      'ለጓ ወሪ ለብዋ', 'ኣምድ', 'ኣርብ',
      'ሰንበር ሽጓዅ'],
  SHORTWEEKDAYS: ['ሰ/ቅ', 'ሰኑ', 'ሰሊጝ', 'ለጓ', 'ኣምድ',
      'ኣርብ', 'ሰ/ሽ'],
  STANDALONESHORTWEEKDAYS: ['ሰ/ቅ', 'ሰኑ', 'ሰሊጝ', 'ለጓ',
      'ኣምድ', 'ኣርብ', 'ሰ/ሽ'],
  NARROWWEEKDAYS: ['ሰ', 'ሰ', 'ሰ', 'ለ', 'ኣ', 'ኣ', 'ሰ'],
  STANDALONENARROWWEEKDAYS: ['ሰ', 'ሰ', 'ሰ', 'ለ', 'ኣ', 'ኣ', 'ሰ'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['ፋዱስ ጃብ', 'ፋዱስ ደምቢ'],
  DATEFORMATS: ['EEEE፡ dd MMMM ግርጋ y G', 'dd MMMM y', 'dd-MMM-y',
      'dd/MM/yy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale byn_ER.
 */
goog.i18n.DateTimeSymbols_byn_ER = goog.i18n.DateTimeSymbols_byn;


/**
 * Date/time formatting symbols for locale ca_ES.
 */
goog.i18n.DateTimeSymbols_ca_ES = {
  ERAS: ['aC', 'dC'],
  ERANAMES: ['abans de Crist', 'després de Crist'],
  NARROWMONTHS: ['G', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['g', 'f', 'm', 'a', 'm', 'j', 'j', 'a', 's', 'o',
      'n', 'd'],
  MONTHS: ['de gener', 'de febrer', 'de març', 'd’abril', 'de maig',
      'de juny', 'de juliol', 'd’agost', 'de setembre', 'd’octubre',
      'de novembre', 'de desembre'],
  STANDALONEMONTHS: ['gener', 'febrer', 'març', 'abril', 'maig', 'juny',
      'juliol', 'agost', 'setembre', 'octubre', 'novembre', 'desembre'],
  SHORTMONTHS: ['de gen.', 'de febr.', 'de març', 'd’abr.', 'de maig',
      'de juny', 'de jul.', 'd’ag.', 'de set.', 'd’oct.', 'de nov.',
      'de des.'],
  STANDALONESHORTMONTHS: ['gen.', 'febr.', 'març', 'abr.', 'maig', 'juny',
      'jul.', 'ag.', 'set.', 'oct.', 'nov.', 'des.'],
  WEEKDAYS: ['diumenge', 'dilluns', 'dimarts', 'dimecres', 'dijous',
      'divendres', 'dissabte'],
  STANDALONEWEEKDAYS: ['Diumenge', 'Dilluns', 'Dimarts', 'Dimecres', 'Dijous',
      'Divendres', 'dissabte'],
  SHORTWEEKDAYS: ['dg.', 'dl.', 'dt.', 'dc.', 'dj.', 'dv.', 'ds.'],
  STANDALONESHORTWEEKDAYS: ['dg', 'dl', 'dt', 'dc', 'dj', 'dv', 'ds'],
  NARROWWEEKDAYS: ['G', 'l', 'T', 'C', 'J', 'V', 'S'],
  STANDALONENARROWWEEKDAYS: ['g', 'l', 't', 'c', 'j', 'v', 's'],
  SHORTQUARTERS: ['1T', '2T', '3T', '4T'],
  QUARTERS: ['1r trimestre', '2n trimestre', '3r trimestre', '4t trimestre'],
  AMPMS: ['a.m.', 'p.m.'],
  DATEFORMATS: ['EEEE d MMMM \'de\' y', 'd MMMM \'de\' y', 'dd/MM/yyyy',
      'dd/MM/yy'],
  TIMEFORMATS: ['H:mm:ss zzzz', 'H:mm:ss z', 'H:mm:ss', 'H:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale cch.
 */
goog.i18n.DateTimeSymbols_cch = {
  ERAS: ['GM', 'M'],
  ERANAMES: ['Gabanin Miladi', 'Miladi'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['Pen Dyon', 'Pen Ba\'a', 'Pen Atat', 'Pen Anas', 'Pen Atyon',
      'Pen Achirim', 'Pen Atariba', 'Pen Awurr', 'Pen Shadon', 'Pen Shakur',
      'Pen Kur Naba', 'Pen Kur Natat'],
  STANDALONEMONTHS: ['Pen Dyon', 'Pen Ba\'a', 'Pen Atat', 'Pen Anas',
      'Pen Atyon', 'Pen Achirim', 'Pen Atariba', 'Pen Awurr', 'Pen Shadon',
      'Pen Shakur', 'Pen Kur Naba', 'Pen Kur Natat'],
  SHORTMONTHS: ['Dyon', 'Baa', 'Atat', 'Anas', 'Atyo', 'Achi', 'Atar', 'Awur',
      'Shad', 'Shak', 'Naba', 'Nata'],
  STANDALONESHORTMONTHS: ['Dyon', 'Baa', 'Atat', 'Anas', 'Atyo', 'Achi', 'Atar',
      'Awur', 'Shad', 'Shak', 'Naba', 'Nata'],
  WEEKDAYS: ['Wai Yoka Bawai', 'Wai Tunga', 'Toki Gitung', 'Tsam Kasuwa',
      'Wai Na Nas', 'Wai Na Tiyon', 'Wai Na Chirim'],
  STANDALONEWEEKDAYS: ['Wai Yoka Bawai', 'Wai Tunga', 'Toki Gitung',
      'Tsam Kasuwa', 'Wai Na Nas', 'Wai Na Tiyon', 'Wai Na Chirim'],
  SHORTWEEKDAYS: ['Yok', 'Tung', 'T. Tung', 'Tsan', 'Nas', 'Nat', 'Chir'],
  STANDALONESHORTWEEKDAYS: ['Yok', 'Tung', 'T. Tung', 'Tsan', 'Nas', 'Nat',
      'Chir'],
  NARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONENARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, y MMMM dd', 'y MMMM d', 'y MMM d', 'yy/MM/dd'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale cch_NG.
 */
goog.i18n.DateTimeSymbols_cch_NG = goog.i18n.DateTimeSymbols_cch;


/**
 * Date/time formatting symbols for locale cs_CZ.
 */
goog.i18n.DateTimeSymbols_cs_CZ = {
  ERAS: ['př.Kr.', 'po Kr.'],
  ERANAMES: ['př.Kr.', 'po Kr.'],
  NARROWMONTHS: ['l', 'ú', 'b', 'd', 'k', 'č', 'č', 's', 'z', 'ř', 'l',
      'p'],
  STANDALONENARROWMONTHS: ['l', 'ú', 'b', 'd', 'k', 'č', 'č', 's', 'z', 'ř',
      'l', 'p'],
  MONTHS: ['ledna', 'února', 'března', 'dubna', 'května', 'června',
      'července', 'srpna', 'září', 'října', 'listopadu', 'prosince'],
  STANDALONEMONTHS: ['leden', 'únor', 'březen', 'duben', 'květen', 'červen',
      'červenec', 'srpen', 'září', 'říjen', 'listopad', 'prosinec'],
  SHORTMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONESHORTMONTHS: ['1.', '2.', '3.', '4.', '5.', '6.', '7.', '8.', '9.',
      '10.', '11.', '12.'],
  WEEKDAYS: ['neděle', 'pondělí', 'úterý', 'středa', 'čtvrtek', 'pátek',
      'sobota'],
  STANDALONEWEEKDAYS: ['neděle', 'pondělí', 'úterý', 'středa', 'čtvrtek',
      'pátek', 'sobota'],
  SHORTWEEKDAYS: ['ne', 'po', 'út', 'st', 'čt', 'pá', 'so'],
  STANDALONESHORTWEEKDAYS: ['ne', 'po', 'út', 'st', 'čt', 'pá', 'so'],
  NARROWWEEKDAYS: ['N', 'P', 'Ú', 'S', 'Č', 'P', 'S'],
  STANDALONENARROWWEEKDAYS: ['N', 'P', 'Ú', 'S', 'Č', 'P', 'S'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['1. čtvrtletí', '2. čtvrtletí', '3. čtvrtletí',
      '4. čtvrtletí'],
  AMPMS: ['dop.', 'odp.'],
  DATEFORMATS: ['EEEE, d. MMMM y', 'd. MMMM y', 'd.M.yyyy', 'd.M.yy'],
  TIMEFORMATS: ['H:mm:ss zzzz', 'H:mm:ss z', 'H:mm:ss', 'H:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale cy.
 */
goog.i18n.DateTimeSymbols_cy = {
  ERAS: ['CC', 'OC'],
  ERANAMES: ['Cyn Crist', 'Oed Crist'],
  NARROWMONTHS: ['I', 'C', 'M', 'E', 'M', 'M', 'G', 'A', 'M', 'H', 'T', 'R'],
  STANDALONENARROWMONTHS: ['I', 'C', 'M', 'E', 'M', 'M', 'G', 'A', 'M', 'H',
      'T', 'R'],
  MONTHS: ['Ionawr', 'Chwefror', 'Mawrth', 'Ebrill', 'Mai', 'Mehefin',
      'Gorffenaf', 'Awst', 'Medi', 'Hydref', 'Tachwedd', 'Rhagfyr'],
  STANDALONEMONTHS: ['Ionawr', 'Chwefror', 'Mawrth', 'Ebrill', 'Mai', 'Mehefin',
      'Gorffennaf', 'Awst', 'Medi', 'Hydref', 'Tachwedd', 'Rhagfyr'],
  SHORTMONTHS: ['Ion', 'Chwef', 'Mawrth', 'Ebrill', 'Mai', 'Meh', 'Gorff',
      'Awst', 'Medi', 'Hyd', 'Tach', 'Rhag'],
  STANDALONESHORTMONTHS: ['Ion', 'Chwe', 'Maw', 'Ebr', 'Mai', 'Meh', 'Gor',
      'Awst', 'Medi', 'Hyd', 'Tach', 'Rhag'],
  WEEKDAYS: ['Dydd Sul', 'Dydd Llun', 'Dydd Mawrth', 'Dydd Mercher', 'Dydd Iau',
      'Dydd Gwener', 'Dydd Sadwrn'],
  STANDALONEWEEKDAYS: ['Dydd Sul', 'Dydd Llun', 'Dydd Mawrth', 'Dydd Mercher',
      'Dydd Iau', 'Dydd Gwener', 'Dydd Sadwrn'],
  SHORTWEEKDAYS: ['Sul', 'Llun', 'Maw', 'Mer', 'Iau', 'Gwen', 'Sad'],
  STANDALONESHORTWEEKDAYS: ['Sul', 'Llun', 'Maw', 'Mer', 'Iau', 'Gwe', 'Sad'],
  NARROWWEEKDAYS: ['S', 'L', 'M', 'M', 'I', 'G', 'S'],
  STANDALONENARROWWEEKDAYS: ['S', 'L', 'M', 'M', 'I', 'G', 'S'],
  SHORTQUARTERS: ['Ch1', 'Ch2', 'Ch3', 'Ch4'],
  QUARTERS: ['Chwarter 1af', '2il chwarter', '3ydd chwarter', '4ydd chwarter'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, d MMMM y', 'd MMMM y', 'd MMM y', 'dd/MM/yyyy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale cy_GB.
 */
goog.i18n.DateTimeSymbols_cy_GB = goog.i18n.DateTimeSymbols_cy;


/**
 * Date/time formatting symbols for locale da_DK.
 */
goog.i18n.DateTimeSymbols_da_DK = {
  ERAS: ['f.Kr.', 'e.Kr.'],
  ERANAMES: ['f.Kr.', 'e.Kr.'],
  NARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['januar', 'februar', 'marts', 'april', 'maj', 'juni', 'juli',
      'august', 'september', 'oktober', 'november', 'december'],
  STANDALONEMONTHS: ['januar', 'februar', 'marts', 'april', 'maj', 'juni',
      'juli', 'august', 'september', 'oktober', 'november', 'december'],
  SHORTMONTHS: ['jan.', 'feb.', 'mar.', 'apr.', 'maj', 'jun.', 'jul.', 'aug.',
      'sep.', 'okt.', 'nov.', 'dec.'],
  STANDALONESHORTMONTHS: ['jan', 'feb', 'mar', 'apr', 'maj', 'jun', 'jul',
      'aug', 'sep', 'okt', 'nov', 'dec'],
  WEEKDAYS: ['søndag', 'mandag', 'tirsdag', 'onsdag', 'torsdag', 'fredag',
      'lørdag'],
  STANDALONEWEEKDAYS: ['søndag', 'mandag', 'tirsdag', 'onsdag', 'torsdag',
      'fredag', 'lørdag'],
  SHORTWEEKDAYS: ['søn', 'man', 'tir', 'ons', 'tor', 'fre', 'lør'],
  STANDALONESHORTWEEKDAYS: ['søn', 'man', 'tir', 'ons', 'tor', 'fre', 'lør'],
  NARROWWEEKDAYS: ['S', 'M', 'T', 'O', 'T', 'F', 'L'],
  STANDALONENARROWWEEKDAYS: ['S', 'M', 'T', 'O', 'T', 'F', 'L'],
  SHORTQUARTERS: ['K1', 'K2', 'K3', 'K4'],
  QUARTERS: ['1. kvartal', '2. kvartal', '3. kvartal', '4. kvartal'],
  AMPMS: ['f.m.', 'e.m.'],
  DATEFORMATS: ['EEEE \'den\' d. MMMM y', 'd. MMM y', 'dd/MM/yyyy', 'dd/MM/yy'],
  TIMEFORMATS: ['HH.mm.ss zzzz', 'HH.mm.ss z', 'HH.mm.ss', 'HH.mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale de_BE.
 */
goog.i18n.DateTimeSymbols_de_BE = {
  ERAS: ['v. Chr.', 'n. Chr.'],
  ERANAMES: ['v. Chr.', 'n. Chr.'],
  NARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['Januar', 'Februar', 'März', 'April', 'Mai', 'Juni', 'Juli',
      'August', 'September', 'Oktober', 'November', 'Dezember'],
  STANDALONEMONTHS: ['Januar', 'Februar', 'März', 'April', 'Mai', 'Juni',
      'Juli', 'August', 'September', 'Oktober', 'November', 'Dezember'],
  SHORTMONTHS: ['Jan', 'Feb', 'Mär', 'Apr', 'Mai', 'Jun', 'Jul', 'Aug', 'Sep',
      'Okt', 'Nov', 'Dez'],
  STANDALONESHORTMONTHS: ['Jan.', 'Feb.', 'Mär', 'Apr.', 'Mai', 'Juni', 'Jul',
      'Aug', 'Sep', 'Okt', 'Nov', 'Dez'],
  WEEKDAYS: ['Sonntag', 'Montag', 'Dienstag', 'Mittwoch', 'Donnerstag',
      'Freitag', 'Samstag'],
  STANDALONEWEEKDAYS: ['Sonntag', 'Montag', 'Dienstag', 'Mittwoch',
      'Donnerstag', 'Freitag', 'Samstag'],
  SHORTWEEKDAYS: ['Son', 'Mon', 'Die', 'Mit', 'Don', 'Fre', 'Sam'],
  STANDALONESHORTWEEKDAYS: ['So', 'Mo', 'Di', 'Mi', 'Do', 'Fr', 'Sa'],
  NARROWWEEKDAYS: ['S', 'M', 'D', 'M', 'D', 'F', 'S'],
  STANDALONENARROWWEEKDAYS: ['S', 'M', 'D', 'M', 'D', 'F', 'S'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['1. Quartal', '2. Quartal', '3. Quartal', '4. Quartal'],
  AMPMS: ['vorm.', 'nachm.'],
  DATEFORMATS: ['EEEE d MMMM y', 'd MMMM y', 'dd.MM.yyyy', 'd/MM/yy'],
  TIMEFORMATS: ['HH \'h\' mm \'min\' ss \'s\' zzzz', 'HH:mm:ss z', 'HH:mm:ss',
      'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale de_DE.
 */
goog.i18n.DateTimeSymbols_de_DE = {
  ERAS: ['v. Chr.', 'n. Chr.'],
  ERANAMES: ['v. Chr.', 'n. Chr.'],
  NARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['Januar', 'Februar', 'März', 'April', 'Mai', 'Juni', 'Juli',
      'August', 'September', 'Oktober', 'November', 'Dezember'],
  STANDALONEMONTHS: ['Januar', 'Februar', 'März', 'April', 'Mai', 'Juni',
      'Juli', 'August', 'September', 'Oktober', 'November', 'Dezember'],
  SHORTMONTHS: ['Jan', 'Feb', 'Mär', 'Apr', 'Mai', 'Jun', 'Jul', 'Aug', 'Sep',
      'Okt', 'Nov', 'Dez'],
  STANDALONESHORTMONTHS: ['Jan.', 'Feb.', 'Mär', 'Apr.', 'Mai', 'Juni', 'Jul',
      'Aug', 'Sep', 'Okt', 'Nov', 'Dez'],
  WEEKDAYS: ['Sonntag', 'Montag', 'Dienstag', 'Mittwoch', 'Donnerstag',
      'Freitag', 'Samstag'],
  STANDALONEWEEKDAYS: ['Sonntag', 'Montag', 'Dienstag', 'Mittwoch',
      'Donnerstag', 'Freitag', 'Samstag'],
  SHORTWEEKDAYS: ['So.', 'Mo.', 'Di.', 'Mi.', 'Do.', 'Fr.', 'Sa.'],
  STANDALONESHORTWEEKDAYS: ['So', 'Mo', 'Di', 'Mi', 'Do', 'Fr', 'Sa'],
  NARROWWEEKDAYS: ['S', 'M', 'D', 'M', 'D', 'F', 'S'],
  STANDALONENARROWWEEKDAYS: ['S', 'M', 'D', 'M', 'D', 'F', 'S'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['1. Quartal', '2. Quartal', '3. Quartal', '4. Quartal'],
  AMPMS: ['vorm.', 'nachm.'],
  DATEFORMATS: ['EEEE, d. MMMM y', 'd. MMMM y', 'dd.MM.yyyy', 'dd.MM.yy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale de_LI.
 */
goog.i18n.DateTimeSymbols_de_LI = {
  ERAS: ['v. Chr.', 'n. Chr.'],
  ERANAMES: ['v. Chr.', 'n. Chr.'],
  NARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['Januar', 'Februar', 'März', 'April', 'Mai', 'Juni', 'Juli',
      'August', 'September', 'Oktober', 'November', 'Dezember'],
  STANDALONEMONTHS: ['Januar', 'Februar', 'März', 'April', 'Mai', 'Juni',
      'Juli', 'August', 'September', 'Oktober', 'November', 'Dezember'],
  SHORTMONTHS: ['Jan', 'Feb', 'Mär', 'Apr', 'Mai', 'Jun', 'Jul', 'Aug', 'Sep',
      'Okt', 'Nov', 'Dez'],
  STANDALONESHORTMONTHS: ['Jan.', 'Feb.', 'Mär', 'Apr.', 'Mai', 'Juni', 'Jul',
      'Aug', 'Sep', 'Okt', 'Nov', 'Dez'],
  WEEKDAYS: ['Sonntag', 'Montag', 'Dienstag', 'Mittwoch', 'Donnerstag',
      'Freitag', 'Samstag'],
  STANDALONEWEEKDAYS: ['Sonntag', 'Montag', 'Dienstag', 'Mittwoch',
      'Donnerstag', 'Freitag', 'Samstag'],
  SHORTWEEKDAYS: ['So.', 'Mo.', 'Di.', 'Mi.', 'Do.', 'Fr.', 'Sa.'],
  STANDALONESHORTWEEKDAYS: ['So', 'Mo', 'Di', 'Mi', 'Do', 'Fr', 'Sa'],
  NARROWWEEKDAYS: ['S', 'M', 'D', 'M', 'D', 'F', 'S'],
  STANDALONENARROWWEEKDAYS: ['S', 'M', 'D', 'M', 'D', 'F', 'S'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['1. Quartal', '2. Quartal', '3. Quartal', '4. Quartal'],
  AMPMS: ['vorm.', 'nachm.'],
  DATEFORMATS: ['EEEE, d. MMMM y', 'd. MMMM y', 'dd.MM.yyyy', 'dd.MM.yy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale de_LU.
 */
goog.i18n.DateTimeSymbols_de_LU = {
  ERAS: ['v. Chr.', 'n. Chr.'],
  ERANAMES: ['v. Chr.', 'n. Chr.'],
  NARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['Januar', 'Februar', 'März', 'April', 'Mai', 'Juni', 'Juli',
      'August', 'September', 'Oktober', 'November', 'Dezember'],
  STANDALONEMONTHS: ['Januar', 'Februar', 'März', 'April', 'Mai', 'Juni',
      'Juli', 'August', 'September', 'Oktober', 'November', 'Dezember'],
  SHORTMONTHS: ['Jan', 'Feb', 'Mär', 'Apr', 'Mai', 'Jun', 'Jul', 'Aug', 'Sep',
      'Okt', 'Nov', 'Dez'],
  STANDALONESHORTMONTHS: ['Jan.', 'Feb.', 'Mär', 'Apr.', 'Mai', 'Juni', 'Jul',
      'Aug', 'Sep', 'Okt', 'Nov', 'Dez'],
  WEEKDAYS: ['Sonntag', 'Montag', 'Dienstag', 'Mittwoch', 'Donnerstag',
      'Freitag', 'Samstag'],
  STANDALONEWEEKDAYS: ['Sonntag', 'Montag', 'Dienstag', 'Mittwoch',
      'Donnerstag', 'Freitag', 'Samstag'],
  SHORTWEEKDAYS: ['So.', 'Mo.', 'Di.', 'Mi.', 'Do.', 'Fr.', 'Sa.'],
  STANDALONESHORTWEEKDAYS: ['So', 'Mo', 'Di', 'Mi', 'Do', 'Fr', 'Sa'],
  NARROWWEEKDAYS: ['S', 'M', 'D', 'M', 'D', 'F', 'S'],
  STANDALONENARROWWEEKDAYS: ['S', 'M', 'D', 'M', 'D', 'F', 'S'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['1. Quartal', '2. Quartal', '3. Quartal', '4. Quartal'],
  AMPMS: ['vorm.', 'nachm.'],
  DATEFORMATS: ['EEEE, d. MMMM y', 'd. MMMM y', 'dd.MM.yyyy', 'dd.MM.yy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale dv.
 */
goog.i18n.DateTimeSymbols_dv = {
  ERAS: ['BCE', 'CE'],
  ERANAMES: ['BCE', 'CE'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONEMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11',
      '12'],
  SHORTMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONESHORTMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  WEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONEWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONESHORTWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  NARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONENARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE d MMMM y', 'd MMMM y', 'dd-MM-yyyy', 'd-M-yy'],
  TIMEFORMATS: ['hh:mm:ss a zzzz', 'hh:mm:ss a z', 'hh:mm:ss a', 'hh:mm a'],
  FIRSTDAYOFWEEK: 4,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 0
};


/**
 * Date/time formatting symbols for locale dv_MV.
 */
goog.i18n.DateTimeSymbols_dv_MV = goog.i18n.DateTimeSymbols_dv;


/**
 * Date/time formatting symbols for locale dz.
 */
goog.i18n.DateTimeSymbols_dz = {
  ERAS: ['BCE', 'CE'],
  ERANAMES: ['BCE', 'CE'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['སྤྱི་ཟླཝ་དངཔ་',
      'སྤྱི་ཟླཝ་གཉིས་པ་',
      'སྤྱི་ཟླཝ་གསུམ་པ་',
      'སྤྱི་ཟླཝ་བཞི་པ་',
      'སྤྱི་ཟླཝ་ལྔ་པ་',
      'སྤྱི་ཟླཝ་དྲུག་པ་',
      'སྤྱི་ཟླཝ་བདུན་པ་',
      'སྤྱི་ཟླཝ་བརྒྱད་པ་',
      'སྤྱི་ཟླཝ་དགུ་པ་',
      'སྤྱི་ཟླཝ་བཅུ་པ་',
      'སྤྱི་ཟླཝ་བཅུ་གཅིག་པ་',
      'སྤྱི་ཟླཝ་བཅུ་གཉིས་པ་'],
  STANDALONEMONTHS: ['སྤྱི་ཟླཝ་དངཔ་',
      'སྤྱི་ཟླཝ་གཉིས་པ་',
      'སྤྱི་ཟླཝ་གསུམ་པ་',
      'སྤྱི་ཟླཝ་བཞི་པ་',
      'སྤྱི་ཟླཝ་ལྔ་པ་',
      'སྤྱི་ཟླཝ་དྲུག་པ་',
      'སྤྱི་ཟླཝ་བདུན་པ་',
      'སྤྱི་ཟླཝ་བརྒྱད་པ་',
      'སྤྱི་ཟླཝ་དགུ་པ་',
      'སྤྱི་ཟླཝ་བཅུ་པ་',
      'སྤྱི་ཟླཝ་བཅུ་གཅིག་པ་',
      'སྤྱི་ཟླཝ་བཅུ་གཉིས་པ་'],
  SHORTMONTHS: ['ཟླ་ ༡', 'ཟླ་ ༢', 'ཟླ་ ༣',
      'ཟླ་ ༤', 'ཟླ་ ༥', 'ཟླ་ ༦', 'ཟླ་ ༧',
      'ཟླ་ ༨', 'ཟླ་ ༩', 'ཟླ་ ༡༠', 'ཟླ་ ༡༡',
      'ཟླ་ ༡༢'],
  STANDALONESHORTMONTHS: ['ཟླ་ ༡', 'ཟླ་ ༢', 'ཟླ་ ༣',
      'ཟླ་ ༤', 'ཟླ་ ༥', 'ཟླ་ ༦', 'ཟླ་ ༧',
      'ཟླ་ ༨', 'ཟླ་ ༩', 'ཟླ་ ༡༠', 'ཟླ་ ༡༡',
      'ཟླ་ ༡༢'],
  WEEKDAYS: ['གཟའ་ཟླ་བ་',
      'གཟའ་མིག་དམར་', 'གཟའ་ལྷག་པ་',
      'གཟའ་ཕུར་བུ་', 'གཟའ་པ་སངས་',
      'གཟའ་སྤེན་པ་', 'གཟའ་ཉི་མ་'],
  STANDALONEWEEKDAYS: ['གཟའ་ཟླ་བ་',
      'གཟའ་མིག་དམར་', 'གཟའ་ལྷག་པ་',
      'གཟའ་ཕུར་བུ་', 'གཟའ་པ་སངས་',
      'གཟའ་སྤེན་པ་', 'གཟའ་ཉི་མ་'],
  SHORTWEEKDAYS: ['ཟླ་', 'མིར་', 'ལྷག་', 'ཕུར་',
      'སངས་', 'སྤེན་', 'ཉི་'],
  STANDALONESHORTWEEKDAYS: ['ཟླ་', 'མིར་', 'ལྷག་',
      'ཕུར་', 'སངས་', 'སྤེན་', 'ཉི་'],
  NARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONENARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTQUARTERS: ['བཞི་དཔྱ་༡', 'བཞི་དཔྱ་༢',
      'བཞི་དཔྱ་༣', 'བཞི་དཔྱ་༤'],
  QUARTERS: ['བཞི་དཔྱ་དང་པ་',
      'བཞི་དཔྱ་གཉིས་པ་',
      'བཞི་དཔྱ་གསུམ་པ་',
      'བཞི་དཔྱ་བཞི་པ་'],
  AMPMS: ['སྔ་ཆ་', 'ཕྱི་ཆ་'],
  DATEFORMATS: ['སྤྱི་ལོ་y ཟླ་ MMMM ཚེས་ dd',
      'སྤྱི་ལོ་y ཟླ་ MMMM ཚེས་ dd',
      'སྤྱི་ལོ་y ཟླ་ MMM ཚེས་ dd', 'yyyy-MM-dd'],
  TIMEFORMATS: [
      'ཆུ་ཚོད་ h སྐར་མ་ mm སྐར་ཆཱ་ ss a zzzz',
      'ཆུ་ཚོད་ h སྐར་མ་ mm སྐར་ཆཱ་ ss a z',
      'ཆུ་ཚོད་h:mm:ss a',
      'ཆུ་ཚོད་ h སྐར་མ་ mm a'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale dz_BT.
 */
goog.i18n.DateTimeSymbols_dz_BT = goog.i18n.DateTimeSymbols_dz;


/**
 * Date/time formatting symbols for locale ee.
 */
goog.i18n.DateTimeSymbols_ee = {
  ERAS: ['HY', 'YŊ'],
  ERANAMES: ['Hafi Yesu Va Do ŋgɔ', 'Yesu Ŋɔli'],
  NARROWMONTHS: ['D', 'D', 'T', 'A', 'D', 'M', 'S', 'D', 'A', 'K', 'A', 'D'],
  STANDALONENARROWMONTHS: ['D', 'D', 'T', 'A', 'D', 'M', 'S', 'D', 'A', 'K',
      'A', 'D'],
  MONTHS: ['Dzove', 'Dzodze', 'Tedoxe', 'Afɔfiɛ', 'Dama', 'Masa', 'Siamlɔm',
      'Deasiamime', 'Anyɔnyɔ', 'Kele', 'Adeɛmekpɔxe', 'Dzome'],
  STANDALONEMONTHS: ['Dzove', 'Dzodze', 'Tedoxe', 'Afɔfiɛ', 'Dama', 'Masa',
      'Siamlɔm', 'Deasiamime', 'Anyɔnyɔ', 'Kele', 'Adeɛmekpɔxe', 'Dzome'],
  SHORTMONTHS: ['Dzv', 'Dzd', 'Ted', 'Afɔ', 'Dam', 'Mas', 'Sia', 'Dea', 'Any',
      'Kel', 'Ade', 'Dzm'],
  STANDALONESHORTMONTHS: ['Dzv', 'Dzd', 'Ted', 'Afɔ', 'Dam', 'Mas', 'Sia',
      'Dea', 'Any', 'Kel', 'Ade', 'Dzm'],
  WEEKDAYS: ['Kɔsiɖa', 'Dzoɖa', 'Braɖa', 'Kuɖa', 'Yawoɖa', 'Fiɖa',
      'Memleɖa'],
  STANDALONEWEEKDAYS: ['Kɔsiɖa', 'Dzoɖa', 'Braɖa', 'Kuɖa', 'Yawoɖa',
      'Fiɖa', 'Memleɖa'],
  SHORTWEEKDAYS: ['Kɔs Kwe', 'Dzo', 'Bra', 'Kuɖ', 'Yaw', 'Fiɖ', 'Mem'],
  STANDALONESHORTWEEKDAYS: ['Kɔs Kwe', 'Dzo', 'Bra', 'Kuɖ', 'Yaw', 'Fiɖ',
      'Mem'],
  NARROWWEEKDAYS: ['K', 'D', 'B', 'K', 'Y', 'F', 'M'],
  STANDALONENARROWWEEKDAYS: ['K', 'D', 'B', 'K', 'Y', 'F', 'M'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['AN', 'EW'],
  DATEFORMATS: ['EEEE, d MMMM y', 'd MMMM y', 'd MMM y', 'dd/MM/yyyy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale ee_GH.
 */
goog.i18n.DateTimeSymbols_ee_GH = goog.i18n.DateTimeSymbols_ee;


/**
 * Date/time formatting symbols for locale ee_TG.
 */
goog.i18n.DateTimeSymbols_ee_TG = goog.i18n.DateTimeSymbols_ee;


/**
 * Date/time formatting symbols for locale el_CY.
 */
goog.i18n.DateTimeSymbols_el_CY = {
  ERAS: ['π.Χ.', 'μ.Χ.'],
  ERANAMES: ['π.Χ.', 'μ.Χ.'],
  NARROWMONTHS: ['Ι', 'Φ', 'Μ', 'Α', 'Μ', 'Ι', 'Ι', 'Α', 'Σ', 'Ο',
      'Ν', 'Δ'],
  STANDALONENARROWMONTHS: ['Ι', 'Φ', 'Μ', 'Α', 'Μ', 'Ι', 'Ι', 'Α', 'Σ',
      'Ο', 'Ν', 'Δ'],
  MONTHS: ['Ιανουαρίου', 'Φεβρουαρίου', 'Μαρτίου',
      'Απριλίου', 'Μαΐου', 'Ιουνίου', 'Ιουλίου',
      'Αυγούστου', 'Σεπτεμβρίου', 'Οκτωβρίου',
      'Νοεμβρίου', 'Δεκεμβρίου'],
  STANDALONEMONTHS: ['Ιανουάριος', 'Φεβρουάριος',
      'Μάρτιος', 'Απρίλιος', 'Μάιος', 'Ιούνιος',
      'Ιούλιος', 'Αύγουστος', 'Σεπτέμβριος',
      'Οκτώβριος', 'Νοέμβριος', 'Δεκέμβριος'],
  SHORTMONTHS: ['Ιαν', 'Φεβ', 'Μαρ', 'Απρ', 'Μαϊ', 'Ιουν',
      'Ιουλ', 'Αυγ', 'Σεπ', 'Οκτ', 'Νοε', 'Δεκ'],
  STANDALONESHORTMONTHS: ['Ιαν', 'Φεβ', 'Μαρ', 'Απρ', 'Μαϊ',
      'Ιουν', 'Ιουλ', 'Αυγ', 'Σεπ', 'Οκτ', 'Νοε', 'Δεκ'],
  WEEKDAYS: ['Κυριακή', 'Δευτέρα', 'Τρίτη', 'Τετάρτη',
      'Πέμπτη', 'Παρασκευή', 'Σάββατο'],
  STANDALONEWEEKDAYS: ['Κυριακή', 'Δευτέρα', 'Τρίτη',
      'Τετάρτη', 'Πέμπτη', 'Παρασκευή', 'Σάββατο'],
  SHORTWEEKDAYS: ['Κυρ', 'Δευ', 'Τρι', 'Τετ', 'Πεμ', 'Παρ',
      'Σαβ'],
  STANDALONESHORTWEEKDAYS: ['Κυρ', 'Δευ', 'Τρι', 'Τετ', 'Πεμ',
      'Παρ', 'Σαβ'],
  NARROWWEEKDAYS: ['Κ', 'Δ', 'Τ', 'Τ', 'Π', 'Π', 'Σ'],
  STANDALONENARROWWEEKDAYS: ['Κ', 'Δ', 'Τ', 'Τ', 'Π', 'Π', 'Σ'],
  SHORTQUARTERS: ['Τ1', 'Τ2', 'Τ3', 'Τ4'],
  QUARTERS: ['1ο τρίμηνο', '2ο τρίμηνο', '3ο τρίμηνο',
      '4ο τρίμηνο'],
  AMPMS: ['π.μ.', 'μ.μ.'],
  DATEFORMATS: ['EEEE, d MMMM y', 'd MMMM y', 'd MMM y', 'd/M/yy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale el_GR.
 */
goog.i18n.DateTimeSymbols_el_GR = {
  ERAS: ['π.Χ.', 'μ.Χ.'],
  ERANAMES: ['π.Χ.', 'μ.Χ.'],
  NARROWMONTHS: ['Ι', 'Φ', 'Μ', 'Α', 'Μ', 'Ι', 'Ι', 'Α', 'Σ', 'Ο',
      'Ν', 'Δ'],
  STANDALONENARROWMONTHS: ['Ι', 'Φ', 'Μ', 'Α', 'Μ', 'Ι', 'Ι', 'Α', 'Σ',
      'Ο', 'Ν', 'Δ'],
  MONTHS: ['Ιανουαρίου', 'Φεβρουαρίου', 'Μαρτίου',
      'Απριλίου', 'Μαΐου', 'Ιουνίου', 'Ιουλίου',
      'Αυγούστου', 'Σεπτεμβρίου', 'Οκτωβρίου',
      'Νοεμβρίου', 'Δεκεμβρίου'],
  STANDALONEMONTHS: ['Ιανουάριος', 'Φεβρουάριος',
      'Μάρτιος', 'Απρίλιος', 'Μάιος', 'Ιούνιος',
      'Ιούλιος', 'Αύγουστος', 'Σεπτέμβριος',
      'Οκτώβριος', 'Νοέμβριος', 'Δεκέμβριος'],
  SHORTMONTHS: ['Ιαν', 'Φεβ', 'Μαρ', 'Απρ', 'Μαϊ', 'Ιουν',
      'Ιουλ', 'Αυγ', 'Σεπ', 'Οκτ', 'Νοε', 'Δεκ'],
  STANDALONESHORTMONTHS: ['Ιαν', 'Φεβ', 'Μαρ', 'Απρ', 'Μαϊ',
      'Ιουν', 'Ιουλ', 'Αυγ', 'Σεπ', 'Οκτ', 'Νοε', 'Δεκ'],
  WEEKDAYS: ['Κυριακή', 'Δευτέρα', 'Τρίτη', 'Τετάρτη',
      'Πέμπτη', 'Παρασκευή', 'Σάββατο'],
  STANDALONEWEEKDAYS: ['Κυριακή', 'Δευτέρα', 'Τρίτη',
      'Τετάρτη', 'Πέμπτη', 'Παρασκευή', 'Σάββατο'],
  SHORTWEEKDAYS: ['Κυρ', 'Δευ', 'Τρι', 'Τετ', 'Πεμ', 'Παρ',
      'Σαβ'],
  STANDALONESHORTWEEKDAYS: ['Κυρ', 'Δευ', 'Τρι', 'Τετ', 'Πεμ',
      'Παρ', 'Σαβ'],
  NARROWWEEKDAYS: ['Κ', 'Δ', 'Τ', 'Τ', 'Π', 'Π', 'Σ'],
  STANDALONENARROWWEEKDAYS: ['Κ', 'Δ', 'Τ', 'Τ', 'Π', 'Π', 'Σ'],
  SHORTQUARTERS: ['Τ1', 'Τ2', 'Τ3', 'Τ4'],
  QUARTERS: ['1ο τρίμηνο', '2ο τρίμηνο', '3ο τρίμηνο',
      '4ο τρίμηνο'],
  AMPMS: ['π.μ.', 'μ.μ.'],
  DATEFORMATS: ['EEEE, d MMMM y', 'd MMMM y', 'd MMM y', 'd/M/yy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale el_POLYTON.
 */
goog.i18n.DateTimeSymbols_el_POLYTON = {
  ERAS: ['π.Χ.', 'μ.Χ.'],
  ERANAMES: ['π.Χ.', 'μ.Χ.'],
  NARROWMONTHS: ['Ι', 'Φ', 'Μ', 'Α', 'Μ', 'Ι', 'Ι', 'Α', 'Σ', 'Ο',
      'Ν', 'Δ'],
  STANDALONENARROWMONTHS: ['Ι', 'Φ', 'Μ', 'Α', 'Μ', 'Ι', 'Ι', 'Α', 'Σ',
      'Ο', 'Ν', 'Δ'],
  MONTHS: ['Ιανουαρίου', 'Φεβρουαρίου', 'Μαρτίου',
      'Απριλίου', 'Μαΐου', 'Ιουνίου', 'Ιουλίου',
      'Αὐγούστου', 'Σεπτεμβρίου', 'Ὀκτωβρίου',
      'Νοεμβρίου', 'Δεκεμβρίου'],
  STANDALONEMONTHS: ['Ιανουάριος', 'Φεβρουάριος',
      'Μάρτιος', 'Απρίλιος', 'Μάιος', 'Ιούνιος',
      'Ιούλιος', 'Αὔγουστος', 'Σεπτέμβριος',
      'Ὀκτώβριος', 'Νοέμβριος', 'Δεκέμβριος'],
  SHORTMONTHS: ['Ιαν', 'Φεβ', 'Μαρ', 'Απρ', 'Μαϊ', 'Ιουν',
      'Ιουλ', 'Αὐγ', 'Σεπ', 'Ὀκτ', 'Νοε', 'Δεκ'],
  STANDALONESHORTMONTHS: ['Ιαν', 'Φεβ', 'Μαρ', 'Απρ', 'Μαϊ',
      'Ιουν', 'Ιουλ', 'Αὐγ', 'Σεπ', 'Ὀκτ', 'Νοε',
      'Δεκ'],
  WEEKDAYS: ['Κυριακή', 'Δευτέρα', 'Τρίτη', 'Τετάρτη',
      'Πέμπτη', 'Παρασκευή', 'Σάββατο'],
  STANDALONEWEEKDAYS: ['Κυριακή', 'Δευτέρα', 'Τρίτη',
      'Τετάρτη', 'Πέμπτη', 'Παρασκευή', 'Σάββατο'],
  SHORTWEEKDAYS: ['Κυρ', 'Δευ', 'Τρι', 'Τετ', 'Πεμ', 'Παρ',
      'Σαβ'],
  STANDALONESHORTWEEKDAYS: ['Κυρ', 'Δευ', 'Τρι', 'Τετ', 'Πεμ',
      'Παρ', 'Σαβ'],
  NARROWWEEKDAYS: ['Κ', 'Δ', 'Τ', 'Τ', 'Π', 'Π', 'Σ'],
  STANDALONENARROWWEEKDAYS: ['Κ', 'Δ', 'Τ', 'Τ', 'Π', 'Π', 'Σ'],
  SHORTQUARTERS: ['Τ1', 'Τ2', 'Τ3', 'Τ4'],
  QUARTERS: ['1ο τρίμηνο', '2ο τρίμηνο', '3ο τρίμηνο',
      '4ο τρίμηνο'],
  AMPMS: ['π.μ.', 'μ.μ.'],
  DATEFORMATS: ['EEEE, d MMMM y', 'd MMMM y', 'd MMM y', 'd/M/yy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale en_AS.
 */
goog.i18n.DateTimeSymbols_en_AS = {
  ERAS: ['BC', 'AD'],
  ERANAMES: ['Before Christ', 'Anno Domini'],
  NARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['January', 'February', 'March', 'April', 'May', 'June', 'July',
      'August', 'September', 'October', 'November', 'December'],
  STANDALONEMONTHS: ['January', 'February', 'March', 'April', 'May', 'June',
      'July', 'August', 'September', 'October', 'November', 'December'],
  SHORTMONTHS: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep',
      'Oct', 'Nov', 'Dec'],
  STANDALONESHORTMONTHS: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul',
      'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
  WEEKDAYS: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday',
      'Saturday'],
  STANDALONEWEEKDAYS: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday',
      'Friday', 'Saturday'],
  SHORTWEEKDAYS: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
  STANDALONESHORTWEEKDAYS: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
  NARROWWEEKDAYS: ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
  STANDALONENARROWWEEKDAYS: ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['1st quarter', '2nd quarter', '3rd quarter', '4th quarter'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, MMMM d, y', 'MMMM d, y', 'MMM d, y', 'M/d/yy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale en_BE.
 */
goog.i18n.DateTimeSymbols_en_BE = {
  ERAS: ['BC', 'AD'],
  ERANAMES: ['Before Christ', 'Anno Domini'],
  NARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['January', 'February', 'March', 'April', 'May', 'June', 'July',
      'August', 'September', 'October', 'November', 'December'],
  STANDALONEMONTHS: ['January', 'February', 'March', 'April', 'May', 'June',
      'July', 'August', 'September', 'October', 'November', 'December'],
  SHORTMONTHS: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep',
      'Oct', 'Nov', 'Dec'],
  STANDALONESHORTMONTHS: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul',
      'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
  WEEKDAYS: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday',
      'Saturday'],
  STANDALONEWEEKDAYS: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday',
      'Friday', 'Saturday'],
  SHORTWEEKDAYS: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
  STANDALONESHORTWEEKDAYS: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
  NARROWWEEKDAYS: ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
  STANDALONENARROWWEEKDAYS: ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['1st quarter', '2nd quarter', '3rd quarter', '4th quarter'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE d MMMM y', 'd MMM y', 'dd MMM y', 'dd/MM/yy'],
  TIMEFORMATS: ['HH \'h\' mm \'min\' ss \'s\' zzzz', 'HH:mm:ss z', 'HH:mm:ss',
      'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale en_BW.
 */
goog.i18n.DateTimeSymbols_en_BW = {
  ERAS: ['BC', 'AD'],
  ERANAMES: ['Before Christ', 'Anno Domini'],
  NARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['January', 'February', 'March', 'April', 'May', 'June', 'July',
      'August', 'September', 'October', 'November', 'December'],
  STANDALONEMONTHS: ['January', 'February', 'March', 'April', 'May', 'June',
      'July', 'August', 'September', 'October', 'November', 'December'],
  SHORTMONTHS: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep',
      'Oct', 'Nov', 'Dec'],
  STANDALONESHORTMONTHS: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul',
      'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
  WEEKDAYS: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday',
      'Saturday'],
  STANDALONEWEEKDAYS: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday',
      'Friday', 'Saturday'],
  SHORTWEEKDAYS: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
  STANDALONESHORTWEEKDAYS: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
  NARROWWEEKDAYS: ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
  STANDALONENARROWWEEKDAYS: ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['1st quarter', '2nd quarter', '3rd quarter', '4th quarter'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE dd MMMM y', 'dd MMMM y', 'MMM d, y', 'dd/MM/yy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale en_BZ.
 */
goog.i18n.DateTimeSymbols_en_BZ = {
  ERAS: ['BC', 'AD'],
  ERANAMES: ['Before Christ', 'Anno Domini'],
  NARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['January', 'February', 'March', 'April', 'May', 'June', 'July',
      'August', 'September', 'October', 'November', 'December'],
  STANDALONEMONTHS: ['January', 'February', 'March', 'April', 'May', 'June',
      'July', 'August', 'September', 'October', 'November', 'December'],
  SHORTMONTHS: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep',
      'Oct', 'Nov', 'Dec'],
  STANDALONESHORTMONTHS: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul',
      'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
  WEEKDAYS: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday',
      'Saturday'],
  STANDALONEWEEKDAYS: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday',
      'Friday', 'Saturday'],
  SHORTWEEKDAYS: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
  STANDALONESHORTWEEKDAYS: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
  NARROWWEEKDAYS: ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
  STANDALONENARROWWEEKDAYS: ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['1st quarter', '2nd quarter', '3rd quarter', '4th quarter'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['dd MMMM y', 'dd MMMM y', 'dd-MMM-y', 'dd/MM/yy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale en_CA.
 */
goog.i18n.DateTimeSymbols_en_CA = {
  ERAS: ['BC', 'AD'],
  ERANAMES: ['Before Christ', 'Anno Domini'],
  NARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['January', 'February', 'March', 'April', 'May', 'June', 'July',
      'August', 'September', 'October', 'November', 'December'],
  STANDALONEMONTHS: ['January', 'February', 'March', 'April', 'May', 'June',
      'July', 'August', 'September', 'October', 'November', 'December'],
  SHORTMONTHS: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep',
      'Oct', 'Nov', 'Dec'],
  STANDALONESHORTMONTHS: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul',
      'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
  WEEKDAYS: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday',
      'Saturday'],
  STANDALONEWEEKDAYS: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday',
      'Friday', 'Saturday'],
  SHORTWEEKDAYS: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
  STANDALONESHORTWEEKDAYS: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
  NARROWWEEKDAYS: ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
  STANDALONENARROWWEEKDAYS: ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['1st quarter', '2nd quarter', '3rd quarter', '4th quarter'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, d MMMM, y', 'd MMMM, y', 'yyyy-MM-dd', 'yy-MM-dd'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale en_Dsrt.
 */
goog.i18n.DateTimeSymbols_en_Dsrt = {
  ERAS: ['𐐒𐐗', '𐐈𐐔'],
  ERANAMES: ['𐐒𐐲𐑁𐐬𐑉 𐐗𐑉𐐴𐑅𐐻',
      '𐐈𐑌𐐬 𐐔𐐱𐑋𐐮𐑌𐐨'],
  NARROWMONTHS: ['𐐖', '𐐙', '𐐣', '𐐁', '𐐣', '𐐖', '𐐖', '𐐂',
      '𐐝', '𐐉', '𐐤', '𐐔'],
  STANDALONENARROWMONTHS: ['𐐖', '𐐙', '𐐣', '𐐁', '𐐣', '𐐖',
      '𐐖', '𐐂', '𐐝', '𐐉', '𐐤', '𐐔'],
  MONTHS: ['𐐖𐐰𐑌𐐷𐐭𐐯𐑉𐐨',
      '𐐙𐐯𐐺𐑉𐐭𐐯𐑉𐐨', '𐐣𐐪𐑉𐐽',
      '𐐁𐐹𐑉𐐮𐑊', '𐐣𐐩', '𐐖𐐭𐑌', '𐐖𐐭𐑊𐐴',
      '𐐂𐑀𐐲𐑅𐐻', '𐐝𐐯𐐹𐐻𐐯𐑋𐐺𐐲𐑉',
      '𐐉𐐿𐐻𐐬𐐺𐐲𐑉', '𐐤𐐬𐑂𐐯𐑋𐐺𐐲𐑉',
      '𐐔𐐨𐑅𐐯𐑋𐐺𐐲𐑉'],
  STANDALONEMONTHS: ['𐐖𐐰𐑌𐐷𐐭𐐯𐑉𐐨',
      '𐐙𐐯𐐺𐑉𐐭𐐯𐑉𐐨', '𐐣𐐪𐑉𐐽',
      '𐐁𐐹𐑉𐐮𐑊', '𐐣𐐩', '𐐖𐐭𐑌', '𐐖𐐭𐑊𐐴',
      '𐐂𐑀𐐲𐑅𐐻', '𐐝𐐯𐐹𐐻𐐯𐑋𐐺𐐲𐑉',
      '𐐉𐐿𐐻𐐬𐐺𐐲𐑉', '𐐤𐐬𐑂𐐯𐑋𐐺𐐲𐑉',
      '𐐔𐐨𐑅𐐯𐑋𐐺𐐲𐑉'],
  SHORTMONTHS: ['𐐖𐐰𐑌', '𐐙𐐯𐐺', '𐐣𐐪𐑉', '𐐁𐐹𐑉',
      '𐐣𐐩', '𐐖𐐭𐑌', '𐐖𐐭𐑊', '𐐂𐑀', '𐐝𐐯𐐹',
      '𐐉𐐿𐐻', '𐐤𐐬𐑂', '𐐔𐐨𐑅'],
  STANDALONESHORTMONTHS: ['𐐖𐐰𐑌', '𐐙𐐯𐐺', '𐐣𐐪𐑉',
      '𐐁𐐹𐑉', '𐐣𐐩', '𐐖𐐭𐑌', '𐐖𐐭𐑊', '𐐂𐑀',
      '𐐝𐐯𐐹', '𐐉𐐿𐐻', '𐐤𐐬𐑂', '𐐔𐐨𐑅'],
  WEEKDAYS: ['𐐝𐐲𐑌𐐼𐐩', '𐐣𐐲𐑌𐐼𐐩',
      '𐐓𐐭𐑆𐐼𐐩', '𐐎𐐯𐑌𐑆𐐼𐐩',
      '𐐛𐐲𐑉𐑆𐐼𐐩', '𐐙𐑉𐐴𐐼𐐩',
      '𐐝𐐰𐐻𐐲𐑉𐐼𐐩'],
  STANDALONEWEEKDAYS: ['𐐝𐐲𐑌𐐼𐐩', '𐐣𐐲𐑌𐐼𐐩',
      '𐐓𐐭𐑆𐐼𐐩', '𐐎𐐯𐑌𐑆𐐼𐐩',
      '𐐛𐐲𐑉𐑆𐐼𐐩', '𐐙𐑉𐐴𐐼𐐩',
      '𐐝𐐰𐐻𐐲𐑉𐐼𐐩'],
  SHORTWEEKDAYS: ['𐐝𐐲𐑌', '𐐣𐐲𐑌', '𐐓𐐭𐑆',
      '𐐎𐐯𐑌', '𐐛𐐲𐑉', '𐐙𐑉𐐴', '𐐝𐐰𐐻'],
  STANDALONESHORTWEEKDAYS: ['𐐝𐐲𐑌', '𐐣𐐲𐑌', '𐐓𐐭𐑆',
      '𐐎𐐯𐑌', '𐐛𐐲𐑉', '𐐙𐑉𐐴', '𐐝𐐰𐐻'],
  NARROWWEEKDAYS: ['𐐝', '𐐣', '𐐓', '𐐎', '𐐛', '𐐙', '𐐝'],
  STANDALONENARROWWEEKDAYS: ['𐐝', '𐐣', '𐐓', '𐐎', '𐐛', '𐐙',
      '𐐝'],
  SHORTQUARTERS: ['𐐗1', '𐐗2', '𐐗3', '𐐗4'],
  QUARTERS: ['1𐑅𐐻 𐐿𐐶𐐪𐑉𐐻𐐲𐑉',
      '2𐑌𐐼 𐐿𐐶𐐪𐑉𐐻𐐲𐑉',
      '3𐑉𐐼 𐐿𐐶𐐪𐑉𐐻𐐲𐑉',
      '4𐑉𐑃 𐐿𐐶𐐪𐑉𐐻𐐲𐑉'],
  AMPMS: ['𐐈𐐣', '𐐑𐐣'],
  DATEFORMATS: ['EEEE, MMMM d, y', 'MMMM d, y', 'MMM d, y', 'M/d/yy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale en_Dsrt_US.
 */
goog.i18n.DateTimeSymbols_en_Dsrt_US = goog.i18n.DateTimeSymbols_en_Dsrt;


/**
 * Date/time formatting symbols for locale en_GU.
 */
goog.i18n.DateTimeSymbols_en_GU = {
  ERAS: ['BC', 'AD'],
  ERANAMES: ['Before Christ', 'Anno Domini'],
  NARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['January', 'February', 'March', 'April', 'May', 'June', 'July',
      'August', 'September', 'October', 'November', 'December'],
  STANDALONEMONTHS: ['January', 'February', 'March', 'April', 'May', 'June',
      'July', 'August', 'September', 'October', 'November', 'December'],
  SHORTMONTHS: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep',
      'Oct', 'Nov', 'Dec'],
  STANDALONESHORTMONTHS: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul',
      'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
  WEEKDAYS: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday',
      'Saturday'],
  STANDALONEWEEKDAYS: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday',
      'Friday', 'Saturday'],
  SHORTWEEKDAYS: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
  STANDALONESHORTWEEKDAYS: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
  NARROWWEEKDAYS: ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
  STANDALONENARROWWEEKDAYS: ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['1st quarter', '2nd quarter', '3rd quarter', '4th quarter'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, MMMM d, y', 'MMMM d, y', 'MMM d, y', 'M/d/yy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale en_HK.
 */
goog.i18n.DateTimeSymbols_en_HK = {
  ERAS: ['BC', 'AD'],
  ERANAMES: ['Before Christ', 'Anno Domini'],
  NARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['January', 'February', 'March', 'April', 'May', 'June', 'July',
      'August', 'September', 'October', 'November', 'December'],
  STANDALONEMONTHS: ['January', 'February', 'March', 'April', 'May', 'June',
      'July', 'August', 'September', 'October', 'November', 'December'],
  SHORTMONTHS: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep',
      'Oct', 'Nov', 'Dec'],
  STANDALONESHORTMONTHS: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul',
      'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
  WEEKDAYS: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday',
      'Saturday'],
  STANDALONEWEEKDAYS: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday',
      'Friday', 'Saturday'],
  SHORTWEEKDAYS: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
  STANDALONESHORTWEEKDAYS: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
  NARROWWEEKDAYS: ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
  STANDALONENARROWWEEKDAYS: ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['1st quarter', '2nd quarter', '3rd quarter', '4th quarter'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, d MMMM, y', 'd MMMM, y', 'd MMM, y', 'd/M/yy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale en_JM.
 */
goog.i18n.DateTimeSymbols_en_JM = {
  ERAS: ['BC', 'AD'],
  ERANAMES: ['Before Christ', 'Anno Domini'],
  NARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['January', 'February', 'March', 'April', 'May', 'June', 'July',
      'August', 'September', 'October', 'November', 'December'],
  STANDALONEMONTHS: ['January', 'February', 'March', 'April', 'May', 'June',
      'July', 'August', 'September', 'October', 'November', 'December'],
  SHORTMONTHS: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep',
      'Oct', 'Nov', 'Dec'],
  STANDALONESHORTMONTHS: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul',
      'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
  WEEKDAYS: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday',
      'Saturday'],
  STANDALONEWEEKDAYS: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday',
      'Friday', 'Saturday'],
  SHORTWEEKDAYS: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
  STANDALONESHORTWEEKDAYS: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
  NARROWWEEKDAYS: ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
  STANDALONENARROWWEEKDAYS: ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['1st quarter', '2nd quarter', '3rd quarter', '4th quarter'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, MMMM d, y', 'MMMM d, y', 'MMM d, y', 'd/M/yy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale en_MH.
 */
goog.i18n.DateTimeSymbols_en_MH = {
  ERAS: ['BC', 'AD'],
  ERANAMES: ['Before Christ', 'Anno Domini'],
  NARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['January', 'February', 'March', 'April', 'May', 'June', 'July',
      'August', 'September', 'October', 'November', 'December'],
  STANDALONEMONTHS: ['January', 'February', 'March', 'April', 'May', 'June',
      'July', 'August', 'September', 'October', 'November', 'December'],
  SHORTMONTHS: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep',
      'Oct', 'Nov', 'Dec'],
  STANDALONESHORTMONTHS: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul',
      'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
  WEEKDAYS: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday',
      'Saturday'],
  STANDALONEWEEKDAYS: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday',
      'Friday', 'Saturday'],
  SHORTWEEKDAYS: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
  STANDALONESHORTWEEKDAYS: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
  NARROWWEEKDAYS: ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
  STANDALONENARROWWEEKDAYS: ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['1st quarter', '2nd quarter', '3rd quarter', '4th quarter'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, MMMM d, y', 'MMMM d, y', 'MMM d, y', 'M/d/yy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale en_MP.
 */
goog.i18n.DateTimeSymbols_en_MP = {
  ERAS: ['BC', 'AD'],
  ERANAMES: ['Before Christ', 'Anno Domini'],
  NARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['January', 'February', 'March', 'April', 'May', 'June', 'July',
      'August', 'September', 'October', 'November', 'December'],
  STANDALONEMONTHS: ['January', 'February', 'March', 'April', 'May', 'June',
      'July', 'August', 'September', 'October', 'November', 'December'],
  SHORTMONTHS: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep',
      'Oct', 'Nov', 'Dec'],
  STANDALONESHORTMONTHS: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul',
      'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
  WEEKDAYS: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday',
      'Saturday'],
  STANDALONEWEEKDAYS: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday',
      'Friday', 'Saturday'],
  SHORTWEEKDAYS: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
  STANDALONESHORTWEEKDAYS: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
  NARROWWEEKDAYS: ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
  STANDALONENARROWWEEKDAYS: ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['1st quarter', '2nd quarter', '3rd quarter', '4th quarter'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, MMMM d, y', 'MMMM d, y', 'MMM d, y', 'M/d/yy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale en_MT.
 */
goog.i18n.DateTimeSymbols_en_MT = {
  ERAS: ['BC', 'AD'],
  ERANAMES: ['Before Christ', 'Anno Domini'],
  NARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['January', 'February', 'March', 'April', 'May', 'June', 'July',
      'August', 'September', 'October', 'November', 'December'],
  STANDALONEMONTHS: ['January', 'February', 'March', 'April', 'May', 'June',
      'July', 'August', 'September', 'October', 'November', 'December'],
  SHORTMONTHS: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep',
      'Oct', 'Nov', 'Dec'],
  STANDALONESHORTMONTHS: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul',
      'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
  WEEKDAYS: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday',
      'Saturday'],
  STANDALONEWEEKDAYS: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday',
      'Friday', 'Saturday'],
  SHORTWEEKDAYS: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
  STANDALONESHORTWEEKDAYS: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
  NARROWWEEKDAYS: ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
  STANDALONENARROWWEEKDAYS: ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['1st quarter', '2nd quarter', '3rd quarter', '4th quarter'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, d MMMM y', 'dd MMMM y', 'dd MMM y', 'dd/MM/yyyy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale en_NA.
 */
goog.i18n.DateTimeSymbols_en_NA = {
  ERAS: ['BC', 'AD'],
  ERANAMES: ['Before Christ', 'Anno Domini'],
  NARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['January', 'February', 'March', 'April', 'May', 'June', 'July',
      'August', 'September', 'October', 'November', 'December'],
  STANDALONEMONTHS: ['January', 'February', 'March', 'April', 'May', 'June',
      'July', 'August', 'September', 'October', 'November', 'December'],
  SHORTMONTHS: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep',
      'Oct', 'Nov', 'Dec'],
  STANDALONESHORTMONTHS: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul',
      'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
  WEEKDAYS: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday',
      'Saturday'],
  STANDALONEWEEKDAYS: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday',
      'Friday', 'Saturday'],
  SHORTWEEKDAYS: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
  STANDALONESHORTWEEKDAYS: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
  NARROWWEEKDAYS: ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
  STANDALONENARROWWEEKDAYS: ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['1st quarter', '2nd quarter', '3rd quarter', '4th quarter'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, MMMM d, y', 'MMMM d, y', 'MMM d, y', 'M/d/yy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale en_NZ.
 */
goog.i18n.DateTimeSymbols_en_NZ = {
  ERAS: ['BC', 'AD'],
  ERANAMES: ['Before Christ', 'Anno Domini'],
  NARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['January', 'February', 'March', 'April', 'May', 'June', 'July',
      'August', 'September', 'October', 'November', 'December'],
  STANDALONEMONTHS: ['January', 'February', 'March', 'April', 'May', 'June',
      'July', 'August', 'September', 'October', 'November', 'December'],
  SHORTMONTHS: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep',
      'Oct', 'Nov', 'Dec'],
  STANDALONESHORTMONTHS: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul',
      'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
  WEEKDAYS: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday',
      'Saturday'],
  STANDALONEWEEKDAYS: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday',
      'Friday', 'Saturday'],
  SHORTWEEKDAYS: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
  STANDALONESHORTWEEKDAYS: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
  NARROWWEEKDAYS: ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
  STANDALONENARROWWEEKDAYS: ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['1st quarter', '2nd quarter', '3rd quarter', '4th quarter'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, d MMMM y', 'd MMMM y', 'd/MM/yyyy', 'd/MM/yy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale en_PH.
 */
goog.i18n.DateTimeSymbols_en_PH = {
  ERAS: ['BC', 'AD'],
  ERANAMES: ['Before Christ', 'Anno Domini'],
  NARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['January', 'February', 'March', 'April', 'May', 'June', 'July',
      'August', 'September', 'October', 'November', 'December'],
  STANDALONEMONTHS: ['January', 'February', 'March', 'April', 'May', 'June',
      'July', 'August', 'September', 'October', 'November', 'December'],
  SHORTMONTHS: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep',
      'Oct', 'Nov', 'Dec'],
  STANDALONESHORTMONTHS: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul',
      'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
  WEEKDAYS: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday',
      'Saturday'],
  STANDALONEWEEKDAYS: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday',
      'Friday', 'Saturday'],
  SHORTWEEKDAYS: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
  STANDALONESHORTWEEKDAYS: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
  NARROWWEEKDAYS: ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
  STANDALONENARROWWEEKDAYS: ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['1st quarter', '2nd quarter', '3rd quarter', '4th quarter'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, MMMM d, y', 'MMMM d, y', 'MMM d, y', 'M/d/yy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale en_PK.
 */
goog.i18n.DateTimeSymbols_en_PK = {
  ERAS: ['BC', 'AD'],
  ERANAMES: ['Before Christ', 'Anno Domini'],
  NARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['January', 'February', 'March', 'April', 'May', 'June', 'July',
      'August', 'September', 'October', 'November', 'December'],
  STANDALONEMONTHS: ['January', 'February', 'March', 'April', 'May', 'June',
      'July', 'August', 'September', 'October', 'November', 'December'],
  SHORTMONTHS: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep',
      'Oct', 'Nov', 'Dec'],
  STANDALONESHORTMONTHS: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul',
      'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
  WEEKDAYS: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday',
      'Saturday'],
  STANDALONEWEEKDAYS: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday',
      'Friday', 'Saturday'],
  SHORTWEEKDAYS: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
  STANDALONESHORTWEEKDAYS: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
  NARROWWEEKDAYS: ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
  STANDALONENARROWWEEKDAYS: ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['1st quarter', '2nd quarter', '3rd quarter', '4th quarter'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE d MMMM y', 'd MMMM y', 'dd-MMM-y', 'dd/MM/yy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale en_Shaw.
 */
goog.i18n.DateTimeSymbols_en_Shaw = {
  ERAS: ['𐑚·𐑒', '𐑨𐑛'],
  ERANAMES: ['𐑚𐑰𐑓𐑪𐑮 ·𐑒𐑮𐑲𐑕𐑑',
      '𐑨𐑙𐑴 𐑛𐑪𐑥𐑦𐑙𐑰'],
  NARROWMONTHS: ['𐑡', '𐑓', '𐑥', '𐑱', '𐑥', '𐑡', '𐑡', '𐑪',
      '𐑕', '𐑷', '𐑯', '𐑛'],
  STANDALONENARROWMONTHS: ['𐑡', '𐑓', '𐑥', '𐑱', '𐑥', '𐑡',
      '𐑡', '𐑪', '𐑕', '𐑷', '𐑯', '𐑛'],
  MONTHS: ['·𐑡𐑨𐑙𐑘𐑭𐑢𐑺𐑰',
      '·𐑓𐑧𐑚𐑘𐑵𐑢𐑺𐑰', '·𐑥𐑸𐑗',
      '·𐑱𐑐𐑮𐑭𐑤', '·𐑥𐑱', '·𐑡𐑵𐑯',
      '·𐑡𐑫𐑤𐑲', '·𐑪𐑜𐑭𐑕𐑑',
      '·𐑕𐑧𐑐𐑑𐑧𐑥𐑚𐑸', '·𐑷𐑒𐑑𐑴𐑚𐑸',
      '·𐑯𐑴𐑝𐑧𐑥𐑚𐑸', '·𐑛𐑭𐑕𐑧𐑥𐑚𐑸'],
  STANDALONEMONTHS: ['·𐑡𐑨𐑙𐑘𐑭𐑢𐑺𐑰',
      '·𐑓𐑧𐑚𐑘𐑵𐑢𐑺𐑰', '·𐑥𐑸𐑗',
      '·𐑱𐑐𐑮𐑭𐑤', '·𐑥𐑱', '·𐑡𐑵𐑯',
      '·𐑡𐑫𐑤𐑲', '·𐑪𐑜𐑭𐑕𐑑',
      '·𐑕𐑧𐑐𐑑𐑧𐑥𐑚𐑸', '·𐑷𐑒𐑑𐑴𐑚𐑸',
      '·𐑯𐑴𐑝𐑧𐑥𐑚𐑸', '·𐑛𐑭𐑕𐑧𐑥𐑚𐑸'],
  SHORTMONTHS: ['·𐑡𐑨', '·𐑓𐑧', '·𐑥𐑸', '·𐑱𐑐',
      '·𐑥𐑱', '·𐑡𐑵', '·𐑡𐑫', '·𐑪𐑜', '·𐑕𐑧',
      '·𐑷𐑒', '·𐑯𐑴', '·𐑛𐑭'],
  STANDALONESHORTMONTHS: ['·𐑡𐑨', '·𐑓𐑧', '·𐑥𐑸',
      '·𐑱𐑐', '·𐑥𐑱', '·𐑡𐑵', '·𐑡𐑫', '·𐑪𐑜',
      '·𐑕𐑧', '·𐑷𐑒', '·𐑯𐑴', '·𐑛𐑭'],
  WEEKDAYS: ['·𐑕𐑭𐑙𐑛𐑱', '·𐑥𐑭𐑙𐑛𐑱',
      '·𐑑𐑵𐑟𐑛𐑱', '·𐑢𐑧𐑙𐑟𐑛𐑱',
      '·𐑔𐑻𐑟𐑛𐑱', '·𐑓𐑮𐑲𐑛𐑱',
      '·𐑕𐑨𐑛𐑻𐑛𐑱'],
  STANDALONEWEEKDAYS: ['·𐑕𐑭𐑙𐑛𐑱', '·𐑥𐑭𐑙𐑛𐑱',
      '·𐑑𐑵𐑟𐑛𐑱', '·𐑢𐑧𐑙𐑟𐑛𐑱',
      '·𐑔𐑻𐑟𐑛𐑱', '·𐑓𐑮𐑲𐑛𐑱',
      '·𐑕𐑨𐑛𐑻𐑛𐑱'],
  SHORTWEEKDAYS: ['·𐑕𐑭', '·𐑥𐑭', '·𐑑𐑵', '·𐑢𐑧',
      '·𐑔𐑻', '·𐑓𐑮', '·𐑕𐑨'],
  STANDALONESHORTWEEKDAYS: ['·𐑕𐑭', '·𐑥𐑭', '·𐑑𐑵',
      '·𐑢𐑧', '·𐑔𐑻', '·𐑓𐑮', '·𐑕𐑨'],
  NARROWWEEKDAYS: ['𐑕', '𐑥', '𐑑', '𐑢', '𐑔', '𐑓', '𐑕'],
  STANDALONENARROWWEEKDAYS: ['𐑕', '𐑥', '𐑑', '𐑢', '𐑔', '𐑓',
      '𐑕'],
  SHORTQUARTERS: ['𐑒1', '𐑒2', '𐑒3', '𐑒4'],
  QUARTERS: ['1𐑕𐑑 𐑒𐑢𐑸𐑛𐑸', '2𐑯𐑛 𐑒𐑢𐑸𐑛𐑸',
      '3𐑻𐑛 𐑒𐑢𐑸𐑛𐑸', '4𐑹𐑔 𐑒𐑢𐑸𐑛𐑸'],
  AMPMS: ['𐑨𐑥', '𐑐𐑥'],
  DATEFORMATS: ['EEEE, MMMM d, y', 'MMMM d, y', 'MMM d, y', 'M/d/yy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale en_TT.
 */
goog.i18n.DateTimeSymbols_en_TT = {
  ERAS: ['BC', 'AD'],
  ERANAMES: ['Before Christ', 'Anno Domini'],
  NARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['January', 'February', 'March', 'April', 'May', 'June', 'July',
      'August', 'September', 'October', 'November', 'December'],
  STANDALONEMONTHS: ['January', 'February', 'March', 'April', 'May', 'June',
      'July', 'August', 'September', 'October', 'November', 'December'],
  SHORTMONTHS: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep',
      'Oct', 'Nov', 'Dec'],
  STANDALONESHORTMONTHS: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul',
      'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
  WEEKDAYS: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday',
      'Saturday'],
  STANDALONEWEEKDAYS: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday',
      'Friday', 'Saturday'],
  SHORTWEEKDAYS: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
  STANDALONESHORTWEEKDAYS: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
  NARROWWEEKDAYS: ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
  STANDALONENARROWWEEKDAYS: ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['1st quarter', '2nd quarter', '3rd quarter', '4th quarter'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, MMMM d, y', 'MMMM d, y', 'MMM d, y', 'M/d/yy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale en_UM.
 */
goog.i18n.DateTimeSymbols_en_UM = {
  ERAS: ['BC', 'AD'],
  ERANAMES: ['Before Christ', 'Anno Domini'],
  NARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['January', 'February', 'March', 'April', 'May', 'June', 'July',
      'August', 'September', 'October', 'November', 'December'],
  STANDALONEMONTHS: ['January', 'February', 'March', 'April', 'May', 'June',
      'July', 'August', 'September', 'October', 'November', 'December'],
  SHORTMONTHS: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep',
      'Oct', 'Nov', 'Dec'],
  STANDALONESHORTMONTHS: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul',
      'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
  WEEKDAYS: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday',
      'Saturday'],
  STANDALONEWEEKDAYS: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday',
      'Friday', 'Saturday'],
  SHORTWEEKDAYS: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
  STANDALONESHORTWEEKDAYS: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
  NARROWWEEKDAYS: ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
  STANDALONENARROWWEEKDAYS: ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['1st quarter', '2nd quarter', '3rd quarter', '4th quarter'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, MMMM d, y', 'MMMM d, y', 'MMM d, y', 'M/d/yy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale en_VI.
 */
goog.i18n.DateTimeSymbols_en_VI = {
  ERAS: ['BC', 'AD'],
  ERANAMES: ['Before Christ', 'Anno Domini'],
  NARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['January', 'February', 'March', 'April', 'May', 'June', 'July',
      'August', 'September', 'October', 'November', 'December'],
  STANDALONEMONTHS: ['January', 'February', 'March', 'April', 'May', 'June',
      'July', 'August', 'September', 'October', 'November', 'December'],
  SHORTMONTHS: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep',
      'Oct', 'Nov', 'Dec'],
  STANDALONESHORTMONTHS: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul',
      'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
  WEEKDAYS: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday',
      'Saturday'],
  STANDALONEWEEKDAYS: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday',
      'Friday', 'Saturday'],
  SHORTWEEKDAYS: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
  STANDALONESHORTWEEKDAYS: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
  NARROWWEEKDAYS: ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
  STANDALONENARROWWEEKDAYS: ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['1st quarter', '2nd quarter', '3rd quarter', '4th quarter'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, MMMM d, y', 'MMMM d, y', 'MMM d, y', 'M/d/yy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale en_ZW.
 */
goog.i18n.DateTimeSymbols_en_ZW = {
  ERAS: ['BC', 'AD'],
  ERANAMES: ['Before Christ', 'Anno Domini'],
  NARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['January', 'February', 'March', 'April', 'May', 'June', 'July',
      'August', 'September', 'October', 'November', 'December'],
  STANDALONEMONTHS: ['January', 'February', 'March', 'April', 'May', 'June',
      'July', 'August', 'September', 'October', 'November', 'December'],
  SHORTMONTHS: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep',
      'Oct', 'Nov', 'Dec'],
  STANDALONESHORTMONTHS: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul',
      'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
  WEEKDAYS: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday',
      'Saturday'],
  STANDALONEWEEKDAYS: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday',
      'Friday', 'Saturday'],
  SHORTWEEKDAYS: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
  STANDALONESHORTWEEKDAYS: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
  NARROWWEEKDAYS: ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
  STANDALONENARROWWEEKDAYS: ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['1st quarter', '2nd quarter', '3rd quarter', '4th quarter'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE dd MMMM y', 'dd MMMM y', 'dd MMM,y', 'd/M/yyyy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale eo.
 */
goog.i18n.DateTimeSymbols_eo = {
  ERAS: ['aK', 'pK'],
  ERANAMES: ['aK', 'pK'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['januaro', 'februaro', 'marto', 'aprilo', 'majo', 'junio', 'julio',
      'aŭgusto', 'septembro', 'oktobro', 'novembro', 'decembro'],
  STANDALONEMONTHS: ['januaro', 'februaro', 'marto', 'aprilo', 'majo', 'junio',
      'julio', 'aŭgusto', 'septembro', 'oktobro', 'novembro', 'decembro'],
  SHORTMONTHS: ['jan', 'feb', 'mar', 'apr', 'maj', 'jun', 'jul', 'aŭg', 'sep',
      'okt', 'nov', 'dec'],
  STANDALONESHORTMONTHS: ['jan', 'feb', 'mar', 'apr', 'maj', 'jun', 'jul',
      'aŭg', 'sep', 'okt', 'nov', 'dec'],
  WEEKDAYS: ['dimanĉo', 'lundo', 'mardo', 'merkredo', 'ĵaŭdo', 'vendredo',
      'sabato'],
  STANDALONEWEEKDAYS: ['dimanĉo', 'lundo', 'mardo', 'merkredo', 'ĵaŭdo',
      'vendredo', 'sabato'],
  SHORTWEEKDAYS: ['di', 'lu', 'ma', 'me', 'ĵa', 've', 'sa'],
  STANDALONESHORTWEEKDAYS: ['di', 'lu', 'ma', 'me', 'ĵa', 've', 'sa'],
  NARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONENARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTQUARTERS: ['K1', 'K2', 'K3', 'K4'],
  QUARTERS: ['1a kvaronjaro', '2a kvaronjaro', '3a kvaronjaro',
      '4a kvaronjaro'],
  AMPMS: ['atm', 'ptm'],
  DATEFORMATS: ['EEEE, d-\'a\' \'de\' MMMM y', 'y-MMMM-dd', 'y-MMM-dd',
      'yy-MM-dd'],
  TIMEFORMATS: ['H-\'a\' \'horo\' \'kaj\' m:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss',
      'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale es_AR.
 */
goog.i18n.DateTimeSymbols_es_AR = {
  ERAS: ['a.C.', 'd.C.'],
  ERANAMES: ['antes de Cristo', 'anno Dómini'],
  NARROWMONTHS: ['E', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['E', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio', 'julio',
      'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre'],
  STANDALONEMONTHS: ['enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio',
      'julio', 'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre'],
  SHORTMONTHS: ['ene', 'feb', 'mar', 'abr', 'may', 'jun', 'jul', 'ago', 'sep',
      'oct', 'nov', 'dic'],
  STANDALONESHORTMONTHS: ['ene', 'feb', 'mar', 'abr', 'may', 'jun', 'jul',
      'ago', 'sep', 'oct', 'nov', 'dic'],
  WEEKDAYS: ['domingo', 'lunes', 'martes', 'miércoles', 'jueves', 'viernes',
      'sábado'],
  STANDALONEWEEKDAYS: ['domingo', 'lunes', 'martes', 'miércoles', 'jueves',
      'viernes', 'sábado'],
  SHORTWEEKDAYS: ['dom', 'lun', 'mar', 'mié', 'jue', 'vie', 'sáb'],
  STANDALONESHORTWEEKDAYS: ['dom', 'lun', 'mar', 'mié', 'jue', 'vie', 'sáb'],
  NARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  STANDALONENARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  SHORTQUARTERS: ['T1', 'T2', 'T3', 'T4'],
  QUARTERS: ['1er trimestre', '2º trimestre', '3er trimestre',
      '4º trimestre'],
  AMPMS: ['a.m.', 'p.m.'],
  DATEFORMATS: ['EEEE d \'de\' MMMM \'de\' y', 'd \'de\' MMMM \'de\' y',
      'dd/MM/yyyy', 'dd/MM/yy'],
  TIMEFORMATS: ['HH\'h\'\'\'mm:ss zzzz', 'H:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale es_BO.
 */
goog.i18n.DateTimeSymbols_es_BO = {
  ERAS: ['a.C.', 'd.C.'],
  ERANAMES: ['antes de Cristo', 'anno Dómini'],
  NARROWMONTHS: ['E', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['E', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio', 'julio',
      'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre'],
  STANDALONEMONTHS: ['enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio',
      'julio', 'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre'],
  SHORTMONTHS: ['ene', 'feb', 'mar', 'abr', 'may', 'jun', 'jul', 'ago', 'sep',
      'oct', 'nov', 'dic'],
  STANDALONESHORTMONTHS: ['ene', 'feb', 'mar', 'abr', 'may', 'jun', 'jul',
      'ago', 'sep', 'oct', 'nov', 'dic'],
  WEEKDAYS: ['domingo', 'lunes', 'martes', 'miércoles', 'jueves', 'viernes',
      'sábado'],
  STANDALONEWEEKDAYS: ['domingo', 'lunes', 'martes', 'miércoles', 'jueves',
      'viernes', 'sábado'],
  SHORTWEEKDAYS: ['dom', 'lun', 'mar', 'mié', 'jue', 'vie', 'sáb'],
  STANDALONESHORTWEEKDAYS: ['dom', 'lun', 'mar', 'mié', 'jue', 'vie', 'sáb'],
  NARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  STANDALONENARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  SHORTQUARTERS: ['T1', 'T2', 'T3', 'T4'],
  QUARTERS: ['1er trimestre', '2º trimestre', '3er trimestre',
      '4º trimestre'],
  AMPMS: ['a.m.', 'p.m.'],
  DATEFORMATS: ['EEEE d \'de\' MMMM \'de\' y', 'd \'de\' MMMM \'de\' y',
      'dd/MM/yyyy', 'dd/MM/yy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale es_CL.
 */
goog.i18n.DateTimeSymbols_es_CL = {
  ERAS: ['a.C.', 'd.C.'],
  ERANAMES: ['antes de Cristo', 'anno Dómini'],
  NARROWMONTHS: ['E', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['E', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio', 'julio',
      'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre'],
  STANDALONEMONTHS: ['enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio',
      'julio', 'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre'],
  SHORTMONTHS: ['ene', 'feb', 'mar', 'abr', 'may', 'jun', 'jul', 'ago', 'sep',
      'oct', 'nov', 'dic'],
  STANDALONESHORTMONTHS: ['ene', 'feb', 'mar', 'abr', 'may', 'jun', 'jul',
      'ago', 'sep', 'oct', 'nov', 'dic'],
  WEEKDAYS: ['domingo', 'lunes', 'martes', 'miércoles', 'jueves', 'viernes',
      'sábado'],
  STANDALONEWEEKDAYS: ['domingo', 'lunes', 'martes', 'miércoles', 'jueves',
      'viernes', 'sábado'],
  SHORTWEEKDAYS: ['dom', 'lun', 'mar', 'mié', 'jue', 'vie', 'sáb'],
  STANDALONESHORTWEEKDAYS: ['dom', 'lun', 'mar', 'mié', 'jue', 'vie', 'sáb'],
  NARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  STANDALONENARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  SHORTQUARTERS: ['T1', 'T2', 'T3', 'T4'],
  QUARTERS: ['1er trimestre', '2º trimestre', '3er trimestre',
      '4º trimestre'],
  AMPMS: ['a.m.', 'p.m.'],
  DATEFORMATS: ['EEEE d \'de\' MMMM \'de\' y', 'd \'de\' MMMM \'de\' y',
      'dd-MM-yyyy', 'dd-MM-yy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'H:mm:ss z', 'H:mm:ss', 'H:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale es_CO.
 */
goog.i18n.DateTimeSymbols_es_CO = {
  ERAS: ['a.C.', 'd.C.'],
  ERANAMES: ['antes de Cristo', 'anno Dómini'],
  NARROWMONTHS: ['E', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['E', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio', 'julio',
      'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre'],
  STANDALONEMONTHS: ['enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio',
      'julio', 'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre'],
  SHORTMONTHS: ['ene', 'feb', 'mar', 'abr', 'may', 'jun', 'jul', 'ago', 'sep',
      'oct', 'nov', 'dic'],
  STANDALONESHORTMONTHS: ['ene', 'feb', 'mar', 'abr', 'may', 'jun', 'jul',
      'ago', 'sep', 'oct', 'nov', 'dic'],
  WEEKDAYS: ['domingo', 'lunes', 'martes', 'miércoles', 'jueves', 'viernes',
      'sábado'],
  STANDALONEWEEKDAYS: ['domingo', 'lunes', 'martes', 'miércoles', 'jueves',
      'viernes', 'sábado'],
  SHORTWEEKDAYS: ['dom', 'lun', 'mar', 'mié', 'jue', 'vie', 'sáb'],
  STANDALONESHORTWEEKDAYS: ['dom', 'lun', 'mar', 'mié', 'jue', 'vie', 'sáb'],
  NARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  STANDALONENARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  SHORTQUARTERS: ['T1', 'T2', 'T3', 'T4'],
  QUARTERS: ['1er trimestre', '2º trimestre', '3er trimestre',
      '4º trimestre'],
  AMPMS: ['a.m.', 'p.m.'],
  DATEFORMATS: ['EEEE d \'de\' MMMM \'de\' y', 'd \'de\' MMMM \'de\' y',
      'd/MM/yyyy', 'd/MM/yy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'H:mm:ss z', 'H:mm:ss', 'H:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale es_CR.
 */
goog.i18n.DateTimeSymbols_es_CR = {
  ERAS: ['a.C.', 'd.C.'],
  ERANAMES: ['antes de Cristo', 'anno Dómini'],
  NARROWMONTHS: ['E', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['E', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio', 'julio',
      'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre'],
  STANDALONEMONTHS: ['enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio',
      'julio', 'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre'],
  SHORTMONTHS: ['ene', 'feb', 'mar', 'abr', 'may', 'jun', 'jul', 'ago', 'sep',
      'oct', 'nov', 'dic'],
  STANDALONESHORTMONTHS: ['ene', 'feb', 'mar', 'abr', 'may', 'jun', 'jul',
      'ago', 'sep', 'oct', 'nov', 'dic'],
  WEEKDAYS: ['domingo', 'lunes', 'martes', 'miércoles', 'jueves', 'viernes',
      'sábado'],
  STANDALONEWEEKDAYS: ['domingo', 'lunes', 'martes', 'miércoles', 'jueves',
      'viernes', 'sábado'],
  SHORTWEEKDAYS: ['dom', 'lun', 'mar', 'mié', 'jue', 'vie', 'sáb'],
  STANDALONESHORTWEEKDAYS: ['dom', 'lun', 'mar', 'mié', 'jue', 'vie', 'sáb'],
  NARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  STANDALONENARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  SHORTQUARTERS: ['T1', 'T2', 'T3', 'T4'],
  QUARTERS: ['1er trimestre', '2º trimestre', '3er trimestre',
      '4º trimestre'],
  AMPMS: ['a.m.', 'p.m.'],
  DATEFORMATS: ['EEEE d \'de\' MMMM \'de\' y', 'd \'de\' MMMM \'de\' y',
      'dd/MM/yyyy', 'dd/MM/yy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale es_DO.
 */
goog.i18n.DateTimeSymbols_es_DO = {
  ERAS: ['a.C.', 'd.C.'],
  ERANAMES: ['antes de Cristo', 'anno Dómini'],
  NARROWMONTHS: ['E', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['E', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio', 'julio',
      'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre'],
  STANDALONEMONTHS: ['enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio',
      'julio', 'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre'],
  SHORTMONTHS: ['ene', 'feb', 'mar', 'abr', 'may', 'jun', 'jul', 'ago', 'sep',
      'oct', 'nov', 'dic'],
  STANDALONESHORTMONTHS: ['ene', 'feb', 'mar', 'abr', 'may', 'jun', 'jul',
      'ago', 'sep', 'oct', 'nov', 'dic'],
  WEEKDAYS: ['domingo', 'lunes', 'martes', 'miércoles', 'jueves', 'viernes',
      'sábado'],
  STANDALONEWEEKDAYS: ['domingo', 'lunes', 'martes', 'miércoles', 'jueves',
      'viernes', 'sábado'],
  SHORTWEEKDAYS: ['dom', 'lun', 'mar', 'mié', 'jue', 'vie', 'sáb'],
  STANDALONESHORTWEEKDAYS: ['dom', 'lun', 'mar', 'mié', 'jue', 'vie', 'sáb'],
  NARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  STANDALONENARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  SHORTQUARTERS: ['T1', 'T2', 'T3', 'T4'],
  QUARTERS: ['1er trimestre', '2º trimestre', '3er trimestre',
      '4º trimestre'],
  AMPMS: ['a.m.', 'p.m.'],
  DATEFORMATS: ['EEEE d \'de\' MMMM \'de\' y', 'd \'de\' MMMM \'de\' y',
      'dd/MM/yyyy', 'dd/MM/yy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale es_EC.
 */
goog.i18n.DateTimeSymbols_es_EC = {
  ERAS: ['a.C.', 'd.C.'],
  ERANAMES: ['antes de Cristo', 'anno Dómini'],
  NARROWMONTHS: ['E', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['E', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio', 'julio',
      'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre'],
  STANDALONEMONTHS: ['enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio',
      'julio', 'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre'],
  SHORTMONTHS: ['ene', 'feb', 'mar', 'abr', 'may', 'jun', 'jul', 'ago', 'sep',
      'oct', 'nov', 'dic'],
  STANDALONESHORTMONTHS: ['ene', 'feb', 'mar', 'abr', 'may', 'jun', 'jul',
      'ago', 'sep', 'oct', 'nov', 'dic'],
  WEEKDAYS: ['domingo', 'lunes', 'martes', 'miércoles', 'jueves', 'viernes',
      'sábado'],
  STANDALONEWEEKDAYS: ['domingo', 'lunes', 'martes', 'miércoles', 'jueves',
      'viernes', 'sábado'],
  SHORTWEEKDAYS: ['dom', 'lun', 'mar', 'mié', 'jue', 'vie', 'sáb'],
  STANDALONESHORTWEEKDAYS: ['dom', 'lun', 'mar', 'mié', 'jue', 'vie', 'sáb'],
  NARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  STANDALONENARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  SHORTQUARTERS: ['T1', 'T2', 'T3', 'T4'],
  QUARTERS: ['1er trimestre', '2º trimestre', '3er trimestre',
      '4º trimestre'],
  AMPMS: ['a.m.', 'p.m.'],
  DATEFORMATS: ['EEEE d \'de\' MMMM \'de\' y', 'd \'de\' MMMM \'de\' y',
      'dd/MM/yyyy', 'dd/MM/yy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'H:mm:ss z', 'H:mm:ss', 'H:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale es_ES.
 */
goog.i18n.DateTimeSymbols_es_ES = {
  ERAS: ['a.C.', 'd.C.'],
  ERANAMES: ['antes de Cristo', 'anno Dómini'],
  NARROWMONTHS: ['E', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['E', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio', 'julio',
      'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre'],
  STANDALONEMONTHS: ['enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio',
      'julio', 'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre'],
  SHORTMONTHS: ['ene', 'feb', 'mar', 'abr', 'may', 'jun', 'jul', 'ago', 'sep',
      'oct', 'nov', 'dic'],
  STANDALONESHORTMONTHS: ['ene', 'feb', 'mar', 'abr', 'may', 'jun', 'jul',
      'ago', 'sep', 'oct', 'nov', 'dic'],
  WEEKDAYS: ['domingo', 'lunes', 'martes', 'miércoles', 'jueves', 'viernes',
      'sábado'],
  STANDALONEWEEKDAYS: ['domingo', 'lunes', 'martes', 'miércoles', 'jueves',
      'viernes', 'sábado'],
  SHORTWEEKDAYS: ['dom', 'lun', 'mar', 'mié', 'jue', 'vie', 'sáb'],
  STANDALONESHORTWEEKDAYS: ['dom', 'lun', 'mar', 'mié', 'jue', 'vie', 'sáb'],
  NARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  STANDALONENARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  SHORTQUARTERS: ['T1', 'T2', 'T3', 'T4'],
  QUARTERS: ['1er trimestre', '2º trimestre', '3er trimestre',
      '4º trimestre'],
  AMPMS: ['a.m.', 'p.m.'],
  DATEFORMATS: ['EEEE d \'de\' MMMM \'de\' y', 'd \'de\' MMMM \'de\' y',
      'dd/MM/yyyy', 'dd/MM/yy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale es_GT.
 */
goog.i18n.DateTimeSymbols_es_GT = {
  ERAS: ['a.C.', 'd.C.'],
  ERANAMES: ['antes de Cristo', 'anno Dómini'],
  NARROWMONTHS: ['E', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['E', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio', 'julio',
      'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre'],
  STANDALONEMONTHS: ['enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio',
      'julio', 'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre'],
  SHORTMONTHS: ['ene', 'feb', 'mar', 'abr', 'may', 'jun', 'jul', 'ago', 'sep',
      'oct', 'nov', 'dic'],
  STANDALONESHORTMONTHS: ['ene', 'feb', 'mar', 'abr', 'may', 'jun', 'jul',
      'ago', 'sep', 'oct', 'nov', 'dic'],
  WEEKDAYS: ['domingo', 'lunes', 'martes', 'miércoles', 'jueves', 'viernes',
      'sábado'],
  STANDALONEWEEKDAYS: ['domingo', 'lunes', 'martes', 'miércoles', 'jueves',
      'viernes', 'sábado'],
  SHORTWEEKDAYS: ['dom', 'lun', 'mar', 'mié', 'jue', 'vie', 'sáb'],
  STANDALONESHORTWEEKDAYS: ['dom', 'lun', 'mar', 'mié', 'jue', 'vie', 'sáb'],
  NARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  STANDALONENARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  SHORTQUARTERS: ['T1', 'T2', 'T3', 'T4'],
  QUARTERS: ['1er trimestre', '2º trimestre', '3er trimestre',
      '4º trimestre'],
  AMPMS: ['a.m.', 'p.m.'],
  DATEFORMATS: ['EEEE d \'de\' MMMM \'de\' y', 'd \'de\' MMMM \'de\' y',
      'd/MM/yyyy', 'd/MM/yy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale es_HN.
 */
goog.i18n.DateTimeSymbols_es_HN = {
  ERAS: ['a.C.', 'd.C.'],
  ERANAMES: ['antes de Cristo', 'anno Dómini'],
  NARROWMONTHS: ['E', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['E', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio', 'julio',
      'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre'],
  STANDALONEMONTHS: ['enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio',
      'julio', 'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre'],
  SHORTMONTHS: ['ene', 'feb', 'mar', 'abr', 'may', 'jun', 'jul', 'ago', 'sep',
      'oct', 'nov', 'dic'],
  STANDALONESHORTMONTHS: ['ene', 'feb', 'mar', 'abr', 'may', 'jun', 'jul',
      'ago', 'sep', 'oct', 'nov', 'dic'],
  WEEKDAYS: ['domingo', 'lunes', 'martes', 'miércoles', 'jueves', 'viernes',
      'sábado'],
  STANDALONEWEEKDAYS: ['domingo', 'lunes', 'martes', 'miércoles', 'jueves',
      'viernes', 'sábado'],
  SHORTWEEKDAYS: ['dom', 'lun', 'mar', 'mié', 'jue', 'vie', 'sáb'],
  STANDALONESHORTWEEKDAYS: ['dom', 'lun', 'mar', 'mié', 'jue', 'vie', 'sáb'],
  NARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  STANDALONENARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  SHORTQUARTERS: ['T1', 'T2', 'T3', 'T4'],
  QUARTERS: ['1er trimestre', '2º trimestre', '3er trimestre',
      '4º trimestre'],
  AMPMS: ['a.m.', 'p.m.'],
  DATEFORMATS: ['EEEE dd \'de\' MMMM \'de\' y', 'dd \'de\' MMMM \'de\' y',
      'dd/MM/yyyy', 'dd/MM/yy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale es_MX.
 */
goog.i18n.DateTimeSymbols_es_MX = {
  ERAS: ['a.C.', 'd.C.'],
  ERANAMES: ['antes de Cristo', 'anno Dómini'],
  NARROWMONTHS: ['E', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['E', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio', 'julio',
      'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre'],
  STANDALONEMONTHS: ['enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio',
      'julio', 'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre'],
  SHORTMONTHS: ['ene', 'feb', 'mar', 'abr', 'may', 'jun', 'jul', 'ago', 'sep',
      'oct', 'nov', 'dic'],
  STANDALONESHORTMONTHS: ['ene', 'feb', 'mar', 'abr', 'may', 'jun', 'jul',
      'ago', 'sep', 'oct', 'nov', 'dic'],
  WEEKDAYS: ['domingo', 'lunes', 'martes', 'miércoles', 'jueves', 'viernes',
      'sábado'],
  STANDALONEWEEKDAYS: ['domingo', 'lunes', 'martes', 'miércoles', 'jueves',
      'viernes', 'sábado'],
  SHORTWEEKDAYS: ['dom', 'lun', 'mar', 'mié', 'jue', 'vie', 'sáb'],
  STANDALONESHORTWEEKDAYS: ['dom', 'lun', 'mar', 'mié', 'jue', 'vie', 'sáb'],
  NARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  STANDALONENARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  SHORTQUARTERS: ['T1', 'T2', 'T3', 'T4'],
  QUARTERS: ['1er trimestre', '2º trimestre', '3er trimestre',
      '4º trimestre'],
  AMPMS: ['a.m.', 'p.m.'],
  DATEFORMATS: ['EEEE d \'de\' MMMM \'de\' y', 'd \'de\' MMMM \'de\' y',
      'dd/MM/yyyy', 'dd/MM/yy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale es_NI.
 */
goog.i18n.DateTimeSymbols_es_NI = {
  ERAS: ['a.C.', 'd.C.'],
  ERANAMES: ['antes de Cristo', 'anno Dómini'],
  NARROWMONTHS: ['E', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['E', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio', 'julio',
      'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre'],
  STANDALONEMONTHS: ['enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio',
      'julio', 'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre'],
  SHORTMONTHS: ['ene', 'feb', 'mar', 'abr', 'may', 'jun', 'jul', 'ago', 'sep',
      'oct', 'nov', 'dic'],
  STANDALONESHORTMONTHS: ['ene', 'feb', 'mar', 'abr', 'may', 'jun', 'jul',
      'ago', 'sep', 'oct', 'nov', 'dic'],
  WEEKDAYS: ['domingo', 'lunes', 'martes', 'miércoles', 'jueves', 'viernes',
      'sábado'],
  STANDALONEWEEKDAYS: ['domingo', 'lunes', 'martes', 'miércoles', 'jueves',
      'viernes', 'sábado'],
  SHORTWEEKDAYS: ['dom', 'lun', 'mar', 'mié', 'jue', 'vie', 'sáb'],
  STANDALONESHORTWEEKDAYS: ['dom', 'lun', 'mar', 'mié', 'jue', 'vie', 'sáb'],
  NARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  STANDALONENARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  SHORTQUARTERS: ['T1', 'T2', 'T3', 'T4'],
  QUARTERS: ['1er trimestre', '2º trimestre', '3er trimestre',
      '4º trimestre'],
  AMPMS: ['a.m.', 'p.m.'],
  DATEFORMATS: ['EEEE d \'de\' MMMM \'de\' y', 'd \'de\' MMMM \'de\' y',
      'dd/MM/yyyy', 'dd/MM/yy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale es_PA.
 */
goog.i18n.DateTimeSymbols_es_PA = {
  ERAS: ['a.C.', 'd.C.'],
  ERANAMES: ['antes de Cristo', 'anno Dómini'],
  NARROWMONTHS: ['E', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['E', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio', 'julio',
      'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre'],
  STANDALONEMONTHS: ['enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio',
      'julio', 'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre'],
  SHORTMONTHS: ['ene', 'feb', 'mar', 'abr', 'may', 'jun', 'jul', 'ago', 'sep',
      'oct', 'nov', 'dic'],
  STANDALONESHORTMONTHS: ['ene', 'feb', 'mar', 'abr', 'may', 'jun', 'jul',
      'ago', 'sep', 'oct', 'nov', 'dic'],
  WEEKDAYS: ['domingo', 'lunes', 'martes', 'miércoles', 'jueves', 'viernes',
      'sábado'],
  STANDALONEWEEKDAYS: ['domingo', 'lunes', 'martes', 'miércoles', 'jueves',
      'viernes', 'sábado'],
  SHORTWEEKDAYS: ['dom', 'lun', 'mar', 'mié', 'jue', 'vie', 'sáb'],
  STANDALONESHORTWEEKDAYS: ['dom', 'lun', 'mar', 'mié', 'jue', 'vie', 'sáb'],
  NARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  STANDALONENARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  SHORTQUARTERS: ['T1', 'T2', 'T3', 'T4'],
  QUARTERS: ['1er trimestre', '2º trimestre', '3er trimestre',
      '4º trimestre'],
  AMPMS: ['a.m.', 'p.m.'],
  DATEFORMATS: ['EEEE d \'de\' MMMM \'de\' y', 'd \'de\' MMMM \'de\' y',
      'MM/dd/yyyy', 'MM/dd/yy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale es_PE.
 */
goog.i18n.DateTimeSymbols_es_PE = {
  ERAS: ['a.C.', 'd.C.'],
  ERANAMES: ['antes de Cristo', 'anno Dómini'],
  NARROWMONTHS: ['E', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['E', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio', 'julio',
      'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre'],
  STANDALONEMONTHS: ['enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio',
      'julio', 'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre'],
  SHORTMONTHS: ['ene', 'feb', 'mar', 'abr', 'may', 'jun', 'jul', 'ago', 'sep',
      'oct', 'nov', 'dic'],
  STANDALONESHORTMONTHS: ['ene', 'feb', 'mar', 'abr', 'may', 'jun', 'jul',
      'ago', 'sep', 'oct', 'nov', 'dic'],
  WEEKDAYS: ['domingo', 'lunes', 'martes', 'miércoles', 'jueves', 'viernes',
      'sábado'],
  STANDALONEWEEKDAYS: ['domingo', 'lunes', 'martes', 'miércoles', 'jueves',
      'viernes', 'sábado'],
  SHORTWEEKDAYS: ['dom', 'lun', 'mar', 'mié', 'jue', 'vie', 'sáb'],
  STANDALONESHORTWEEKDAYS: ['dom', 'lun', 'mar', 'mié', 'jue', 'vie', 'sáb'],
  NARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  STANDALONENARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  SHORTQUARTERS: ['T1', 'T2', 'T3', 'T4'],
  QUARTERS: ['1er trimestre', '2º trimestre', '3er trimestre',
      '4º trimestre'],
  AMPMS: ['a.m.', 'p.m.'],
  DATEFORMATS: ['EEEE d \'de\' MMMM \'de\' y', 'd \'de\' MMMM \'de\' y',
      'dd/MM/yyyy', 'd/MM/yy'],
  TIMEFORMATS: ['HH\'H\'mm\'\'ss\'\' zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale es_PR.
 */
goog.i18n.DateTimeSymbols_es_PR = {
  ERAS: ['a.C.', 'd.C.'],
  ERANAMES: ['antes de Cristo', 'anno Dómini'],
  NARROWMONTHS: ['E', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['E', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio', 'julio',
      'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre'],
  STANDALONEMONTHS: ['enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio',
      'julio', 'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre'],
  SHORTMONTHS: ['ene', 'feb', 'mar', 'abr', 'may', 'jun', 'jul', 'ago', 'sep',
      'oct', 'nov', 'dic'],
  STANDALONESHORTMONTHS: ['ene', 'feb', 'mar', 'abr', 'may', 'jun', 'jul',
      'ago', 'sep', 'oct', 'nov', 'dic'],
  WEEKDAYS: ['domingo', 'lunes', 'martes', 'miércoles', 'jueves', 'viernes',
      'sábado'],
  STANDALONEWEEKDAYS: ['domingo', 'lunes', 'martes', 'miércoles', 'jueves',
      'viernes', 'sábado'],
  SHORTWEEKDAYS: ['dom', 'lun', 'mar', 'mié', 'jue', 'vie', 'sáb'],
  STANDALONESHORTWEEKDAYS: ['dom', 'lun', 'mar', 'mié', 'jue', 'vie', 'sáb'],
  NARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  STANDALONENARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  SHORTQUARTERS: ['T1', 'T2', 'T3', 'T4'],
  QUARTERS: ['1er trimestre', '2º trimestre', '3er trimestre',
      '4º trimestre'],
  AMPMS: ['a.m.', 'p.m.'],
  DATEFORMATS: ['EEEE d \'de\' MMMM \'de\' y', 'd \'de\' MMMM \'de\' y',
      'MM/dd/yyyy', 'MM/dd/yy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale es_PY.
 */
goog.i18n.DateTimeSymbols_es_PY = {
  ERAS: ['a.C.', 'd.C.'],
  ERANAMES: ['antes de Cristo', 'anno Dómini'],
  NARROWMONTHS: ['E', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['E', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio', 'julio',
      'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre'],
  STANDALONEMONTHS: ['enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio',
      'julio', 'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre'],
  SHORTMONTHS: ['ene', 'feb', 'mar', 'abr', 'may', 'jun', 'jul', 'ago', 'sep',
      'oct', 'nov', 'dic'],
  STANDALONESHORTMONTHS: ['ene', 'feb', 'mar', 'abr', 'may', 'jun', 'jul',
      'ago', 'sep', 'oct', 'nov', 'dic'],
  WEEKDAYS: ['domingo', 'lunes', 'martes', 'miércoles', 'jueves', 'viernes',
      'sábado'],
  STANDALONEWEEKDAYS: ['domingo', 'lunes', 'martes', 'miércoles', 'jueves',
      'viernes', 'sábado'],
  SHORTWEEKDAYS: ['dom', 'lun', 'mar', 'mié', 'jue', 'vie', 'sáb'],
  STANDALONESHORTWEEKDAYS: ['dom', 'lun', 'mar', 'mié', 'jue', 'vie', 'sáb'],
  NARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  STANDALONENARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  SHORTQUARTERS: ['T1', 'T2', 'T3', 'T4'],
  QUARTERS: ['1er trimestre', '2º trimestre', '3er trimestre',
      '4º trimestre'],
  AMPMS: ['a.m.', 'p.m.'],
  DATEFORMATS: ['EEEE d \'de\' MMMM \'de\' y', 'd \'de\' MMMM \'de\' y',
      'dd/MM/yyyy', 'dd/MM/yy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale es_SV.
 */
goog.i18n.DateTimeSymbols_es_SV = {
  ERAS: ['a.C.', 'd.C.'],
  ERANAMES: ['antes de Cristo', 'anno Dómini'],
  NARROWMONTHS: ['E', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['E', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio', 'julio',
      'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre'],
  STANDALONEMONTHS: ['enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio',
      'julio', 'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre'],
  SHORTMONTHS: ['ene', 'feb', 'mar', 'abr', 'may', 'jun', 'jul', 'ago', 'sep',
      'oct', 'nov', 'dic'],
  STANDALONESHORTMONTHS: ['ene', 'feb', 'mar', 'abr', 'may', 'jun', 'jul',
      'ago', 'sep', 'oct', 'nov', 'dic'],
  WEEKDAYS: ['domingo', 'lunes', 'martes', 'miércoles', 'jueves', 'viernes',
      'sábado'],
  STANDALONEWEEKDAYS: ['domingo', 'lunes', 'martes', 'miércoles', 'jueves',
      'viernes', 'sábado'],
  SHORTWEEKDAYS: ['dom', 'lun', 'mar', 'mié', 'jue', 'vie', 'sáb'],
  STANDALONESHORTWEEKDAYS: ['dom', 'lun', 'mar', 'mié', 'jue', 'vie', 'sáb'],
  NARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  STANDALONENARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  SHORTQUARTERS: ['T1', 'T2', 'T3', 'T4'],
  QUARTERS: ['1er trimestre', '2º trimestre', '3er trimestre',
      '4º trimestre'],
  AMPMS: ['a.m.', 'p.m.'],
  DATEFORMATS: ['EEEE d \'de\' MMMM \'de\' y', 'd \'de\' MMMM \'de\' y',
      'dd/MM/yyyy', 'dd/MM/yy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale es_US.
 */
goog.i18n.DateTimeSymbols_es_US = {
  ERAS: ['a.C.', 'd.C.'],
  ERANAMES: ['antes de Cristo', 'anno Dómini'],
  NARROWMONTHS: ['E', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['E', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio', 'julio',
      'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre'],
  STANDALONEMONTHS: ['enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio',
      'julio', 'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre'],
  SHORTMONTHS: ['ene', 'feb', 'mar', 'abr', 'may', 'jun', 'jul', 'ago', 'sep',
      'oct', 'nov', 'dic'],
  STANDALONESHORTMONTHS: ['ene', 'feb', 'mar', 'abr', 'may', 'jun', 'jul',
      'ago', 'sep', 'oct', 'nov', 'dic'],
  WEEKDAYS: ['domingo', 'lunes', 'martes', 'miércoles', 'jueves', 'viernes',
      'sábado'],
  STANDALONEWEEKDAYS: ['domingo', 'lunes', 'martes', 'miércoles', 'jueves',
      'viernes', 'sábado'],
  SHORTWEEKDAYS: ['dom', 'lun', 'mar', 'mié', 'jue', 'vie', 'sáb'],
  STANDALONESHORTWEEKDAYS: ['dom', 'lun', 'mar', 'mié', 'jue', 'vie', 'sáb'],
  NARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  STANDALONENARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  SHORTQUARTERS: ['T1', 'T2', 'T3', 'T4'],
  QUARTERS: ['1er trimestre', '2º trimestre', '3er trimestre',
      '4º trimestre'],
  AMPMS: ['a.m.', 'p.m.'],
  DATEFORMATS: ['EEEE d \'de\' MMMM \'de\' y', 'd \'de\' MMMM \'de\' y',
      'MMM d, y', 'M/d/yy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale es_UY.
 */
goog.i18n.DateTimeSymbols_es_UY = {
  ERAS: ['a.C.', 'd.C.'],
  ERANAMES: ['antes de Cristo', 'anno Dómini'],
  NARROWMONTHS: ['E', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['E', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio', 'julio',
      'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre'],
  STANDALONEMONTHS: ['enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio',
      'julio', 'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre'],
  SHORTMONTHS: ['ene', 'feb', 'mar', 'abr', 'may', 'jun', 'jul', 'ago', 'sep',
      'oct', 'nov', 'dic'],
  STANDALONESHORTMONTHS: ['ene', 'feb', 'mar', 'abr', 'may', 'jun', 'jul',
      'ago', 'sep', 'oct', 'nov', 'dic'],
  WEEKDAYS: ['domingo', 'lunes', 'martes', 'miércoles', 'jueves', 'viernes',
      'sábado'],
  STANDALONEWEEKDAYS: ['domingo', 'lunes', 'martes', 'miércoles', 'jueves',
      'viernes', 'sábado'],
  SHORTWEEKDAYS: ['dom', 'lun', 'mar', 'mié', 'jue', 'vie', 'sáb'],
  STANDALONESHORTWEEKDAYS: ['dom', 'lun', 'mar', 'mié', 'jue', 'vie', 'sáb'],
  NARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  STANDALONENARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  SHORTQUARTERS: ['T1', 'T2', 'T3', 'T4'],
  QUARTERS: ['1er trimestre', '2º trimestre', '3er trimestre',
      '4º trimestre'],
  AMPMS: ['a.m.', 'p.m.'],
  DATEFORMATS: ['EEEE d \'de\' MMMM \'de\' y', 'd \'de\' MMMM \'de\' y',
      'dd/MM/yyyy', 'dd/MM/yy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale es_VE.
 */
goog.i18n.DateTimeSymbols_es_VE = {
  ERAS: ['a.C.', 'd.C.'],
  ERANAMES: ['antes de Cristo', 'anno Dómini'],
  NARROWMONTHS: ['E', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['E', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio', 'julio',
      'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre'],
  STANDALONEMONTHS: ['enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio',
      'julio', 'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre'],
  SHORTMONTHS: ['ene', 'feb', 'mar', 'abr', 'may', 'jun', 'jul', 'ago', 'sep',
      'oct', 'nov', 'dic'],
  STANDALONESHORTMONTHS: ['ene', 'feb', 'mar', 'abr', 'may', 'jun', 'jul',
      'ago', 'sep', 'oct', 'nov', 'dic'],
  WEEKDAYS: ['domingo', 'lunes', 'martes', 'miércoles', 'jueves', 'viernes',
      'sábado'],
  STANDALONEWEEKDAYS: ['domingo', 'lunes', 'martes', 'miércoles', 'jueves',
      'viernes', 'sábado'],
  SHORTWEEKDAYS: ['dom', 'lun', 'mar', 'mié', 'jue', 'vie', 'sáb'],
  STANDALONESHORTWEEKDAYS: ['dom', 'lun', 'mar', 'mié', 'jue', 'vie', 'sáb'],
  NARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  STANDALONENARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  SHORTQUARTERS: ['T1', 'T2', 'T3', 'T4'],
  QUARTERS: ['1er trimestre', '2º trimestre', '3er trimestre',
      '4º trimestre'],
  AMPMS: ['a.m.', 'p.m.'],
  DATEFORMATS: ['EEEE d \'de\' MMMM \'de\' y', 'd \'de\' MMMM \'de\' y',
      'dd/MM/yyyy', 'dd/MM/yy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale et_EE.
 */
goog.i18n.DateTimeSymbols_et_EE = {
  ERAS: ['e.m.a.', 'm.a.j.'],
  ERANAMES: ['enne meie aega', 'meie aja järgi'],
  NARROWMONTHS: ['J', 'V', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['J', 'V', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['jaanuar', 'veebruar', 'märts', 'aprill', 'mai', 'juuni', 'juuli',
      'august', 'september', 'oktoober', 'november', 'detsember'],
  STANDALONEMONTHS: ['jaanuar', 'veebruar', 'märts', 'aprill', 'mai', 'juuni',
      'juuli', 'august', 'september', 'oktoober', 'november', 'detsember'],
  SHORTMONTHS: ['jaan', 'veebr', 'märts', 'apr', 'mai', 'juuni', 'juuli',
      'aug', 'sept', 'okt', 'nov', 'dets'],
  STANDALONESHORTMONTHS: ['jaan', 'veebr', 'märts', 'apr', 'mai', 'juuni',
      'juuli', 'aug', 'sept', 'okt', 'nov', 'dets'],
  WEEKDAYS: ['pühapäev', 'esmaspäev', 'teisipäev', 'kolmapäev',
      'neljapäev', 'reede', 'laupäev'],
  STANDALONEWEEKDAYS: ['pühapäev', 'esmaspäev', 'teisipäev', 'kolmapäev',
      'neljapäev', 'reede', 'laupäev'],
  SHORTWEEKDAYS: ['P', 'E', 'T', 'K', 'N', 'R', 'L'],
  STANDALONESHORTWEEKDAYS: ['P', 'E', 'T', 'K', 'N', 'R', 'L'],
  NARROWWEEKDAYS: ['P', 'E', 'T', 'K', 'N', 'R', 'L'],
  STANDALONENARROWWEEKDAYS: ['P', 'E', 'T', 'K', 'N', 'R', 'L'],
  SHORTQUARTERS: ['K1', 'K2', 'K3', 'K4'],
  QUARTERS: ['1. kvartal', '2. kvartal', '3. kvartal', '4. kvartal'],
  AMPMS: ['enne keskpäeva', 'pärast keskpäeva'],
  DATEFORMATS: ['EEEE, d. MMMM y', 'd. MMMM y', 'dd.MM.yyyy', 'dd.MM.yy'],
  TIMEFORMATS: ['H:mm.ss zzzz', 'H:mm.ss z', 'H:mm.ss', 'H:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale eu_ES.
 */
goog.i18n.DateTimeSymbols_eu_ES = {
  ERAS: ['BCE', 'CE'],
  ERANAMES: ['BCE', 'CE'],
  NARROWMONTHS: ['U', 'O', 'M', 'A', 'M', 'E', 'U', 'A', 'I', 'U', 'A', 'A'],
  STANDALONENARROWMONTHS: ['U', 'O', 'M', 'A', 'M', 'E', 'U', 'A', 'I', 'U',
      'A', 'A'],
  MONTHS: ['urtarrila', 'otsaila', 'martxoa', 'apirila', 'maiatza', 'ekaina',
      'uztaila', 'abuztua', 'iraila', 'urria', 'azaroa', 'abendua'],
  STANDALONEMONTHS: ['urtarrila', 'otsaila', 'martxoa', 'apirila', 'maiatza',
      'ekaina', 'uztaila', 'abuztua', 'iraila', 'urria', 'azaroa', 'abendua'],
  SHORTMONTHS: ['urt', 'ots', 'mar', 'api', 'mai', 'eka', 'uzt', 'abu', 'ira',
      'urr', 'aza', 'abe'],
  STANDALONESHORTMONTHS: ['urt', 'ots', 'mar', 'api', 'mai', 'eka', 'uzt',
      'abu', 'ira', 'urr', 'aza', 'abe'],
  WEEKDAYS: ['igandea', 'astelehena', 'asteartea', 'asteazkena', 'osteguna',
      'ostirala', 'larunbata'],
  STANDALONEWEEKDAYS: ['igandea', 'astelehena', 'asteartea', 'asteazkena',
      'osteguna', 'ostirala', 'larunbata'],
  SHORTWEEKDAYS: ['ig', 'al', 'as', 'az', 'og', 'or', 'lr'],
  STANDALONESHORTWEEKDAYS: ['ig', 'al', 'as', 'az', 'og', 'or', 'lr'],
  NARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONENARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTQUARTERS: ['1Hh', '2Hh', '3Hh', '4Hh'],
  QUARTERS: ['1. hiruhilekoa', '2. hiruhilekoa', '3. hiruhilekoa',
      '4. hiruhilekoa'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, y\'eko\' MMMM\'ren\' dd\'a\'',
      'y\'eko\' MMM\'ren\' dd\'a\'', 'y MMM d', 'yyyy-MM-dd'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale fa_AF.
 */
goog.i18n.DateTimeSymbols_fa_AF = {
  ERAS: ['ق.م.', 'ب. م.'],
  ERANAMES: ['قبل از میلاد', 'میلادی'],
  NARROWMONTHS: ['ج', 'ف', 'م', 'ا', 'م', 'ج', 'ج', 'ا', 'س', 'ا',
      'ن', 'د'],
  STANDALONENARROWMONTHS: ['ج', 'ف', 'م', 'ا', 'م', 'ج', 'ج', 'ا', 'س',
      'ا', 'ن', 'د'],
  MONTHS: ['جنوری', 'فبروری', 'مارچ', 'اپریل', 'می',
      'جون', 'جولای', 'اگست', 'سپتمبر', 'اکتوبر',
      'نومبر', 'دسمبر'],
  STANDALONEMONTHS: ['ژانویه', 'فوریه', 'مارس', 'آوریل',
      'مه', 'ژوئن', 'ژوئیه', 'اوت', 'سپتامبر',
      'اکتبر', 'نوامبر', 'دسامبر'],
  SHORTMONTHS: ['جنو', 'فوریهٔ', 'مارس', 'آوریل', 'مـی',
      'جون', 'جول', 'اوت', 'سپتامبر', 'اکتبر',
      'نوامبر', 'دسم'],
  STANDALONESHORTMONTHS: ['ژانویه', 'فوریه', 'مارس',
      'آوریل', 'مه', 'ژوئن', 'ژوئیه', 'اوت',
      'سپتامبر', 'اکتبر', 'نوامبر', 'دسامبر'],
  WEEKDAYS: ['یکشنبه', 'دوشنبه', 'سه‌شنبه',
      'چهارشنبه', 'پنجشنبه', 'جمعه', 'شنبه'],
  STANDALONEWEEKDAYS: ['یکشنبه', 'دوشنبه', 'سه‌شنبه',
      'چهارشنبه', 'پنجشنبه', 'جمعه', 'شنبه'],
  SHORTWEEKDAYS: ['یکشنبه', 'دوشنبه', 'سه‌شنبه',
      'چهارشنبه', 'پنجشنبه', 'جمعه', 'شنبه'],
  STANDALONESHORTWEEKDAYS: ['یکشنبه', 'دوشنبه', 'سه‌شنبه',
      'چهارشنبه', 'پنجشنبه', 'جمعه', 'شنبه'],
  NARROWWEEKDAYS: ['ی', 'د', 'س', 'چ', 'پ', 'ج', 'ش'],
  STANDALONENARROWWEEKDAYS: ['ی', 'د', 'س', 'چ', 'پ', 'ج', 'ش'],
  SHORTQUARTERS: ['س‌م۱', 'س‌م۲', 'س‌م۳', 'س‌م۴'],
  QUARTERS: ['سه‌ماههٔ اول', 'سه‌ماههٔ دوم',
      'سه‌ماههٔ سوم', 'سه‌ماههٔ چهارم'],
  AMPMS: ['قبل از ظهر', 'بعد از ظهر'],
  DATEFORMATS: ['EEEE, MMMM d, y', 'MMMM d, y', 'MMM d, y', 'M/d/yy'],
  TIMEFORMATS: ['H:mm:ss (zzzz)', 'H:mm:ss (z)', 'H:mm:ss', 'H:mm'],
  FIRSTDAYOFWEEK: 5,
  WEEKENDRANGE: [3, 4],
  FIRSTWEEKCUTOFFDAY: 1
};


/**
 * Date/time formatting symbols for locale fa_IR.
 */
goog.i18n.DateTimeSymbols_fa_IR = {
  ERAS: ['ق.م.', 'ب. م.'],
  ERANAMES: ['قبل از میلاد', 'میلادی'],
  NARROWMONTHS: ['ژ', 'ف', 'م', 'آ', 'می', 'ژ', 'ژ', 'ا', 'س', 'ا',
      'ن', 'د'],
  STANDALONENARROWMONTHS: ['ژ', 'ف', 'م', 'آ', 'می', 'ژ', 'ژ', 'ا',
      'س', 'ا', 'ن', 'د'],
  MONTHS: ['ژانویهٔ', 'فوریهٔ', 'مارس', 'آوریل', 'می',
      'جون', 'جولای', 'آگوست', 'سپتامبر', 'اکتبر',
      'نوامبر', 'دسامبر'],
  STANDALONEMONTHS: ['ژانویه', 'فوریه', 'مارس', 'آوریل',
      'مه', 'ژوئن', 'ژوئیه', 'اوت', 'سپتامبر',
      'اکتبر', 'نوامبر', 'دسامبر'],
  SHORTMONTHS: ['ژانویهٔ', 'فوریهٔ', 'مارس', 'آوریل',
      'می', 'جون', 'جولای', 'اوت', 'سپتامبر', 'اکتبر',
      'نوامبر', 'دسامبر'],
  STANDALONESHORTMONTHS: ['ژانویه', 'فوریه', 'مارس',
      'آوریل', 'مه', 'ژوئن', 'ژوئیه', 'اوت',
      'سپتامبر', 'اکتبر', 'نوامبر', 'دسامبر'],
  WEEKDAYS: ['یکشنبه', 'دوشنبه', 'سه‌شنبه',
      'چهارشنبه', 'پنجشنبه', 'جمعه', 'شنبه'],
  STANDALONEWEEKDAYS: ['یکشنبه', 'دوشنبه', 'سه‌شنبه',
      'چهارشنبه', 'پنجشنبه', 'جمعه', 'شنبه'],
  SHORTWEEKDAYS: ['یکشنبه', 'دوشنبه', 'سه‌شنبه',
      'چهارشنبه', 'پنجشنبه', 'جمعه', 'شنبه'],
  STANDALONESHORTWEEKDAYS: ['یکشنبه', 'دوشنبه', 'سه‌شنبه',
      'چهارشنبه', 'پنجشنبه', 'جمعه', 'شنبه'],
  NARROWWEEKDAYS: ['ی', 'د', 'س', 'چ', 'پ', 'ج', 'ش'],
  STANDALONENARROWWEEKDAYS: ['ی', 'د', 'س', 'چ', 'پ', 'ج', 'ش'],
  SHORTQUARTERS: ['س‌م۱', 'س‌م۲', 'س‌م۳', 'س‌م۴'],
  QUARTERS: ['سه‌ماههٔ اول', 'سه‌ماههٔ دوم',
      'سه‌ماههٔ سوم', 'سه‌ماههٔ چهارم'],
  AMPMS: ['قبل از ظهر', 'بعد از ظهر'],
  DATEFORMATS: ['EEEE, MMMM d, y', 'MMMM d, y', 'MMM d, y', 'M/d/yy'],
  TIMEFORMATS: ['H:mm:ss (zzzz)', 'H:mm:ss (z)', 'H:mm:ss', 'H:mm'],
  FIRSTDAYOFWEEK: 5,
  WEEKENDRANGE: [3, 4],
  FIRSTWEEKCUTOFFDAY: 1
};


/**
 * Date/time formatting symbols for locale fi_FI.
 */
goog.i18n.DateTimeSymbols_fi_FI = {
  ERAS: ['eKr.', 'jKr.'],
  ERANAMES: ['ennen Kristuksen syntymää', 'jälkeen Kristuksen syntymän'],
  NARROWMONTHS: ['T', 'H', 'M', 'H', 'T', 'K', 'H', 'E', 'S', 'L', 'M', 'J'],
  STANDALONENARROWMONTHS: ['T', 'H', 'M', 'H', 'T', 'K', 'H', 'E', 'S', 'L',
      'M', 'J'],
  MONTHS: ['tammikuuta', 'helmikuuta', 'maaliskuuta', 'huhtikuuta',
      'toukokuuta', 'kesäkuuta', 'heinäkuuta', 'elokuuta', 'syyskuuta',
      'lokakuuta', 'marraskuuta', 'joulukuuta'],
  STANDALONEMONTHS: ['tammikuu', 'helmikuu', 'maaliskuu', 'huhtikuu',
      'toukokuu', 'kesäkuu', 'heinäkuu', 'elokuu', 'syyskuu', 'lokakuu',
      'marraskuu', 'joulukuu'],
  SHORTMONTHS: ['tammikuuta', 'helmikuuta', 'maaliskuuta', 'huhtikuuta',
      'toukokuuta', 'kesäkuuta', 'heinäkuuta', 'elokuuta', 'syyskuuta',
      'lokakuuta', 'marraskuuta', 'joulukuuta'],
  STANDALONESHORTMONTHS: ['tammi', 'helmi', 'maalis', 'huhti', 'touko', 'kesä',
      'heinä', 'elo', 'syys', 'loka', 'marras', 'joulu'],
  WEEKDAYS: ['sunnuntaina', 'maanantaina', 'tiistaina', 'keskiviikkona',
      'torstaina', 'perjantaina', 'lauantaina'],
  STANDALONEWEEKDAYS: ['sunnuntai', 'maanantai', 'tiistai', 'keskiviikko',
      'torstai', 'perjantai', 'lauantai'],
  SHORTWEEKDAYS: ['su', 'ma', 'ti', 'ke', 'to', 'pe', 'la'],
  STANDALONESHORTWEEKDAYS: ['su', 'ma', 'ti', 'ke', 'to', 'pe', 'la'],
  NARROWWEEKDAYS: ['S', 'M', 'T', 'K', 'T', 'P', 'L'],
  STANDALONENARROWWEEKDAYS: ['S', 'M', 'T', 'K', 'T', 'P', 'L'],
  SHORTQUARTERS: ['1. nelj.', '2. nelj.', '3. nelj.', '4. nelj.'],
  QUARTERS: ['1. neljännes', '2. neljännes', '3. neljännes',
      '4. neljännes'],
  AMPMS: ['ap.', 'ip.'],
  DATEFORMATS: ['cccc d. MMMM y', 'd. MMMM y', 'd.M.yyyy', 'd.M.yyyy'],
  TIMEFORMATS: ['H.mm.ss zzzz', 'H.mm.ss z', 'H.mm.ss', 'H.mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale fil_PH.
 */
goog.i18n.DateTimeSymbols_fil_PH = {
  ERAS: ['BCE', 'CE'],
  ERANAMES: ['BCE', 'CE'],
  NARROWMONTHS: ['E', 'P', 'M', 'A', 'M', 'H', 'H', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['E', 'P', 'M', 'A', 'M', 'H', 'H', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['Enero', 'Pebrero', 'Marso', 'Abril', 'Mayo', 'Hunyo', 'Hulyo',
      'Agosto', 'Setyembre', 'Oktubre', 'Nobyembre', 'Disyembre'],
  STANDALONEMONTHS: ['Enero', 'Pebrero', 'Marso', 'Abril', 'Mayo', 'Hunyo',
      'Hulyo', 'Agosto', 'Setyembre', 'Oktubre', 'Nobyembre', 'Disyembre'],
  SHORTMONTHS: ['Ene', 'Peb', 'Mar', 'Abr', 'May', 'Hun', 'Hul', 'Ago', 'Set',
      'Okt', 'Nob', 'Dis'],
  STANDALONESHORTMONTHS: ['Ene', 'Peb', 'Mar', 'Abr', 'May', 'Hun', 'Hul',
      'Ago', 'Set', 'Okt', 'Nob', 'Dis'],
  WEEKDAYS: ['Linggo', 'Lunes', 'Martes', 'Miyerkules', 'Huwebes', 'Biyernes',
      'Sabado'],
  STANDALONEWEEKDAYS: ['Linggo', 'Lunes', 'Martes', 'Miyerkules', 'Huwebes',
      'Biyernes', 'Sabado'],
  SHORTWEEKDAYS: ['Lin', 'Lun', 'Mar', 'Mye', 'Huw', 'Bye', 'Sab'],
  STANDALONESHORTWEEKDAYS: ['Lin', 'Lun', 'Mar', 'Miy', 'Huw', 'Biy', 'Sab'],
  NARROWWEEKDAYS: ['L', 'L', 'M', 'M', 'H', 'B', 'S'],
  STANDALONENARROWWEEKDAYS: ['L', 'L', 'M', 'M', 'H', 'B', 'S'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, MMMM dd y', 'MMMM d, y', 'MMM d, y', 'M/d/yy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale fo.
 */
goog.i18n.DateTimeSymbols_fo = {
  ERAS: ['f.Kr.', 'e.Kr.'],
  ERANAMES: ['fyrir Krist', 'eftir Krist'],
  NARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['januar', 'februar', 'mars', 'apríl', 'mai', 'juni', 'juli',
      'august', 'september', 'oktober', 'november', 'desember'],
  STANDALONEMONTHS: ['januar', 'februar', 'mars', 'apríl', 'mai', 'juni',
      'juli', 'august', 'september', 'oktober', 'november', 'desember'],
  SHORTMONTHS: ['jan', 'feb', 'mar', 'apr', 'mai', 'jun', 'jul', 'aug', 'sep',
      'okt', 'nov', 'des'],
  STANDALONESHORTMONTHS: ['jan', 'feb', 'mar', 'apr', 'mai', 'jun', 'jul',
      'aug', 'sep', 'okt', 'nov', 'des'],
  WEEKDAYS: ['sunnudagur', 'mánadagur', 'týsdagur', 'mikudagur', 'hósdagur',
      'fríggjadagur', 'leygardagur'],
  STANDALONEWEEKDAYS: ['sunnudagur', 'mánadagur', 'týsdagur', 'mikudagur',
      'hósdagur', 'fríggjadagur', 'leygardagur'],
  SHORTWEEKDAYS: ['sun', 'mán', 'týs', 'mik', 'hós', 'frí', 'ley'],
  STANDALONESHORTWEEKDAYS: ['sun', 'mán', 'týs', 'mik', 'hós', 'frí',
      'ley'],
  NARROWWEEKDAYS: ['S', 'M', 'T', 'M', 'H', 'F', 'L'],
  STANDALONENARROWWEEKDAYS: ['S', 'M', 'T', 'M', 'H', 'F', 'L'],
  SHORTQUARTERS: ['K1', 'K2', 'K3', 'K4'],
  QUARTERS: ['1. kvartal', '2. kvartal', '3. kvartal', '4. kvartal'],
  AMPMS: ['um fyrrapartur', 'um seinnapartur'],
  DATEFORMATS: ['EEEE dd MMMM y', 'd. MMM y', 'dd-MM-yyyy', 'dd-MM-yy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale fo_FO.
 */
goog.i18n.DateTimeSymbols_fo_FO = goog.i18n.DateTimeSymbols_fo;


/**
 * Date/time formatting symbols for locale fr_BE.
 */
goog.i18n.DateTimeSymbols_fr_BE = {
  ERAS: ['av. J.-C.', 'ap. J.-C.'],
  ERANAMES: ['avant Jésus-Christ', 'après Jésus-Christ'],
  NARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['janvier', 'février', 'mars', 'avril', 'mai', 'juin', 'juillet',
      'août', 'septembre', 'octobre', 'novembre', 'décembre'],
  STANDALONEMONTHS: ['janvier', 'février', 'mars', 'avril', 'mai', 'juin',
      'juillet', 'août', 'septembre', 'octobre', 'novembre', 'décembre'],
  SHORTMONTHS: ['janv.', 'févr.', 'mars', 'avr.', 'mai', 'juin', 'juil.',
      'août', 'sept.', 'oct.', 'nov.', 'déc.'],
  STANDALONESHORTMONTHS: ['janv.', 'févr.', 'mars', 'avr.', 'mai', 'juin',
      'juil.', 'août', 'sept.', 'oct.', 'nov.', 'déc.'],
  WEEKDAYS: ['dimanche', 'lundi', 'mardi', 'mercredi', 'jeudi', 'vendredi',
      'samedi'],
  STANDALONEWEEKDAYS: ['dimanche', 'lundi', 'mardi', 'mercredi', 'jeudi',
      'vendredi', 'samedi'],
  SHORTWEEKDAYS: ['dim.', 'lun.', 'mar.', 'mer.', 'jeu.', 'ven.', 'sam.'],
  STANDALONESHORTWEEKDAYS: ['dim.', 'lun.', 'mar.', 'mer.', 'jeu.', 'ven.',
      'sam.'],
  NARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  STANDALONENARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  SHORTQUARTERS: ['T1', 'T2', 'T3', 'T4'],
  QUARTERS: ['1er trimestre', '2e trimestre', '3e trimestre', '4e trimestre'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE d MMMM y', 'd MMMM y', 'd MMM y', 'd/MM/yy'],
  TIMEFORMATS: ['H \'h\' mm \'min\' ss \'s\' zzzz', 'HH:mm:ss z', 'HH:mm:ss',
      'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale fr_CH.
 */
goog.i18n.DateTimeSymbols_fr_CH = {
  ERAS: ['av. J.-C.', 'ap. J.-C.'],
  ERANAMES: ['avant Jésus-Christ', 'après Jésus-Christ'],
  NARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['janvier', 'février', 'mars', 'avril', 'mai', 'juin', 'juillet',
      'août', 'septembre', 'octobre', 'novembre', 'décembre'],
  STANDALONEMONTHS: ['janvier', 'février', 'mars', 'avril', 'mai', 'juin',
      'juillet', 'août', 'septembre', 'octobre', 'novembre', 'décembre'],
  SHORTMONTHS: ['janv.', 'févr.', 'mars', 'avr.', 'mai', 'juin', 'juil.',
      'août', 'sept.', 'oct.', 'nov.', 'déc.'],
  STANDALONESHORTMONTHS: ['janv.', 'févr.', 'mars', 'avr.', 'mai', 'juin',
      'juil.', 'août', 'sept.', 'oct.', 'nov.', 'déc.'],
  WEEKDAYS: ['dimanche', 'lundi', 'mardi', 'mercredi', 'jeudi', 'vendredi',
      'samedi'],
  STANDALONEWEEKDAYS: ['dimanche', 'lundi', 'mardi', 'mercredi', 'jeudi',
      'vendredi', 'samedi'],
  SHORTWEEKDAYS: ['dim.', 'lun.', 'mar.', 'mer.', 'jeu.', 'ven.', 'sam.'],
  STANDALONESHORTWEEKDAYS: ['dim.', 'lun.', 'mar.', 'mer.', 'jeu.', 'ven.',
      'sam.'],
  NARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  STANDALONENARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  SHORTQUARTERS: ['T1', 'T2', 'T3', 'T4'],
  QUARTERS: ['1er trimestre', '2e trimestre', '3e trimestre', '4e trimestre'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, d MMMM y', 'd MMMM y', 'd MMM y', 'dd.MM.yy'],
  TIMEFORMATS: ['HH.mm:ss \'h\' zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale fr_FR.
 */
goog.i18n.DateTimeSymbols_fr_FR = {
  ERAS: ['av. J.-C.', 'ap. J.-C.'],
  ERANAMES: ['avant Jésus-Christ', 'après Jésus-Christ'],
  NARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['janvier', 'février', 'mars', 'avril', 'mai', 'juin', 'juillet',
      'août', 'septembre', 'octobre', 'novembre', 'décembre'],
  STANDALONEMONTHS: ['janvier', 'février', 'mars', 'avril', 'mai', 'juin',
      'juillet', 'août', 'septembre', 'octobre', 'novembre', 'décembre'],
  SHORTMONTHS: ['janv.', 'févr.', 'mars', 'avr.', 'mai', 'juin', 'juil.',
      'août', 'sept.', 'oct.', 'nov.', 'déc.'],
  STANDALONESHORTMONTHS: ['janv.', 'févr.', 'mars', 'avr.', 'mai', 'juin',
      'juil.', 'août', 'sept.', 'oct.', 'nov.', 'déc.'],
  WEEKDAYS: ['dimanche', 'lundi', 'mardi', 'mercredi', 'jeudi', 'vendredi',
      'samedi'],
  STANDALONEWEEKDAYS: ['dimanche', 'lundi', 'mardi', 'mercredi', 'jeudi',
      'vendredi', 'samedi'],
  SHORTWEEKDAYS: ['dim.', 'lun.', 'mar.', 'mer.', 'jeu.', 'ven.', 'sam.'],
  STANDALONESHORTWEEKDAYS: ['dim.', 'lun.', 'mar.', 'mer.', 'jeu.', 'ven.',
      'sam.'],
  NARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  STANDALONENARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  SHORTQUARTERS: ['T1', 'T2', 'T3', 'T4'],
  QUARTERS: ['1er trimestre', '2e trimestre', '3e trimestre', '4e trimestre'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE d MMMM y', 'd MMMM y', 'd MMM y', 'dd/MM/yy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale fr_LU.
 */
goog.i18n.DateTimeSymbols_fr_LU = {
  ERAS: ['av. J.-C.', 'ap. J.-C.'],
  ERANAMES: ['avant Jésus-Christ', 'après Jésus-Christ'],
  NARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['janvier', 'février', 'mars', 'avril', 'mai', 'juin', 'juillet',
      'août', 'septembre', 'octobre', 'novembre', 'décembre'],
  STANDALONEMONTHS: ['janvier', 'février', 'mars', 'avril', 'mai', 'juin',
      'juillet', 'août', 'septembre', 'octobre', 'novembre', 'décembre'],
  SHORTMONTHS: ['janv.', 'févr.', 'mars', 'avr.', 'mai', 'juin', 'juil.',
      'août', 'sept.', 'oct.', 'nov.', 'déc.'],
  STANDALONESHORTMONTHS: ['janv.', 'févr.', 'mars', 'avr.', 'mai', 'juin',
      'juil.', 'août', 'sept.', 'oct.', 'nov.', 'déc.'],
  WEEKDAYS: ['dimanche', 'lundi', 'mardi', 'mercredi', 'jeudi', 'vendredi',
      'samedi'],
  STANDALONEWEEKDAYS: ['dimanche', 'lundi', 'mardi', 'mercredi', 'jeudi',
      'vendredi', 'samedi'],
  SHORTWEEKDAYS: ['dim.', 'lun.', 'mar.', 'mer.', 'jeu.', 'ven.', 'sam.'],
  STANDALONESHORTWEEKDAYS: ['dim.', 'lun.', 'mar.', 'mer.', 'jeu.', 'ven.',
      'sam.'],
  NARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  STANDALONENARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  SHORTQUARTERS: ['T1', 'T2', 'T3', 'T4'],
  QUARTERS: ['1er trimestre', '2e trimestre', '3e trimestre', '4e trimestre'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE d MMMM y', 'd MMMM y', 'd MMM y', 'dd/MM/yy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale fr_MC.
 */
goog.i18n.DateTimeSymbols_fr_MC = {
  ERAS: ['av. J.-C.', 'ap. J.-C.'],
  ERANAMES: ['avant Jésus-Christ', 'après Jésus-Christ'],
  NARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['janvier', 'février', 'mars', 'avril', 'mai', 'juin', 'juillet',
      'août', 'septembre', 'octobre', 'novembre', 'décembre'],
  STANDALONEMONTHS: ['janvier', 'février', 'mars', 'avril', 'mai', 'juin',
      'juillet', 'août', 'septembre', 'octobre', 'novembre', 'décembre'],
  SHORTMONTHS: ['janv.', 'févr.', 'mars', 'avr.', 'mai', 'juin', 'juil.',
      'août', 'sept.', 'oct.', 'nov.', 'déc.'],
  STANDALONESHORTMONTHS: ['janv.', 'févr.', 'mars', 'avr.', 'mai', 'juin',
      'juil.', 'août', 'sept.', 'oct.', 'nov.', 'déc.'],
  WEEKDAYS: ['dimanche', 'lundi', 'mardi', 'mercredi', 'jeudi', 'vendredi',
      'samedi'],
  STANDALONEWEEKDAYS: ['dimanche', 'lundi', 'mardi', 'mercredi', 'jeudi',
      'vendredi', 'samedi'],
  SHORTWEEKDAYS: ['dim.', 'lun.', 'mar.', 'mer.', 'jeu.', 'ven.', 'sam.'],
  STANDALONESHORTWEEKDAYS: ['dim.', 'lun.', 'mar.', 'mer.', 'jeu.', 'ven.',
      'sam.'],
  NARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  STANDALONENARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  SHORTQUARTERS: ['T1', 'T2', 'T3', 'T4'],
  QUARTERS: ['1er trimestre', '2e trimestre', '3e trimestre', '4e trimestre'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE d MMMM y', 'd MMMM y', 'd MMM y', 'dd/MM/yy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale fr_SN.
 */
goog.i18n.DateTimeSymbols_fr_SN = {
  ERAS: ['av. J.-C.', 'ap. J.-C.'],
  ERANAMES: ['avant Jésus-Christ', 'après Jésus-Christ'],
  NARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['janvier', 'février', 'mars', 'avril', 'mai', 'juin', 'juillet',
      'août', 'septembre', 'octobre', 'novembre', 'décembre'],
  STANDALONEMONTHS: ['janvier', 'février', 'mars', 'avril', 'mai', 'juin',
      'juillet', 'août', 'septembre', 'octobre', 'novembre', 'décembre'],
  SHORTMONTHS: ['janv.', 'févr.', 'mars', 'avr.', 'mai', 'juin', 'juil.',
      'août', 'sept.', 'oct.', 'nov.', 'déc.'],
  STANDALONESHORTMONTHS: ['janv.', 'févr.', 'mars', 'avr.', 'mai', 'juin',
      'juil.', 'août', 'sept.', 'oct.', 'nov.', 'déc.'],
  WEEKDAYS: ['dimanche', 'lundi', 'mardi', 'mercredi', 'jeudi', 'vendredi',
      'samedi'],
  STANDALONEWEEKDAYS: ['dimanche', 'lundi', 'mardi', 'mercredi', 'jeudi',
      'vendredi', 'samedi'],
  SHORTWEEKDAYS: ['dim.', 'lun.', 'mar.', 'mer.', 'jeu.', 'ven.', 'sam.'],
  STANDALONESHORTWEEKDAYS: ['dim.', 'lun.', 'mar.', 'mer.', 'jeu.', 'ven.',
      'sam.'],
  NARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  STANDALONENARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  SHORTQUARTERS: ['T1', 'T2', 'T3', 'T4'],
  QUARTERS: ['1er trimestre', '2e trimestre', '3e trimestre', '4e trimestre'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE d MMMM y', 'd MMMM y', 'd MMM y', 'dd/MM/yy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale fur.
 */
goog.i18n.DateTimeSymbols_fur = {
  ERAS: ['pdC', 'ddC'],
  ERANAMES: ['pdC', 'ddC'],
  NARROWMONTHS: ['Z', 'F', 'M', 'A', 'M', 'J', 'L', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['Z', 'F', 'M', 'A', 'M', 'J', 'L', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['Zenâr', 'Fevrâr', 'Març', 'Avrîl', 'Mai', 'Jugn', 'Lui',
      'Avost', 'Setembar', 'Otubar', 'Novembar', 'Dicembar'],
  STANDALONEMONTHS: ['Zenâr', 'Fevrâr', 'Març', 'Avrîl', 'Mai', 'Jugn',
      'Lui', 'Avost', 'Setembar', 'Otubar', 'Novembar', 'Dicembar'],
  SHORTMONTHS: ['Zen', 'Fev', 'Mar', 'Avr', 'Mai', 'Jug', 'Lui', 'Avo', 'Set',
      'Otu', 'Nov', 'Dic'],
  STANDALONESHORTMONTHS: ['Zen', 'Fev', 'Mar', 'Avr', 'Mai', 'Jug', 'Lui',
      'Avo', 'Set', 'Otu', 'Nov', 'Dic'],
  WEEKDAYS: ['domenie', 'lunis', 'martars', 'miercus', 'joibe', 'vinars',
      'sabide'],
  STANDALONEWEEKDAYS: ['domenie', 'lunis', 'martars', 'miercus', 'joibe',
      'vinars', 'sabide'],
  SHORTWEEKDAYS: ['dom', 'lun', 'mar', 'mie', 'joi', 'vin', 'sab'],
  STANDALONESHORTWEEKDAYS: ['dom', 'lun', 'mar', 'mie', 'joi', 'vin', 'sab'],
  NARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  STANDALONENARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  SHORTQUARTERS: ['T1', 'T2', 'T3', 'T4'],
  QUARTERS: ['Prin trimestri', 'Secont trimestri', 'Tierç trimestri',
      'Cuart trimestri'],
  AMPMS: ['a.', 'p.'],
  DATEFORMATS: ['EEEE d \'di\' MMMM \'dal\' y', 'd \'di\' MMMM \'dal\' y',
      'dd/MM/yyyy', 'dd/MM/yy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale fur_IT.
 */
goog.i18n.DateTimeSymbols_fur_IT = goog.i18n.DateTimeSymbols_fur;


/**
 * Date/time formatting symbols for locale ga.
 */
goog.i18n.DateTimeSymbols_ga = {
  ERAS: ['RC', 'AD'],
  ERANAMES: ['Roimh Chríost', 'Anno Domini'],
  NARROWMONTHS: ['E', 'F', 'M', 'A', 'B', 'M', 'I', 'L', 'M', 'D', 'S', 'N'],
  STANDALONENARROWMONTHS: ['E', 'F', 'M', 'A', 'B', 'M', 'I', 'L', 'M', 'D',
      'S', 'N'],
  MONTHS: ['Eanáir', 'Feabhra', 'Márta', 'Aibreán', 'Bealtaine', 'Meitheamh',
      'Iúil', 'Lúnasa', 'Meán Fómhair', 'Deireadh Fómhair', 'Samhain',
      'Nollaig'],
  STANDALONEMONTHS: ['Eanáir', 'Feabhra', 'Márta', 'Aibreán', 'Bealtaine',
      'Meitheamh', 'Iúil', 'Lúnasa', 'Meán Fómhair', 'Deireadh Fómhair',
      'Samhain', 'Nollaig'],
  SHORTMONTHS: ['Ean', 'Feabh', 'Márta', 'Aib', 'Beal', 'Meith', 'Iúil',
      'Lún', 'MFómh', 'DFómh', 'Samh', 'Noll'],
  STANDALONESHORTMONTHS: ['Ean', 'Feabh', 'Márta', 'Aib', 'Beal', 'Meith',
      'Iúil', 'Lún', 'MFómh', 'DFómh', 'Samh', 'Noll'],
  WEEKDAYS: ['Dé Domhnaigh', 'Dé Luain', 'Dé Máirt', 'Dé Céadaoin',
      'Déardaoin', 'Dé hAoine', 'Dé Sathairn'],
  STANDALONEWEEKDAYS: ['Dé Domhnaigh', 'Dé Luain', 'Dé Máirt',
      'Dé Céadaoin', 'Déardaoin', 'Dé hAoine', 'Dé Sathairn'],
  SHORTWEEKDAYS: ['Domh', 'Luan', 'Máirt', 'Céad', 'Déar', 'Aoine', 'Sath'],
  STANDALONESHORTWEEKDAYS: ['Domh', 'Luan', 'Máirt', 'Céad', 'Déar', 'Aoine',
      'Sath'],
  NARROWWEEKDAYS: ['D', 'L', 'M', 'C', 'D', 'A', 'S'],
  STANDALONENARROWWEEKDAYS: ['D', 'L', 'M', 'C', 'D', 'A', 'S'],
  SHORTQUARTERS: ['R1', 'R2', 'R3', 'R4'],
  QUARTERS: ['1ú ráithe', '2ú ráithe', '3ú ráithe', '4ú ráithe'],
  AMPMS: ['a.m.', 'p.m.'],
  DATEFORMATS: ['EEEE d MMMM y', 'd MMMM y', 'd MMM y', 'dd/MM/yyyy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale ga_IE.
 */
goog.i18n.DateTimeSymbols_ga_IE = goog.i18n.DateTimeSymbols_ga;


/**
 * Date/time formatting symbols for locale gaa.
 */
goog.i18n.DateTimeSymbols_gaa = {
  ERAS: ['DJ', 'KJ'],
  ERANAMES: ['Dani Jesu', 'KJ'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['Aharabata', 'Oflo', 'Ochokrikri', 'Abeibee', 'Agbeinaa',
      'Otukwadan', 'Maawe', 'Manyawale', 'Gbo', 'Anton', 'Alemle', 'Afuabee'],
  STANDALONEMONTHS: ['Aharabata', 'Oflo', 'Ochokrikri', 'Abeibee', 'Agbeinaa',
      'Otukwadan', 'Maawe', 'Manyawale', 'Gbo', 'Anton', 'Alemle', 'Afuabee'],
  SHORTMONTHS: ['Aha', 'Ofl', 'Och', 'Abe', 'Agb', 'Otu', 'Maa', 'Man', 'Gbo',
      'Ant', 'Ale', 'Afu'],
  STANDALONESHORTMONTHS: ['Aha', 'Ofl', 'Och', 'Abe', 'Agb', 'Otu', 'Maa',
      'Man', 'Gbo', 'Ant', 'Ale', 'Afu'],
  WEEKDAYS: ['Hogbaa', 'Dzu', 'Dzufo', 'Sho', 'Soo', 'Sohaa', 'Ho'],
  STANDALONEWEEKDAYS: ['Hogbaa', 'Dzu', 'Dzufo', 'Sho', 'Soo', 'Sohaa', 'Ho'],
  SHORTWEEKDAYS: ['Ho', 'Dzu', 'Dzf', 'Sho', 'Soo', 'Soh', 'Ho'],
  STANDALONESHORTWEEKDAYS: ['Ho', 'Dzu', 'Dzf', 'Sho', 'Soo', 'Soh', 'Ho'],
  NARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONENARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['LB', 'SN'],
  DATEFORMATS: ['EEEE, y MMMM dd', 'y MMMM d', 'y MMM d', 'yy/MM/dd'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale gaa_GH.
 */
goog.i18n.DateTimeSymbols_gaa_GH = goog.i18n.DateTimeSymbols_gaa;


/**
 * Date/time formatting symbols for locale gez.
 */
goog.i18n.DateTimeSymbols_gez = {
  ERAS: ['ዓ/ዓ', 'ዓ/ም'],
  ERANAMES: ['ዓ/ዓ', 'ዓ/ም'],
  NARROWMONTHS: ['ጠ', 'ከ', 'መ', 'አ', 'ግ', 'ሠ', 'ሐ', 'ነ', 'ከ',
      'ጠ', 'ኀ', 'ኀ'],
  STANDALONENARROWMONTHS: ['ጠ', 'ከ', 'መ', 'አ', 'ግ', 'ሠ', 'ሐ',
      'ነ', 'ከ', 'ጠ', 'ኀ', 'ኀ'],
  MONTHS: ['ጠሐረ', 'ከተተ', 'መገበ', 'አኀዘ', 'ግንባት',
      'ሠንየ', 'ሐመለ', 'ነሐሰ', 'ከረመ', 'ጠቀመ',
      'ኀደረ', 'ኀሠሠ'],
  STANDALONEMONTHS: ['ጠሐረ', 'ከተተ', 'መገበ', 'አኀዘ',
      'ግንባት', 'ሠንየ', 'ሐመለ', 'ነሐሰ', 'ከረመ',
      'ጠቀመ', 'ኀደረ', 'ኀሠሠ'],
  SHORTMONTHS: ['ጠሐረ', 'ከተተ', 'መገበ', 'አኀዘ',
      'ግንባት', 'ሠንየ', 'ሐመለ', 'ነሐሰ', 'ከረመ',
      'ጠቀመ', 'ኀደረ', 'ኀሠሠ'],
  STANDALONESHORTMONTHS: ['ጠሐረ', 'ከተተ', 'መገበ', 'አኀዘ',
      'ግንባት', 'ሠንየ', 'ሐመለ', 'ነሐሰ', 'ከረመ',
      'ጠቀመ', 'ኀደረ', 'ኀሠሠ'],
  WEEKDAYS: ['እኁድ', 'ሰኑይ', 'ሠሉስ', 'ራብዕ', 'ሐሙስ',
      'ዓርበ', 'ቀዳሚት'],
  STANDALONEWEEKDAYS: ['እኁድ', 'ሰኑይ', 'ሠሉስ', 'ራብዕ',
      'ሐሙስ', 'ዓርበ', 'ቀዳሚት'],
  SHORTWEEKDAYS: ['እኁድ', 'ሰኑይ', 'ሠሉስ', 'ራብዕ',
      'ሐሙስ', 'ዓርበ', 'ቀዳሚት'],
  STANDALONESHORTWEEKDAYS: ['እኁድ', 'ሰኑይ', 'ሠሉስ', 'ራብዕ',
      'ሐሙስ', 'ዓርበ', 'ቀዳሚት'],
  NARROWWEEKDAYS: ['እ', 'ሰ', 'ሠ', 'ራ', 'ሐ', 'ዓ', 'ቀ'],
  STANDALONENARROWWEEKDAYS: ['እ', 'ሰ', 'ሠ', 'ራ', 'ሐ', 'ዓ', 'ቀ'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['ጽባሕ', 'ምሴት'],
  DATEFORMATS: ['EEEE፥ dd MMMM መዓልት y G', 'dd MMMM y', 'dd-MMM-y',
      'dd/MM/yy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale gez_ER.
 */
goog.i18n.DateTimeSymbols_gez_ER = goog.i18n.DateTimeSymbols_gez;


/**
 * Date/time formatting symbols for locale gez_ET.
 */
goog.i18n.DateTimeSymbols_gez_ET = goog.i18n.DateTimeSymbols_gez;


/**
 * Date/time formatting symbols for locale gl_ES.
 */
goog.i18n.DateTimeSymbols_gl_ES = {
  ERAS: ['a.C.', 'd.C.'],
  ERANAMES: ['antes de Cristo', 'despois de Cristo'],
  NARROWMONTHS: ['X', 'F', 'M', 'A', 'M', 'X', 'X', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['X', 'F', 'M', 'A', 'M', 'X', 'X', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['Xaneiro', 'Febreiro', 'Marzo', 'Abril', 'Maio', 'Xuño', 'Xullo',
      'Agosto', 'Setembro', 'Outubro', 'Novembro', 'Decembro'],
  STANDALONEMONTHS: ['Xaneiro', 'Febreiro', 'Marzo', 'Abril', 'Maio', 'Xuño',
      'Xullo', 'Agosto', 'Setembro', 'Outubro', 'Novembro', 'Decembro'],
  SHORTMONTHS: ['Xan', 'Feb', 'Mar', 'Abr', 'Mai', 'Xuñ', 'Xul', 'Ago', 'Set',
      'Out', 'Nov', 'Dec'],
  STANDALONESHORTMONTHS: ['Xan', 'Feb', 'Mar', 'Abr', 'Mai', 'Xuñ', 'Xul',
      'Ago', 'Set', 'Out', 'Nov', 'Dec'],
  WEEKDAYS: ['Domingo', 'Luns', 'Martes', 'Mércores', 'Xoves', 'Venres',
      'Sábado'],
  STANDALONEWEEKDAYS: ['Domingo', 'Luns', 'Martes', 'Mércores', 'Xoves',
      'Venres', 'Sábado'],
  SHORTWEEKDAYS: ['Dom', 'Lun', 'Mar', 'Mér', 'Xov', 'Ven', 'Sáb'],
  STANDALONESHORTWEEKDAYS: ['Dom', 'Lun', 'Mar', 'Mér', 'Xov', 'Ven', 'Sáb'],
  NARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'X', 'V', 'S'],
  STANDALONENARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'X', 'V', 'S'],
  SHORTQUARTERS: ['T1', 'T2', 'T3', 'T4'],
  QUARTERS: ['1o trimestre', '2o trimestre', '3o trimestre', '4o trimestre'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE dd MMMM y', 'dd MMMM y', 'd MMM, y', 'dd/MM/yy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale gsw_CH.
 */
goog.i18n.DateTimeSymbols_gsw_CH = {
  ERAS: ['v. Chr.', 'n. Chr.'],
  ERANAMES: ['v. Chr.', 'n. Chr.'],
  NARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['Januar', 'Februar', 'März', 'April', 'Mai', 'Juni', 'Juli',
      'Auguscht', 'Septämber', 'Oktoober', 'Novämber', 'Dezämber'],
  STANDALONEMONTHS: ['Januar', 'Februar', 'März', 'April', 'Mai', 'Juni',
      'Juli', 'Auguscht', 'Septämber', 'Oktoober', 'Novämber', 'Dezämber'],
  SHORTMONTHS: ['Jan', 'Feb', 'Mär', 'Apr', 'Mai', 'Jun', 'Jul', 'Aug', 'Sep',
      'Okt', 'Nov', 'Dez'],
  STANDALONESHORTMONTHS: ['Jan', 'Feb', 'Mär', 'Apr', 'Mai', 'Jun', 'Jul',
      'Aug', 'Sep', 'Okt', 'Nov', 'Dez'],
  WEEKDAYS: ['Sunntig', 'Määntig', 'Ziischtig', 'Mittwuch', 'Dunschtig',
      'Friitig', 'Samschtig'],
  STANDALONEWEEKDAYS: ['Sunntig', 'Määntig', 'Ziischtig', 'Mittwuch',
      'Dunschtig', 'Friitig', 'Samschtig'],
  SHORTWEEKDAYS: ['Su.', 'Mä.', 'Zi.', 'Mi.', 'Du.', 'Fr.', 'Sa.'],
  STANDALONESHORTWEEKDAYS: ['Su.', 'Mä.', 'Zi.', 'Mi.', 'Du.', 'Fr.', 'Sa.'],
  NARROWWEEKDAYS: ['S', 'M', 'D', 'M', 'D', 'F', 'S'],
  STANDALONENARROWWEEKDAYS: ['S', 'M', 'D', 'M', 'D', 'F', 'S'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['1. Quartal', '2. Quartal', '3. Quartal', '4. Quartal'],
  AMPMS: ['vorm.', 'nam.'],
  DATEFORMATS: ['EEEE, d. MMMM y', 'd. MMMM y', 'dd.MM.yyyy', 'dd.MM.yy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale gu_IN.
 */
goog.i18n.DateTimeSymbols_gu_IN = {
  ERAS: ['ઈલુના જન્મ પહેસાં',
      'ઇસવીસન'],
  ERANAMES: ['ઈસવીસન પૂર્વે', 'ઇસવીસન'],
  NARROWMONTHS: ['જા', 'ફે', 'મા', 'એ', 'મે', 'જૂ',
      'જુ', 'ઑ', 'સ', 'ઑ', 'ન', 'ડિ'],
  STANDALONENARROWMONTHS: ['જા', 'ફે', 'મા', 'એ', 'મે',
      'જૂ', 'જુ', 'ઑ', 'સ', 'ઑ', 'ન', 'ડિ'],
  MONTHS: ['જાન્યુઆરી', 'ફેબ્રુઆરી',
      'માર્ચ', 'એપ્રિલ', 'મે', 'જૂન',
      'જુલાઈ', 'ઑગસ્ટ', 'સપ્ટેમ્બર',
      'ઑક્ટ્બર', 'નવેમ્બર',
      'ડિસેમ્બર'],
  STANDALONEMONTHS: ['જાન્યુઆરી',
      'ફેબ્રુઆરી', 'માર્ચ', 'એપ્રિલ',
      'મે', 'જૂન', 'જુલાઈ', 'ઑગસ્ટ',
      'સપ્ટેમ્બર', 'ઑક્ટ્બર',
      'નવેમ્બર', 'ડિસેમ્બર'],
  SHORTMONTHS: ['જાન્યુ', 'ફેબ્રુ', 'માર્ચ',
      'એપ્રિલ', 'મે', 'જૂન', 'જુલાઈ',
      'ઑગસ્ટ', 'સપ્ટે', 'ઑક્ટો', 'નવે',
      'ડિસે'],
  STANDALONESHORTMONTHS: ['જાન્યુ', 'ફેબ્રુ',
      'માર્ચ', 'એપ્રિલ', 'મે', 'જૂન',
      'જુલાઈ', 'ઑગસ્ટ', 'સપ્ટે',
      'ઑક્ટો', 'નવે', 'ડિસે'],
  WEEKDAYS: ['રવિવાર', 'સોમવાર',
      'મંગળવાર', 'બુધવાર', 'ગુરુવાર',
      'શુક્રવાર', 'શનિવાર'],
  STANDALONEWEEKDAYS: ['રવિવાર', 'સોમવાર',
      'મંગળવાર', 'બુધવાર', 'ગુરુવાર',
      'શુક્રવાર', 'શનિવાર'],
  SHORTWEEKDAYS: ['રવિ', 'સોમ', 'મંગળ', 'બુધ',
      'ગુરુ', 'શુક્ર', 'શનિ'],
  STANDALONESHORTWEEKDAYS: ['રવિ', 'સોમ', 'મંગળ',
      'બુધ', 'ગુરુ', 'શુક્ર', 'શનિ'],
  NARROWWEEKDAYS: ['ર', 'સો', 'મં', 'બુ', 'ગુ', 'શુ',
      'શ'],
  STANDALONENARROWWEEKDAYS: ['ર', 'સો', 'મં', 'બુ', 'ગુ',
      'શુ', 'શ'],
  SHORTQUARTERS: ['પેહલા હંત 1',
      'ત્રિમાસિક ૨', 'ત્રિમાસિક ૩',
      'ચૌતા હંત 4'],
  QUARTERS: ['પેહલા હંત 1', 'ડૂસઋા હંત 2',
      'તીસઋા હંત 3', 'ચૌતા હંત 4'],
  AMPMS: ['પૂર્વ મધ્યાહ્ન',
      'ઉત્તર મધ્યાહ્ન'],
  DATEFORMATS: ['EEEE, d MMMM, y', 'd MMMM, y', 'd MMM, y', 'd-MM-yy'],
  TIMEFORMATS: ['hh:mm:ss a zzzz', 'hh:mm:ss a z', 'hh:mm:ss a', 'hh:mm a'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [6, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale gv.
 */
goog.i18n.DateTimeSymbols_gv = {
  ERAS: ['RC', 'AD'],
  ERANAMES: ['RC', 'AD'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['Jerrey-geuree', 'Toshiaght-arree', 'Mayrnt', 'Averil', 'Boaldyn',
      'Mean-souree', 'Jerrey-souree', 'Luanistyn', 'Mean-fouyir',
      'Jerrey-fouyir', 'Mee Houney', 'Mee ny Nollick'],
  STANDALONEMONTHS: ['Jerrey-geuree', 'Toshiaght-arree', 'Mayrnt', 'Averil',
      'Boaldyn', 'Mean-souree', 'Jerrey-souree', 'Luanistyn', 'Mean-fouyir',
      'Jerrey-fouyir', 'Mee Houney', 'Mee ny Nollick'],
  SHORTMONTHS: ['J-guer', 'T-arree', 'Mayrnt', 'Avrril', 'Boaldyn', 'M-souree',
      'J-souree', 'Luanistyn', 'M-fouyir', 'J-fouyir', 'M.Houney', 'M.Nollick'],
  STANDALONESHORTMONTHS: ['J-guer', 'T-arree', 'Mayrnt', 'Avrril', 'Boaldyn',
      'M-souree', 'J-souree', 'Luanistyn', 'M-fouyir', 'J-fouyir', 'M.Houney',
      'M.Nollick'],
  WEEKDAYS: ['Jedoonee', 'Jelhein', 'Jemayrt', 'Jercean', 'Jerdein', 'Jeheiney',
      'Jesarn'],
  STANDALONEWEEKDAYS: ['Jedoonee', 'Jelhein', 'Jemayrt', 'Jercean', 'Jerdein',
      'Jeheiney', 'Jesarn'],
  SHORTWEEKDAYS: ['Jed', 'Jel', 'Jem', 'Jerc', 'Jerd', 'Jeh', 'Jes'],
  STANDALONESHORTWEEKDAYS: ['Jed', 'Jel', 'Jem', 'Jerc', 'Jerd', 'Jeh', 'Jes'],
  NARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONENARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['a.m.', 'p.m.'],
  DATEFORMATS: ['EEEE dd MMMM y', 'dd MMMM y', 'MMM dd, y', 'dd/MM/yy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale gv_GB.
 */
goog.i18n.DateTimeSymbols_gv_GB = goog.i18n.DateTimeSymbols_gv;


/**
 * Date/time formatting symbols for locale ha.
 */
goog.i18n.DateTimeSymbols_ha = {
  ERAS: ['KHAI', 'BHAI'],
  ERANAMES: ['Kafin haihuwar annab', 'Bayan haihuwar annab'],
  NARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'Y', 'Y', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'Y', 'Y', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['Janairu', 'Faburairu', 'Maris', 'Afirilu', 'Mayu', 'Yuni', 'Yuli',
      'Agusta', 'Satumba', 'Oktoba', 'Nuwamba', 'Disamba'],
  STANDALONEMONTHS: ['Janairu', 'Faburairu', 'Maris', 'Afirilu', 'Mayu', 'Yuni',
      'Yuli', 'Agusta', 'Satumba', 'Oktoba', 'Nuwamba', 'Disamba'],
  SHORTMONTHS: ['Jan', 'Fab', 'Mar', 'Afi', 'May', 'Yun', 'Yul', 'Agu', 'Sat',
      'Okt', 'Nuw', 'Dis'],
  STANDALONESHORTMONTHS: ['Jan', 'Fab', 'Mar', 'Afi', 'May', 'Yun', 'Yul',
      'Agu', 'Sat', 'Okt', 'Nuw', 'Dis'],
  WEEKDAYS: ['Lahadi', 'Litinin', 'Talata', 'Laraba', 'Alhamis', 'Jumma\'a',
      'Asabar'],
  STANDALONEWEEKDAYS: ['Lahadi', 'Litinin', 'Talata', 'Laraba', 'Alhamis',
      'Jumma\'a', 'Asabar'],
  SHORTWEEKDAYS: ['Lh', 'Li', 'Ta', 'Lr', 'Al', 'Ju', 'As'],
  STANDALONESHORTWEEKDAYS: ['Lh', 'Li', 'Ta', 'Lr', 'Al', 'Ju', 'As'],
  NARROWWEEKDAYS: ['L', 'L', 'T', 'L', 'A', 'J', 'A'],
  STANDALONENARROWWEEKDAYS: ['L', 'L', 'T', 'L', 'A', 'J', 'A'],
  SHORTQUARTERS: ['K1', 'K2', 'K3', 'K4'],
  QUARTERS: ['Kwata na ɗaya', 'Kwata na biyu', 'Kwata na uku',
      'Kwata na huɗu'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, d MMMM, y', 'd MMMM, y', 'd MMM, y', 'd/M/yy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale ha_Arab.
 */
goog.i18n.DateTimeSymbols_ha_Arab = {
  ERAS: ['غَبَنِنْ مِلَدِ', 'مِلَدِ'],
  ERANAMES: ['غَبَنِنْ مِلَدِ', 'مِلَدِ'],
  NARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'Y', 'Y', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'Y', 'Y', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['جَنَيْرُ', 'ڢَبْرَيْرُ', 'مَرِسْ',
      'أَڢْرِلُ', 'مَيُ', 'يُونِ', 'يُولِ',
      'أَغُسْتَ', 'سَتُمْبَ', 'أُكْتوُبَ',
      'نُوَمْبَ', 'دِسَمْبَ'],
  STANDALONEMONTHS: ['جَنَيْرُ', 'ڢَبْرَيْرُ', 'مَرِسْ',
      'أَڢْرِلُ', 'مَيُ', 'يُونِ', 'يُولِ',
      'أَغُسْتَ', 'سَتُمْبَ', 'أُكْتوُبَ',
      'نُوَمْبَ', 'دِسَمْبَ'],
  SHORTMONTHS: ['جَن', 'ڢَب', 'مَر', 'أَڢْر', 'مَي',
      'يُون', 'يُول', 'أَغُ', 'سَت', 'أُكْت', 'نُو',
      'دِس'],
  STANDALONESHORTMONTHS: ['جَن', 'ڢَب', 'مَر', 'أَڢْر', 'مَي',
      'يُون', 'يُول', 'أَغُ', 'سَت', 'أُكْت', 'نُو',
      'دِس'],
  WEEKDAYS: ['لَحَدِ', 'لِتِنِنْ', 'تَلَتَ', 'لَرَبَ',
      'أَلْحَمِسْ', 'جُمَعَ', 'أَسَبَرْ'],
  STANDALONEWEEKDAYS: ['لَحَدِ', 'لِتِنِنْ', 'تَلَتَ',
      'لَرَبَ', 'أَلْحَمِسْ', 'جُمَعَ',
      'أَسَبَرْ'],
  SHORTWEEKDAYS: ['لَح', 'لِت', 'تَل', 'لَر', 'أَلْح',
      'جُم', 'أَسَ'],
  STANDALONESHORTWEEKDAYS: ['لَح', 'لِت', 'تَل', 'لَر',
      'أَلْح', 'جُم', 'أَسَ'],
  NARROWWEEKDAYS: ['L', 'L', 'T', 'L', 'A', 'J', 'A'],
  STANDALONENARROWWEEKDAYS: ['L', 'L', 'T', 'L', 'A', 'J', 'A'],
  SHORTQUARTERS: ['K1', 'K2', 'K3', 'K4'],
  QUARTERS: ['Kwata na ɗaya', 'Kwata na biyu', 'Kwata na uku',
      'Kwata na huɗu'],
  AMPMS: ['A.M.', 'P.M.'],
  DATEFORMATS: ['EEEE, d MMMM, y', 'd MMMM, y', 'd MMM, y', 'd/M/yy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale ha_Arab_NG.
 */
goog.i18n.DateTimeSymbols_ha_Arab_NG = goog.i18n.DateTimeSymbols_ha_Arab;


/**
 * Date/time formatting symbols for locale ha_Arab_SD.
 */
goog.i18n.DateTimeSymbols_ha_Arab_SD = goog.i18n.DateTimeSymbols_ha_Arab;


/**
 * Date/time formatting symbols for locale ha_GH.
 */
goog.i18n.DateTimeSymbols_ha_GH = goog.i18n.DateTimeSymbols_ha;


/**
 * Date/time formatting symbols for locale ha_Latn.
 */
goog.i18n.DateTimeSymbols_ha_Latn = goog.i18n.DateTimeSymbols_ha;


/**
 * Date/time formatting symbols for locale ha_Latn_GH.
 */
goog.i18n.DateTimeSymbols_ha_Latn_GH = goog.i18n.DateTimeSymbols_ha;


/**
 * Date/time formatting symbols for locale ha_Latn_NE.
 */
goog.i18n.DateTimeSymbols_ha_Latn_NE = goog.i18n.DateTimeSymbols_ha;


/**
 * Date/time formatting symbols for locale ha_Latn_NG.
 */
goog.i18n.DateTimeSymbols_ha_Latn_NG = goog.i18n.DateTimeSymbols_ha;


/**
 * Date/time formatting symbols for locale ha_NE.
 */
goog.i18n.DateTimeSymbols_ha_NE = goog.i18n.DateTimeSymbols_ha;


/**
 * Date/time formatting symbols for locale ha_NG.
 */
goog.i18n.DateTimeSymbols_ha_NG = goog.i18n.DateTimeSymbols_ha;


/**
 * Date/time formatting symbols for locale ha_SD.
 */
goog.i18n.DateTimeSymbols_ha_SD = {
  ERAS: ['غَبَنِنْ مِلَدِ', 'مِلَدِ'],
  ERANAMES: ['غَبَنِنْ مِلَدِ', 'مِلَدِ'],
  NARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'Y', 'Y', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'Y', 'Y', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['جَنَيْرُ', 'ڢَبْرَيْرُ', 'مَرِسْ',
      'أَڢْرِلُ', 'مَيُ', 'يُونِ', 'يُولِ',
      'أَغُسْتَ', 'سَتُمْبَ', 'أُكْتوُبَ',
      'نُوَمْبَ', 'دِسَمْبَ'],
  STANDALONEMONTHS: ['جَنَيْرُ', 'ڢَبْرَيْرُ', 'مَرِسْ',
      'أَڢْرِلُ', 'مَيُ', 'يُونِ', 'يُولِ',
      'أَغُسْتَ', 'سَتُمْبَ', 'أُكْتوُبَ',
      'نُوَمْبَ', 'دِسَمْبَ'],
  SHORTMONTHS: ['جَن', 'ڢَب', 'مَر', 'أَڢْر', 'مَي',
      'يُون', 'يُول', 'أَغُ', 'سَت', 'أُكْت', 'نُو',
      'دِس'],
  STANDALONESHORTMONTHS: ['جَن', 'ڢَب', 'مَر', 'أَڢْر', 'مَي',
      'يُون', 'يُول', 'أَغُ', 'سَت', 'أُكْت', 'نُو',
      'دِس'],
  WEEKDAYS: ['لَحَدِ', 'لِتِنِنْ', 'تَلَتَ', 'لَرَبَ',
      'أَلْحَمِسْ', 'جُمَعَ', 'أَسَبَرْ'],
  STANDALONEWEEKDAYS: ['لَحَدِ', 'لِتِنِنْ', 'تَلَتَ',
      'لَرَبَ', 'أَلْحَمِسْ', 'جُمَعَ',
      'أَسَبَرْ'],
  SHORTWEEKDAYS: ['لَح', 'لِت', 'تَل', 'لَر', 'أَلْح',
      'جُم', 'أَسَ'],
  STANDALONESHORTWEEKDAYS: ['لَح', 'لِت', 'تَل', 'لَر',
      'أَلْح', 'جُم', 'أَسَ'],
  NARROWWEEKDAYS: ['L', 'L', 'T', 'L', 'A', 'J', 'A'],
  STANDALONENARROWWEEKDAYS: ['L', 'L', 'T', 'L', 'A', 'J', 'A'],
  SHORTQUARTERS: ['K1', 'K2', 'K3', 'K4'],
  QUARTERS: ['Kwata na ɗaya', 'Kwata na biyu', 'Kwata na uku',
      'Kwata na huɗu'],
  AMPMS: ['A.M.', 'P.M.'],
  DATEFORMATS: ['EEEE, d MMMM, y', 'd MMMM, y', 'd MMM, y', 'd/M/yy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 5,
  WEEKENDRANGE: [3, 4],
  FIRSTWEEKCUTOFFDAY: 1
};


/**
 * Date/time formatting symbols for locale haw.
 */
goog.i18n.DateTimeSymbols_haw = {
  ERAS: ['BCE', 'CE'],
  ERANAMES: ['BCE', 'CE'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['Ianuali', 'Pepeluali', 'Malaki', 'ʻApelila', 'Mei', 'Iune',
      'Iulai', 'ʻAukake', 'Kepakemapa', 'ʻOkakopa', 'Nowemapa', 'Kekemapa'],
  STANDALONEMONTHS: ['Ianuali', 'Pepeluali', 'Malaki', 'ʻApelila', 'Mei',
      'Iune', 'Iulai', 'ʻAukake', 'Kepakemapa', 'ʻOkakopa', 'Nowemapa',
      'Kekemapa'],
  SHORTMONTHS: ['Ian.', 'Pep.', 'Mal.', 'ʻAp.', 'Mei', 'Iun.', 'Iul.', 'ʻAu.',
      'Kep.', 'ʻOk.', 'Now.', 'Kek.'],
  STANDALONESHORTMONTHS: ['Ian.', 'Pep.', 'Mal.', 'ʻAp.', 'Mei', 'Iun.',
      'Iul.', 'ʻAu.', 'Kep.', 'ʻOk.', 'Now.', 'Kek.'],
  WEEKDAYS: ['Lāpule', 'Poʻakahi', 'Poʻalua', 'Poʻakolu', 'Poʻahā',
      'Poʻalima', 'Poʻaono'],
  STANDALONEWEEKDAYS: ['Lāpule', 'Poʻakahi', 'Poʻalua', 'Poʻakolu',
      'Poʻahā', 'Poʻalima', 'Poʻaono'],
  SHORTWEEKDAYS: ['LP', 'P1', 'P2', 'P3', 'P4', 'P5', 'P6'],
  STANDALONESHORTWEEKDAYS: ['LP', 'P1', 'P2', 'P3', 'P4', 'P5', 'P6'],
  NARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONENARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, d MMMM y', 'd MMMM y', 'd MMM y', 'd/M/yy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale haw_US.
 */
goog.i18n.DateTimeSymbols_haw_US = goog.i18n.DateTimeSymbols_haw;


/**
 * Date/time formatting symbols for locale he_IL.
 */
goog.i18n.DateTimeSymbols_he_IL = {
  ERAS: ['לפנה״ס', 'לסה״נ'],
  ERANAMES: ['לפני הספירה', 'לספירה'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['ינואר', 'פברואר', 'מרס', 'אפריל', 'מאי',
      'יוני', 'יולי', 'אוגוסט', 'ספטמבר', 'אוקטובר',
      'נובמבר', 'דצמבר'],
  STANDALONEMONTHS: ['ינואר', 'פברואר', 'מרס', 'אפריל',
      'מאי', 'יוני', 'יולי', 'אוגוסט', 'ספטמבר',
      'אוקטובר', 'נובמבר', 'דצמבר'],
  SHORTMONTHS: ['ינו', 'פבר', 'מרס', 'אפר', 'מאי', 'יונ',
      'יול', 'אוג', 'ספט', 'אוק', 'נוב', 'דצמ'],
  STANDALONESHORTMONTHS: ['ינו׳', 'פבר׳', 'מרס', 'אפר׳',
      'מאי', 'יונ׳', 'יול׳', 'אוג׳', 'ספט׳', 'אוק׳',
      'נוב׳', 'דצמ׳'],
  WEEKDAYS: ['יום ראשון', 'יום שני', 'יום שלישי',
      'יום רביעי', 'יום חמישי', 'יום שישי',
      'יום שבת'],
  STANDALONEWEEKDAYS: ['יום ראשון', 'יום שני',
      'יום שלישי', 'יום רביעי', 'יום חמישי',
      'יום שישי', 'יום שבת'],
  SHORTWEEKDAYS: ['יום א׳', 'יום ב׳', 'יום ג׳', 'יום ד׳',
      'יום ה׳', 'יום ו׳', 'שבת'],
  STANDALONESHORTWEEKDAYS: ['יום א׳', 'יום ב׳', 'יום ג׳',
      'יום ד׳', 'יום ה׳', 'יום ו׳', 'שבת'],
  NARROWWEEKDAYS: ['א', 'ב', 'ג', 'ד', 'ה', 'ו', 'ש'],
  STANDALONENARROWWEEKDAYS: ['א', 'ב', 'ג', 'ד', 'ה', 'ו', 'ש'],
  SHORTQUARTERS: ['רבעון 1', 'רבעון 2', 'רבעון 3',
      'רבעון 4'],
  QUARTERS: ['רבעון 1', 'רבעון 2', 'רבעון 3', 'רבעון 4'],
  AMPMS: ['לפנה״צ', 'אחה״צ'],
  DATEFORMATS: ['EEEE, d בMMMM y', 'd בMMMM y', 'd בMMM yyyy', 'dd/MM/yy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [4, 5],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale hi_IN.
 */
goog.i18n.DateTimeSymbols_hi_IN = {
  ERAS: ['ईसापूर्व', 'सन'],
  ERANAMES: ['ईसापूर्व', 'सन'],
  NARROWMONTHS: ['ज', 'फ़', 'मा', 'अ', 'म', 'जू', 'जु',
      'अ', 'सि', 'अ', 'न', 'दि'],
  STANDALONENARROWMONTHS: ['ज', 'फ़', 'मा', 'अ', 'म', 'जू',
      'जु', 'अ', 'सि', 'अ', 'न', 'दि'],
  MONTHS: ['जनवरी', 'फरवरी', 'मार्च',
      'अप्रैल', 'मई', 'जून', 'जुलाई',
      'अगस्त', 'सितम्बर', 'अक्तूबर',
      'नवम्बर', 'दिसम्बर'],
  STANDALONEMONTHS: ['जनवरी', 'फरवरी', 'मार्च',
      'अप्रैल', 'मई', 'जून', 'जुलाई',
      'अगस्त', 'सितम्बर', 'अक्तूबर',
      'नवम्बर', 'दिसम्बर'],
  SHORTMONTHS: ['जनवरी', 'फरवरी', 'मार्च',
      'अप्रैल', 'मई', 'जून', 'जुलाई',
      'अगस्त', 'सितम्बर', 'अक्तूबर',
      'नवम्बर', 'दिसम्बर'],
  STANDALONESHORTMONTHS: ['जनवरी', 'फरवरी',
      'मार्च', 'अप्रैल', 'मई', 'जून',
      'जुलाई', 'अगस्त', 'सितम्बर',
      'अक्तूबर', 'नवम्बर', 'दिसम्बर'],
  WEEKDAYS: ['रविवार', 'सोमवार',
      'मंगलवार', 'बुधवार',
      'बृहस्पतिवार', 'शुक्रवार',
      'शनिवार'],
  STANDALONEWEEKDAYS: ['रविवार', 'सोमवार',
      'मंगलवार', 'बुधवार',
      'बृहस्पतिवार', 'शुक्रवार',
      'शनिवार'],
  SHORTWEEKDAYS: ['रवि.', 'सोम.', 'मंगल.', 'बुध.',
      'बृह.', 'शुक्र.', 'शनि.'],
  STANDALONESHORTWEEKDAYS: ['रवि.', 'सोम.', 'मंगल.',
      'बुध.', 'बृह.', 'शुक्र.', 'शनि.'],
  NARROWWEEKDAYS: ['र', 'सो', 'मं', 'बु', 'गु', 'शु',
      'श'],
  STANDALONENARROWWEEKDAYS: ['र', 'सो', 'मं', 'बु', 'गु',
      'शु', 'श'],
  SHORTQUARTERS: ['तिमाही', 'दूसरी तिमाही',
      'तीसरी तिमाही', 'चौथी तिमाही'],
  QUARTERS: ['तिमाही', 'दूसरी तिमाही',
      'तीसरी तिमाही', 'चौथी तिमाही'],
  AMPMS: ['पूर्वाह्न', 'अपराह्न'],
  DATEFORMATS: ['EEEE, d MMMM y', 'd MMMM y', 'dd-MM-yyyy', 'd-M-yy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [6, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale hr_HR.
 */
goog.i18n.DateTimeSymbols_hr_HR = {
  ERAS: ['p. n. e.', 'A. D.'],
  ERANAMES: ['Prije Krista', 'Poslije Krista'],
  NARROWMONTHS: ['1.', '2.', '3.', '4.', '5.', '6.', '7.', '8.', '9.', '10.',
      '11.', '12.'],
  STANDALONENARROWMONTHS: ['1.', '2.', '3.', '4.', '5.', '6.', '7.', '8.', '9.',
      '10.', '11.', '12.'],
  MONTHS: ['siječnja', 'veljače', 'ožujka', 'travnja', 'svibnja', 'lipnja',
      'srpnja', 'kolovoza', 'rujna', 'listopada', 'studenoga', 'prosinca'],
  STANDALONEMONTHS: ['siječanj', 'veljača', 'ožujak', 'travanj', 'svibanj',
      'lipanj', 'srpanj', 'kolovoz', 'rujan', 'listopad', 'studeni',
      'prosinac'],
  SHORTMONTHS: ['sij', 'velj', 'ožu', 'tra', 'svi', 'lip', 'srp', 'kol', 'ruj',
      'lis', 'stu', 'pro'],
  STANDALONESHORTMONTHS: ['sij', 'velj', 'ožu', 'tra', 'svi', 'lip', 'srp',
      'kol', 'ruj', 'lis', 'stu', 'pro'],
  WEEKDAYS: ['nedjelja', 'ponedjeljak', 'utorak', 'srijeda', 'četvrtak',
      'petak', 'subota'],
  STANDALONEWEEKDAYS: ['nedjelja', 'ponedjeljak', 'utorak', 'srijeda',
      'četvrtak', 'petak', 'subota'],
  SHORTWEEKDAYS: ['ned', 'pon', 'uto', 'sri', 'čet', 'pet', 'sub'],
  STANDALONESHORTWEEKDAYS: ['ned', 'pon', 'uto', 'sri', 'čet', 'pet', 'sub'],
  NARROWWEEKDAYS: ['n', 'p', 'u', 's', 'č', 'p', 's'],
  STANDALONENARROWWEEKDAYS: ['n', 'p', 'u', 's', 'č', 'p', 's'],
  SHORTQUARTERS: ['1kv', '2kv', '3kv', '4kv'],
  QUARTERS: ['1. kvartal', '2. kvartal', '3. kvartal', '4. kvartal'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, d. MMMM y.', 'd. MMMM y.', 'd. M. yyyy.',
      'dd. MM. yyyy.'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale hu_HU.
 */
goog.i18n.DateTimeSymbols_hu_HU = {
  ERAS: ['i. e.', 'i. sz.'],
  ERANAMES: ['időszámításunk előtt', 'időszámításunk szerint'],
  NARROWMONTHS: ['J', 'F', 'M', 'Á', 'M', 'J', 'J', 'A', 'Sz', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['J', 'F', 'M', 'Á', 'M', 'J', 'J', 'A', 'Sz', 'O',
      'N', 'D'],
  MONTHS: ['január', 'február', 'március', 'április', 'május', 'június',
      'július', 'augusztus', 'szeptember', 'október', 'november', 'december'],
  STANDALONEMONTHS: ['január', 'február', 'március', 'április', 'május',
      'június', 'július', 'augusztus', 'szeptember', 'október', 'november',
      'december'],
  SHORTMONTHS: ['jan.', 'febr.', 'márc.', 'ápr.', 'máj.', 'jún.', 'júl.',
      'aug.', 'szept.', 'okt.', 'nov.', 'dec.'],
  STANDALONESHORTMONTHS: ['jan.', 'febr.', 'márc.', 'ápr.', 'máj.', 'jún.',
      'júl.', 'aug.', 'szept.', 'okt.', 'nov.', 'dec.'],
  WEEKDAYS: ['vasárnap', 'hétfő', 'kedd', 'szerda', 'csütörtök',
      'péntek', 'szombat'],
  STANDALONEWEEKDAYS: ['vasárnap', 'hétfő', 'kedd', 'szerda', 'csütörtök',
      'péntek', 'szombat'],
  SHORTWEEKDAYS: ['V', 'H', 'K', 'Sze', 'Cs', 'P', 'Szo'],
  STANDALONESHORTWEEKDAYS: ['V', 'H', 'K', 'Sze', 'Cs', 'P', 'Szo'],
  NARROWWEEKDAYS: ['V', 'H', 'K', 'Sz', 'Cs', 'P', 'Sz'],
  STANDALONENARROWWEEKDAYS: ['V', 'H', 'K', 'Sz', 'Cs', 'P', 'Sz'],
  SHORTQUARTERS: ['N1', 'N2', 'N3', 'N4'],
  QUARTERS: ['I. negyedév', 'II. negyedév', 'III. negyedév',
      'IV. negyedév'],
  AMPMS: ['de.', 'du.'],
  DATEFORMATS: ['y. MMMM d., EEEE', 'y. MMMM d.', 'yyyy.MM.dd.', 'yyyy.MM.dd.'],
  TIMEFORMATS: ['H:mm:ss zzzz', 'H:mm:ss z', 'H:mm:ss', 'H:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale hy.
 */
goog.i18n.DateTimeSymbols_hy = {
  ERAS: ['Մ․Թ․Ա․', 'Մ․Թ․'],
  ERANAMES: ['Մ․Թ․Ա․', 'Մ․Թ․'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['Հունվար', 'Փետրվար', 'Մարտ', 'Ապրիլ',
      'Մայիս', 'Հունիս', 'Հուլիս', 'Օգոստոս',
      'Սեպտեմբեր', 'Հոկտեմբեր', 'Նոյեմբեր',
      'Դեկտեմբեր'],
  STANDALONEMONTHS: ['Հունվար', 'Փետրվար', 'Մարտ',
      'Ապրիլ', 'Մայիս', 'Հունիս', 'Հուլիս',
      'Օգոստոս', 'Սեպտեմբեր', 'Հոկտեմբեր',
      'Նոյեմբեր', 'Դեկտեմբեր'],
  SHORTMONTHS: ['Հնվ', 'Փտվ', 'Մրտ', 'Ապր', 'Մյս', 'Հնս',
      'Հլս', 'Օգս', 'Սեպ', 'Հոկ', 'Նոյ', 'Դեկ'],
  STANDALONESHORTMONTHS: ['Հնվ', 'Փտվ', 'Մրտ', 'Ապր', 'Մյս',
      'Հնս', 'Հլս', 'Օգս', 'Սեպ', 'Հոկ', 'Նոյ', 'Դեկ'],
  WEEKDAYS: ['Կիրակի', 'Երկուշաբթի', 'Երեքշաբթի',
      'Չորեքշաբթի', 'Հինգշաբթի', 'Ուրբաթ',
      'Շաբաթ'],
  STANDALONEWEEKDAYS: ['Կիրակի', 'Երկուշաբթի',
      'Երեքշաբթի', 'Չորեքշաբթի', 'Հինգշաբթի',
      'Ուրբաթ', 'Շաբաթ'],
  SHORTWEEKDAYS: ['Կիր', 'Երկ', 'Երք', 'Չոր', 'Հնգ', 'Ուր',
      'Շաբ'],
  STANDALONESHORTWEEKDAYS: ['Կիր', 'Երկ', 'Երք', 'Չոր', 'Հնգ',
      'Ուր', 'Շաբ'],
  NARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONENARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['Առ․', 'Կե․'],
  DATEFORMATS: ['EEEE, MMMM d, y', 'MMMM dd, y', 'MMM d, y', 'MM/dd/yy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale hy_AM.
 */
goog.i18n.DateTimeSymbols_hy_AM = goog.i18n.DateTimeSymbols_hy;


/**
 * Date/time formatting symbols for locale ia.
 */
goog.i18n.DateTimeSymbols_ia = {
  ERAS: ['a.Chr.', 'p.Chr.'],
  ERANAMES: ['ante Christo', 'post Christo'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['januario', 'februario', 'martio', 'april', 'maio', 'junio', 'julio',
      'augusto', 'septembre', 'octobre', 'novembre', 'decembre'],
  STANDALONEMONTHS: ['januario', 'februario', 'martio', 'april', 'maio',
      'junio', 'julio', 'augusto', 'septembre', 'octobre', 'novembre',
      'decembre'],
  SHORTMONTHS: ['jan', 'feb', 'mar', 'apr', 'mai', 'jun', 'jul', 'aug', 'sep',
      'oct', 'nov', 'dec'],
  STANDALONESHORTMONTHS: ['jan', 'feb', 'mar', 'apr', 'mai', 'jun', 'jul',
      'aug', 'sep', 'oct', 'nov', 'dec'],
  WEEKDAYS: ['dominica', 'lunedi', 'martedi', 'mercuridi', 'jovedi', 'venerdi',
      'sabbato'],
  STANDALONEWEEKDAYS: ['dominica', 'lunedi', 'martedi', 'mercuridi', 'jovedi',
      'venerdi', 'sabbato'],
  SHORTWEEKDAYS: ['dom', 'lun', 'mar', 'mer', 'jov', 'ven', 'sab'],
  STANDALONESHORTWEEKDAYS: ['dom', 'lun', 'mar', 'mer', 'jov', 'ven', 'sab'],
  NARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONENARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTQUARTERS: ['T1', 'T2', 'T3', 'T4'],
  QUARTERS: ['1-me trimestre', '2-nde trimestre', '3-tie trimestre',
      '4-te trimestre'],
  AMPMS: ['a.m.', 'p.m.'],
  DATEFORMATS: ['EEEE, y MMMM dd', 'y MMMM d', 'y MMM d', 'yy/MM/dd'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale id_ID.
 */
goog.i18n.DateTimeSymbols_id_ID = {
  ERAS: ['SM', 'M'],
  ERANAMES: ['SM', 'M'],
  NARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni', 'Juli',
      'Agustus', 'September', 'Oktober', 'November', 'Desember'],
  STANDALONEMONTHS: ['Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni',
      'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'],
  SHORTMONTHS: ['Jan', 'Feb', 'Mar', 'Apr', 'Mei', 'Jun', 'Jul', 'Agt', 'Sep',
      'Okt', 'Nov', 'Des'],
  STANDALONESHORTMONTHS: ['Jan', 'Feb', 'Mar', 'Apr', 'Mei', 'Jun', 'Jul',
      'Agt', 'Sep', 'Okt', 'Nov', 'Des'],
  WEEKDAYS: ['Minggu', 'Senin', 'Selasa', 'Rabu', 'Kamis', 'Jumat', 'Sabtu'],
  STANDALONEWEEKDAYS: ['Minggu', 'Senin', 'Selasa', 'Rabu', 'Kamis', 'Jumat',
      'Sabtu'],
  SHORTWEEKDAYS: ['Min', 'Sen', 'Sel', 'Rab', 'Kam', 'Jum', 'Sab'],
  STANDALONESHORTWEEKDAYS: ['Min', 'Sen', 'Sel', 'Rab', 'Kam', 'Jum', 'Sab'],
  NARROWWEEKDAYS: ['M', 'S', 'S', 'R', 'K', 'J', 'S'],
  STANDALONENARROWWEEKDAYS: ['M', 'S', 'S', 'R', 'K', 'J', 'S'],
  SHORTQUARTERS: ['K1', 'K2', 'K3', 'K4'],
  QUARTERS: ['kuartal pertama', 'kuartal kedua', 'kuartal ketiga',
      'kuartal keempat'],
  AMPMS: ['pagi', 'malam'],
  DATEFORMATS: ['EEEE, dd MMMM yyyy', 'd MMMM yyyy', 'd MMM yyyy', 'dd/MM/yy'],
  TIMEFORMATS: ['H:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale ig.
 */
goog.i18n.DateTimeSymbols_ig = {
  ERAS: ['T.K.', 'A.K.'],
  ERANAMES: ['Tupu Kristi', 'Afọ Kristi'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['Jenụwarị', 'Febrụwarị', 'Maachị', 'Eprel', 'Mee', 'Juun',
      'Julaị', 'Ọgọọst', 'Septemba', 'Ọktoba', 'Novemba', 'Disemba'],
  STANDALONEMONTHS: ['Jenụwarị', 'Febrụwarị', 'Maachị', 'Eprel',
      'Mee', 'Juun', 'Julaị', 'Ọgọọst', 'Septemba', 'Ọktoba',
      'Novemba', 'Disemba'],
  SHORTMONTHS: ['Jen', 'Feb', 'Maa', 'Epr', 'Mee', 'Juu', 'Jul', 'Ọgọ',
      'Sep', 'Ọkt', 'Nov', 'Dis'],
  STANDALONESHORTMONTHS: ['Jen', 'Feb', 'Maa', 'Epr', 'Mee', 'Juu', 'Jul',
      'Ọgọ', 'Sep', 'Ọkt', 'Nov', 'Dis'],
  WEEKDAYS: ['Mbọsị Ụka', 'Mọnde', 'Tiuzdee', 'Wenezdee', 'Tọọzdee',
      'Fraịdee', 'Satọdee'],
  STANDALONEWEEKDAYS: ['Mbọsị Ụka', 'Mọnde', 'Tiuzdee', 'Wenezdee',
      'Tọọzdee', 'Fraịdee', 'Satọdee'],
  SHORTWEEKDAYS: ['Ụka', 'Mọn', 'Tiu', 'Wen', 'Tọọ', 'Fraị', 'Sat'],
  STANDALONESHORTWEEKDAYS: ['Ụka', 'Mọn', 'Tiu', 'Wen', 'Tọọ', 'Fraị',
      'Sat'],
  NARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONENARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTQUARTERS: ['Ọ1', 'Ọ2', 'Ọ3', 'Ọ4'],
  QUARTERS: ['Ọkara 1', 'Ọkara 2', 'Ọkara 3', 'Ọkara 4'],
  AMPMS: ['A.M.', 'P.M.'],
  DATEFORMATS: ['EEEE, d MMMM y', 'd MMMM y', 'd MMM y', 'dd/MM/yyyy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale ig_NG.
 */
goog.i18n.DateTimeSymbols_ig_NG = goog.i18n.DateTimeSymbols_ig;


/**
 * Date/time formatting symbols for locale ii.
 */
goog.i18n.DateTimeSymbols_ii = {
  ERAS: ['ꃅꋊꂿ', 'ꃅꋊꊂ'],
  ERANAMES: ['ꃅꋊꂿ', 'ꃅꋊꊂ'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['ꋍꆪ', 'ꑍꆪ', 'ꌕꆪ', 'ꇖꆪ', 'ꉬꆪ', 'ꃘꆪ', 'ꏃꆪ',
      'ꉆꆪ', 'ꈬꆪ', 'ꊰꆪ', 'ꊰꊪꆪ', 'ꊰꑋꆪ'],
  STANDALONEMONTHS: ['ꋍꆪ', 'ꑍꆪ', 'ꌕꆪ', 'ꇖꆪ', 'ꉬꆪ', 'ꃘꆪ',
      'ꏃꆪ', 'ꉆꆪ', 'ꈬꆪ', 'ꊰꆪ', 'ꊰꊪꆪ', 'ꊰꑋꆪ'],
  SHORTMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONESHORTMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  WEEKDAYS: ['ꑭꆏꑍ', 'ꆏꊂꋍ', 'ꆏꊂꑍ', 'ꆏꊂꌕ', 'ꆏꊂꇖ',
      'ꆏꊂꉬ', 'ꆏꊂꃘ'],
  STANDALONEWEEKDAYS: ['ꑭꆏꑍ', 'ꆏꊂꋍ', 'ꆏꊂꑍ', 'ꆏꊂꌕ',
      'ꆏꊂꇖ', 'ꆏꊂꉬ', 'ꆏꊂꃘ'],
  SHORTWEEKDAYS: ['ꆏꑍ', 'ꆏꋍ', 'ꆏꑍ', 'ꆏꌕ', 'ꆏꇖ', 'ꆏꉬ',
      'ꆏꃘ'],
  STANDALONESHORTWEEKDAYS: ['ꆏꑍ', 'ꆏꋍ', 'ꆏꑍ', 'ꆏꌕ', 'ꆏꇖ',
      'ꆏꉬ', 'ꆏꃘ'],
  NARROWWEEKDAYS: ['ꆏ', 'ꋍ', 'ꑍ', 'ꌕ', 'ꇖ', 'ꉬ', 'ꃘ'],
  STANDALONENARROWWEEKDAYS: ['ꆏ', 'ꋍ', 'ꑍ', 'ꌕ', 'ꇖ', 'ꉬ', 'ꃘ'],
  SHORTQUARTERS: ['ꃅꑌ', 'ꃅꎸ', 'ꃅꍵ', 'ꃅꋆ'],
  QUARTERS: ['ꃅꑌ', 'ꃅꎸ', 'ꃅꍵ', 'ꃅꋆ'],
  AMPMS: ['ꎸꄑ', 'ꁯꋒ'],
  DATEFORMATS: ['EEEE, y MMMM dd', 'y MMMM d', 'y MMM d', 'yyyy-MM-dd'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale ii_CN.
 */
goog.i18n.DateTimeSymbols_ii_CN = goog.i18n.DateTimeSymbols_ii;


/**
 * Date/time formatting symbols for locale is_IS.
 */
goog.i18n.DateTimeSymbols_is_IS = {
  ERAS: ['fyrir Krist', 'eftir Krist'],
  ERANAMES: ['fyrir Krist', 'eftir Krist'],
  NARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'Á', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['j', 'f', 'm', 'a', 'm', 'j', 'j', 'á', 's', 'o',
      'n', 'd'],
  MONTHS: ['janúar', 'febrúar', 'mars', 'apríl', 'maí', 'júní', 'júlí',
      'ágúst', 'september', 'október', 'nóvember', 'desember'],
  STANDALONEMONTHS: ['janúar', 'febrúar', 'mars', 'apríl', 'maí', 'júní',
      'júlí', 'ágúst', 'september', 'október', 'nóvember', 'desember'],
  SHORTMONTHS: ['jan', 'feb', 'mar', 'apr', 'maí', 'jún', 'júl', 'ágú',
      'sep', 'okt', 'nóv', 'des'],
  STANDALONESHORTMONTHS: ['jan', 'feb', 'mar', 'apr', 'maí', 'jún', 'júl',
      'ágú', 'sep', 'okt', 'nóv', 'des'],
  WEEKDAYS: ['sunnudagur', 'mánudagur', 'þriðjudagur', 'miðvikudagur',
      'fimmtudagur', 'föstudagur', 'laugardagur'],
  STANDALONEWEEKDAYS: ['sunnudagur', 'mánudagur', 'þriðjudagur',
      'miðvikudagur', 'fimmtudagur', 'föstudagur', 'laugardagur'],
  SHORTWEEKDAYS: ['sun', 'mán', 'þri', 'mið', 'fim', 'fös', 'lau'],
  STANDALONESHORTWEEKDAYS: ['sun', 'mán', 'þri', 'mið', 'fim', 'fös',
      'lau'],
  NARROWWEEKDAYS: ['S', 'M', 'Þ', 'M', 'F', 'F', 'L'],
  STANDALONENARROWWEEKDAYS: ['s', 'm', 'þ', 'm', 'f', 'f', 'l'],
  SHORTQUARTERS: ['F1', 'F2', 'F3', 'F4'],
  QUARTERS: ['1st fjórðungur', '2nd fjórðungur', '3rd fjórðungur',
      '4th fjórðungur'],
  AMPMS: ['f.h.', 'e.h.'],
  DATEFORMATS: ['EEEE, d. MMMM y', 'd. MMMM y', 'd.M.yyyy', 'd.M.yyyy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale it_CH.
 */
goog.i18n.DateTimeSymbols_it_CH = {
  ERAS: ['aC', 'dC'],
  ERANAMES: ['a.C.', 'd.C'],
  NARROWMONTHS: ['G', 'F', 'M', 'A', 'M', 'G', 'L', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['G', 'F', 'M', 'A', 'M', 'G', 'L', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['gennaio', 'febbraio', 'marzo', 'aprile', 'maggio', 'giugno',
      'luglio', 'agosto', 'settembre', 'ottobre', 'novembre', 'dicembre'],
  STANDALONEMONTHS: ['Gennaio', 'Febbraio', 'Marzo', 'Aprile', 'Maggio',
      'Giugno', 'Luglio', 'Agosto', 'Settembre', 'Ottobre', 'Novembre',
      'Dicembre'],
  SHORTMONTHS: ['gen', 'feb', 'mar', 'apr', 'mag', 'giu', 'lug', 'ago', 'set',
      'ott', 'nov', 'dic'],
  STANDALONESHORTMONTHS: ['gen', 'feb', 'mar', 'apr', 'mag', 'giu', 'lug',
      'ago', 'set', 'ott', 'nov', 'dic'],
  WEEKDAYS: ['domenica', 'lunedì', 'martedì', 'mercoledì', 'giovedì',
      'venerdì', 'sabato'],
  STANDALONEWEEKDAYS: ['Domenica', 'Lunedì', 'Martedì', 'Mercoledì',
      'Giovedì', 'Venerdì', 'Sabato'],
  SHORTWEEKDAYS: ['dom', 'lun', 'mar', 'mer', 'gio', 'ven', 'sab'],
  STANDALONESHORTWEEKDAYS: ['dom', 'lun', 'mar', 'mer', 'gio', 'ven', 'sab'],
  NARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'G', 'V', 'S'],
  STANDALONENARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'G', 'V', 'S'],
  SHORTQUARTERS: ['T1', 'T2', 'T3', 'T4'],
  QUARTERS: ['1o trimestre', '2o trimestre', '3o trimestre', '4o trimestre'],
  AMPMS: ['m.', 'p.'],
  DATEFORMATS: ['EEEE, d MMMM y', 'd MMMM y', 'd-MMM-y', 'dd.MM.yy'],
  TIMEFORMATS: ['HH.mm:ss \'h\' zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale it_IT.
 */
goog.i18n.DateTimeSymbols_it_IT = {
  ERAS: ['aC', 'dC'],
  ERANAMES: ['a.C.', 'd.C'],
  NARROWMONTHS: ['G', 'F', 'M', 'A', 'M', 'G', 'L', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['G', 'F', 'M', 'A', 'M', 'G', 'L', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['gennaio', 'febbraio', 'marzo', 'aprile', 'maggio', 'giugno',
      'luglio', 'agosto', 'settembre', 'ottobre', 'novembre', 'dicembre'],
  STANDALONEMONTHS: ['Gennaio', 'Febbraio', 'Marzo', 'Aprile', 'Maggio',
      'Giugno', 'Luglio', 'Agosto', 'Settembre', 'Ottobre', 'Novembre',
      'Dicembre'],
  SHORTMONTHS: ['gen', 'feb', 'mar', 'apr', 'mag', 'giu', 'lug', 'ago', 'set',
      'ott', 'nov', 'dic'],
  STANDALONESHORTMONTHS: ['gen', 'feb', 'mar', 'apr', 'mag', 'giu', 'lug',
      'ago', 'set', 'ott', 'nov', 'dic'],
  WEEKDAYS: ['domenica', 'lunedì', 'martedì', 'mercoledì', 'giovedì',
      'venerdì', 'sabato'],
  STANDALONEWEEKDAYS: ['Domenica', 'Lunedì', 'Martedì', 'Mercoledì',
      'Giovedì', 'Venerdì', 'Sabato'],
  SHORTWEEKDAYS: ['dom', 'lun', 'mar', 'mer', 'gio', 'ven', 'sab'],
  STANDALONESHORTWEEKDAYS: ['dom', 'lun', 'mar', 'mer', 'gio', 'ven', 'sab'],
  NARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'G', 'V', 'S'],
  STANDALONENARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'G', 'V', 'S'],
  SHORTQUARTERS: ['T1', 'T2', 'T3', 'T4'],
  QUARTERS: ['1o trimestre', '2o trimestre', '3o trimestre', '4o trimestre'],
  AMPMS: ['m.', 'p.'],
  DATEFORMATS: ['EEEE d MMMM y', 'dd MMMM y', 'dd/MMM/y', 'dd/MM/yy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale iu.
 */
goog.i18n.DateTimeSymbols_iu = {
  ERAS: ['BCE', 'CE'],
  ERANAMES: ['BCE', 'CE'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['ᔭᓐᓄᐊᓕ', 'ᕕᕝᕗᐊᓕ', 'ᒫᑦᓯ', 'ᐊᐃᑉᐳᓗ',
      'ᒪᐃ', 'ᔫᓂ', 'ᔪᓚᐃ', 'ᐊᐅᒡᒍᓯ', 'ᓰᑦᑏᕝᕙ',
      'ᐆᑦᑑᕝᕙ', 'ᓅᕙᐃᕝᕙ', 'ᑏᓰᕝᕙ'],
  STANDALONEMONTHS: ['ᔭᓐᓄᐊᓕ', 'ᕕᕝᕗᐊᓕ', 'ᒫᑦᓯ',
      'ᐊᐃᑉᐳᓗ', 'ᒪᐃ', 'ᔫᓂ', 'ᔪᓚᐃ', 'ᐊᐅᒡᒍᓯ',
      'ᓰᑦᑏᕝᕙ', 'ᐆᑦᑑᕝᕙ', 'ᓅᕙᐃᕝᕙ', 'ᑏᓰᕝᕙ'],
  SHORTMONTHS: ['ᔭᓐᓄᐊᓕ', 'ᕕᕝᕗᐊᓕ', 'ᒫᑦᓯ',
      'ᐊᐃᑉᐳᓗ', 'ᒪᐃ', 'ᔫᓂ', 'ᔪᓚᐃ', 'ᐊᐅᒡᒍᓯ',
      'ᓰᑦᑏᕝᕙ', 'ᐆᑦᑑᕝᕙ', 'ᓅᕙᐃᕝᕙ', 'ᑏᓰᕝᕙ'],
  STANDALONESHORTMONTHS: ['ᔭᓐᓄᐊᓕ', 'ᕕᕝᕗᐊᓕ', 'ᒫᑦᓯ',
      'ᐊᐃᑉᐳᓗ', 'ᒪᐃ', 'ᔫᓂ', 'ᔪᓚᐃ', 'ᐊᐅᒡᒍᓯ',
      'ᓰᑦᑏᕝᕙ', 'ᐆᑦᑑᕝᕙ', 'ᓅᕙᐃᕝᕙ', 'ᑏᓰᕝᕙ'],
  WEEKDAYS: ['ᓈᑦᓰᖑᔭ', 'ᓇᒡᒐᔾᔭᐅ',
      'ᓇᒡᒐᔾᔭᐅᓕᖅᑭ', 'ᐱᖓᑦᓯᖅ', 'ᓯᑕᒻᒥᖅ',
      'ᑕᓪᓕᕐᒥᖅ', 'ᓈᑦᓰᖑᔭᓕᖅᕿ'],
  STANDALONEWEEKDAYS: ['ᓈᑦᓰᖑᔭ', 'ᓇᒡᒐᔾᔭᐅ',
      'ᓇᒡᒐᔾᔭᐅᓕᖅᑭ', 'ᐱᖓᑦᓯᖅ', 'ᓯᑕᒻᒥᖅ',
      'ᑕᓪᓕᕐᒥᖅ', 'ᓈᑦᓰᖑᔭᓕᖅᕿ'],
  SHORTWEEKDAYS: ['ᓈᑦᓰᖑᔭ', 'ᓇᒡᒐᔾᔭᐅ',
      'ᓇᒡᒐᔾᔭᐅᓕᖅᑭ', 'ᐱᖓᑦᓯᖅ', 'ᓯᑕᒻᒥᖅ',
      'ᑕᓪᓕᕐᒥᖅ', 'ᓈᑦᓰᖑᔭᓕᖅᕿ'],
  STANDALONESHORTWEEKDAYS: ['ᓈᑦᓰᖑᔭ', 'ᓇᒡᒐᔾᔭᐅ',
      'ᓇᒡᒐᔾᔭᐅᓕᖅᑭ', 'ᐱᖓᑦᓯᖅ', 'ᓯᑕᒻᒥᖅ',
      'ᑕᓪᓕᕐᒥᖅ', 'ᓈᑦᓰᖑᔭᓕᖅᕿ'],
  NARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONENARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, y MMMM dd', 'y MMMM d', 'y MMM d', 'yyyy-MM-dd'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale ja_JP.
 */
goog.i18n.DateTimeSymbols_ja_JP = {
  ERAS: ['紀元前', '西暦'],
  ERANAMES: ['紀元前', '西暦'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['1月', '2月', '3月', '4月', '5月', '6月', '7月', '8月',
      '9月', '10月', '11月', '12月'],
  STANDALONEMONTHS: ['1月', '2月', '3月', '4月', '5月', '6月', '7月',
      '8月', '9月', '10月', '11月', '12月'],
  SHORTMONTHS: ['1月', '2月', '3月', '4月', '5月', '6月', '7月', '8月',
      '9月', '10月', '11月', '12月'],
  STANDALONESHORTMONTHS: ['1月', '2月', '3月', '4月', '5月', '6月',
      '7月', '8月', '9月', '10月', '11月', '12月'],
  WEEKDAYS: ['日曜日', '月曜日', '火曜日', '水曜日', '木曜日',
      '金曜日', '土曜日'],
  STANDALONEWEEKDAYS: ['日曜日', '月曜日', '火曜日', '水曜日',
      '木曜日', '金曜日', '土曜日'],
  SHORTWEEKDAYS: ['日', '月', '火', '水', '木', '金', '土'],
  STANDALONESHORTWEEKDAYS: ['日', '月', '火', '水', '木', '金', '土'],
  NARROWWEEKDAYS: ['日', '月', '火', '水', '木', '金', '土'],
  STANDALONENARROWWEEKDAYS: ['日', '月', '火', '水', '木', '金', '土'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['第1四半期', '第2四半期', '第3四半期',
      '第4四半期'],
  AMPMS: ['午前', '午後'],
  DATEFORMATS: ['y年M月d日EEEE', 'y年M月d日', 'yyyy/MM/dd', 'yy/MM/dd'],
  TIMEFORMATS: ['H時mm分ss秒 zzzz', 'H:mm:ss z', 'H:mm:ss', 'H:mm'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale ka.
 */
goog.i18n.DateTimeSymbols_ka = {
  ERAS: ['ჩვენს წელთაღრიცხვამდე',
      'ჩვენი წელთაღრიცხვით'],
  ERANAMES: ['ჩვენს წელთაღრიცხვამდე',
      'ჩვენი წელთაღრიცხვით'],
  NARROWMONTHS: ['ი', 'თ', 'მ', 'ა', 'მ', 'ი', 'ი', 'ა', 'ს',
      'ო', 'ნ', 'დ'],
  STANDALONENARROWMONTHS: ['ი', 'თ', 'მ', 'ა', 'მ', 'ი', 'ი',
      'ა', 'ს', 'ო', 'ნ', 'დ'],
  MONTHS: ['იანვარი', 'თებერვალი',
      'მარტი', 'აპრილი', 'მაისი',
      'ივნისი', 'ივლისი', 'აგვისტო',
      'სექტემბერი', 'ოქტომბერი',
      'ნოემბერი', 'დეკემბერი'],
  STANDALONEMONTHS: ['იანვარი', 'თებერვალი',
      'მარტი', 'აპრილი', 'მაისი',
      'ივნისი', 'ივლისი', 'აგვისტო',
      'სექტემბერი', 'ოქტომბერი',
      'ნოემბერი', 'დეკემბერი'],
  SHORTMONTHS: ['იან', 'თებ', 'მარ', 'აპრ', 'მაი',
      'ივნ', 'ივლ', 'აგვ', 'სექ', 'ოქტ',
      'ნოე', 'დეკ'],
  STANDALONESHORTMONTHS: ['იან', 'თებ', 'მარ', 'აპრ',
      'მაი', 'ივნ', 'ივლ', 'აგვ', 'სექ',
      'ოქტ', 'ნოე', 'დეკ'],
  WEEKDAYS: ['კვირა', 'ორშაბათი',
      'სამშაბათი', 'ოთხშაბათი',
      'ხუთშაბათი', 'პარასკევი',
      'შაბათი'],
  STANDALONEWEEKDAYS: ['კვირა', 'ორშაბათი',
      'სამშაბათი', 'ოთხშაბათი',
      'ხუთშაბათი', 'პარასკევი',
      'შაბათი'],
  SHORTWEEKDAYS: ['კვი', 'ორშ', 'სამ', 'ოთხ',
      'ხუთ', 'პარ', 'შაბ'],
  STANDALONESHORTWEEKDAYS: ['კვი', 'ორშ', 'სამ', 'ოთხ',
      'ხუთ', 'პარ', 'შაბ'],
  NARROWWEEKDAYS: ['კ', 'ო', 'ს', 'ო', 'ხ', 'პ', 'შ'],
  STANDALONENARROWWEEKDAYS: ['კ', 'ო', 'ს', 'ო', 'ხ', 'პ', 'შ'],
  SHORTQUARTERS: ['I კვ.', 'II კვ.', 'III კვ.', 'IV კვ.'],
  QUARTERS: ['1-ლი კვარტალი',
      'მე-2 კვარტალი', 'მე-3 კვარტალი',
      'მე-4 კვარტალი'],
  AMPMS: ['დილის', 'საღამოს'],
  DATEFORMATS: ['EEEE, y MMMM dd', 'y MMMM d', 'y MMM d', 'yy/MM/dd'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale ka_GE.
 */
goog.i18n.DateTimeSymbols_ka_GE = goog.i18n.DateTimeSymbols_ka;


/**
 * Date/time formatting symbols for locale kaj.
 */
goog.i18n.DateTimeSymbols_kaj = {
  ERAS: ['G.M.', 'M.'],
  ERANAMES: ['Gabanin Miladi', 'Miladi'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['Hywan A̱yrnig', 'Hywan A̱hwa', 'Hywan A̱tat', 'Hywan A̱naai',
      'Hywan A̱pfwon', 'Hywan A̱kitat', 'Hywan A̱tyirin', 'Hywan A̱ninai',
      'Hywan A̱kumviriyin', 'Hywan Swak', 'Hywan Swak B\'a̱yrnig',
      'Hywan Swak B\'a̱hwa'],
  STANDALONEMONTHS: ['Hywan A̱yrnig', 'Hywan A̱hwa', 'Hywan A̱tat',
      'Hywan A̱naai', 'Hywan A̱pfwon', 'Hywan A̱kitat', 'Hywan A̱tyirin',
      'Hywan A̱ninai', 'Hywan A̱kumviriyin', 'Hywan Swak',
      'Hywan Swak B\'a̱yrnig', 'Hywan Swak B\'a̱hwa'],
  SHORTMONTHS: ['A̱yr', 'A̱hw', 'A̱ta', 'A̱na', 'A̱pf', 'A̱ki', 'A̱ty',
      'A̱ni', 'A̱ku', 'Swa', 'Sby', 'Sbh'],
  STANDALONESHORTMONTHS: ['A̱yr', 'A̱hw', 'A̱ta', 'A̱na', 'A̱pf', 'A̱ki',
      'A̱ty', 'A̱ni', 'A̱ku', 'Swa', 'Sby', 'Sbh'],
  WEEKDAYS: ['Ladi', 'Lintani', 'Talata', 'Larba', 'Lamit', 'Juma', 'Asabar'],
  STANDALONEWEEKDAYS: ['Ladi', 'Lintani', 'Talata', 'Larba', 'Lamit', 'Juma',
      'Asabar'],
  SHORTWEEKDAYS: ['Lad', 'Lin', 'Tal', 'Lar', 'Lam', 'Jum', 'Asa'],
  STANDALONESHORTWEEKDAYS: ['Lad', 'Lin', 'Tal', 'Lar', 'Lam', 'Jum', 'Asa'],
  NARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONENARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['A.M.', 'P.M.'],
  DATEFORMATS: ['EEEE, y MMMM dd', 'y MMMM d', 'y MMM d', 'yy/MM/dd'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale kaj_NG.
 */
goog.i18n.DateTimeSymbols_kaj_NG = goog.i18n.DateTimeSymbols_kaj;


/**
 * Date/time formatting symbols for locale kam.
 */
goog.i18n.DateTimeSymbols_kam = {
  ERAS: ['MY', 'IY'],
  ERANAMES: ['Mbee wa Yesũ', 'Ĩtina wa Yesũ'],
  NARROWMONTHS: ['M', 'K', 'K', 'K', 'K', 'T', 'M', 'N', 'K', 'Ĩ', 'Ĩ', 'Ĩ'],
  STANDALONENARROWMONTHS: ['M', 'K', 'K', 'K', 'K', 'T', 'M', 'N', 'K', 'Ĩ',
      'Ĩ', 'Ĩ'],
  MONTHS: ['Mwai wa mbee', 'Mwai wa kelĩ', 'Mwai wa katatũ', 'Mwai wa kana',
      'Mwai wa katano', 'Mwai wa thanthatũ', 'Mwai wa muonza',
      'Mwai wa nyaanya', 'Mwai wa kenda', 'Mwai wa ĩkumi',
      'Mwai wa ĩkumi na ĩmwe', 'Mwai wa ĩkumi na ilĩ'],
  STANDALONEMONTHS: ['Mwai wa mbee', 'Mwai wa kelĩ', 'Mwai wa katatũ',
      'Mwai wa kana', 'Mwai wa katano', 'Mwai wa thanthatũ', 'Mwai wa muonza',
      'Mwai wa nyaanya', 'Mwai wa kenda', 'Mwai wa ĩkumi',
      'Mwai wa ĩkumi na ĩmwe', 'Mwai wa ĩkumi na ilĩ'],
  SHORTMONTHS: ['Mbe', 'Kel', 'Ktũ', 'Kan', 'Ktn', 'Tha', 'Moo', 'Nya', 'Knd',
      'Ĩku', 'Ĩkm', 'Ĩkl'],
  STANDALONESHORTMONTHS: ['Mbe', 'Kel', 'Ktũ', 'Kan', 'Ktn', 'Tha', 'Moo',
      'Nya', 'Knd', 'Ĩku', 'Ĩkm', 'Ĩkl'],
  WEEKDAYS: ['Wa kyumwa', 'Wa kwambĩlĩlya', 'Wa kelĩ', 'Wa katatũ',
      'Wa kana', 'Wa katano', 'Wa thanthatũ'],
  STANDALONEWEEKDAYS: ['Wa kyumwa', 'Wa kwambĩlĩlya', 'Wa kelĩ',
      'Wa katatũ', 'Wa kana', 'Wa katano', 'Wa thanthatũ'],
  SHORTWEEKDAYS: ['Wky', 'Wkw', 'Wkl', 'Wtũ', 'Wkn', 'Wtn', 'Wth'],
  STANDALONESHORTWEEKDAYS: ['Wky', 'Wkw', 'Wkl', 'Wtũ', 'Wkn', 'Wtn', 'Wth'],
  NARROWWEEKDAYS: ['Y', 'W', 'E', 'A', 'A', 'A', 'A'],
  STANDALONENARROWWEEKDAYS: ['Y', 'W', 'E', 'A', 'A', 'A', 'A'],
  SHORTQUARTERS: ['L1', 'L2', 'L3', 'L4'],
  QUARTERS: ['Lovo ya mbee', 'Lovo ya kelĩ', 'Lovo ya katatũ',
      'Lovo ya kana'],
  AMPMS: ['Ĩyakwakya', 'Ĩyawĩoo'],
  DATEFORMATS: ['EEEE, d MMMM y', 'd MMMM y', 'd MMM y', 'dd/MM/yyyy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale kam_KE.
 */
goog.i18n.DateTimeSymbols_kam_KE = goog.i18n.DateTimeSymbols_kam;


/**
 * Date/time formatting symbols for locale kcg.
 */
goog.i18n.DateTimeSymbols_kcg = {
  ERAS: ['GM', 'M'],
  ERANAMES: ['Gabanin Miladi', 'Miladi'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['Zwat Juwung', 'Zwat Swiyang', 'Zwat Tsat', 'Zwat Nyai',
      'Zwat Tswon', 'Zwat Ataah', 'Zwat Anatat', 'Zwat Arinai',
      'Zwat Akubunyung', 'Zwat Swag', 'Zwat Mangjuwang', 'Zwat Swag-Ma-Suyang'],
  STANDALONEMONTHS: ['Zwat Juwung', 'Zwat Swiyang', 'Zwat Tsat', 'Zwat Nyai',
      'Zwat Tswon', 'Zwat Ataah', 'Zwat Anatat', 'Zwat Arinai',
      'Zwat Akubunyung', 'Zwat Swag', 'Zwat Mangjuwang', 'Zwat Swag-Ma-Suyang'],
  SHORTMONTHS: ['Juw', 'Swi', 'Tsa', 'Nya', 'Tsw', 'Ata', 'Ana', 'Ari', 'Aku',
      'Swa', 'Man', 'Mas'],
  STANDALONESHORTMONTHS: ['Juw', 'Swi', 'Tsa', 'Nya', 'Tsw', 'Ata', 'Ana',
      'Ari', 'Aku', 'Swa', 'Man', 'Mas'],
  WEEKDAYS: ['Ladi', 'Tanii', 'Talata', 'Larba', 'Lamit', 'Juma', 'Asabat'],
  STANDALONEWEEKDAYS: ['Ladi', 'Tanii', 'Talata', 'Larba', 'Lamit', 'Juma',
      'Asabat'],
  SHORTWEEKDAYS: ['Lad', 'Tan', 'Tal', 'Lar', 'Lam', 'Jum', 'Asa'],
  STANDALONESHORTWEEKDAYS: ['Lad', 'Tan', 'Tal', 'Lar', 'Lam', 'Jum', 'Asa'],
  NARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONENARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, y MMMM dd', 'y MMMM d', 'y MMM d', 'yy/MM/dd'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale kcg_NG.
 */
goog.i18n.DateTimeSymbols_kcg_NG = goog.i18n.DateTimeSymbols_kcg;


/**
 * Date/time formatting symbols for locale kfo.
 */
goog.i18n.DateTimeSymbols_kfo = {
  ERAS: ['KMW', 'BCW'],
  ERANAMES: ['Kafi Mar Wenom', 'Bayan Chi Wenom'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['Fai Weyene', 'Fai Fani', 'Fai Tataka', 'Fai Nangra', 'Fai Tuyo',
      'Fai Tsoyi', 'Fai Tafaka', 'Fai Warachi', 'Fai Kunobok', 'Fai Bansok',
      'Fai Kom', 'Fai Sauk'],
  STANDALONEMONTHS: ['Fai Weyene', 'Fai Fani', 'Fai Tataka', 'Fai Nangra',
      'Fai Tuyo', 'Fai Tsoyi', 'Fai Tafaka', 'Fai Warachi', 'Fai Kunobok',
      'Fai Bansok', 'Fai Kom', 'Fai Sauk'],
  SHORTMONTHS: ['Wey', 'Fan', 'Tat', 'Nan', 'Tuy', 'Tso', 'Taf', 'War', 'Kun',
      'Ban', 'Kom', 'Sau'],
  STANDALONESHORTMONTHS: ['Wey', 'Fan', 'Tat', 'Nan', 'Tuy', 'Tso', 'Taf',
      'War', 'Kun', 'Ban', 'Kom', 'Sau'],
  WEEKDAYS: ['Lahadi', 'Je-Kubacha', 'Je-Gbai', 'Tansati', 'Je-Yei', 'Je-Koye',
      'Sati'],
  STANDALONEWEEKDAYS: ['Lahadi', 'Je-Kubacha', 'Je-Gbai', 'Tansati', 'Je-Yei',
      'Je-Koye', 'Sati'],
  SHORTWEEKDAYS: ['Lah', 'Kub', 'Gba', 'Tan', 'Yei', 'Koy', 'Sat'],
  STANDALONESHORTWEEKDAYS: ['Lah', 'Kub', 'Gba', 'Tan', 'Yei', 'Koy', 'Sat'],
  NARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONENARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, y MMMM dd', 'y MMMM d', 'y MMM d', 'yy/MM/dd'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale kfo_CI.
 */
goog.i18n.DateTimeSymbols_kfo_CI = goog.i18n.DateTimeSymbols_kfo;


/**
 * Date/time formatting symbols for locale kk.
 */
goog.i18n.DateTimeSymbols_kk = {
  ERAS: ['BCE', 'CE'],
  ERANAMES: ['BCE', 'CE'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['қаңтар', 'ақпан', 'наурыз', 'сәуір',
      'мамыр', 'маусым', 'шілде', 'тамыз',
      'қыркүйек', 'қазан', 'қараша', 'желтоқсан'],
  STANDALONEMONTHS: ['қаңтар', 'ақпан', 'наурыз', 'сәуір',
      'мамыр', 'маусым', 'шілде', 'тамыз',
      'қыркүйек', 'қазан', 'қараша', 'желтоқсан'],
  SHORTMONTHS: ['қаң.', 'ақп.', 'нау.', 'сәу.', 'мам.',
      'мау.', 'шіл.', 'там.', 'қыр.', 'қаз.', 'қар.',
      'желт.'],
  STANDALONESHORTMONTHS: ['қаң.', 'ақп.', 'нау.', 'сәу.', 'мам.',
      'мау.', 'шіл.', 'там.', 'қыр.', 'қаз.', 'қар.',
      'желт.'],
  WEEKDAYS: ['жексені', 'дуйсенбі', 'сейсенбі',
      'сәренбі', 'бейсенбі', 'жұма', 'сенбі'],
  STANDALONEWEEKDAYS: ['жексені', 'дуйсенбі', 'сейсенбі',
      'сәренбі', 'бейсенбі', 'жұма', 'сенбі'],
  SHORTWEEKDAYS: ['жс.', 'дс.', 'сс.', 'ср.', 'бс.', 'жм.',
      'сһ.'],
  STANDALONESHORTWEEKDAYS: ['жс.', 'дс.', 'сс.', 'ср.', 'бс.',
      'жм.', 'сһ.'],
  NARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONENARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, d MMMM y \'ж\'.', 'd MMMM y \'ж\'.', 'dd.MM.yyyy',
      'dd.MM.yy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale kk_Cyrl.
 */
goog.i18n.DateTimeSymbols_kk_Cyrl = goog.i18n.DateTimeSymbols_kk;


/**
 * Date/time formatting symbols for locale kk_Cyrl_KZ.
 */
goog.i18n.DateTimeSymbols_kk_Cyrl_KZ = goog.i18n.DateTimeSymbols_kk;


/**
 * Date/time formatting symbols for locale kk_KZ.
 */
goog.i18n.DateTimeSymbols_kk_KZ = goog.i18n.DateTimeSymbols_kk;


/**
 * Date/time formatting symbols for locale kl.
 */
goog.i18n.DateTimeSymbols_kl = {
  ERAS: ['Kr.in.si.', 'Kr.in.king.'],
  ERANAMES: ['Kristusip inunngornerata siornagut',
      'Kristusip inunngornerata kingornagut'],
  NARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['januari', 'februari', 'martsi', 'aprili', 'maji', 'juni', 'juli',
      'augustusi', 'septemberi', 'oktoberi', 'novemberi', 'decemberi'],
  STANDALONEMONTHS: ['januari', 'februari', 'martsi', 'aprili', 'maji', 'juni',
      'juli', 'augustusi', 'septemberi', 'oktoberi', 'novemberi', 'decemberi'],
  SHORTMONTHS: ['jan', 'feb', 'mar', 'apr', 'maj', 'jun', 'jul', 'aug', 'sep',
      'okt', 'nov', 'dec'],
  STANDALONESHORTMONTHS: ['jan', 'feb', 'mar', 'apr', 'maj', 'jun', 'jul',
      'aug', 'sep', 'okt', 'nov', 'dec'],
  WEEKDAYS: ['sabaat', 'ataasinngorneq', 'marlunngorneq', 'pingasunngorneq',
      'sisamanngorneq', 'tallimanngorneq', 'arfininngorneq'],
  STANDALONEWEEKDAYS: ['sabaat', 'ataasinngorneq', 'marlunngorneq',
      'pingasunngorneq', 'sisamanngorneq', 'tallimanngorneq', 'arfininngorneq'],
  SHORTWEEKDAYS: ['sab', 'ata', 'mar', 'pin', 'sis', 'tal', 'arf'],
  STANDALONESHORTWEEKDAYS: ['sab', 'ata', 'mar', 'pin', 'sis', 'tal', 'arf'],
  NARROWWEEKDAYS: ['S', 'A', 'M', 'P', 'S', 'T', 'A'],
  STANDALONENARROWWEEKDAYS: ['S', 'A', 'M', 'P', 'S', 'T', 'A'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['ulloqeqqata-tungaa', 'ulloqeqqata-kingorna'],
  DATEFORMATS: ['EEEE dd MMMM y', 'dd MMMM y', 'MMM dd, y', 'yyyy-MM-dd'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale kl_GL.
 */
goog.i18n.DateTimeSymbols_kl_GL = goog.i18n.DateTimeSymbols_kl;


/**
 * Date/time formatting symbols for locale km.
 */
goog.i18n.DateTimeSymbols_km = {
  ERAS: ['មុន​គ.ស.', 'គ.ស.'],
  ERANAMES: ['មុន​គ្រិស្តសករាជ',
      'គ្រិស្តសករាជ'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['មករា', 'កុម្ភៈ', 'មិនា', 'មេសា',
      'ឧសភា', 'មិថុនា', 'កក្កដា',
      'សីហា', 'កញ្ញា', 'តុលា',
      'វិច្ឆិកា', 'ធ្នូ'],
  STANDALONEMONTHS: ['មករា', 'កុម្ភៈ', 'មិនា',
      'មេសា', 'ឧសភា', 'មិថុនា',
      'កក្កដា', 'សីហា', 'កញ្ញា', 'តុលា',
      'វិច្ឆិកា', 'ធ្នូ'],
  SHORTMONTHS: ['១', '២', '៣', '៤', '៥', '៦', '៧', '៨', '៩',
      '១០', '១១', '១២'],
  STANDALONESHORTMONTHS: ['១', '២', '៣', '៤', '៥', '៦', '៧',
      '៨', '៩', '១០', '១១', '១២'],
  WEEKDAYS: ['ថ្ងៃអាទិត្យ',
      '​ថ្ងៃច័ន្ទ', 'ថ្ងៃអង្គារ',
      'ថ្ងៃពុធ', 'ថ្ងៃព្រហស្បតិ៍',
      'ថ្ងៃសុក្រ', 'ថ្ងៃសៅរ៍'],
  STANDALONEWEEKDAYS: ['ថ្ងៃអាទិត្យ',
      '​ថ្ងៃច័ន្ទ', 'ថ្ងៃអង្គារ',
      'ថ្ងៃពុធ', 'ថ្ងៃព្រហស្បតិ៍',
      'ថ្ងៃសុក្រ', 'ថ្ងៃសៅរ៍'],
  SHORTWEEKDAYS: ['អា', 'ច', 'អ', 'ពុ', 'ព្រ', 'សុ',
      'ស'],
  STANDALONESHORTWEEKDAYS: ['អា', 'ច', 'អ', 'ពុ', 'ព្រ',
      'សុ', 'ស'],
  NARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONENARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTQUARTERS: ['ត្រី១', 'ត្រី២', 'ត្រី៣',
      'ត្រី៤'],
  QUARTERS: ['ត្រីមាសទី១', 'ត្រីមាសទី២',
      'ត្រីមាសទី៣', 'ត្រីមាសទី៤'],
  AMPMS: ['ព្រឹក', 'ល្ងាច'],
  DATEFORMATS: ['EEEE ថ្ងៃ d ខែ MMMM ឆ្នាំ y',
      'd ខែ MMMM ឆ្នាំ y', 'd MMM y', 'd/M/yyyy'],
  TIMEFORMATS: ['H ម៉ោង m នាទី ss វិនាទី​ zzzz',
      'H ម៉ោង m នាទី ss វិនាទី​z', 'H:mm:ss',
      'H:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale km_KH.
 */
goog.i18n.DateTimeSymbols_km_KH = goog.i18n.DateTimeSymbols_km;


/**
 * Date/time formatting symbols for locale kn_IN.
 */
goog.i18n.DateTimeSymbols_kn_IN = {
  ERAS: ['BCE', 'CE'],
  ERANAMES: ['ಈಸಪೂವ೯.', 'ಕ್ರಿಸ್ತ ಶಕ'],
  NARROWMONTHS: ['ಜ', 'ಫೆ', 'ಮಾ', 'ಎ', 'ಮೇ', 'ಜೂ', 'ಜು',
      'ಆ', 'ಸೆ', 'ಅ', 'ನ', 'ಡಿ'],
  STANDALONENARROWMONTHS: ['ಜ', 'ಫೆ', 'ಮಾ', 'ಎ', 'ಮೇ', 'ಜೂ',
      'ಜು', 'ಆ', 'ಸೆ', 'ಅ', 'ನ', 'ಡಿ'],
  MONTHS: ['ಜನವರೀ', 'ಫೆಬ್ರವರೀ', 'ಮಾರ್ಚ್',
      'ಎಪ್ರಿಲ್', 'ಮೆ', 'ಜೂನ್', 'ಜುಲೈ',
      'ಆಗಸ್ಟ್', 'ಸಪ್ಟೆಂಬರ್',
      'ಅಕ್ಟೋಬರ್', 'ನವೆಂಬರ್',
      'ಡಿಸೆಂಬರ್'],
  STANDALONEMONTHS: ['ಜನವರೀ', 'ಫೆಬ್ರವರೀ',
      'ಮಾರ್ಚ್', 'ಎಪ್ರಿಲ್', 'ಮೆ', 'ಜೂನ್',
      'ಜುಲೈ', 'ಆಗಸ್ಟ್', 'ಸಪ್ಟೆಂಬರ್',
      'ಅಕ್ಟೋಬರ್', 'ನವೆಂಬರ್',
      'ಡಿಸೆಂಬರ್'],
  SHORTMONTHS: ['ಜನವರೀ', 'ಫೆಬ್ರವರೀ',
      'ಮಾರ್ಚ್', 'ಎಪ್ರಿಲ್', 'ಮೆ', 'ಜೂನ್',
      'ಜುಲೈ', 'ಆಗಸ್ಟ್', 'ಸಪ್ಟೆಂಬರ್',
      'ಅಕ್ಟೋಬರ್', 'ನವೆಂಬರ್',
      'ಡಿಸೆಂಬರ್'],
  STANDALONESHORTMONTHS: ['ಜನವರೀ', 'ಫೆಬ್ರವರೀ',
      'ಮಾರ್ಚ್', 'ಎಪ್ರಿಲ್', 'ಮೆ', 'ಜೂನ್',
      'ಜುಲೈ', 'ಆಗಸ್ಟ್', 'ಸಪ್ಟೆಂಬರ್',
      'ಅಕ್ಟೋಬರ್', 'ನವೆಂಬರ್',
      'ಡಿಸೆಂಬರ್'],
  WEEKDAYS: ['ರವಿವಾರ', 'ಸೋಮವಾರ',
      'ಮಂಗಳವಾರ', 'ಬುಧವಾರ', 'ಗುರುವಾರ',
      'ಶುಕ್ರವಾರ', 'ಶನಿವಾರ'],
  STANDALONEWEEKDAYS: ['ರವಿವಾರ', 'ಸೋಮವಾರ',
      'ಮಂಗಳವಾರ', 'ಬುಧವಾರ', 'ಗುರುವಾರ',
      'ಶುಕ್ರವಾರ', 'ಶನಿವಾರ'],
  SHORTWEEKDAYS: ['ರ.', 'ಸೋ.', 'ಮಂ.', 'ಬು.', 'ಗು.', 'ಶು.',
      'ಶನಿ.'],
  STANDALONESHORTWEEKDAYS: ['ರ.', 'ಸೋ.', 'ಮಂ.', 'ಬು.', 'ಗು.',
      'ಶು.', 'ಶನಿ.'],
  NARROWWEEKDAYS: ['ರ', 'ಸೋ', 'ಮಂ', 'ಬು', 'ಗು', 'ಶು',
      'ಶ'],
  STANDALONENARROWWEEKDAYS: ['ರ', 'ಸೋ', 'ಮಂ', 'ಬು', 'ಗು',
      'ಶು', 'ಶ'],
  SHORTQUARTERS: ['ಒಂದು 1', 'ಎರಡು 2', 'ಮೂರು 3',
      'ನಾಲೃಕ 4'],
  QUARTERS: ['ಒಂದು 1', 'ಎರಡು 2', 'ಮೂರು 3',
      'ನಾಲೃಕ 4'],
  AMPMS: ['am', 'pm'],
  DATEFORMATS: ['EEEE d MMMM y', 'd MMMM y', 'd MMM y', 'd-M-yy'],
  TIMEFORMATS: ['hh:mm:ss a zzzz', 'hh:mm:ss a z', 'hh:mm:ss a', 'hh:mm a'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [6, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale ko_KR.
 */
goog.i18n.DateTimeSymbols_ko_KR = {
  ERAS: ['기원전', '서기'],
  ERANAMES: ['서력기원전', '서력기원'],
  NARROWMONTHS: ['1월', '2월', '3월', '4월', '5월', '6월', '7월', '8월',
      '9월', '10월', '11월', '12월'],
  STANDALONENARROWMONTHS: ['1월', '2월', '3월', '4월', '5월', '6월',
      '7월', '8월', '9월', '10월', '11월', '12월'],
  MONTHS: ['1월', '2월', '3월', '4월', '5월', '6월', '7월', '8월',
      '9월', '10월', '11월', '12월'],
  STANDALONEMONTHS: ['1월', '2월', '3월', '4월', '5월', '6월', '7월',
      '8월', '9월', '10월', '11월', '12월'],
  SHORTMONTHS: ['1월', '2월', '3월', '4월', '5월', '6월', '7월', '8월',
      '9월', '10월', '11월', '12월'],
  STANDALONESHORTMONTHS: ['1월', '2월', '3월', '4월', '5월', '6월',
      '7월', '8월', '9월', '10월', '11월', '12월'],
  WEEKDAYS: ['일요일', '월요일', '화요일', '수요일', '목요일',
      '금요일', '토요일'],
  STANDALONEWEEKDAYS: ['일요일', '월요일', '화요일', '수요일',
      '목요일', '금요일', '토요일'],
  SHORTWEEKDAYS: ['일', '월', '화', '수', '목', '금', '토'],
  STANDALONESHORTWEEKDAYS: ['일', '월', '화', '수', '목', '금', '토'],
  NARROWWEEKDAYS: ['일', '월', '화', '수', '목', '금', '토'],
  STANDALONENARROWWEEKDAYS: ['일', '월', '화', '수', '목', '금', '토'],
  SHORTQUARTERS: ['1분기', '2분기', '3분기', '4분기'],
  QUARTERS: ['제 1/4분기', '제 2/4분기', '제 3/4분기',
      '제 4/4분기'],
  AMPMS: ['오전', '오후'],
  DATEFORMATS: ['y년 M월 d일 EEEE', 'y년 M월 d일', 'yyyy. M. d.',
      'yy. M. d.'],
  TIMEFORMATS: ['a h시 m분 s초 zzzz', 'a h시 m분 s초 z', 'a h:mm:ss',
      'a h:mm'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale kok.
 */
goog.i18n.DateTimeSymbols_kok = {
  ERAS: ['क्रिस्तपूर्व',
      'क्रिस्तशखा'],
  ERANAMES: ['क्रिस्तपूर्व',
      'क्रिस्तशखा'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['जानेवारी', 'फेब्रुवारी',
      'मार्च', 'एप्रिल', 'मे', 'जून',
      'जुलै', 'ओगस्ट', 'सेप्टेंबर',
      'ओक्टोबर', 'नोव्हेंबर',
      'डिसेंबर'],
  STANDALONEMONTHS: ['जानेवारी',
      'फेब्रुवारी', 'मार्च', 'एप्रिल',
      'मे', 'जून', 'जुलै', 'ओगस्ट',
      'सेप्टेंबर', 'ओक्टोबर',
      'नोव्हेंबर', 'डिसेंबर'],
  SHORTMONTHS: ['जानेवारी', 'फेब्रुवारी',
      'मार्च', 'एप्रिल', 'मे', 'जून',
      'जुलै', 'ओगस्ट', 'सेप्टेंबर',
      'ओक्टोबर', 'नोव्हेंबर',
      'डिसेंबर'],
  STANDALONESHORTMONTHS: ['जानेवारी',
      'फेब्रुवारी', 'मार्च', 'एप्रिल',
      'मे', 'जून', 'जुलै', 'ओगस्ट',
      'सेप्टेंबर', 'ओक्टोबर',
      'नोव्हेंबर', 'डिसेंबर'],
  WEEKDAYS: ['आदित्यवार', 'सोमवार',
      'मंगळार', 'बुधवार', 'गुरुवार',
      'शुक्रवार', 'शनिवार'],
  STANDALONEWEEKDAYS: ['आदित्यवार', 'सोमवार',
      'मंगळार', 'बुधवार', 'गुरुवार',
      'शुक्रवार', 'शनिवार'],
  SHORTWEEKDAYS: ['रवि', 'सोम', 'मंगळ', 'बुध',
      'गुरु', 'शुक्र', 'शनि'],
  STANDALONESHORTWEEKDAYS: ['रवि', 'सोम', 'मंगळ',
      'बुध', 'गुरु', 'शुक्र', 'शनि'],
  NARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONENARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['म.पू.', 'म.नं.'],
  DATEFORMATS: ['EEEE d MMMM y', 'd MMMM y', 'dd-MM-yyyy', 'd-M-yy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [6, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale kok_IN.
 */
goog.i18n.DateTimeSymbols_kok_IN = goog.i18n.DateTimeSymbols_kok;


/**
 * Date/time formatting symbols for locale kpe.
 */
goog.i18n.DateTimeSymbols_kpe = {
  ERAS: ['BCE', 'CE'],
  ERANAMES: ['BCE', 'CE'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONEMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11',
      '12'],
  SHORTMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONESHORTMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  WEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONEWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONESHORTWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  NARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONENARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, y MMMM dd', 'y MMMM d', 'y MMM d', 'yyyy-MM-dd'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale kpe_GN.
 */
goog.i18n.DateTimeSymbols_kpe_GN = goog.i18n.DateTimeSymbols_kpe;


/**
 * Date/time formatting symbols for locale kpe_LR.
 */
goog.i18n.DateTimeSymbols_kpe_LR = goog.i18n.DateTimeSymbols_kpe;


/**
 * Date/time formatting symbols for locale ku.
 */
goog.i18n.DateTimeSymbols_ku = {
  ERAS: ['BCE', 'CE'],
  ERANAMES: ['BCE', 'CE'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONEMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11',
      '12'],
  SHORTMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONESHORTMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  WEEKDAYS: ['یەکشەممە', 'دووشەممە', 'سێشەممە',
      'چوارشەممە', '5', '6', '7'],
  STANDALONEWEEKDAYS: ['یەکشەممە', 'دووشەممە', 'سێشەممە',
      'چوارشەممە', '5', '6', '7'],
  SHORTWEEKDAYS: ['یەکشەممە', 'دووشەممە', 'سێشەممە',
      'چوارشەممە', '5', '6', '7'],
  STANDALONESHORTWEEKDAYS: ['یەکشەممە', 'دووشەممە',
      'سێشەممە', 'چوارشەممە', '5', '6', '7'],
  NARROWWEEKDAYS: ['ی', 'د', 'س', '4', '5', '6', '7'],
  STANDALONENARROWWEEKDAYS: ['ی', 'د', 'س', '4', '5', '6', '7'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, y MMMM dd', 'y MMMM d', 'y MMM d', 'yyyy-MM-dd'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 5,
  WEEKENDRANGE: [4, 5],
  FIRSTWEEKCUTOFFDAY: 1
};


/**
 * Date/time formatting symbols for locale ku_Arab.
 */
goog.i18n.DateTimeSymbols_ku_Arab = goog.i18n.DateTimeSymbols_ku;


/**
 * Date/time formatting symbols for locale ku_Arab_IQ.
 */
goog.i18n.DateTimeSymbols_ku_Arab_IQ = goog.i18n.DateTimeSymbols_ku;


/**
 * Date/time formatting symbols for locale ku_Arab_IR.
 */
goog.i18n.DateTimeSymbols_ku_Arab_IR = goog.i18n.DateTimeSymbols_ku;


/**
 * Date/time formatting symbols for locale ku_IQ.
 */
goog.i18n.DateTimeSymbols_ku_IQ = goog.i18n.DateTimeSymbols_ku;


/**
 * Date/time formatting symbols for locale ku_IR.
 */
goog.i18n.DateTimeSymbols_ku_IR = goog.i18n.DateTimeSymbols_ku;


/**
 * Date/time formatting symbols for locale ku_Latn.
 */
goog.i18n.DateTimeSymbols_ku_Latn = {
  ERAS: ['BZ', 'PZ'],
  ERANAMES: ['BZ', 'PZ'],
  NARROWMONTHS: ['ç', 's', 'a', 'n', 'g', 'h', '7', '8', '9', '10', '11',
      '12'],
  STANDALONENARROWMONTHS: ['ç', 's', 'a', 'n', 'g', 'h', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['çile', 'sibat', 'adar', 'nîsan', 'gulan', 'hezîran', '7', '8',
      '9', '10', '11', '12'],
  STANDALONEMONTHS: ['çile', 'sibat', 'adar', 'nîsan', 'gulan', 'hezîran',
      '7', '8', '9', '10', '11', '12'],
  SHORTMONTHS: ['çil', 'sib', 'adr', 'nîs', 'gul', 'hez', 'tîr', '8', '9',
      '10', '11', '12'],
  STANDALONESHORTMONTHS: ['çil', 'sib', 'adr', 'nîs', 'gul', 'hez', 'tîr',
      '8', '9', '10', '11', '12'],
  WEEKDAYS: ['yekşem', 'duşem', 'şê', 'çarşem', 'pêncşem', 'în',
      'şemî'],
  STANDALONEWEEKDAYS: ['yekşem', 'duşem', 'şê', 'çarşem', 'pêncşem',
      'în', 'şemî'],
  SHORTWEEKDAYS: ['yş', 'dş', 'sş', 'çş', 'pş', 'în', 'ş'],
  STANDALONESHORTWEEKDAYS: ['yş', 'dş', 'sş', 'çş', 'pş', 'în', 'ş'],
  NARROWWEEKDAYS: ['y', 'd', 's', 'ç', 'p', 'î', 'ş'],
  STANDALONENARROWWEEKDAYS: ['y', 'd', 's', 'ç', 'p', 'î', 'ş'],
  SHORTQUARTERS: ['Ç1', 'Ç2', 'Ç3', 'Ç4'],
  QUARTERS: ['Ç1', 'Ç2', 'Ç3', 'Ç4'],
  AMPMS: ['BN', 'PN'],
  DATEFORMATS: ['EEEE, y MMMM dd', 'y MMMM d', 'y MMM d', 'yyyy-MM-dd'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale ku_Latn_SY.
 */
goog.i18n.DateTimeSymbols_ku_Latn_SY = goog.i18n.DateTimeSymbols_ku_Latn;


/**
 * Date/time formatting symbols for locale ku_Latn_TR.
 */
goog.i18n.DateTimeSymbols_ku_Latn_TR = goog.i18n.DateTimeSymbols_ku_Latn;


/**
 * Date/time formatting symbols for locale ku_SY.
 */
goog.i18n.DateTimeSymbols_ku_SY = {
  ERAS: ['BZ', 'PZ'],
  ERANAMES: ['BZ', 'PZ'],
  NARROWMONTHS: ['ç', 's', 'a', 'n', 'g', 'h', '7', '8', '9', '10', '11',
      '12'],
  STANDALONENARROWMONTHS: ['ç', 's', 'a', 'n', 'g', 'h', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['çile', 'sibat', 'adar', 'nîsan', 'gulan', 'hezîran', '7', '8',
      '9', '10', '11', '12'],
  STANDALONEMONTHS: ['çile', 'sibat', 'adar', 'nîsan', 'gulan', 'hezîran',
      '7', '8', '9', '10', '11', '12'],
  SHORTMONTHS: ['çil', 'sib', 'adr', 'nîs', 'gul', 'hez', 'tîr', '8', '9',
      '10', '11', '12'],
  STANDALONESHORTMONTHS: ['çil', 'sib', 'adr', 'nîs', 'gul', 'hez', 'tîr',
      '8', '9', '10', '11', '12'],
  WEEKDAYS: ['yekşem', 'duşem', 'şê', 'çarşem', 'pêncşem', 'în',
      'şemî'],
  STANDALONEWEEKDAYS: ['yekşem', 'duşem', 'şê', 'çarşem', 'pêncşem',
      'în', 'şemî'],
  SHORTWEEKDAYS: ['yş', 'dş', 'sş', 'çş', 'pş', 'în', 'ş'],
  STANDALONESHORTWEEKDAYS: ['yş', 'dş', 'sş', 'çş', 'pş', 'în', 'ş'],
  NARROWWEEKDAYS: ['y', 'd', 's', 'ç', 'p', 'î', 'ş'],
  STANDALONENARROWWEEKDAYS: ['y', 'd', 's', 'ç', 'p', 'î', 'ş'],
  SHORTQUARTERS: ['Ç1', 'Ç2', 'Ç3', 'Ç4'],
  QUARTERS: ['Ç1', 'Ç2', 'Ç3', 'Ç4'],
  AMPMS: ['BN', 'PN'],
  DATEFORMATS: ['EEEE, y MMMM dd', 'y MMMM d', 'y MMM d', 'yyyy-MM-dd'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [4, 5],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale ku_TR.
 */
goog.i18n.DateTimeSymbols_ku_TR = {
  ERAS: ['BZ', 'PZ'],
  ERANAMES: ['BZ', 'PZ'],
  NARROWMONTHS: ['ç', 's', 'a', 'n', 'g', 'h', '7', '8', '9', '10', '11',
      '12'],
  STANDALONENARROWMONTHS: ['ç', 's', 'a', 'n', 'g', 'h', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['çile', 'sibat', 'adar', 'nîsan', 'gulan', 'hezîran', '7', '8',
      '9', '10', '11', '12'],
  STANDALONEMONTHS: ['çile', 'sibat', 'adar', 'nîsan', 'gulan', 'hezîran',
      '7', '8', '9', '10', '11', '12'],
  SHORTMONTHS: ['çil', 'sib', 'adr', 'nîs', 'gul', 'hez', 'tîr', '8', '9',
      '10', '11', '12'],
  STANDALONESHORTMONTHS: ['çil', 'sib', 'adr', 'nîs', 'gul', 'hez', 'tîr',
      '8', '9', '10', '11', '12'],
  WEEKDAYS: ['yekşem', 'duşem', 'şê', 'çarşem', 'pêncşem', 'în',
      'şemî'],
  STANDALONEWEEKDAYS: ['yekşem', 'duşem', 'şê', 'çarşem', 'pêncşem',
      'în', 'şemî'],
  SHORTWEEKDAYS: ['yş', 'dş', 'sş', 'çş', 'pş', 'în', 'ş'],
  STANDALONESHORTWEEKDAYS: ['yş', 'dş', 'sş', 'çş', 'pş', 'în', 'ş'],
  NARROWWEEKDAYS: ['y', 'd', 's', 'ç', 'p', 'î', 'ş'],
  STANDALONENARROWWEEKDAYS: ['y', 'd', 's', 'ç', 'p', 'î', 'ş'],
  SHORTQUARTERS: ['Ç1', 'Ç2', 'Ç3', 'Ç4'],
  QUARTERS: ['Ç1', 'Ç2', 'Ç3', 'Ç4'],
  AMPMS: ['BN', 'PN'],
  DATEFORMATS: ['EEEE, y MMMM dd', 'y MMMM d', 'y MMM d', 'yyyy-MM-dd'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale kw.
 */
goog.i18n.DateTimeSymbols_kw = {
  ERAS: ['RC', 'AD'],
  ERANAMES: ['RC', 'AD'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['Mys Genver', 'Mys Whevrel', 'Mys Merth', 'Mys Ebrel', 'Mys Me',
      'Mys Efan', 'Mys Gortheren', 'Mye Est', 'Mys Gwyngala', 'Mys Hedra',
      'Mys Du', 'Mys Kevardhu'],
  STANDALONEMONTHS: ['Mys Genver', 'Mys Whevrel', 'Mys Merth', 'Mys Ebrel',
      'Mys Me', 'Mys Efan', 'Mys Gortheren', 'Mye Est', 'Mys Gwyngala',
      'Mys Hedra', 'Mys Du', 'Mys Kevardhu'],
  SHORTMONTHS: ['Gen', 'Whe', 'Mer', 'Ebr', 'Me', 'Efn', 'Gor', 'Est', 'Gwn',
      'Hed', 'Du', 'Kev'],
  STANDALONESHORTMONTHS: ['Gen', 'Whe', 'Mer', 'Ebr', 'Me', 'Efn', 'Gor', 'Est',
      'Gwn', 'Hed', 'Du', 'Kev'],
  WEEKDAYS: ['De Sul', 'De Lun', 'De Merth', 'De Merher', 'De Yow', 'De Gwener',
      'De Sadorn'],
  STANDALONEWEEKDAYS: ['De Sul', 'De Lun', 'De Merth', 'De Merher', 'De Yow',
      'De Gwener', 'De Sadorn'],
  SHORTWEEKDAYS: ['Sul', 'Lun', 'Mth', 'Mhr', 'Yow', 'Gwe', 'Sad'],
  STANDALONESHORTWEEKDAYS: ['Sul', 'Lun', 'Mth', 'Mhr', 'Yow', 'Gwe', 'Sad'],
  NARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONENARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['a.m.', 'p.m.'],
  DATEFORMATS: ['EEEE d MMMM y', 'd MMMM y', 'd MMM y', 'dd/MM/yyyy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale kw_GB.
 */
goog.i18n.DateTimeSymbols_kw_GB = goog.i18n.DateTimeSymbols_kw;


/**
 * Date/time formatting symbols for locale ky.
 */
goog.i18n.DateTimeSymbols_ky = {
  ERAS: ['BCE', 'CE'],
  ERANAMES: ['BCE', 'CE'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONEMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11',
      '12'],
  SHORTMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONESHORTMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  WEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONEWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONESHORTWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  NARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONENARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, y MMMM dd', 'y MMMM d', 'y MMM d', 'yyyy-MM-dd'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale ky_KG.
 */
goog.i18n.DateTimeSymbols_ky_KG = goog.i18n.DateTimeSymbols_ky;


/**
 * Date/time formatting symbols for locale ln_CD.
 */
goog.i18n.DateTimeSymbols_ln_CD = {
  ERAS: ['libosó ya Y.-K.', 'nsima ya Y.-K.'],
  ERANAMES: ['libosó ya Y.-K.', 'nsima ya Y.-K.'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['sánzá ya yambo', 'sánzá ya míbalé', 'sánzá ya mísáto',
      'sánzá ya mínei', 'sánzá ya mítáno', 'sánzá ya motóbá',
      'sánzá ya nsambo', 'sánzá ya mwambe', 'sánzá ya libwa',
      'sánzá ya zómi', 'sánzá ya zómi na mɔ̌kɔ́',
      'sánzá ya zómi na míbalé'],
  STANDALONEMONTHS: ['sánzá ya yambo', 'sánzá ya míbalé',
      'sánzá ya mísáto', 'sánzá ya mínei', 'sánzá ya mítáno',
      'sánzá ya motóbá', 'sánzá ya nsambo', 'sánzá ya mwambe',
      'sánzá ya libwa', 'sánzá ya zómi', 'sánzá ya zómi na mɔ̌kɔ́',
      'sánzá ya zómi na míbalé'],
  SHORTMONTHS: ['s1', 's2', 's3', 's4', 's5', 's6', 's7', 's8', 's9', 's10',
      's11', 's12'],
  STANDALONESHORTMONTHS: ['s1', 's2', 's3', 's4', 's5', 's6', 's7', 's8', 's9',
      's10', 's11', 's12'],
  WEEKDAYS: ['eyenga', 'mokɔlɔ ya libosó', 'mokɔlɔ ya míbalé',
      'mokɔlɔ ya mísáto', 'mokɔlɔ ya mínéi', 'mokɔlɔ ya mítáno',
      'mpɔ́sɔ'],
  STANDALONEWEEKDAYS: ['eyenga', 'mokɔlɔ ya libosó', 'mokɔlɔ ya míbalé',
      'mokɔlɔ ya mísáto', 'mokɔlɔ ya mínéi', 'mokɔlɔ ya mítáno',
      'mpɔ́sɔ'],
  SHORTWEEKDAYS: ['eye', 'm1', 'm2', 'm3', 'm4', 'm5', 'mps'],
  STANDALONESHORTWEEKDAYS: ['eye', 'm1', 'm2', 'm3', 'm4', 'm5', 'mps'],
  NARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONENARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTQUARTERS: ['SM1', 'SM2', 'SM3', 'SM4'],
  QUARTERS: ['sánzá mísáto ya yambo', 'sánzá mísáto ya míbalé',
      'sánzá mísáto ya mísáto', 'sánzá mísáto ya mínei'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, y MMMM dd', 'y MMMM d', 'y MMM d', 'yy/MM/dd'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale ln_CG.
 */
goog.i18n.DateTimeSymbols_ln_CG = {
  ERAS: ['libosó ya Y.-K.', 'nsima ya Y.-K.'],
  ERANAMES: ['libosó ya Y.-K.', 'nsima ya Y.-K.'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['sánzá ya yambo', 'sánzá ya míbalé', 'sánzá ya mísáto',
      'sánzá ya mínei', 'sánzá ya mítáno', 'sánzá ya motóbá',
      'sánzá ya nsambo', 'sánzá ya mwambe', 'sánzá ya libwa',
      'sánzá ya zómi', 'sánzá ya zómi na mɔ̌kɔ́',
      'sánzá ya zómi na míbalé'],
  STANDALONEMONTHS: ['sánzá ya yambo', 'sánzá ya míbalé',
      'sánzá ya mísáto', 'sánzá ya mínei', 'sánzá ya mítáno',
      'sánzá ya motóbá', 'sánzá ya nsambo', 'sánzá ya mwambe',
      'sánzá ya libwa', 'sánzá ya zómi', 'sánzá ya zómi na mɔ̌kɔ́',
      'sánzá ya zómi na míbalé'],
  SHORTMONTHS: ['s1', 's2', 's3', 's4', 's5', 's6', 's7', 's8', 's9', 's10',
      's11', 's12'],
  STANDALONESHORTMONTHS: ['s1', 's2', 's3', 's4', 's5', 's6', 's7', 's8', 's9',
      's10', 's11', 's12'],
  WEEKDAYS: ['eyenga', 'mokɔlɔ ya libosó', 'mokɔlɔ ya míbalé',
      'mokɔlɔ ya mísáto', 'mokɔlɔ ya mínéi', 'mokɔlɔ ya mítáno',
      'mpɔ́sɔ'],
  STANDALONEWEEKDAYS: ['eyenga', 'mokɔlɔ ya libosó', 'mokɔlɔ ya míbalé',
      'mokɔlɔ ya mísáto', 'mokɔlɔ ya mínéi', 'mokɔlɔ ya mítáno',
      'mpɔ́sɔ'],
  SHORTWEEKDAYS: ['eye', 'm1', 'm2', 'm3', 'm4', 'm5', 'mps'],
  STANDALONESHORTWEEKDAYS: ['eye', 'm1', 'm2', 'm3', 'm4', 'm5', 'mps'],
  NARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONENARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTQUARTERS: ['SM1', 'SM2', 'SM3', 'SM4'],
  QUARTERS: ['sánzá mísáto ya yambo', 'sánzá mísáto ya míbalé',
      'sánzá mísáto ya mísáto', 'sánzá mísáto ya mínei'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, y MMMM dd', 'y MMMM d', 'y MMM d', 'yy/MM/dd'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale lo.
 */
goog.i18n.DateTimeSymbols_lo = {
  ERAS: ['ປີກ່ອນຄິດສະການທີ່', 'ຄ.ສ.'],
  ERANAMES: ['ປີກ່ອນຄິດສະການທີ່', 'ຄ.ສ.'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['ມັງກອນ', 'ກຸມພາ', 'ມີນາ',
      'ເມສາ', 'ພຶດສະພາ', 'ມິຖຸນາ',
      'ກໍລະກົດ', 'ສິງຫາ', 'ກັນຍາ',
      'ຕຸລາ', 'ພະຈິກ', 'ທັນວາ'],
  STANDALONEMONTHS: ['ມັງກອນ', 'ກຸມພາ', 'ມີນາ',
      'ເມສາ', 'ພຶດສະພາ', 'ມິຖຸນາ',
      'ກໍລະກົດ', 'ສິງຫາ', 'ກັນຍາ',
      'ຕຸລາ', 'ພະຈິກ', 'ທັນວາ'],
  SHORTMONTHS: ['ມ.ກ.', 'ກ.ພ.', 'ມີ.ນ.', 'ມ.ສ..', 'ພ.ພ.',
      'ມິ.ຖ.', 'ກ.ລ.', 'ສ.ຫ.', 'ກ.ຍ.', 'ຕ.ລ.', 'ພ.ຈ.',
      'ທ.ວ.'],
  STANDALONESHORTMONTHS: ['ມ.ກ.', 'ກ.ພ.', 'ມີ.ນ.', 'ມ.ສ..',
      'ພ.ພ.', 'ມິ.ຖ.', 'ກ.ລ.', 'ສ.ຫ.', 'ກ.ຍ.', 'ຕ.ລ.',
      'ພ.ຈ.', 'ທ.ວ.'],
  WEEKDAYS: ['ວັນອາທິດ', 'ວັນຈັນ',
      'ວັນອັງຄານ', 'ວັນພຸດ',
      'ວັນພະຫັດ', 'ວັນສຸກ',
      'ວັນເສົາ'],
  STANDALONEWEEKDAYS: ['ວັນອາທິດ', 'ວັນຈັນ',
      'ວັນອັງຄານ', 'ວັນພຸດ',
      'ວັນພະຫັດ', 'ວັນສຸກ',
      'ວັນເສົາ'],
  SHORTWEEKDAYS: ['ອາ.', 'ຈ.', 'ອ.', 'ພ.', 'ພຫ.', 'ສກ.',
      'ສ.'],
  STANDALONESHORTWEEKDAYS: ['ອາ.', 'ຈ.', 'ອ.', 'ພ.', 'ພຫ.',
      'ສກ.', 'ສ.'],
  NARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONENARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['ກ່ອນທ່ຽງ', 'ຫລັງທ່ຽງ'],
  DATEFORMATS: ['EEEEທີ d MMMM G y', 'd MMMM y', 'd MMM y', 'd/M/yyyy'],
  TIMEFORMATS: ['Hໂມງ mນາທີ ss ວິນາທີzzzz',
      'H ໂມງ mນາທີss z', 'H:mm:ss', 'H:mm'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale lo_LA.
 */
goog.i18n.DateTimeSymbols_lo_LA = goog.i18n.DateTimeSymbols_lo;


/**
 * Date/time formatting symbols for locale lt_LT.
 */
goog.i18n.DateTimeSymbols_lt_LT = {
  ERAS: ['pr. Kr.', 'po Kr.'],
  ERANAMES: ['prieš Kristų', 'po Kristaus'],
  NARROWMONTHS: ['S', 'V', 'K', 'B', 'G', 'B', 'L', 'R', 'R', 'S', 'L', 'G'],
  STANDALONENARROWMONTHS: ['S', 'V', 'K', 'B', 'G', 'B', 'L', 'R', 'R', 'S',
      'L', 'G'],
  MONTHS: ['sausis', 'vasaris', 'kovas', 'balandis', 'gegužė', 'birželis',
      'liepa', 'rugpjūtis', 'rugsėjis', 'spalis', 'lapkritis', 'gruodis'],
  STANDALONEMONTHS: ['Sausis', 'Vasaris', 'Kovas', 'Balandis', 'Gegužė',
      'Birželis', 'Liepa', 'Rugpjūtis', 'Rugsėjis', 'Spalis', 'Lapkritis',
      'Gruodis'],
  SHORTMONTHS: ['Sau', 'Vas', 'Kov', 'Bal', 'Geg', 'Bir', 'Lie', 'Rgp', 'Rgs',
      'Spl', 'Lap', 'Grd'],
  STANDALONESHORTMONTHS: ['Saus.', 'Vas.', 'kov', 'Bal.', 'Geg.', 'Bir.',
      'Liep.', 'Rugpj.', 'Rugs.', 'Spal.', 'Lapkr.', 'Gruod.'],
  WEEKDAYS: ['sekmadienis', 'pirmadienis', 'antradienis', 'trečiadienis',
      'ketvirtadienis', 'penktadienis', 'šeštadienis'],
  STANDALONEWEEKDAYS: ['sekmadienis', 'pirmadienis', 'antradienis',
      'trečiadienis', 'ketvirtadienis', 'penktadienis', 'šeštadienis'],
  SHORTWEEKDAYS: ['Sk', 'Pr', 'An', 'Tr', 'Kt', 'Pn', 'Št'],
  STANDALONESHORTWEEKDAYS: ['Sk', 'Pi', 'A', 'T', 'K', 'Pe', 'Š'],
  NARROWWEEKDAYS: ['S', 'P', 'A', 'T', 'K', 'P', 'Š'],
  STANDALONENARROWWEEKDAYS: ['S', 'P', 'A', 'T', 'K', 'P', 'Š'],
  SHORTQUARTERS: ['K1', 'K2', 'K3', 'K4'],
  QUARTERS: ['pirmas ketvirtis', 'antras ketvirtis', 'trečias ketvirtis',
      'ketvirtas ketvirtis'],
  AMPMS: ['priešpiet', 'popiet'],
  DATEFORMATS: ['y \'m\'. MMMM d \'d\'.,EEEE', 'y \'m\'. MMMM d \'d\'.',
      'yyyy.MM.dd', 'yyyy-MM-dd'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale lv_LV.
 */
goog.i18n.DateTimeSymbols_lv_LV = {
  ERAS: ['p.m.ē.', 'm.ē.'],
  ERANAMES: ['pirms mūsu ēras', 'mūsu ērā'],
  NARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['janvāris', 'februāris', 'marts', 'aprīlis', 'maijs', 'jūnijs',
      'jūlijs', 'augusts', 'septembris', 'oktobris', 'novembris', 'decembris'],
  STANDALONEMONTHS: ['janvāris', 'februāris', 'marts', 'aprīlis', 'maijs',
      'jūnijs', 'jūlijs', 'augusts', 'septembris', 'oktobris', 'novembris',
      'decembris'],
  SHORTMONTHS: ['janv.', 'febr.', 'marts', 'apr.', 'maijs', 'jūn.', 'jūl.',
      'aug.', 'sept.', 'okt.', 'nov.', 'dec.'],
  STANDALONESHORTMONTHS: ['janv.', 'febr.', 'marts', 'apr.', 'maijs', 'jūn.',
      'jūl.', 'aug.', 'sept.', 'okt.', 'nov.', 'dec.'],
  WEEKDAYS: ['svētdiena', 'pirmdiena', 'otrdiena', 'trešdiena', 'ceturtdiena',
      'piektdiena', 'sestdiena'],
  STANDALONEWEEKDAYS: ['svētdiena', 'pirmdiena', 'otrdiena', 'trešdiena',
      'ceturtdiena', 'piektdiena', 'sestdiena'],
  SHORTWEEKDAYS: ['Sv', 'Pr', 'Ot', 'Tr', 'Ce', 'Pk', 'Se'],
  STANDALONESHORTWEEKDAYS: ['Sv', 'Pr', 'Ot', 'Tr', 'Ce', 'Pk', 'Se'],
  NARROWWEEKDAYS: ['S', 'P', 'O', 'T', 'C', 'P', 'S'],
  STANDALONENARROWWEEKDAYS: ['S', 'P', 'O', 'T', 'C', 'P', 'S'],
  SHORTQUARTERS: ['C1', 'C2', 'C3', 'C4'],
  QUARTERS: ['1. ceturksnis', '2. ceturksnis', '3. ceturksnis',
      '4. ceturksnis'],
  AMPMS: ['priekšpusdienā', 'pēcpusdienā'],
  DATEFORMATS: ['EEEE, y. \'gada\' d. MMMM', 'y. \'gada\' d. MMMM',
      'y. \'gada\' d. MMM', 'dd.MM.yy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale mk.
 */
goog.i18n.DateTimeSymbols_mk = {
  ERAS: ['пр.н.е.', 'ае.'],
  ERANAMES: ['пр.н.е.', 'ае.'],
  NARROWMONTHS: ['ј', 'ф', 'м', 'а', 'м', 'ј', 'ј', 'а', 'с', 'о',
      'н', 'д'],
  STANDALONENARROWMONTHS: ['ј', 'ф', 'м', 'а', 'м', 'ј', 'ј', 'а', 'с',
      'о', 'н', 'д'],
  MONTHS: ['јануари', 'февруари', 'март', 'април',
      'мај', 'јуни', 'јули', 'август', 'септември',
      'октомври', 'ноември', 'декември'],
  STANDALONEMONTHS: ['јануари', 'февруари', 'март',
      'април', 'мај', 'јуни', 'јули', 'август',
      'септември', 'октомври', 'ноември',
      'декември'],
  SHORTMONTHS: ['јан.', 'фев.', 'мар.', 'апр.', 'мај', 'јун.',
      'јул.', 'авг.', 'септ.', 'окт.', 'ноем.', 'декем.'],
  STANDALONESHORTMONTHS: ['јан.', 'фев.', 'мар.', 'апр.', 'мај',
      'јун.', 'јул.', 'авг.', 'септ.', 'окт.', 'ноем.',
      'декем.'],
  WEEKDAYS: ['недела', 'понеделник', 'вторник',
      'среда', 'четврток', 'петок', 'сабота'],
  STANDALONEWEEKDAYS: ['недела', 'понеделник', 'вторник',
      'среда', 'четврток', 'петок', 'сабота'],
  SHORTWEEKDAYS: ['нед.', 'пон.', 'вт.', 'сре.', 'чет.',
      'пет.', 'саб.'],
  STANDALONESHORTWEEKDAYS: ['нед.', 'пон.', 'вт.', 'сре.', 'чет.',
      'пет.', 'саб.'],
  NARROWWEEKDAYS: ['н', 'п', 'в', 'с', 'ч', 'п', 'с'],
  STANDALONENARROWWEEKDAYS: ['н', 'п', 'в', 'с', 'ч', 'п', 'с'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['прво тромесечје', 'второ тромесечје',
      'трето тромесечје', 'четврто тромесечје'],
  AMPMS: ['претпладне', 'попладне'],
  DATEFORMATS: ['EEEE, dd MMMM y', 'dd MMMM y', 'dd.M.yyyy', 'dd.M.yy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale mk_MK.
 */
goog.i18n.DateTimeSymbols_mk_MK = goog.i18n.DateTimeSymbols_mk;


/**
 * Date/time formatting symbols for locale ml_IN.
 */
goog.i18n.DateTimeSymbols_ml_IN = {
  ERAS: ['ക്രി.മൂ', 'ക്രി.പി.'],
  ERANAMES: ['ക്രിസ്തുവിനു് മുമ്പ്‌',
      'ക്രിസ്തുവിന് പിന്‍പ്'],
  NARROWMONTHS: ['ജ', 'ഫെ', 'മാ', 'ഏ', 'മേ', 'ജൂ', 'ജൂ',
      'ഓ', 'സെ', 'ഒ', 'ന', 'ഡി'],
  STANDALONENARROWMONTHS: ['ജ', 'ഫെ', 'മാ', 'ഏ', 'മേ', 'ജൂ',
      'ജൂ', 'ഓ', 'സെ', 'ഒ', 'ന', 'ഡി'],
  MONTHS: ['ജനുവരി', 'ഫെബ്രുവരി',
      'മാര്‍ച്ച്', 'ഏപ്രില്‍', 'മേയ്',
      'ജൂണ്‍', 'ജൂലൈ', 'ആഗസ്റ്റ്',
      'സെപ്റ്റംബര്‍', 'ഒക്ടോബര്‍',
      'നവംബര്‍', 'ഡിസംബര്‍'],
  STANDALONEMONTHS: ['ജനുവരി', 'ഫെബ്രുവരി',
      'മാര്‍ച്ച്', 'ഏപ്രില്‍', 'മേയ്',
      'ജൂണ്‍', 'ജൂലൈ', 'ആഗസ്റ്റ്',
      'സെപ്റ്റംബര്‍', 'ഒക്ടോബര്‍',
      'നവംബര്‍', 'ഡിസംബര്‍'],
  SHORTMONTHS: ['ജനു', 'ഫെബ്രു', 'മാര്‍',
      'ഏപ്രി', 'മേയ്', 'ജൂണ്‍', 'ജൂലൈ',
      'ഓഗ', 'സെപ്റ്റം', 'ഒക്ടോ', 'നവം',
      'ഡിസം'],
  STANDALONESHORTMONTHS: ['ജനു', 'ഫെബ്രു', 'മാര്‍',
      'ഏപ്രി', 'മേയ്', 'ജൂണ്‍', 'ജൂലൈ',
      'ഓഗ', 'സെപ്റ്റം', 'ഒക്ടോ', 'നവം',
      'ഡിസം'],
  WEEKDAYS: ['ഞായറാഴ്ച', 'തിങ്കളാഴ്ച',
      'ചൊവ്വാഴ്ച', 'ബുധനാഴ്ച',
      'വ്യാഴാഴ്ച', 'വെള്ളിയാഴ്ച',
      'ശനിയാഴ്ച'],
  STANDALONEWEEKDAYS: ['ഞായറാഴ്ച',
      'തിങ്കളാഴ്ച', 'ചൊവ്വാഴ്ച',
      'ബുധനാഴ്ച', 'വ്യാഴാഴ്ച',
      'വെള്ളിയാഴ്ച', 'ശനിയാഴ്ച'],
  SHORTWEEKDAYS: ['ഞായര്‍', 'തിങ്കള്‍',
      'ചൊവ്വ', 'ബുധന്‍', 'വ്യാഴം',
      'വെള്ളി', 'ശനി'],
  STANDALONESHORTWEEKDAYS: ['ഞായര്‍', 'തിങ്കള്‍',
      'ചൊവ്വ', 'ബുധന്‍', 'വ്യാഴം',
      'വെള്ളി', 'ശനി'],
  NARROWWEEKDAYS: ['ഞാ', 'തി', 'ചൊ', 'ബു', 'വ്യാ',
      'വെ', 'ശ'],
  STANDALONENARROWWEEKDAYS: ['ഞാ', 'തി', 'ചൊ', 'ബു',
      'വ്യാ', 'വെ', 'ശ'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['ഒന്നാം പാദം',
      'രണ്ടാം പാദം', 'മൂന്നാം പാദം',
      'നാലാം പാദം'],
  AMPMS: ['രാവിലെ', 'വൈകുന്നേരം'],
  DATEFORMATS: ['y, MMMM d, EEEE', 'y, MMMM d', 'y, MMM d', 'dd/MM/yy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [6, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale mn.
 */
goog.i18n.DateTimeSymbols_mn = {
  ERAS: ['м.э.ө', 'м.э.'],
  ERANAMES: ['манай эриний өмнөх', 'манай эриний'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['Хулгана', 'Үхэр', 'Бар', 'Туулай', 'Луу',
      'Могой', 'Морь', 'Хонь', 'Бич', 'Тахиа',
      'Нохой', 'Гахай'],
  STANDALONEMONTHS: ['Хулгана', 'Үхэр', 'Бар', 'Туулай',
      'Луу', 'Могой', 'Морь', 'Хонь', 'Бич', 'Тахиа',
      'Нохой', 'Гахай'],
  SHORTMONTHS: ['хул', 'үхэ', 'бар', 'туу', 'луу', 'мог',
      'мор', 'хон', 'бич', 'тах', 'нох', 'гах'],
  STANDALONESHORTMONTHS: ['хул', 'үхэ', 'бар', 'туу', 'луу',
      'мог', 'мор', 'хон', 'бич', 'тах', 'нох', 'гах'],
  WEEKDAYS: ['ням', 'даваа', 'мягмар', 'лхагва',
      'пүрэв', 'баасан', 'бямба'],
  STANDALONEWEEKDAYS: ['ням', 'даваа', 'мягмар', 'лхагва',
      'пүрэв', 'баасан', 'бямба'],
  SHORTWEEKDAYS: ['Ня', 'Да', 'Мя', 'Лх', 'Пү', 'Ба', 'Бя'],
  STANDALONESHORTWEEKDAYS: ['Ня', 'Да', 'Мя', 'Лх', 'Пү', 'Ба',
      'Бя'],
  NARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONENARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTQUARTERS: ['1/4', '2/4', '3/4', '4/4'],
  QUARTERS: ['дөрөвний нэг', 'дөрөвний хоёр',
      'дөрөвний гурав', 'дөрөвний дөрөв'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, y MMMM dd', 'y MMMM d', 'y MMM d', 'yyyy-MM-dd'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale mn_CN.
 */
goog.i18n.DateTimeSymbols_mn_CN = goog.i18n.DateTimeSymbols_mn;


/**
 * Date/time formatting symbols for locale mn_Cyrl.
 */
goog.i18n.DateTimeSymbols_mn_Cyrl = goog.i18n.DateTimeSymbols_mn;


/**
 * Date/time formatting symbols for locale mn_Cyrl_MN.
 */
goog.i18n.DateTimeSymbols_mn_Cyrl_MN = goog.i18n.DateTimeSymbols_mn;


/**
 * Date/time formatting symbols for locale mn_MN.
 */
goog.i18n.DateTimeSymbols_mn_MN = goog.i18n.DateTimeSymbols_mn;


/**
 * Date/time formatting symbols for locale mn_Mong.
 */
goog.i18n.DateTimeSymbols_mn_Mong = goog.i18n.DateTimeSymbols_mn;


/**
 * Date/time formatting symbols for locale mn_Mong_CN.
 */
goog.i18n.DateTimeSymbols_mn_Mong_CN = goog.i18n.DateTimeSymbols_mn;


/**
 * Date/time formatting symbols for locale mr_IN.
 */
goog.i18n.DateTimeSymbols_mr_IN = {
  ERAS: ['ई.स.पू.', 'ई.स.'],
  ERANAMES: ['ईसवीसनपूर्व', 'ईसवीसन'],
  NARROWMONTHS: ['जा', 'फे', 'मा', 'ए', 'मे', 'जू',
      'जु', 'ऑ', 'स', 'ऑ', 'नो', 'डि'],
  STANDALONENARROWMONTHS: ['जा', 'फे', 'मा', 'ए', 'मे',
      'जू', 'जु', 'ऑ', 'स', 'ऑ', 'नो', 'डि'],
  MONTHS: ['जानेवारी', 'फेब्रुवारी',
      'मार्च', 'एप्रिल', 'मे', 'जून',
      'जुलै', 'ऑगस्ट', 'सप्टेंबर',
      'ऑक्टोबर', 'नोव्हेंबर',
      'डिसेंबर'],
  STANDALONEMONTHS: ['जानेवारी',
      'फेब्रुवारी', 'मार्च', 'एप्रिल',
      'मे', 'जून', 'जुलै', 'ऑगस्ट',
      'सप्टेंबर', 'ऑक्टोबर',
      'नोव्हेंबर', 'डिसेंबर'],
  SHORTMONTHS: ['जानेवारी', 'फेब्रुवारी',
      'मार्च', 'एप्रिल', 'मे', 'जून',
      'जुलै', 'ऑगस्ट', 'सप्टेंबर',
      'ऑक्टोबर', 'नोव्हेंबर',
      'डिसेंबर'],
  STANDALONESHORTMONTHS: ['जानेवारी',
      'फेब्रुवारी', 'मार्च', 'एप्रिल',
      'मे', 'जून', 'जुलै', 'ऑगस्ट',
      'सप्टेंबर', 'ऑक्टोबर',
      'नोव्हेंबर', 'डिसेंबर'],
  WEEKDAYS: ['रविवार', 'सोमवार',
      'मंगळवार', 'बुधवार', 'गुरुवार',
      'शुक्रवार', 'शनिवार'],
  STANDALONEWEEKDAYS: ['रविवार', 'सोमवार',
      'मंगळवार', 'बुधवार', 'गुरुवार',
      'शुक्रवार', 'शनिवार'],
  SHORTWEEKDAYS: ['रवि', 'सोम', 'मंगळ', 'बुध',
      'गुरु', 'शुक्र', 'शनि'],
  STANDALONESHORTWEEKDAYS: ['रवि', 'सोम', 'मंगळ',
      'बुध', 'गुरु', 'शुक्र', 'शनि'],
  NARROWWEEKDAYS: ['र', 'सो', 'मं', 'बु', 'गु', 'शु',
      'श'],
  STANDALONENARROWWEEKDAYS: ['र', 'सो', 'मं', 'बु', 'गु',
      'शु', 'श'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['प्रथम तिमाही',
      'द्वितीय तिमाही',
      'तृतीय तिमाही',
      'चतुर्थ तिमाही'],
  AMPMS: ['am', 'pm'],
  DATEFORMATS: ['EEEE d MMMM y', 'd MMMM y', 'd MMM y', 'd-M-yy'],
  TIMEFORMATS: ['h-mm-ss a zzzz', 'h-mm-ss a z', 'h-mm-ss a', 'h-mm a'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [6, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale ms_BN.
 */
goog.i18n.DateTimeSymbols_ms_BN = {
  ERAS: ['S.M.', 'T.M.'],
  ERANAMES: ['S.M.', 'T.M.'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['Januari', 'Februari', 'Mac', 'April', 'Mei', 'Jun', 'Julai', 'Ogos',
      'September', 'Oktober', 'November', 'Disember'],
  STANDALONEMONTHS: ['Januari', 'Februari', 'Mac', 'April', 'Mei', 'Jun',
      'Julai', 'Ogos', 'September', 'Oktober', 'November', 'Disember'],
  SHORTMONTHS: ['Jan', 'Feb', 'Mac', 'Apr', 'Mei', 'Jun', 'Jul', 'Ogos', 'Sep',
      'Okt', 'Nov', 'Dis'],
  STANDALONESHORTMONTHS: ['Jan', 'Feb', 'Mac', 'Apr', 'Mei', 'Jun', 'Jul',
      'Ogos', 'Sep', 'Okt', 'Nov', 'Dis'],
  WEEKDAYS: ['Ahad', 'Isnin', 'Selasa', 'Rabu', 'Khamis', 'Jumaat', 'Sabtu'],
  STANDALONEWEEKDAYS: ['Ahad', 'Isnin', 'Selasa', 'Rabu', 'Khamis', 'Jumaat',
      'Sabtu'],
  SHORTWEEKDAYS: ['Ahd', 'Isn', 'Sel', 'Rab', 'Kha', 'Jum', 'Sab'],
  STANDALONESHORTWEEKDAYS: ['Ahd', 'Isn', 'Sel', 'Rab', 'Kha', 'Jum', 'Sab'],
  NARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONENARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTQUARTERS: ['S1', 'S2', 'S3', 'S4'],
  QUARTERS: ['suku pertama', 'suku kedua', 'suku ketiga', 'suku keempat'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['dd MMMM y', 'd MMMM y', 'dd/MM/yyyy', 'd/MM/yy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale ms_MY.
 */
goog.i18n.DateTimeSymbols_ms_MY = {
  ERAS: ['S.M.', 'T.M.'],
  ERANAMES: ['S.M.', 'T.M.'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['Januari', 'Februari', 'Mac', 'April', 'Mei', 'Jun', 'Julai', 'Ogos',
      'September', 'Oktober', 'November', 'Disember'],
  STANDALONEMONTHS: ['Januari', 'Februari', 'Mac', 'April', 'Mei', 'Jun',
      'Julai', 'Ogos', 'September', 'Oktober', 'November', 'Disember'],
  SHORTMONTHS: ['Jan', 'Feb', 'Mac', 'Apr', 'Mei', 'Jun', 'Jul', 'Ogos', 'Sep',
      'Okt', 'Nov', 'Dis'],
  STANDALONESHORTMONTHS: ['Jan', 'Feb', 'Mac', 'Apr', 'Mei', 'Jun', 'Jul',
      'Ogos', 'Sep', 'Okt', 'Nov', 'Dis'],
  WEEKDAYS: ['Ahad', 'Isnin', 'Selasa', 'Rabu', 'Khamis', 'Jumaat', 'Sabtu'],
  STANDALONEWEEKDAYS: ['Ahad', 'Isnin', 'Selasa', 'Rabu', 'Khamis', 'Jumaat',
      'Sabtu'],
  SHORTWEEKDAYS: ['Ahd', 'Isn', 'Sel', 'Rab', 'Kha', 'Jum', 'Sab'],
  STANDALONESHORTWEEKDAYS: ['Ahd', 'Isn', 'Sel', 'Rab', 'Kha', 'Jum', 'Sab'],
  NARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONENARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTQUARTERS: ['S1', 'S2', 'S3', 'S4'],
  QUARTERS: ['suku pertama', 'suku kedua', 'suku ketiga', 'suku keempat'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, d MMMM y', 'd MMMM y', 'dd/MM/yyyy', 'd/MM/yy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale mt_MT.
 */
goog.i18n.DateTimeSymbols_mt_MT = {
  ERAS: ['QK', 'WK'],
  ERANAMES: ['Qabel Kristu', 'Wara Kristu'],
  NARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'Ġ', 'L', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'Ġ', 'L', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['Jannar', 'Frar', 'Marzu', 'April', 'Mejju', 'Ġunju', 'Lulju',
      'Awwissu', 'Settembru', 'Ottubru', 'Novembru', 'Diċembru'],
  STANDALONEMONTHS: ['Jannar', 'Frar', 'Marzu', 'April', 'Mejju', 'Ġunju',
      'Lulju', 'Awwissu', 'Settembru', 'Ottubru', 'Novembru', 'Diċembru'],
  SHORTMONTHS: ['Jan', 'Fra', 'Mar', 'Apr', 'Mej', 'Ġun', 'Lul', 'Aww', 'Set',
      'Ott', 'Nov', 'Diċ'],
  STANDALONESHORTMONTHS: ['Jan', 'Fra', 'Mar', 'Apr', 'Mej', 'Ġun', 'Lul',
      'Aww', 'Set', 'Ott', 'Nov', 'Diċ'],
  WEEKDAYS: ['Il-Ħadd', 'It-Tnejn', 'It-Tlieta', 'L-Erbgħa', 'Il-Ħamis',
      'Il-Ġimgħa', 'Is-Sibt'],
  STANDALONEWEEKDAYS: ['Il-Ħadd', 'It-Tnejn', 'It-Tlieta', 'L-Erbgħa',
      'Il-Ħamis', 'Il-Ġimgħa', 'Is-Sibt'],
  SHORTWEEKDAYS: ['Ħad', 'Tne', 'Tli', 'Erb', 'Ħam', 'Ġim', 'Sib'],
  STANDALONESHORTWEEKDAYS: ['Ħad', 'Tne', 'Tli', 'Erb', 'Ħam', 'Ġim', 'Sib'],
  NARROWWEEKDAYS: ['Ħ', 'T', 'T', 'E', 'Ħ', 'Ġ', 'S'],
  STANDALONENARROWWEEKDAYS: ['Ħ', 'T', 'T', 'E', 'Ħ', 'Ġ', 'S'],
  SHORTQUARTERS: ['K1', 'K2', 'K3', 'K4'],
  QUARTERS: ['K1', 'K2', 'K3', 'K4'],
  AMPMS: ['QN', 'WN'],
  DATEFORMATS: ['EEEE, d \'ta\'’ MMMM y', 'd \'ta\'’ MMMM y', 'dd MMM y',
      'dd/MM/yyyy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale my.
 */
goog.i18n.DateTimeSymbols_my = {
  ERAS: ['ဘီစီ', 'အေဒီ'],
  ERANAMES: ['ခရစ်တော် မပေါ်မီကာလ',
      'ခရစ်တော် ပေါ်ထွန်းပြီးကာလ'],
  NARROWMONTHS: ['ဇ', 'ဖ', 'မ', 'ဧ', 'မ', 'ဇ', 'ဇ', 'ဩ', 'စ',
      'အ', 'န', 'ဒ'],
  STANDALONENARROWMONTHS: ['ဇ', 'ဖ', 'မ', 'ဧ', 'မ', 'ဇ', 'ဇ',
      'ဩ', 'စ', 'အ', 'န', 'ဒ'],
  MONTHS: ['ဇန်နဝါရီ', 'ဖေဖော်ဝါရီ',
      'မတ်', 'ဧပြီ', 'မေ', 'ဇွန်',
      'ဇူလိုင်', 'ဩဂုတ်', 'စက်တင်ဘာ',
      'အောက်တိုဘာ', 'နိုဝင်ဘာ',
      'ဒီဇင်ဘာ'],
  STANDALONEMONTHS: ['ဇန်နဝါရီ',
      'ဖေဖော်ဝါရီ', 'မတ်', 'ဧပြီ', 'မေ',
      'ဇွန်', 'ဇူလိုင်', 'ဩဂုတ်',
      'စက်တင်ဘာ', 'အောက်တိုဘာ',
      'နိုဝင်ဘာ', 'ဒီဇင်ဘာ'],
  SHORTMONTHS: ['ဇန်', 'ဖေ', 'မတ်', 'ဧ', 'မေ',
      'ဇွန်', 'ဇူ', 'ဩ', 'စက်', 'အောက်',
      'နို', 'ဒီ'],
  STANDALONESHORTMONTHS: ['ဇန်', 'ဖေ', 'မတ်', 'ဧ', 'မေ',
      'ဇွန်', 'ဇူ', 'ဩ', 'စက်', 'အောက်',
      'နို', 'ဒီ'],
  WEEKDAYS: ['တနင်္ဂနွေ', 'တနင်္လာ',
      'အင်္ဂါ', 'ဗုဒ္ဓဟူး',
      'ကြာသပတေး', 'သောကြာ', 'စနေ'],
  STANDALONEWEEKDAYS: ['တနင်္ဂနွေ', 'တနင်္လာ',
      'အင်္ဂါ', 'ဗုဒ္ဓဟူး',
      'ကြာသပတေး', 'သောကြာ', 'စနေ'],
  SHORTWEEKDAYS: ['နွေ', 'လာ', 'ဂါ', 'ဟူး', 'တေး',
      'ကြာ', 'နေ'],
  STANDALONESHORTWEEKDAYS: ['နွေ', 'လာ', 'ဂါ', 'ဟူး',
      'တေး', 'ကြာ', 'နေ'],
  NARROWWEEKDAYS: ['တ', 'တ', 'အ', 'ဗ', 'က', 'သ', 'စ'],
  STANDALONENARROWWEEKDAYS: ['တ', 'တ', 'အ', 'ဗ', 'က', 'သ', 'စ'],
  SHORTQUARTERS: ['ပ-စိတ်', 'ဒု-စိတ်', 'တ-စိတ်',
      'စ-စိတ်'],
  QUARTERS: ['ပထမ သုံးလပတ်',
      'ဒုတိယ သုံးလပတ်',
      'တတိယ သုံးလပတ်',
      'စတုတ္ထ သုံးလပတ်'],
  AMPMS: ['နံနက်', 'ညနေ'],
  DATEFORMATS: ['EEEE, y MMMM dd', 'y MMMM d', 'y MMM d', 'yy/MM/dd'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale my_MM.
 */
goog.i18n.DateTimeSymbols_my_MM = goog.i18n.DateTimeSymbols_my;


/**
 * Date/time formatting symbols for locale nb.
 */
goog.i18n.DateTimeSymbols_nb = {
  ERAS: ['f.Kr.', 'e.Kr.'],
  ERANAMES: ['f.Kr.', 'e.Kr.'],
  NARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['januar', 'februar', 'mars', 'april', 'mai', 'juni', 'juli',
      'august', 'september', 'oktober', 'november', 'desember'],
  STANDALONEMONTHS: ['januar', 'februar', 'mars', 'april', 'mai', 'juni',
      'juli', 'august', 'september', 'oktober', 'november', 'desember'],
  SHORTMONTHS: ['jan.', 'feb.', 'mars', 'apr.', 'mai', 'juni', 'juli', 'aug.',
      'sep.', 'okt.', 'nov.', 'des.'],
  STANDALONESHORTMONTHS: ['jan.', 'feb.', 'mars', 'apr.', 'mai', 'juni', 'juli',
      'aug.', 'sep.', 'okt.', 'nov.', 'des.'],
  WEEKDAYS: ['søndag', 'mandag', 'tirsdag', 'onsdag', 'torsdag', 'fredag',
      'lørdag'],
  STANDALONEWEEKDAYS: ['søndag', 'mandag', 'tirsdag', 'onsdag', 'torsdag',
      'fredag', 'lørdag'],
  SHORTWEEKDAYS: ['søn.', 'man.', 'tir.', 'ons.', 'tor.', 'fre.', 'lør.'],
  STANDALONESHORTWEEKDAYS: ['sø.', 'ma.', 'ti.', 'on.', 'to.', 'fr.', 'lø.'],
  NARROWWEEKDAYS: ['S', 'M', 'T', 'O', 'T', 'F', 'L'],
  STANDALONENARROWWEEKDAYS: ['S', 'M', 'T', 'O', 'T', 'F', 'L'],
  SHORTQUARTERS: ['K1', 'K2', 'K3', 'K4'],
  QUARTERS: ['1. kvartal', '2. kvartal', '3. kvartal', '4. kvartal'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE d. MMMM y', 'd. MMMM y', 'd. MMM y', 'dd.MM.yy'],
  TIMEFORMATS: ['\'kl\'. HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale nb_NO.
 */
goog.i18n.DateTimeSymbols_nb_NO = goog.i18n.DateTimeSymbols_nb;


/**
 * Date/time formatting symbols for locale nds.
 */
goog.i18n.DateTimeSymbols_nds = {
  ERAS: ['BCE', 'CE'],
  ERANAMES: ['BCE', 'CE'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONEMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11',
      '12'],
  SHORTMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONESHORTMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  WEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONEWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONESHORTWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  NARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONENARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, y MMMM dd', 'y MMMM d', 'y MMM d', 'yyyy-MM-dd'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale nds_DE.
 */
goog.i18n.DateTimeSymbols_nds_DE = goog.i18n.DateTimeSymbols_nds;


/**
 * Date/time formatting symbols for locale ne.
 */
goog.i18n.DateTimeSymbols_ne = {
  ERAS: ['ईसा पूर्व', 'सन्'],
  ERANAMES: ['ईसा पूर्व', 'सन्'],
  NARROWMONTHS: ['१', '२', '३', '४', '५', '६', '७', '८', '९',
      '१०', '११', '१२'],
  STANDALONENARROWMONTHS: ['१', '२', '३', '४', '५', '६', '७',
      '८', '९', '१०', '११', '१२'],
  MONTHS: ['जनवरी', 'फेब्रुअरी', 'मार्च',
      'अप्रिल', 'मे', 'जुन', 'जुलाई',
      'अगस्त', 'सेप्टेम्बर',
      'अक्टोबर', 'नोभेम्बर',
      'डिसेम्बर'],
  STANDALONEMONTHS: ['जनवरी', 'फेब्रुअरी',
      'मार्च', 'अप्रिल', 'मे', 'जुन',
      'जुलाई', 'अगस्त', 'सेप्टेम्बर',
      'अक्टोबर', 'नोभेम्बर',
      'डिसेम्बर'],
  SHORTMONTHS: ['जन', 'फेब', 'मार्च', 'अप्रि',
      'मे', 'जुन', 'जुला', 'अग', 'सेप्ट',
      'अक्टो', 'नोभे', 'डिसे'],
  STANDALONESHORTMONTHS: ['जन', 'फेब', 'मार्च',
      'अप्रि', 'मे', 'जुन', 'जुला', 'अग',
      'सेप्ट', 'अक्टो', 'नोभे', 'डिसे'],
  WEEKDAYS: ['आइतबार', 'सोमबार',
      'मङ्गलबार', 'बुधबार', 'बिहीबार',
      'शुक्रबार', 'शनिबार'],
  STANDALONEWEEKDAYS: ['आइतबार', 'सोमबार',
      'मङ्गलबार', 'बुधबार', 'बिहीबार',
      'शुक्रबार', 'शनिबार'],
  SHORTWEEKDAYS: ['आइत', 'सोम', 'मङ्गल', 'बुध',
      'बिही', 'शुक्र', 'शनि'],
  STANDALONESHORTWEEKDAYS: ['आइत', 'सोम', 'मङ्गल',
      'बुध', 'बिही', 'शुक्र', 'शनि'],
  NARROWWEEKDAYS: ['१', '२', '३', '४', '५', '६', '७'],
  STANDALONENARROWWEEKDAYS: ['१', '२', '३', '४', '५', '६', '७'],
  SHORTQUARTERS: ['पहिलो सत्र',
      'दोस्रो सत्र', 'तेस्रो सत्र',
      'चौथो सत्र'],
  QUARTERS: ['पहिलो सत्र', 'दोस्रो सत्र',
      'तेस्रो सत्र', 'चौथो सत्र'],
  AMPMS: ['पूर्व मध्यान्ह',
      'उत्तर मध्यान्ह'],
  DATEFORMATS: ['EEEE, y MMMM dd', 'y MMMM d', 'y MMM d', 'yyyy-MM-dd'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale ne_IN.
 */
goog.i18n.DateTimeSymbols_ne_IN = {
  ERAS: ['ईसा पूर्व', 'सन्'],
  ERANAMES: ['ईसा पूर्व', 'सन्'],
  NARROWMONTHS: ['१', '२', '३', '४', '५', '६', '७', '८', '९',
      '१०', '११', '१२'],
  STANDALONENARROWMONTHS: ['१', '२', '३', '४', '५', '६', '७',
      '८', '९', '१०', '११', '१२'],
  MONTHS: ['जनवरी', 'फरवरी', 'मार्च',
      'अप्रेल', 'मई', 'जुन', 'जुलाई',
      'अगस्त', 'सेप्टेम्बर',
      'अक्टोबर', 'नोभेम्बर',
      'दिसम्बर'],
  STANDALONEMONTHS: ['जनवरी', 'फरवरी', 'मार्च',
      'अप्रेल', 'मई', 'जुन', 'जुलाई',
      'अगस्त', 'सेप्टेम्बर',
      'अक्टोबर', 'नोभेम्बर',
      'दिसम्बर'],
  SHORTMONTHS: ['जन', 'फेब', 'मार्च', 'अप्रि',
      'मे', 'जुन', 'जुला', 'अग', 'सेप्ट',
      'अक्टो', 'नोभे', 'डिसे'],
  STANDALONESHORTMONTHS: ['जन', 'फेब', 'मार्च',
      'अप्रि', 'मे', 'जुन', 'जुला', 'अग',
      'सेप्ट', 'अक्टो', 'नोभे', 'डिसे'],
  WEEKDAYS: ['आइतवार', 'सोमवार',
      'मङ्गलवार', 'बुधवार', 'बिहीवार',
      'शुक्रवार', 'शनिवार'],
  STANDALONEWEEKDAYS: ['आइतवार', 'सोमवार',
      'मङ्गलवार', 'बुधवार', 'बिहीवार',
      'शुक्रवार', 'शनिवार'],
  SHORTWEEKDAYS: ['आइत', 'सोम', 'मङ्गल', 'बुध',
      'बिही', 'शुक्र', 'शनि'],
  STANDALONESHORTWEEKDAYS: ['आइत', 'सोम', 'मङ्गल',
      'बुध', 'बिही', 'शुक्र', 'शनि'],
  NARROWWEEKDAYS: ['१', '२', '३', '४', '५', '६', '७'],
  STANDALONENARROWWEEKDAYS: ['१', '२', '३', '४', '५', '६', '७'],
  SHORTQUARTERS: ['पहिलो पाउ', 'दोस्रो पाउ',
      'तेस्रो पाउ', 'चौथो पाउ'],
  QUARTERS: ['पहिलो पाउ', 'दोस्रो पाउ',
      'तेस्रो पाउ', 'चौथो पाउ'],
  AMPMS: ['पूर्वाह्न', 'अपराह्न'],
  DATEFORMATS: ['EEEE, y MMMM dd', 'y MMMM d', 'y MMM d', 'yyyy-MM-dd'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [6, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale ne_NP.
 */
goog.i18n.DateTimeSymbols_ne_NP = goog.i18n.DateTimeSymbols_ne;


/**
 * Date/time formatting symbols for locale nl_BE.
 */
goog.i18n.DateTimeSymbols_nl_BE = {
  ERAS: ['v. Chr.', 'n. Chr.'],
  ERANAMES: ['Voor Christus', 'na Christus'],
  NARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['januari', 'februari', 'maart', 'april', 'mei', 'juni', 'juli',
      'augustus', 'september', 'oktober', 'november', 'december'],
  STANDALONEMONTHS: ['januari', 'februari', 'maart', 'april', 'mei', 'juni',
      'juli', 'augustus', 'september', 'oktober', 'november', 'december'],
  SHORTMONTHS: ['jan.', 'feb.', 'mrt.', 'apr.', 'mei', 'jun.', 'jul.', 'aug.',
      'sep.', 'okt.', 'nov.', 'dec.'],
  STANDALONESHORTMONTHS: ['jan', 'feb', 'mrt', 'apr', 'mei', 'jun', 'jul',
      'aug', 'sep', 'okt', 'nov', 'dec'],
  WEEKDAYS: ['zondag', 'maandag', 'dinsdag', 'woensdag', 'donderdag', 'vrijdag',
      'zaterdag'],
  STANDALONEWEEKDAYS: ['zondag', 'maandag', 'dinsdag', 'woensdag', 'donderdag',
      'vrijdag', 'zaterdag'],
  SHORTWEEKDAYS: ['zo', 'ma', 'di', 'wo', 'do', 'vr', 'za'],
  STANDALONESHORTWEEKDAYS: ['zo', 'ma', 'di', 'wo', 'do', 'vr', 'za'],
  NARROWWEEKDAYS: ['Z', 'M', 'D', 'W', 'D', 'V', 'Z'],
  STANDALONENARROWWEEKDAYS: ['Z', 'M', 'D', 'W', 'D', 'V', 'Z'],
  SHORTQUARTERS: ['K1', 'K2', 'K3', 'K4'],
  QUARTERS: ['1e kwartaal', '2e kwartaal', '3e kwartaal', '4e kwartaal'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE d MMMM y', 'd MMMM y', 'd-MMM-y', 'd/MM/yy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale nl_NL.
 */
goog.i18n.DateTimeSymbols_nl_NL = {
  ERAS: ['v. Chr.', 'n. Chr.'],
  ERANAMES: ['Voor Christus', 'na Christus'],
  NARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['januari', 'februari', 'maart', 'april', 'mei', 'juni', 'juli',
      'augustus', 'september', 'oktober', 'november', 'december'],
  STANDALONEMONTHS: ['januari', 'februari', 'maart', 'april', 'mei', 'juni',
      'juli', 'augustus', 'september', 'oktober', 'november', 'december'],
  SHORTMONTHS: ['jan.', 'feb.', 'mrt.', 'apr.', 'mei', 'jun.', 'jul.', 'aug.',
      'sep.', 'okt.', 'nov.', 'dec.'],
  STANDALONESHORTMONTHS: ['jan', 'feb', 'mrt', 'apr', 'mei', 'jun', 'jul',
      'aug', 'sep', 'okt', 'nov', 'dec'],
  WEEKDAYS: ['zondag', 'maandag', 'dinsdag', 'woensdag', 'donderdag', 'vrijdag',
      'zaterdag'],
  STANDALONEWEEKDAYS: ['zondag', 'maandag', 'dinsdag', 'woensdag', 'donderdag',
      'vrijdag', 'zaterdag'],
  SHORTWEEKDAYS: ['zo', 'ma', 'di', 'wo', 'do', 'vr', 'za'],
  STANDALONESHORTWEEKDAYS: ['zo', 'ma', 'di', 'wo', 'do', 'vr', 'za'],
  NARROWWEEKDAYS: ['Z', 'M', 'D', 'W', 'D', 'V', 'Z'],
  STANDALONENARROWWEEKDAYS: ['Z', 'M', 'D', 'W', 'D', 'V', 'Z'],
  SHORTQUARTERS: ['K1', 'K2', 'K3', 'K4'],
  QUARTERS: ['1e kwartaal', '2e kwartaal', '3e kwartaal', '4e kwartaal'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE d MMMM y', 'd MMMM y', 'd MMM y', 'dd-MM-yy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale nn.
 */
goog.i18n.DateTimeSymbols_nn = {
  ERAS: ['f.Kr.', 'e.Kr.'],
  ERANAMES: ['f.Kr.', 'e.Kr.'],
  NARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['januar', 'februar', 'mars', 'april', 'mai', 'juni', 'juli',
      'august', 'september', 'oktober', 'november', 'desember'],
  STANDALONEMONTHS: ['januar', 'februar', 'mars', 'april', 'mai', 'juni',
      'juli', 'august', 'september', 'oktober', 'november', 'desember'],
  SHORTMONTHS: ['jan', 'feb', 'mar', 'apr', 'mai', 'jun', 'jul', 'aug', 'sep',
      'okt', 'nov', 'des'],
  STANDALONESHORTMONTHS: ['jan', 'feb', 'mar', 'apr', 'mai', 'jun', 'jul',
      'aug', 'sep', 'okt', 'nov', 'des'],
  WEEKDAYS: ['søndag', 'måndag', 'tysdag', 'onsdag', 'torsdag', 'fredag',
      'laurdag'],
  STANDALONEWEEKDAYS: ['søndag', 'måndag', 'tysdag', 'onsdag', 'torsdag',
      'fredag', 'laurdag'],
  SHORTWEEKDAYS: ['sø.', 'må.', 'ty.', 'on.', 'to.', 'fr.', 'la.'],
  STANDALONESHORTWEEKDAYS: ['sø.', 'må.', 'ty.', 'on.', 'to.', 'fr.', 'la.'],
  NARROWWEEKDAYS: ['S', 'M', 'T', 'O', 'T', 'F', 'L'],
  STANDALONENARROWWEEKDAYS: ['S', 'M', 'T', 'O', 'T', 'F', 'L'],
  SHORTQUARTERS: ['K1', 'K2', 'K3', 'K4'],
  QUARTERS: ['1. kvartal', '2. kvartal', '3. kvartal', '4. kvartal'],
  AMPMS: ['formiddag', 'ettermiddag'],
  DATEFORMATS: ['EEEE d. MMMM y', 'd. MMMM y', 'd. MMM. y', 'dd.MM.yy'],
  TIMEFORMATS: ['\'kl\'. HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale nn_NO.
 */
goog.i18n.DateTimeSymbols_nn_NO = goog.i18n.DateTimeSymbols_nn;


/**
 * Date/time formatting symbols for locale nr.
 */
goog.i18n.DateTimeSymbols_nr = {
  ERAS: ['BC', 'AD'],
  ERANAMES: ['BC', 'AD'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['Janabari', 'uFeberbari', 'uMatjhi', 'u-Apreli', 'Meyi', 'Juni',
      'Julayi', 'Arhostosi', 'Septemba', 'Oktoba', 'Usinyikhaba', 'Disemba'],
  STANDALONEMONTHS: ['Janabari', 'uFeberbari', 'uMatjhi', 'u-Apreli', 'Meyi',
      'Juni', 'Julayi', 'Arhostosi', 'Septemba', 'Oktoba', 'Usinyikhaba',
      'Disemba'],
  SHORTMONTHS: ['Jan', 'Feb', 'Mat', 'Apr', 'Mey', 'Jun', 'Jul', 'Arh', 'Sep',
      'Okt', 'Usi', 'Dis'],
  STANDALONESHORTMONTHS: ['Jan', 'Feb', 'Mat', 'Apr', 'Mey', 'Jun', 'Jul',
      'Arh', 'Sep', 'Okt', 'Usi', 'Dis'],
  WEEKDAYS: ['uSonto', 'uMvulo', 'uLesibili', 'Lesithathu', 'uLesine',
      'ngoLesihlanu', 'umGqibelo'],
  STANDALONEWEEKDAYS: ['uSonto', 'uMvulo', 'uLesibili', 'Lesithathu', 'uLesine',
      'ngoLesihlanu', 'umGqibelo'],
  SHORTWEEKDAYS: ['Son', 'Mvu', 'Bil', 'Tha', 'Ne', 'Hla', 'Gqi'],
  STANDALONESHORTWEEKDAYS: ['Son', 'Mvu', 'Bil', 'Tha', 'Ne', 'Hla', 'Gqi'],
  NARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONENARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, y MMMM dd', 'y MMMM d', 'y MMM d', 'yyyy-MM-dd'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale nr_ZA.
 */
goog.i18n.DateTimeSymbols_nr_ZA = goog.i18n.DateTimeSymbols_nr;


/**
 * Date/time formatting symbols for locale nso.
 */
goog.i18n.DateTimeSymbols_nso = {
  ERAS: ['BCE', 'CE'],
  ERANAMES: ['BCE', 'CE'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['Janaware', 'Feberware', 'Matšhe', 'Aporele', 'Mei', 'June',
      'Julae', 'Agostose', 'Setemere', 'Oktobore', 'Nofemere', 'Disemere'],
  STANDALONEMONTHS: ['Janaware', 'Feberware', 'Matšhe', 'Aporele', 'Mei',
      'June', 'Julae', 'Agostose', 'Setemere', 'Oktobore', 'Nofemere',
      'Disemere'],
  SHORTMONTHS: ['Jan', 'Feb', 'Mat', 'Apo', 'Mei', 'Jun', 'Jul', 'Ago', 'Set',
      'Okt', 'Nof', 'Dis'],
  STANDALONESHORTMONTHS: ['Jan', 'Feb', 'Mat', 'Apo', 'Mei', 'Jun', 'Jul',
      'Ago', 'Set', 'Okt', 'Nof', 'Dis'],
  WEEKDAYS: ['Sontaga', 'Mosupalogo', 'Labobedi', 'Laboraro', 'Labone',
      'Labohlano', 'Mokibelo'],
  STANDALONEWEEKDAYS: ['Sontaga', 'Mosupalogo', 'Labobedi', 'Laboraro',
      'Labone', 'Labohlano', 'Mokibelo'],
  SHORTWEEKDAYS: ['Son', 'Mos', 'Bed', 'Rar', 'Ne', 'Hla', 'Mok'],
  STANDALONESHORTWEEKDAYS: ['Son', 'Mos', 'Bed', 'Rar', 'Ne', 'Hla', 'Mok'],
  NARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONENARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, y MMMM dd', 'y MMMM d', 'y MMM d', 'yyyy-MM-dd'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale nso_ZA.
 */
goog.i18n.DateTimeSymbols_nso_ZA = goog.i18n.DateTimeSymbols_nso;


/**
 * Date/time formatting symbols for locale ny.
 */
goog.i18n.DateTimeSymbols_ny = {
  ERAS: ['BCE', 'CE'],
  ERANAMES: ['BCE', 'CE'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['Januwale', 'Febuluwale', 'Malichi', 'Epulo', 'Mei', 'Juni', 'Julai',
      'Ogasiti', 'Seputemba', 'Okutoba', 'Novemba', 'Disemba'],
  STANDALONEMONTHS: ['Januwale', 'Febuluwale', 'Malichi', 'Epulo', 'Mei',
      'Juni', 'Julai', 'Ogasiti', 'Seputemba', 'Okutoba', 'Novemba', 'Disemba'],
  SHORTMONTHS: ['Jan', 'Feb', 'Mal', 'Epu', 'Mei', 'Jun', 'Jul', 'Oga', 'Sep',
      'Oku', 'Nov', 'Dis'],
  STANDALONESHORTMONTHS: ['Jan', 'Feb', 'Mal', 'Epu', 'Mei', 'Jun', 'Jul',
      'Oga', 'Sep', 'Oku', 'Nov', 'Dis'],
  WEEKDAYS: ['Lamulungu', 'Lolemba', 'Lachiwiri', 'Lachitatu', 'Lachinayi',
      'Lachisanu', 'Loweruka'],
  STANDALONEWEEKDAYS: ['Lamulungu', 'Lolemba', 'Lachiwiri', 'Lachitatu',
      'Lachinayi', 'Lachisanu', 'Loweruka'],
  SHORTWEEKDAYS: ['Mul', 'Lem', 'Wir', 'Tat', 'Nai', 'San', 'Wer'],
  STANDALONESHORTWEEKDAYS: ['Mul', 'Lem', 'Wir', 'Tat', 'Nai', 'San', 'Wer'],
  NARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONENARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, y MMMM dd', 'y MMMM d', 'y MMM d', 'yyyy-MM-dd'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale ny_MW.
 */
goog.i18n.DateTimeSymbols_ny_MW = goog.i18n.DateTimeSymbols_ny;


/**
 * Date/time formatting symbols for locale oc.
 */
goog.i18n.DateTimeSymbols_oc = {
  ERAS: ['BCE', 'CE'],
  ERANAMES: ['BCE', 'CE'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['genièr', 'febrièr', 'març', 'abril', 'mai', 'junh', 'julhet',
      'agost', 'setembre', 'octòbre', 'novembre', 'dezembre'],
  STANDALONEMONTHS: ['genièr', 'febrièr', 'març', 'abril', 'mai', 'junh',
      'julhet', 'agost', 'setembre', 'octòbre', 'novembre', 'dezembre'],
  SHORTMONTHS: ['genièr', 'febrièr', 'març', 'abril', 'mai', 'junh',
      'julhet', 'agost', 'setembre', 'octòbre', 'novembre', 'dezembre'],
  STANDALONESHORTMONTHS: ['genièr', 'febrièr', 'març', 'abril', 'mai',
      'junh', 'julhet', 'agost', 'setembre', 'octòbre', 'novembre',
      'dezembre'],
  WEEKDAYS: ['Dimenge', 'diluns', 'dimarç', 'dimècres', 'dijòus',
      'divèndres', 'dissabte'],
  STANDALONEWEEKDAYS: ['Dimenge', 'diluns', 'dimarç', 'dimècres', 'dijòus',
      'divèndres', 'dissabte'],
  SHORTWEEKDAYS: ['Dimenge', 'diluns', 'dimarç', 'dimècres', 'dijòus',
      'divèndres', 'dissabte'],
  STANDALONESHORTWEEKDAYS: ['Dimenge', 'diluns', 'dimarç', 'dimècres',
      'dijòus', 'divèndres', 'dissabte'],
  NARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONENARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, y MMMM dd', 'y MMMM d', 'y MMM d', 'yyyy-MM-dd'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale oc_FR.
 */
goog.i18n.DateTimeSymbols_oc_FR = goog.i18n.DateTimeSymbols_oc;


/**
 * Date/time formatting symbols for locale om.
 */
goog.i18n.DateTimeSymbols_om = {
  ERAS: ['KD', 'KB'],
  ERANAMES: ['KD', 'KB'],
  NARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['Amajjii', 'Guraandhala', 'Bitooteessa', 'Elba', 'Caamsa',
      'Waxabajjii', 'Adooleessa', 'Hagayya', 'Fuulbana', 'Onkololeessa',
      'Sadaasa', 'Muddee'],
  STANDALONEMONTHS: ['Amajjii', 'Guraandhala', 'Bitooteessa', 'Elba', 'Caamsa',
      'Waxabajjii', 'Adooleessa', 'Hagayya', 'Fuulbana', 'Onkololeessa',
      'Sadaasa', 'Muddee'],
  SHORTMONTHS: ['Ama', 'Gur', 'Bit', 'Elb', 'Cam', 'Wax', 'Ado', 'Hag', 'Ful',
      'Onk', 'Sad', 'Mud'],
  STANDALONESHORTMONTHS: ['Ama', 'Gur', 'Bit', 'Elb', 'Cam', 'Wax', 'Ado',
      'Hag', 'Ful', 'Onk', 'Sad', 'Mud'],
  WEEKDAYS: ['Dilbata', 'Wiixata', 'Qibxata', 'Roobii', 'Kamiisa', 'Jimaata',
      'Sanbata'],
  STANDALONEWEEKDAYS: ['Dilbata', 'Wiixata', 'Qibxata', 'Roobii', 'Kamiisa',
      'Jimaata', 'Sanbata'],
  SHORTWEEKDAYS: ['Dil', 'Wix', 'Qib', 'Rob', 'Kam', 'Jim', 'San'],
  STANDALONESHORTWEEKDAYS: ['Dil', 'Wix', 'Qib', 'Rob', 'Kam', 'Jim', 'San'],
  NARROWWEEKDAYS: ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
  STANDALONENARROWWEEKDAYS: ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['WD', 'WB'],
  DATEFORMATS: ['EEEE, MMMM d, y', 'dd MMMM y', 'dd-MMM-y', 'dd/MM/yy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale om_ET.
 */
goog.i18n.DateTimeSymbols_om_ET = goog.i18n.DateTimeSymbols_om;


/**
 * Date/time formatting symbols for locale om_KE.
 */
goog.i18n.DateTimeSymbols_om_KE = goog.i18n.DateTimeSymbols_om;


/**
 * Date/time formatting symbols for locale or_IN.
 */
goog.i18n.DateTimeSymbols_or_IN = {
  ERAS: ['BCE', 'CE'],
  ERANAMES: ['BCE', 'CE'],
  NARROWMONTHS: ['ଜା', 'ଫେ', 'ମା', 'ଅ', 'ମେ', 'ଜୁ',
      'ଜୁ', 'ଅ', 'ସେ', 'ଅ', 'ନ', 'ଡି'],
  STANDALONENARROWMONTHS: ['ଜା', 'ଫେ', 'ମା', 'ଅ', 'ମେ',
      'ଜୁ', 'ଜୁ', 'ଅ', 'ସେ', 'ଅ', 'ନ', 'ଡି'],
  MONTHS: ['ଜାନୁଆରୀ', 'ଫେବ୍ରୁୟାରୀ',
      'ମାର୍ଚ୍ଚ', 'ଅପ୍ରେଲ', 'ମେ', 'ଜୁନ',
      'ଜୁଲାଇ', 'ଅଗଷ୍ଟ', 'ସେପ୍ଟେମ୍ବର',
      'ଅକ୍ଟୋବର', 'ନଭେମ୍ବର',
      'ଡିସେମ୍ବର'],
  STANDALONEMONTHS: ['ଜାନୁଆରୀ', 'ଫେବ୍ରୁୟାରୀ',
      'ମାର୍ଚ୍ଚ', 'ଅପ୍ରେଲ', 'ମେ', 'ଜୁନ',
      'ଜୁଲାଇ', 'ଅଗଷ୍ଟ', 'ସେପ୍ଟେମ୍ବର',
      'ଅକ୍ଟୋବର', 'ନଭେମ୍ବର',
      'ଡିସେମ୍ବର'],
  SHORTMONTHS: ['ଜାନୁଆରୀ', 'ଫେବ୍ରୁୟାରୀ',
      'ମାର୍ଚ୍ଚ', 'ଅପ୍ରେଲ', 'ମେ', 'ଜୁନ',
      'ଜୁଲାଇ', 'ଅଗଷ୍ଟ', 'ସେପ୍ଟେମ୍ବର',
      'ଅକ୍ଟୋବର', 'ନଭେମ୍ବର',
      'ଡିସେମ୍ବର'],
  STANDALONESHORTMONTHS: ['ଜାନୁଆରୀ',
      'ଫେବ୍ରୁୟାରୀ', 'ମାର୍ଚ୍ଚ',
      'ଅପ୍ରେଲ', 'ମେ', 'ଜୁନ', 'ଜୁଲାଇ',
      'ଅଗଷ୍ଟ', 'ସେପ୍ଟେମ୍ବର',
      'ଅକ୍ଟୋବର', 'ନଭେମ୍ବର',
      'ଡିସେମ୍ବର'],
  WEEKDAYS: ['ରବିବାର', 'ସୋମବାର',
      'ମଙ୍ଗଳବାର', 'ବୁଧବାର', 'ଗୁରୁବାର',
      'ଶୁକ୍ରବାର', 'ଶନିବାର'],
  STANDALONEWEEKDAYS: ['ରବିବାର', 'ସୋମବାର',
      'ମଙ୍ଗଳବାର', 'ବୁଧବାର', 'ଗୁରୁବାର',
      'ଶୁକ୍ରବାର', 'ଶନିବାର'],
  SHORTWEEKDAYS: ['ରବି', 'ସୋମ', 'ମଙ୍ଗଳ', 'ବୁଧ',
      'ଗୁରୁ', 'ଶୁକ୍ର', 'ଶନି'],
  STANDALONESHORTWEEKDAYS: ['ରବି', 'ସୋମ', 'ମଙ୍ଗଳ',
      'ବୁଧ', 'ଗୁରୁ', 'ଶୁକ୍ର', 'ଶନି'],
  NARROWWEEKDAYS: ['ର', 'ସୋ', 'ମ', 'ବୁ', 'ଗୁ', 'ଶୁ', 'ଶ'],
  STANDALONENARROWWEEKDAYS: ['ର', 'ସୋ', 'ମ', 'ବୁ', 'ଗୁ',
      'ଶୁ', 'ଶ'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['am', 'pm'],
  DATEFORMATS: ['EEEE, d MMMM y', 'd MMMM y', 'd MMM y', 'd-M-yy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [6, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale pa.
 */
goog.i18n.DateTimeSymbols_pa = {
  ERAS: ['ਈਸਾਪੂਰਵ', 'ਸੰਨ'],
  ERANAMES: ['ਈਸਾਪੂਰਵ', 'ਸੰਨ'],
  NARROWMONTHS: ['ਜ', 'ਫ', 'ਮਾ', 'ਅ', 'ਮ', 'ਜੂ', 'ਜੁ',
      'ਅ', 'ਸ', 'ਅ', 'ਨ', 'ਦ'],
  STANDALONENARROWMONTHS: ['ਜ', 'ਫ', 'ਮਾ', 'ਅ', 'ਮ', 'ਜੂ',
      'ਜੁ', 'ਅ', 'ਸ', 'ਅ', 'ਨ', 'ਦ'],
  MONTHS: ['ਜਨਵਰੀ', 'ਫ਼ਰਵਰੀ', 'ਮਾਰਚ',
      'ਅਪ੍ਰੈਲ', 'ਮਈ', 'ਜੂਨ', 'ਜੁਲਾਈ',
      'ਅਗਸਤ', 'ਸਤੰਬਰ', 'ਅਕਤੂਬਰ',
      'ਨਵੰਬਰ', 'ਦਸੰਬਰ'],
  STANDALONEMONTHS: ['ਜਨਵਰੀ', 'ਫ਼ਰਵਰੀ', 'ਮਾਰਚ',
      'ਅਪ੍ਰੈਲ', 'ਮਈ', 'ਜੂਨ', 'ਜੁਲਾਈ',
      'ਅਗਸਤ', 'ਸਤੰਬਰ', 'ਅਕਤੂਬਰ',
      'ਨਵੰਬਰ', 'ਦਸੰਬਰ'],
  SHORTMONTHS: ['ਜਨਵਰੀ', 'ਫ਼ਰਵਰੀ', 'ਮਾਰਚ',
      'ਅਪ੍ਰੈਲ', 'ਮਈ', 'ਜੂਨ', 'ਜੁਲਾਈ',
      'ਅਗਸਤ', 'ਸਤੰਬਰ', 'ਅਕਤੂਬਰ',
      'ਨਵੰਬਰ', 'ਦਸੰਬਰ'],
  STANDALONESHORTMONTHS: ['ਜਨਵਰੀ', 'ਫ਼ਰਵਰੀ',
      'ਮਾਰਚ', 'ਅਪ੍ਰੈਲ', 'ਮਈ', 'ਜੂਨ',
      'ਜੁਲਾਈ', 'ਅਗਸਤ', 'ਸਤੰਬਰ',
      'ਅਕਤੂਬਰ', 'ਨਵੰਬਰ', 'ਦਸੰਬਰ'],
  WEEKDAYS: ['ਐਤਵਾਰ', 'ਸੋਮਵਾਰ', 'ਮੰਗਲਵਾਰ',
      'ਬੁਧਵਾਰ', 'ਵੀਰਵਾਰ', 'ਸ਼ੁੱਕਰਵਾਰ',
      'ਸ਼ਨੀਚਰਵਾਰ'],
  STANDALONEWEEKDAYS: ['ਐਤਵਾਰ', 'ਸੋਮਵਾਰ',
      'ਮੰਗਲਵਾਰ', 'ਬੁਧਵਾਰ', 'ਵੀਰਵਾਰ',
      'ਸ਼ੁੱਕਰਵਾਰ', 'ਸ਼ਨੀਚਰਵਾਰ'],
  SHORTWEEKDAYS: ['ਐਤ.', 'ਸੋਮ.', 'ਮੰਗਲ.', 'ਬੁਧ.',
      'ਵੀਰ.', 'ਸ਼ੁਕਰ.', 'ਸ਼ਨੀ.'],
  STANDALONESHORTWEEKDAYS: ['ਐਤ.', 'ਸੋਮ.', 'ਮੰਗਲ.',
      'ਬੁਧ.', 'ਵੀਰ.', 'ਸ਼ੁਕਰ.', 'ਸ਼ਨੀ.'],
  NARROWWEEKDAYS: ['ਐ', 'ਸੋ', 'ਮੰ', 'ਬੁੱ', 'ਵੀ',
      'ਸ਼ੁੱ', 'ਸ਼'],
  STANDALONENARROWWEEKDAYS: ['ਐ', 'ਸੋ', 'ਮੰ', 'ਬੁੱ', 'ਵੀ',
      'ਸ਼ੁੱ', 'ਸ਼'],
  SHORTQUARTERS: ['ਪਹਿਲਾਂ ਚੌਥਾਈ',
      'ਦੂਜਾ ਚੌਥਾਈ', 'ਤੀਜਾ ਚੌਥਾਈ',
      'ਚੌਥਾ ਚੌਥਾਈ'],
  QUARTERS: ['ਪਹਿਲਾਂ ਚੌਥਾਈ',
      'ਦੂਜਾ ਚੌਥਾਈ', 'ਤੀਜਾ ਚੌਥਾਈ',
      'ਚੌਥਾ ਚੌਥਾਈ'],
  AMPMS: ['ਸਵੇਰੇ', 'ਸ਼ਾਮ'],
  DATEFORMATS: ['EEEE, dd MMMM y', 'd MMMM y', 'd MMM y', 'dd/MM/yyyy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [6, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale pa_Arab.
 */
goog.i18n.DateTimeSymbols_pa_Arab = {
  ERAS: ['ਈਸਾਪੂਰਵ', 'ਸੰਨ'],
  ERANAMES: ['ايساپورو', 'سں'],
  NARROWMONTHS: ['ਜ', 'ਫ', 'ਮਾ', 'ਅ', 'ਮ', 'ਜੂ', 'ਜੁ',
      'ਅ', 'ਸ', 'ਅ', 'ਨ', 'ਦ'],
  STANDALONENARROWMONTHS: ['ਜ', 'ਫ', 'ਮਾ', 'ਅ', 'ਮ', 'ਜੂ',
      'ਜੁ', 'ਅ', 'ਸ', 'ਅ', 'ਨ', 'ਦ'],
  MONTHS: ['جنوری', 'فروری', 'مارچ', 'اپریل', 'مئ',
      'جون', 'جولائی', 'اگست', 'ستمبر', 'اکتوبر',
      'نومبر', 'دسمبر'],
  STANDALONEMONTHS: ['جنوری', 'فروری', 'مارچ', 'اپریل',
      'مئ', 'جون', 'جولائی', 'اگست', 'ستمبر',
      'اکتوبر', 'نومبر', 'دسمبر'],
  SHORTMONTHS: ['جنوری', 'فروری', 'مارچ', 'اپریل', 'مئ',
      'جون', 'جولائی', 'اگست', 'ستمبر', 'اکتوبر',
      'نومبر', 'دسمبر'],
  STANDALONESHORTMONTHS: ['جنوری', 'فروری', 'مارچ', 'اپریل',
      'مئ', 'جون', 'جولائی', 'اگست', 'ستمبر',
      'اکتوبر', 'نومبر', 'دسمبر'],
  WEEKDAYS: ['اتوار', 'پیر', 'منگل', 'بُدھ', 'جمعرات',
      'جمعہ', 'ہفتہ'],
  STANDALONEWEEKDAYS: ['اتوار', 'پیر', 'منگل', 'بُدھ',
      'جمعرات', 'جمعہ', 'ہفتہ'],
  SHORTWEEKDAYS: ['ਐਤ.', 'ਸੋਮ.', 'ਮੰਗਲ.', 'ਬੁਧ.',
      'ਵੀਰ.', 'ਸ਼ੁਕਰ.', 'ਸ਼ਨੀ.'],
  STANDALONESHORTWEEKDAYS: ['ਐਤ.', 'ਸੋਮ.', 'ਮੰਗਲ.',
      'ਬੁਧ.', 'ਵੀਰ.', 'ਸ਼ੁਕਰ.', 'ਸ਼ਨੀ.'],
  NARROWWEEKDAYS: ['ਐ', 'ਸੋ', 'ਮੰ', 'ਬੁੱ', 'ਵੀ',
      'ਸ਼ੁੱ', 'ਸ਼'],
  STANDALONENARROWWEEKDAYS: ['ਐ', 'ਸੋ', 'ਮੰ', 'ਬੁੱ', 'ਵੀ',
      'ਸ਼ੁੱ', 'ਸ਼'],
  SHORTQUARTERS: ['چوتھاي پہلاں', 'چوتھاي دوجا',
      'چوتھاي تيجا', 'چوتھاي چوتھا'],
  QUARTERS: ['چوتھاي پہلاں', 'چوتھاي دوجا',
      'چوتھاي تيجا', 'چوتھاي چوتھا'],
  AMPMS: ['ਸਵੇਰੇ', 'ਸ਼ਾਮ'],
  DATEFORMATS: ['EEEE, dd MMMM y', 'd MMMM y', 'd MMM y', 'dd/MM/yyyy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale pa_Arab_PK.
 */
goog.i18n.DateTimeSymbols_pa_Arab_PK = goog.i18n.DateTimeSymbols_pa_Arab;


/**
 * Date/time formatting symbols for locale pa_Guru.
 */
goog.i18n.DateTimeSymbols_pa_Guru = goog.i18n.DateTimeSymbols_pa;


/**
 * Date/time formatting symbols for locale pa_Guru_IN.
 */
goog.i18n.DateTimeSymbols_pa_Guru_IN = goog.i18n.DateTimeSymbols_pa;


/**
 * Date/time formatting symbols for locale pa_IN.
 */
goog.i18n.DateTimeSymbols_pa_IN = goog.i18n.DateTimeSymbols_pa;


/**
 * Date/time formatting symbols for locale pa_PK.
 */
goog.i18n.DateTimeSymbols_pa_PK = {
  ERAS: ['ਈਸਾਪੂਰਵ', 'ਸੰਨ'],
  ERANAMES: ['ايساپورو', 'سں'],
  NARROWMONTHS: ['ਜ', 'ਫ', 'ਮਾ', 'ਅ', 'ਮ', 'ਜੂ', 'ਜੁ',
      'ਅ', 'ਸ', 'ਅ', 'ਨ', 'ਦ'],
  STANDALONENARROWMONTHS: ['ਜ', 'ਫ', 'ਮਾ', 'ਅ', 'ਮ', 'ਜੂ',
      'ਜੁ', 'ਅ', 'ਸ', 'ਅ', 'ਨ', 'ਦ'],
  MONTHS: ['جنوری', 'فروری', 'مارچ', 'اپریل', 'مئ',
      'جون', 'جولائی', 'اگست', 'ستمبر', 'اکتوبر',
      'نومبر', 'دسمبر'],
  STANDALONEMONTHS: ['جنوری', 'فروری', 'مارچ', 'اپریل',
      'مئ', 'جون', 'جولائی', 'اگست', 'ستمبر',
      'اکتوبر', 'نومبر', 'دسمبر'],
  SHORTMONTHS: ['جنوری', 'فروری', 'مارچ', 'اپریل', 'مئ',
      'جون', 'جولائی', 'اگست', 'ستمبر', 'اکتوبر',
      'نومبر', 'دسمبر'],
  STANDALONESHORTMONTHS: ['جنوری', 'فروری', 'مارچ', 'اپریل',
      'مئ', 'جون', 'جولائی', 'اگست', 'ستمبر',
      'اکتوبر', 'نومبر', 'دسمبر'],
  WEEKDAYS: ['اتوار', 'پیر', 'منگل', 'بُدھ', 'جمعرات',
      'جمعہ', 'ہفتہ'],
  STANDALONEWEEKDAYS: ['اتوار', 'پیر', 'منگل', 'بُدھ',
      'جمعرات', 'جمعہ', 'ہفتہ'],
  SHORTWEEKDAYS: ['ਐਤ.', 'ਸੋਮ.', 'ਮੰਗਲ.', 'ਬੁਧ.',
      'ਵੀਰ.', 'ਸ਼ੁਕਰ.', 'ਸ਼ਨੀ.'],
  STANDALONESHORTWEEKDAYS: ['ਐਤ.', 'ਸੋਮ.', 'ਮੰਗਲ.',
      'ਬੁਧ.', 'ਵੀਰ.', 'ਸ਼ੁਕਰ.', 'ਸ਼ਨੀ.'],
  NARROWWEEKDAYS: ['ਐ', 'ਸੋ', 'ਮੰ', 'ਬੁੱ', 'ਵੀ',
      'ਸ਼ੁੱ', 'ਸ਼'],
  STANDALONENARROWWEEKDAYS: ['ਐ', 'ਸੋ', 'ਮੰ', 'ਬੁੱ', 'ਵੀ',
      'ਸ਼ੁੱ', 'ਸ਼'],
  SHORTQUARTERS: ['چوتھاي پہلاں', 'چوتھاي دوجا',
      'چوتھاي تيجا', 'چوتھاي چوتھا'],
  QUARTERS: ['چوتھاي پہلاں', 'چوتھاي دوجا',
      'چوتھاي تيجا', 'چوتھاي چوتھا'],
  AMPMS: ['ਸਵੇਰੇ', 'ਸ਼ਾਮ'],
  DATEFORMATS: ['EEEE, dd MMMM y', 'd MMMM y', 'd MMM y', 'dd/MM/yyyy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale pl_PL.
 */
goog.i18n.DateTimeSymbols_pl_PL = {
  ERAS: ['p.n.e.', 'n.e.'],
  ERANAMES: ['p.n.e.', 'n.e.'],
  NARROWMONTHS: ['s', 'l', 'm', 'k', 'm', 'c', 'l', 's', 'w', 'p', 'l', 'g'],
  STANDALONENARROWMONTHS: ['s', 'l', 'm', 'k', 'm', 'c', 'l', 's', 'w', 'p',
      'l', 'g'],
  MONTHS: ['stycznia', 'lutego', 'marca', 'kwietnia', 'maja', 'czerwca',
      'lipca', 'sierpnia', 'września', 'października', 'listopada',
      'grudnia'],
  STANDALONEMONTHS: ['styczeń', 'luty', 'marzec', 'kwiecień', 'maj',
      'czerwiec', 'lipiec', 'sierpień', 'wrzesień', 'październik',
      'listopad', 'grudzień'],
  SHORTMONTHS: ['sty', 'lut', 'mar', 'kwi', 'maj', 'cze', 'lip', 'sie', 'wrz',
      'paź', 'lis', 'gru'],
  STANDALONESHORTMONTHS: ['sty', 'lut', 'mar', 'kwi', 'maj', 'cze', 'lip',
      'sie', 'wrz', 'paź', 'lis', 'gru'],
  WEEKDAYS: ['niedziela', 'poniedziałek', 'wtorek', 'środa', 'czwartek',
      'piątek', 'sobota'],
  STANDALONEWEEKDAYS: ['niedziela', 'poniedziałek', 'wtorek', 'środa',
      'czwartek', 'piątek', 'sobota'],
  SHORTWEEKDAYS: ['niedz.', 'pon.', 'wt.', 'śr.', 'czw.', 'pt.', 'sob.'],
  STANDALONESHORTWEEKDAYS: ['niedz.', 'pon.', 'wt.', 'śr.', 'czw.', 'pt.',
      'sob.'],
  NARROWWEEKDAYS: ['N', 'P', 'W', 'Ś', 'C', 'P', 'S'],
  STANDALONENARROWWEEKDAYS: ['N', 'P', 'W', 'Ś', 'C', 'P', 'S'],
  SHORTQUARTERS: ['K1', 'K2', 'K3', 'K4'],
  QUARTERS: ['I kwartał', 'II kwartał', 'III kwartał', 'IV kwartał'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, d MMMM y', 'd MMMM y', 'd MMM y', 'dd.MM.yyyy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale ps.
 */
goog.i18n.DateTimeSymbols_ps = {
  ERAS: ['ق.م.', 'م.'],
  ERANAMES: ['ق.م.', 'م.'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['جنوري', 'فبروري', 'مارچ', 'اپریل', 'می',
      'جون', 'جولای', 'اګست', 'سپتمبر', 'اکتوبر',
      'نومبر', 'دسمبر'],
  STANDALONEMONTHS: ['جنوري', 'فبروري', 'مارچ', 'اپریل',
      'می', 'جون', 'جولای', 'اګست', 'سپتمبر',
      'اکتوبر', 'نومبر', 'دسمبر'],
  SHORTMONTHS: ['جنوري', 'فبروري', 'مارچ', 'اپریل', 'می',
      'جون', 'جولای', 'اګست', 'سپتمبر', 'اکتوبر',
      'نومبر', 'دسمبر'],
  STANDALONESHORTMONTHS: ['جنوري', 'فبروري', 'مارچ',
      'اپریل', 'می', 'جون', 'جولای', 'اګست', 'سپتمبر',
      'اکتوبر', 'نومبر', 'دسمبر'],
  WEEKDAYS: ['یکشنبه', 'دوشنبه', 'سه‌شنبه',
      'چهارشنبه', 'پنجشنبه', 'جمعه', 'شنبه'],
  STANDALONEWEEKDAYS: ['یکشنبه', 'دوشنبه', 'سه‌شنبه',
      'چهارشنبه', 'پنجشنبه', 'جمعه', 'شنبه'],
  SHORTWEEKDAYS: ['یکشنبه', 'دوشنبه', 'سه‌شنبه',
      'چهارشنبه', 'پنجشنبه', 'جمعه', 'شنبه'],
  STANDALONESHORTWEEKDAYS: ['یکشنبه', 'دوشنبه', 'سه‌شنبه',
      'چهارشنبه', 'پنجشنبه', 'جمعه', 'شنبه'],
  NARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONENARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['غ.م.', 'غ.و.'],
  DATEFORMATS: ['EEEE د y د MMMM d', 'د y د MMMM d', 'd MMM y', 'yyyy/M/d'],
  TIMEFORMATS: ['H:mm:ss (zzzz)', 'H:mm:ss (z)', 'H:mm:ss', 'H:mm'],
  FIRSTDAYOFWEEK: 5,
  WEEKENDRANGE: [3, 4],
  FIRSTWEEKCUTOFFDAY: 1
};


/**
 * Date/time formatting symbols for locale ps_AF.
 */
goog.i18n.DateTimeSymbols_ps_AF = goog.i18n.DateTimeSymbols_ps;


/**
 * Date/time formatting symbols for locale ro_MD.
 */
goog.i18n.DateTimeSymbols_ro_MD = {
  ERAS: ['î.Hr.', 'd.Hr.'],
  ERANAMES: ['înainte de Hristos', 'după Hristos'],
  NARROWMONTHS: ['I', 'F', 'M', 'A', 'M', 'I', 'I', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['I', 'F', 'M', 'A', 'M', 'I', 'I', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['ianuarie', 'februarie', 'martie', 'aprilie', 'mai', 'iunie',
      'iulie', 'august', 'septembrie', 'octombrie', 'noiembrie', 'decembrie'],
  STANDALONEMONTHS: ['ianuarie', 'februarie', 'martie', 'aprilie', 'mai',
      'iunie', 'iulie', 'august', 'septembrie', 'octombrie', 'noiembrie',
      'decembrie'],
  SHORTMONTHS: ['ian.', 'feb.', 'mar.', 'apr.', 'mai', 'iun.', 'iul.', 'aug.',
      'sept.', 'oct.', 'nov.', 'dec.'],
  STANDALONESHORTMONTHS: ['ian.', 'feb.', 'mar.', 'apr.', 'mai', 'iun.', 'iul.',
      'aug.', 'sept.', 'oct.', 'nov.', 'dec.'],
  WEEKDAYS: ['duminică', 'luni', 'marți', 'miercuri', 'joi', 'vineri',
      'sâmbătă'],
  STANDALONEWEEKDAYS: ['duminică', 'luni', 'marți', 'miercuri', 'joi',
      'vineri', 'sâmbătă'],
  SHORTWEEKDAYS: ['Du', 'Lu', 'Ma', 'Mi', 'Jo', 'Vi', 'Sâ'],
  STANDALONESHORTWEEKDAYS: ['Du', 'Lu', 'Ma', 'Mi', 'Jo', 'Vi', 'Sâ'],
  NARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  STANDALONENARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  SHORTQUARTERS: ['trim. I', 'trim. II', 'trim. III', 'trim. IV'],
  QUARTERS: ['trimestrul I', 'trimestrul al II-lea', 'trimestrul al III-lea',
      'trimestrul al IV-lea'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, d MMMM y', 'd MMMM y', 'dd.MM.yyyy', 'dd.MM.yyyy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale ro_RO.
 */
goog.i18n.DateTimeSymbols_ro_RO = {
  ERAS: ['î.Hr.', 'd.Hr.'],
  ERANAMES: ['înainte de Hristos', 'după Hristos'],
  NARROWMONTHS: ['I', 'F', 'M', 'A', 'M', 'I', 'I', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['I', 'F', 'M', 'A', 'M', 'I', 'I', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['ianuarie', 'februarie', 'martie', 'aprilie', 'mai', 'iunie',
      'iulie', 'august', 'septembrie', 'octombrie', 'noiembrie', 'decembrie'],
  STANDALONEMONTHS: ['ianuarie', 'februarie', 'martie', 'aprilie', 'mai',
      'iunie', 'iulie', 'august', 'septembrie', 'octombrie', 'noiembrie',
      'decembrie'],
  SHORTMONTHS: ['ian.', 'feb.', 'mar.', 'apr.', 'mai', 'iun.', 'iul.', 'aug.',
      'sept.', 'oct.', 'nov.', 'dec.'],
  STANDALONESHORTMONTHS: ['ian.', 'feb.', 'mar.', 'apr.', 'mai', 'iun.', 'iul.',
      'aug.', 'sept.', 'oct.', 'nov.', 'dec.'],
  WEEKDAYS: ['duminică', 'luni', 'marți', 'miercuri', 'joi', 'vineri',
      'sâmbătă'],
  STANDALONEWEEKDAYS: ['duminică', 'luni', 'marți', 'miercuri', 'joi',
      'vineri', 'sâmbătă'],
  SHORTWEEKDAYS: ['Du', 'Lu', 'Ma', 'Mi', 'Jo', 'Vi', 'Sâ'],
  STANDALONESHORTWEEKDAYS: ['Du', 'Lu', 'Ma', 'Mi', 'Jo', 'Vi', 'Sâ'],
  NARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  STANDALONENARROWWEEKDAYS: ['D', 'L', 'M', 'M', 'J', 'V', 'S'],
  SHORTQUARTERS: ['trim. I', 'trim. II', 'trim. III', 'trim. IV'],
  QUARTERS: ['trimestrul I', 'trimestrul al II-lea', 'trimestrul al III-lea',
      'trimestrul al IV-lea'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, d MMMM y', 'd MMMM y', 'dd.MM.yyyy', 'dd.MM.yyyy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale ru_RU.
 */
goog.i18n.DateTimeSymbols_ru_RU = {
  ERAS: ['до н.э.', 'н.э.'],
  ERANAMES: ['до н.э.', 'н.э.'],
  NARROWMONTHS: ['Я', 'Ф', 'М', 'А', 'М', 'И', 'И', 'А', 'С', 'О',
      'Н', 'Д'],
  STANDALONENARROWMONTHS: ['Я', 'Ф', 'М', 'А', 'М', 'И', 'И', 'А', 'С',
      'О', 'Н', 'Д'],
  MONTHS: ['января', 'февраля', 'марта', 'апреля',
      'мая', 'июня', 'июля', 'августа', 'сентября',
      'октября', 'ноября', 'декабря'],
  STANDALONEMONTHS: ['Январь', 'Февраль', 'Март',
      'Апрель', 'Май', 'Июнь', 'Июль', 'Август',
      'Сентябрь', 'Октябрь', 'Ноябрь', 'Декабрь'],
  SHORTMONTHS: ['янв.', 'февр.', 'марта', 'апр.', 'мая',
      'июня', 'июля', 'авг.', 'сент.', 'окт.', 'нояб.',
      'дек.'],
  STANDALONESHORTMONTHS: ['янв.', 'февр.', 'март', 'апр.',
      'май', 'июнь', 'июль', 'авг.', 'сент.', 'окт.',
      'нояб.', 'дек.'],
  WEEKDAYS: ['воскресенье', 'понедельник',
      'вторник', 'среда', 'четверг', 'пятница',
      'суббота'],
  STANDALONEWEEKDAYS: ['Воскресенье', 'Понедельник',
      'Вторник', 'Среда', 'Четверг', 'Пятница',
      'Суббота'],
  SHORTWEEKDAYS: ['вс', 'пн', 'вт', 'ср', 'чт', 'пт', 'сб'],
  STANDALONESHORTWEEKDAYS: ['Вс', 'Пн', 'Вт', 'Ср', 'Чт', 'Пт',
      'Сб'],
  NARROWWEEKDAYS: ['В', 'П', 'В', 'С', 'Ч', 'П', 'С'],
  STANDALONENARROWWEEKDAYS: ['В', 'П', 'В', 'С', 'Ч', 'П', 'С'],
  SHORTQUARTERS: ['1-й кв.', '2-й кв.', '3-й кв.', '4-й кв.'],
  QUARTERS: ['1-й квартал', '2-й квартал',
      '3-й квартал', '4-й квартал'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, d MMMM y \'г\'.', 'd MMMM y \'г\'.', 'dd.MM.yyyy',
      'dd.MM.yy'],
  TIMEFORMATS: ['H:mm:ss zzzz', 'H:mm:ss z', 'H:mm:ss', 'H:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale ru_UA.
 */
goog.i18n.DateTimeSymbols_ru_UA = {
  ERAS: ['до н.э.', 'н.э.'],
  ERANAMES: ['до н.э.', 'н.э.'],
  NARROWMONTHS: ['Я', 'Ф', 'М', 'А', 'М', 'И', 'И', 'А', 'С', 'О',
      'Н', 'Д'],
  STANDALONENARROWMONTHS: ['Я', 'Ф', 'М', 'А', 'М', 'И', 'И', 'А', 'С',
      'О', 'Н', 'Д'],
  MONTHS: ['января', 'февраля', 'марта', 'апреля',
      'мая', 'июня', 'июля', 'августа', 'сентября',
      'октября', 'ноября', 'декабря'],
  STANDALONEMONTHS: ['Январь', 'Февраль', 'Март',
      'Апрель', 'Май', 'Июнь', 'Июль', 'Август',
      'Сентябрь', 'Октябрь', 'Ноябрь', 'Декабрь'],
  SHORTMONTHS: ['янв.', 'февр.', 'марта', 'апр.', 'мая',
      'июня', 'июля', 'авг.', 'сент.', 'окт.', 'нояб.',
      'дек.'],
  STANDALONESHORTMONTHS: ['янв.', 'февр.', 'март', 'апр.',
      'май', 'июнь', 'июль', 'авг.', 'сент.', 'окт.',
      'нояб.', 'дек.'],
  WEEKDAYS: ['воскресенье', 'понедельник',
      'вторник', 'среда', 'четверг', 'пятница',
      'суббота'],
  STANDALONEWEEKDAYS: ['Воскресенье', 'Понедельник',
      'Вторник', 'Среда', 'Четверг', 'Пятница',
      'Суббота'],
  SHORTWEEKDAYS: ['вс', 'пн', 'вт', 'ср', 'чт', 'пт', 'сб'],
  STANDALONESHORTWEEKDAYS: ['Вс', 'Пн', 'Вт', 'Ср', 'Чт', 'Пт',
      'Сб'],
  NARROWWEEKDAYS: ['В', 'П', 'В', 'С', 'Ч', 'П', 'С'],
  STANDALONENARROWWEEKDAYS: ['В', 'П', 'В', 'С', 'Ч', 'П', 'С'],
  SHORTQUARTERS: ['1-й кв.', '2-й кв.', '3-й кв.', '4-й кв.'],
  QUARTERS: ['1-й квартал', '2-й квартал',
      '3-й квартал', '4-й квартал'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, d MMMM y \'г\'.', 'd MMMM y', 'd MMM y', 'dd.MM.yy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale rw.
 */
goog.i18n.DateTimeSymbols_rw = {
  ERAS: ['BCE', 'CE'],
  ERANAMES: ['BCE', 'CE'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['Mutarama', 'Gashyantare', 'Werurwe', 'Mata', 'Gicuransi', 'Kamena',
      'Nyakanga', 'Kanama', 'Nzeli', 'Ukwakira', 'Ugushyingo', 'Ukuboza'],
  STANDALONEMONTHS: ['Mutarama', 'Gashyantare', 'Werurwe', 'Mata', 'Gicuransi',
      'Kamena', 'Nyakanga', 'Kanama', 'Nzeli', 'Ukwakira', 'Ugushyingo',
      'Ukuboza'],
  SHORTMONTHS: ['mut.', 'gas.', 'wer.', 'mat.', 'gic.', 'kam.', 'nya.', 'kan.',
      'nze.', 'ukw.', 'ugu.', 'uku.'],
  STANDALONESHORTMONTHS: ['mut.', 'gas.', 'wer.', 'mat.', 'gic.', 'kam.',
      'nya.', 'kan.', 'nze.', 'ukw.', 'ugu.', 'uku.'],
  WEEKDAYS: ['Ku cyumweru', 'Kuwa mbere', 'Kuwa kabiri', 'Kuwa gatatu',
      'Kuwa kane', 'Kuwa gatanu', 'Kuwa gatandatu'],
  STANDALONEWEEKDAYS: ['Ku cyumweru', 'Kuwa mbere', 'Kuwa kabiri',
      'Kuwa gatatu', 'Kuwa kane', 'Kuwa gatanu', 'Kuwa gatandatu'],
  SHORTWEEKDAYS: ['cyu.', 'mbe.', 'kab.', 'gtu.', 'kan.', 'gnu.', 'gnd.'],
  STANDALONESHORTWEEKDAYS: ['cyu.', 'mbe.', 'kab.', 'gtu.', 'kan.', 'gnu.',
      'gnd.'],
  NARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONENARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTQUARTERS: ['I1', 'I2', 'I3', 'I4'],
  QUARTERS: ['igihembwe cya mbere', 'igihembwe cya kabiri',
      'igihembwe cya gatatu', 'igihembwe cya kane'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, y MMMM dd', 'y MMMM d', 'y MMM d', 'yy/MM/dd'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale rw_RW.
 */
goog.i18n.DateTimeSymbols_rw_RW = goog.i18n.DateTimeSymbols_rw;


/**
 * Date/time formatting symbols for locale sa.
 */
goog.i18n.DateTimeSymbols_sa = {
  ERAS: ['BCE', 'CE'],
  ERANAMES: ['BCE', 'CE'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONEMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11',
      '12'],
  SHORTMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONESHORTMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  WEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONEWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONESHORTWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  NARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONENARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE d MMMM y', 'd MMMM y', 'dd-MM-yyyy', 'd-MM-yy'],
  TIMEFORMATS: ['hh:mm:ss a zzzz', 'hh:mm:ss a z', 'hh:mm:ss a', 'hh:mm a'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale sa_IN.
 */
goog.i18n.DateTimeSymbols_sa_IN = goog.i18n.DateTimeSymbols_sa;


/**
 * Date/time formatting symbols for locale se.
 */
goog.i18n.DateTimeSymbols_se = {
  ERAS: ['o.Kr.', 'm.Kr.'],
  ERANAMES: ['ovdal Kristtusa', 'maŋŋel Kristtusa'],
  NARROWMONTHS: ['O', 'G', 'N', 'C', 'M', 'G', 'S', 'B', 'Č', 'G', 'S', 'J'],
  STANDALONENARROWMONTHS: ['O', 'G', 'N', 'C', 'M', 'G', 'S', 'B', 'Č', 'G',
      'S', 'J'],
  MONTHS: ['ođđajagemánnu', 'guovvamánnu', 'njukčamánnu', 'cuoŋománnu',
      'miessemánnu', 'geassemánnu', 'suoidnemánnu', 'borgemánnu',
      'čakčamánnu', 'golggotmánnu', 'skábmamánnu', 'juovlamánnu'],
  STANDALONEMONTHS: ['ođđajagemánnu', 'guovvamánnu', 'njukčamánnu',
      'cuoŋománnu', 'miessemánnu', 'geassemánnu', 'suoidnemánnu',
      'borgemánnu', 'čakčamánnu', 'golggotmánnu', 'skábmamánnu',
      'juovlamánnu'],
  SHORTMONTHS: ['ođđj', 'guov', 'njuk', 'cuo', 'mies', 'geas', 'suoi', 'borg',
      'čakč', 'golg', 'skáb', 'juov'],
  STANDALONESHORTMONTHS: ['ođđj', 'guov', 'njuk', 'cuo', 'mies', 'geas',
      'suoi', 'borg', 'čakč', 'golg', 'skáb', 'juov'],
  WEEKDAYS: ['sotnabeaivi', 'vuossárga', 'maŋŋebárga', 'gaskavahkku',
      'duorasdat', 'bearjadat', 'lávvardat'],
  STANDALONEWEEKDAYS: ['sotnabeaivi', 'vuossárga', 'maŋŋebárga',
      'gaskavahkku', 'duorasdat', 'bearjadat', 'lávvardat'],
  SHORTWEEKDAYS: ['sotn', 'vuos', 'maŋ', 'gask', 'duor', 'bear', 'láv'],
  STANDALONESHORTWEEKDAYS: ['sotn', 'vuos', 'maŋ', 'gask', 'duor', 'bear',
      'láv'],
  NARROWWEEKDAYS: ['S', 'V', 'M', 'G', 'D', 'B', 'L'],
  STANDALONENARROWWEEKDAYS: ['S', 'V', 'M', 'G', 'D', 'B', 'L'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['iđitbeaivet', 'eahketbeaivet'],
  DATEFORMATS: ['EEEE, y MMMM dd', 'y MMMM d', 'y MMM d', 'yyyy-MM-dd'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale se_FI.
 */
goog.i18n.DateTimeSymbols_se_FI = {
  ERAS: ['o.Kr.', 'm.Kr.'],
  ERANAMES: ['ovdal Kristtusa', 'maŋŋel Kristtusa'],
  NARROWMONTHS: ['O', 'G', 'N', 'C', 'M', 'G', 'S', 'B', 'Č', 'G', 'S', 'J'],
  STANDALONENARROWMONTHS: ['O', 'G', 'N', 'C', 'M', 'G', 'S', 'B', 'Č', 'G',
      'S', 'J'],
  MONTHS: ['ođđajagemánnu', 'guovvamánnu', 'njukčamánnu', 'cuoŋománnu',
      'miessemánnu', 'geassemánnu', 'suoidnemánnu', 'borgemánnu',
      'čakčamánnu', 'golggotmánnu', 'skábmamánnu', 'juovlamánnu'],
  STANDALONEMONTHS: ['ođđajagemánnu', 'guovvamánnu', 'njukčamánnu',
      'cuoŋománnu', 'miessemánnu', 'geassemánnu', 'suoidnemánnu',
      'borgemánnu', 'čakčamánnu', 'golggotmánnu', 'skábmamánnu',
      'juovlamánnu'],
  SHORTMONTHS: ['ođđajage', 'guovva', 'njukča', 'cuoŋo', 'miesse', 'geasse',
      'suoidne', 'borge', 'čakča', 'golggot', 'skábma', 'juovla'],
  STANDALONESHORTMONTHS: ['ođđajage', 'guovva', 'njukča', 'cuoŋo', 'miesse',
      'geasse', 'suoidne', 'borge', 'čakča', 'golggot', 'skábma', 'juovla'],
  WEEKDAYS: ['aejlege', 'måanta', 'däjsta', 'gaskevahkoe', 'dåarsta',
      'bearjadahke', 'laavadahke'],
  STANDALONEWEEKDAYS: ['aejlege', 'måanta', 'däjsta', 'gaskevahkoe',
      'dåarsta', 'bearjadahke', 'laavadahke'],
  SHORTWEEKDAYS: ['sotn', 'vuos', 'maŋ', 'gask', 'duor', 'bear', 'láv'],
  STANDALONESHORTWEEKDAYS: ['sotn', 'vuos', 'maŋ', 'gask', 'duor', 'bear',
      'láv'],
  NARROWWEEKDAYS: ['S', 'M', 'D', 'G', 'D', 'B', 'L'],
  STANDALONENARROWWEEKDAYS: ['S', 'M', 'D', 'G', 'D', 'B', 'L'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['iđitbeaivet', 'eahketbeaivet'],
  DATEFORMATS: ['EEEE, y MMMM dd', 'y MMMM d', 'y MMM d', 'yyyy-MM-dd'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale se_NO.
 */
goog.i18n.DateTimeSymbols_se_NO = goog.i18n.DateTimeSymbols_se;


/**
 * Date/time formatting symbols for locale sh.
 */
goog.i18n.DateTimeSymbols_sh = {
  ERAS: ['p. n. e.', 'n. e'],
  ERANAMES: ['Pre nove ere', 'Nove ere'],
  NARROWMONTHS: ['j', 'f', 'm', 'a', 'm', 'j', 'j', 'a', 's', 'o', 'n', 'd'],
  STANDALONENARROWMONTHS: ['j', 'f', 'm', 'a', 'm', 'j', 'j', 'a', 's', 'o',
      'n', 'd'],
  MONTHS: ['januar', 'februar', 'mart', 'april', 'maj', 'jun', 'jul', 'avgust',
      'septembar', 'oktobar', 'novembar', 'decembar'],
  STANDALONEMONTHS: ['januar', 'februar', 'mart', 'april', 'maj', 'jun', 'jul',
      'avgust', 'septembar', 'oktobar', 'novembar', 'decembar'],
  SHORTMONTHS: ['jan', 'feb', 'mar', 'apr', 'maj', 'jun', 'jul', 'avg', 'sep',
      'okt', 'nov', 'dec'],
  STANDALONESHORTMONTHS: ['jan', 'feb', 'mar', 'apr', 'maj', 'jun', 'jul',
      'avg', 'sep', 'okt', 'nov', 'dec'],
  WEEKDAYS: ['nedelja', 'ponedeljak', 'utorak', 'sreda', 'četvrtak', 'petak',
      'subota'],
  STANDALONEWEEKDAYS: ['nedelja', 'ponedeljak', 'utorak', 'sreda', 'četvrtak',
      'petak', 'subota'],
  SHORTWEEKDAYS: ['ned', 'pon', 'uto', 'sre', 'čet', 'pet', 'sub'],
  STANDALONESHORTWEEKDAYS: ['ned', 'pon', 'uto', 'sre', 'čet', 'pet', 'sub'],
  NARROWWEEKDAYS: ['n', 'p', 'u', 's', 'č', 'p', 's'],
  STANDALONENARROWWEEKDAYS: ['n', 'p', 'u', 's', 'č', 'p', 's'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['1. kvartal', '2. kvartal', '3. kvartal', '4. kvartal'],
  AMPMS: ['pre podne', 'popodne'],
  DATEFORMATS: ['EEEE, dd. MMMM y.', 'dd. MMMM y.', 'dd.MM.y.', 'd.M.yy.'],
  TIMEFORMATS: ['HH.mm.ss zzzz', 'HH.mm.ss z', 'HH.mm.ss', 'HH.mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale sh_BA.
 */
goog.i18n.DateTimeSymbols_sh_BA = goog.i18n.DateTimeSymbols_sh;


/**
 * Date/time formatting symbols for locale sh_CS.
 */
goog.i18n.DateTimeSymbols_sh_CS = goog.i18n.DateTimeSymbols_sh;


/**
 * Date/time formatting symbols for locale sh_YU.
 */
goog.i18n.DateTimeSymbols_sh_YU = goog.i18n.DateTimeSymbols_sh;


/**
 * Date/time formatting symbols for locale si.
 */
goog.i18n.DateTimeSymbols_si = {
  ERAS: ['ක්‍රි.පූ.', 'ක්‍රි.ව.'],
  ERANAMES: ['ක්‍රිස්තු පූර්‍ව',
      'ක්‍රිස්තු වර්‍ෂ'],
  NARROWMONTHS: ['ජ', 'පෙ', 'මා', 'අ', 'මැ', 'ජූ', 'ජූ',
      'අ', 'සැ', 'ඔ', 'නො', 'දෙ'],
  STANDALONENARROWMONTHS: ['ජ', 'පෙ', 'මා', 'අ', 'මැ', 'ජූ',
      'ජූ', 'අ', 'සැ', 'ඔ', 'නො', 'දෙ'],
  MONTHS: ['ජනවාර', 'පෙබරවාර', 'මාර්ත',
      'අප්‍රේල්', 'මැයි', 'ජූන', 'ජූලි',
      'අගෝස්තු', 'සැප්තැම්බර්',
      'ඔක්තෝබර්', 'නොවැම්බර්',
      'දෙසැම්බර්'],
  STANDALONEMONTHS: ['ජනවාර', 'පෙබරවාර',
      'මාර්ත', 'අප්‍රේල්', 'මැයි',
      'ජූන', 'ජූලි', 'අගෝස්තු',
      'සැප්තැම්බර්', 'ඔක්තෝබර්',
      'නොවැම්බර්', 'දෙසැම්බර්'],
  SHORTMONTHS: ['ජන', 'පෙබ', 'මාර්ත',
      'අප්‍රේල', 'මැය', 'ජූන', 'ජූල',
      'අගෝ', 'සැප', 'ඔක', 'නොවැ', 'දෙසැ'],
  STANDALONESHORTMONTHS: ['ජන', 'පෙබ', 'මාර්ත',
      'අප්‍රේල', 'මැය', 'ජූන', 'ජූල',
      'අගෝ', 'සැප', 'ඔක', 'නොවැ', 'දෙසැ'],
  WEEKDAYS: ['ඉරිදා', 'සඳුදා',
      'අඟහරුවාදා', 'බදාදා',
      'බ්‍රහස්පතින්දා', 'සිකුරාදා',
      'සෙනසුරාදා'],
  STANDALONEWEEKDAYS: ['ඉරිදා', 'සඳුදා',
      'අඟහරුවාදා', 'බදාදා',
      'බ්‍රහස්පතින්දා', 'සිකුරාදා',
      'සෙනසුරාදා'],
  SHORTWEEKDAYS: ['ඉරි', 'සඳු', 'අඟ', 'බදා',
      'බ්‍රහ', 'සිකු', 'සෙන'],
  STANDALONESHORTWEEKDAYS: ['ඉරි', 'සඳු', 'අඟ', 'බදා',
      'බ්‍රහ', 'සිකු', 'සෙන'],
  NARROWWEEKDAYS: ['ඉ', 'ස', 'අ', 'බ', 'බ්‍ර', 'සි',
      'සෙ'],
  STANDALONENARROWWEEKDAYS: ['ඉ', 'ස', 'අ', 'බ', 'බ්‍ර',
      'සි', 'සෙ'],
  SHORTQUARTERS: ['කාර්:1', 'කාර්:2', 'කාර්:3',
      'කාර්:4'],
  QUARTERS: ['1 වන කාර්තුව', '2 වන කාර්තුව',
      '3 වන කාර්තුව', '4 වන කාර්තුව'],
  AMPMS: ['පෙ.ව.', 'ප.ව.'],
  DATEFORMATS: ['EEEE, y MMMM d', 'y MMMM d', 'y MMM d', 'yyyy/MM/dd'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale si_LK.
 */
goog.i18n.DateTimeSymbols_si_LK = goog.i18n.DateTimeSymbols_si;


/**
 * Date/time formatting symbols for locale sid.
 */
goog.i18n.DateTimeSymbols_sid = {
  ERAS: ['YIA', 'YIG'],
  ERANAMES: ['YIA', 'YIG'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONEMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11',
      '12'],
  SHORTMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONESHORTMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  WEEKDAYS: ['Sambata', 'Sanyo', 'Maakisanyo', 'Roowe', 'Hamuse', 'Arbe',
      'Qidaame'],
  STANDALONEWEEKDAYS: ['Sambata', 'Sanyo', 'Maakisanyo', 'Roowe', 'Hamuse',
      'Arbe', 'Qidaame'],
  SHORTWEEKDAYS: ['Sam', 'San', 'Mak', 'Row', 'Ham', 'Arb', 'Qid'],
  STANDALONESHORTWEEKDAYS: ['Sam', 'San', 'Mak', 'Row', 'Ham', 'Arb', 'Qid'],
  NARROWWEEKDAYS: ['S', 'S', 'M', 'R', 'H', 'A', 'Q'],
  STANDALONENARROWWEEKDAYS: ['S', 'S', 'M', 'R', 'H', 'A', 'Q'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['soodo', 'hawwaro'],
  DATEFORMATS: ['EEEE, MMMM dd, y', 'dd MMMM y', 'dd-MMM-y', 'dd/MM/yy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale sid_ET.
 */
goog.i18n.DateTimeSymbols_sid_ET = goog.i18n.DateTimeSymbols_sid;


/**
 * Date/time formatting symbols for locale sk_SK.
 */
goog.i18n.DateTimeSymbols_sk_SK = {
  ERAS: ['pred n.l.', 'n.l.'],
  ERANAMES: ['pred n.l.', 'n.l.'],
  NARROWMONTHS: ['j', 'f', 'm', 'a', 'm', 'j', 'j', 'a', 's', 'o', 'n', 'd'],
  STANDALONENARROWMONTHS: ['j', 'f', 'm', 'a', 'm', 'j', 'j', 'a', 's', 'o',
      'n', 'd'],
  MONTHS: ['januára', 'februára', 'marca', 'apríla', 'mája', 'júna',
      'júla', 'augusta', 'septembra', 'októbra', 'novembra', 'decembra'],
  STANDALONEMONTHS: ['január', 'február', 'marec', 'apríl', 'máj', 'jún',
      'júl', 'august', 'september', 'október', 'november', 'december'],
  SHORTMONTHS: ['jan', 'feb', 'mar', 'apr', 'máj', 'jún', 'júl', 'aug',
      'sep', 'okt', 'nov', 'dec'],
  STANDALONESHORTMONTHS: ['jan', 'feb', 'mar', 'apr', 'máj', 'jún', 'júl',
      'aug', 'sep', 'okt', 'nov', 'dec'],
  WEEKDAYS: ['nedeľa', 'pondelok', 'utorok', 'streda', 'štvrtok', 'piatok',
      'sobota'],
  STANDALONEWEEKDAYS: ['nedeľa', 'pondelok', 'utorok', 'streda', 'štvrtok',
      'piatok', 'sobota'],
  SHORTWEEKDAYS: ['ne', 'po', 'ut', 'st', 'št', 'pi', 'so'],
  STANDALONESHORTWEEKDAYS: ['ne', 'po', 'ut', 'st', 'št', 'pi', 'so'],
  NARROWWEEKDAYS: ['N', 'P', 'U', 'S', 'Š', 'P', 'S'],
  STANDALONENARROWWEEKDAYS: ['N', 'P', 'U', 'S', 'Š', 'P', 'S'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['1. štvrťrok', '2. štvrťrok', '3. štvrťrok',
      '4. štvrťrok'],
  AMPMS: ['dopoludnia', 'popoludní'],
  DATEFORMATS: ['EEEE, d. MMMM y', 'd. MMMM y', 'd.M.yyyy', 'd.M.yyyy'],
  TIMEFORMATS: ['H:mm:ss zzzz', 'H:mm:ss z', 'H:mm:ss', 'H:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale sl_SI.
 */
goog.i18n.DateTimeSymbols_sl_SI = {
  ERAS: ['pr. n. št.', 'po Kr.'],
  ERANAMES: ['pred našim štetjem', 'naše štetje'],
  NARROWMONTHS: ['j', 'f', 'm', 'a', 'm', 'j', 'j', 'a', 's', 'o', 'n', 'd'],
  STANDALONENARROWMONTHS: ['j', 'f', 'm', 'a', 'm', 'j', 'j', 'a', 's', 'o',
      'n', 'd'],
  MONTHS: ['januar', 'februar', 'marec', 'april', 'maj', 'junij', 'julij',
      'avgust', 'september', 'oktober', 'november', 'december'],
  STANDALONEMONTHS: ['januar', 'februar', 'marec', 'april', 'maj', 'junij',
      'julij', 'avgust', 'september', 'oktober', 'november', 'december'],
  SHORTMONTHS: ['jan.', 'feb.', 'mar.', 'apr.', 'maj', 'jun.', 'jul.', 'avg.',
      'sep.', 'okt.', 'nov.', 'dec.'],
  STANDALONESHORTMONTHS: ['jan', 'feb', 'mar', 'apr', 'maj', 'jun', 'jul',
      'avg', 'sep', 'okt', 'nov', 'dec'],
  WEEKDAYS: ['nedelja', 'ponedeljek', 'torek', 'sreda', 'četrtek', 'petek',
      'sobota'],
  STANDALONEWEEKDAYS: ['nedelja', 'ponedeljek', 'torek', 'sreda', 'četrtek',
      'petek', 'sobota'],
  SHORTWEEKDAYS: ['ned', 'pon', 'tor', 'sre', 'čet', 'pet', 'sob'],
  STANDALONESHORTWEEKDAYS: ['ned', 'pon', 'tor', 'sre', 'čet', 'pet', 'sob'],
  NARROWWEEKDAYS: ['n', 'p', 't', 's', 'č', 'p', 's'],
  STANDALONENARROWWEEKDAYS: ['n', 'p', 't', 's', 'č', 'p', 's'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['1. četrtletje', '2. četrtletje', '3. četrtletje',
      '4. četrtletje'],
  AMPMS: ['dop.', 'pop.'],
  DATEFORMATS: ['EEEE, dd. MMMM y', 'dd. MMMM y', 'd. MMM yyyy', 'd. MM. yy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale so.
 */
goog.i18n.DateTimeSymbols_so = {
  ERAS: ['CK', 'CD'],
  ERANAMES: ['Ciise ka hor (CS)', 'Ciise ka dib (CS)'],
  NARROWMONTHS: ['K', 'L', 'S', 'A', 'S', 'L', 'T', 'S', 'S', 'T', 'K', 'L'],
  STANDALONENARROWMONTHS: ['K', 'L', 'S', 'A', 'S', 'L', 'T', 'S', 'S', 'T',
      'K', 'L'],
  MONTHS: ['Bisha Koobaad', 'Bisha Labaad', 'Bisha Saddexaad', 'Bisha Afraad',
      'Bisha Shanaad', 'Bisha Lixaad', 'Bisha Todobaad', 'Bisha Sideedaad',
      'Bisha Sagaalaad', 'Bisha Tobnaad', 'Bisha Kow iyo Tobnaad',
      'Bisha Laba iyo Tobnaad'],
  STANDALONEMONTHS: ['Bisha Koobaad', 'Bisha Labaad', 'Bisha Saddexaad',
      'Bisha Afraad', 'Bisha Shanaad', 'Bisha Lixaad', 'Bisha Todobaad',
      'Bisha Sideedaad', 'Bisha Sagaalaad', 'Bisha Tobnaad',
      'Bisha Kow iyo Tobnaad', 'Bisha Laba iyo Tobnaad'],
  SHORTMONTHS: ['Kob', 'Lab', 'Sad', 'Afr', 'Sha', 'Lix', 'Tod', 'Sid', 'Sag',
      'Tob', 'KIT', 'LIT'],
  STANDALONESHORTMONTHS: ['Kob', 'Lab', 'Sad', 'Afr', 'Sha', 'Lix', 'Tod',
      'Sid', 'Sag', 'Tob', 'KIT', 'LIT'],
  WEEKDAYS: ['Axad', 'Isniin', 'Talaado', 'Arbaco', 'Khamiis', 'Jimco',
      'Sabti'],
  STANDALONEWEEKDAYS: ['Axad', 'Isniin', 'Talaado', 'Arbaco', 'Khamiis',
      'Jimco', 'Sabti'],
  SHORTWEEKDAYS: ['Axd', 'Isn', 'Tal', 'Arb', 'Kha', 'Jim', 'Sab'],
  STANDALONESHORTWEEKDAYS: ['Axd', 'Isn', 'Tal', 'Arb', 'Kha', 'Jim', 'Sab'],
  NARROWWEEKDAYS: ['A', 'I', 'T', 'A', 'K', 'J', 'S'],
  STANDALONENARROWWEEKDAYS: ['A', 'I', 'T', 'A', 'K', 'J', 'S'],
  SHORTQUARTERS: ['R1', 'R2', 'R3', 'R4'],
  QUARTERS: ['Rubaca 1aad', 'Rubaca 2aad', 'Rubaca 3aad', 'Rubaca 4aad'],
  AMPMS: ['sn.', 'gn.'],
  DATEFORMATS: ['EEEE, MMMM dd, y', 'dd MMMM y', 'dd-MMM-y', 'dd/MM/yy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 5,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 1
};


/**
 * Date/time formatting symbols for locale so_DJ.
 */
goog.i18n.DateTimeSymbols_so_DJ = goog.i18n.DateTimeSymbols_so;


/**
 * Date/time formatting symbols for locale so_ET.
 */
goog.i18n.DateTimeSymbols_so_ET = goog.i18n.DateTimeSymbols_so;


/**
 * Date/time formatting symbols for locale so_KE.
 */
goog.i18n.DateTimeSymbols_so_KE = goog.i18n.DateTimeSymbols_so;


/**
 * Date/time formatting symbols for locale so_SO.
 */
goog.i18n.DateTimeSymbols_so_SO = goog.i18n.DateTimeSymbols_so;


/**
 * Date/time formatting symbols for locale sq_AL.
 */
goog.i18n.DateTimeSymbols_sq_AL = {
  ERAS: ['p.e.r.', 'n.e.r.'],
  ERANAMES: ['p.e.r.', 'n.e.r.'],
  NARROWMONTHS: ['J', 'S', 'M', 'P', 'M', 'Q', 'K', 'G', 'S', 'T', 'N', 'D'],
  STANDALONENARROWMONTHS: ['J', 'S', 'M', 'P', 'M', 'Q', 'K', 'G', 'S', 'T',
      'N', 'D'],
  MONTHS: ['janar', 'shkurt', 'mars', 'prill', 'maj', 'qershor', 'korrik',
      'gusht', 'shtator', 'tetor', 'nëntor', 'dhjetor'],
  STANDALONEMONTHS: ['janar', 'shkurt', 'mars', 'prill', 'maj', 'qershor',
      'korrik', 'gusht', 'shtator', 'tetor', 'nëntor', 'dhjetor'],
  SHORTMONTHS: ['Jan', 'Shk', 'Mar', 'Pri', 'Maj', 'Qer', 'Kor', 'Gsh', 'Sht',
      'Tet', 'Nën', 'Dhj'],
  STANDALONESHORTMONTHS: ['Jan', 'Shk', 'Mar', 'Pri', 'Maj', 'Qer', 'Kor',
      'Gsh', 'Sht', 'Tet', 'Nën', 'Dhj'],
  WEEKDAYS: ['e diel', 'e hënë', 'e martë', 'e mërkurë', 'e enjte',
      'e premte', 'e shtunë'],
  STANDALONEWEEKDAYS: ['e diel', 'e hënë', 'e martë', 'e mërkurë',
      'e enjte', 'e premte', 'e shtunë'],
  SHORTWEEKDAYS: ['Die', 'Hën', 'Mar', 'Mër', 'Enj', 'Pre', 'Sht'],
  STANDALONESHORTWEEKDAYS: ['Die', 'Hën', 'Mar', 'Mër', 'Enj', 'Pre', 'Sht'],
  NARROWWEEKDAYS: ['D', 'H', 'M', 'M', 'E', 'P', 'S'],
  STANDALONENARROWWEEKDAYS: ['D', 'H', 'M', 'M', 'E', 'P', 'S'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['PD', 'MD'],
  DATEFORMATS: ['EEEE, dd MMMM y', 'dd MMMM y', 'yyyy-MM-dd', 'yy-MM-dd'],
  TIMEFORMATS: ['h.mm.ss.a zzzz', 'h.mm.ss.a z', 'h.mm.ss.a', 'h.mm.a'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale sr_BA.
 */
goog.i18n.DateTimeSymbols_sr_BA = {
  ERAS: ['п. н. е.', 'н. е.'],
  ERANAMES: ['Пре нове ере', 'Нове ере'],
  NARROWMONTHS: ['ј', 'ф', 'м', 'а', 'м', 'ј', 'ј', 'а', 'с', 'о',
      'н', 'д'],
  STANDALONENARROWMONTHS: ['ј', 'ф', 'м', 'а', 'м', 'ј', 'ј', 'а', 'с',
      'о', 'н', 'д'],
  MONTHS: ['јануар', 'фебруар', 'март', 'април', 'мај',
      'јуни', 'јули', 'август', 'септембар',
      'октобар', 'новембар', 'децембар'],
  STANDALONEMONTHS: ['јануар', 'фебруар', 'март', 'април',
      'мај', 'јуни', 'јули', 'август', 'септембар',
      'октобар', 'новембар', 'децембар'],
  SHORTMONTHS: ['јан', 'феб', 'мар', 'апр', 'мај', 'јун',
      'јул', 'авг', 'сеп', 'окт', 'нов', 'дец'],
  STANDALONESHORTMONTHS: ['јан', 'феб', 'мар', 'апр', 'мај',
      'јун', 'јул', 'авг', 'сеп', 'окт', 'нов', 'дец'],
  WEEKDAYS: ['недеља', 'понедељак', 'уторак',
      'сриједа', 'четвртак', 'петак', 'субота'],
  STANDALONEWEEKDAYS: ['недеља', 'понедељак', 'уторак',
      'сриједа', 'четвртак', 'петак', 'субота'],
  SHORTWEEKDAYS: ['нед', 'пон', 'уто', 'сри', 'чет', 'пет',
      'суб'],
  STANDALONESHORTWEEKDAYS: ['нед', 'пон', 'уто', 'сри', 'чет',
      'пет', 'суб'],
  NARROWWEEKDAYS: ['н', 'п', 'у', 'с', 'ч', 'п', 'с'],
  STANDALONENARROWWEEKDAYS: ['н', 'п', 'у', 'с', 'ч', 'п', 'с'],
  SHORTQUARTERS: ['К1', 'К2', 'К3', 'К4'],
  QUARTERS: ['Прво тромесечје', 'Друго тромесечје',
      'Треће тромесечје', 'Четврто тромесечје'],
  AMPMS: ['пре подне', 'поподне'],
  DATEFORMATS: ['EEEE, dd. MMMM y.', 'dd. MMMM y.', 'yyyy-MM-dd', 'yy-MM-dd'],
  TIMEFORMATS: [
      'HH \'часова\', mm \'минута\', ss \'секунди\' zzzz',
      'HH.mm.ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale sr_CS.
 */
goog.i18n.DateTimeSymbols_sr_CS = {
  ERAS: ['п. н. е.', 'н. е.'],
  ERANAMES: ['Пре нове ере', 'Нове ере'],
  NARROWMONTHS: ['ј', 'ф', 'м', 'а', 'м', 'ј', 'ј', 'а', 'с', 'о',
      'н', 'д'],
  STANDALONENARROWMONTHS: ['ј', 'ф', 'м', 'а', 'м', 'ј', 'ј', 'а', 'с',
      'о', 'н', 'д'],
  MONTHS: ['јануар', 'фебруар', 'март', 'април', 'мај',
      'јун', 'јул', 'август', 'септембар',
      'октобар', 'новембар', 'децембар'],
  STANDALONEMONTHS: ['јануар', 'фебруар', 'март', 'април',
      'мај', 'јун', 'јул', 'август', 'септембар',
      'октобар', 'новембар', 'децембар'],
  SHORTMONTHS: ['јан', 'феб', 'мар', 'апр', 'мај', 'јун',
      'јул', 'авг', 'сеп', 'окт', 'нов', 'дец'],
  STANDALONESHORTMONTHS: ['јан', 'феб', 'мар', 'апр', 'мај',
      'јун', 'јул', 'авг', 'сеп', 'окт', 'нов', 'дец'],
  WEEKDAYS: ['недеља', 'понедељак', 'уторак', 'среда',
      'четвртак', 'петак', 'субота'],
  STANDALONEWEEKDAYS: ['недеља', 'понедељак', 'уторак',
      'среда', 'четвртак', 'петак', 'субота'],
  SHORTWEEKDAYS: ['нед', 'пон', 'уто', 'сре', 'чет', 'пет',
      'суб'],
  STANDALONESHORTWEEKDAYS: ['нед', 'пон', 'уто', 'сре', 'чет',
      'пет', 'суб'],
  NARROWWEEKDAYS: ['н', 'п', 'у', 'с', 'ч', 'п', 'с'],
  STANDALONENARROWWEEKDAYS: ['н', 'п', 'у', 'с', 'ч', 'п', 'с'],
  SHORTQUARTERS: ['К1', 'К2', 'К3', 'К4'],
  QUARTERS: ['Прво тромесечје', 'Друго тромесечје',
      'Треће тромесечје', 'Четврто тромесечје'],
  AMPMS: ['пре подне', 'поподне'],
  DATEFORMATS: ['EEEE, dd. MMMM y.', 'dd. MMMM y.', 'dd.MM.y.', 'd.M.yy.'],
  TIMEFORMATS: ['HH.mm.ss zzzz', 'HH.mm.ss z', 'HH.mm.ss', 'HH.mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale sr_Cyrl.
 */
goog.i18n.DateTimeSymbols_sr_Cyrl = {
  ERAS: ['п. н. е.', 'н. е.'],
  ERANAMES: ['Пре нове ере', 'Нове ере'],
  NARROWMONTHS: ['ј', 'ф', 'м', 'а', 'м', 'ј', 'ј', 'а', 'с', 'о',
      'н', 'д'],
  STANDALONENARROWMONTHS: ['ј', 'ф', 'м', 'а', 'м', 'ј', 'ј', 'а', 'с',
      'о', 'н', 'д'],
  MONTHS: ['јануар', 'фебруар', 'март', 'април', 'мај',
      'јун', 'јул', 'август', 'септембар',
      'октобар', 'новембар', 'децембар'],
  STANDALONEMONTHS: ['јануар', 'фебруар', 'март', 'април',
      'мај', 'јун', 'јул', 'август', 'септембар',
      'октобар', 'новембар', 'децембар'],
  SHORTMONTHS: ['јан', 'феб', 'мар', 'апр', 'мај', 'јун',
      'јул', 'авг', 'сеп', 'окт', 'нов', 'дец'],
  STANDALONESHORTMONTHS: ['јан', 'феб', 'мар', 'апр', 'мај',
      'јун', 'јул', 'авг', 'сеп', 'окт', 'нов', 'дец'],
  WEEKDAYS: ['недеља', 'понедељак', 'уторак', 'среда',
      'четвртак', 'петак', 'субота'],
  STANDALONEWEEKDAYS: ['недеља', 'понедељак', 'уторак',
      'среда', 'четвртак', 'петак', 'субота'],
  SHORTWEEKDAYS: ['нед', 'пон', 'уто', 'сре', 'чет', 'пет',
      'суб'],
  STANDALONESHORTWEEKDAYS: ['нед', 'пон', 'уто', 'сре', 'чет',
      'пет', 'суб'],
  NARROWWEEKDAYS: ['н', 'п', 'у', 'с', 'ч', 'п', 'с'],
  STANDALONENARROWWEEKDAYS: ['н', 'п', 'у', 'с', 'ч', 'п', 'с'],
  SHORTQUARTERS: ['К1', 'К2', 'К3', 'К4'],
  QUARTERS: ['Прво тромесечје', 'Друго тромесечје',
      'Треће тромесечје', 'Четврто тромесечје'],
  AMPMS: ['пре подне', 'поподне'],
  DATEFORMATS: ['EEEE, dd. MMMM y.', 'dd. MMMM y.', 'dd.MM.y.', 'd.M.yy.'],
  TIMEFORMATS: ['HH.mm.ss zzzz', 'HH.mm.ss z', 'HH.mm.ss', 'HH.mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale sr_Cyrl_BA.
 */
goog.i18n.DateTimeSymbols_sr_Cyrl_BA = {
  ERAS: ['п. н. е.', 'н. е.'],
  ERANAMES: ['Пре нове ере', 'Нове ере'],
  NARROWMONTHS: ['ј', 'ф', 'м', 'а', 'м', 'ј', 'ј', 'а', 'с', 'о',
      'н', 'д'],
  STANDALONENARROWMONTHS: ['ј', 'ф', 'м', 'а', 'м', 'ј', 'ј', 'а', 'с',
      'о', 'н', 'д'],
  MONTHS: ['јануар', 'фебруар', 'март', 'април', 'мај',
      'јуни', 'јули', 'август', 'септембар',
      'октобар', 'новембар', 'децембар'],
  STANDALONEMONTHS: ['јануар', 'фебруар', 'март', 'април',
      'мај', 'јуни', 'јули', 'август', 'септембар',
      'октобар', 'новембар', 'децембар'],
  SHORTMONTHS: ['јан', 'феб', 'мар', 'апр', 'мај', 'јун',
      'јул', 'авг', 'сеп', 'окт', 'нов', 'дец'],
  STANDALONESHORTMONTHS: ['јан', 'феб', 'мар', 'апр', 'мај',
      'јун', 'јул', 'авг', 'сеп', 'окт', 'нов', 'дец'],
  WEEKDAYS: ['недеља', 'понедељак', 'уторак',
      'сриједа', 'четвртак', 'петак', 'субота'],
  STANDALONEWEEKDAYS: ['недеља', 'понедељак', 'уторак',
      'сриједа', 'четвртак', 'петак', 'субота'],
  SHORTWEEKDAYS: ['нед', 'пон', 'уто', 'сри', 'чет', 'пет',
      'суб'],
  STANDALONESHORTWEEKDAYS: ['нед', 'пон', 'уто', 'сри', 'чет',
      'пет', 'суб'],
  NARROWWEEKDAYS: ['н', 'п', 'у', 'с', 'ч', 'п', 'с'],
  STANDALONENARROWWEEKDAYS: ['н', 'п', 'у', 'с', 'ч', 'п', 'с'],
  SHORTQUARTERS: ['К1', 'К2', 'К3', 'К4'],
  QUARTERS: ['Прво тромесечје', 'Друго тромесечје',
      'Треће тромесечје', 'Четврто тромесечје'],
  AMPMS: ['пре подне', 'поподне'],
  DATEFORMATS: ['EEEE, dd. MMMM y.', 'dd. MMMM y.', 'yyyy-MM-dd', 'yy-MM-dd'],
  TIMEFORMATS: [
      'HH \'часова\', mm \'минута\', ss \'секунди\' zzzz',
      'HH.mm.ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale sr_Cyrl_CS.
 */
goog.i18n.DateTimeSymbols_sr_Cyrl_CS = goog.i18n.DateTimeSymbols_sr_Cyrl;


/**
 * Date/time formatting symbols for locale sr_Cyrl_ME.
 */
goog.i18n.DateTimeSymbols_sr_Cyrl_ME = goog.i18n.DateTimeSymbols_sr_Cyrl;


/**
 * Date/time formatting symbols for locale sr_Cyrl_RS.
 */
goog.i18n.DateTimeSymbols_sr_Cyrl_RS = goog.i18n.DateTimeSymbols_sr_Cyrl;


/**
 * Date/time formatting symbols for locale sr_Cyrl_YU.
 */
goog.i18n.DateTimeSymbols_sr_Cyrl_YU = goog.i18n.DateTimeSymbols_sr_Cyrl;


/**
 * Date/time formatting symbols for locale sr_Latn.
 */
goog.i18n.DateTimeSymbols_sr_Latn = {
  ERAS: ['p. n. e.', 'n. e'],
  ERANAMES: ['Pre nove ere', 'Nove ere'],
  NARROWMONTHS: ['j', 'f', 'm', 'a', 'm', 'j', 'j', 'a', 's', 'o', 'n', 'd'],
  STANDALONENARROWMONTHS: ['j', 'f', 'm', 'a', 'm', 'j', 'j', 'a', 's', 'o',
      'n', 'd'],
  MONTHS: ['januar', 'februar', 'mart', 'april', 'maj', 'jun', 'jul', 'avgust',
      'septembar', 'oktobar', 'novembar', 'decembar'],
  STANDALONEMONTHS: ['januar', 'februar', 'mart', 'april', 'maj', 'jun', 'jul',
      'avgust', 'septembar', 'oktobar', 'novembar', 'decembar'],
  SHORTMONTHS: ['jan', 'feb', 'mar', 'apr', 'maj', 'jun', 'jul', 'avg', 'sep',
      'okt', 'nov', 'dec'],
  STANDALONESHORTMONTHS: ['jan', 'feb', 'mar', 'apr', 'maj', 'jun', 'jul',
      'avg', 'sep', 'okt', 'nov', 'dec'],
  WEEKDAYS: ['nedelja', 'ponedeljak', 'utorak', 'sreda', 'četvrtak', 'petak',
      'subota'],
  STANDALONEWEEKDAYS: ['nedelja', 'ponedeljak', 'utorak', 'sreda', 'četvrtak',
      'petak', 'subota'],
  SHORTWEEKDAYS: ['ned', 'pon', 'uto', 'sre', 'čet', 'pet', 'sub'],
  STANDALONESHORTWEEKDAYS: ['ned', 'pon', 'uto', 'sre', 'čet', 'pet', 'sub'],
  NARROWWEEKDAYS: ['n', 'p', 'u', 's', 'č', 'p', 's'],
  STANDALONENARROWWEEKDAYS: ['n', 'p', 'u', 's', 'č', 'p', 's'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['1. kvartal', '2. kvartal', '3. kvartal', '4. kvartal'],
  AMPMS: ['pre podne', 'popodne'],
  DATEFORMATS: ['EEEE, dd. MMMM y.', 'dd. MMMM y.', 'dd.MM.y.', 'd.M.yy.'],
  TIMEFORMATS: ['HH.mm.ss zzzz', 'HH.mm.ss z', 'HH.mm.ss', 'HH.mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale sr_Latn_BA.
 */
goog.i18n.DateTimeSymbols_sr_Latn_BA = goog.i18n.DateTimeSymbols_sr_Latn;


/**
 * Date/time formatting symbols for locale sr_Latn_CS.
 */
goog.i18n.DateTimeSymbols_sr_Latn_CS = goog.i18n.DateTimeSymbols_sr_Latn;


/**
 * Date/time formatting symbols for locale sr_Latn_ME.
 */
goog.i18n.DateTimeSymbols_sr_Latn_ME = {
  ERAS: ['p. n. e.', 'n. e'],
  ERANAMES: ['Pre nove ere', 'Nove ere'],
  NARROWMONTHS: ['j', 'f', 'm', 'a', 'm', 'j', 'j', 'a', 's', 'o', 'n', 'd'],
  STANDALONENARROWMONTHS: ['j', 'f', 'm', 'a', 'm', 'j', 'j', 'a', 's', 'o',
      'n', 'd'],
  MONTHS: ['januar', 'februar', 'mart', 'april', 'maj', 'jun', 'jul', 'avgust',
      'septembar', 'oktobar', 'novembar', 'decembar'],
  STANDALONEMONTHS: ['januar', 'februar', 'mart', 'april', 'maj', 'jun', 'jul',
      'avgust', 'septembar', 'oktobar', 'novembar', 'decembar'],
  SHORTMONTHS: ['jan', 'feb', 'mar', 'apr', 'maj', 'jun', 'jul', 'avg', 'sep',
      'okt', 'nov', 'dec'],
  STANDALONESHORTMONTHS: ['jan', 'feb', 'mar', 'apr', 'maj', 'jun', 'jul',
      'avg', 'sep', 'okt', 'nov', 'dec'],
  WEEKDAYS: ['nedelja', 'ponedeljak', 'utorak', 'sreda', 'četvrtak', 'petak',
      'subota'],
  STANDALONEWEEKDAYS: ['nedelja', 'ponedeljak', 'utorak', 'sreda', 'četvrtak',
      'petak', 'subota'],
  SHORTWEEKDAYS: ['ned', 'pon', 'uto', 'sre', 'čet', 'pet', 'sub'],
  STANDALONESHORTWEEKDAYS: ['ned', 'pon', 'uto', 'sre', 'čet', 'pet', 'sub'],
  NARROWWEEKDAYS: ['n', 'p', 'u', 's', 'č', 'p', 's'],
  STANDALONENARROWWEEKDAYS: ['n', 'p', 'u', 's', 'č', 'p', 's'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['1. kvartal', '2. kvartal', '3. kvartal', '4. kvartal'],
  AMPMS: ['pre podne', 'popodne'],
  DATEFORMATS: ['EEEE, dd. MMMM y.', 'd.MM.yyyy.', 'dd.MM.y.', 'd.M.yy.'],
  TIMEFORMATS: ['HH.mm.ss zzzz', 'HH.mm.ss z', 'HH.mm.ss', 'HH.mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale sr_Latn_RS.
 */
goog.i18n.DateTimeSymbols_sr_Latn_RS = goog.i18n.DateTimeSymbols_sr_Latn;


/**
 * Date/time formatting symbols for locale sr_Latn_YU.
 */
goog.i18n.DateTimeSymbols_sr_Latn_YU = goog.i18n.DateTimeSymbols_sr_Latn;


/**
 * Date/time formatting symbols for locale sr_ME.
 */
goog.i18n.DateTimeSymbols_sr_ME = {
  ERAS: ['p. n. e.', 'n. e'],
  ERANAMES: ['Pre nove ere', 'Nove ere'],
  NARROWMONTHS: ['j', 'f', 'm', 'a', 'm', 'j', 'j', 'a', 's', 'o', 'n', 'd'],
  STANDALONENARROWMONTHS: ['j', 'f', 'm', 'a', 'm', 'j', 'j', 'a', 's', 'o',
      'n', 'd'],
  MONTHS: ['januar', 'februar', 'mart', 'april', 'maj', 'jun', 'jul', 'avgust',
      'septembar', 'oktobar', 'novembar', 'decembar'],
  STANDALONEMONTHS: ['januar', 'februar', 'mart', 'april', 'maj', 'jun', 'jul',
      'avgust', 'septembar', 'oktobar', 'novembar', 'decembar'],
  SHORTMONTHS: ['jan', 'feb', 'mar', 'apr', 'maj', 'jun', 'jul', 'avg', 'sep',
      'okt', 'nov', 'dec'],
  STANDALONESHORTMONTHS: ['jan', 'feb', 'mar', 'apr', 'maj', 'jun', 'jul',
      'avg', 'sep', 'okt', 'nov', 'dec'],
  WEEKDAYS: ['nedelja', 'ponedeljak', 'utorak', 'sreda', 'četvrtak', 'petak',
      'subota'],
  STANDALONEWEEKDAYS: ['nedelja', 'ponedeljak', 'utorak', 'sreda', 'četvrtak',
      'petak', 'subota'],
  SHORTWEEKDAYS: ['ned', 'pon', 'uto', 'sre', 'čet', 'pet', 'sub'],
  STANDALONESHORTWEEKDAYS: ['ned', 'pon', 'uto', 'sre', 'čet', 'pet', 'sub'],
  NARROWWEEKDAYS: ['n', 'p', 'u', 's', 'č', 'p', 's'],
  STANDALONENARROWWEEKDAYS: ['n', 'p', 'u', 's', 'č', 'p', 's'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['1. kvartal', '2. kvartal', '3. kvartal', '4. kvartal'],
  AMPMS: ['pre podne', 'popodne'],
  DATEFORMATS: ['EEEE, dd. MMMM y.', 'd.MM.yyyy.', 'dd.MM.y.', 'd.M.yy.'],
  TIMEFORMATS: ['HH.mm.ss zzzz', 'HH.mm.ss z', 'HH.mm.ss', 'HH.mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale sr_RS.
 */
goog.i18n.DateTimeSymbols_sr_RS = {
  ERAS: ['п. н. е.', 'н. е.'],
  ERANAMES: ['Пре нове ере', 'Нове ере'],
  NARROWMONTHS: ['ј', 'ф', 'м', 'а', 'м', 'ј', 'ј', 'а', 'с', 'о',
      'н', 'д'],
  STANDALONENARROWMONTHS: ['ј', 'ф', 'м', 'а', 'м', 'ј', 'ј', 'а', 'с',
      'о', 'н', 'д'],
  MONTHS: ['јануар', 'фебруар', 'март', 'април', 'мај',
      'јун', 'јул', 'август', 'септембар',
      'октобар', 'новембар', 'децембар'],
  STANDALONEMONTHS: ['јануар', 'фебруар', 'март', 'април',
      'мај', 'јун', 'јул', 'август', 'септембар',
      'октобар', 'новембар', 'децембар'],
  SHORTMONTHS: ['јан', 'феб', 'мар', 'апр', 'мај', 'јун',
      'јул', 'авг', 'сеп', 'окт', 'нов', 'дец'],
  STANDALONESHORTMONTHS: ['јан', 'феб', 'мар', 'апр', 'мај',
      'јун', 'јул', 'авг', 'сеп', 'окт', 'нов', 'дец'],
  WEEKDAYS: ['недеља', 'понедељак', 'уторак', 'среда',
      'четвртак', 'петак', 'субота'],
  STANDALONEWEEKDAYS: ['недеља', 'понедељак', 'уторак',
      'среда', 'четвртак', 'петак', 'субота'],
  SHORTWEEKDAYS: ['нед', 'пон', 'уто', 'сре', 'чет', 'пет',
      'суб'],
  STANDALONESHORTWEEKDAYS: ['нед', 'пон', 'уто', 'сре', 'чет',
      'пет', 'суб'],
  NARROWWEEKDAYS: ['н', 'п', 'у', 'с', 'ч', 'п', 'с'],
  STANDALONENARROWWEEKDAYS: ['н', 'п', 'у', 'с', 'ч', 'п', 'с'],
  SHORTQUARTERS: ['К1', 'К2', 'К3', 'К4'],
  QUARTERS: ['Прво тромесечје', 'Друго тромесечје',
      'Треће тромесечје', 'Четврто тромесечје'],
  AMPMS: ['пре подне', 'поподне'],
  DATEFORMATS: ['EEEE, dd. MMMM y.', 'dd. MMMM y.', 'dd.MM.y.', 'd.M.yy.'],
  TIMEFORMATS: ['HH.mm.ss zzzz', 'HH.mm.ss z', 'HH.mm.ss', 'HH.mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale sr_YU.
 */
goog.i18n.DateTimeSymbols_sr_YU = {
  ERAS: ['п. н. е.', 'н. е.'],
  ERANAMES: ['Пре нове ере', 'Нове ере'],
  NARROWMONTHS: ['ј', 'ф', 'м', 'а', 'м', 'ј', 'ј', 'а', 'с', 'о',
      'н', 'д'],
  STANDALONENARROWMONTHS: ['ј', 'ф', 'м', 'а', 'м', 'ј', 'ј', 'а', 'с',
      'о', 'н', 'д'],
  MONTHS: ['јануар', 'фебруар', 'март', 'април', 'мај',
      'јун', 'јул', 'август', 'септембар',
      'октобар', 'новембар', 'децембар'],
  STANDALONEMONTHS: ['јануар', 'фебруар', 'март', 'април',
      'мај', 'јун', 'јул', 'август', 'септембар',
      'октобар', 'новембар', 'децембар'],
  SHORTMONTHS: ['јан', 'феб', 'мар', 'апр', 'мај', 'јун',
      'јул', 'авг', 'сеп', 'окт', 'нов', 'дец'],
  STANDALONESHORTMONTHS: ['јан', 'феб', 'мар', 'апр', 'мај',
      'јун', 'јул', 'авг', 'сеп', 'окт', 'нов', 'дец'],
  WEEKDAYS: ['недеља', 'понедељак', 'уторак', 'среда',
      'четвртак', 'петак', 'субота'],
  STANDALONEWEEKDAYS: ['недеља', 'понедељак', 'уторак',
      'среда', 'четвртак', 'петак', 'субота'],
  SHORTWEEKDAYS: ['нед', 'пон', 'уто', 'сре', 'чет', 'пет',
      'суб'],
  STANDALONESHORTWEEKDAYS: ['нед', 'пон', 'уто', 'сре', 'чет',
      'пет', 'суб'],
  NARROWWEEKDAYS: ['н', 'п', 'у', 'с', 'ч', 'п', 'с'],
  STANDALONENARROWWEEKDAYS: ['н', 'п', 'у', 'с', 'ч', 'п', 'с'],
  SHORTQUARTERS: ['К1', 'К2', 'К3', 'К4'],
  QUARTERS: ['Прво тромесечје', 'Друго тромесечје',
      'Треће тромесечје', 'Четврто тромесечје'],
  AMPMS: ['пре подне', 'поподне'],
  DATEFORMATS: ['EEEE, dd. MMMM y.', 'dd. MMMM y.', 'dd.MM.y.', 'd.M.yy.'],
  TIMEFORMATS: ['HH.mm.ss zzzz', 'HH.mm.ss z', 'HH.mm.ss', 'HH.mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale ss.
 */
goog.i18n.DateTimeSymbols_ss = {
  ERAS: ['BCE', 'CE'],
  ERANAMES: ['BCE', 'CE'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['Bhimbidvwane', 'iNdlovana', 'iNdlovu-lenkhulu', 'Mabasa',
      'iNkhwekhweti', 'iNhlaba', 'Kholwane', 'iNgci', 'iNyoni', 'iMphala',
      'Lweti', 'iNgongoni'],
  STANDALONEMONTHS: ['Bhimbidvwane', 'iNdlovana', 'iNdlovu-lenkhulu', 'Mabasa',
      'iNkhwekhweti', 'iNhlaba', 'Kholwane', 'iNgci', 'iNyoni', 'iMphala',
      'Lweti', 'iNgongoni'],
  SHORTMONTHS: ['Bhi', 'Van', 'Vol', 'Mab', 'Nkh', 'Nhl', 'Kho', 'Ngc', 'Nyo',
      'Mph', 'Lwe', 'Ngo'],
  STANDALONESHORTMONTHS: ['Bhi', 'Van', 'Vol', 'Mab', 'Nkh', 'Nhl', 'Kho',
      'Ngc', 'Nyo', 'Mph', 'Lwe', 'Ngo'],
  WEEKDAYS: ['Lisontfo', 'uMsombuluko', 'Lesibili', 'Lesitsatfu', 'Lesine',
      'Lesihlanu', 'uMgcibelo'],
  STANDALONEWEEKDAYS: ['Lisontfo', 'uMsombuluko', 'Lesibili', 'Lesitsatfu',
      'Lesine', 'Lesihlanu', 'uMgcibelo'],
  SHORTWEEKDAYS: ['Son', 'Mso', 'Bil', 'Tsa', 'Ne', 'Hla', 'Mgc'],
  STANDALONESHORTWEEKDAYS: ['Son', 'Mso', 'Bil', 'Tsa', 'Ne', 'Hla', 'Mgc'],
  NARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONENARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, y MMMM dd', 'y MMMM d', 'y MMM d', 'yyyy-MM-dd'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale ss_SZ.
 */
goog.i18n.DateTimeSymbols_ss_SZ = goog.i18n.DateTimeSymbols_ss;


/**
 * Date/time formatting symbols for locale ss_ZA.
 */
goog.i18n.DateTimeSymbols_ss_ZA = goog.i18n.DateTimeSymbols_ss;


/**
 * Date/time formatting symbols for locale st.
 */
goog.i18n.DateTimeSymbols_st = {
  ERAS: ['BCE', 'CE'],
  ERANAMES: ['BCE', 'CE'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['Phesekgong', 'Hlakola', 'Hlakubele', 'Mmese', 'Motsheanong',
      'Phupjane', 'Phupu', 'Phata', 'Leotshe', 'Mphalane', 'Pundungwane',
      'Tshitwe'],
  STANDALONEMONTHS: ['Phesekgong', 'Hlakola', 'Hlakubele', 'Mmese',
      'Motsheanong', 'Phupjane', 'Phupu', 'Phata', 'Leotshe', 'Mphalane',
      'Pundungwane', 'Tshitwe'],
  SHORTMONTHS: ['Phe', 'Kol', 'Ube', 'Mme', 'Mot', 'Jan', 'Upu', 'Pha', 'Leo',
      'Mph', 'Pun', 'Tsh'],
  STANDALONESHORTMONTHS: ['Phe', 'Kol', 'Ube', 'Mme', 'Mot', 'Jan', 'Upu',
      'Pha', 'Leo', 'Mph', 'Pun', 'Tsh'],
  WEEKDAYS: ['Sontaha', 'Mmantaha', 'Labobedi', 'Laboraru', 'Labone',
      'Labohlane', 'Moqebelo'],
  STANDALONEWEEKDAYS: ['Sontaha', 'Mmantaha', 'Labobedi', 'Laboraru', 'Labone',
      'Labohlane', 'Moqebelo'],
  SHORTWEEKDAYS: ['Son', 'Mma', 'Bed', 'Rar', 'Ne', 'Hla', 'Moq'],
  STANDALONESHORTWEEKDAYS: ['Son', 'Mma', 'Bed', 'Rar', 'Ne', 'Hla', 'Moq'],
  NARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONENARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, y MMMM dd', 'y MMMM d', 'y MMM d', 'yyyy-MM-dd'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale st_LS.
 */
goog.i18n.DateTimeSymbols_st_LS = goog.i18n.DateTimeSymbols_st;


/**
 * Date/time formatting symbols for locale st_ZA.
 */
goog.i18n.DateTimeSymbols_st_ZA = goog.i18n.DateTimeSymbols_st;


/**
 * Date/time formatting symbols for locale sv_FI.
 */
goog.i18n.DateTimeSymbols_sv_FI = {
  ERAS: ['f.Kr.', 'e.Kr.'],
  ERANAMES: ['före Kristus', 'efter Kristus'],
  NARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['januari', 'februari', 'mars', 'april', 'maj', 'juni', 'juli',
      'augusti', 'september', 'oktober', 'november', 'december'],
  STANDALONEMONTHS: ['januari', 'februari', 'mars', 'april', 'maj', 'juni',
      'juli', 'augusti', 'september', 'oktober', 'november', 'december'],
  SHORTMONTHS: ['jan', 'feb', 'mar', 'apr', 'maj', 'jun', 'jul', 'aug', 'sep',
      'okt', 'nov', 'dec'],
  STANDALONESHORTMONTHS: ['jan', 'feb', 'mar', 'apr', 'maj', 'jun', 'jul',
      'aug', 'sep', 'okt', 'nov', 'dec'],
  WEEKDAYS: ['söndag', 'måndag', 'tisdag', 'onsdag', 'torsdag', 'fredag',
      'lördag'],
  STANDALONEWEEKDAYS: ['söndag', 'måndag', 'tisdag', 'onsdag', 'torsdag',
      'fredag', 'lördag'],
  SHORTWEEKDAYS: ['sön', 'mån', 'tis', 'ons', 'tors', 'fre', 'lör'],
  STANDALONESHORTWEEKDAYS: ['sön', 'mån', 'tis', 'ons', 'tors', 'fre',
      'lör'],
  NARROWWEEKDAYS: ['S', 'M', 'T', 'O', 'T', 'F', 'L'],
  STANDALONENARROWWEEKDAYS: ['S', 'M', 'T', 'O', 'T', 'F', 'L'],
  SHORTQUARTERS: ['K1', 'K2', 'K3', 'K4'],
  QUARTERS: ['1:a kvartalet', '2:a kvartalet', '3:e kvartalet',
      '4:e kvartalet'],
  AMPMS: ['fm', 'em'],
  DATEFORMATS: ['EEEE\'en\' \'den\' d:\'e\' MMMM y', 'd MMMM y', 'd MMM y',
      'yyyy-MM-dd'],
  TIMEFORMATS: ['\'kl\'. HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale sv_SE.
 */
goog.i18n.DateTimeSymbols_sv_SE = {
  ERAS: ['f.Kr.', 'e.Kr.'],
  ERANAMES: ['före Kristus', 'efter Kristus'],
  NARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['januari', 'februari', 'mars', 'april', 'maj', 'juni', 'juli',
      'augusti', 'september', 'oktober', 'november', 'december'],
  STANDALONEMONTHS: ['januari', 'februari', 'mars', 'april', 'maj', 'juni',
      'juli', 'augusti', 'september', 'oktober', 'november', 'december'],
  SHORTMONTHS: ['jan', 'feb', 'mar', 'apr', 'maj', 'jun', 'jul', 'aug', 'sep',
      'okt', 'nov', 'dec'],
  STANDALONESHORTMONTHS: ['jan', 'feb', 'mar', 'apr', 'maj', 'jun', 'jul',
      'aug', 'sep', 'okt', 'nov', 'dec'],
  WEEKDAYS: ['söndag', 'måndag', 'tisdag', 'onsdag', 'torsdag', 'fredag',
      'lördag'],
  STANDALONEWEEKDAYS: ['söndag', 'måndag', 'tisdag', 'onsdag', 'torsdag',
      'fredag', 'lördag'],
  SHORTWEEKDAYS: ['sön', 'mån', 'tis', 'ons', 'tors', 'fre', 'lör'],
  STANDALONESHORTWEEKDAYS: ['sön', 'mån', 'tis', 'ons', 'tors', 'fre',
      'lör'],
  NARROWWEEKDAYS: ['S', 'M', 'T', 'O', 'T', 'F', 'L'],
  STANDALONENARROWWEEKDAYS: ['S', 'M', 'T', 'O', 'T', 'F', 'L'],
  SHORTQUARTERS: ['K1', 'K2', 'K3', 'K4'],
  QUARTERS: ['1:a kvartalet', '2:a kvartalet', '3:e kvartalet',
      '4:e kvartalet'],
  AMPMS: ['fm', 'em'],
  DATEFORMATS: ['EEEE\'en\' \'den\' d:\'e\' MMMM y', 'd MMMM y', 'd MMM y',
      'yyyy-MM-dd'],
  TIMEFORMATS: ['\'kl\'. HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale sw_KE.
 */
goog.i18n.DateTimeSymbols_sw_KE = {
  ERAS: ['KK', 'BK'],
  ERANAMES: ['Kabla ya Kristo', 'Baada ya Kristo'],
  NARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['Januari', 'Februari', 'Machi', 'Aprili', 'Mei', 'Juni', 'Julai',
      'Agosti', 'Septemba', 'Oktoba', 'Novemba', 'Desemba'],
  STANDALONEMONTHS: ['Januari', 'Februari', 'Machi', 'Aprili', 'Mei', 'Juni',
      'Julai', 'Agosti', 'Septemba', 'Oktoba', 'Novemba', 'Desemba'],
  SHORTMONTHS: ['Jan', 'Feb', 'Mac', 'Apr', 'Mei', 'Jun', 'Jul', 'Ago', 'Sep',
      'Okt', 'Nov', 'Des'],
  STANDALONESHORTMONTHS: ['Jan', 'Feb', 'Mac', 'Apr', 'Mei', 'Jun', 'Jul',
      'Ago', 'Sep', 'Okt', 'Nov', 'Des'],
  WEEKDAYS: ['Jumapili', 'Jumatatu', 'Jumanne', 'Jumatano', 'Alhamisi',
      'Ijumaa', 'Jumamosi'],
  STANDALONEWEEKDAYS: ['Jumapili', 'Jumatatu', 'Jumanne', 'Jumatano',
      'Alhamisi', 'Ijumaa', 'Jumamosi'],
  SHORTWEEKDAYS: ['J2', 'J3', 'J4', 'J5', 'Alh', 'Ij', 'J1'],
  STANDALONESHORTWEEKDAYS: ['J2', 'J3', 'J4', 'J5', 'Alh', 'Ij', 'J1'],
  NARROWWEEKDAYS: ['2', '3', '4', '5', 'A', 'I', '1'],
  STANDALONENARROWWEEKDAYS: ['2', '3', '4', '5', 'A', 'I', '1'],
  SHORTQUARTERS: ['R1', 'R2', 'R3', 'R4'],
  QUARTERS: ['Robo 1', 'Robo 2', 'Robo 3', 'Robo 4'],
  AMPMS: ['asubuhi', 'alasiri'],
  DATEFORMATS: ['EEEE, d MMMM y', 'd MMMM y', 'd MMM y', 'dd/MM/yyyy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 5,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 1
};


/**
 * Date/time formatting symbols for locale sw_TZ.
 */
goog.i18n.DateTimeSymbols_sw_TZ = {
  ERAS: ['KK', 'BK'],
  ERANAMES: ['Kabla ya Kristo', 'Baada ya Kristo'],
  NARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['Januari', 'Februari', 'Machi', 'Aprili', 'Mei', 'Juni', 'Julai',
      'Agosti', 'Septemba', 'Oktoba', 'Novemba', 'Desemba'],
  STANDALONEMONTHS: ['Januari', 'Februari', 'Machi', 'Aprili', 'Mei', 'Juni',
      'Julai', 'Agosti', 'Septemba', 'Oktoba', 'Novemba', 'Desemba'],
  SHORTMONTHS: ['Jan', 'Feb', 'Mac', 'Apr', 'Mei', 'Jun', 'Jul', 'Ago', 'Sep',
      'Okt', 'Nov', 'Des'],
  STANDALONESHORTMONTHS: ['Jan', 'Feb', 'Mac', 'Apr', 'Mei', 'Jun', 'Jul',
      'Ago', 'Sep', 'Okt', 'Nov', 'Des'],
  WEEKDAYS: ['Jumapili', 'Jumatatu', 'Jumanne', 'Jumatano', 'Alhamisi',
      'Ijumaa', 'Jumamosi'],
  STANDALONEWEEKDAYS: ['Jumapili', 'Jumatatu', 'Jumanne', 'Jumatano',
      'Alhamisi', 'Ijumaa', 'Jumamosi'],
  SHORTWEEKDAYS: ['J2', 'J3', 'J4', 'J5', 'Alh', 'Ij', 'J1'],
  STANDALONESHORTWEEKDAYS: ['J2', 'J3', 'J4', 'J5', 'Alh', 'Ij', 'J1'],
  NARROWWEEKDAYS: ['2', '3', '4', '5', 'A', 'I', '1'],
  STANDALONENARROWWEEKDAYS: ['2', '3', '4', '5', 'A', 'I', '1'],
  SHORTQUARTERS: ['R1', 'R2', 'R3', 'R4'],
  QUARTERS: ['Robo 1', 'Robo 2', 'Robo 3', 'Robo 4'],
  AMPMS: ['asubuhi', 'alasiri'],
  DATEFORMATS: ['EEEE, d MMMM y', 'd MMMM y', 'd MMM y', 'dd/MM/yyyy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale syr.
 */
goog.i18n.DateTimeSymbols_syr = {
  ERAS: ['BCE', 'CE'],
  ERANAMES: ['BCE', 'CE'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['܏ܟܢ ܏ܒ', 'ܫܒܛ', 'ܐܕܪ', 'ܢܝܣܢ', 'ܐܝܪ',
      'ܚܙܝܪܢ', 'ܬܡܘܙ', 'ܐܒ', 'ܐܝܠܘܠ', '܏ܬܫ ܏ܐ',
      '܏ܬܫ ܏ܒ', '܏ܟܢ ܏ܐ'],
  STANDALONEMONTHS: ['܏ܟܢ ܏ܒ', 'ܫܒܛ', 'ܐܕܪ', 'ܢܝܣܢ', 'ܐܝܪ',
      'ܚܙܝܪܢ', 'ܬܡܘܙ', 'ܐܒ', 'ܐܝܠܘܠ', '܏ܬܫ ܏ܐ',
      '܏ܬܫ ܏ܒ', '܏ܟܢ ܏ܐ'],
  SHORTMONTHS: ['܏ܟܢ ܏ܒ', 'ܫܒܛ', 'ܐܕܪ', 'ܢܝܣܢ', 'ܐܝܪ',
      'ܚܙܝܪܢ', 'ܬܡܘܙ', 'ܐܒ', 'ܐܝܠܘܠ', '܏ܬܫ ܏ܐ',
      '܏ܬܫ ܏ܒ', '܏ܟܢ ܏ܐ'],
  STANDALONESHORTMONTHS: ['܏ܟܢ ܏ܒ', 'ܫܒܛ', 'ܐܕܪ', 'ܢܝܣܢ',
      'ܐܝܪ', 'ܚܙܝܪܢ', 'ܬܡܘܙ', 'ܐܒ', 'ܐܝܠܘܠ', '܏ܬܫ ܏ܐ',
      '܏ܬܫ ܏ܒ', '܏ܟܢ ܏ܐ'],
  WEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONEWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONESHORTWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  NARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONENARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['dd MMMM, y', 'dd MMMM, y', 'dd/MM/yyyy', 'dd/MM/yyyy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale syr_SY.
 */
goog.i18n.DateTimeSymbols_syr_SY = goog.i18n.DateTimeSymbols_syr;


/**
 * Date/time formatting symbols for locale ta_IN.
 */
goog.i18n.DateTimeSymbols_ta_IN = {
  ERAS: ['கிமு', 'கிபி'],
  ERANAMES: ['கிறிஸ்துவுக்கு முன்',
      'அனோ டோமினி'],
  NARROWMONTHS: ['ஜ', 'பி', 'மா', 'ஏ', 'மே', 'ஜூ', 'ஜூ',
      'ஆ', 'செ', 'அ', 'ந', 'டி'],
  STANDALONENARROWMONTHS: ['ஜ', 'பி', 'மா', 'ஏ', 'மே', 'ஜூ',
      'ஜூ', 'ஆ', 'செ', 'அ', 'ந', 'டி'],
  MONTHS: ['ஜனவரி', 'பிப்ரவரி', 'மார்ச்',
      'ஏப்ரல்', 'மே', 'ஜூன்', 'ஜூலை',
      'ஆகஸ்ட்', 'செப்டெம்ப்ர்',
      'அக்டோபர்', 'நவம்பர்',
      'டிசம்பர்'],
  STANDALONEMONTHS: ['ஜனவரி', 'பிப்ரவரி',
      'மார்ச்', 'ஏப்ரல்', 'மே', 'ஜூன்',
      'ஜூலை', 'ஆகஸ்ட்',
      'செப்டெம்ப்ர்', 'அக்டோபர்',
      'நவம்பர்', 'டிசம்பர்'],
  SHORTMONTHS: ['ஜன.', 'பிப்.', 'மார்.', 'ஏப்.',
      'மே', 'ஜூன்', 'ஜூலை', 'ஆக.', 'செப்.',
      'அக்.', 'நவ.', 'டிச.'],
  STANDALONESHORTMONTHS: ['ஜன.', 'பிப்.', 'மார்.',
      'ஏப்.', 'மே', 'ஜூன்', 'ஜூலை', 'ஆக.',
      'செப்.', 'அக்.', 'நவ.', 'டிச.'],
  WEEKDAYS: ['ஞாயிறு', 'திங்கள்',
      'செவ்வாய்', 'புதன்', 'வியாழன்',
      'வெள்ளி', 'சனி'],
  STANDALONEWEEKDAYS: ['ஞாயிறு', 'திங்கள்',
      'செவ்வாய்', 'புதன்', 'வியாழன்',
      'வெள்ளி', 'சனி'],
  SHORTWEEKDAYS: ['ஞா', 'தி', 'செ', 'பு', 'வி', 'வெ',
      'ச'],
  STANDALONESHORTWEEKDAYS: ['ஞா', 'தி', 'செ', 'பு', 'வி',
      'வெ', 'ச'],
  NARROWWEEKDAYS: ['ஞா', 'தி', 'செ', 'பு', 'வி', 'வெ',
      'ச'],
  STANDALONENARROWWEEKDAYS: ['ஞா', 'தி', 'செ', 'பு', 'வி',
      'வெ', 'ச'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['1ஆம் காலாண்டு',
      '2ஆம் காலாண்டு',
      '3ஆம் காலாண்டு',
      '4ஆம் காலாண்டு'],
  AMPMS: ['am', 'pm'],
  DATEFORMATS: ['EEEE, d MMMM, y', 'd MMMM, y', 'd MMM, y', 'd-M-yy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [6, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale te_IN.
 */
goog.i18n.DateTimeSymbols_te_IN = {
  ERAS: ['ఈసాపూర్వ.', 'సన్.'],
  ERANAMES: ['ఈసాపూర్వ.', 'సన్.'],
  NARROWMONTHS: ['జ', 'ఫి', 'మ', 'ఎ', 'మె', 'జు', 'జు',
      'ఆ', 'సె', 'అ', 'న', 'డి'],
  STANDALONENARROWMONTHS: ['జ', 'ఫి', 'మ', 'ఎ', 'మె', 'జు',
      'జు', 'ఆ', 'సె', 'అ', 'న', 'డి'],
  MONTHS: ['జనవరి', 'ఫిబ్రవరి', 'మార్చి',
      'ఏప్రిల్', 'మే', 'జూన్', 'జూలై',
      'ఆగస్టు', 'సెప్టెంబర్',
      'అక్టోబర్', 'నవంబర్',
      'డిసెంబర్'],
  STANDALONEMONTHS: ['జనవరి', 'ఫిబ్రవరి',
      'మార్చి', 'ఏప్రిల్', 'మే', 'జూన్',
      'జూలై', 'ఆగస్టు', 'సెప్టెంబర్',
      'అక్టోబర్', 'నవంబర్',
      'డిసెంబర్'],
  SHORTMONTHS: ['జనవరి', 'ఫిబ్రవరి',
      'మార్చి', 'ఏప్రిల్', 'మే', 'జూన్',
      'జూలై', 'ఆగస్టు', 'సెప్టెంబర్',
      'అక్టోబర్', 'నవంబర్',
      'డిసెంబర్'],
  STANDALONESHORTMONTHS: ['జనవరి', 'ఫిబ్రవరి',
      'మార్చి', 'ఏప్రిల్', 'మే', 'జూన్',
      'జూలై', 'ఆగస్టు', 'సెప్టెంబర్',
      'అక్టోబర్', 'నవంబర్',
      'డిసెంబర్'],
  WEEKDAYS: ['ఆదివారం', 'సోమవారం',
      'మంగళవారం', 'బుధవారం',
      'గురువారం', 'శుక్రవారం',
      'శనివారం'],
  STANDALONEWEEKDAYS: ['ఆదివారం', 'సోమవారం',
      'మంగళవారం', 'బుధవారం',
      'గురువారం', 'శుక్రవారం',
      'శనివారం'],
  SHORTWEEKDAYS: ['ఆది', 'సోమ', 'మంగళ', 'బుధ',
      'గురు', 'శుక్ర', 'శని'],
  STANDALONESHORTWEEKDAYS: ['ఆది', 'సోమ', 'మంగళ',
      'బుధ', 'గురు', 'శుక్ర', 'శని'],
  NARROWWEEKDAYS: ['ఆ', 'సో', 'మ', 'భు', 'గు', 'శు', 'శ'],
  STANDALONENARROWWEEKDAYS: ['ఆ', 'సో', 'మ', 'భు', 'గు',
      'శు', 'శ'],
  SHORTQUARTERS: ['ఒకటి 1', 'రెండు 2', 'మూడు 3',
      'నాలుగు 4'],
  QUARTERS: ['ఒకటి 1', 'రెండు 2', 'మూడు 3',
      'నాలుగు 4'],
  AMPMS: ['ఉ', 'సా'],
  DATEFORMATS: ['EEEE d MMMM y', 'd MMMM y', 'd MMM y', 'dd-MM-yy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [6, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale tg.
 */
goog.i18n.DateTimeSymbols_tg = {
  ERAS: ['ПеМ', 'ПаМ'],
  ERANAMES: ['Пеш аз милод', 'ПаМ'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['Январ', 'Феврал', 'Март', 'Апрел', 'Май',
      'Июн', 'Июл', 'Август', 'Сентябр', 'Октябр',
      'Ноябр', 'Декабр'],
  STANDALONEMONTHS: ['Январ', 'Феврал', 'Март', 'Апрел',
      'Май', 'Июн', 'Июл', 'Август', 'Сентябр',
      'Октябр', 'Ноябр', 'Декабр'],
  SHORTMONTHS: ['Янв', 'Фев', 'Мар', 'Апр', 'Май', 'Июн',
      'Июл', 'Авг', 'Сен', 'Окт', 'Ноя', 'Дек'],
  STANDALONESHORTMONTHS: ['Янв', 'Фев', 'Мар', 'Апр', 'Май',
      'Июн', 'Июл', 'Авг', 'Сен', 'Окт', 'Ноя', 'Дек'],
  WEEKDAYS: ['Якшанбе', 'Душанбе', 'Сешанбе',
      'Чоршанбе', 'Панҷшанбе', 'Ҷумъа', 'Шанбе'],
  STANDALONEWEEKDAYS: ['Якшанбе', 'Душанбе', 'Сешанбе',
      'Чоршанбе', 'Панҷшанбе', 'Ҷумъа', 'Шанбе'],
  SHORTWEEKDAYS: ['Яшб', 'Дшб', 'Сшб', 'Чшб', 'Пшб', 'Ҷмъ',
      'Шнб'],
  STANDALONESHORTWEEKDAYS: ['Яшб', 'Дшб', 'Сшб', 'Чшб', 'Пшб',
      'Ҷмъ', 'Шнб'],
  NARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONENARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['пе. чо.', 'па. чо.'],
  DATEFORMATS: ['EEEE, y MMMM dd', 'y MMMM d', 'y MMM d', 'yy/MM/dd'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale tg_Cyrl.
 */
goog.i18n.DateTimeSymbols_tg_Cyrl = goog.i18n.DateTimeSymbols_tg;


/**
 * Date/time formatting symbols for locale tg_Cyrl_TJ.
 */
goog.i18n.DateTimeSymbols_tg_Cyrl_TJ = goog.i18n.DateTimeSymbols_tg;


/**
 * Date/time formatting symbols for locale tg_TJ.
 */
goog.i18n.DateTimeSymbols_tg_TJ = goog.i18n.DateTimeSymbols_tg;


/**
 * Date/time formatting symbols for locale th_TH.
 */
goog.i18n.DateTimeSymbols_th_TH = {
  ERAS: ['ปีก่อน ค.ศ.', 'ค.ศ.'],
  ERANAMES: ['ปีก่อนคริสต์ศักราช',
      'คริสต์ศักราช'],
  NARROWMONTHS: ['ม', 'ก', 'ม', 'ม', 'พ', 'ม', 'ก', 'ส', 'ก',
      'ต', 'พ', 'ธ'],
  STANDALONENARROWMONTHS: ['ม.ค.', 'ก.พ.', 'มี.ค.', 'เม.ย.',
      'พ.ค.', 'มิ.ย.', 'ก.ค.', 'ส.ค.', 'ก.ย.', 'ต.ค.',
      'พ.ย.', 'ธ.ค.'],
  MONTHS: ['มกราคม', 'กุมภาพันธ์',
      'มีนาคม', 'เมษายน', 'พฤษภาคม',
      'มิถุนายน', 'กรกฎาคม',
      'สิงหาคม', 'กันยายน', 'ตุลาคม',
      'พฤศจิกายน', 'ธันวาคม'],
  STANDALONEMONTHS: ['มกราคม', 'กุมภาพันธ์',
      'มีนาคม', 'เมษายน', 'พฤษภาคม',
      'มิถุนายน', 'กรกฎาคม',
      'สิงหาคม', 'กันยายน', 'ตุลาคม',
      'พฤศจิกายน', 'ธันวาคม'],
  SHORTMONTHS: ['ม.ค.', 'ก.พ.', 'มี.ค.', 'เม.ย.',
      'พ.ค.', 'มิ.ย.', 'ก.ค.', 'ส.ค.', 'ก.ย.', 'ต.ค.',
      'พ.ย.', 'ธ.ค.'],
  STANDALONESHORTMONTHS: ['ม.ค.', 'ก.พ.', 'มี.ค.', 'เม.ย.',
      'พ.ค.', 'มิ.ย.', 'ก.ค.', 'ส.ค.', 'ก.ย.', 'ต.ค.',
      'พ.ย.', 'ธ.ค.'],
  WEEKDAYS: ['วันอาทิตย์', 'วันจันทร์',
      'วันอังคาร', 'วันพุธ',
      'วันพฤหัสบดี', 'วันศุกร์',
      'วันเสาร์'],
  STANDALONEWEEKDAYS: ['วันอาทิตย์',
      'วันจันทร์', 'วันอังคาร',
      'วันพุธ', 'วันพฤหัสบดี',
      'วันศุกร์', 'วันเสาร์'],
  SHORTWEEKDAYS: ['อา.', 'จ.', 'อ.', 'พ.', 'พฤ.', 'ศ.', 'ส.'],
  STANDALONESHORTWEEKDAYS: ['อา.', 'จ.', 'อ.', 'พ.', 'พฤ.',
      'ศ.', 'ส.'],
  NARROWWEEKDAYS: ['อ', 'จ', 'อ', 'พ', 'พ', 'ศ', 'ส'],
  STANDALONENARROWWEEKDAYS: ['อ', 'จ', 'อ', 'พ', 'พ', 'ศ', 'ส'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['ไตรมาส 1', 'ไตรมาส 2',
      'ไตรมาส 3', 'ไตรมาส 4'],
  AMPMS: ['ก่อนเที่ยง', 'หลังเที่ยง'],
  DATEFORMATS: ['EEEEที่ d MMMM G y', 'd MMMM y', 'd MMM y', 'd/M/yyyy'],
  TIMEFORMATS: [
      'H นาฬิกา m นาที ss วินาที zzzz',
      'H นาฬิกา m นาที ss วินาที z', 'H:mm:ss',
      'H:mm'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale ti.
 */
goog.i18n.DateTimeSymbols_ti = {
  ERAS: ['ዓ/ዓ', 'ዓ/ም'],
  ERANAMES: ['ዓ/ዓ', 'ዓ/ም'],
  NARROWMONTHS: ['ጃ', 'ፌ', 'ማ', 'ኤ', 'ሜ', 'ጁ', 'ጁ', 'ኦ', 'ሴ',
      'ኦ', 'ኖ', 'ዲ'],
  STANDALONENARROWMONTHS: ['ጃ', 'ፌ', 'ማ', 'ኤ', 'ሜ', 'ጁ', 'ጁ',
      'ኦ', 'ሴ', 'ኦ', 'ኖ', 'ዲ'],
  MONTHS: ['ጃንዩወሪ', 'ፌብሩወሪ', 'ማርች', 'ኤፕረል',
      'ሜይ', 'ጁን', 'ጁላይ', 'ኦገስት', 'ሴፕቴምበር',
      'ኦክተውበር', 'ኖቬምበር', 'ዲሴምበር'],
  STANDALONEMONTHS: ['ጃንዩወሪ', 'ፌብሩወሪ', 'ማርች',
      'ኤፕረል', 'ሜይ', 'ጁን', 'ጁላይ', 'ኦገስት',
      'ሴፕቴምበር', 'ኦክተውበር', 'ኖቬምበር',
      'ዲሴምበር'],
  SHORTMONTHS: ['ጃንዩ', 'ፌብሩ', 'ማርች', 'ኤፕረ', 'ሜይ',
      'ጁን', 'ጁላይ', 'ኦገስ', 'ሴፕቴ', 'ኦክተ', 'ኖቬም',
      'ዲሴም'],
  STANDALONESHORTMONTHS: ['ጃንዩ', 'ፌብሩ', 'ማርች', 'ኤፕረ',
      'ሜይ', 'ጁን', 'ጁላይ', 'ኦገስ', 'ሴፕቴ', 'ኦክተ',
      'ኖቬም', 'ዲሴም'],
  WEEKDAYS: ['ሰንበት', 'ሰኑይ', 'ሠሉስ', 'ረቡዕ', 'ኃሙስ',
      'ዓርቢ', 'ቀዳም'],
  STANDALONEWEEKDAYS: ['ሰንበት', 'ሰኑይ', 'ሠሉስ', 'ረቡዕ',
      'ኃሙስ', 'ዓርቢ', 'ቀዳም'],
  SHORTWEEKDAYS: ['ሰንበት', 'ሰኑይ', 'ሠሉስ', 'ረቡዕ',
      'ኃሙስ', 'ዓርቢ', 'ቀዳም'],
  STANDALONESHORTWEEKDAYS: ['ሰንበት', 'ሰኑይ', 'ሠሉስ',
      'ረቡዕ', 'ኃሙስ', 'ዓርቢ', 'ቀዳም'],
  NARROWWEEKDAYS: ['ሰ', 'ሰ', 'ሠ', 'ረ', 'ኃ', 'ዓ', 'ቀ'],
  STANDALONENARROWWEEKDAYS: ['ሰ', 'ሰ', 'ሠ', 'ረ', 'ኃ', 'ዓ', 'ቀ'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['ንጉሆ ሰዓተ', 'ድሕር ሰዓት'],
  DATEFORMATS: ['EEEE፣ dd MMMM መዓልቲ y G', 'dd MMMM y', 'dd-MMM-y',
      'dd/MM/yy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 5,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 1
};


/**
 * Date/time formatting symbols for locale ti_ER.
 */
goog.i18n.DateTimeSymbols_ti_ER = {
  ERAS: ['ዓ/ዓ', 'ዓ/ም'],
  ERANAMES: ['ዓ/ዓ', 'ዓ/ም'],
  NARROWMONTHS: ['ጃ', 'ፌ', 'ማ', 'ኤ', 'ሜ', 'ጁ', 'ጁ', 'ኦ', 'ሴ',
      'ኦ', 'ኖ', 'ዲ'],
  STANDALONENARROWMONTHS: ['ጃ', 'ፌ', 'ማ', 'ኤ', 'ሜ', 'ጁ', 'ጁ',
      'ኦ', 'ሴ', 'ኦ', 'ኖ', 'ዲ'],
  MONTHS: ['ጥሪ', 'ለካቲት', 'መጋቢት', 'ሚያዝያ',
      'ግንቦት', 'ሰነ', 'ሓምለ', 'ነሓሰ', 'መስከረም',
      'ጥቅምቲ', 'ሕዳር', 'ታሕሳስ'],
  STANDALONEMONTHS: ['ጥሪ', 'ለካቲት', 'መጋቢት', 'ሚያዝያ',
      'ግንቦት', 'ሰነ', 'ሓምለ', 'ነሓሰ', 'መስከረም',
      'ጥቅምቲ', 'ሕዳር', 'ታሕሳስ'],
  SHORTMONTHS: ['ጥሪ', 'ለካቲ', 'መጋቢ', 'ሚያዝ', 'ግንቦ',
      'ሰነ', 'ሓምለ', 'ነሓሰ', 'መስከ', 'ጥቅም', 'ሕዳር',
      'ታሕሳ'],
  STANDALONESHORTMONTHS: ['ጥሪ', 'ለካቲ', 'መጋቢ', 'ሚያዝ',
      'ግንቦ', 'ሰነ', 'ሓምለ', 'ነሓሰ', 'መስከ', 'ጥቅም',
      'ሕዳር', 'ታሕሳ'],
  WEEKDAYS: ['ሰንበት', 'ሰኑይ', 'ሰሉስ', 'ረቡዕ', 'ሓሙስ',
      'ዓርቢ', 'ቀዳም'],
  STANDALONEWEEKDAYS: ['ሰንበት', 'ሰኑይ', 'ሰሉስ', 'ረቡዕ',
      'ሓሙስ', 'ዓርቢ', 'ቀዳም'],
  SHORTWEEKDAYS: ['ሰንበት', 'ሰኑይ', 'ሰሉስ', 'ረቡዕ',
      'ሓሙስ', 'ዓርቢ', 'ቀዳም'],
  STANDALONESHORTWEEKDAYS: ['ሰንበት', 'ሰኑይ', 'ሰሉስ',
      'ረቡዕ', 'ሓሙስ', 'ዓርቢ', 'ቀዳም'],
  NARROWWEEKDAYS: ['ሰ', 'ሰ', 'ሠ', 'ረ', 'ኃ', 'ዓ', 'ቀ'],
  STANDALONENARROWWEEKDAYS: ['ሰ', 'ሰ', 'ሠ', 'ረ', 'ኃ', 'ዓ', 'ቀ'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['ንጉሆ ሰዓተ', 'ድሕር ሰዓት'],
  DATEFORMATS: ['EEEE፡ dd MMMM መዓልቲ y G', 'dd MMMM y', 'dd-MMM-y',
      'dd/MM/yy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 5,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 1
};


/**
 * Date/time formatting symbols for locale ti_ET.
 */
goog.i18n.DateTimeSymbols_ti_ET = goog.i18n.DateTimeSymbols_ti;


/**
 * Date/time formatting symbols for locale tig.
 */
goog.i18n.DateTimeSymbols_tig = {
  ERAS: ['ዓ/ዓ', 'ዓ/ም'],
  ERANAMES: ['ዓ/ዓ', 'ዓ/ም'],
  NARROWMONTHS: ['ጃ', 'ፌ', 'ማ', 'ኤ', 'ሜ', 'ጁ', 'ጁ', 'ኦ', 'ሴ',
      'ኦ', 'ኖ', 'ዲ'],
  STANDALONENARROWMONTHS: ['ጃ', 'ፌ', 'ማ', 'ኤ', 'ሜ', 'ጁ', 'ጁ',
      'ኦ', 'ሴ', 'ኦ', 'ኖ', 'ዲ'],
  MONTHS: ['ጃንዩወሪ', 'ፌብሩወሪ', 'ማርች', 'ኤፕረል',
      'ሜይ', 'ጁን', 'ጁላይ', 'ኦገስት', 'ሴፕቴምበር',
      'ኦክተውበር', 'ኖቬምበር', 'ዲሴምበር'],
  STANDALONEMONTHS: ['ጃንዩወሪ', 'ፌብሩወሪ', 'ማርች',
      'ኤፕረል', 'ሜይ', 'ጁን', 'ጁላይ', 'ኦገስት',
      'ሴፕቴምበር', 'ኦክተውበር', 'ኖቬምበር',
      'ዲሴምበር'],
  SHORTMONTHS: ['ጃንዩ', 'ፌብሩ', 'ማርች', 'ኤፕረ', 'ሜይ',
      'ጁን', 'ጁላይ', 'ኦገስ', 'ሴፕቴ', 'ኦክተ', 'ኖቬም',
      'ዲሴም'],
  STANDALONESHORTMONTHS: ['ጃንዩ', 'ፌብሩ', 'ማርች', 'ኤፕረ',
      'ሜይ', 'ጁን', 'ጁላይ', 'ኦገስ', 'ሴፕቴ', 'ኦክተ',
      'ኖቬም', 'ዲሴም'],
  WEEKDAYS: ['ሰንበት ዓባይ', 'ሰኖ', 'ታላሸኖ',
      'ኣረርባዓ', 'ከሚሽ', 'ጅምዓት', 'ሰንበት ንኢሽ'],
  STANDALONEWEEKDAYS: ['ሰንበት ዓባይ', 'ሰኖ', 'ታላሸኖ',
      'ኣረርባዓ', 'ከሚሽ', 'ጅምዓት', 'ሰንበት ንኢሽ'],
  SHORTWEEKDAYS: ['ሰ/ዓ', 'ሰኖ', 'ታላሸ', 'ኣረር', 'ከሚሽ',
      'ጅምዓ', 'ሰ/ን'],
  STANDALONESHORTWEEKDAYS: ['ሰ/ዓ', 'ሰኖ', 'ታላሸ', 'ኣረር',
      'ከሚሽ', 'ጅምዓ', 'ሰ/ን'],
  NARROWWEEKDAYS: ['ሰ', 'ሰ', 'ታ', 'ኣ', 'ከ', 'ጅ', 'ሰ'],
  STANDALONENARROWWEEKDAYS: ['ሰ', 'ሰ', 'ታ', 'ኣ', 'ከ', 'ጅ', 'ሰ'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['ቀደም ሰርምዕል', 'ሓቆ ስርምዕል'],
  DATEFORMATS: ['EEEE፡ dd MMMM ዮም y G', 'dd MMMM y', 'dd-MMM-y',
      'dd/MM/yy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale tig_ER.
 */
goog.i18n.DateTimeSymbols_tig_ER = goog.i18n.DateTimeSymbols_tig;


/**
 * Date/time formatting symbols for locale tl_PH.
 */
goog.i18n.DateTimeSymbols_tl_PH = {
  ERAS: ['BCE', 'CE'],
  ERANAMES: ['BCE', 'CE'],
  NARROWMONTHS: ['E', 'P', 'M', 'A', 'M', 'H', 'H', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['E', 'P', 'M', 'A', 'M', 'H', 'H', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['Enero', 'Pebrero', 'Marso', 'Abril', 'Mayo', 'Hunyo', 'Hulyo',
      'Agosto', 'Setyembre', 'Oktubre', 'Nobyembre', 'Disyembre'],
  STANDALONEMONTHS: ['Enero', 'Pebrero', 'Marso', 'Abril', 'Mayo', 'Hunyo',
      'Hulyo', 'Agosto', 'Setyembre', 'Oktubre', 'Nobyembre', 'Disyembre'],
  SHORTMONTHS: ['Ene', 'Peb', 'Mar', 'Abr', 'May', 'Hun', 'Hul', 'Ago', 'Set',
      'Okt', 'Nob', 'Dis'],
  STANDALONESHORTMONTHS: ['Ene', 'Peb', 'Mar', 'Abr', 'May', 'Hun', 'Hul',
      'Ago', 'Set', 'Okt', 'Nob', 'Dis'],
  WEEKDAYS: ['Linggo', 'Lunes', 'Martes', 'Miyerkules', 'Huwebes', 'Biyernes',
      'Sabado'],
  STANDALONEWEEKDAYS: ['Linggo', 'Lunes', 'Martes', 'Miyerkules', 'Huwebes',
      'Biyernes', 'Sabado'],
  SHORTWEEKDAYS: ['Lin', 'Lun', 'Mar', 'Mye', 'Huw', 'Bye', 'Sab'],
  STANDALONESHORTWEEKDAYS: ['Lin', 'Lun', 'Mar', 'Miy', 'Huw', 'Biy', 'Sab'],
  NARROWWEEKDAYS: ['L', 'L', 'M', 'M', 'H', 'B', 'S'],
  STANDALONENARROWWEEKDAYS: ['L', 'L', 'M', 'M', 'H', 'B', 'S'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, MMMM dd y', 'MMMM d, y', 'MMM d, y', 'M/d/yy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale tn.
 */
goog.i18n.DateTimeSymbols_tn = {
  ERAS: ['BCE', 'CE'],
  ERANAMES: ['BCE', 'CE'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['Ferikgong', 'Tlhakole', 'Mopitlo', 'Moranang', 'Motsheganang',
      'Seetebosigo', 'Phukwi', 'Phatwe', 'Lwetse', 'Diphalane', 'Ngwanatsele',
      'Sedimonthole'],
  STANDALONEMONTHS: ['Ferikgong', 'Tlhakole', 'Mopitlo', 'Moranang',
      'Motsheganang', 'Seetebosigo', 'Phukwi', 'Phatwe', 'Lwetse', 'Diphalane',
      'Ngwanatsele', 'Sedimonthole'],
  SHORTMONTHS: ['Fer', 'Tlh', 'Mop', 'Mor', 'Mot', 'See', 'Phu', 'Pha', 'Lwe',
      'Dip', 'Ngw', 'Sed'],
  STANDALONESHORTMONTHS: ['Fer', 'Tlh', 'Mop', 'Mor', 'Mot', 'See', 'Phu',
      'Pha', 'Lwe', 'Dip', 'Ngw', 'Sed'],
  WEEKDAYS: ['Tshipi', 'Mosopulogo', 'Labobedi', 'Laboraro', 'Labone',
      'Labotlhano', 'Matlhatso'],
  STANDALONEWEEKDAYS: ['Tshipi', 'Mosopulogo', 'Labobedi', 'Laboraro', 'Labone',
      'Labotlhano', 'Matlhatso'],
  SHORTWEEKDAYS: ['Tsh', 'Mos', 'Bed', 'Rar', 'Ne', 'Tla', 'Mat'],
  STANDALONESHORTWEEKDAYS: ['Tsh', 'Mos', 'Bed', 'Rar', 'Ne', 'Tla', 'Mat'],
  NARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONENARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, y MMMM dd', 'y MMMM d', 'y MMM d', 'yyyy-MM-dd'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale tn_ZA.
 */
goog.i18n.DateTimeSymbols_tn_ZA = goog.i18n.DateTimeSymbols_tn;


/**
 * Date/time formatting symbols for locale to.
 */
goog.i18n.DateTimeSymbols_to = {
  ERAS: ['KM', 'TS'],
  ERANAMES: ['ki muʻa', 'taʻu ʻo Sīsū'],
  NARROWMONTHS: ['S', 'F', 'M', 'E', 'M', 'S', 'S', 'A', 'S', 'O', 'N', 'T'],
  STANDALONENARROWMONTHS: ['S', 'F', 'M', 'E', 'M', 'S', 'S', 'A', 'S', 'O',
      'N', 'T'],
  MONTHS: ['Sānuali', 'Fēpueli', 'Maʻasi', 'ʻEpeleli', 'Mē', 'Sune',
      'Siulai', 'ʻAokosi', 'Sepitema', 'ʻOkatopa', 'Nōvema', 'Tīsema'],
  STANDALONEMONTHS: ['Sānuali', 'Fēpueli', 'Maʻasi', 'ʻEpeleli', 'Mē',
      'Sune', 'Siulai', 'ʻAokosi', 'Sepitema', 'ʻOkatopa', 'Nōvema',
      'Tīsema'],
  SHORTMONTHS: ['Sān', 'Fēp', 'Maʻa', 'ʻEpe', 'Mē', 'Sun', 'Siu', 'ʻAok',
      'Sep', 'ʻOka', 'Nōv', 'Tīs'],
  STANDALONESHORTMONTHS: ['Sān', 'Fēp', 'Maʻa', 'ʻEpe', 'Mē', 'Sun', 'Siu',
      'ʻAok', 'Sep', 'ʻOka', 'Nōv', 'Tīs'],
  WEEKDAYS: ['Sāpate', 'Mōnite', 'Tūsite', 'Pulelulu', 'Tuʻapulelulu',
      'Falaite', 'Tokonaki'],
  STANDALONEWEEKDAYS: ['Sāpate', 'Mōnite', 'Tūsite', 'Pulelulu',
      'Tuʻapulelulu', 'Falaite', 'Tokonaki'],
  SHORTWEEKDAYS: ['Sāp', 'Mōn', 'Tūs', 'Pul', 'Tuʻa', 'Fal', 'Tok'],
  STANDALONESHORTWEEKDAYS: ['Sāp', 'Mōn', 'Tūs', 'Pul', 'Tuʻa', 'Fal',
      'Tok'],
  NARROWWEEKDAYS: ['S', 'M', 'T', 'P', 'T', 'F', 'T'],
  STANDALONENARROWWEEKDAYS: ['S', 'M', 'T', 'P', 'T', 'F', 'T'],
  SHORTQUARTERS: ['K1', 'K2', 'K3', 'K4'],
  QUARTERS: ['kuata ʻuluaki', 'kuata ua', 'kuata tolu', 'kuata fā'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE d MMMM y', 'd MMMM y', 'd MMM y', 'd/M/yy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale to_TO.
 */
goog.i18n.DateTimeSymbols_to_TO = goog.i18n.DateTimeSymbols_to;


/**
 * Date/time formatting symbols for locale tr_TR.
 */
goog.i18n.DateTimeSymbols_tr_TR = {
  ERAS: ['MÖ', 'MS'],
  ERANAMES: ['Milattan Önce', 'Milattan Sonra'],
  NARROWMONTHS: ['O', 'Ş', 'M', 'N', 'M', 'H', 'T', 'A', 'E', 'E', 'K', 'A'],
  STANDALONENARROWMONTHS: ['O', 'Ş', 'M', 'N', 'M', 'H', 'T', 'A', 'E', 'E',
      'K', 'A'],
  MONTHS: ['Ocak', 'Şubat', 'Mart', 'Nisan', 'Mayıs', 'Haziran', 'Temmuz',
      'Ağustos', 'Eylül', 'Ekim', 'Kasım', 'Aralık'],
  STANDALONEMONTHS: ['Ocak', 'Şubat', 'Mart', 'Nisan', 'Mayıs', 'Haziran',
      'Temmuz', 'Ağustos', 'Eylül', 'Ekim', 'Kasım', 'Aralık'],
  SHORTMONTHS: ['Oca', 'Şub', 'Mar', 'Nis', 'May', 'Haz', 'Tem', 'Ağu', 'Eyl',
      'Eki', 'Kas', 'Ara'],
  STANDALONESHORTMONTHS: ['Oca', 'Şub', 'Mar', 'Nis', 'May', 'Haz', 'Tem',
      'Ağu', 'Eyl', 'Eki', 'Kas', 'Ara'],
  WEEKDAYS: ['Pazar', 'Pazartesi', 'Salı', 'Çarşamba', 'Perşembe', 'Cuma',
      'Cumartesi'],
  STANDALONEWEEKDAYS: ['Pazar', 'Pazartesi', 'Salı', 'Çarşamba', 'Perşembe',
      'Cuma', 'Cumartesi'],
  SHORTWEEKDAYS: ['Paz', 'Pzt', 'Sal', 'Çar', 'Per', 'Cum', 'Cmt'],
  STANDALONESHORTWEEKDAYS: ['Paz', 'Pzt', 'Sal', 'Çar', 'Per', 'Cum', 'Cmt'],
  NARROWWEEKDAYS: ['P', 'P', 'S', 'Ç', 'P', 'C', 'C'],
  STANDALONENARROWWEEKDAYS: ['P', 'P', 'S', 'Ç', 'P', 'C', 'C'],
  SHORTQUARTERS: ['Ç1', 'Ç2', 'Ç3', 'Ç4'],
  QUARTERS: ['1. çeyrek', '2. çeyrek', '3. çeyrek', '4. çeyrek'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['dd MMMM y EEEE', 'dd MMMM y', 'dd MMM y', 'dd MM yyyy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale trv.
 */
goog.i18n.DateTimeSymbols_trv = {
  ERAS: ['BRY', 'BUY'],
  ERANAMES: ['Brah jikan Yisu Thulang', 'Bukuy jikan Yisu Thulang'],
  NARROWMONTHS: ['K', 'D', 'T', 'S', 'R', 'M', 'E', 'P', 'A', 'M', 'K', 'D'],
  STANDALONENARROWMONTHS: ['K', 'D', 'T', 'S', 'R', 'M', 'E', 'P', 'A', 'M',
      'K', 'D'],
  MONTHS: ['Kingal idas', 'Dha idas', 'Tru idas', 'Spat idas', 'Rima idas',
      'Mataru idas', 'Empitu idas', 'Maspat idas', 'Mngari idas', 'Maxal idas',
      'Maxal kingal idas', 'Maxal dha idas'],
  STANDALONEMONTHS: ['Kingal idas', 'Dha idas', 'Tru idas', 'Spat idas',
      'Rima idas', 'Mataru idas', 'Empitu idas', 'Maspat idas', 'Mngari idas',
      'Maxal idas', 'Maxal kingal idas', 'Maxal dha idas'],
  SHORTMONTHS: ['Kii', 'Dhi', 'Tri', 'Spi', 'Rii', 'Mti', 'Emi', 'Mai', 'Mni',
      'Mxi', 'Mxk', 'Mxd'],
  STANDALONESHORTMONTHS: ['Kii', 'Dhi', 'Tri', 'Spi', 'Rii', 'Mti', 'Emi',
      'Mai', 'Mni', 'Mxi', 'Mxk', 'Mxd'],
  WEEKDAYS: ['Jiyax sngayan', 'tgKingal jiyax iyax sngayan',
      'tgDha jiyax iyax sngayan', 'tgTru jiyax iyax sngayan',
      'tgSpac jiyax iyax sngayan', 'tgRima jiyax iyax sngayan',
      'tgMataru jiyax iyax sngayan'],
  STANDALONEWEEKDAYS: ['Jiyax sngayan', 'tgKingal jiyax iyax sngayan',
      'tgDha jiyax iyax sngayan', 'tgTru jiyax iyax sngayan',
      'tgSpac jiyax iyax sngayan', 'tgRima jiyax iyax sngayan',
      'tgMataru jiyax iyax sngayan'],
  SHORTWEEKDAYS: ['Emp', 'Kin', 'Dha', 'Tru', 'Spa', 'Rim', 'Mat'],
  STANDALONESHORTWEEKDAYS: ['Emp', 'Kin', 'Dha', 'Tru', 'Spa', 'Rim', 'Mat'],
  NARROWWEEKDAYS: ['E', 'K', 'D', 'T', 'S', 'R', 'M'],
  STANDALONENARROWWEEKDAYS: ['E', 'K', 'D', 'T', 'S', 'R', 'M'],
  SHORTQUARTERS: ['mn1', 'mn2', 'mn3', 'mn4'],
  QUARTERS: ['mnprxan', 'mndha', 'mntru', 'mnspat'],
  AMPMS: ['Brax kndaax', 'Baubau kndaax'],
  DATEFORMATS: ['EEEE, y MMMM dd', 'y MMMM d', 'y MMM d', 'yyyy-MM-dd'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale trv_TW.
 */
goog.i18n.DateTimeSymbols_trv_TW = goog.i18n.DateTimeSymbols_trv;


/**
 * Date/time formatting symbols for locale ts.
 */
goog.i18n.DateTimeSymbols_ts = {
  ERAS: ['BCE', 'CE'],
  ERANAMES: ['BCE', 'CE'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['Sunguti', 'Nyenyenyani', 'Nyenyankulu', 'Dzivamisoko', 'Mudyaxihi',
      'Khotavuxika', 'Mawuwani', 'Mhawuri', 'Ndzhati', 'Nhlangula', 'Hukuri',
      'N\'wendzamhala'],
  STANDALONEMONTHS: ['Sunguti', 'Nyenyenyani', 'Nyenyankulu', 'Dzivamisoko',
      'Mudyaxihi', 'Khotavuxika', 'Mawuwani', 'Mhawuri', 'Ndzhati', 'Nhlangula',
      'Hukuri', 'N\'wendzamhala'],
  SHORTMONTHS: ['Sun', 'Yan', 'Kul', 'Dzi', 'Mud', 'Kho', 'Maw', 'Mha', 'Ndz',
      'Nhl', 'Huk', 'N\'w'],
  STANDALONESHORTMONTHS: ['Sun', 'Yan', 'Kul', 'Dzi', 'Mud', 'Kho', 'Maw',
      'Mha', 'Ndz', 'Nhl', 'Huk', 'N\'w'],
  WEEKDAYS: ['Sonto', 'Musumbhunuku', 'Ravumbirhi', 'Ravunharhu', 'Ravumune',
      'Ravuntlhanu', 'Mugqivela'],
  STANDALONEWEEKDAYS: ['Sonto', 'Musumbhunuku', 'Ravumbirhi', 'Ravunharhu',
      'Ravumune', 'Ravuntlhanu', 'Mugqivela'],
  SHORTWEEKDAYS: ['Son', 'Mus', 'Bir', 'Har', 'Ne', 'Tlh', 'Mug'],
  STANDALONESHORTWEEKDAYS: ['Son', 'Mus', 'Bir', 'Har', 'Ne', 'Tlh', 'Mug'],
  NARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONENARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTQUARTERS: ['K1', 'K2', 'K3', 'K4'],
  QUARTERS: ['Kotara yo sungula', 'Kotara ya vumbirhi', 'Kotara ya vunharhu',
      'Kotara ya vumune'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, y MMMM dd', 'y MMMM d', 'y MMM d', 'yyyy-MM-dd'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale ts_ZA.
 */
goog.i18n.DateTimeSymbols_ts_ZA = goog.i18n.DateTimeSymbols_ts;


/**
 * Date/time formatting symbols for locale tt.
 */
goog.i18n.DateTimeSymbols_tt = {
  ERAS: ['BCE', 'CE'],
  ERANAMES: ['BCE', 'CE'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONEMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11',
      '12'],
  SHORTMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONESHORTMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  WEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONEWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONESHORTWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  NARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONENARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['d MMMM y', 'd MMMM y', 'dd.MM.yyyy', 'dd.MM.yyyy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'H:mm:ss z', 'H:mm:ss', 'H:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale tt_RU.
 */
goog.i18n.DateTimeSymbols_tt_RU = goog.i18n.DateTimeSymbols_tt;


/**
 * Date/time formatting symbols for locale ug.
 */
goog.i18n.DateTimeSymbols_ug = {
  ERAS: ['BCE', 'CE'],
  ERANAMES: ['BCE', 'CE'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONEMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11',
      '12'],
  SHORTMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONESHORTMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  WEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONEWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONESHORTWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  NARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONENARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, y MMMM dd', 'y MMMM d', 'y MMM d', 'yyyy-MM-dd'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale ug_Arab.
 */
goog.i18n.DateTimeSymbols_ug_Arab = goog.i18n.DateTimeSymbols_ug;


/**
 * Date/time formatting symbols for locale ug_Arab_CN.
 */
goog.i18n.DateTimeSymbols_ug_Arab_CN = goog.i18n.DateTimeSymbols_ug;


/**
 * Date/time formatting symbols for locale ug_CN.
 */
goog.i18n.DateTimeSymbols_ug_CN = goog.i18n.DateTimeSymbols_ug;


/**
 * Date/time formatting symbols for locale uk_UA.
 */
goog.i18n.DateTimeSymbols_uk_UA = {
  ERAS: ['до н.е.', 'н.е.'],
  ERANAMES: ['до нашої ери', 'нашої ери'],
  NARROWMONTHS: ['С', 'Л', 'Б', 'К', 'Т', 'Ч', 'Л', 'С', 'В', 'Ж',
      'Л', 'Г'],
  STANDALONENARROWMONTHS: ['С', 'Л', 'Б', 'К', 'Т', 'Ч', 'Л', 'С', 'В',
      'Ж', 'Л', 'Г'],
  MONTHS: ['січня', 'лютого', 'березня', 'квітня',
      'травня', 'червня', 'липня', 'серпня',
      'вересня', 'жовтня', 'листопада', 'грудня'],
  STANDALONEMONTHS: ['Січень', 'Лютий', 'Березень',
      'Квітень', 'Травень', 'Червень', 'Липень',
      'Серпень', 'Вересень', 'Жовтень',
      'Листопад', 'Грудень'],
  SHORTMONTHS: ['січ.', 'лют.', 'бер.', 'квіт.', 'трав.',
      'черв.', 'лип.', 'серп.', 'вер.', 'жовт.', 'лист.',
      'груд.'],
  STANDALONESHORTMONTHS: ['Січ', 'Лют', 'Бер', 'Кві', 'Тра',
      'Чер', 'Лип', 'Сер', 'Вер', 'Жов', 'Лис', 'Гру'],
  WEEKDAYS: ['Неділя', 'Понеділок', 'Вівторок',
      'Середа', 'Четвер', 'Пʼятниця', 'Субота'],
  STANDALONEWEEKDAYS: ['Неділя', 'Понеділок', 'Вівторок',
      'Середа', 'Четвер', 'Пʼятниця', 'Субота'],
  SHORTWEEKDAYS: ['Нд', 'Пн', 'Вт', 'Ср', 'Чт', 'Пт', 'Сб'],
  STANDALONESHORTWEEKDAYS: ['Нд', 'Пн', 'Вт', 'Ср', 'Чт', 'Пт',
      'Сб'],
  NARROWWEEKDAYS: ['Н', 'П', 'В', 'С', 'Ч', 'П', 'С'],
  STANDALONENARROWWEEKDAYS: ['Н', 'П', 'В', 'С', 'Ч', 'П', 'С'],
  SHORTQUARTERS: ['I кв.', 'II кв.', 'III кв.', 'IV кв.'],
  QUARTERS: ['I квартал', 'II квартал', 'III квартал',
      'IV квартал'],
  AMPMS: ['дп', 'пп'],
  DATEFORMATS: ['EEEE, d MMMM y \'р\'.', 'd MMMM y \'р\'.', 'd MMM y',
      'dd.MM.yy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale ur_IN.
 */
goog.i18n.DateTimeSymbols_ur_IN = {
  ERAS: ['ق م', 'عيسوی سن'],
  ERANAMES: ['قبل مسيح', 'عيسوی سن'],
  NARROWMONTHS: ['ج', 'ف', 'م', 'ا', 'م', 'ج', 'ج', 'ا', 'س', 'ا',
      'ن', 'د'],
  STANDALONENARROWMONTHS: ['ج', 'ف', 'م', 'ا', 'م', 'ج', 'ج', 'ا', 'س',
      'ا', 'ن', 'د'],
  MONTHS: ['جنوری', 'فروری', 'مار چ', 'اپريل', 'مئ',
      'جون', 'جولائ', 'اگست', 'ستمبر', 'اکتوبر',
      'نومبر', 'دسمبر'],
  STANDALONEMONTHS: ['جنوری', 'فروری', 'مار چ', 'اپريل',
      'مئ', 'جون', 'جولائ', 'اگست', 'ستمبر', 'اکتوبر',
      'نومبر', 'دسمبر'],
  SHORTMONTHS: ['جنوری', 'فروری', 'مار چ', 'اپريل', 'مئ',
      'جون', 'جولائ', 'اگست', 'ستمبر', 'اکتوبر',
      'نومبر', 'دسمبر'],
  STANDALONESHORTMONTHS: ['جنوری', 'فروری', 'مار چ', 'اپريل',
      'مئ', 'جون', 'جولائ', 'اگست', 'ستمبر', 'اکتوبر',
      'نومبر', 'دسمبر'],
  WEEKDAYS: ['اتوار', 'پير', 'منگل', 'بده', 'جمعرات',
      'جمعہ', 'ہفتہ'],
  STANDALONEWEEKDAYS: ['اتوار', 'پير', 'منگل', 'بده',
      'جمعرات', 'جمعہ', 'ہفتہ'],
  SHORTWEEKDAYS: ['اتوار', 'پير', 'منگل', 'بده', 'جمعرات',
      'جمعہ', 'ہفتہ'],
  STANDALONESHORTWEEKDAYS: ['اتوار', 'پير', 'منگل', 'بده',
      'جمعرات', 'جمعہ', 'ہفتہ'],
  NARROWWEEKDAYS: ['ا', 'پ', 'م', 'ب', 'ج', 'ج', 'ہ'],
  STANDALONENARROWWEEKDAYS: ['ا', 'پ', 'م', 'ب', 'ج', 'ج', 'ہ'],
  SHORTQUARTERS: ['1سہ ماہی', '2سہ ماہی', '3سہ ماہی',
      '4سہ ماہی'],
  QUARTERS: ['پہلی سہ ماہی', 'دوسری سہ ماہی',
      'تيسری سہ ماہی', 'چوتهی سہ ماہی'],
  AMPMS: ['قبل دوپہر', 'بعد دوپہر'],
  DATEFORMATS: ['EEEE, d, MMMM y', 'd, MMMM y', 'd, MMM y', 'd/M/yy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [6, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale ur_PK.
 */
goog.i18n.DateTimeSymbols_ur_PK = {
  ERAS: ['ق م', 'عيسوی سن'],
  ERANAMES: ['قبل مسيح', 'عيسوی سن'],
  NARROWMONTHS: ['ج', 'ف', 'م', 'ا', 'م', 'ج', 'ج', 'ا', 'س', 'ا',
      'ن', 'د'],
  STANDALONENARROWMONTHS: ['ج', 'ف', 'م', 'ا', 'م', 'ج', 'ج', 'ا', 'س',
      'ا', 'ن', 'د'],
  MONTHS: ['جنوری', 'فروری', 'مار چ', 'اپريل', 'مئ',
      'جون', 'جولائ', 'اگست', 'ستمبر', 'اکتوبر',
      'نومبر', 'دسمبر'],
  STANDALONEMONTHS: ['جنوری', 'فروری', 'مار چ', 'اپريل',
      'مئ', 'جون', 'جولائ', 'اگست', 'ستمبر', 'اکتوبر',
      'نومبر', 'دسمبر'],
  SHORTMONTHS: ['جنوری', 'فروری', 'مار چ', 'اپريل', 'مئ',
      'جون', 'جولائ', 'اگست', 'ستمبر', 'اکتوبر',
      'نومبر', 'دسمبر'],
  STANDALONESHORTMONTHS: ['جنوری', 'فروری', 'مار چ', 'اپريل',
      'مئ', 'جون', 'جولائ', 'اگست', 'ستمبر', 'اکتوبر',
      'نومبر', 'دسمبر'],
  WEEKDAYS: ['اتوار', 'پير', 'منگل', 'بده', 'جمعرات',
      'جمعہ', 'ہفتہ'],
  STANDALONEWEEKDAYS: ['اتوار', 'پير', 'منگل', 'بده',
      'جمعرات', 'جمعہ', 'ہفتہ'],
  SHORTWEEKDAYS: ['اتوار', 'پير', 'منگل', 'بده', 'جمعرات',
      'جمعہ', 'ہفتہ'],
  STANDALONESHORTWEEKDAYS: ['اتوار', 'پير', 'منگل', 'بده',
      'جمعرات', 'جمعہ', 'ہفتہ'],
  NARROWWEEKDAYS: ['ا', 'پ', 'م', 'ب', 'ج', 'ج', 'ہ'],
  STANDALONENARROWWEEKDAYS: ['ا', 'پ', 'م', 'ب', 'ج', 'ج', 'ہ'],
  SHORTQUARTERS: ['1سہ ماہی', '2سہ ماہی', '3سہ ماہی',
      '4سہ ماہی'],
  QUARTERS: ['پہلی سہ ماہی', 'دوسری سہ ماہی',
      'تيسری سہ ماہی', 'چوتهی سہ ماہی'],
  AMPMS: ['قبل دوپہر', 'بعد دوپہر'],
  DATEFORMATS: ['EEEE, d, MMMM y', 'd, MMMM y', 'd, MMM y', 'd/M/yy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale uz.
 */
goog.i18n.DateTimeSymbols_uz = {
  ERAS: ['BCE', 'CE'],
  ERANAMES: ['BCE', 'CE'],
  NARROWMONTHS: ['Я', 'Ф', 'М', 'А', 'М', 'И', 'И', 'А', 'С', 'О',
      'Н', 'Д'],
  STANDALONENARROWMONTHS: ['Я', 'Ф', 'М', 'А', 'М', 'И', 'И', 'А', 'С',
      'О', 'Н', 'Д'],
  MONTHS: ['Муҳаррам', 'Сафар', 'Рабиул-аввал',
      'Рабиул-охир', 'Жумодиул-уло',
      'Жумодиул-ухро', 'Ражаб', 'Шаъбон',
      'Рамазон', 'Шаввол', 'Зил-қаъда',
      'Зил-ҳижжа'],
  STANDALONEMONTHS: ['Муҳаррам', 'Сафар',
      'Рабиул-аввал', 'Рабиул-охир',
      'Жумодиул-уло', 'Жумодиул-ухро', 'Ражаб',
      'Шаъбон', 'Рамазон', 'Шаввол', 'Зил-қаъда',
      'Зил-ҳижжа'],
  SHORTMONTHS: ['Янв', 'Фев', 'Мар', 'Апр', 'Май', 'Июн',
      'Июл', 'Авг', 'Сен', 'Окт', 'Ноя', 'Дек'],
  STANDALONESHORTMONTHS: ['Янв', 'Фев', 'Мар', 'Апр', 'Май',
      'Июн', 'Июл', 'Авг', 'Сен', 'Окт', 'Ноя', 'Дек'],
  WEEKDAYS: ['якшанба', 'душанба', 'сешанба',
      'чоршанба', 'пайшанба', 'жума', 'шанба'],
  STANDALONEWEEKDAYS: ['якшанба', 'душанба', 'сешанба',
      'чоршанба', 'пайшанба', 'жума', 'шанба'],
  SHORTWEEKDAYS: ['Якш', 'Душ', 'Сеш', 'Чор', 'Пай', 'Жум',
      'Шан'],
  STANDALONESHORTWEEKDAYS: ['Якш', 'Душ', 'Сеш', 'Чор', 'Пай',
      'Жум', 'Шан'],
  NARROWWEEKDAYS: ['Я', 'Д', 'С', 'Ч', 'П', 'Ж', 'Ш'],
  STANDALONENARROWWEEKDAYS: ['Я', 'Д', 'С', 'Ч', 'П', 'Ж', 'Ш'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, y MMMM dd', 'y MMMM d', 'y MMM d', 'yy/MM/dd'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale uz_AF.
 */
goog.i18n.DateTimeSymbols_uz_AF = {
  ERAS: ['ق.م.', 'م.'],
  ERANAMES: ['ق.م.', 'م.'],
  NARROWMONTHS: ['Я', 'Ф', 'М', 'А', 'М', 'И', 'И', 'А', 'С', 'О',
      'Н', 'Д'],
  STANDALONENARROWMONTHS: ['Я', 'Ф', 'М', 'А', 'М', 'И', 'И', 'А', 'С',
      'О', 'Н', 'Д'],
  MONTHS: ['جنوری', 'فبروری', 'مارچ', 'اپریل', 'می',
      'جون', 'جولای', 'اگست', 'سپتمبر', 'اکتوبر',
      'نومبر', 'دسمبر'],
  STANDALONEMONTHS: ['جنوری', 'فبروری', 'مارچ', 'اپریل',
      'می', 'جون', 'جولای', 'اگست', 'سپتمبر',
      'اکتوبر', 'نومبر', 'دسمبر'],
  SHORTMONTHS: ['جنو', 'فبر', 'مار', 'اپر', 'مـی', 'جون',
      'جول', 'اگس', 'سپت', 'اکت', 'نوم', 'دسم'],
  STANDALONESHORTMONTHS: ['جنو', 'فبر', 'مار', 'اپر', 'مـی',
      'جون', 'جول', 'اگس', 'سپت', 'اکت', 'نوم', 'دسم'],
  WEEKDAYS: ['یکشنبه', 'دوشنبه', 'سه‌شنبه',
      'چهارشنبه', 'پنجشنبه', 'جمعه', 'شنبه'],
  STANDALONEWEEKDAYS: ['یکشنبه', 'دوشنبه', 'سه‌شنبه',
      'چهارشنبه', 'پنجشنبه', 'جمعه', 'شنبه'],
  SHORTWEEKDAYS: ['ی.', 'د.', 'س.', 'چ.', 'پ.', 'ج.', 'ش.'],
  STANDALONESHORTWEEKDAYS: ['ی.', 'د.', 'س.', 'چ.', 'پ.', 'ج.', 'ش.'],
  NARROWWEEKDAYS: ['Я', 'Д', 'С', 'Ч', 'П', 'Ж', 'Ш'],
  STANDALONENARROWWEEKDAYS: ['Я', 'Д', 'С', 'Ч', 'П', 'Ж', 'Ш'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['y نچی ییل d نچی MMMM EEEE کونی',
      'd نچی MMMM y', 'd MMM y', 'yyyy/M/d'],
  TIMEFORMATS: ['H:mm:ss (zzzz)', 'H:mm:ss (z)', 'H:mm:ss', 'H:mm'],
  FIRSTDAYOFWEEK: 5,
  WEEKENDRANGE: [3, 4],
  FIRSTWEEKCUTOFFDAY: 1
};


/**
 * Date/time formatting symbols for locale uz_Arab.
 */
goog.i18n.DateTimeSymbols_uz_Arab = {
  ERAS: ['ق.م.', 'م.'],
  ERANAMES: ['ق.م.', 'م.'],
  NARROWMONTHS: ['Я', 'Ф', 'М', 'А', 'М', 'И', 'И', 'А', 'С', 'О',
      'Н', 'Д'],
  STANDALONENARROWMONTHS: ['Я', 'Ф', 'М', 'А', 'М', 'И', 'И', 'А', 'С',
      'О', 'Н', 'Д'],
  MONTHS: ['جنوری', 'فبروری', 'مارچ', 'اپریل', 'می',
      'جون', 'جولای', 'اگست', 'سپتمبر', 'اکتوبر',
      'نومبر', 'دسمبر'],
  STANDALONEMONTHS: ['جنوری', 'فبروری', 'مارچ', 'اپریل',
      'می', 'جون', 'جولای', 'اگست', 'سپتمبر',
      'اکتوبر', 'نومبر', 'دسمبر'],
  SHORTMONTHS: ['جنو', 'فبر', 'مار', 'اپر', 'مـی', 'جون',
      'جول', 'اگس', 'سپت', 'اکت', 'نوم', 'دسم'],
  STANDALONESHORTMONTHS: ['جنو', 'فبر', 'مار', 'اپر', 'مـی',
      'جون', 'جول', 'اگس', 'سپت', 'اکت', 'نوم', 'دسم'],
  WEEKDAYS: ['یکشنبه', 'دوشنبه', 'سه‌شنبه',
      'چهارشنبه', 'پنجشنبه', 'جمعه', 'شنبه'],
  STANDALONEWEEKDAYS: ['یکشنبه', 'دوشنبه', 'سه‌شنبه',
      'چهارشنبه', 'پنجشنبه', 'جمعه', 'شنبه'],
  SHORTWEEKDAYS: ['ی.', 'د.', 'س.', 'چ.', 'پ.', 'ج.', 'ش.'],
  STANDALONESHORTWEEKDAYS: ['ی.', 'د.', 'س.', 'چ.', 'پ.', 'ج.', 'ش.'],
  NARROWWEEKDAYS: ['Я', 'Д', 'С', 'Ч', 'П', 'Ж', 'Ш'],
  STANDALONENARROWWEEKDAYS: ['Я', 'Д', 'С', 'Ч', 'П', 'Ж', 'Ш'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['y نچی ییل d نچی MMMM EEEE کونی',
      'd نچی MMMM y', 'd MMM y', 'yyyy/M/d'],
  TIMEFORMATS: ['H:mm:ss (zzzz)', 'H:mm:ss (z)', 'H:mm:ss', 'H:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale uz_Arab_AF.
 */
goog.i18n.DateTimeSymbols_uz_Arab_AF = goog.i18n.DateTimeSymbols_uz_Arab;


/**
 * Date/time formatting symbols for locale uz_Cyrl.
 */
goog.i18n.DateTimeSymbols_uz_Cyrl = goog.i18n.DateTimeSymbols_uz;


/**
 * Date/time formatting symbols for locale uz_Cyrl_UZ.
 */
goog.i18n.DateTimeSymbols_uz_Cyrl_UZ = goog.i18n.DateTimeSymbols_uz;


/**
 * Date/time formatting symbols for locale uz_Latn.
 */
goog.i18n.DateTimeSymbols_uz_Latn = {
  ERAS: ['BCE', 'CE'],
  ERANAMES: ['BCE', 'CE'],
  NARROWMONTHS: ['Y', 'F', 'M', 'A', 'M', 'I', 'I', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['Y', 'F', 'M', 'A', 'M', 'I', 'I', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['Муҳаррам', 'Сафар', 'Рабиул-аввал',
      'Рабиул-охир', 'Жумодиул-уло',
      'Жумодиул-ухро', 'Ражаб', 'Шаъбон',
      'Рамазон', 'Шаввол', 'Зил-қаъда',
      'Зил-ҳижжа'],
  STANDALONEMONTHS: ['Муҳаррам', 'Сафар',
      'Рабиул-аввал', 'Рабиул-охир',
      'Жумодиул-уло', 'Жумодиул-ухро', 'Ражаб',
      'Шаъбон', 'Рамазон', 'Шаввол', 'Зил-қаъда',
      'Зил-ҳижжа'],
  SHORTMONTHS: ['Yanv', 'Fev', 'Mar', 'Apr', 'May', 'Iyun', 'Iyul', 'Avg',
      'Sen', 'Okt', 'Noya', 'Dek'],
  STANDALONESHORTMONTHS: ['Yanv', 'Fev', 'Mar', 'Apr', 'May', 'Iyun', 'Iyul',
      'Avg', 'Sen', 'Okt', 'Noya', 'Dek'],
  WEEKDAYS: ['yakshanba', 'dushanba', 'seshanba', 'chorshanba', 'payshanba',
      'juma', 'shanba'],
  STANDALONEWEEKDAYS: ['yakshanba', 'dushanba', 'seshanba', 'chorshanba',
      'payshanba', 'juma', 'shanba'],
  SHORTWEEKDAYS: ['Yaksh', 'Dush', 'Sesh', 'Chor', 'Pay', 'Jum', 'Shan'],
  STANDALONESHORTWEEKDAYS: ['Yaksh', 'Dush', 'Sesh', 'Chor', 'Pay', 'Jum',
      'Shan'],
  NARROWWEEKDAYS: ['Y', 'D', 'S', 'C', 'P', 'J', 'S'],
  STANDALONENARROWWEEKDAYS: ['Y', 'D', 'S', 'C', 'P', 'J', 'S'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, y MMMM dd', 'y MMMM d', 'y MMM d', 'yy/MM/dd'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale uz_Latn_UZ.
 */
goog.i18n.DateTimeSymbols_uz_Latn_UZ = goog.i18n.DateTimeSymbols_uz_Latn;


/**
 * Date/time formatting symbols for locale uz_UZ.
 */
goog.i18n.DateTimeSymbols_uz_UZ = goog.i18n.DateTimeSymbols_uz;


/**
 * Date/time formatting symbols for locale ve.
 */
goog.i18n.DateTimeSymbols_ve = {
  ERAS: ['BCE', 'CE'],
  ERANAMES: ['BCE', 'CE'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['Phando', 'Luhuhi', 'Ṱhafamuhwe', 'Lambamai', 'Shundunthule',
      'Fulwi', 'Fulwana', 'Ṱhangule', 'Khubvumedzi', 'Tshimedzi', 'Ḽara',
      'Nyendavhusiku'],
  STANDALONEMONTHS: ['Phando', 'Luhuhi', 'Ṱhafamuhwe', 'Lambamai',
      'Shundunthule', 'Fulwi', 'Fulwana', 'Ṱhangule', 'Khubvumedzi',
      'Tshimedzi', 'Ḽara', 'Nyendavhusiku'],
  SHORTMONTHS: ['Pha', 'Luh', 'Ṱha', 'Lam', 'Shu', 'Lwi', 'Lwa', 'Ṱha',
      'Khu', 'Tsh', 'Ḽar', 'Nye'],
  STANDALONESHORTMONTHS: ['Pha', 'Luh', 'Ṱha', 'Lam', 'Shu', 'Lwi', 'Lwa',
      'Ṱha', 'Khu', 'Tsh', 'Ḽar', 'Nye'],
  WEEKDAYS: ['Swondaha', 'Musumbuluwo', 'Ḽavhuvhili', 'Ḽavhuraru',
      'Ḽavhuṋa', 'Ḽavhuṱanu', 'Mugivhela'],
  STANDALONEWEEKDAYS: ['Swondaha', 'Musumbuluwo', 'Ḽavhuvhili', 'Ḽavhuraru',
      'Ḽavhuṋa', 'Ḽavhuṱanu', 'Mugivhela'],
  SHORTWEEKDAYS: ['Swo', 'Mus', 'Vhi', 'Rar', 'Ṋa', 'Ṱan', 'Mug'],
  STANDALONESHORTWEEKDAYS: ['Swo', 'Mus', 'Vhi', 'Rar', 'Ṋa', 'Ṱan', 'Mug'],
  NARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONENARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTQUARTERS: ['K1', 'K2', 'K3', 'K4'],
  QUARTERS: ['Kotara ya u thoma', 'Kotara ya vhuvhili', 'Kotara ya vhuraru',
      'Kotara ya vhuṋa'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, y MMMM dd', 'y MMMM d', 'y MMM d', 'yyyy-MM-dd'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale ve_ZA.
 */
goog.i18n.DateTimeSymbols_ve_ZA = goog.i18n.DateTimeSymbols_ve;


/**
 * Date/time formatting symbols for locale vi_VN.
 */
goog.i18n.DateTimeSymbols_vi_VN = {
  ERAS: ['tr. CN', 'sau CN'],
  ERANAMES: ['tr. CN', 'sau CN'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['tháng một', 'tháng hai', 'tháng ba', 'tháng tư',
      'tháng năm', 'tháng sáu', 'tháng bảy', 'tháng tám',
      'tháng chín', 'tháng mười', 'tháng mười một',
      'tháng mười hai'],
  STANDALONEMONTHS: ['tháng một', 'tháng hai', 'tháng ba', 'tháng tư',
      'tháng năm', 'tháng sáu', 'tháng bảy', 'tháng tám',
      'tháng chín', 'tháng mười', 'tháng mười một',
      'tháng mười hai'],
  SHORTMONTHS: ['thg 1', 'thg 2', 'thg 3', 'thg 4', 'thg 5', 'thg 6', 'thg 7',
      'thg 8', 'thg 9', 'thg 10', 'thg 11', 'thg 12'],
  STANDALONESHORTMONTHS: ['thg 1', 'thg 2', 'thg 3', 'thg 4', 'thg 5', 'thg 6',
      'thg 7', 'thg 8', 'thg 9', 'thg 10', 'thg 11', 'thg 12'],
  WEEKDAYS: ['Chủ nhật', 'Thứ hai', 'Thứ ba', 'Thứ tư', 'Thứ năm',
      'Thứ sáu', 'Thứ bảy'],
  STANDALONEWEEKDAYS: ['Chủ nhật', 'Thứ hai', 'Thứ ba', 'Thứ tư',
      'Thứ năm', 'Thứ sáu', 'Thứ bảy'],
  SHORTWEEKDAYS: ['CN', 'Th 2', 'Th 3', 'Th 4', 'Th 5', 'Th 6', 'Th 7'],
  STANDALONESHORTWEEKDAYS: ['CN', 'Th 2', 'Th 3', 'Th 4', 'Th 5', 'Th 6',
      'Th 7'],
  NARROWWEEKDAYS: ['CN', 'T2', 'T3', 'T4', 'T5', 'T6', 'T7'],
  STANDALONENARROWWEEKDAYS: ['CN', 'T2', 'T3', 'T4', 'T5', 'T6', 'T7'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['SA', 'CH'],
  DATEFORMATS: ['EEEE, \'ngày\' dd MMMM \'năm\' y',
      '\'Ngày\' dd \'tháng\' M \'năm\' y', 'dd-MM-yyyy', 'dd/MM/yyyy'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale wal.
 */
goog.i18n.DateTimeSymbols_wal = {
  ERAS: ['አዳ ዎዴ', 'ግሮተታ ላይታ'],
  ERANAMES: ['አዳ ዎዴ', 'ግሮተታ ላይታ'],
  NARROWMONTHS: ['ጃ', 'ፌ', 'ማ', 'ኤ', 'ሜ', 'ጁ', 'ጁ', 'ኦ', 'ሴ',
      'ኦ', 'ኖ', 'ዲ'],
  STANDALONENARROWMONTHS: ['ጃ', 'ፌ', 'ማ', 'ኤ', 'ሜ', 'ጁ', 'ጁ',
      'ኦ', 'ሴ', 'ኦ', 'ኖ', 'ዲ'],
  MONTHS: ['ጃንዩወሪ', 'ፌብሩወሪ', 'ማርች', 'ኤፕረል',
      'ሜይ', 'ጁን', 'ጁላይ', 'ኦገስት', 'ሴፕቴምበር',
      'ኦክተውበር', 'ኖቬምበር', 'ዲሴምበር'],
  STANDALONEMONTHS: ['ጃንዩወሪ', 'ፌብሩወሪ', 'ማርች',
      'ኤፕረል', 'ሜይ', 'ጁን', 'ጁላይ', 'ኦገስት',
      'ሴፕቴምበር', 'ኦክተውበር', 'ኖቬምበር',
      'ዲሴምበር'],
  SHORTMONTHS: ['ጃንዩ', 'ፌብሩ', 'ማርች', 'ኤፕረ', 'ሜይ',
      'ጁን', 'ጁላይ', 'ኦገስ', 'ሴፕቴ', 'ኦክተ', 'ኖቬም',
      'ዲሴም'],
  STANDALONESHORTMONTHS: ['ጃንዩ', 'ፌብሩ', 'ማርች', 'ኤፕረ',
      'ሜይ', 'ጁን', 'ጁላይ', 'ኦገስ', 'ሴፕቴ', 'ኦክተ',
      'ኖቬም', 'ዲሴም'],
  WEEKDAYS: ['ወጋ', 'ሳይኖ', 'ማቆሳኛ', 'አሩዋ', 'ሃሙሳ',
      'አርባ', 'ቄራ'],
  STANDALONEWEEKDAYS: ['ወጋ', 'ሳይኖ', 'ማቆሳኛ', 'አሩዋ',
      'ሃሙሳ', 'አርባ', 'ቄራ'],
  SHORTWEEKDAYS: ['ወጋ', 'ሳይኖ', 'ማቆሳኛ', 'አሩዋ',
      'ሃሙሳ', 'አርባ', 'ቄራ'],
  STANDALONESHORTWEEKDAYS: ['ወጋ', 'ሳይኖ', 'ማቆሳኛ', 'አሩዋ',
      'ሃሙሳ', 'አርባ', 'ቄራ'],
  NARROWWEEKDAYS: ['ወ', 'ሳ', 'ማ', 'አ', 'ሃ', 'አ', 'ቄ'],
  STANDALONENARROWWEEKDAYS: ['ወ', 'ሳ', 'ማ', 'አ', 'ሃ', 'አ', 'ቄ'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['ማለዶ', 'ቃማ'],
  DATEFORMATS: ['EEEE፥ dd MMMM ጋላሳ y G', 'dd MMMM y', 'dd-MMM-y',
      'dd/MM/yy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale wal_ET.
 */
goog.i18n.DateTimeSymbols_wal_ET = goog.i18n.DateTimeSymbols_wal;


/**
 * Date/time formatting symbols for locale wo.
 */
goog.i18n.DateTimeSymbols_wo = {
  ERAS: ['BCE', 'CE'],
  ERANAMES: ['BCE', 'CE'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONEMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11',
      '12'],
  SHORTMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONESHORTMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  WEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONEWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONESHORTWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  NARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONENARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, y MMMM dd', 'y MMMM d', 'y MMM d', 'yyyy-MM-dd'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale wo_Latn.
 */
goog.i18n.DateTimeSymbols_wo_Latn = goog.i18n.DateTimeSymbols_wo;


/**
 * Date/time formatting symbols for locale wo_Latn_SN.
 */
goog.i18n.DateTimeSymbols_wo_Latn_SN = goog.i18n.DateTimeSymbols_wo;


/**
 * Date/time formatting symbols for locale wo_SN.
 */
goog.i18n.DateTimeSymbols_wo_SN = goog.i18n.DateTimeSymbols_wo;


/**
 * Date/time formatting symbols for locale xh.
 */
goog.i18n.DateTimeSymbols_xh = {
  ERAS: ['BC', 'AD'],
  ERANAMES: ['BC', 'umnyaka wokuzalwa kukaYesu'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['Janyuwari', 'Februwari', 'Matshi', 'Epreli', 'Meyi', 'Juni',
      'Julayi', 'Agasti', 'Septemba', 'Okthoba', 'Novemba', 'Disemba'],
  STANDALONEMONTHS: ['Janyuwari', 'Februwari', 'Matshi', 'Epreli', 'Meyi',
      'Juni', 'Julayi', 'Agasti', 'Septemba', 'Okthoba', 'Novemba', 'Disemba'],
  SHORTMONTHS: ['Jan', 'Feb', 'Mat', 'Epr', 'Mey', 'Jun', 'Jul', 'Aga', 'Sep',
      'Okt', 'Nov', 'Dis'],
  STANDALONESHORTMONTHS: ['Jan', 'Feb', 'Mat', 'Epr', 'Mey', 'Jun', 'Jul',
      'Aga', 'Sep', 'Okt', 'Nov', 'Dis'],
  WEEKDAYS: ['Cawe', 'Mvulo', 'Lwesibini', 'Lwesithathu', 'Lwesine',
      'Lwesihlanu', 'Mgqibelo'],
  STANDALONEWEEKDAYS: ['Cawe', 'Mvulo', 'Lwesibini', 'Lwesithathu', 'Lwesine',
      'Lwesihlanu', 'Mgqibelo'],
  SHORTWEEKDAYS: ['Caw', 'Mvu', 'Bin', 'Tha', 'Sin', 'Hla', 'Mgq'],
  STANDALONESHORTWEEKDAYS: ['Caw', 'Mvu', 'Bin', 'Tha', 'Sin', 'Hla', 'Mgq'],
  NARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONENARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['1 unyangantathu', '2 unyangantathu', '3 unyangantathu',
      '4 unyangantathu'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE, y MMMM dd', 'y MMMM d', 'y MMM d', 'yyyy-MM-dd'],
  TIMEFORMATS: ['HH:mm:ss zzzz', 'HH:mm:ss z', 'HH:mm:ss', 'HH:mm'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale xh_ZA.
 */
goog.i18n.DateTimeSymbols_xh_ZA = goog.i18n.DateTimeSymbols_xh;


/**
 * Date/time formatting symbols for locale yo.
 */
goog.i18n.DateTimeSymbols_yo = {
  ERAS: ['SK', 'LK'],
  ERANAMES: ['Saju Kristi', 'Lehin Kristi'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['Oṣù Ṣẹ́rẹ́', 'Oṣù Èrèlè', 'Oṣù Ẹrẹ̀nà',
      'Oṣù Ìgbé', 'Oṣù Ẹ̀bibi', 'Oṣù Òkúdu', 'Oṣù Agẹmọ',
      'Oṣù Ògún', 'Oṣù Owewe', 'Oṣù Ọ̀wàrà', 'Oṣù Bélú',
      'Oṣù Ọ̀pẹ̀'],
  STANDALONEMONTHS: ['Oṣù Ṣẹ́rẹ́', 'Oṣù Èrèlè',
      'Oṣù Ẹrẹ̀nà', 'Oṣù Ìgbé', 'Oṣù Ẹ̀bibi',
      'Oṣù Òkúdu', 'Oṣù Agẹmọ', 'Oṣù Ògún', 'Oṣù Owewe',
      'Oṣù Ọ̀wàrà', 'Oṣù Bélú', 'Oṣù Ọ̀pẹ̀'],
  SHORTMONTHS: ['Ṣẹ́rẹ́', 'Èrèlè', 'Ẹrẹ̀nà', 'Ìgbé',
      'Ẹ̀bibi', 'Òkúdu', 'Agẹmọ', 'Ògún', 'Owewe', 'Ọ̀wàrà',
      'Bélú', 'Ọ̀pẹ̀'],
  STANDALONESHORTMONTHS: ['Ṣẹ́rẹ́', 'Èrèlè', 'Ẹrẹ̀nà',
      'Ìgbé', 'Ẹ̀bibi', 'Òkúdu', 'Agẹmọ', 'Ògún', 'Owewe',
      'Ọ̀wàrà', 'Bélú', 'Ọ̀pẹ̀'],
  WEEKDAYS: ['Ọjọ́ Àìkú', 'Ọjọ́ Ajé', 'Ọjọ́ Ìsẹ́gun',
      'Ọjọ́rú', 'Ọjọ́bọ', 'Ọjọ́ Ẹtì',
      'Ọjọ́ Àbámẹ́ta'],
  STANDALONEWEEKDAYS: ['Ọjọ́ Àìkú', 'Ọjọ́ Ajé',
      'Ọjọ́ Ìsẹ́gun', 'Ọjọ́rú', 'Ọjọ́bọ',
      'Ọjọ́ Ẹtì', 'Ọjọ́ Àbámẹ́ta'],
  SHORTWEEKDAYS: ['Àìkú', 'Ajé', 'Ìsẹ́gun', 'Ọjọ́rú',
      'Ọjọ́bọ', 'Ẹtì', 'Àbámẹ́ta'],
  STANDALONESHORTWEEKDAYS: ['Àìkú', 'Ajé', 'Ìsẹ́gun', 'Ọjọ́rú',
      'Ọjọ́bọ', 'Ẹtì', 'Àbámẹ́ta'],
  NARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  STANDALONENARROWWEEKDAYS: ['1', '2', '3', '4', '5', '6', '7'],
  SHORTQUARTERS: ['K1', 'K2', 'K3', 'K4'],
  QUARTERS: ['Kọ́tà Kínní', 'Kọ́tà Kejì', 'Kọ́à Keta',
      'Kọ́tà Kẹrin'],
  AMPMS: ['Àárọ̀', 'Ọ̀sán'],
  DATEFORMATS: ['EEEE, d MMMM y', 'd MMMM y', 'd MMM y', 'dd/MM/yyyy'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale yo_NG.
 */
goog.i18n.DateTimeSymbols_yo_NG = goog.i18n.DateTimeSymbols_yo;


/**
 * Date/time formatting symbols for locale zh_Hans.
 */
goog.i18n.DateTimeSymbols_zh_Hans = {
  ERAS: ['公元前', '公元'],
  ERANAMES: ['公元前', '公元'],
  NARROWMONTHS: ['1月', '2月', '3月', '4月', '5月', '6月', '7月', '8月',
      '9月', '10月', '11月', '12月'],
  STANDALONENARROWMONTHS: ['1月', '2月', '3月', '4月', '5月', '6月',
      '7月', '8月', '9月', '10月', '11月', '12月'],
  MONTHS: ['1月', '2月', '3月', '4月', '5月', '6月', '7月', '8月',
      '9月', '10月', '11月', '12月'],
  STANDALONEMONTHS: ['一月', '二月', '三月', '四月', '五月', '六月',
      '七月', '八月', '九月', '十月', '十一月', '十二月'],
  SHORTMONTHS: ['1月', '2月', '3月', '4月', '5月', '6月', '7月', '8月',
      '9月', '10月', '11月', '12月'],
  STANDALONESHORTMONTHS: ['一月', '二月', '三月', '四月', '五月',
      '六月', '七月', '八月', '九月', '十月', '十一月',
      '十二月'],
  WEEKDAYS: ['星期日', '星期一', '星期二', '星期三', '星期四',
      '星期五', '星期六'],
  STANDALONEWEEKDAYS: ['星期日', '星期一', '星期二', '星期三',
      '星期四', '星期五', '星期六'],
  SHORTWEEKDAYS: ['周日', '周一', '周二', '周三', '周四', '周五',
      '周六'],
  STANDALONESHORTWEEKDAYS: ['周日', '周一', '周二', '周三', '周四',
      '周五', '周六'],
  NARROWWEEKDAYS: ['日', '一', '二', '三', '四', '五', '六'],
  STANDALONENARROWWEEKDAYS: ['日', '一', '二', '三', '四', '五', '六'],
  SHORTQUARTERS: ['1季', '2季', '3季', '4季'],
  QUARTERS: ['第1季度', '第2季度', '第3季度', '第4季度'],
  AMPMS: ['上午', '下午'],
  DATEFORMATS: ['y年M月d日EEEE', 'y年M月d日', 'yyyy-M-d', 'yy-M-d'],
  TIMEFORMATS: ['zzzzah时mm分ss秒', 'zah时mm分ss秒', 'ah:mm:ss', 'ah:mm'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale zh_Hans_CN.
 */
goog.i18n.DateTimeSymbols_zh_Hans_CN = goog.i18n.DateTimeSymbols_zh_Hans;


/**
 * Date/time formatting symbols for locale zh_Hans_HK.
 */
goog.i18n.DateTimeSymbols_zh_Hans_HK = goog.i18n.DateTimeSymbols_zh_Hans;


/**
 * Date/time formatting symbols for locale zh_Hans_MO.
 */
goog.i18n.DateTimeSymbols_zh_Hans_MO = goog.i18n.DateTimeSymbols_zh_Hans;


/**
 * Date/time formatting symbols for locale zh_Hans_SG.
 */
goog.i18n.DateTimeSymbols_zh_Hans_SG = {
  ERAS: ['公元前', '公元'],
  ERANAMES: ['公元前', '公元'],
  NARROWMONTHS: ['1月', '2月', '3月', '4月', '5月', '6月', '7月', '8月',
      '9月', '10月', '11月', '12月'],
  STANDALONENARROWMONTHS: ['1月', '2月', '3月', '4月', '5月', '6月',
      '7月', '8月', '9月', '10月', '11月', '12月'],
  MONTHS: ['1月', '2月', '3月', '4月', '5月', '6月', '7月', '8月',
      '9月', '10月', '11月', '12月'],
  STANDALONEMONTHS: ['一月', '二月', '三月', '四月', '五月', '六月',
      '七月', '八月', '九月', '十月', '十一月', '十二月'],
  SHORTMONTHS: ['1月', '2月', '3月', '4月', '5月', '6月', '7月', '8月',
      '9月', '10月', '11月', '12月'],
  STANDALONESHORTMONTHS: ['一月', '二月', '三月', '四月', '五月',
      '六月', '七月', '八月', '九月', '十月', '十一月',
      '十二月'],
  WEEKDAYS: ['星期日', '星期一', '星期二', '星期三', '星期四',
      '星期五', '星期六'],
  STANDALONEWEEKDAYS: ['星期日', '星期一', '星期二', '星期三',
      '星期四', '星期五', '星期六'],
  SHORTWEEKDAYS: ['周日', '周一', '周二', '周三', '周四', '周五',
      '周六'],
  STANDALONESHORTWEEKDAYS: ['周日', '周一', '周二', '周三', '周四',
      '周五', '周六'],
  NARROWWEEKDAYS: ['日', '一', '二', '三', '四', '五', '六'],
  STANDALONENARROWWEEKDAYS: ['日', '一', '二', '三', '四', '五', '六'],
  SHORTQUARTERS: ['1季', '2季', '3季', '4季'],
  QUARTERS: ['第1季度', '第2季度', '第3季度', '第4季度'],
  AMPMS: ['上午', '下午'],
  DATEFORMATS: ['y年M月d日EEEE', 'y年M月d日', 'yyyy-M-d', 'dd/MM/yy'],
  TIMEFORMATS: ['zzzzah时mm分ss秒', 'ahh:mm:ssz', 'ah:mm:ss', 'ahh:mm'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale zh_Hant.
 */
goog.i18n.DateTimeSymbols_zh_Hant = {
  ERAS: ['西元前', '西元'],
  ERANAMES: ['西元前', '西元'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['1月', '2月', '3月', '4月', '5月', '6月', '7月', '8月',
      '9月', '10月', '11月', '12月'],
  STANDALONEMONTHS: ['一月', '二月', '三月', '四月', '五月', '六月',
      '七月', '八月', '九月', '十月', '十一月', '十二月'],
  SHORTMONTHS: ['1月', '2月', '3月', '4月', '5月', '6月', '7月', '8月',
      '9月', '10月', '11月', '12月'],
  STANDALONESHORTMONTHS: ['一月', '二月', '三月', '四月', '五月',
      '六月', '七月', '八月', '九月', '十月', '十一月',
      '十二月'],
  WEEKDAYS: ['星期日', '星期一', '星期二', '星期三', '星期四',
      '星期五', '星期六'],
  STANDALONEWEEKDAYS: ['星期日', '星期一', '星期二', '星期三',
      '星期四', '星期五', '星期六'],
  SHORTWEEKDAYS: ['週日', '週一', '週二', '週三', '週四', '週五',
      '週六'],
  STANDALONESHORTWEEKDAYS: ['週日', '週一', '週二', '週三', '週四',
      '週五', '週六'],
  NARROWWEEKDAYS: ['日', '一', '二', '三', '四', '五', '六'],
  STANDALONENARROWWEEKDAYS: ['日', '一', '二', '三', '四', '五', '六'],
  SHORTQUARTERS: ['1季', '2季', '3季', '4季'],
  QUARTERS: ['第1季', '第2季', '第3季', '第4季'],
  AMPMS: ['上午', '下午'],
  DATEFORMATS: ['y年M月d日EEEE', 'y年M月d日', 'yyyy/M/d', 'yy/M/d'],
  TIMEFORMATS: ['zzzzah時mm分ss秒', 'zah時mm分ss秒', 'ah:mm:ss', 'ah:mm'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale zh_Hant_HK.
 */
goog.i18n.DateTimeSymbols_zh_Hant_HK = {
  ERAS: ['西元前', '西元'],
  ERANAMES: ['西元前', '西元'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['1月', '2月', '3月', '4月', '5月', '6月', '7月', '8月',
      '9月', '10月', '11月', '12月'],
  STANDALONEMONTHS: ['一月', '二月', '三月', '四月', '五月', '六月',
      '七月', '八月', '九月', '十月', '十一月', '十二月'],
  SHORTMONTHS: ['1月', '2月', '3月', '4月', '5月', '6月', '7月', '8月',
      '9月', '10月', '11月', '12月'],
  STANDALONESHORTMONTHS: ['一月', '二月', '三月', '四月', '五月',
      '六月', '七月', '八月', '九月', '十月', '十一月',
      '十二月'],
  WEEKDAYS: ['星期日', '星期一', '星期二', '星期三', '星期四',
      '星期五', '星期六'],
  STANDALONEWEEKDAYS: ['星期日', '星期一', '星期二', '星期三',
      '星期四', '星期五', '星期六'],
  SHORTWEEKDAYS: ['週日', '週一', '週二', '週三', '週四', '週五',
      '週六'],
  STANDALONESHORTWEEKDAYS: ['週日', '週一', '週二', '週三', '週四',
      '週五', '週六'],
  NARROWWEEKDAYS: ['日', '一', '二', '三', '四', '五', '六'],
  STANDALONENARROWWEEKDAYS: ['日', '一', '二', '三', '四', '五', '六'],
  SHORTQUARTERS: ['1季', '2季', '3季', '4季'],
  QUARTERS: ['第1季', '第2季', '第3季', '第4季'],
  AMPMS: ['上午', '下午'],
  DATEFORMATS: ['y年M月d日EEEE', 'y年M月d日', 'y年M月d日',
      'yy年M月d日'],
  TIMEFORMATS: ['zzzzah時mm分ss秒', 'zah時mm分ss秒', 'ahh:mm:ss',
      'ah:mm'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale zh_Hant_MO.
 */
goog.i18n.DateTimeSymbols_zh_Hant_MO = {
  ERAS: ['西元前', '西元'],
  ERANAMES: ['西元前', '西元'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['1月', '2月', '3月', '4月', '5月', '6月', '7月', '8月',
      '9月', '10月', '11月', '12月'],
  STANDALONEMONTHS: ['一月', '二月', '三月', '四月', '五月', '六月',
      '七月', '八月', '九月', '十月', '十一月', '十二月'],
  SHORTMONTHS: ['1月', '2月', '3月', '4月', '5月', '6月', '7月', '8月',
      '9月', '10月', '11月', '12月'],
  STANDALONESHORTMONTHS: ['一月', '二月', '三月', '四月', '五月',
      '六月', '七月', '八月', '九月', '十月', '十一月',
      '十二月'],
  WEEKDAYS: ['星期日', '星期一', '星期二', '星期三', '星期四',
      '星期五', '星期六'],
  STANDALONEWEEKDAYS: ['星期日', '星期一', '星期二', '星期三',
      '星期四', '星期五', '星期六'],
  SHORTWEEKDAYS: ['週日', '週一', '週二', '週三', '週四', '週五',
      '週六'],
  STANDALONESHORTWEEKDAYS: ['週日', '週一', '週二', '週三', '週四',
      '週五', '週六'],
  NARROWWEEKDAYS: ['日', '一', '二', '三', '四', '五', '六'],
  STANDALONENARROWWEEKDAYS: ['日', '一', '二', '三', '四', '五', '六'],
  SHORTQUARTERS: ['1季', '2季', '3季', '4季'],
  QUARTERS: ['第1季', '第2季', '第3季', '第4季'],
  AMPMS: ['上午', '下午'],
  DATEFORMATS: ['y年MM月dd日EEEE', 'y年MM月dd日', 'y年M月d日',
      'yy年M月d日'],
  TIMEFORMATS: ['zzzzah時mm分ss秒', 'zah時mm分ss秒', 'ahh:mm:ss',
      'ah:mm'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale zh_Hant_TW.
 */
goog.i18n.DateTimeSymbols_zh_Hant_TW = goog.i18n.DateTimeSymbols_zh_Hant;


/**
 * Date/time formatting symbols for locale zh_MO.
 */
goog.i18n.DateTimeSymbols_zh_MO = {
  ERAS: ['西元前', '西元'],
  ERANAMES: ['西元前', '西元'],
  NARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
  STANDALONENARROWMONTHS: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10',
      '11', '12'],
  MONTHS: ['1月', '2月', '3月', '4月', '5月', '6月', '7月', '8月',
      '9月', '10月', '11月', '12月'],
  STANDALONEMONTHS: ['一月', '二月', '三月', '四月', '五月', '六月',
      '七月', '八月', '九月', '十月', '十一月', '十二月'],
  SHORTMONTHS: ['1月', '2月', '3月', '4月', '5月', '6月', '7月', '8月',
      '9月', '10月', '11月', '12月'],
  STANDALONESHORTMONTHS: ['一月', '二月', '三月', '四月', '五月',
      '六月', '七月', '八月', '九月', '十月', '十一月',
      '十二月'],
  WEEKDAYS: ['星期日', '星期一', '星期二', '星期三', '星期四',
      '星期五', '星期六'],
  STANDALONEWEEKDAYS: ['星期日', '星期一', '星期二', '星期三',
      '星期四', '星期五', '星期六'],
  SHORTWEEKDAYS: ['週日', '週一', '週二', '週三', '週四', '週五',
      '週六'],
  STANDALONESHORTWEEKDAYS: ['週日', '週一', '週二', '週三', '週四',
      '週五', '週六'],
  NARROWWEEKDAYS: ['日', '一', '二', '三', '四', '五', '六'],
  STANDALONENARROWWEEKDAYS: ['日', '一', '二', '三', '四', '五', '六'],
  SHORTQUARTERS: ['1季', '2季', '3季', '4季'],
  QUARTERS: ['第1季', '第2季', '第3季', '第4季'],
  AMPMS: ['上午', '下午'],
  DATEFORMATS: ['y年MM月dd日EEEE', 'y年MM月dd日', 'y年M月d日',
      'yy年M月d日'],
  TIMEFORMATS: ['zzzzah時mm分ss秒', 'zah時mm分ss秒', 'ahh:mm:ss',
      'ah:mm'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale zh_SG.
 */
goog.i18n.DateTimeSymbols_zh_SG = {
  ERAS: ['公元前', '公元'],
  ERANAMES: ['公元前', '公元'],
  NARROWMONTHS: ['1月', '2月', '3月', '4月', '5月', '6月', '7月', '8月',
      '9月', '10月', '11月', '12月'],
  STANDALONENARROWMONTHS: ['1月', '2月', '3月', '4月', '5月', '6月',
      '7月', '8月', '9月', '10月', '11月', '12月'],
  MONTHS: ['1月', '2月', '3月', '4月', '5月', '6月', '7月', '8月',
      '9月', '10月', '11月', '12月'],
  STANDALONEMONTHS: ['一月', '二月', '三月', '四月', '五月', '六月',
      '七月', '八月', '九月', '十月', '十一月', '十二月'],
  SHORTMONTHS: ['1月', '2月', '3月', '4月', '5月', '6月', '7月', '8月',
      '9月', '10月', '11月', '12月'],
  STANDALONESHORTMONTHS: ['一月', '二月', '三月', '四月', '五月',
      '六月', '七月', '八月', '九月', '十月', '十一月',
      '十二月'],
  WEEKDAYS: ['星期日', '星期一', '星期二', '星期三', '星期四',
      '星期五', '星期六'],
  STANDALONEWEEKDAYS: ['星期日', '星期一', '星期二', '星期三',
      '星期四', '星期五', '星期六'],
  SHORTWEEKDAYS: ['周日', '周一', '周二', '周三', '周四', '周五',
      '周六'],
  STANDALONESHORTWEEKDAYS: ['周日', '周一', '周二', '周三', '周四',
      '周五', '周六'],
  NARROWWEEKDAYS: ['日', '一', '二', '三', '四', '五', '六'],
  STANDALONENARROWWEEKDAYS: ['日', '一', '二', '三', '四', '五', '六'],
  SHORTQUARTERS: ['1季', '2季', '3季', '4季'],
  QUARTERS: ['第1季度', '第2季度', '第3季度', '第4季度'],
  AMPMS: ['上午', '下午'],
  DATEFORMATS: ['y年M月d日EEEE', 'y年M月d日', 'yyyy-M-d', 'dd/MM/yy'],
  TIMEFORMATS: ['zzzzah时mm分ss秒', 'ahh:mm:ssz', 'ah:mm:ss', 'ahh:mm'],
  FIRSTDAYOFWEEK: 6,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 2
};


/**
 * Date/time formatting symbols for locale zu.
 */
goog.i18n.DateTimeSymbols_zu = {
  ERAS: ['BCE', 'CE'],
  ERANAMES: ['BCE', 'CE'],
  NARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  STANDALONENARROWMONTHS: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O',
      'N', 'D'],
  MONTHS: ['Januwari', 'Februwari', 'Mashi', 'Apreli', 'Meyi', 'Juni', 'Julayi',
      'Agasti', 'Septhemba', 'Okthoba', 'Novemba', 'Disemba'],
  STANDALONEMONTHS: ['uJanuwari', 'uFebruwari', 'uMashi', 'u-Apreli', 'uMeyi',
      'uJuni', 'uJulayi', 'uAgasti', 'uSepthemba', 'u-Okthoba', 'uNovemba',
      'uDisemba'],
  SHORTMONTHS: ['Jan', 'Feb', 'Mas', 'Apr', 'Mey', 'Jun', 'Jul', 'Aga', 'Sep',
      'Okt', 'Nov', 'Dis'],
  STANDALONESHORTMONTHS: ['Jan', 'Feb', 'Mas', 'Apr', 'Mey', 'Jun', 'Jul',
      'Aga', 'Sep', 'Okt', 'Nov', 'Dis'],
  WEEKDAYS: ['Sonto', 'Msombuluko', 'Lwesibili', 'Lwesithathu', 'uLwesine',
      'Lwesihlanu', 'Mgqibelo'],
  STANDALONEWEEKDAYS: ['Sonto', 'Msombuluko', 'Lwesibili', 'Lwesithathu',
      'uLwesine', 'Lwesihlanu', 'Mgqibelo'],
  SHORTWEEKDAYS: ['Son', 'Mso', 'Bil', 'Tha', 'Sin', 'Hla', 'Mgq'],
  STANDALONESHORTWEEKDAYS: ['Son', 'Mso', 'Bil', 'Tha', 'Sin', 'Hla', 'Mgq'],
  NARROWWEEKDAYS: ['S', 'M', 'B', 'T', 'S', 'H', 'M'],
  STANDALONENARROWWEEKDAYS: ['S', 'M', 'B', 'T', 'S', 'H', 'M'],
  SHORTQUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  QUARTERS: ['Q1', 'Q2', 'Q3', 'Q4'],
  AMPMS: ['AM', 'PM'],
  DATEFORMATS: ['EEEE dd MMMM y', 'd MMMM y', 'd MMM y', 'yyyy-MM-dd'],
  TIMEFORMATS: ['h:mm:ss a zzzz', 'h:mm:ss a z', 'h:mm:ss a', 'h:mm a'],
  FIRSTDAYOFWEEK: 0,
  WEEKENDRANGE: [5, 6],
  FIRSTWEEKCUTOFFDAY: 3
};


/**
 * Date/time formatting symbols for locale zu_ZA.
 */
goog.i18n.DateTimeSymbols_zu_ZA = goog.i18n.DateTimeSymbols_zu;


/**
 * Selected date/time formatting symbols by locale.
 */
if (goog.LOCALE == 'aa') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_aa;
}

if (goog.LOCALE == 'aa_DJ' || goog.LOCALE == 'aa-DJ') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_aa_DJ;
}

if (goog.LOCALE == 'aa_ER' || goog.LOCALE == 'aa-ER') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_aa;
}

if (goog.LOCALE == 'aa_ET' || goog.LOCALE == 'aa-ET') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_aa;
}

if (goog.LOCALE == 'af') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_af;
}

if (goog.LOCALE == 'af_NA' || goog.LOCALE == 'af-NA') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_af_NA;
}

if (goog.LOCALE == 'af_ZA' || goog.LOCALE == 'af-ZA') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_af;
}

if (goog.LOCALE == 'ak') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ak;
}

if (goog.LOCALE == 'ak_GH' || goog.LOCALE == 'ak-GH') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ak;
}

if (goog.LOCALE == 'am_ET' || goog.LOCALE == 'am-ET') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_am_ET;
}

if (goog.LOCALE == 'ar_AE' || goog.LOCALE == 'ar-AE') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ar_AE;
}

if (goog.LOCALE == 'ar_BH' || goog.LOCALE == 'ar-BH') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ar_BH;
}

if (goog.LOCALE == 'ar_DZ' || goog.LOCALE == 'ar-DZ') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ar_DZ;
}

if (goog.LOCALE == 'ar_EG' || goog.LOCALE == 'ar-EG') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ar_EG;
}

if (goog.LOCALE == 'ar_IQ' || goog.LOCALE == 'ar-IQ') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ar_IQ;
}

if (goog.LOCALE == 'ar_JO' || goog.LOCALE == 'ar-JO') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ar_JO;
}

if (goog.LOCALE == 'ar_KW' || goog.LOCALE == 'ar-KW') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ar_KW;
}

if (goog.LOCALE == 'ar_LB' || goog.LOCALE == 'ar-LB') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ar_LB;
}

if (goog.LOCALE == 'ar_LY' || goog.LOCALE == 'ar-LY') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ar_LY;
}

if (goog.LOCALE == 'ar_MA' || goog.LOCALE == 'ar-MA') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ar_MA;
}

if (goog.LOCALE == 'ar_OM' || goog.LOCALE == 'ar-OM') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ar_OM;
}

if (goog.LOCALE == 'ar_QA' || goog.LOCALE == 'ar-QA') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ar_QA;
}

if (goog.LOCALE == 'ar_SA' || goog.LOCALE == 'ar-SA') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ar_SA;
}

if (goog.LOCALE == 'ar_SD' || goog.LOCALE == 'ar-SD') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ar_SD;
}

if (goog.LOCALE == 'ar_SY' || goog.LOCALE == 'ar-SY') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ar_SY;
}

if (goog.LOCALE == 'ar_TN' || goog.LOCALE == 'ar-TN') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ar_TN;
}

if (goog.LOCALE == 'ar_YE' || goog.LOCALE == 'ar-YE') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ar_YE;
}

if (goog.LOCALE == 'as') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_as;
}

if (goog.LOCALE == 'as_IN' || goog.LOCALE == 'as-IN') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_as;
}

if (goog.LOCALE == 'az') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_az;
}

if (goog.LOCALE == 'az_AZ' || goog.LOCALE == 'az-AZ') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_az;
}

if (goog.LOCALE == 'az_Arab' || goog.LOCALE == 'az-Arab') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_az;
}

if (goog.LOCALE == 'az_Arab_IR' || goog.LOCALE == 'az-Arab-IR') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_az;
}

if (goog.LOCALE == 'az_Cyrl' || goog.LOCALE == 'az-Cyrl') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_az_Cyrl;
}

if (goog.LOCALE == 'az_Cyrl_AZ' || goog.LOCALE == 'az-Cyrl-AZ') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_az_Cyrl;
}

if (goog.LOCALE == 'az_IR' || goog.LOCALE == 'az-IR') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_az;
}

if (goog.LOCALE == 'az_Latn' || goog.LOCALE == 'az-Latn') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_az;
}

if (goog.LOCALE == 'az_Latn_AZ' || goog.LOCALE == 'az-Latn-AZ') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_az;
}

if (goog.LOCALE == 'be') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_be;
}

if (goog.LOCALE == 'be_BY' || goog.LOCALE == 'be-BY') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_be;
}

if (goog.LOCALE == 'bg_BG' || goog.LOCALE == 'bg-BG') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_bg_BG;
}

if (goog.LOCALE == 'bn_BD' || goog.LOCALE == 'bn-BD') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_bn_BD;
}

if (goog.LOCALE == 'bn_IN' || goog.LOCALE == 'bn-IN') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_bn_IN;
}

if (goog.LOCALE == 'bo') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_bo;
}

if (goog.LOCALE == 'bo_CN' || goog.LOCALE == 'bo-CN') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_bo;
}

if (goog.LOCALE == 'bo_IN' || goog.LOCALE == 'bo-IN') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_bo;
}

if (goog.LOCALE == 'bs') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_bs;
}

if (goog.LOCALE == 'bs_BA' || goog.LOCALE == 'bs-BA') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_bs;
}

if (goog.LOCALE == 'byn') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_byn;
}

if (goog.LOCALE == 'byn_ER' || goog.LOCALE == 'byn-ER') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_byn;
}

if (goog.LOCALE == 'ca_ES' || goog.LOCALE == 'ca-ES') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ca_ES;
}

if (goog.LOCALE == 'cch') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_cch;
}

if (goog.LOCALE == 'cch_NG' || goog.LOCALE == 'cch-NG') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_cch;
}

if (goog.LOCALE == 'cs_CZ' || goog.LOCALE == 'cs-CZ') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_cs_CZ;
}

if (goog.LOCALE == 'cy') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_cy;
}

if (goog.LOCALE == 'cy_GB' || goog.LOCALE == 'cy-GB') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_cy;
}

if (goog.LOCALE == 'da_DK' || goog.LOCALE == 'da-DK') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_da_DK;
}

if (goog.LOCALE == 'de_BE' || goog.LOCALE == 'de-BE') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_de_BE;
}

if (goog.LOCALE == 'de_DE' || goog.LOCALE == 'de-DE') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_de_DE;
}

if (goog.LOCALE == 'de_LI' || goog.LOCALE == 'de-LI') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_de_LI;
}

if (goog.LOCALE == 'de_LU' || goog.LOCALE == 'de-LU') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_de_LU;
}

if (goog.LOCALE == 'dv') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_dv;
}

if (goog.LOCALE == 'dv_MV' || goog.LOCALE == 'dv-MV') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_dv;
}

if (goog.LOCALE == 'dz') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_dz;
}

if (goog.LOCALE == 'dz_BT' || goog.LOCALE == 'dz-BT') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_dz;
}

if (goog.LOCALE == 'ee') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ee;
}

if (goog.LOCALE == 'ee_GH' || goog.LOCALE == 'ee-GH') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ee;
}

if (goog.LOCALE == 'ee_TG' || goog.LOCALE == 'ee-TG') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ee;
}

if (goog.LOCALE == 'el_CY' || goog.LOCALE == 'el-CY') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_el_CY;
}

if (goog.LOCALE == 'el_GR' || goog.LOCALE == 'el-GR') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_el_GR;
}

if (goog.LOCALE == 'el_POLYTON' || goog.LOCALE == 'el-POLYTON') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_el_POLYTON;
}

if (goog.LOCALE == 'en_AS' || goog.LOCALE == 'en-AS') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_en_AS;
}

if (goog.LOCALE == 'en_BE' || goog.LOCALE == 'en-BE') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_en_BE;
}

if (goog.LOCALE == 'en_BW' || goog.LOCALE == 'en-BW') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_en_BW;
}

if (goog.LOCALE == 'en_BZ' || goog.LOCALE == 'en-BZ') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_en_BZ;
}

if (goog.LOCALE == 'en_CA' || goog.LOCALE == 'en-CA') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_en_CA;
}

if (goog.LOCALE == 'en_Dsrt' || goog.LOCALE == 'en-Dsrt') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_en_Dsrt;
}

if (goog.LOCALE == 'en_Dsrt_US' || goog.LOCALE == 'en-Dsrt-US') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_en_Dsrt;
}

if (goog.LOCALE == 'en_GU' || goog.LOCALE == 'en-GU') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_en_GU;
}

if (goog.LOCALE == 'en_HK' || goog.LOCALE == 'en-HK') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_en_HK;
}

if (goog.LOCALE == 'en_JM' || goog.LOCALE == 'en-JM') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_en_JM;
}

if (goog.LOCALE == 'en_MH' || goog.LOCALE == 'en-MH') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_en_MH;
}

if (goog.LOCALE == 'en_MP' || goog.LOCALE == 'en-MP') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_en_MP;
}

if (goog.LOCALE == 'en_MT' || goog.LOCALE == 'en-MT') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_en_MT;
}

if (goog.LOCALE == 'en_NA' || goog.LOCALE == 'en-NA') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_en_NA;
}

if (goog.LOCALE == 'en_NZ' || goog.LOCALE == 'en-NZ') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_en_NZ;
}

if (goog.LOCALE == 'en_PH' || goog.LOCALE == 'en-PH') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_en_PH;
}

if (goog.LOCALE == 'en_PK' || goog.LOCALE == 'en-PK') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_en_PK;
}

if (goog.LOCALE == 'en_Shaw' || goog.LOCALE == 'en-Shaw') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_en_Shaw;
}

if (goog.LOCALE == 'en_TT' || goog.LOCALE == 'en-TT') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_en_TT;
}

if (goog.LOCALE == 'en_UM' || goog.LOCALE == 'en-UM') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_en_UM;
}

if (goog.LOCALE == 'en_VI' || goog.LOCALE == 'en-VI') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_en_VI;
}

if (goog.LOCALE == 'en_ZW' || goog.LOCALE == 'en-ZW') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_en_ZW;
}

if (goog.LOCALE == 'eo') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_eo;
}

if (goog.LOCALE == 'es_AR' || goog.LOCALE == 'es-AR') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_es_AR;
}

if (goog.LOCALE == 'es_BO' || goog.LOCALE == 'es-BO') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_es_BO;
}

if (goog.LOCALE == 'es_CL' || goog.LOCALE == 'es-CL') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_es_CL;
}

if (goog.LOCALE == 'es_CO' || goog.LOCALE == 'es-CO') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_es_CO;
}

if (goog.LOCALE == 'es_CR' || goog.LOCALE == 'es-CR') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_es_CR;
}

if (goog.LOCALE == 'es_DO' || goog.LOCALE == 'es-DO') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_es_DO;
}

if (goog.LOCALE == 'es_EC' || goog.LOCALE == 'es-EC') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_es_EC;
}

if (goog.LOCALE == 'es_ES' || goog.LOCALE == 'es-ES') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_es_ES;
}

if (goog.LOCALE == 'es_GT' || goog.LOCALE == 'es-GT') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_es_GT;
}

if (goog.LOCALE == 'es_HN' || goog.LOCALE == 'es-HN') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_es_HN;
}

if (goog.LOCALE == 'es_MX' || goog.LOCALE == 'es-MX') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_es_MX;
}

if (goog.LOCALE == 'es_NI' || goog.LOCALE == 'es-NI') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_es_NI;
}

if (goog.LOCALE == 'es_PA' || goog.LOCALE == 'es-PA') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_es_PA;
}

if (goog.LOCALE == 'es_PE' || goog.LOCALE == 'es-PE') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_es_PE;
}

if (goog.LOCALE == 'es_PR' || goog.LOCALE == 'es-PR') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_es_PR;
}

if (goog.LOCALE == 'es_PY' || goog.LOCALE == 'es-PY') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_es_PY;
}

if (goog.LOCALE == 'es_SV' || goog.LOCALE == 'es-SV') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_es_SV;
}

if (goog.LOCALE == 'es_US' || goog.LOCALE == 'es-US') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_es_US;
}

if (goog.LOCALE == 'es_UY' || goog.LOCALE == 'es-UY') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_es_UY;
}

if (goog.LOCALE == 'es_VE' || goog.LOCALE == 'es-VE') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_es_VE;
}

if (goog.LOCALE == 'et_EE' || goog.LOCALE == 'et-EE') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_et_EE;
}

if (goog.LOCALE == 'eu_ES' || goog.LOCALE == 'eu-ES') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_eu_ES;
}

if (goog.LOCALE == 'fa_AF' || goog.LOCALE == 'fa-AF') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_fa_AF;
}

if (goog.LOCALE == 'fa_IR' || goog.LOCALE == 'fa-IR') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_fa_IR;
}

if (goog.LOCALE == 'fi_FI' || goog.LOCALE == 'fi-FI') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_fi_FI;
}

if (goog.LOCALE == 'fil_PH' || goog.LOCALE == 'fil-PH') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_fil_PH;
}

if (goog.LOCALE == 'fo') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_fo;
}

if (goog.LOCALE == 'fo_FO' || goog.LOCALE == 'fo-FO') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_fo;
}

if (goog.LOCALE == 'fr_BE' || goog.LOCALE == 'fr-BE') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_fr_BE;
}

if (goog.LOCALE == 'fr_CH' || goog.LOCALE == 'fr-CH') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_fr_CH;
}

if (goog.LOCALE == 'fr_FR' || goog.LOCALE == 'fr-FR') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_fr_FR;
}

if (goog.LOCALE == 'fr_LU' || goog.LOCALE == 'fr-LU') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_fr_LU;
}

if (goog.LOCALE == 'fr_MC' || goog.LOCALE == 'fr-MC') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_fr_MC;
}

if (goog.LOCALE == 'fr_SN' || goog.LOCALE == 'fr-SN') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_fr_SN;
}

if (goog.LOCALE == 'fur') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_fur;
}

if (goog.LOCALE == 'fur_IT' || goog.LOCALE == 'fur-IT') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_fur;
}

if (goog.LOCALE == 'ga') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ga;
}

if (goog.LOCALE == 'ga_IE' || goog.LOCALE == 'ga-IE') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ga;
}

if (goog.LOCALE == 'gaa') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_gaa;
}

if (goog.LOCALE == 'gaa_GH' || goog.LOCALE == 'gaa-GH') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_gaa;
}

if (goog.LOCALE == 'gez') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_gez;
}

if (goog.LOCALE == 'gez_ER' || goog.LOCALE == 'gez-ER') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_gez;
}

if (goog.LOCALE == 'gez_ET' || goog.LOCALE == 'gez-ET') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_gez;
}

if (goog.LOCALE == 'gl_ES' || goog.LOCALE == 'gl-ES') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_gl_ES;
}

if (goog.LOCALE == 'gsw_CH' || goog.LOCALE == 'gsw-CH') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_gsw_CH;
}

if (goog.LOCALE == 'gu_IN' || goog.LOCALE == 'gu-IN') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_gu_IN;
}

if (goog.LOCALE == 'gv') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_gv;
}

if (goog.LOCALE == 'gv_GB' || goog.LOCALE == 'gv-GB') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_gv;
}

if (goog.LOCALE == 'ha') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ha;
}

if (goog.LOCALE == 'ha_Arab' || goog.LOCALE == 'ha-Arab') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ha_Arab;
}

if (goog.LOCALE == 'ha_Arab_NG' || goog.LOCALE == 'ha-Arab-NG') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ha_Arab;
}

if (goog.LOCALE == 'ha_Arab_SD' || goog.LOCALE == 'ha-Arab-SD') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ha_Arab;
}

if (goog.LOCALE == 'ha_GH' || goog.LOCALE == 'ha-GH') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ha;
}

if (goog.LOCALE == 'ha_Latn' || goog.LOCALE == 'ha-Latn') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ha;
}

if (goog.LOCALE == 'ha_Latn_GH' || goog.LOCALE == 'ha-Latn-GH') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ha;
}

if (goog.LOCALE == 'ha_Latn_NE' || goog.LOCALE == 'ha-Latn-NE') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ha;
}

if (goog.LOCALE == 'ha_Latn_NG' || goog.LOCALE == 'ha-Latn-NG') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ha;
}

if (goog.LOCALE == 'ha_NE' || goog.LOCALE == 'ha-NE') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ha;
}

if (goog.LOCALE == 'ha_NG' || goog.LOCALE == 'ha-NG') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ha;
}

if (goog.LOCALE == 'ha_SD' || goog.LOCALE == 'ha-SD') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ha_SD;
}

if (goog.LOCALE == 'haw') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_haw;
}

if (goog.LOCALE == 'haw_US' || goog.LOCALE == 'haw-US') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_haw;
}

if (goog.LOCALE == 'he_IL' || goog.LOCALE == 'he-IL') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_he_IL;
}

if (goog.LOCALE == 'hi_IN' || goog.LOCALE == 'hi-IN') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_hi_IN;
}

if (goog.LOCALE == 'hr_HR' || goog.LOCALE == 'hr-HR') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_hr_HR;
}

if (goog.LOCALE == 'hu_HU' || goog.LOCALE == 'hu-HU') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_hu_HU;
}

if (goog.LOCALE == 'hy') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_hy;
}

if (goog.LOCALE == 'hy_AM' || goog.LOCALE == 'hy-AM') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_hy;
}

if (goog.LOCALE == 'ia') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ia;
}

if (goog.LOCALE == 'id_ID' || goog.LOCALE == 'id-ID') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_id_ID;
}

if (goog.LOCALE == 'ig') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ig;
}

if (goog.LOCALE == 'ig_NG' || goog.LOCALE == 'ig-NG') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ig;
}

if (goog.LOCALE == 'ii') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ii;
}

if (goog.LOCALE == 'ii_CN' || goog.LOCALE == 'ii-CN') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ii;
}

if (goog.LOCALE == 'is_IS' || goog.LOCALE == 'is-IS') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_is_IS;
}

if (goog.LOCALE == 'it_CH' || goog.LOCALE == 'it-CH') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_it_CH;
}

if (goog.LOCALE == 'it_IT' || goog.LOCALE == 'it-IT') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_it_IT;
}

if (goog.LOCALE == 'iu') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_iu;
}

if (goog.LOCALE == 'ja_JP' || goog.LOCALE == 'ja-JP') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ja_JP;
}

if (goog.LOCALE == 'ka') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ka;
}

if (goog.LOCALE == 'ka_GE' || goog.LOCALE == 'ka-GE') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ka;
}

if (goog.LOCALE == 'kaj') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_kaj;
}

if (goog.LOCALE == 'kaj_NG' || goog.LOCALE == 'kaj-NG') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_kaj;
}

if (goog.LOCALE == 'kam') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_kam;
}

if (goog.LOCALE == 'kam_KE' || goog.LOCALE == 'kam-KE') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_kam;
}

if (goog.LOCALE == 'kcg') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_kcg;
}

if (goog.LOCALE == 'kcg_NG' || goog.LOCALE == 'kcg-NG') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_kcg;
}

if (goog.LOCALE == 'kfo') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_kfo;
}

if (goog.LOCALE == 'kfo_CI' || goog.LOCALE == 'kfo-CI') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_kfo;
}

if (goog.LOCALE == 'kk') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_kk;
}

if (goog.LOCALE == 'kk_Cyrl' || goog.LOCALE == 'kk-Cyrl') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_kk;
}

if (goog.LOCALE == 'kk_Cyrl_KZ' || goog.LOCALE == 'kk-Cyrl-KZ') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_kk;
}

if (goog.LOCALE == 'kk_KZ' || goog.LOCALE == 'kk-KZ') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_kk;
}

if (goog.LOCALE == 'kl') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_kl;
}

if (goog.LOCALE == 'kl_GL' || goog.LOCALE == 'kl-GL') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_kl;
}

if (goog.LOCALE == 'km') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_km;
}

if (goog.LOCALE == 'km_KH' || goog.LOCALE == 'km-KH') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_km;
}

if (goog.LOCALE == 'kn_IN' || goog.LOCALE == 'kn-IN') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_kn_IN;
}

if (goog.LOCALE == 'ko_KR' || goog.LOCALE == 'ko-KR') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ko_KR;
}

if (goog.LOCALE == 'kok') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_kok;
}

if (goog.LOCALE == 'kok_IN' || goog.LOCALE == 'kok-IN') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_kok;
}

if (goog.LOCALE == 'kpe') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_kpe;
}

if (goog.LOCALE == 'kpe_GN' || goog.LOCALE == 'kpe-GN') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_kpe;
}

if (goog.LOCALE == 'kpe_LR' || goog.LOCALE == 'kpe-LR') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_kpe;
}

if (goog.LOCALE == 'ku') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ku;
}

if (goog.LOCALE == 'ku_Arab' || goog.LOCALE == 'ku-Arab') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ku;
}

if (goog.LOCALE == 'ku_Arab_IQ' || goog.LOCALE == 'ku-Arab-IQ') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ku;
}

if (goog.LOCALE == 'ku_Arab_IR' || goog.LOCALE == 'ku-Arab-IR') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ku;
}

if (goog.LOCALE == 'ku_IQ' || goog.LOCALE == 'ku-IQ') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ku;
}

if (goog.LOCALE == 'ku_IR' || goog.LOCALE == 'ku-IR') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ku;
}

if (goog.LOCALE == 'ku_Latn' || goog.LOCALE == 'ku-Latn') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ku_Latn;
}

if (goog.LOCALE == 'ku_Latn_SY' || goog.LOCALE == 'ku-Latn-SY') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ku_Latn;
}

if (goog.LOCALE == 'ku_Latn_TR' || goog.LOCALE == 'ku-Latn-TR') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ku_Latn;
}

if (goog.LOCALE == 'ku_SY' || goog.LOCALE == 'ku-SY') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ku_SY;
}

if (goog.LOCALE == 'ku_TR' || goog.LOCALE == 'ku-TR') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ku_TR;
}

if (goog.LOCALE == 'kw') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_kw;
}

if (goog.LOCALE == 'kw_GB' || goog.LOCALE == 'kw-GB') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_kw;
}

if (goog.LOCALE == 'ky') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ky;
}

if (goog.LOCALE == 'ky_KG' || goog.LOCALE == 'ky-KG') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ky;
}

if (goog.LOCALE == 'ln_CD' || goog.LOCALE == 'ln-CD') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ln_CD;
}

if (goog.LOCALE == 'ln_CG' || goog.LOCALE == 'ln-CG') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ln_CG;
}

if (goog.LOCALE == 'lo') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_lo;
}

if (goog.LOCALE == 'lo_LA' || goog.LOCALE == 'lo-LA') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_lo;
}

if (goog.LOCALE == 'lt_LT' || goog.LOCALE == 'lt-LT') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_lt_LT;
}

if (goog.LOCALE == 'lv_LV' || goog.LOCALE == 'lv-LV') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_lv_LV;
}

if (goog.LOCALE == 'mk') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_mk;
}

if (goog.LOCALE == 'mk_MK' || goog.LOCALE == 'mk-MK') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_mk;
}

if (goog.LOCALE == 'ml_IN' || goog.LOCALE == 'ml-IN') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ml_IN;
}

if (goog.LOCALE == 'mn') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_mn;
}

if (goog.LOCALE == 'mn_CN' || goog.LOCALE == 'mn-CN') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_mn;
}

if (goog.LOCALE == 'mn_Cyrl' || goog.LOCALE == 'mn-Cyrl') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_mn;
}

if (goog.LOCALE == 'mn_Cyrl_MN' || goog.LOCALE == 'mn-Cyrl-MN') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_mn;
}

if (goog.LOCALE == 'mn_MN' || goog.LOCALE == 'mn-MN') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_mn;
}

if (goog.LOCALE == 'mn_Mong' || goog.LOCALE == 'mn-Mong') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_mn;
}

if (goog.LOCALE == 'mn_Mong_CN' || goog.LOCALE == 'mn-Mong-CN') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_mn;
}

if (goog.LOCALE == 'mr_IN' || goog.LOCALE == 'mr-IN') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_mr_IN;
}

if (goog.LOCALE == 'ms_BN' || goog.LOCALE == 'ms-BN') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ms_BN;
}

if (goog.LOCALE == 'ms_MY' || goog.LOCALE == 'ms-MY') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ms_MY;
}

if (goog.LOCALE == 'mt_MT' || goog.LOCALE == 'mt-MT') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_mt_MT;
}

if (goog.LOCALE == 'my') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_my;
}

if (goog.LOCALE == 'my_MM' || goog.LOCALE == 'my-MM') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_my;
}

if (goog.LOCALE == 'nb') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_nb;
}

if (goog.LOCALE == 'nb_NO' || goog.LOCALE == 'nb-NO') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_nb;
}

if (goog.LOCALE == 'nds') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_nds;
}

if (goog.LOCALE == 'nds_DE' || goog.LOCALE == 'nds-DE') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_nds;
}

if (goog.LOCALE == 'ne') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ne;
}

if (goog.LOCALE == 'ne_IN' || goog.LOCALE == 'ne-IN') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ne_IN;
}

if (goog.LOCALE == 'ne_NP' || goog.LOCALE == 'ne-NP') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ne;
}

if (goog.LOCALE == 'nl_BE' || goog.LOCALE == 'nl-BE') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_nl_BE;
}

if (goog.LOCALE == 'nl_NL' || goog.LOCALE == 'nl-NL') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_nl_NL;
}

if (goog.LOCALE == 'nn') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_nn;
}

if (goog.LOCALE == 'nn_NO' || goog.LOCALE == 'nn-NO') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_nn;
}

if (goog.LOCALE == 'nr') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_nr;
}

if (goog.LOCALE == 'nr_ZA' || goog.LOCALE == 'nr-ZA') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_nr;
}

if (goog.LOCALE == 'nso') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_nso;
}

if (goog.LOCALE == 'nso_ZA' || goog.LOCALE == 'nso-ZA') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_nso;
}

if (goog.LOCALE == 'ny') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ny;
}

if (goog.LOCALE == 'ny_MW' || goog.LOCALE == 'ny-MW') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ny;
}

if (goog.LOCALE == 'oc') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_oc;
}

if (goog.LOCALE == 'oc_FR' || goog.LOCALE == 'oc-FR') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_oc;
}

if (goog.LOCALE == 'om') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_om;
}

if (goog.LOCALE == 'om_ET' || goog.LOCALE == 'om-ET') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_om;
}

if (goog.LOCALE == 'om_KE' || goog.LOCALE == 'om-KE') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_om;
}

if (goog.LOCALE == 'or_IN' || goog.LOCALE == 'or-IN') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_or_IN;
}

if (goog.LOCALE == 'pa') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_pa;
}

if (goog.LOCALE == 'pa_Arab' || goog.LOCALE == 'pa-Arab') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_pa_Arab;
}

if (goog.LOCALE == 'pa_Arab_PK' || goog.LOCALE == 'pa-Arab-PK') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_pa_Arab;
}

if (goog.LOCALE == 'pa_Guru' || goog.LOCALE == 'pa-Guru') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_pa;
}

if (goog.LOCALE == 'pa_Guru_IN' || goog.LOCALE == 'pa-Guru-IN') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_pa;
}

if (goog.LOCALE == 'pa_IN' || goog.LOCALE == 'pa-IN') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_pa;
}

if (goog.LOCALE == 'pa_PK' || goog.LOCALE == 'pa-PK') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_pa_PK;
}

if (goog.LOCALE == 'pl_PL' || goog.LOCALE == 'pl-PL') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_pl_PL;
}

if (goog.LOCALE == 'ps') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ps;
}

if (goog.LOCALE == 'ps_AF' || goog.LOCALE == 'ps-AF') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ps;
}

if (goog.LOCALE == 'ro_MD' || goog.LOCALE == 'ro-MD') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ro_MD;
}

if (goog.LOCALE == 'ro_RO' || goog.LOCALE == 'ro-RO') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ro_RO;
}

if (goog.LOCALE == 'ru_RU' || goog.LOCALE == 'ru-RU') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ru_RU;
}

if (goog.LOCALE == 'ru_UA' || goog.LOCALE == 'ru-UA') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ru_UA;
}

if (goog.LOCALE == 'rw') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_rw;
}

if (goog.LOCALE == 'rw_RW' || goog.LOCALE == 'rw-RW') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_rw;
}

if (goog.LOCALE == 'sa') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_sa;
}

if (goog.LOCALE == 'sa_IN' || goog.LOCALE == 'sa-IN') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_sa;
}

if (goog.LOCALE == 'se') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_se;
}

if (goog.LOCALE == 'se_FI' || goog.LOCALE == 'se-FI') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_se_FI;
}

if (goog.LOCALE == 'se_NO' || goog.LOCALE == 'se-NO') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_se;
}

if (goog.LOCALE == 'sh') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_sh;
}

if (goog.LOCALE == 'sh_BA' || goog.LOCALE == 'sh-BA') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_sh;
}

if (goog.LOCALE == 'sh_CS' || goog.LOCALE == 'sh-CS') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_sh;
}

if (goog.LOCALE == 'sh_YU' || goog.LOCALE == 'sh-YU') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_sh;
}

if (goog.LOCALE == 'si') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_si;
}

if (goog.LOCALE == 'si_LK' || goog.LOCALE == 'si-LK') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_si;
}

if (goog.LOCALE == 'sid') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_sid;
}

if (goog.LOCALE == 'sid_ET' || goog.LOCALE == 'sid-ET') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_sid;
}

if (goog.LOCALE == 'sk_SK' || goog.LOCALE == 'sk-SK') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_sk_SK;
}

if (goog.LOCALE == 'sl_SI' || goog.LOCALE == 'sl-SI') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_sl_SI;
}

if (goog.LOCALE == 'so') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_so;
}

if (goog.LOCALE == 'so_DJ' || goog.LOCALE == 'so-DJ') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_so;
}

if (goog.LOCALE == 'so_ET' || goog.LOCALE == 'so-ET') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_so;
}

if (goog.LOCALE == 'so_KE' || goog.LOCALE == 'so-KE') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_so;
}

if (goog.LOCALE == 'so_SO' || goog.LOCALE == 'so-SO') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_so;
}

if (goog.LOCALE == 'sq_AL' || goog.LOCALE == 'sq-AL') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_sq_AL;
}

if (goog.LOCALE == 'sr_BA' || goog.LOCALE == 'sr-BA') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_sr_BA;
}

if (goog.LOCALE == 'sr_CS' || goog.LOCALE == 'sr-CS') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_sr_CS;
}

if (goog.LOCALE == 'sr_Cyrl' || goog.LOCALE == 'sr-Cyrl') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_sr_Cyrl;
}

if (goog.LOCALE == 'sr_Cyrl_BA' || goog.LOCALE == 'sr-Cyrl-BA') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_sr_Cyrl_BA;
}

if (goog.LOCALE == 'sr_Cyrl_CS' || goog.LOCALE == 'sr-Cyrl-CS') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_sr_Cyrl;
}

if (goog.LOCALE == 'sr_Cyrl_ME' || goog.LOCALE == 'sr-Cyrl-ME') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_sr_Cyrl;
}

if (goog.LOCALE == 'sr_Cyrl_RS' || goog.LOCALE == 'sr-Cyrl-RS') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_sr_Cyrl;
}

if (goog.LOCALE == 'sr_Cyrl_YU' || goog.LOCALE == 'sr-Cyrl-YU') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_sr_Cyrl;
}

if (goog.LOCALE == 'sr_Latn' || goog.LOCALE == 'sr-Latn') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_sr_Latn;
}

if (goog.LOCALE == 'sr_Latn_BA' || goog.LOCALE == 'sr-Latn-BA') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_sr_Latn;
}

if (goog.LOCALE == 'sr_Latn_CS' || goog.LOCALE == 'sr-Latn-CS') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_sr_Latn;
}

if (goog.LOCALE == 'sr_Latn_ME' || goog.LOCALE == 'sr-Latn-ME') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_sr_Latn_ME;
}

if (goog.LOCALE == 'sr_Latn_RS' || goog.LOCALE == 'sr-Latn-RS') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_sr_Latn;
}

if (goog.LOCALE == 'sr_Latn_YU' || goog.LOCALE == 'sr-Latn-YU') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_sr_Latn;
}

if (goog.LOCALE == 'sr_ME' || goog.LOCALE == 'sr-ME') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_sr_ME;
}

if (goog.LOCALE == 'sr_RS' || goog.LOCALE == 'sr-RS') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_sr_RS;
}

if (goog.LOCALE == 'sr_YU' || goog.LOCALE == 'sr-YU') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_sr_YU;
}

if (goog.LOCALE == 'ss') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ss;
}

if (goog.LOCALE == 'ss_SZ' || goog.LOCALE == 'ss-SZ') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ss;
}

if (goog.LOCALE == 'ss_ZA' || goog.LOCALE == 'ss-ZA') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ss;
}

if (goog.LOCALE == 'st') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_st;
}

if (goog.LOCALE == 'st_LS' || goog.LOCALE == 'st-LS') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_st;
}

if (goog.LOCALE == 'st_ZA' || goog.LOCALE == 'st-ZA') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_st;
}

if (goog.LOCALE == 'sv_FI' || goog.LOCALE == 'sv-FI') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_sv_FI;
}

if (goog.LOCALE == 'sv_SE' || goog.LOCALE == 'sv-SE') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_sv_SE;
}

if (goog.LOCALE == 'sw_KE' || goog.LOCALE == 'sw-KE') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_sw_KE;
}

if (goog.LOCALE == 'sw_TZ' || goog.LOCALE == 'sw-TZ') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_sw_TZ;
}

if (goog.LOCALE == 'syr') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_syr;
}

if (goog.LOCALE == 'syr_SY' || goog.LOCALE == 'syr-SY') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_syr;
}

if (goog.LOCALE == 'ta_IN' || goog.LOCALE == 'ta-IN') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ta_IN;
}

if (goog.LOCALE == 'te_IN' || goog.LOCALE == 'te-IN') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_te_IN;
}

if (goog.LOCALE == 'tg') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_tg;
}

if (goog.LOCALE == 'tg_Cyrl' || goog.LOCALE == 'tg-Cyrl') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_tg;
}

if (goog.LOCALE == 'tg_Cyrl_TJ' || goog.LOCALE == 'tg-Cyrl-TJ') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_tg;
}

if (goog.LOCALE == 'tg_TJ' || goog.LOCALE == 'tg-TJ') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_tg;
}

if (goog.LOCALE == 'th_TH' || goog.LOCALE == 'th-TH') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_th_TH;
}

if (goog.LOCALE == 'ti') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ti;
}

if (goog.LOCALE == 'ti_ER' || goog.LOCALE == 'ti-ER') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ti_ER;
}

if (goog.LOCALE == 'ti_ET' || goog.LOCALE == 'ti-ET') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ti;
}

if (goog.LOCALE == 'tig') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_tig;
}

if (goog.LOCALE == 'tig_ER' || goog.LOCALE == 'tig-ER') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_tig;
}

if (goog.LOCALE == 'tl_PH' || goog.LOCALE == 'tl-PH') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_tl_PH;
}

if (goog.LOCALE == 'tn') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_tn;
}

if (goog.LOCALE == 'tn_ZA' || goog.LOCALE == 'tn-ZA') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_tn;
}

if (goog.LOCALE == 'to') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_to;
}

if (goog.LOCALE == 'to_TO' || goog.LOCALE == 'to-TO') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_to;
}

if (goog.LOCALE == 'tr_TR' || goog.LOCALE == 'tr-TR') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_tr_TR;
}

if (goog.LOCALE == 'trv') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_trv;
}

if (goog.LOCALE == 'trv_TW' || goog.LOCALE == 'trv-TW') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_trv;
}

if (goog.LOCALE == 'ts') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ts;
}

if (goog.LOCALE == 'ts_ZA' || goog.LOCALE == 'ts-ZA') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ts;
}

if (goog.LOCALE == 'tt') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_tt;
}

if (goog.LOCALE == 'tt_RU' || goog.LOCALE == 'tt-RU') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_tt;
}

if (goog.LOCALE == 'ug') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ug;
}

if (goog.LOCALE == 'ug_Arab' || goog.LOCALE == 'ug-Arab') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ug;
}

if (goog.LOCALE == 'ug_Arab_CN' || goog.LOCALE == 'ug-Arab-CN') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ug;
}

if (goog.LOCALE == 'ug_CN' || goog.LOCALE == 'ug-CN') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ug;
}

if (goog.LOCALE == 'uk_UA' || goog.LOCALE == 'uk-UA') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_uk_UA;
}

if (goog.LOCALE == 'ur_IN' || goog.LOCALE == 'ur-IN') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ur_IN;
}

if (goog.LOCALE == 'ur_PK' || goog.LOCALE == 'ur-PK') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ur_PK;
}

if (goog.LOCALE == 'uz') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_uz;
}

if (goog.LOCALE == 'uz_AF' || goog.LOCALE == 'uz-AF') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_uz_AF;
}

if (goog.LOCALE == 'uz_Arab' || goog.LOCALE == 'uz-Arab') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_uz_Arab;
}

if (goog.LOCALE == 'uz_Arab_AF' || goog.LOCALE == 'uz-Arab-AF') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_uz_Arab;
}

if (goog.LOCALE == 'uz_Cyrl' || goog.LOCALE == 'uz-Cyrl') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_uz;
}

if (goog.LOCALE == 'uz_Cyrl_UZ' || goog.LOCALE == 'uz-Cyrl-UZ') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_uz;
}

if (goog.LOCALE == 'uz_Latn' || goog.LOCALE == 'uz-Latn') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_uz_Latn;
}

if (goog.LOCALE == 'uz_Latn_UZ' || goog.LOCALE == 'uz-Latn-UZ') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_uz_Latn;
}

if (goog.LOCALE == 'uz_UZ' || goog.LOCALE == 'uz-UZ') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_uz;
}

if (goog.LOCALE == 've') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ve;
}

if (goog.LOCALE == 've_ZA' || goog.LOCALE == 've-ZA') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_ve;
}

if (goog.LOCALE == 'vi_VN' || goog.LOCALE == 'vi-VN') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_vi_VN;
}

if (goog.LOCALE == 'wal') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_wal;
}

if (goog.LOCALE == 'wal_ET' || goog.LOCALE == 'wal-ET') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_wal;
}

if (goog.LOCALE == 'wo') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_wo;
}

if (goog.LOCALE == 'wo_Latn' || goog.LOCALE == 'wo-Latn') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_wo;
}

if (goog.LOCALE == 'wo_Latn_SN' || goog.LOCALE == 'wo-Latn-SN') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_wo;
}

if (goog.LOCALE == 'wo_SN' || goog.LOCALE == 'wo-SN') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_wo;
}

if (goog.LOCALE == 'xh') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_xh;
}

if (goog.LOCALE == 'xh_ZA' || goog.LOCALE == 'xh-ZA') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_xh;
}

if (goog.LOCALE == 'yo') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_yo;
}

if (goog.LOCALE == 'yo_NG' || goog.LOCALE == 'yo-NG') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_yo;
}

if (goog.LOCALE == 'zh_Hans' || goog.LOCALE == 'zh-Hans') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_zh_Hans;
}

if (goog.LOCALE == 'zh_Hans_CN' || goog.LOCALE == 'zh-Hans-CN') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_zh_Hans;
}

if (goog.LOCALE == 'zh_Hans_HK' || goog.LOCALE == 'zh-Hans-HK') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_zh_Hans;
}

if (goog.LOCALE == 'zh_Hans_MO' || goog.LOCALE == 'zh-Hans-MO') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_zh_Hans;
}

if (goog.LOCALE == 'zh_Hans_SG' || goog.LOCALE == 'zh-Hans-SG') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_zh_Hans_SG;
}

if (goog.LOCALE == 'zh_Hant' || goog.LOCALE == 'zh-Hant') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_zh_Hant;
}

if (goog.LOCALE == 'zh_Hant_HK' || goog.LOCALE == 'zh-Hant-HK') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_zh_Hant_HK;
}

if (goog.LOCALE == 'zh_Hant_MO' || goog.LOCALE == 'zh-Hant-MO') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_zh_Hant_MO;
}

if (goog.LOCALE == 'zh_Hant_TW' || goog.LOCALE == 'zh-Hant-TW') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_zh_Hant;
}

if (goog.LOCALE == 'zh_MO' || goog.LOCALE == 'zh-MO') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_zh_MO;
}

if (goog.LOCALE == 'zh_SG' || goog.LOCALE == 'zh-SG') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_zh_SG;
}

if (goog.LOCALE == 'zu') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_zu;
}

if (goog.LOCALE == 'zu_ZA' || goog.LOCALE == 'zu-ZA') {
  goog.i18n.DateTimeSymbols = goog.i18n.DateTimeSymbols_zu;
}

