(ns geschichte.p2p.log
  "Logging middleware for geschichte."
  (:require [geschichte.platform-log :refer [debug info warn error]]
            [konserve.protocols :refer [IEDNAsyncKeyValueStore -assoc-in -get-in -update-in]]
            [clojure.set :as set]
                  [clojure.core.async :as async
                   :refer [<! >! >!! <!! timeout chan alt! go put!
                           filter< map< go-loop pub sub unsub close!]]
                                             
                                                                                       )
                                                                            )


(defn logger
  "Appends messages of in and out to log-atom under [topic :in/:out] to a vector."
  [log-atom topic [in out]]
  (let [new-in (chan)
        new-out (chan)]
    (go-loop [i (<! in)]
      (if i
        (do
          (swap! log-atom update-in [topic :in] (fnil conj []) i)
          (>! new-in i)
          (recur (<! in)))
        (close! new-in)))
    (go-loop [o (<! new-out)]
      (if o
        (do
          (swap! log-atom update-in [topic :out] (fnil conj []) o)
          (>! out o)
          (recur (<! new-out)))
        (close! new-out)))
    [new-in new-out]))

;;;;;;;;;;;; This file autogenerated from src/cljx/geschichte/p2p/log.cljx
