;; ## Swarm Handler Protocol
(ns ^{:author "Jason Ozias"}
  net.ozias.swarmhandler.handler)

;; ### Handler
;; This protocol defines 4 functions
;;
;; #### handlercommands
;; Evaluate to a vector of supported commands
;;
;; #### handlername
;; Evaluate to the name of the protocol as a string
;;
;; #### handlerhelp
;; Evaluate to a vector of strings representing each line of help text
;;
;; #### parse
;; Parse the given input map
;;
;; The input map will always have a command key
;;
;;     {...
;;      :command <cmd>
;;     ...}
(defprotocol Handler
  "Swarm Handler Protocol"
  (handlercommands [_]
    "Evaluate to a vector of supported commands")
  (handlername [_]
    "Evaluate to the name of the protocol as a string")
  (handlerhelp [_]
    "Evaluate to a vector of strings representing each line of help text")
  (parse [_ input]
    "Parse the given input map

    The input map will always have a command key

    {...
     :command <cmd>
     ...}
    "))
