(def major "0")
(def minor "1")
(def patch "0")
(def label "-SNAPSHOT")

(def project-version
  (apply str
         (conj (->> (filter #(not (empty? %)) [major minor patch])
                    (interpose ".")
                    (vec))
               label)))

(defproject net.ozias/swarmhandler project-version
  :description "Distributed computing implemented in Clojure"
  :url "https://github.com/CraZySacX/swarm"
  :license {:name "MIT"
            :url "http://opensource.org/licenses/MIT"}
  :dependencies [[org.clojure/clojure "1.5.1"]]
  :profiles {:dev {:source-paths ["dev"]
                   :dependencies [[org.clojure/tools.namespace "0.2.4"]]}}
  :aliases {"build" ["install"]
            "docs" ["do" "doc," "marg" "--multi" "src/" "test/"]
            "deployall" ["do" "deploy," "deploy" "clojars"]}
  :jvm-opts ["-Xms1024m" "-Xmx1024m"]
  :plugins [[codox "0.6.6"]
            [lein-marginalia "0.7.1"]]
  :deploy-repositories [["snapshots" 
                         {:url "http://www.ozias.net/archiva/repository/snapshots/"
                          :creds :gpg}]
                        ["releases"
                         {:url "http://www.ozias.net/archiva/repository/internal/"
                          :creds :gpg}]]
  :target-path "target/"
  :scm {:name "git"
         :url "https://github.com/CraZySacX/swarm"}
  :codox {:output-dir "api"
          :sources ["src" "test"]}
  :manifest {"Implementation-Version" ~project-version})
