(ns net.ozias.swarm.handler.helphandler
  (:require [clojure.string :refer (split)]
            [matchure :refer (cond-match)]
            [net.ozias.swarm.libswarm :refer (separator)]
            [net.ozias.swarm.handler.handlerhandler :refer (handlers get-handler)]
            [net.ozias.swarmhandler.handler :refer (Handler) :as handleit]
            [taoensso.timbre :as timbre :refer (debug info)]))

(defn- swarm-cmds []
  (apply str (interpose ", " (flatten (mapv #(handleit/handlercommands %) @handlers)))))

(defn- gen-output [handler]
  (mapv #(info %) (handleit/handlerhelp handler)))

(defn- handler-help
  ([]
     (gen-output (get-handler "help")))
  ([command]
     (let [[_ name] (re-matches #"^help (.*)" command)
           handler (get-handler name)]
       (if (nil? handler)
         (info name "not found")
         (gen-output handler)))))

(defrecord HelpHandler []
  Handler
  (handlercommands [_] ["?" "help" "help <cmd>"])
  (handlername [_] "help")
  (handlerhelp [this] [(separator 80 "=")
                 "Swarm Help"
                 (separator 80 "=")
                 "?:              Show this information."
                 "help:           Show this information."
                 "help <handler>: Show more detailed help information for the given handler."
                 ""
                 "Supported Swarm Commands: "
                 (swarm-cmds)])
  (parse [_ [options args :as cl]]
    (let [command (:command options)]
      (cond-match
        [#"^\?$" command] (handler-help)
        [#"^help$" command] (handler-help)
        [#"^help .*" command] (handler-help command)
        [? command] (debug "Help Handler passing:" command))
      cl)))
