(ns net.ozias.swarm.handler.handlerhandler
  (:require [clojure.set :refer (difference)]
            [matchure :refer (cond-match)]
            [net.ozias.swarm.libswarm :refer (separator)]
            [net.ozias.swarmhandler.handler :refer (Handler) :as handleit]
            [taoensso.timbre :as timbre :refer (debug info)]))

(def handlers (atom []))

(defn add-handler [handler]
  (swap! handlers conj handler))

(defn get-handler [name]
  (first (filter #(= name (handleit/handlername %)) @handlers)))

(defn- add-file [filepath handlername]
  (let [pre-ns (set (all-ns))]
    (try
      (let [_ (load-file filepath)
            post-ns (set (all-ns))
            ns-sym (ns-name (first (difference post-ns pre-ns)))
            handler (ns-resolve ns-sym (symbol (str "->" handlername)))]
        (add-handler (handler)))
      (catch Exception e (info (.getMessage e))))))

(defn- add-namespace [ns handlername]
  (let [ns-sym (symbol (clojure.string/replace ns #"/" "."))
        _ (if (not (find-ns ns-sym)) (load ns)) 
        handler (ns-resolve ns-sym (symbol (str "->" handlername)))]
    (add-handler (handler))))

(defn- my-add [command]
  (let [[_ ns handlername] (re-matches #"^add handler (.*) (.*)" command)]
    (if (.endsWith ns ".clj")
      (add-file ns handlername)
      (add-namespace ns handlername))))

(defrecord HandlerHandler []
  Handler
  (handlercommands [_] ["list handlers"
                        "add handler <file>"
                        "get handler <name>"])
  (handlername [_] "handler")
  (handlerhelp [this] [(separator 80 "=")
                       "Handler Handler Help"
                       (separator 80 "=")
                       "The Handler handler is generally used to issue commands that operate on other"
                       "handlers"
                       ""
                       "list handlers: Show a list of all registered handlers by name."
                       "add handler <handler file>: Add a handler to the handler chain as defined in the"
                       "given file."])
  (parse [_ [options args :as cl]]
    (let [command (:command options)]
      (cond-match
        [#"^list handlers$" command] (mapv #(info (handleit/handlername %)) @handlers)
        [#"^add handler .*" command] (my-add command)
        [? command] (debug "HandlerHandler passing:" command))
      cl)))
