(ns net.ozias.swarm.handler.exithandler
  (:require [net.ozias.swarm.libswarm :refer (separator)]
            [net.ozias.swarmhandler.handler :refer (Handler)]
            [taoensso.timbre :as timbre :refer (debug)]))

(defn- myname []
  "exit")

(defrecord ExitHandler []
  Handler
  (handlercommands [_] [(myname)])
  (handlername [_] (myname))
  (handlerhelp [_] [(separator 80 "=")
                    "Exit Handler Help"
                    (separator 80 "=")
                    "exit: Exit the application."])
  (parse [_ [options args :as cl]] 
    (if (:debug options)
      (debug (myname) ":" cl))
    (if (= (:command options) (myname))
      false
      cl)))
