(ns net.ozias.swarm.handler.sshhandler
  (:require [matchure :refer (cond-match)]
            [net.ozias.swarm.libswarm :refer (separator)]
            [net.ozias.swarmhandler.handler :refer (Handler) :as handleit]
            [taoensso.timbre :as timbre :refer (debug info)]))

(defrecord SSHHandler []
  Handler
  (handlercommands [_] ["ssh"])
  (handlername [_] "ssh")
  (handlerhelp [this] [(separator 80 "=")
                       "SSH Handler Help"
                       (separator 80 "=")
                       "The ssh handler is used to issue commands via ssh in broadcast or target mode."
                       ""
                       "ssh <cmd>:   Execute a command via ssh."
                       "mode <mode>: Change the ssh mode (broadcast or targeted)"])
  (parse [_ [options args :as cl]]
    (let [command (:command options)]
      (cond-match command
        #"^ssh .*" (info "ssh matched")
        #"^mode .*" (info "mode matched")
        [? command] (debug "SSHHandler passing:" command))
      cl)))
