// Compiled by ClojureScript 1.10.516 {}
goog.provide('thi.ng.geom.vector');
goog.require('cljs.core');
goog.require('thi.ng.geom.core');
goog.require('thi.ng.math.core');
goog.require('thi.ng.dstruct.streams');
goog.require('thi.ng.xerror.core');









/**
* @constructor
 * @implements {thi.ng.geom.core.ITranslate}
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {thi.ng.math.core.IDotProduct}
 * @implements {cljs.core.IReversible}
 * @implements {thi.ng.math.core.IMutableMathOps}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {thi.ng.math.core.ICrossProduct}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {thi.ng.math.core.IDeltaEquals}
 * @implements {thi.ng.geom.core.IPolar}
 * @implements {thi.ng.geom.vector.Object}
 * @implements {thi.ng.geom.core.IClear}
 * @implements {thi.ng.math.core.IInvert}
 * @implements {cljs.core.ICounted}
 * @implements {thi.ng.math.core.ILimit}
 * @implements {thi.ng.dstruct.streams.IBuffer}
 * @implements {cljs.core.ISeq}
 * @implements {thi.ng.math.core.IInterpolate}
 * @implements {cljs.core.INext}
 * @implements {thi.ng.math.core.IMathOps}
 * @implements {thi.ng.geom.core.ITransform}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {thi.ng.math.core.IMinMax}
 * @implements {thi.ng.geom.core.IRotate}
 * @implements {thi.ng.math.core.INormalize}
 * @implements {thi.ng.math.core.IMagnitude}
 * @implements {thi.ng.geom.core.IScale}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {thi.ng.geom.core.IReflect}
 * @implements {thi.ng.geom.core.IHeading}
 * @implements {thi.ng.geom.core.IDistance}
 * @implements {cljs.core.IComparable}
 * @implements {thi.ng.dstruct.streams.IIntoBuffer}
 * @implements {cljs.core.ISequential}
 * @implements {thi.ng.geom.core.INormal}
 * @implements {cljs.core.IWithMeta}
 * @implements {thi.ng.geom.core.IVectorReduce}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
thi.ng.geom.vector.Vec2 = (function (buf,_hash,_meta){
this.buf = buf;
this._hash = _hash;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 2314101723;
this.cljs$lang$protocol_mask$partition1$ = 10240;
});
thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$ITransform$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$ITransform$transform$arity$2 = (function (_,m){
var self__ = this;
var ___$1 = this;
return thi.ng.geom.core.transform_vector.call(null,m,___$1);
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMutableMathOps$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMutableMathOps$__BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
(self__.buf[(0)] = (- (self__.buf[(0)])));

(self__.buf[(1)] = (- (self__.buf[(1)])));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMutableMathOps$__BANG_$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var G__17064_17413 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec2)){
var G__17065_17414 = v.buf;
(self__.buf[(0)] = ((G__17064_17413[(0)]) - (G__17065_17414[(0)])));

(self__.buf[(1)] = ((G__17064_17413[(1)]) - (G__17065_17414[(1)])));

self__._hash = null;
} else {
if(typeof v === 'number'){
(self__.buf[(0)] = ((G__17064_17413[(0)]) - v));

(self__.buf[(1)] = ((G__17064_17413[(1)]) - v));

self__._hash = null;
} else {
(self__.buf[(0)] = ((G__17064_17413[(0)]) - cljs.core.nth.call(null,v,(0),0.0)));

(self__.buf[(1)] = ((G__17064_17413[(1)]) - cljs.core.nth.call(null,v,(1),0.0)));

self__._hash = null;
}
}

return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMutableMathOps$__BANG_$arity$3 = (function (_,v1,v2){
var self__ = this;
var ___$1 = this;
var G__17073_17415 = typeof v1 === 'number';
var G__17074_17416 = typeof v2 === 'number';
if(((G__17073_17415)?G__17074_17416:false)){
(self__.buf[(0)] = ((self__.buf[(0)]) - v1));

(self__.buf[(1)] = ((self__.buf[(1)]) - v2));
} else {
var G__17075_17417 = (((!(G__17073_17415)))?(v1 instanceof thi.ng.geom.vector.Vec2):null);
var G__17076_17418 = (((!(G__17074_17416)))?(v2 instanceof thi.ng.geom.vector.Vec2):null);
var G__17067_17419 = (cljs.core.truth_(G__17075_17417)?v1.buf:null);
var G__17068_17420 = (cljs.core.truth_(G__17076_17418)?v2.buf:null);
var G__17069_17421 = (cljs.core.truth_(G__17075_17417)?(G__17067_17419[(0)]):((G__17073_17415)?v1:cljs.core.nth.call(null,v1,(0),0.0)));
var G__17070_17422 = (cljs.core.truth_(G__17075_17417)?(G__17067_17419[(1)]):((G__17073_17415)?v1:cljs.core.nth.call(null,v1,(1),0.0)));
var G__17071_17423 = (cljs.core.truth_(G__17076_17418)?(G__17068_17420[(0)]):((G__17074_17416)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__17072_17424 = (cljs.core.truth_(G__17076_17418)?(G__17068_17420[(1)]):((G__17074_17416)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
(self__.buf[(0)] = (((self__.buf[(0)]) - G__17069_17421) - G__17071_17423));

(self__.buf[(1)] = (((self__.buf[(1)]) - G__17070_17422) - G__17072_17424));
}

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMutableMathOps$_STAR__BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMutableMathOps$_STAR__BANG_$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var G__17077_17425 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec2)){
var G__17078_17426 = v.buf;
(self__.buf[(0)] = ((G__17077_17425[(0)]) * (G__17078_17426[(0)])));

(self__.buf[(1)] = ((G__17077_17425[(1)]) * (G__17078_17426[(1)])));

self__._hash = null;
} else {
if(typeof v === 'number'){
(self__.buf[(0)] = ((G__17077_17425[(0)]) * v));

(self__.buf[(1)] = ((G__17077_17425[(1)]) * v));

self__._hash = null;
} else {
(self__.buf[(0)] = ((G__17077_17425[(0)]) * cljs.core.nth.call(null,v,(0),0.0)));

(self__.buf[(1)] = ((G__17077_17425[(1)]) * cljs.core.nth.call(null,v,(1),0.0)));

self__._hash = null;
}
}

return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMutableMathOps$_STAR__BANG_$arity$3 = (function (_,v1,v2){
var self__ = this;
var ___$1 = this;
var G__17086_17427 = typeof v1 === 'number';
var G__17087_17428 = typeof v2 === 'number';
if(((G__17086_17427)?G__17087_17428:false)){
(self__.buf[(0)] = ((self__.buf[(0)]) * v1));

(self__.buf[(1)] = ((self__.buf[(1)]) * v2));
} else {
var G__17088_17429 = (((!(G__17086_17427)))?(v1 instanceof thi.ng.geom.vector.Vec2):null);
var G__17089_17430 = (((!(G__17087_17428)))?(v2 instanceof thi.ng.geom.vector.Vec2):null);
var G__17080_17431 = (cljs.core.truth_(G__17088_17429)?v1.buf:null);
var G__17081_17432 = (cljs.core.truth_(G__17089_17430)?v2.buf:null);
var G__17082_17433 = (cljs.core.truth_(G__17088_17429)?(G__17080_17431[(0)]):((G__17086_17427)?v1:cljs.core.nth.call(null,v1,(0),0.0)));
var G__17083_17434 = (cljs.core.truth_(G__17088_17429)?(G__17080_17431[(1)]):((G__17086_17427)?v1:cljs.core.nth.call(null,v1,(1),0.0)));
var G__17084_17435 = (cljs.core.truth_(G__17089_17430)?(G__17081_17432[(0)]):((G__17087_17428)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__17085_17436 = (cljs.core.truth_(G__17089_17430)?(G__17081_17432[(1)]):((G__17087_17428)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
(self__.buf[(0)] = (((self__.buf[(0)]) * G__17082_17433) * G__17084_17435));

(self__.buf[(1)] = (((self__.buf[(1)]) * G__17083_17434) * G__17085_17436));
}

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMutableMathOps$subm_BANG_$arity$3 = (function (_,a,b){
var self__ = this;
var ___$1 = this;
var G__17099_17437 = (a instanceof thi.ng.geom.vector.Vec2);
var G__17100_17438 = (b instanceof thi.ng.geom.vector.Vec2);
var G__17101_17439 = (((!(G__17099_17437)))?typeof a === 'number':null);
var G__17102_17440 = (((!(G__17100_17438)))?typeof b === 'number':null);
var G__17090_17441 = self__.buf;
var G__17091_17442 = ((G__17099_17437)?a.buf:null);
var G__17092_17443 = ((G__17100_17438)?b.buf:null);
var G__17093_17444 = (G__17090_17441[(0)]);
var G__17094_17445 = (G__17090_17441[(1)]);
var G__17095_17446 = ((G__17099_17437)?(G__17091_17442[(0)]):(cljs.core.truth_(G__17101_17439)?a:cljs.core.nth.call(null,a,(0),0.0)));
var G__17096_17447 = ((G__17099_17437)?(G__17091_17442[(1)]):(cljs.core.truth_(G__17101_17439)?a:cljs.core.nth.call(null,a,(1),0.0)));
var G__17097_17448 = ((G__17100_17438)?(G__17092_17443[(0)]):(cljs.core.truth_(G__17102_17440)?b:cljs.core.nth.call(null,b,(0),1.0)));
var G__17098_17449 = ((G__17100_17438)?(G__17092_17443[(1)]):(cljs.core.truth_(G__17102_17440)?b:cljs.core.nth.call(null,b,(1),1.0)));
(self__.buf[(0)] = ((G__17093_17444 - G__17095_17446) * G__17097_17448));

(self__.buf[(1)] = ((G__17094_17445 - G__17096_17447) * G__17098_17449));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMutableMathOps$msub_BANG_$arity$3 = (function (_,a,b){
var self__ = this;
var ___$1 = this;
var G__17112_17450 = (a instanceof thi.ng.geom.vector.Vec2);
var G__17113_17451 = (b instanceof thi.ng.geom.vector.Vec2);
var G__17114_17452 = (((!(G__17112_17450)))?typeof a === 'number':null);
var G__17115_17453 = (((!(G__17113_17451)))?typeof b === 'number':null);
var G__17103_17454 = self__.buf;
var G__17104_17455 = ((G__17112_17450)?a.buf:null);
var G__17105_17456 = ((G__17113_17451)?b.buf:null);
var G__17106_17457 = (G__17103_17454[(0)]);
var G__17107_17458 = (G__17103_17454[(1)]);
var G__17108_17459 = ((G__17112_17450)?(G__17104_17455[(0)]):(cljs.core.truth_(G__17114_17452)?a:cljs.core.nth.call(null,a,(0),1.0)));
var G__17109_17460 = ((G__17112_17450)?(G__17104_17455[(1)]):(cljs.core.truth_(G__17114_17452)?a:cljs.core.nth.call(null,a,(1),1.0)));
var G__17110_17461 = ((G__17113_17451)?(G__17105_17456[(0)]):(cljs.core.truth_(G__17115_17453)?b:cljs.core.nth.call(null,b,(0),0.0)));
var G__17111_17462 = ((G__17113_17451)?(G__17105_17456[(1)]):(cljs.core.truth_(G__17115_17453)?b:cljs.core.nth.call(null,b,(1),0.0)));
(self__.buf[(0)] = ((G__17106_17457 * G__17108_17459) - G__17110_17461));

(self__.buf[(1)] = ((G__17107_17458 * G__17109_17460) - G__17111_17462));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMutableMathOps$abs_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
(self__.buf[(0)] = thi.ng.math.core.abs_STAR_.call(null,(self__.buf[(0)])));

(self__.buf[(1)] = thi.ng.math.core.abs_STAR_.call(null,(self__.buf[(1)])));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMutableMathOps$madd_BANG_$arity$3 = (function (_,a,b){
var self__ = this;
var ___$1 = this;
var G__17125_17463 = (a instanceof thi.ng.geom.vector.Vec2);
var G__17126_17464 = (b instanceof thi.ng.geom.vector.Vec2);
var G__17127_17465 = (((!(G__17125_17463)))?typeof a === 'number':null);
var G__17128_17466 = (((!(G__17126_17464)))?typeof b === 'number':null);
var G__17116_17467 = self__.buf;
var G__17117_17468 = ((G__17125_17463)?a.buf:null);
var G__17118_17469 = ((G__17126_17464)?b.buf:null);
var G__17119_17470 = (G__17116_17467[(0)]);
var G__17120_17471 = (G__17116_17467[(1)]);
var G__17121_17472 = ((G__17125_17463)?(G__17117_17468[(0)]):(cljs.core.truth_(G__17127_17465)?a:cljs.core.nth.call(null,a,(0),1.0)));
var G__17122_17473 = ((G__17125_17463)?(G__17117_17468[(1)]):(cljs.core.truth_(G__17127_17465)?a:cljs.core.nth.call(null,a,(1),1.0)));
var G__17123_17474 = ((G__17126_17464)?(G__17118_17469[(0)]):(cljs.core.truth_(G__17128_17466)?b:cljs.core.nth.call(null,b,(0),0.0)));
var G__17124_17475 = ((G__17126_17464)?(G__17118_17469[(1)]):(cljs.core.truth_(G__17128_17466)?b:cljs.core.nth.call(null,b,(1),0.0)));
(self__.buf[(0)] = ((G__17119_17470 * G__17121_17472) + G__17123_17474));

(self__.buf[(1)] = ((G__17120_17471 * G__17122_17473) + G__17124_17475));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMutableMathOps$div_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
(self__.buf[(0)] = ((1) / (self__.buf[(0)])));

(self__.buf[(1)] = ((1) / (self__.buf[(1)])));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMutableMathOps$div_BANG_$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var G__17129_17476 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec2)){
var G__17130_17477 = v.buf;
(self__.buf[(0)] = ((G__17129_17476[(0)]) / (G__17130_17477[(0)])));

(self__.buf[(1)] = ((G__17129_17476[(1)]) / (G__17130_17477[(1)])));

self__._hash = null;
} else {
if(typeof v === 'number'){
(self__.buf[(0)] = ((G__17129_17476[(0)]) / v));

(self__.buf[(1)] = ((G__17129_17476[(1)]) / v));

self__._hash = null;
} else {
(self__.buf[(0)] = ((G__17129_17476[(0)]) / cljs.core.nth.call(null,v,(0),0.0)));

(self__.buf[(1)] = ((G__17129_17476[(1)]) / cljs.core.nth.call(null,v,(1),0.0)));

self__._hash = null;
}
}

return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMutableMathOps$div_BANG_$arity$3 = (function (_,v1,v2){
var self__ = this;
var ___$1 = this;
var G__17138_17478 = typeof v1 === 'number';
var G__17139_17479 = typeof v2 === 'number';
if(((G__17138_17478)?G__17139_17479:false)){
(self__.buf[(0)] = ((self__.buf[(0)]) / v1));

(self__.buf[(1)] = ((self__.buf[(1)]) / v2));
} else {
var G__17140_17480 = (((!(G__17138_17478)))?(v1 instanceof thi.ng.geom.vector.Vec2):null);
var G__17141_17481 = (((!(G__17139_17479)))?(v2 instanceof thi.ng.geom.vector.Vec2):null);
var G__17132_17482 = (cljs.core.truth_(G__17140_17480)?v1.buf:null);
var G__17133_17483 = (cljs.core.truth_(G__17141_17481)?v2.buf:null);
var G__17134_17484 = (cljs.core.truth_(G__17140_17480)?(G__17132_17482[(0)]):((G__17138_17478)?v1:cljs.core.nth.call(null,v1,(0),0.0)));
var G__17135_17485 = (cljs.core.truth_(G__17140_17480)?(G__17132_17482[(1)]):((G__17138_17478)?v1:cljs.core.nth.call(null,v1,(1),0.0)));
var G__17136_17486 = (cljs.core.truth_(G__17141_17481)?(G__17133_17483[(0)]):((G__17139_17479)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__17137_17487 = (cljs.core.truth_(G__17141_17481)?(G__17133_17483[(1)]):((G__17139_17479)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
(self__.buf[(0)] = (((self__.buf[(0)]) / G__17134_17484) / G__17136_17486));

(self__.buf[(1)] = (((self__.buf[(1)]) / G__17135_17485) / G__17137_17487));
}

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMutableMathOps$_PLUS__BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMutableMathOps$_PLUS__BANG_$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var G__17142_17488 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec2)){
var G__17143_17489 = v.buf;
(self__.buf[(0)] = ((G__17142_17488[(0)]) + (G__17143_17489[(0)])));

(self__.buf[(1)] = ((G__17142_17488[(1)]) + (G__17143_17489[(1)])));

self__._hash = null;
} else {
if(typeof v === 'number'){
(self__.buf[(0)] = ((G__17142_17488[(0)]) + v));

(self__.buf[(1)] = ((G__17142_17488[(1)]) + v));

self__._hash = null;
} else {
(self__.buf[(0)] = ((G__17142_17488[(0)]) + cljs.core.nth.call(null,v,(0),0.0)));

(self__.buf[(1)] = ((G__17142_17488[(1)]) + cljs.core.nth.call(null,v,(1),0.0)));

self__._hash = null;
}
}

return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMutableMathOps$_PLUS__BANG_$arity$3 = (function (_,v1,v2){
var self__ = this;
var ___$1 = this;
var G__17151_17490 = typeof v1 === 'number';
var G__17152_17491 = typeof v2 === 'number';
if(((G__17151_17490)?G__17152_17491:false)){
(self__.buf[(0)] = ((self__.buf[(0)]) + v1));

(self__.buf[(1)] = ((self__.buf[(1)]) + v2));
} else {
var G__17153_17492 = (((!(G__17151_17490)))?(v1 instanceof thi.ng.geom.vector.Vec2):null);
var G__17154_17493 = (((!(G__17152_17491)))?(v2 instanceof thi.ng.geom.vector.Vec2):null);
var G__17145_17494 = (cljs.core.truth_(G__17153_17492)?v1.buf:null);
var G__17146_17495 = (cljs.core.truth_(G__17154_17493)?v2.buf:null);
var G__17147_17496 = (cljs.core.truth_(G__17153_17492)?(G__17145_17494[(0)]):((G__17151_17490)?v1:cljs.core.nth.call(null,v1,(0),0.0)));
var G__17148_17497 = (cljs.core.truth_(G__17153_17492)?(G__17145_17494[(1)]):((G__17151_17490)?v1:cljs.core.nth.call(null,v1,(1),0.0)));
var G__17149_17498 = (cljs.core.truth_(G__17154_17493)?(G__17146_17495[(0)]):((G__17152_17491)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__17150_17499 = (cljs.core.truth_(G__17154_17493)?(G__17146_17495[(1)]):((G__17152_17491)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
(self__.buf[(0)] = (((self__.buf[(0)]) + G__17147_17496) + G__17149_17498));

(self__.buf[(1)] = (((self__.buf[(1)]) + G__17148_17497) + G__17150_17499));
}

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMutableMathOps$addm_BANG_$arity$3 = (function (_,a,b){
var self__ = this;
var ___$1 = this;
var G__17164_17500 = (a instanceof thi.ng.geom.vector.Vec2);
var G__17165_17501 = (b instanceof thi.ng.geom.vector.Vec2);
var G__17166_17502 = (((!(G__17164_17500)))?typeof a === 'number':null);
var G__17167_17503 = (((!(G__17165_17501)))?typeof b === 'number':null);
var G__17155_17504 = self__.buf;
var G__17156_17505 = ((G__17164_17500)?a.buf:null);
var G__17157_17506 = ((G__17165_17501)?b.buf:null);
var G__17158_17507 = (G__17155_17504[(0)]);
var G__17159_17508 = (G__17155_17504[(1)]);
var G__17160_17509 = ((G__17164_17500)?(G__17156_17505[(0)]):(cljs.core.truth_(G__17166_17502)?a:cljs.core.nth.call(null,a,(0),0.0)));
var G__17161_17510 = ((G__17164_17500)?(G__17156_17505[(1)]):(cljs.core.truth_(G__17166_17502)?a:cljs.core.nth.call(null,a,(1),0.0)));
var G__17162_17511 = ((G__17165_17501)?(G__17157_17506[(0)]):(cljs.core.truth_(G__17167_17503)?b:cljs.core.nth.call(null,b,(0),1.0)));
var G__17163_17512 = ((G__17165_17501)?(G__17157_17506[(1)]):(cljs.core.truth_(G__17167_17503)?b:cljs.core.nth.call(null,b,(1),1.0)));
(self__.buf[(0)] = ((G__17158_17507 + G__17160_17509) * G__17162_17511));

(self__.buf[(1)] = ((G__17159_17508 + G__17161_17510) * G__17163_17512));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$dstruct$streams$IBuffer$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$dstruct$streams$IBuffer$get_float_buffer$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.buf;
});

thi.ng.geom.vector.Vec2.prototype.toString = (function (){
var self__ = this;
var _ = this;
return ["[",cljs.core.str.cljs$core$IFn$_invoke$arity$1((self__.buf[(0)]))," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((self__.buf[(1)])),"]"].join('');
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
if((k instanceof cljs.core.Keyword)){
var temp__5802__auto__ = thi.ng.geom.vector.swizzle2_fns.call(null,k);
if(cljs.core.truth_(temp__5802__auto__)){
var f = temp__5802__auto__;
return f.call(null,___$1);
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,k);
}
} else {
if((((k >= (0))) && ((k < (2))))){
return (self__.buf[k]);
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,k);
}
}
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (_,k,nf){
var self__ = this;
var ___$1 = this;
if((k instanceof cljs.core.Keyword)){
var temp__5802__auto__ = thi.ng.geom.vector.swizzle2_fns.call(null,k);
if(cljs.core.truth_(temp__5802__auto__)){
var f = temp__5802__auto__;
return f.call(null,___$1);
} else {
return nf;
}
} else {
if((((k >= (0))) && ((k < (2))))){
return (self__.buf[k]);
} else {
return nf;
}
}
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$ICrossProduct$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$ICrossProduct$cross$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var G__17168 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec2)){
var G__17169 = v.buf;
return (((G__17168[(0)]) * (G__17169[(1)])) - ((G__17168[(1)]) * (G__17169[(0)])));
} else {
return (((G__17168[(0)]) * cljs.core.nth.call(null,v,(1),0.0)) - ((G__17168[(1)]) * cljs.core.nth.call(null,v,(0),0.0)));
}
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (_,n){
var self__ = this;
var ___$1 = this;
if((n >= (0))){
if((n < (2))){
return (self__.buf[n]);
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,n);
}
} else {
return null;
}
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (_,n,nf){
var self__ = this;
var ___$1 = this;
if((n >= (0))){
if((n < (2))){
return (self__.buf[n]);
} else {
return nf;
}
} else {
return null;
}
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (_,writer,opts){
var self__ = this;
var ___$1 = this;
return cljs.core.pr_sequential_writer.call(null,writer,cljs.core.pr_writer,"#vec2 ["," ","]",opts,cljs.core.seq.call(null,___$1));
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (_,n,v){
var self__ = this;
var ___$1 = this;
var b = (new Float32Array(self__.buf));
(b[n] = v);

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__._meta;
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new thi.ng.geom.vector.Vec2((new Float32Array(self__.buf)),self__._hash,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IReflect$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IReflect$reflect$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var b = (new Float32Array((2)));
var G__17170 = self__.buf;
var G__17172 = (G__17170[(0)]);
var G__17173 = (G__17170[(1)]);
if((v instanceof thi.ng.geom.vector.Vec2)){
var G__17171 = v.buf;
var G__17174 = (G__17171[(0)]);
var G__17175 = (G__17171[(1)]);
var d = (((G__17172 * G__17174) + (G__17173 * G__17175)) * 2.0);
(b[(0)] = ((G__17174 * d) - G__17172));

(b[(1)] = ((G__17175 * d) - G__17173));

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
} else {
var G__17174 = cljs.core.nth.call(null,v,(0),0.0);
var G__17175 = cljs.core.nth.call(null,v,(1),0.0);
var d = (((G__17172 * G__17174) + (G__17173 * G__17175)) * 2.0);
(b[(0)] = ((G__17174 * d) - G__17172));

(b[(1)] = ((G__17175 * d) - G__17173));

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
}
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$INext$_next$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.cons.call(null,(self__.buf[(1)]),null);
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (2);
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IDistance$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IDistance$dist$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
return Math.sqrt(thi.ng.geom.core.dist_squared.call(null,___$1,v));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IDistance$dist_squared$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var G__17176 = self__.buf;
var G__17178 = (G__17176[(0)]);
var G__17179 = (G__17176[(1)]);
if((v instanceof thi.ng.geom.vector.Vec2)){
var G__17177 = v.buf;
var G__17180 = (G__17177[(0)]);
var G__17181 = (G__17177[(1)]);
var dx = (G__17178 - G__17180);
var dy = (G__17179 - G__17181);
return ((dx * dx) + (dy * dy));
} else {
var G__17180 = cljs.core.nth.call(null,v,(0),0.0);
var G__17181 = cljs.core.nth.call(null,v,(1),0.0);
var dx = (G__17178 - G__17180);
var dy = (G__17179 - G__17181);
return ((dx * dx) + (dy * dy));
}
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IRotate$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IRotate$rotate$arity$2 = (function (_,theta){
var self__ = this;
var ___$1 = this;
var s = Math.sin(theta);
var c = Math.cos(theta);
var b = (new Float32Array((2)));
var G__17182 = self__.buf;
var G__17183 = (G__17182[(0)]);
var G__17184 = (G__17182[(1)]);
(b[(0)] = ((G__17183 * c) - (G__17184 * s)));

(b[(1)] = ((G__17183 * s) + (G__17184 * c)));

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$IStack$_peek$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.buf[(1)]);
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$IStack$_pop$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.with_meta.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.buf[(0)])], null),self__._meta);
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IInvert$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IInvert$invert$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return thi.ng.math.core._.call(null,___$1);
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return thi.ng.geom.vector.swizzle2_fns.call(null,new cljs.core.Keyword(null,"yx","yx",1696579752)).call(null,___$1);
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$ILimit$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$ILimit$limit$arity$2 = (function (_,len){
var self__ = this;
var ___$1 = this;
if((thi.ng.math.core.mag_squared.call(null,___$1) > (len * len))){
return thi.ng.math.core.normalize.call(null,___$1,len);
} else {
return ___$1;
}
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IScale$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IScale$scale$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var dest__15299__auto__ = (new Float32Array((2)));
var G__17185_17513 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec2)){
var G__17186_17514 = v.buf;
(dest__15299__auto__[(0)] = ((G__17185_17513[(0)]) * (G__17186_17514[(0)])));

(dest__15299__auto__[(1)] = ((G__17185_17513[(1)]) * (G__17186_17514[(1)])));
} else {
if(typeof v === 'number'){
(dest__15299__auto__[(0)] = ((G__17185_17513[(0)]) * v));

(dest__15299__auto__[(1)] = ((G__17185_17513[(1)]) * v));
} else {
(dest__15299__auto__[(0)] = ((G__17185_17513[(0)]) * cljs.core.nth.call(null,v,(0),0.0)));

(dest__15299__auto__[(1)] = ((G__17185_17513[(1)]) * cljs.core.nth.call(null,v,(1),0.0)));
}
}

return (new thi.ng.geom.vector.Vec2(dest__15299__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$IHash$_hash$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var or__4131__auto__ = self__._hash;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return ___$1._hash = cljs.core.mix_collection_hash.call(null,((cljs.core.imul.call(null,(((31) + cljs.core.hash.call(null,(self__.buf[(0)]))) | (0)),(31)) + cljs.core.hash.call(null,(self__.buf[(1)]))) | (0)),(2));
}
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IDeltaEquals$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IDeltaEquals$delta_EQ_$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
return thi.ng.math.core.delta_EQ_.call(null,___$1,v,thi.ng.math.core._STAR_eps_STAR_);
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IDeltaEquals$delta_EQ_$arity$3 = (function (_,v,eps){
var self__ = this;
var ___$1 = this;
if(cljs.core.sequential_QMARK_.call(null,v)){
if(((2) === cljs.core.count.call(null,v))){
var G__17187 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec2)){
var G__17188 = v.buf;
if(cljs.core.truth_(thi.ng.math.core.delta_EQ_.call(null,(G__17187[(0)]),(G__17188[(0)]),eps))){
return thi.ng.math.core.delta_EQ_.call(null,(G__17187[(1)]),(G__17188[(1)]),eps);
} else {
return null;
}
} else {
if(cljs.core.truth_(thi.ng.math.core.delta_EQ_.call(null,(G__17187[(0)]),cljs.core.nth.call(null,v,(0),0.0),eps))){
return thi.ng.math.core.delta_EQ_.call(null,(G__17187[(1)]),cljs.core.nth.call(null,v,(1),0.0),eps);
} else {
return null;
}
}
} else {
return null;
}
} else {
return null;
}
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (_,o){
var self__ = this;
var ___$1 = this;
if((o instanceof thi.ng.geom.vector.Vec2)){
var b_SINGLEQUOTE_ = o.buf;
return ((((self__.buf[(0)]) === (b_SINGLEQUOTE_[(0)]))) && (((self__.buf[(1)]) === (b_SINGLEQUOTE_[(1)]))));
} else {
return ((cljs.core.sequential_QMARK_.call(null,o)) && (((2) === cljs.core.count.call(null,o))) && (cljs.core._EQ_.call(null,(self__.buf[(0)]),cljs.core.first.call(null,o))) && (cljs.core._EQ_.call(null,(self__.buf[(1)]),cljs.core.nth.call(null,o,(1)))));
}
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IVectorReduce$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IVectorReduce$reduce_vector$arity$3 = (function (_,f,xs){
var self__ = this;
var ___$1 = this;
var buf_SINGLEQUOTE_ = (new Float32Array(self__.buf));
return (new thi.ng.geom.vector.Vec2(thi.ng.geom.vector.vec2_reduce_STAR_.call(null,f,buf_SINGLEQUOTE_,xs),null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IVectorReduce$reduce_vector$arity$4 = (function (_,f,f2,xs){
var self__ = this;
var ___$1 = this;
var buf_SINGLEQUOTE_ = (new Float32Array(self__.buf));
thi.ng.geom.vector.vec2_reduce_STAR_.call(null,f,buf_SINGLEQUOTE_,xs);

(buf_SINGLEQUOTE_[(0)] = f2.call(null,(buf_SINGLEQUOTE_[(0)]),(0)));

(buf_SINGLEQUOTE_[(1)] = f2.call(null,(buf_SINGLEQUOTE_[(1)]),(1)));

return (new thi.ng.geom.vector.Vec2(buf_SINGLEQUOTE_,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$dstruct$streams$IIntoBuffer$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$dstruct$streams$IIntoBuffer$into_float_buffer$arity$4 = (function (_,dest,stride,idx){
var self__ = this;
var ___$1 = this;
dest.set(self__.buf,idx);

return (idx + stride);
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IDotProduct$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IDotProduct$dot$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var G__17189 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec2)){
var G__17190 = v.buf;
return (((G__17189[(0)]) * (G__17190[(0)])) + ((G__17189[(1)]) * (G__17190[(1)])));
} else {
return (((G__17189[(0)]) * cljs.core.nth.call(null,v,(0),0.0)) + ((G__17189[(1)]) * cljs.core.nth.call(null,v,(1),0.0)));
}
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$INormal$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$INormal$normal$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var b = (new Float32Array((2)));
(b[(0)] = (- (self__.buf[(1)])));

(b[(1)] = (self__.buf[(0)]));

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
var acc = f.call(null,(self__.buf[(0)]),(self__.buf[(1)]));
if(cljs.core.reduced_QMARK_.call(null,acc)){
return cljs.core.deref.call(null,acc);
} else {
return acc;
}
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
var acc = f.call(null,start,(self__.buf[(0)]));
if(cljs.core.reduced_QMARK_.call(null,acc)){
return cljs.core.deref.call(null,acc);
} else {
var acc__$1 = f.call(null,acc,(self__.buf[(1)]));
if(cljs.core.reduced_QMARK_.call(null,acc__$1)){
return cljs.core.deref.call(null,acc__$1);
} else {
return acc__$1;
}
}
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$ITranslate$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$ITranslate$translate$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var dest__15299__auto__ = (new Float32Array((2)));
var G__17191_17515 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec2)){
var G__17192_17516 = v.buf;
(dest__15299__auto__[(0)] = ((G__17191_17515[(0)]) + (G__17192_17516[(0)])));

(dest__15299__auto__[(1)] = ((G__17191_17515[(1)]) + (G__17192_17516[(1)])));
} else {
if(typeof v === 'number'){
(dest__15299__auto__[(0)] = ((G__17191_17515[(0)]) + v));

(dest__15299__auto__[(1)] = ((G__17191_17515[(1)]) + v));
} else {
(dest__15299__auto__[(0)] = ((G__17191_17515[(0)]) + cljs.core.nth.call(null,v,(0),0.0)));

(dest__15299__auto__[(1)] = ((G__17191_17515[(1)]) + cljs.core.nth.call(null,v,(1),0.0)));
}
}

return (new thi.ng.geom.vector.Vec2(dest__15299__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$ISeq$_first$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.buf[(0)]);
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$ISeq$_rest$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.cons.call(null,(self__.buf[(1)]),null);
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IHeading$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IHeading$heading$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var t = Math.atan2((self__.buf[(1)]),(self__.buf[(0)]));
if((t < (0))){
return (t + thi.ng.math.core.TWO_PI);
} else {
return t;
}
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IHeading$heading_xy$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return thi.ng.geom.core.heading.call(null,___$1);
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IHeading$angle_between$arity$2 = (function (_,a){
var self__ = this;
var ___$1 = this;
var t = (thi.ng.geom.core.heading.call(null,a) - thi.ng.geom.core.heading.call(null,___$1));
if((t < (0))){
return (t + thi.ng.math.core.TWO_PI);
} else {
return t;
}
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IHeading$slope_xy$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return ((self__.buf[(1)]) / (self__.buf[(0)]));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IInterpolate$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IInterpolate$mix$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var b = (new Float32Array((2)));
var G__17193_17517 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec2)){
var G__17194_17518 = v.buf;
(b[(0)] = (((G__17193_17517[(0)]) + (G__17194_17518[(0)])) * 0.5));

(b[(1)] = (((G__17193_17517[(1)]) + (G__17194_17518[(1)])) * 0.5));
} else {
if(typeof v === 'number'){
(b[(0)] = (((G__17193_17517[(0)]) + v) * 0.5));

(b[(1)] = (((G__17193_17517[(1)]) + v) * 0.5));
} else {
(b[(0)] = (((G__17193_17517[(0)]) + cljs.core.nth.call(null,v,(0),0.0)) * 0.5));

(b[(1)] = (((G__17193_17517[(1)]) + cljs.core.nth.call(null,v,(1),0.0)) * 0.5));
}
}

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IInterpolate$mix$arity$3 = (function (_,v,t){
var self__ = this;
var ___$1 = this;
var b = (new Float32Array((2)));
var G__17204_17519 = (v instanceof thi.ng.geom.vector.Vec2);
var G__17205_17520 = (t instanceof thi.ng.geom.vector.Vec2);
var G__17206_17521 = (((!(G__17204_17519)))?typeof v === 'number':null);
var G__17207_17522 = (((!(G__17205_17520)))?typeof t === 'number':null);
var G__17195_17523 = self__.buf;
var G__17196_17524 = ((G__17204_17519)?v.buf:null);
var G__17197_17525 = ((G__17205_17520)?t.buf:null);
var G__17198_17526 = (G__17195_17523[(0)]);
var G__17199_17527 = (G__17195_17523[(1)]);
var G__17200_17528 = ((G__17204_17519)?(G__17196_17524[(0)]):(cljs.core.truth_(G__17206_17521)?v:cljs.core.nth.call(null,v,(0),0.0)));
var G__17201_17529 = ((G__17204_17519)?(G__17196_17524[(1)]):(cljs.core.truth_(G__17206_17521)?v:cljs.core.nth.call(null,v,(1),0.0)));
var G__17202_17530 = ((G__17205_17520)?(G__17197_17525[(0)]):(cljs.core.truth_(G__17207_17522)?t:cljs.core.nth.call(null,t,(0),0.0)));
var G__17203_17531 = ((G__17205_17520)?(G__17197_17525[(1)]):(cljs.core.truth_(G__17207_17522)?t:cljs.core.nth.call(null,t,(1),0.0)));
(b[(0)] = (((G__17200_17528 - G__17198_17526) * G__17202_17530) + G__17198_17526));

(b[(1)] = (((G__17201_17529 - G__17199_17527) * G__17203_17531) + G__17199_17527));

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IInterpolate$mix$arity$6 = (function (_,b,c,d,u,v){
var self__ = this;
var ___$1 = this;
var b_SINGLEQUOTE_ = (new Float32Array((2)));
var dv_QMARK_ = (d instanceof thi.ng.geom.vector.Vec2);
var dn_QMARK_ = typeof d === 'number';
var dv = ((dv_QMARK_)?d.buf:null);
var dx = ((dv_QMARK_)?(dv[(0)]):((dn_QMARK_)?d:cljs.core.nth.call(null,d,(0),0.0)));
var dy = ((dv_QMARK_)?(dv[(1)]):((dn_QMARK_)?d:cljs.core.nth.call(null,d,(1),0.0)));
var G__17217_17532 = (b instanceof thi.ng.geom.vector.Vec2);
var G__17218_17533 = (c instanceof thi.ng.geom.vector.Vec2);
var G__17219_17534 = (((!(G__17217_17532)))?typeof b === 'number':null);
var G__17220_17535 = (((!(G__17218_17533)))?typeof c === 'number':null);
var G__17208_17536 = self__.buf;
var G__17209_17537 = ((G__17217_17532)?b.buf:null);
var G__17210_17538 = ((G__17218_17533)?c.buf:null);
var G__17211_17539 = (G__17208_17536[(0)]);
var G__17212_17540 = (G__17208_17536[(1)]);
var G__17213_17541 = ((G__17217_17532)?(G__17209_17537[(0)]):(cljs.core.truth_(G__17219_17534)?b:cljs.core.nth.call(null,b,(0),0.0)));
var G__17214_17542 = ((G__17217_17532)?(G__17209_17537[(1)]):(cljs.core.truth_(G__17219_17534)?b:cljs.core.nth.call(null,b,(1),0.0)));
var G__17215_17543 = ((G__17218_17533)?(G__17210_17538[(0)]):(cljs.core.truth_(G__17220_17535)?c:cljs.core.nth.call(null,c,(0),0.0)));
var G__17216_17544 = ((G__17218_17533)?(G__17210_17538[(1)]):(cljs.core.truth_(G__17220_17535)?c:cljs.core.nth.call(null,c,(1),0.0)));
var x1_17545 = (((G__17213_17541 - G__17211_17539) * u) + G__17211_17539);
var y1_17546 = (((G__17214_17542 - G__17212_17540) * u) + G__17212_17540);
(b_SINGLEQUOTE_[(0)] = ((((((dx - G__17215_17543) * u) + G__17215_17543) - x1_17545) * v) + x1_17545));

(b_SINGLEQUOTE_[(1)] = ((((((dy - G__17216_17544) * u) + G__17216_17544) - y1_17546) * v) + y1_17546));

return (new thi.ng.geom.vector.Vec2(b_SINGLEQUOTE_,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IInterpolate$mix_with$arity$4 = (function (_,v,t,f){
var self__ = this;
var ___$1 = this;
var b = (new Float32Array((2)));
var G__17230_17547 = (v instanceof thi.ng.geom.vector.Vec2);
var G__17231_17548 = (t instanceof thi.ng.geom.vector.Vec2);
var G__17232_17549 = (((!(G__17230_17547)))?typeof v === 'number':null);
var G__17233_17550 = (((!(G__17231_17548)))?typeof t === 'number':null);
var G__17221_17551 = self__.buf;
var G__17222_17552 = ((G__17230_17547)?v.buf:null);
var G__17223_17553 = ((G__17231_17548)?t.buf:null);
var G__17224_17554 = (G__17221_17551[(0)]);
var G__17225_17555 = (G__17221_17551[(1)]);
var G__17226_17556 = ((G__17230_17547)?(G__17222_17552[(0)]):(cljs.core.truth_(G__17232_17549)?v:cljs.core.nth.call(null,v,(0),0.0)));
var G__17227_17557 = ((G__17230_17547)?(G__17222_17552[(1)]):(cljs.core.truth_(G__17232_17549)?v:cljs.core.nth.call(null,v,(1),0.0)));
var G__17228_17558 = ((G__17231_17548)?(G__17223_17553[(0)]):(cljs.core.truth_(G__17233_17550)?t:cljs.core.nth.call(null,t,(0),0.0)));
var G__17229_17559 = ((G__17231_17548)?(G__17223_17553[(1)]):(cljs.core.truth_(G__17233_17550)?t:cljs.core.nth.call(null,t,(1),0.0)));
(b[(0)] = f.call(null,G__17224_17554,G__17226_17556,G__17228_17558));

(b[(1)] = f.call(null,G__17225_17555,G__17227_17557,G__17229_17559));

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IInterpolate$step$arity$2 = (function (_,e){
var self__ = this;
var ___$1 = this;
var b = (new Float32Array((2)));
var G__17234_17560 = self__.buf;
if((e instanceof thi.ng.geom.vector.Vec2)){
var G__17235_17561 = e.buf;
(b[(0)] = thi.ng.math.core.step_STAR_.call(null,(G__17235_17561[(0)]),(G__17234_17560[(0)])));

(b[(1)] = thi.ng.math.core.step_STAR_.call(null,(G__17235_17561[(1)]),(G__17234_17560[(1)])));
} else {
if(typeof e === 'number'){
(b[(0)] = thi.ng.math.core.step_STAR_.call(null,e,(G__17234_17560[(0)])));

(b[(1)] = thi.ng.math.core.step_STAR_.call(null,e,(G__17234_17560[(1)])));
} else {
(b[(0)] = thi.ng.math.core.step_STAR_.call(null,cljs.core.nth.call(null,e,(0),0.0),(G__17234_17560[(0)])));

(b[(1)] = thi.ng.math.core.step_STAR_.call(null,cljs.core.nth.call(null,e,(1),0.0),(G__17234_17560[(1)])));
}
}

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IInterpolate$smoothstep$arity$3 = (function (_,e1,e2){
var self__ = this;
var ___$1 = this;
var b = (new Float32Array((2)));
var G__17245_17562 = (e1 instanceof thi.ng.geom.vector.Vec2);
var G__17246_17563 = (e2 instanceof thi.ng.geom.vector.Vec2);
var G__17247_17564 = (((!(G__17245_17562)))?typeof e1 === 'number':null);
var G__17248_17565 = (((!(G__17246_17563)))?typeof e2 === 'number':null);
var G__17236_17566 = self__.buf;
var G__17237_17567 = ((G__17245_17562)?e1.buf:null);
var G__17238_17568 = ((G__17246_17563)?e2.buf:null);
var G__17239_17569 = (G__17236_17566[(0)]);
var G__17240_17570 = (G__17236_17566[(1)]);
var G__17241_17571 = ((G__17245_17562)?(G__17237_17567[(0)]):(cljs.core.truth_(G__17247_17564)?e1:cljs.core.nth.call(null,e1,(0),0.0)));
var G__17242_17572 = ((G__17245_17562)?(G__17237_17567[(1)]):(cljs.core.truth_(G__17247_17564)?e1:cljs.core.nth.call(null,e1,(1),0.0)));
var G__17243_17573 = ((G__17246_17563)?(G__17238_17568[(0)]):(cljs.core.truth_(G__17248_17565)?e2:cljs.core.nth.call(null,e2,(0),0.0)));
var G__17244_17574 = ((G__17246_17563)?(G__17238_17568[(1)]):(cljs.core.truth_(G__17248_17565)?e2:cljs.core.nth.call(null,e2,(1),0.0)));
(b[(0)] = thi.ng.math.core.smoothstep_STAR_.call(null,G__17241_17571,G__17243_17573,G__17239_17569));

(b[(1)] = thi.ng.math.core.smoothstep_STAR_.call(null,G__17241_17571,G__17244_17574,G__17240_17570));

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
if(typeof k === 'number'){
return (((k >= (0))) && ((k < (2))));
} else {
if(cljs.core.truth_(thi.ng.geom.vector.swizzle2_fns.call(null,k))){
return true;
} else {
return false;
}
}
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (_,k,v){
var self__ = this;
var ___$1 = this;
if(typeof k === 'number'){
if((((k === (0))) || ((k === (1))))){
var b = (new Float32Array(self__.buf));
(b[k] = v);

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
} else {
if((k === (2))){
return cljs.core.conj.call(null,___$1,v);
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,k);
}
}
} else {
if((k instanceof cljs.core.Keyword)){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"z","z",-789527183),k)){
return cljs.core.conj.call(null,___$1,v);
} else {
return (new thi.ng.geom.vector.Vec2(thi.ng.geom.vector.swizzle_assoc_STAR_.call(null,self__.buf,(new Float32Array(self__.buf)),new cljs.core.PersistentArrayMap(null, 2, ["x",(0),"y",(1)], null),k,v),null,self__._meta));
}
} else {
return null;
}
}
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMinMax$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMinMax$min$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var dest__15299__auto__ = (new Float32Array((2)));
var G__17249_17575 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec2)){
var G__17250_17576 = v.buf;
(dest__15299__auto__[(0)] = (function (){var a__14807__auto__ = (G__17249_17575[(0)]);
var b__14808__auto__ = (G__17250_17576[(0)]);
if((a__14807__auto__ <= b__14808__auto__)){
return a__14807__auto__;
} else {
return b__14808__auto__;
}
})());

(dest__15299__auto__[(1)] = (function (){var a__14807__auto__ = (G__17249_17575[(1)]);
var b__14808__auto__ = (G__17250_17576[(1)]);
if((a__14807__auto__ <= b__14808__auto__)){
return a__14807__auto__;
} else {
return b__14808__auto__;
}
})());
} else {
if(typeof v === 'number'){
(dest__15299__auto__[(0)] = (function (){var a__14807__auto__ = (G__17249_17575[(0)]);
var b__14808__auto__ = v;
if((a__14807__auto__ <= b__14808__auto__)){
return a__14807__auto__;
} else {
return b__14808__auto__;
}
})());

(dest__15299__auto__[(1)] = (function (){var a__14807__auto__ = (G__17249_17575[(1)]);
var b__14808__auto__ = v;
if((a__14807__auto__ <= b__14808__auto__)){
return a__14807__auto__;
} else {
return b__14808__auto__;
}
})());
} else {
(dest__15299__auto__[(0)] = (function (){var a__14807__auto__ = (G__17249_17575[(0)]);
var b__14808__auto__ = cljs.core.nth.call(null,v,(0),0.0);
if((a__14807__auto__ <= b__14808__auto__)){
return a__14807__auto__;
} else {
return b__14808__auto__;
}
})());

(dest__15299__auto__[(1)] = (function (){var a__14807__auto__ = (G__17249_17575[(1)]);
var b__14808__auto__ = cljs.core.nth.call(null,v,(1),0.0);
if((a__14807__auto__ <= b__14808__auto__)){
return a__14807__auto__;
} else {
return b__14808__auto__;
}
})());
}
}

return (new thi.ng.geom.vector.Vec2(dest__15299__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMinMax$min$arity$3 = (function (_,v,v2){
var self__ = this;
var ___$1 = this;
var dest__15310__auto__ = (new Float32Array((2)));
var G__17260_17577 = (v instanceof thi.ng.geom.vector.Vec2);
var G__17261_17578 = (v2 instanceof thi.ng.geom.vector.Vec2);
var G__17262_17579 = (((!(G__17260_17577)))?typeof v === 'number':null);
var G__17263_17580 = (((!(G__17261_17578)))?typeof v2 === 'number':null);
var G__17251_17581 = self__.buf;
var G__17252_17582 = ((G__17260_17577)?v.buf:null);
var G__17253_17583 = ((G__17261_17578)?v2.buf:null);
var G__17254_17584 = (G__17251_17581[(0)]);
var G__17255_17585 = (G__17251_17581[(1)]);
var G__17256_17586 = ((G__17260_17577)?(G__17252_17582[(0)]):(cljs.core.truth_(G__17262_17579)?v:cljs.core.nth.call(null,v,(0),0.0)));
var G__17257_17587 = ((G__17260_17577)?(G__17252_17582[(1)]):(cljs.core.truth_(G__17262_17579)?v:cljs.core.nth.call(null,v,(1),0.0)));
var G__17258_17588 = ((G__17261_17578)?(G__17253_17583[(0)]):(cljs.core.truth_(G__17263_17580)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__17259_17589 = ((G__17261_17578)?(G__17253_17583[(1)]):(cljs.core.truth_(G__17263_17580)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
(dest__15310__auto__[(0)] = (function (){var a__14807__auto__ = (function (){var a__14807__auto__ = G__17254_17584;
var b__14808__auto__ = G__17256_17586;
if((a__14807__auto__ <= b__14808__auto__)){
return a__14807__auto__;
} else {
return b__14808__auto__;
}
})();
var b__14808__auto__ = G__17258_17588;
if((a__14807__auto__ <= b__14808__auto__)){
return a__14807__auto__;
} else {
return b__14808__auto__;
}
})());

(dest__15310__auto__[(1)] = (function (){var a__14807__auto__ = (function (){var a__14807__auto__ = G__17255_17585;
var b__14808__auto__ = G__17257_17587;
if((a__14807__auto__ <= b__14808__auto__)){
return a__14807__auto__;
} else {
return b__14808__auto__;
}
})();
var b__14808__auto__ = G__17259_17589;
if((a__14807__auto__ <= b__14808__auto__)){
return a__14807__auto__;
} else {
return b__14808__auto__;
}
})());

return (new thi.ng.geom.vector.Vec2(dest__15310__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMinMax$max$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var dest__15299__auto__ = (new Float32Array((2)));
var G__17264_17590 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec2)){
var G__17265_17591 = v.buf;
(dest__15299__auto__[(0)] = (function (){var a__14814__auto__ = (G__17264_17590[(0)]);
var b__14815__auto__ = (G__17265_17591[(0)]);
if((a__14814__auto__ >= b__14815__auto__)){
return a__14814__auto__;
} else {
return b__14815__auto__;
}
})());

(dest__15299__auto__[(1)] = (function (){var a__14814__auto__ = (G__17264_17590[(1)]);
var b__14815__auto__ = (G__17265_17591[(1)]);
if((a__14814__auto__ >= b__14815__auto__)){
return a__14814__auto__;
} else {
return b__14815__auto__;
}
})());
} else {
if(typeof v === 'number'){
(dest__15299__auto__[(0)] = (function (){var a__14814__auto__ = (G__17264_17590[(0)]);
var b__14815__auto__ = v;
if((a__14814__auto__ >= b__14815__auto__)){
return a__14814__auto__;
} else {
return b__14815__auto__;
}
})());

(dest__15299__auto__[(1)] = (function (){var a__14814__auto__ = (G__17264_17590[(1)]);
var b__14815__auto__ = v;
if((a__14814__auto__ >= b__14815__auto__)){
return a__14814__auto__;
} else {
return b__14815__auto__;
}
})());
} else {
(dest__15299__auto__[(0)] = (function (){var a__14814__auto__ = (G__17264_17590[(0)]);
var b__14815__auto__ = cljs.core.nth.call(null,v,(0),0.0);
if((a__14814__auto__ >= b__14815__auto__)){
return a__14814__auto__;
} else {
return b__14815__auto__;
}
})());

(dest__15299__auto__[(1)] = (function (){var a__14814__auto__ = (G__17264_17590[(1)]);
var b__14815__auto__ = cljs.core.nth.call(null,v,(1),0.0);
if((a__14814__auto__ >= b__14815__auto__)){
return a__14814__auto__;
} else {
return b__14815__auto__;
}
})());
}
}

return (new thi.ng.geom.vector.Vec2(dest__15299__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMinMax$max$arity$3 = (function (_,v,v2){
var self__ = this;
var ___$1 = this;
var dest__15310__auto__ = (new Float32Array((2)));
var G__17275_17592 = (v instanceof thi.ng.geom.vector.Vec2);
var G__17276_17593 = (v2 instanceof thi.ng.geom.vector.Vec2);
var G__17277_17594 = (((!(G__17275_17592)))?typeof v === 'number':null);
var G__17278_17595 = (((!(G__17276_17593)))?typeof v2 === 'number':null);
var G__17266_17596 = self__.buf;
var G__17267_17597 = ((G__17275_17592)?v.buf:null);
var G__17268_17598 = ((G__17276_17593)?v2.buf:null);
var G__17269_17599 = (G__17266_17596[(0)]);
var G__17270_17600 = (G__17266_17596[(1)]);
var G__17271_17601 = ((G__17275_17592)?(G__17267_17597[(0)]):(cljs.core.truth_(G__17277_17594)?v:cljs.core.nth.call(null,v,(0),0.0)));
var G__17272_17602 = ((G__17275_17592)?(G__17267_17597[(1)]):(cljs.core.truth_(G__17277_17594)?v:cljs.core.nth.call(null,v,(1),0.0)));
var G__17273_17603 = ((G__17276_17593)?(G__17268_17598[(0)]):(cljs.core.truth_(G__17278_17595)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__17274_17604 = ((G__17276_17593)?(G__17268_17598[(1)]):(cljs.core.truth_(G__17278_17595)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
(dest__15310__auto__[(0)] = (function (){var a__14814__auto__ = (function (){var a__14814__auto__ = G__17269_17599;
var b__14815__auto__ = G__17271_17601;
if((a__14814__auto__ >= b__14815__auto__)){
return a__14814__auto__;
} else {
return b__14815__auto__;
}
})();
var b__14815__auto__ = G__17273_17603;
if((a__14814__auto__ >= b__14815__auto__)){
return a__14814__auto__;
} else {
return b__14815__auto__;
}
})());

(dest__15310__auto__[(1)] = (function (){var a__14814__auto__ = (function (){var a__14814__auto__ = G__17270_17600;
var b__14815__auto__ = G__17272_17602;
if((a__14814__auto__ >= b__14815__auto__)){
return a__14814__auto__;
} else {
return b__14815__auto__;
}
})();
var b__14815__auto__ = G__17274_17604;
if((a__14814__auto__ >= b__14815__auto__)){
return a__14814__auto__;
} else {
return b__14815__auto__;
}
})());

return (new thi.ng.geom.vector.Vec2(dest__15310__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,m){
var self__ = this;
var ___$1 = this;
return (new thi.ng.geom.vector.Vec2((new Float32Array(self__.buf)),self__._hash,m));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IClear$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IClear$clear_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new thi.ng.geom.vector.Vec2((new Float32Array((2))),null,null));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IClear$clear_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
(self__.buf[(0)] = 0.0);

(self__.buf[(1)] = 0.0);

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$ICollection$_conj$arity$2 = (function (_,x){
var self__ = this;
var ___$1 = this;
return cljs.core.with_meta.call(null,thi.ng.geom.vector.vec3.call(null,(self__.buf[(0)]),(self__.buf[(1)]),x),self__._meta);
});

thi.ng.geom.vector.Vec2.prototype.call = (function() {
var G__17605 = null;
var G__17605__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
if((k instanceof cljs.core.Keyword)){
var temp__5802__auto__ = thi.ng.geom.vector.swizzle2_fns.call(null,k);
if(cljs.core.truth_(temp__5802__auto__)){
var f = temp__5802__auto__;
return f.call(null,_);
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,k);
}
} else {
if((((k >= (0))) && ((k < (2))))){
return (self__.buf[k]);
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,k);
}
}
});
var G__17605__3 = (function (self__,k,nf){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
if((k instanceof cljs.core.Keyword)){
var temp__5802__auto__ = thi.ng.geom.vector.swizzle2_fns.call(null,k);
if(cljs.core.truth_(temp__5802__auto__)){
var f = temp__5802__auto__;
return f.call(null,_);
} else {
return nf;
}
} else {
if((((k >= (0))) && ((k < (2))))){
return (self__.buf[k]);
} else {
return nf;
}
}
});
G__17605 = function(self__,k,nf){
switch(arguments.length){
case 2:
return G__17605__2.call(this,self__,k);
case 3:
return G__17605__3.call(this,self__,k,nf);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__17605.cljs$core$IFn$_invoke$arity$2 = G__17605__2;
G__17605.cljs$core$IFn$_invoke$arity$3 = G__17605__3;
return G__17605;
})()
;

thi.ng.geom.vector.Vec2.prototype.apply = (function (self__,args17063){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone.call(null,args17063)));
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var _ = this;
if((k instanceof cljs.core.Keyword)){
var temp__5802__auto__ = thi.ng.geom.vector.swizzle2_fns.call(null,k);
if(cljs.core.truth_(temp__5802__auto__)){
var f = temp__5802__auto__;
return f.call(null,_);
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,k);
}
} else {
if((((k >= (0))) && ((k < (2))))){
return (self__.buf[k]);
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,k);
}
}
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,nf){
var self__ = this;
var _ = this;
if((k instanceof cljs.core.Keyword)){
var temp__5802__auto__ = thi.ng.geom.vector.swizzle2_fns.call(null,k);
if(cljs.core.truth_(temp__5802__auto__)){
var f = temp__5802__auto__;
return f.call(null,_);
} else {
return nf;
}
} else {
if((((k >= (0))) && ((k < (2))))){
return (self__.buf[k]);
} else {
return nf;
}
}
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IPolar$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IPolar$as_polar$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var b = (new Float32Array((2)));
(b[(0)] = thi.ng.math.core.mag.call(null,___$1));

(b[(1)] = thi.ng.geom.core.heading.call(null,___$1));

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$geom$core$IPolar$as_cartesian$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var G__17279 = self__.buf;
var G__17280 = (G__17279[(0)]);
var G__17281 = (G__17279[(1)]);
var b = (new Float32Array((2)));
(b[(0)] = (G__17280 * Math.cos(G__17281)));

(b[(1)] = (G__17280 * Math.sin(G__17281)));

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.cljs$core$IComparable$_compare$arity$2 = (function (_,o){
var self__ = this;
var ___$1 = this;
if((o instanceof thi.ng.geom.vector.Vec2)){
var b_SINGLEQUOTE_ = o.buf;
var c = cljs.core.compare.call(null,(self__.buf[(0)]),(b_SINGLEQUOTE_[(0)]));
if(((0) === c)){
return cljs.core.compare.call(null,(self__.buf[(1)]),(b_SINGLEQUOTE_[(1)]));
} else {
return c;
}
} else {
var c = cljs.core.count.call(null,o);
if(((2) === c)){
return (- cljs.core.compare.call(null,o,___$1));
} else {
return ((2) - c);
}
}
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$INormalize$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$INormalize$normalize$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var G__17282 = self__.buf;
var G__17283 = (G__17282[(0)]);
var G__17284 = (G__17282[(1)]);
var l = Math.sqrt(((G__17283 * G__17283) + (G__17284 * G__17284)));
if((l > (0))){
var b = (new Float32Array((2)));
(b[(0)] = (G__17283 / l));

(b[(1)] = (G__17284 / l));

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
} else {
return ___$1;
}
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$INormalize$normalize$arity$2 = (function (_,len){
var self__ = this;
var ___$1 = this;
var G__17285 = self__.buf;
var G__17286 = (G__17285[(0)]);
var G__17287 = (G__17285[(1)]);
var l = Math.sqrt(((G__17286 * G__17286) + (G__17287 * G__17287)));
if((l > (0))){
var l__$1 = (len / l);
var b = (new Float32Array((2)));
(b[(0)] = (G__17286 * l__$1));

(b[(1)] = (G__17287 * l__$1));

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
} else {
return ___$1;
}
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$INormalize$normalized_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return thi.ng.math.core.delta_EQ_.call(null,1.0,thi.ng.math.core.mag_squared.call(null,___$1));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMagnitude$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMagnitude$mag$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var G__17288 = self__.buf;
var G__17289 = (G__17288[(0)]);
var G__17290 = (G__17288[(1)]);
return Math.sqrt(((G__17289 * G__17289) + (G__17290 * G__17290)));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMagnitude$mag_squared$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var G__17291 = self__.buf;
var G__17292 = (G__17291[(0)]);
var G__17293 = (G__17291[(1)]);
return ((G__17292 * G__17292) + (G__17293 * G__17293));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMathOps$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMathOps$msub$arity$3 = (function (_,a,b){
var self__ = this;
var ___$1 = this;
var dest__15310__auto__ = (new Float32Array((2)));
var G__17303_17606 = (a instanceof thi.ng.geom.vector.Vec2);
var G__17304_17607 = (b instanceof thi.ng.geom.vector.Vec2);
var G__17305_17608 = (((!(G__17303_17606)))?typeof a === 'number':null);
var G__17306_17609 = (((!(G__17304_17607)))?typeof b === 'number':null);
var G__17294_17610 = self__.buf;
var G__17295_17611 = ((G__17303_17606)?a.buf:null);
var G__17296_17612 = ((G__17304_17607)?b.buf:null);
var G__17297_17613 = (G__17294_17610[(0)]);
var G__17298_17614 = (G__17294_17610[(1)]);
var G__17299_17615 = ((G__17303_17606)?(G__17295_17611[(0)]):(cljs.core.truth_(G__17305_17608)?a:cljs.core.nth.call(null,a,(0),1.0)));
var G__17300_17616 = ((G__17303_17606)?(G__17295_17611[(1)]):(cljs.core.truth_(G__17305_17608)?a:cljs.core.nth.call(null,a,(1),1.0)));
var G__17301_17617 = ((G__17304_17607)?(G__17296_17612[(0)]):(cljs.core.truth_(G__17306_17609)?b:cljs.core.nth.call(null,b,(0),0.0)));
var G__17302_17618 = ((G__17304_17607)?(G__17296_17612[(1)]):(cljs.core.truth_(G__17306_17609)?b:cljs.core.nth.call(null,b,(1),0.0)));
(dest__15310__auto__[(0)] = ((G__17297_17613 * G__17299_17615) - G__17301_17617));

(dest__15310__auto__[(1)] = ((G__17298_17614 * G__17300_17616) - G__17302_17618));

return (new thi.ng.geom.vector.Vec2(dest__15310__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMathOps$_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMathOps$_STAR_$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var dest__15299__auto__ = (new Float32Array((2)));
var G__17307_17619 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec2)){
var G__17308_17620 = v.buf;
(dest__15299__auto__[(0)] = ((G__17307_17619[(0)]) * (G__17308_17620[(0)])));

(dest__15299__auto__[(1)] = ((G__17307_17619[(1)]) * (G__17308_17620[(1)])));
} else {
if(typeof v === 'number'){
(dest__15299__auto__[(0)] = ((G__17307_17619[(0)]) * v));

(dest__15299__auto__[(1)] = ((G__17307_17619[(1)]) * v));
} else {
(dest__15299__auto__[(0)] = ((G__17307_17619[(0)]) * cljs.core.nth.call(null,v,(0),0.0)));

(dest__15299__auto__[(1)] = ((G__17307_17619[(1)]) * cljs.core.nth.call(null,v,(1),0.0)));
}
}

return (new thi.ng.geom.vector.Vec2(dest__15299__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMathOps$_STAR_$arity$3 = (function (_,v1,v2){
var self__ = this;
var ___$1 = this;
var G__17309 = self__.buf;
var G__17312 = (new Float32Array((2)));
var G__17313 = (G__17309[(0)]);
var G__17314 = (G__17309[(1)]);
var G__17319 = typeof v1 === 'number';
var G__17320 = typeof v2 === 'number';
if(((G__17319)?G__17320:false)){
(G__17312[(0)] = (G__17313 * v1));

(G__17312[(1)] = (G__17314 * v2));
} else {
var G__17321_17621 = (((!(G__17319)))?(v1 instanceof thi.ng.geom.vector.Vec2):null);
var G__17322_17622 = (((!(G__17320)))?(v2 instanceof thi.ng.geom.vector.Vec2):null);
var G__17310_17623 = (cljs.core.truth_(G__17321_17621)?v1.buf:null);
var G__17311_17624 = (cljs.core.truth_(G__17322_17622)?v2.buf:null);
var G__17315_17625 = (cljs.core.truth_(G__17321_17621)?(G__17310_17623[(0)]):((G__17319)?v1:cljs.core.nth.call(null,v1,(0),1.0)));
var G__17316_17626 = (cljs.core.truth_(G__17321_17621)?(G__17310_17623[(1)]):((G__17319)?v1:cljs.core.nth.call(null,v1,(1),1.0)));
var G__17317_17627 = (cljs.core.truth_(G__17322_17622)?(G__17311_17624[(0)]):((G__17320)?v2:cljs.core.nth.call(null,v2,(0),1.0)));
var G__17318_17628 = (cljs.core.truth_(G__17322_17622)?(G__17311_17624[(1)]):((G__17320)?v2:cljs.core.nth.call(null,v2,(1),1.0)));
(G__17312[(0)] = ((G__17313 * G__17315_17625) * G__17317_17627));

(G__17312[(1)] = ((G__17314 * G__17316_17626) * G__17318_17628));
}

return (new thi.ng.geom.vector.Vec2(G__17312,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMathOps$_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var dest__15269__auto__ = (new Float32Array((2)));
var G__17323_17629 = self__.buf;
(dest__15269__auto__[(0)] = (- (G__17323_17629[(0)])));

(dest__15269__auto__[(1)] = (- (G__17323_17629[(1)])));

return (new thi.ng.geom.vector.Vec2(dest__15269__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMathOps$_$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var dest__15299__auto__ = (new Float32Array((2)));
var G__17324_17630 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec2)){
var G__17325_17631 = v.buf;
(dest__15299__auto__[(0)] = ((G__17324_17630[(0)]) - (G__17325_17631[(0)])));

(dest__15299__auto__[(1)] = ((G__17324_17630[(1)]) - (G__17325_17631[(1)])));
} else {
if(typeof v === 'number'){
(dest__15299__auto__[(0)] = ((G__17324_17630[(0)]) - v));

(dest__15299__auto__[(1)] = ((G__17324_17630[(1)]) - v));
} else {
(dest__15299__auto__[(0)] = ((G__17324_17630[(0)]) - cljs.core.nth.call(null,v,(0),0.0)));

(dest__15299__auto__[(1)] = ((G__17324_17630[(1)]) - cljs.core.nth.call(null,v,(1),0.0)));
}
}

return (new thi.ng.geom.vector.Vec2(dest__15299__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMathOps$_$arity$3 = (function (_,v1,v2){
var self__ = this;
var ___$1 = this;
var G__17326 = self__.buf;
var G__17329 = (new Float32Array((2)));
var G__17330 = (G__17326[(0)]);
var G__17331 = (G__17326[(1)]);
var G__17336 = typeof v1 === 'number';
var G__17337 = typeof v2 === 'number';
if(((G__17336)?G__17337:false)){
(G__17329[(0)] = (G__17330 - v1));

(G__17329[(1)] = (G__17331 - v2));
} else {
var G__17338_17632 = (((!(G__17336)))?(v1 instanceof thi.ng.geom.vector.Vec2):null);
var G__17339_17633 = (((!(G__17337)))?(v2 instanceof thi.ng.geom.vector.Vec2):null);
var G__17327_17634 = (cljs.core.truth_(G__17338_17632)?v1.buf:null);
var G__17328_17635 = (cljs.core.truth_(G__17339_17633)?v2.buf:null);
var G__17332_17636 = (cljs.core.truth_(G__17338_17632)?(G__17327_17634[(0)]):((G__17336)?v1:cljs.core.nth.call(null,v1,(0),0.0)));
var G__17333_17637 = (cljs.core.truth_(G__17338_17632)?(G__17327_17634[(1)]):((G__17336)?v1:cljs.core.nth.call(null,v1,(1),0.0)));
var G__17334_17638 = (cljs.core.truth_(G__17339_17633)?(G__17328_17635[(0)]):((G__17337)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__17335_17639 = (cljs.core.truth_(G__17339_17633)?(G__17328_17635[(1)]):((G__17337)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
(G__17329[(0)] = ((G__17330 - G__17332_17636) - G__17334_17638));

(G__17329[(1)] = ((G__17331 - G__17333_17637) - G__17335_17639));
}

return (new thi.ng.geom.vector.Vec2(G__17329,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMathOps$madd$arity$3 = (function (_,a,b){
var self__ = this;
var ___$1 = this;
var dest__15310__auto__ = (new Float32Array((2)));
var G__17349_17640 = (a instanceof thi.ng.geom.vector.Vec2);
var G__17350_17641 = (b instanceof thi.ng.geom.vector.Vec2);
var G__17351_17642 = (((!(G__17349_17640)))?typeof a === 'number':null);
var G__17352_17643 = (((!(G__17350_17641)))?typeof b === 'number':null);
var G__17340_17644 = self__.buf;
var G__17341_17645 = ((G__17349_17640)?a.buf:null);
var G__17342_17646 = ((G__17350_17641)?b.buf:null);
var G__17343_17647 = (G__17340_17644[(0)]);
var G__17344_17648 = (G__17340_17644[(1)]);
var G__17345_17649 = ((G__17349_17640)?(G__17341_17645[(0)]):(cljs.core.truth_(G__17351_17642)?a:cljs.core.nth.call(null,a,(0),1.0)));
var G__17346_17650 = ((G__17349_17640)?(G__17341_17645[(1)]):(cljs.core.truth_(G__17351_17642)?a:cljs.core.nth.call(null,a,(1),1.0)));
var G__17347_17651 = ((G__17350_17641)?(G__17342_17646[(0)]):(cljs.core.truth_(G__17352_17643)?b:cljs.core.nth.call(null,b,(0),0.0)));
var G__17348_17652 = ((G__17350_17641)?(G__17342_17646[(1)]):(cljs.core.truth_(G__17352_17643)?b:cljs.core.nth.call(null,b,(1),0.0)));
(dest__15310__auto__[(0)] = ((G__17343_17647 * G__17345_17649) + G__17347_17651));

(dest__15310__auto__[(1)] = ((G__17344_17648 * G__17346_17650) + G__17348_17652));

return (new thi.ng.geom.vector.Vec2(dest__15310__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMathOps$addm$arity$3 = (function (_,a,b){
var self__ = this;
var ___$1 = this;
var dest__15310__auto__ = (new Float32Array((2)));
var G__17362_17653 = (a instanceof thi.ng.geom.vector.Vec2);
var G__17363_17654 = (b instanceof thi.ng.geom.vector.Vec2);
var G__17364_17655 = (((!(G__17362_17653)))?typeof a === 'number':null);
var G__17365_17656 = (((!(G__17363_17654)))?typeof b === 'number':null);
var G__17353_17657 = self__.buf;
var G__17354_17658 = ((G__17362_17653)?a.buf:null);
var G__17355_17659 = ((G__17363_17654)?b.buf:null);
var G__17356_17660 = (G__17353_17657[(0)]);
var G__17357_17661 = (G__17353_17657[(1)]);
var G__17358_17662 = ((G__17362_17653)?(G__17354_17658[(0)]):(cljs.core.truth_(G__17364_17655)?a:cljs.core.nth.call(null,a,(0),0.0)));
var G__17359_17663 = ((G__17362_17653)?(G__17354_17658[(1)]):(cljs.core.truth_(G__17364_17655)?a:cljs.core.nth.call(null,a,(1),0.0)));
var G__17360_17664 = ((G__17363_17654)?(G__17355_17659[(0)]):(cljs.core.truth_(G__17365_17656)?b:cljs.core.nth.call(null,b,(0),1.0)));
var G__17361_17665 = ((G__17363_17654)?(G__17355_17659[(1)]):(cljs.core.truth_(G__17365_17656)?b:cljs.core.nth.call(null,b,(1),1.0)));
(dest__15310__auto__[(0)] = ((G__17356_17660 + G__17358_17662) * G__17360_17664));

(dest__15310__auto__[(1)] = ((G__17357_17661 + G__17359_17663) * G__17361_17665));

return (new thi.ng.geom.vector.Vec2(dest__15310__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMathOps$div$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var dest__15269__auto__ = (new Float32Array((2)));
var G__17366_17666 = self__.buf;
(dest__15269__auto__[(0)] = ((1) / (G__17366_17666[(0)])));

(dest__15269__auto__[(1)] = ((1) / (G__17366_17666[(1)])));

return (new thi.ng.geom.vector.Vec2(dest__15269__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMathOps$div$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var dest__15299__auto__ = (new Float32Array((2)));
var G__17367_17667 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec2)){
var G__17368_17668 = v.buf;
(dest__15299__auto__[(0)] = ((G__17367_17667[(0)]) / (G__17368_17668[(0)])));

(dest__15299__auto__[(1)] = ((G__17367_17667[(1)]) / (G__17368_17668[(1)])));
} else {
if(typeof v === 'number'){
(dest__15299__auto__[(0)] = ((G__17367_17667[(0)]) / v));

(dest__15299__auto__[(1)] = ((G__17367_17667[(1)]) / v));
} else {
(dest__15299__auto__[(0)] = ((G__17367_17667[(0)]) / cljs.core.nth.call(null,v,(0),0.0)));

(dest__15299__auto__[(1)] = ((G__17367_17667[(1)]) / cljs.core.nth.call(null,v,(1),0.0)));
}
}

return (new thi.ng.geom.vector.Vec2(dest__15299__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMathOps$div$arity$3 = (function (_,v1,v2){
var self__ = this;
var ___$1 = this;
var G__17369 = self__.buf;
var G__17372 = (new Float32Array((2)));
var G__17373 = (G__17369[(0)]);
var G__17374 = (G__17369[(1)]);
var G__17379 = typeof v1 === 'number';
var G__17380 = typeof v2 === 'number';
if(((G__17379)?G__17380:false)){
(G__17372[(0)] = (G__17373 / v1));

(G__17372[(1)] = (G__17374 / v2));
} else {
var G__17381_17669 = (((!(G__17379)))?(v1 instanceof thi.ng.geom.vector.Vec2):null);
var G__17382_17670 = (((!(G__17380)))?(v2 instanceof thi.ng.geom.vector.Vec2):null);
var G__17370_17671 = (cljs.core.truth_(G__17381_17669)?v1.buf:null);
var G__17371_17672 = (cljs.core.truth_(G__17382_17670)?v2.buf:null);
var G__17375_17673 = (cljs.core.truth_(G__17381_17669)?(G__17370_17671[(0)]):((G__17379)?v1:cljs.core.nth.call(null,v1,(0),0.0)));
var G__17376_17674 = (cljs.core.truth_(G__17381_17669)?(G__17370_17671[(1)]):((G__17379)?v1:cljs.core.nth.call(null,v1,(1),0.0)));
var G__17377_17675 = (cljs.core.truth_(G__17382_17670)?(G__17371_17672[(0)]):((G__17380)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__17378_17676 = (cljs.core.truth_(G__17382_17670)?(G__17371_17672[(1)]):((G__17380)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
(G__17372[(0)] = ((G__17373 / G__17375_17673) / G__17377_17675));

(G__17372[(1)] = ((G__17374 / G__17376_17674) / G__17378_17676));
}

return (new thi.ng.geom.vector.Vec2(G__17372,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMathOps$_PLUS_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return ___$1;
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMathOps$_PLUS_$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var dest__15299__auto__ = (new Float32Array((2)));
var G__17383_17677 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec2)){
var G__17384_17678 = v.buf;
(dest__15299__auto__[(0)] = ((G__17383_17677[(0)]) + (G__17384_17678[(0)])));

(dest__15299__auto__[(1)] = ((G__17383_17677[(1)]) + (G__17384_17678[(1)])));
} else {
if(typeof v === 'number'){
(dest__15299__auto__[(0)] = ((G__17383_17677[(0)]) + v));

(dest__15299__auto__[(1)] = ((G__17383_17677[(1)]) + v));
} else {
(dest__15299__auto__[(0)] = ((G__17383_17677[(0)]) + cljs.core.nth.call(null,v,(0),0.0)));

(dest__15299__auto__[(1)] = ((G__17383_17677[(1)]) + cljs.core.nth.call(null,v,(1),0.0)));
}
}

return (new thi.ng.geom.vector.Vec2(dest__15299__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMathOps$_PLUS_$arity$3 = (function (_,v1,v2){
var self__ = this;
var ___$1 = this;
var G__17385 = self__.buf;
var G__17388 = (new Float32Array((2)));
var G__17389 = (G__17385[(0)]);
var G__17390 = (G__17385[(1)]);
var G__17395 = typeof v1 === 'number';
var G__17396 = typeof v2 === 'number';
if(((G__17395)?G__17396:false)){
(G__17388[(0)] = (G__17389 + v1));

(G__17388[(1)] = (G__17390 + v2));
} else {
var G__17397_17679 = (((!(G__17395)))?(v1 instanceof thi.ng.geom.vector.Vec2):null);
var G__17398_17680 = (((!(G__17396)))?(v2 instanceof thi.ng.geom.vector.Vec2):null);
var G__17386_17681 = (cljs.core.truth_(G__17397_17679)?v1.buf:null);
var G__17387_17682 = (cljs.core.truth_(G__17398_17680)?v2.buf:null);
var G__17391_17683 = (cljs.core.truth_(G__17397_17679)?(G__17386_17681[(0)]):((G__17395)?v1:cljs.core.nth.call(null,v1,(0),0.0)));
var G__17392_17684 = (cljs.core.truth_(G__17397_17679)?(G__17386_17681[(1)]):((G__17395)?v1:cljs.core.nth.call(null,v1,(1),0.0)));
var G__17393_17685 = (cljs.core.truth_(G__17398_17680)?(G__17387_17682[(0)]):((G__17396)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__17394_17686 = (cljs.core.truth_(G__17398_17680)?(G__17387_17682[(1)]):((G__17396)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
(G__17388[(0)] = ((G__17389 + G__17391_17683) + G__17393_17685));

(G__17388[(1)] = ((G__17390 + G__17392_17684) + G__17394_17686));
}

return (new thi.ng.geom.vector.Vec2(G__17388,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMathOps$abs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var dest__15269__auto__ = (new Float32Array((2)));
var G__17399_17687 = self__.buf;
(dest__15269__auto__[(0)] = thi.ng.math.core.abs_STAR_.call(null,(G__17399_17687[(0)])));

(dest__15269__auto__[(1)] = thi.ng.math.core.abs_STAR_.call(null,(G__17399_17687[(1)])));

return (new thi.ng.geom.vector.Vec2(dest__15269__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec2.prototype.thi$ng$math$core$IMathOps$subm$arity$3 = (function (_,a,b){
var self__ = this;
var ___$1 = this;
var dest__15310__auto__ = (new Float32Array((2)));
var G__17409_17688 = (a instanceof thi.ng.geom.vector.Vec2);
var G__17410_17689 = (b instanceof thi.ng.geom.vector.Vec2);
var G__17411_17690 = (((!(G__17409_17688)))?typeof a === 'number':null);
var G__17412_17691 = (((!(G__17410_17689)))?typeof b === 'number':null);
var G__17400_17692 = self__.buf;
var G__17401_17693 = ((G__17409_17688)?a.buf:null);
var G__17402_17694 = ((G__17410_17689)?b.buf:null);
var G__17403_17695 = (G__17400_17692[(0)]);
var G__17404_17696 = (G__17400_17692[(1)]);
var G__17405_17697 = ((G__17409_17688)?(G__17401_17693[(0)]):(cljs.core.truth_(G__17411_17690)?a:cljs.core.nth.call(null,a,(0),0.0)));
var G__17406_17698 = ((G__17409_17688)?(G__17401_17693[(1)]):(cljs.core.truth_(G__17411_17690)?a:cljs.core.nth.call(null,a,(1),0.0)));
var G__17407_17699 = ((G__17410_17689)?(G__17402_17694[(0)]):(cljs.core.truth_(G__17412_17691)?b:cljs.core.nth.call(null,b,(0),1.0)));
var G__17408_17700 = ((G__17410_17689)?(G__17402_17694[(1)]):(cljs.core.truth_(G__17412_17691)?b:cljs.core.nth.call(null,b,(1),1.0)));
(dest__15310__auto__[(0)] = ((G__17403_17695 - G__17405_17697) * G__17407_17699));

(dest__15310__auto__[(1)] = ((G__17404_17696 - G__17406_17698) * G__17408_17700));

return (new thi.ng.geom.vector.Vec2(dest__15310__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec2.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"buf","buf",1426618187,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_hash","_hash",-2130838312,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"_meta","_meta",-1716892533,null)], null);
});

thi.ng.geom.vector.Vec2.cljs$lang$type = true;

thi.ng.geom.vector.Vec2.cljs$lang$ctorStr = "thi.ng.geom.vector/Vec2";

thi.ng.geom.vector.Vec2.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"thi.ng.geom.vector/Vec2");
});

/**
 * Positional factory function for thi.ng.geom.vector/Vec2.
 */
thi.ng.geom.vector.__GT_Vec2 = (function thi$ng$geom$vector$__GT_Vec2(buf,_hash,_meta){
return (new thi.ng.geom.vector.Vec2(buf,_hash,_meta));
});


/**
* @constructor
 * @implements {thi.ng.geom.core.ITranslate}
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {thi.ng.math.core.IDotProduct}
 * @implements {cljs.core.IReversible}
 * @implements {thi.ng.math.core.IMutableMathOps}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {thi.ng.math.core.ICrossProduct}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {thi.ng.math.core.IDeltaEquals}
 * @implements {thi.ng.geom.core.IPolar}
 * @implements {thi.ng.geom.core.IRotate3D}
 * @implements {thi.ng.geom.vector.Object}
 * @implements {thi.ng.geom.core.IClear}
 * @implements {thi.ng.math.core.IInvert}
 * @implements {cljs.core.ICounted}
 * @implements {thi.ng.math.core.ILimit}
 * @implements {thi.ng.dstruct.streams.IBuffer}
 * @implements {cljs.core.ISeq}
 * @implements {thi.ng.math.core.IInterpolate}
 * @implements {cljs.core.INext}
 * @implements {thi.ng.math.core.IMathOps}
 * @implements {thi.ng.geom.core.ITransform}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {thi.ng.math.core.IMinMax}
 * @implements {thi.ng.geom.core.IRotate}
 * @implements {thi.ng.math.core.INormalize}
 * @implements {thi.ng.math.core.IMagnitude}
 * @implements {thi.ng.geom.core.IScale}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {thi.ng.geom.core.IReflect}
 * @implements {thi.ng.geom.core.IHeading}
 * @implements {thi.ng.geom.core.IDistance}
 * @implements {cljs.core.IComparable}
 * @implements {thi.ng.dstruct.streams.IIntoBuffer}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {thi.ng.geom.core.IVectorReduce}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
thi.ng.geom.vector.Vec3 = (function (buf,_hash,_meta){
this.buf = buf;
this._hash = _hash;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 2314101723;
this.cljs$lang$protocol_mask$partition1$ = 10240;
});
thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$ITransform$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$ITransform$transform$arity$2 = (function (_,m){
var self__ = this;
var ___$1 = this;
return thi.ng.geom.core.transform_vector.call(null,m,___$1);
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$__BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
(self__.buf[(0)] = (- (self__.buf[(0)])));

(self__.buf[(1)] = (- (self__.buf[(1)])));

(self__.buf[(2)] = (- (self__.buf[(2)])));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$__BANG_$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var G__17702_18153 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__17703_18154 = v.buf;
(self__.buf[(0)] = ((G__17702_18153[(0)]) - (G__17703_18154[(0)])));

(self__.buf[(1)] = ((G__17702_18153[(1)]) - (G__17703_18154[(1)])));

(self__.buf[(2)] = ((G__17702_18153[(2)]) - (G__17703_18154[(2)])));

self__._hash = null;
} else {
if(typeof v === 'number'){
(self__.buf[(0)] = ((G__17702_18153[(0)]) - v));

(self__.buf[(1)] = ((G__17702_18153[(1)]) - v));

(self__.buf[(2)] = ((G__17702_18153[(2)]) - v));

self__._hash = null;
} else {
(self__.buf[(0)] = ((G__17702_18153[(0)]) - cljs.core.nth.call(null,v,(0),0.0)));

(self__.buf[(1)] = ((G__17702_18153[(1)]) - cljs.core.nth.call(null,v,(1),0.0)));

(self__.buf[(2)] = ((G__17702_18153[(2)]) - cljs.core.nth.call(null,v,(2),0.0)));

self__._hash = null;
}
}

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$__BANG_$arity$3 = (function (_,v1,v2){
var self__ = this;
var ___$1 = this;
var G__17716_18155 = (v1 instanceof thi.ng.geom.vector.Vec3);
var G__17717_18156 = (v2 instanceof thi.ng.geom.vector.Vec3);
var G__17718_18157 = (((!(G__17716_18155)))?typeof v1 === 'number':null);
var G__17719_18158 = (((!(G__17717_18156)))?typeof v2 === 'number':null);
var G__17704_18159 = self__.buf;
var G__17705_18160 = ((G__17716_18155)?v1.buf:null);
var G__17706_18161 = ((G__17717_18156)?v2.buf:null);
var G__17707_18162 = (G__17704_18159[(0)]);
var G__17708_18163 = (G__17704_18159[(1)]);
var G__17709_18164 = (G__17704_18159[(2)]);
var G__17710_18165 = ((G__17716_18155)?(G__17705_18160[(0)]):(cljs.core.truth_(G__17718_18157)?v1:cljs.core.nth.call(null,v1,(0),0.0)));
var G__17711_18166 = ((G__17716_18155)?(G__17705_18160[(1)]):(cljs.core.truth_(G__17718_18157)?v1:cljs.core.nth.call(null,v1,(1),0.0)));
var G__17712_18167 = ((G__17716_18155)?(G__17705_18160[(2)]):(cljs.core.truth_(G__17718_18157)?v1:cljs.core.nth.call(null,v1,(2),0.0)));
var G__17713_18168 = ((G__17717_18156)?(G__17706_18161[(0)]):(cljs.core.truth_(G__17719_18158)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__17714_18169 = ((G__17717_18156)?(G__17706_18161[(1)]):(cljs.core.truth_(G__17719_18158)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
var G__17715_18170 = ((G__17717_18156)?(G__17706_18161[(2)]):(cljs.core.truth_(G__17719_18158)?v2:cljs.core.nth.call(null,v2,(2),0.0)));
(self__.buf[(0)] = ((G__17707_18162 - G__17710_18165) - G__17713_18168));

(self__.buf[(1)] = ((G__17708_18163 - G__17711_18166) - G__17714_18169));

(self__.buf[(2)] = ((G__17709_18164 - G__17712_18167) - G__17715_18170));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$__BANG_$arity$4 = (function (_,x,y,z){
var self__ = this;
var ___$1 = this;
(self__.buf[(0)] = ((self__.buf[(0)]) - x));

(self__.buf[(1)] = ((self__.buf[(1)]) - y));

(self__.buf[(2)] = ((self__.buf[(2)]) - z));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$_STAR__BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$_STAR__BANG_$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var G__17720_18171 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__17721_18172 = v.buf;
(self__.buf[(0)] = ((G__17720_18171[(0)]) * (G__17721_18172[(0)])));

(self__.buf[(1)] = ((G__17720_18171[(1)]) * (G__17721_18172[(1)])));

(self__.buf[(2)] = ((G__17720_18171[(2)]) * (G__17721_18172[(2)])));

self__._hash = null;
} else {
if(typeof v === 'number'){
(self__.buf[(0)] = ((G__17720_18171[(0)]) * v));

(self__.buf[(1)] = ((G__17720_18171[(1)]) * v));

(self__.buf[(2)] = ((G__17720_18171[(2)]) * v));

self__._hash = null;
} else {
(self__.buf[(0)] = ((G__17720_18171[(0)]) * cljs.core.nth.call(null,v,(0),0.0)));

(self__.buf[(1)] = ((G__17720_18171[(1)]) * cljs.core.nth.call(null,v,(1),0.0)));

(self__.buf[(2)] = ((G__17720_18171[(2)]) * cljs.core.nth.call(null,v,(2),0.0)));

self__._hash = null;
}
}

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$_STAR__BANG_$arity$3 = (function (_,v1,v2){
var self__ = this;
var ___$1 = this;
var G__17734_18173 = (v1 instanceof thi.ng.geom.vector.Vec3);
var G__17735_18174 = (v2 instanceof thi.ng.geom.vector.Vec3);
var G__17736_18175 = (((!(G__17734_18173)))?typeof v1 === 'number':null);
var G__17737_18176 = (((!(G__17735_18174)))?typeof v2 === 'number':null);
var G__17722_18177 = self__.buf;
var G__17723_18178 = ((G__17734_18173)?v1.buf:null);
var G__17724_18179 = ((G__17735_18174)?v2.buf:null);
var G__17725_18180 = (G__17722_18177[(0)]);
var G__17726_18181 = (G__17722_18177[(1)]);
var G__17727_18182 = (G__17722_18177[(2)]);
var G__17728_18183 = ((G__17734_18173)?(G__17723_18178[(0)]):(cljs.core.truth_(G__17736_18175)?v1:cljs.core.nth.call(null,v1,(0),0.0)));
var G__17729_18184 = ((G__17734_18173)?(G__17723_18178[(1)]):(cljs.core.truth_(G__17736_18175)?v1:cljs.core.nth.call(null,v1,(1),0.0)));
var G__17730_18185 = ((G__17734_18173)?(G__17723_18178[(2)]):(cljs.core.truth_(G__17736_18175)?v1:cljs.core.nth.call(null,v1,(2),0.0)));
var G__17731_18186 = ((G__17735_18174)?(G__17724_18179[(0)]):(cljs.core.truth_(G__17737_18176)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__17732_18187 = ((G__17735_18174)?(G__17724_18179[(1)]):(cljs.core.truth_(G__17737_18176)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
var G__17733_18188 = ((G__17735_18174)?(G__17724_18179[(2)]):(cljs.core.truth_(G__17737_18176)?v2:cljs.core.nth.call(null,v2,(2),0.0)));
(self__.buf[(0)] = ((G__17725_18180 * G__17728_18183) * G__17731_18186));

(self__.buf[(1)] = ((G__17726_18181 * G__17729_18184) * G__17732_18187));

(self__.buf[(2)] = ((G__17727_18182 * G__17730_18185) * G__17733_18188));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$_STAR__BANG_$arity$4 = (function (_,x,y,z){
var self__ = this;
var ___$1 = this;
(self__.buf[(0)] = ((self__.buf[(0)]) * x));

(self__.buf[(1)] = ((self__.buf[(1)]) * y));

(self__.buf[(2)] = ((self__.buf[(2)]) * z));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$subm_BANG_$arity$3 = (function (_,a,b){
var self__ = this;
var ___$1 = this;
var G__17750_18189 = (a instanceof thi.ng.geom.vector.Vec3);
var G__17751_18190 = (b instanceof thi.ng.geom.vector.Vec3);
var G__17752_18191 = (((!(G__17750_18189)))?typeof a === 'number':null);
var G__17753_18192 = (((!(G__17751_18190)))?typeof b === 'number':null);
var G__17738_18193 = self__.buf;
var G__17739_18194 = ((G__17750_18189)?a.buf:null);
var G__17740_18195 = ((G__17751_18190)?b.buf:null);
var G__17741_18196 = (G__17738_18193[(0)]);
var G__17742_18197 = (G__17738_18193[(1)]);
var G__17743_18198 = (G__17738_18193[(2)]);
var G__17744_18199 = ((G__17750_18189)?(G__17739_18194[(0)]):(cljs.core.truth_(G__17752_18191)?a:cljs.core.nth.call(null,a,(0),0.0)));
var G__17745_18200 = ((G__17750_18189)?(G__17739_18194[(1)]):(cljs.core.truth_(G__17752_18191)?a:cljs.core.nth.call(null,a,(1),0.0)));
var G__17746_18201 = ((G__17750_18189)?(G__17739_18194[(2)]):(cljs.core.truth_(G__17752_18191)?a:cljs.core.nth.call(null,a,(2),0.0)));
var G__17747_18202 = ((G__17751_18190)?(G__17740_18195[(0)]):(cljs.core.truth_(G__17753_18192)?b:cljs.core.nth.call(null,b,(0),1.0)));
var G__17748_18203 = ((G__17751_18190)?(G__17740_18195[(1)]):(cljs.core.truth_(G__17753_18192)?b:cljs.core.nth.call(null,b,(1),1.0)));
var G__17749_18204 = ((G__17751_18190)?(G__17740_18195[(2)]):(cljs.core.truth_(G__17753_18192)?b:cljs.core.nth.call(null,b,(2),1.0)));
(self__.buf[(0)] = ((G__17741_18196 - G__17744_18199) * G__17747_18202));

(self__.buf[(1)] = ((G__17742_18197 - G__17745_18200) * G__17748_18203));

(self__.buf[(2)] = ((G__17743_18198 - G__17746_18201) * G__17749_18204));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$msub_BANG_$arity$3 = (function (_,a,b){
var self__ = this;
var ___$1 = this;
var G__17766_18205 = (a instanceof thi.ng.geom.vector.Vec3);
var G__17767_18206 = (b instanceof thi.ng.geom.vector.Vec3);
var G__17768_18207 = (((!(G__17766_18205)))?typeof a === 'number':null);
var G__17769_18208 = (((!(G__17767_18206)))?typeof b === 'number':null);
var G__17754_18209 = self__.buf;
var G__17755_18210 = ((G__17766_18205)?a.buf:null);
var G__17756_18211 = ((G__17767_18206)?b.buf:null);
var G__17757_18212 = (G__17754_18209[(0)]);
var G__17758_18213 = (G__17754_18209[(1)]);
var G__17759_18214 = (G__17754_18209[(2)]);
var G__17760_18215 = ((G__17766_18205)?(G__17755_18210[(0)]):(cljs.core.truth_(G__17768_18207)?a:cljs.core.nth.call(null,a,(0),1.0)));
var G__17761_18216 = ((G__17766_18205)?(G__17755_18210[(1)]):(cljs.core.truth_(G__17768_18207)?a:cljs.core.nth.call(null,a,(1),1.0)));
var G__17762_18217 = ((G__17766_18205)?(G__17755_18210[(2)]):(cljs.core.truth_(G__17768_18207)?a:cljs.core.nth.call(null,a,(2),1.0)));
var G__17763_18218 = ((G__17767_18206)?(G__17756_18211[(0)]):(cljs.core.truth_(G__17769_18208)?b:cljs.core.nth.call(null,b,(0),0.0)));
var G__17764_18219 = ((G__17767_18206)?(G__17756_18211[(1)]):(cljs.core.truth_(G__17769_18208)?b:cljs.core.nth.call(null,b,(1),0.0)));
var G__17765_18220 = ((G__17767_18206)?(G__17756_18211[(2)]):(cljs.core.truth_(G__17769_18208)?b:cljs.core.nth.call(null,b,(2),0.0)));
(self__.buf[(0)] = ((G__17757_18212 * G__17760_18215) - G__17763_18218));

(self__.buf[(1)] = ((G__17758_18213 * G__17761_18216) - G__17764_18219));

(self__.buf[(2)] = ((G__17759_18214 * G__17762_18217) - G__17765_18220));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$abs_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
(self__.buf[(0)] = thi.ng.math.core.abs_STAR_.call(null,(self__.buf[(0)])));

(self__.buf[(1)] = thi.ng.math.core.abs_STAR_.call(null,(self__.buf[(1)])));

(self__.buf[(2)] = thi.ng.math.core.abs_STAR_.call(null,(self__.buf[(2)])));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$madd_BANG_$arity$3 = (function (_,a,b){
var self__ = this;
var ___$1 = this;
var G__17782_18221 = (a instanceof thi.ng.geom.vector.Vec3);
var G__17783_18222 = (b instanceof thi.ng.geom.vector.Vec3);
var G__17784_18223 = (((!(G__17782_18221)))?typeof a === 'number':null);
var G__17785_18224 = (((!(G__17783_18222)))?typeof b === 'number':null);
var G__17770_18225 = self__.buf;
var G__17771_18226 = ((G__17782_18221)?a.buf:null);
var G__17772_18227 = ((G__17783_18222)?b.buf:null);
var G__17773_18228 = (G__17770_18225[(0)]);
var G__17774_18229 = (G__17770_18225[(1)]);
var G__17775_18230 = (G__17770_18225[(2)]);
var G__17776_18231 = ((G__17782_18221)?(G__17771_18226[(0)]):(cljs.core.truth_(G__17784_18223)?a:cljs.core.nth.call(null,a,(0),1.0)));
var G__17777_18232 = ((G__17782_18221)?(G__17771_18226[(1)]):(cljs.core.truth_(G__17784_18223)?a:cljs.core.nth.call(null,a,(1),1.0)));
var G__17778_18233 = ((G__17782_18221)?(G__17771_18226[(2)]):(cljs.core.truth_(G__17784_18223)?a:cljs.core.nth.call(null,a,(2),1.0)));
var G__17779_18234 = ((G__17783_18222)?(G__17772_18227[(0)]):(cljs.core.truth_(G__17785_18224)?b:cljs.core.nth.call(null,b,(0),0.0)));
var G__17780_18235 = ((G__17783_18222)?(G__17772_18227[(1)]):(cljs.core.truth_(G__17785_18224)?b:cljs.core.nth.call(null,b,(1),0.0)));
var G__17781_18236 = ((G__17783_18222)?(G__17772_18227[(2)]):(cljs.core.truth_(G__17785_18224)?b:cljs.core.nth.call(null,b,(2),0.0)));
(self__.buf[(0)] = ((G__17773_18228 * G__17776_18231) + G__17779_18234));

(self__.buf[(1)] = ((G__17774_18229 * G__17777_18232) + G__17780_18235));

(self__.buf[(2)] = ((G__17775_18230 * G__17778_18233) + G__17781_18236));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$div_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
(self__.buf[(0)] = ((1) / (self__.buf[(0)])));

(self__.buf[(1)] = ((1) / (self__.buf[(1)])));

(self__.buf[(2)] = ((1) / (self__.buf[(2)])));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$div_BANG_$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var G__17786_18237 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__17787_18238 = v.buf;
(self__.buf[(0)] = ((G__17786_18237[(0)]) / (G__17787_18238[(0)])));

(self__.buf[(1)] = ((G__17786_18237[(1)]) / (G__17787_18238[(1)])));

(self__.buf[(2)] = ((G__17786_18237[(2)]) / (G__17787_18238[(2)])));

self__._hash = null;
} else {
if(typeof v === 'number'){
(self__.buf[(0)] = ((G__17786_18237[(0)]) / v));

(self__.buf[(1)] = ((G__17786_18237[(1)]) / v));

(self__.buf[(2)] = ((G__17786_18237[(2)]) / v));

self__._hash = null;
} else {
(self__.buf[(0)] = ((G__17786_18237[(0)]) / cljs.core.nth.call(null,v,(0),0.0)));

(self__.buf[(1)] = ((G__17786_18237[(1)]) / cljs.core.nth.call(null,v,(1),0.0)));

(self__.buf[(2)] = ((G__17786_18237[(2)]) / cljs.core.nth.call(null,v,(2),0.0)));

self__._hash = null;
}
}

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$div_BANG_$arity$3 = (function (_,v1,v2){
var self__ = this;
var ___$1 = this;
var G__17800_18239 = (v1 instanceof thi.ng.geom.vector.Vec3);
var G__17801_18240 = (v2 instanceof thi.ng.geom.vector.Vec3);
var G__17802_18241 = (((!(G__17800_18239)))?typeof v1 === 'number':null);
var G__17803_18242 = (((!(G__17801_18240)))?typeof v2 === 'number':null);
var G__17788_18243 = self__.buf;
var G__17789_18244 = ((G__17800_18239)?v1.buf:null);
var G__17790_18245 = ((G__17801_18240)?v2.buf:null);
var G__17791_18246 = (G__17788_18243[(0)]);
var G__17792_18247 = (G__17788_18243[(1)]);
var G__17793_18248 = (G__17788_18243[(2)]);
var G__17794_18249 = ((G__17800_18239)?(G__17789_18244[(0)]):(cljs.core.truth_(G__17802_18241)?v1:cljs.core.nth.call(null,v1,(0),0.0)));
var G__17795_18250 = ((G__17800_18239)?(G__17789_18244[(1)]):(cljs.core.truth_(G__17802_18241)?v1:cljs.core.nth.call(null,v1,(1),0.0)));
var G__17796_18251 = ((G__17800_18239)?(G__17789_18244[(2)]):(cljs.core.truth_(G__17802_18241)?v1:cljs.core.nth.call(null,v1,(2),0.0)));
var G__17797_18252 = ((G__17801_18240)?(G__17790_18245[(0)]):(cljs.core.truth_(G__17803_18242)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__17798_18253 = ((G__17801_18240)?(G__17790_18245[(1)]):(cljs.core.truth_(G__17803_18242)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
var G__17799_18254 = ((G__17801_18240)?(G__17790_18245[(2)]):(cljs.core.truth_(G__17803_18242)?v2:cljs.core.nth.call(null,v2,(2),0.0)));
(self__.buf[(0)] = ((G__17791_18246 / G__17794_18249) / G__17797_18252));

(self__.buf[(1)] = ((G__17792_18247 / G__17795_18250) / G__17798_18253));

(self__.buf[(2)] = ((G__17793_18248 / G__17796_18251) / G__17799_18254));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$div_BANG_$arity$4 = (function (_,x,y,z){
var self__ = this;
var ___$1 = this;
(self__.buf[(0)] = ((self__.buf[(0)]) / x));

(self__.buf[(1)] = ((self__.buf[(1)]) / y));

(self__.buf[(2)] = ((self__.buf[(2)]) / z));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$_PLUS__BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$_PLUS__BANG_$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var G__17804_18255 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__17805_18256 = v.buf;
(self__.buf[(0)] = ((G__17804_18255[(0)]) + (G__17805_18256[(0)])));

(self__.buf[(1)] = ((G__17804_18255[(1)]) + (G__17805_18256[(1)])));

(self__.buf[(2)] = ((G__17804_18255[(2)]) + (G__17805_18256[(2)])));

self__._hash = null;
} else {
if(typeof v === 'number'){
(self__.buf[(0)] = ((G__17804_18255[(0)]) + v));

(self__.buf[(1)] = ((G__17804_18255[(1)]) + v));

(self__.buf[(2)] = ((G__17804_18255[(2)]) + v));

self__._hash = null;
} else {
(self__.buf[(0)] = ((G__17804_18255[(0)]) + cljs.core.nth.call(null,v,(0),0.0)));

(self__.buf[(1)] = ((G__17804_18255[(1)]) + cljs.core.nth.call(null,v,(1),0.0)));

(self__.buf[(2)] = ((G__17804_18255[(2)]) + cljs.core.nth.call(null,v,(2),0.0)));

self__._hash = null;
}
}

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$_PLUS__BANG_$arity$3 = (function (_,v1,v2){
var self__ = this;
var ___$1 = this;
var G__17818_18257 = (v1 instanceof thi.ng.geom.vector.Vec3);
var G__17819_18258 = (v2 instanceof thi.ng.geom.vector.Vec3);
var G__17820_18259 = (((!(G__17818_18257)))?typeof v1 === 'number':null);
var G__17821_18260 = (((!(G__17819_18258)))?typeof v2 === 'number':null);
var G__17806_18261 = self__.buf;
var G__17807_18262 = ((G__17818_18257)?v1.buf:null);
var G__17808_18263 = ((G__17819_18258)?v2.buf:null);
var G__17809_18264 = (G__17806_18261[(0)]);
var G__17810_18265 = (G__17806_18261[(1)]);
var G__17811_18266 = (G__17806_18261[(2)]);
var G__17812_18267 = ((G__17818_18257)?(G__17807_18262[(0)]):(cljs.core.truth_(G__17820_18259)?v1:cljs.core.nth.call(null,v1,(0),0.0)));
var G__17813_18268 = ((G__17818_18257)?(G__17807_18262[(1)]):(cljs.core.truth_(G__17820_18259)?v1:cljs.core.nth.call(null,v1,(1),0.0)));
var G__17814_18269 = ((G__17818_18257)?(G__17807_18262[(2)]):(cljs.core.truth_(G__17820_18259)?v1:cljs.core.nth.call(null,v1,(2),0.0)));
var G__17815_18270 = ((G__17819_18258)?(G__17808_18263[(0)]):(cljs.core.truth_(G__17821_18260)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__17816_18271 = ((G__17819_18258)?(G__17808_18263[(1)]):(cljs.core.truth_(G__17821_18260)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
var G__17817_18272 = ((G__17819_18258)?(G__17808_18263[(2)]):(cljs.core.truth_(G__17821_18260)?v2:cljs.core.nth.call(null,v2,(2),0.0)));
(self__.buf[(0)] = ((G__17809_18264 + G__17812_18267) + G__17815_18270));

(self__.buf[(1)] = ((G__17810_18265 + G__17813_18268) + G__17816_18271));

(self__.buf[(2)] = ((G__17811_18266 + G__17814_18269) + G__17817_18272));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$_PLUS__BANG_$arity$4 = (function (_,x,y,z){
var self__ = this;
var ___$1 = this;
(self__.buf[(0)] = ((self__.buf[(0)]) + x));

(self__.buf[(1)] = ((self__.buf[(1)]) + y));

(self__.buf[(2)] = ((self__.buf[(2)]) + z));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMutableMathOps$addm_BANG_$arity$3 = (function (_,a,b){
var self__ = this;
var ___$1 = this;
var G__17834_18273 = (a instanceof thi.ng.geom.vector.Vec3);
var G__17835_18274 = (b instanceof thi.ng.geom.vector.Vec3);
var G__17836_18275 = (((!(G__17834_18273)))?typeof a === 'number':null);
var G__17837_18276 = (((!(G__17835_18274)))?typeof b === 'number':null);
var G__17822_18277 = self__.buf;
var G__17823_18278 = ((G__17834_18273)?a.buf:null);
var G__17824_18279 = ((G__17835_18274)?b.buf:null);
var G__17825_18280 = (G__17822_18277[(0)]);
var G__17826_18281 = (G__17822_18277[(1)]);
var G__17827_18282 = (G__17822_18277[(2)]);
var G__17828_18283 = ((G__17834_18273)?(G__17823_18278[(0)]):(cljs.core.truth_(G__17836_18275)?a:cljs.core.nth.call(null,a,(0),0.0)));
var G__17829_18284 = ((G__17834_18273)?(G__17823_18278[(1)]):(cljs.core.truth_(G__17836_18275)?a:cljs.core.nth.call(null,a,(1),0.0)));
var G__17830_18285 = ((G__17834_18273)?(G__17823_18278[(2)]):(cljs.core.truth_(G__17836_18275)?a:cljs.core.nth.call(null,a,(2),0.0)));
var G__17831_18286 = ((G__17835_18274)?(G__17824_18279[(0)]):(cljs.core.truth_(G__17837_18276)?b:cljs.core.nth.call(null,b,(0),1.0)));
var G__17832_18287 = ((G__17835_18274)?(G__17824_18279[(1)]):(cljs.core.truth_(G__17837_18276)?b:cljs.core.nth.call(null,b,(1),1.0)));
var G__17833_18288 = ((G__17835_18274)?(G__17824_18279[(2)]):(cljs.core.truth_(G__17837_18276)?b:cljs.core.nth.call(null,b,(2),1.0)));
(self__.buf[(0)] = ((G__17825_18280 + G__17828_18283) * G__17831_18286));

(self__.buf[(1)] = ((G__17826_18281 + G__17829_18284) * G__17832_18287));

(self__.buf[(2)] = ((G__17827_18282 + G__17830_18285) * G__17833_18288));

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$dstruct$streams$IBuffer$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$dstruct$streams$IBuffer$get_float_buffer$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.buf;
});

thi.ng.geom.vector.Vec3.prototype.toString = (function (){
var self__ = this;
var _ = this;
return ["[",cljs.core.str.cljs$core$IFn$_invoke$arity$1((self__.buf[(0)]))," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((self__.buf[(1)]))," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((self__.buf[(2)])),"]"].join('');
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
if((k instanceof cljs.core.Keyword)){
var temp__5802__auto__ = thi.ng.geom.vector.swizzle3_fns.call(null,k);
if(cljs.core.truth_(temp__5802__auto__)){
var f = temp__5802__auto__;
return f.call(null,___$1);
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,k);
}
} else {
if((((k >= (0))) && ((k <= (2))))){
return (self__.buf[k]);
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,k);
}
}
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (_,k,nf){
var self__ = this;
var ___$1 = this;
if((k instanceof cljs.core.Keyword)){
var temp__5802__auto__ = thi.ng.geom.vector.swizzle3_fns.call(null,k);
if(cljs.core.truth_(temp__5802__auto__)){
var f = temp__5802__auto__;
return f.call(null,___$1);
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,k);
}
} else {
if((((k >= (0))) && ((k <= (2))))){
return (self__.buf[k]);
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,k);
}
}
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$ICrossProduct$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$ICrossProduct$cross$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var b = (new Float32Array((3)));
var G__17838_18289 = self__.buf;
var G__17840_18290 = (G__17838_18289[(0)]);
var G__17841_18291 = (G__17838_18289[(1)]);
var G__17842_18292 = (G__17838_18289[(2)]);
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__17839_18293 = v.buf;
var G__17843_18294 = (G__17839_18293[(0)]);
var G__17844_18295 = (G__17839_18293[(1)]);
var G__17845_18296 = (G__17839_18293[(2)]);
(b[(0)] = ((G__17841_18291 * G__17845_18296) - (G__17844_18295 * G__17842_18292)));

(b[(1)] = ((G__17842_18292 * G__17843_18294) - (G__17845_18296 * G__17840_18290)));

(b[(2)] = ((G__17840_18290 * G__17844_18295) - (G__17843_18294 * G__17841_18291)));
} else {
var G__17843_18297 = cljs.core.nth.call(null,v,(0),0.0);
var G__17844_18298 = cljs.core.nth.call(null,v,(1),0.0);
var G__17845_18299 = cljs.core.nth.call(null,v,(2),0.0);
(b[(0)] = ((G__17841_18291 * G__17845_18299) - (G__17844_18298 * G__17842_18292)));

(b[(1)] = ((G__17842_18292 * G__17843_18297) - (G__17845_18299 * G__17840_18290)));

(b[(2)] = ((G__17840_18290 * G__17844_18298) - (G__17843_18297 * G__17841_18291)));
}

return (new thi.ng.geom.vector.Vec3(b,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (_,n){
var self__ = this;
var ___$1 = this;
if((n >= (0))){
if((n < (3))){
return (self__.buf[n]);
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,n);
}
} else {
return null;
}
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (_,n,nf){
var self__ = this;
var ___$1 = this;
if((n >= (0))){
if((n < (3))){
return (self__.buf[n]);
} else {
return nf;
}
} else {
return null;
}
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (_,writer,opts){
var self__ = this;
var ___$1 = this;
return cljs.core.pr_sequential_writer.call(null,writer,cljs.core.pr_writer,"#vec3 ["," ","]",opts,cljs.core.seq.call(null,___$1));
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (_,n,v){
var self__ = this;
var ___$1 = this;
var b = (new Float32Array(self__.buf));
(b[n] = v);

return (new thi.ng.geom.vector.Vec3(b,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__._meta;
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new thi.ng.geom.vector.Vec3((new Float32Array(self__.buf)),self__._hash,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IReflect$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IReflect$reflect$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var b = (new Float32Array((3)));
var G__17846 = self__.buf;
var G__17848 = (G__17846[(0)]);
var G__17849 = (G__17846[(1)]);
var G__17850 = (G__17846[(2)]);
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__17847 = v.buf;
var G__17851 = (G__17847[(0)]);
var G__17852 = (G__17847[(1)]);
var G__17853 = (G__17847[(2)]);
var d = ((((G__17848 * G__17851) + (G__17849 * G__17852)) + (G__17850 * G__17853)) * 2.0);
(b[(0)] = ((G__17851 * d) - G__17848));

(b[(1)] = ((G__17852 * d) - G__17849));

(b[(2)] = ((G__17853 * d) - G__17850));

return (new thi.ng.geom.vector.Vec3(b,null,self__._meta));
} else {
var G__17851 = cljs.core.nth.call(null,v,(0),0.0);
var G__17852 = cljs.core.nth.call(null,v,(1),0.0);
var G__17853 = cljs.core.nth.call(null,v,(2),0.0);
var d = ((((G__17848 * G__17851) + (G__17849 * G__17852)) + (G__17850 * G__17853)) * 2.0);
(b[(0)] = ((G__17851 * d) - G__17848));

(b[(1)] = ((G__17852 * d) - G__17849));

(b[(2)] = ((G__17853 * d) - G__17850));

return (new thi.ng.geom.vector.Vec3(b,null,self__._meta));
}
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$INext$_next$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.cons.call(null,(self__.buf[(1)]),cljs.core.cons.call(null,(self__.buf[(2)]),null));
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (3);
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IDistance$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IDistance$dist$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
return Math.sqrt(thi.ng.geom.core.dist_squared.call(null,___$1,v));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IDistance$dist_squared$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var G__17854 = self__.buf;
var G__17856 = (G__17854[(0)]);
var G__17857 = (G__17854[(1)]);
var G__17858 = (G__17854[(2)]);
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__17855 = v.buf;
var G__17859 = (G__17855[(0)]);
var G__17860 = (G__17855[(1)]);
var G__17861 = (G__17855[(2)]);
var dx = (G__17856 - G__17859);
var dy = (G__17857 - G__17860);
var dz = (G__17858 - G__17861);
return (((dx * dx) + (dy * dy)) + (dz * dz));
} else {
var G__17859 = cljs.core.nth.call(null,v,(0),0.0);
var G__17860 = cljs.core.nth.call(null,v,(1),0.0);
var G__17861 = cljs.core.nth.call(null,v,(2),0.0);
var dx = (G__17856 - G__17859);
var dy = (G__17857 - G__17860);
var dz = (G__17858 - G__17861);
return (((dx * dx) + (dy * dy)) + (dz * dz));
}
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IRotate$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IRotate$rotate$arity$2 = (function (_,theta){
var self__ = this;
var ___$1 = this;
return thi.ng.geom.core.rotate_z.call(null,___$1,theta);
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$IStack$_peek$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.buf[(2)]);
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$IStack$_pop$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var b = (new Float32Array((2)));
(b[(0)] = (self__.buf[(0)]));

(b[(1)] = (self__.buf[(1)]));

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IInvert$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IInvert$invert$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return thi.ng.math.core._.call(null,___$1);
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return thi.ng.geom.vector.swizzle3_fns.call(null,new cljs.core.Keyword(null,"zyx","zyx",1752527951)).call(null,___$1);
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$ILimit$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$ILimit$limit$arity$2 = (function (_,len){
var self__ = this;
var ___$1 = this;
if((thi.ng.math.core.mag_squared.call(null,___$1) > (len * len))){
return thi.ng.math.core.normalize.call(null,___$1,len);
} else {
return ___$1;
}
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IScale$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IScale$scale$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var dest__15404__auto__ = (new Float32Array((3)));
var G__17862_18300 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__17863_18301 = v.buf;
(dest__15404__auto__[(0)] = ((G__17862_18300[(0)]) * (G__17863_18301[(0)])));

(dest__15404__auto__[(1)] = ((G__17862_18300[(1)]) * (G__17863_18301[(1)])));

(dest__15404__auto__[(2)] = ((G__17862_18300[(2)]) * (G__17863_18301[(2)])));
} else {
if(typeof v === 'number'){
(dest__15404__auto__[(0)] = ((G__17862_18300[(0)]) * v));

(dest__15404__auto__[(1)] = ((G__17862_18300[(1)]) * v));

(dest__15404__auto__[(2)] = ((G__17862_18300[(2)]) * v));
} else {
(dest__15404__auto__[(0)] = ((G__17862_18300[(0)]) * cljs.core.nth.call(null,v,(0),0.0)));

(dest__15404__auto__[(1)] = ((G__17862_18300[(1)]) * cljs.core.nth.call(null,v,(1),0.0)));

(dest__15404__auto__[(2)] = ((G__17862_18300[(2)]) * cljs.core.nth.call(null,v,(2),0.0)));
}
}

return (new thi.ng.geom.vector.Vec3(dest__15404__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$IHash$_hash$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var or__4131__auto__ = self__._hash;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return ___$1._hash = cljs.core.mix_collection_hash.call(null,((cljs.core.imul.call(null,((cljs.core.imul.call(null,(((31) + cljs.core.hash.call(null,(self__.buf[(0)]))) | (0)),(31)) + cljs.core.hash.call(null,(self__.buf[(1)]))) | (0)),(31)) + cljs.core.hash.call(null,(self__.buf[(2)]))) | (0)),(3));
}
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IDeltaEquals$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IDeltaEquals$delta_EQ_$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
return thi.ng.math.core.delta_EQ_.call(null,___$1,v,thi.ng.math.core._STAR_eps_STAR_);
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IDeltaEquals$delta_EQ_$arity$3 = (function (_,v,eps){
var self__ = this;
var ___$1 = this;
if(cljs.core.sequential_QMARK_.call(null,v)){
if(((3) === cljs.core.count.call(null,v))){
var G__17864 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__17865 = v.buf;
if(cljs.core.truth_(thi.ng.math.core.delta_EQ_.call(null,(G__17864[(0)]),(G__17865[(0)]),eps))){
if(cljs.core.truth_(thi.ng.math.core.delta_EQ_.call(null,(G__17864[(1)]),(G__17865[(1)]),eps))){
return thi.ng.math.core.delta_EQ_.call(null,(G__17864[(2)]),(G__17865[(2)]),eps);
} else {
return null;
}
} else {
return null;
}
} else {
if(cljs.core.truth_(thi.ng.math.core.delta_EQ_.call(null,(G__17864[(0)]),cljs.core.nth.call(null,v,(0),0.0),eps))){
if(cljs.core.truth_(thi.ng.math.core.delta_EQ_.call(null,(G__17864[(1)]),cljs.core.nth.call(null,v,(1),0.0),eps))){
return thi.ng.math.core.delta_EQ_.call(null,(G__17864[(2)]),cljs.core.nth.call(null,v,(2),0.0),eps);
} else {
return null;
}
} else {
return null;
}
}
} else {
return null;
}
} else {
return null;
}
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (_,o){
var self__ = this;
var ___$1 = this;
if((o instanceof thi.ng.geom.vector.Vec3)){
var b_SINGLEQUOTE_ = o.buf;
return ((((self__.buf[(0)]) === (b_SINGLEQUOTE_[(0)]))) && (((self__.buf[(1)]) === (b_SINGLEQUOTE_[(1)]))) && (((self__.buf[(2)]) === (b_SINGLEQUOTE_[(2)]))));
} else {
return ((cljs.core.sequential_QMARK_.call(null,o)) && (((3) === cljs.core.count.call(null,o))) && (cljs.core._EQ_.call(null,(self__.buf[(0)]),cljs.core.first.call(null,o))) && (cljs.core._EQ_.call(null,(self__.buf[(1)]),cljs.core.nth.call(null,o,(1)))) && (cljs.core._EQ_.call(null,(self__.buf[(2)]),cljs.core.nth.call(null,o,(2)))));
}
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IVectorReduce$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IVectorReduce$reduce_vector$arity$3 = (function (_,f,xs){
var self__ = this;
var ___$1 = this;
var buf_SINGLEQUOTE_ = (new Float32Array(self__.buf));
return (new thi.ng.geom.vector.Vec3(thi.ng.geom.vector.vec3_reduce_STAR_.call(null,f,buf_SINGLEQUOTE_,xs),null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IVectorReduce$reduce_vector$arity$4 = (function (_,f,f2,xs){
var self__ = this;
var ___$1 = this;
var buf_SINGLEQUOTE_ = (new Float32Array(self__.buf));
thi.ng.geom.vector.vec3_reduce_STAR_.call(null,f,buf_SINGLEQUOTE_,xs);

(buf_SINGLEQUOTE_[(0)] = f2.call(null,(buf_SINGLEQUOTE_[(0)]),(0)));

(buf_SINGLEQUOTE_[(1)] = f2.call(null,(buf_SINGLEQUOTE_[(1)]),(1)));

(buf_SINGLEQUOTE_[(2)] = f2.call(null,(buf_SINGLEQUOTE_[(2)]),(2)));

return (new thi.ng.geom.vector.Vec3(buf_SINGLEQUOTE_,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$dstruct$streams$IIntoBuffer$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$dstruct$streams$IIntoBuffer$into_float_buffer$arity$4 = (function (_,dest,stride,idx){
var self__ = this;
var ___$1 = this;
dest.set(self__.buf,idx);

return (idx + stride);
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IDotProduct$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IDotProduct$dot$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var G__17866 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__17867 = v.buf;
return ((((G__17866[(0)]) * (G__17867[(0)])) + ((G__17866[(1)]) * (G__17867[(1)]))) + ((G__17866[(2)]) * (G__17867[(2)])));
} else {
return ((((G__17866[(0)]) * cljs.core.nth.call(null,v,(0),0.0)) + ((G__17866[(1)]) * cljs.core.nth.call(null,v,(1),0.0))) + ((G__17866[(2)]) * cljs.core.nth.call(null,v,(2),0.0)));
}
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
var acc = f.call(null,(self__.buf[(0)]),(self__.buf[(1)]));
if(cljs.core.reduced_QMARK_.call(null,acc)){
return cljs.core.deref.call(null,acc);
} else {
var acc__$1 = f.call(null,acc,(self__.buf[(2)]));
if(cljs.core.reduced_QMARK_.call(null,acc__$1)){
return cljs.core.deref.call(null,acc__$1);
} else {
return acc__$1;
}
}
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
var acc = f.call(null,start,(self__.buf[(0)]));
if(cljs.core.reduced_QMARK_.call(null,acc)){
return cljs.core.deref.call(null,acc);
} else {
var acc__$1 = f.call(null,acc,(self__.buf[(1)]));
if(cljs.core.reduced_QMARK_.call(null,acc__$1)){
return cljs.core.deref.call(null,acc__$1);
} else {
var acc__$2 = f.call(null,acc__$1,(self__.buf[(2)]));
if(cljs.core.reduced_QMARK_.call(null,acc__$2)){
return cljs.core.deref.call(null,acc__$2);
} else {
return acc__$2;
}
}
}
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$ITranslate$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$ITranslate$translate$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var dest__15404__auto__ = (new Float32Array((3)));
var G__17868_18302 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__17869_18303 = v.buf;
(dest__15404__auto__[(0)] = ((G__17868_18302[(0)]) + (G__17869_18303[(0)])));

(dest__15404__auto__[(1)] = ((G__17868_18302[(1)]) + (G__17869_18303[(1)])));

(dest__15404__auto__[(2)] = ((G__17868_18302[(2)]) + (G__17869_18303[(2)])));
} else {
if(typeof v === 'number'){
(dest__15404__auto__[(0)] = ((G__17868_18302[(0)]) + v));

(dest__15404__auto__[(1)] = ((G__17868_18302[(1)]) + v));

(dest__15404__auto__[(2)] = ((G__17868_18302[(2)]) + v));
} else {
(dest__15404__auto__[(0)] = ((G__17868_18302[(0)]) + cljs.core.nth.call(null,v,(0),0.0)));

(dest__15404__auto__[(1)] = ((G__17868_18302[(1)]) + cljs.core.nth.call(null,v,(1),0.0)));

(dest__15404__auto__[(2)] = ((G__17868_18302[(2)]) + cljs.core.nth.call(null,v,(2),0.0)));
}
}

return (new thi.ng.geom.vector.Vec3(dest__15404__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$ISeq$_first$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.buf[(0)]);
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$ISeq$_rest$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.cons.call(null,(self__.buf[(1)]),cljs.core.cons.call(null,(self__.buf[(2)]),null));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IHeading$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IHeading$heading$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return thi.ng.geom.core.heading_xy.call(null,___$1);
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IHeading$heading_xy$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var t = Math.atan2((self__.buf[(1)]),(self__.buf[(0)]));
if((t < (0))){
return (t + thi.ng.math.core.TWO_PI);
} else {
return t;
}
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IHeading$heading_xz$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var t = Math.atan2((self__.buf[(2)]),(self__.buf[(0)]));
if((t < (0))){
return (t + thi.ng.math.core.TWO_PI);
} else {
return t;
}
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IHeading$heading_yz$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var t = Math.atan2((self__.buf[(2)]),(self__.buf[(1)]));
if((t < (0))){
return (t + thi.ng.math.core.TWO_PI);
} else {
return t;
}
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IHeading$angle_between$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var v__$1 = (((v instanceof thi.ng.geom.vector.Vec3))?v:thi.ng.geom.vector.vec3.call(null,v));
return Math.acos(thi.ng.math.core.dot.call(null,thi.ng.math.core.normalize.call(null,___$1),thi.ng.math.core.normalize.call(null,v__$1)));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IHeading$slope_xy$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return ((self__.buf[(1)]) / (self__.buf[(0)]));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IHeading$slope_xz$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return ((self__.buf[(2)]) / (self__.buf[(0)]));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IHeading$slope_yz$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return ((self__.buf[(2)]) / (self__.buf[(1)]));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IInterpolate$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IInterpolate$mix$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var b = (new Float32Array((3)));
var G__17870_18304 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__17871_18305 = v.buf;
(b[(0)] = (((G__17870_18304[(0)]) + (G__17871_18305[(0)])) * 0.5));

(b[(1)] = (((G__17870_18304[(1)]) + (G__17871_18305[(1)])) * 0.5));

(b[(2)] = (((G__17870_18304[(2)]) + (G__17871_18305[(2)])) * 0.5));
} else {
if(typeof v === 'number'){
(b[(0)] = (((G__17870_18304[(0)]) + v) * 0.5));

(b[(1)] = (((G__17870_18304[(1)]) + v) * 0.5));

(b[(2)] = (((G__17870_18304[(2)]) + v) * 0.5));
} else {
(b[(0)] = (((G__17870_18304[(0)]) + cljs.core.nth.call(null,v,(0),0.0)) * 0.5));

(b[(1)] = (((G__17870_18304[(1)]) + cljs.core.nth.call(null,v,(1),0.0)) * 0.5));

(b[(2)] = (((G__17870_18304[(2)]) + cljs.core.nth.call(null,v,(2),0.0)) * 0.5));
}
}

return (new thi.ng.geom.vector.Vec3(b,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IInterpolate$mix$arity$3 = (function (_,v,t){
var self__ = this;
var ___$1 = this;
var b = (new Float32Array((3)));
var G__17884_18306 = (v instanceof thi.ng.geom.vector.Vec3);
var G__17885_18307 = (t instanceof thi.ng.geom.vector.Vec3);
var G__17886_18308 = (((!(G__17884_18306)))?typeof v === 'number':null);
var G__17887_18309 = (((!(G__17885_18307)))?typeof t === 'number':null);
var G__17872_18310 = self__.buf;
var G__17873_18311 = ((G__17884_18306)?v.buf:null);
var G__17874_18312 = ((G__17885_18307)?t.buf:null);
var G__17875_18313 = (G__17872_18310[(0)]);
var G__17876_18314 = (G__17872_18310[(1)]);
var G__17877_18315 = (G__17872_18310[(2)]);
var G__17878_18316 = ((G__17884_18306)?(G__17873_18311[(0)]):(cljs.core.truth_(G__17886_18308)?v:cljs.core.nth.call(null,v,(0),0.0)));
var G__17879_18317 = ((G__17884_18306)?(G__17873_18311[(1)]):(cljs.core.truth_(G__17886_18308)?v:cljs.core.nth.call(null,v,(1),0.0)));
var G__17880_18318 = ((G__17884_18306)?(G__17873_18311[(2)]):(cljs.core.truth_(G__17886_18308)?v:cljs.core.nth.call(null,v,(2),0.0)));
var G__17881_18319 = ((G__17885_18307)?(G__17874_18312[(0)]):(cljs.core.truth_(G__17887_18309)?t:cljs.core.nth.call(null,t,(0),0.0)));
var G__17882_18320 = ((G__17885_18307)?(G__17874_18312[(1)]):(cljs.core.truth_(G__17887_18309)?t:cljs.core.nth.call(null,t,(1),0.0)));
var G__17883_18321 = ((G__17885_18307)?(G__17874_18312[(2)]):(cljs.core.truth_(G__17887_18309)?t:cljs.core.nth.call(null,t,(2),0.0)));
(b[(0)] = (((G__17878_18316 - G__17875_18313) * G__17881_18319) + G__17875_18313));

(b[(1)] = (((G__17879_18317 - G__17876_18314) * G__17882_18320) + G__17876_18314));

(b[(2)] = (((G__17880_18318 - G__17877_18315) * G__17883_18321) + G__17877_18315));

return (new thi.ng.geom.vector.Vec3(b,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IInterpolate$mix$arity$6 = (function (_,b,c,d,u,v){
var self__ = this;
var ___$1 = this;
var b_SINGLEQUOTE_ = (new Float32Array((3)));
var dv_QMARK_ = (d instanceof thi.ng.geom.vector.Vec3);
var dn_QMARK_ = typeof d === 'number';
var dv = ((dv_QMARK_)?d.buf:null);
var dx = ((dv_QMARK_)?(dv[(0)]):((dn_QMARK_)?d:cljs.core.nth.call(null,d,(0),0.0)));
var dy = ((dv_QMARK_)?(dv[(1)]):((dn_QMARK_)?d:cljs.core.nth.call(null,d,(1),0.0)));
var dz = ((dv_QMARK_)?(dv[(2)]):((dn_QMARK_)?d:cljs.core.nth.call(null,d,(2),0.0)));
var G__17900_18322 = (b instanceof thi.ng.geom.vector.Vec3);
var G__17901_18323 = (c instanceof thi.ng.geom.vector.Vec3);
var G__17902_18324 = (((!(G__17900_18322)))?typeof b === 'number':null);
var G__17903_18325 = (((!(G__17901_18323)))?typeof c === 'number':null);
var G__17888_18326 = self__.buf;
var G__17889_18327 = ((G__17900_18322)?b.buf:null);
var G__17890_18328 = ((G__17901_18323)?c.buf:null);
var G__17891_18329 = (G__17888_18326[(0)]);
var G__17892_18330 = (G__17888_18326[(1)]);
var G__17893_18331 = (G__17888_18326[(2)]);
var G__17894_18332 = ((G__17900_18322)?(G__17889_18327[(0)]):(cljs.core.truth_(G__17902_18324)?b:cljs.core.nth.call(null,b,(0),0.0)));
var G__17895_18333 = ((G__17900_18322)?(G__17889_18327[(1)]):(cljs.core.truth_(G__17902_18324)?b:cljs.core.nth.call(null,b,(1),0.0)));
var G__17896_18334 = ((G__17900_18322)?(G__17889_18327[(2)]):(cljs.core.truth_(G__17902_18324)?b:cljs.core.nth.call(null,b,(2),0.0)));
var G__17897_18335 = ((G__17901_18323)?(G__17890_18328[(0)]):(cljs.core.truth_(G__17903_18325)?c:cljs.core.nth.call(null,c,(0),0.0)));
var G__17898_18336 = ((G__17901_18323)?(G__17890_18328[(1)]):(cljs.core.truth_(G__17903_18325)?c:cljs.core.nth.call(null,c,(1),0.0)));
var G__17899_18337 = ((G__17901_18323)?(G__17890_18328[(2)]):(cljs.core.truth_(G__17903_18325)?c:cljs.core.nth.call(null,c,(2),0.0)));
var x1_18338 = (((G__17894_18332 - G__17891_18329) * u) + G__17891_18329);
var y1_18339 = (((G__17895_18333 - G__17892_18330) * u) + G__17892_18330);
var z1_18340 = (((G__17896_18334 - G__17893_18331) * u) + G__17893_18331);
(b_SINGLEQUOTE_[(0)] = ((((((dx - G__17897_18335) * u) + G__17897_18335) - x1_18338) * v) + x1_18338));

(b_SINGLEQUOTE_[(1)] = ((((((dy - G__17898_18336) * u) + G__17898_18336) - y1_18339) * v) + y1_18339));

(b_SINGLEQUOTE_[(2)] = ((((((dz - G__17899_18337) * u) + G__17899_18337) - z1_18340) * v) + z1_18340));

return (new thi.ng.geom.vector.Vec3(b_SINGLEQUOTE_,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IInterpolate$mix_with$arity$4 = (function (_,v,t,f){
var self__ = this;
var ___$1 = this;
var b = (new Float32Array((3)));
var G__17916_18341 = (v instanceof thi.ng.geom.vector.Vec3);
var G__17917_18342 = (t instanceof thi.ng.geom.vector.Vec3);
var G__17918_18343 = (((!(G__17916_18341)))?typeof v === 'number':null);
var G__17919_18344 = (((!(G__17917_18342)))?typeof t === 'number':null);
var G__17904_18345 = self__.buf;
var G__17905_18346 = ((G__17916_18341)?v.buf:null);
var G__17906_18347 = ((G__17917_18342)?t.buf:null);
var G__17907_18348 = (G__17904_18345[(0)]);
var G__17908_18349 = (G__17904_18345[(1)]);
var G__17909_18350 = (G__17904_18345[(2)]);
var G__17910_18351 = ((G__17916_18341)?(G__17905_18346[(0)]):(cljs.core.truth_(G__17918_18343)?v:cljs.core.nth.call(null,v,(0),0.0)));
var G__17911_18352 = ((G__17916_18341)?(G__17905_18346[(1)]):(cljs.core.truth_(G__17918_18343)?v:cljs.core.nth.call(null,v,(1),0.0)));
var G__17912_18353 = ((G__17916_18341)?(G__17905_18346[(2)]):(cljs.core.truth_(G__17918_18343)?v:cljs.core.nth.call(null,v,(2),0.0)));
var G__17913_18354 = ((G__17917_18342)?(G__17906_18347[(0)]):(cljs.core.truth_(G__17919_18344)?t:cljs.core.nth.call(null,t,(0),0.0)));
var G__17914_18355 = ((G__17917_18342)?(G__17906_18347[(1)]):(cljs.core.truth_(G__17919_18344)?t:cljs.core.nth.call(null,t,(1),0.0)));
var G__17915_18356 = ((G__17917_18342)?(G__17906_18347[(2)]):(cljs.core.truth_(G__17919_18344)?t:cljs.core.nth.call(null,t,(2),0.0)));
(b[(0)] = f.call(null,G__17907_18348,G__17910_18351,G__17913_18354));

(b[(1)] = f.call(null,G__17908_18349,G__17911_18352,G__17914_18355));

(b[(2)] = f.call(null,G__17909_18350,G__17912_18353,G__17915_18356));

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IInterpolate$step$arity$2 = (function (_,e){
var self__ = this;
var ___$1 = this;
var b = (new Float32Array((3)));
var G__17920_18357 = self__.buf;
if((e instanceof thi.ng.geom.vector.Vec3)){
var G__17921_18358 = e.buf;
(b[(0)] = thi.ng.math.core.step_STAR_.call(null,(G__17921_18358[(0)]),(G__17920_18357[(0)])));

(b[(1)] = thi.ng.math.core.step_STAR_.call(null,(G__17921_18358[(1)]),(G__17920_18357[(1)])));

(b[(2)] = thi.ng.math.core.step_STAR_.call(null,(G__17921_18358[(2)]),(G__17920_18357[(2)])));
} else {
if(typeof e === 'number'){
(b[(0)] = thi.ng.math.core.step_STAR_.call(null,e,(G__17920_18357[(0)])));

(b[(1)] = thi.ng.math.core.step_STAR_.call(null,e,(G__17920_18357[(1)])));

(b[(2)] = thi.ng.math.core.step_STAR_.call(null,e,(G__17920_18357[(2)])));
} else {
(b[(0)] = thi.ng.math.core.step_STAR_.call(null,cljs.core.nth.call(null,e,(0),0.0),(G__17920_18357[(0)])));

(b[(1)] = thi.ng.math.core.step_STAR_.call(null,cljs.core.nth.call(null,e,(1),0.0),(G__17920_18357[(1)])));

(b[(2)] = thi.ng.math.core.step_STAR_.call(null,cljs.core.nth.call(null,e,(2),0.0),(G__17920_18357[(2)])));
}
}

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IInterpolate$smoothstep$arity$3 = (function (_,e1,e2){
var self__ = this;
var ___$1 = this;
var b = (new Float32Array((3)));
var G__17934_18359 = (e1 instanceof thi.ng.geom.vector.Vec3);
var G__17935_18360 = (e2 instanceof thi.ng.geom.vector.Vec3);
var G__17936_18361 = (((!(G__17934_18359)))?typeof e1 === 'number':null);
var G__17937_18362 = (((!(G__17935_18360)))?typeof e2 === 'number':null);
var G__17922_18363 = self__.buf;
var G__17923_18364 = ((G__17934_18359)?e1.buf:null);
var G__17924_18365 = ((G__17935_18360)?e2.buf:null);
var G__17925_18366 = (G__17922_18363[(0)]);
var G__17926_18367 = (G__17922_18363[(1)]);
var G__17927_18368 = (G__17922_18363[(2)]);
var G__17928_18369 = ((G__17934_18359)?(G__17923_18364[(0)]):(cljs.core.truth_(G__17936_18361)?e1:cljs.core.nth.call(null,e1,(0),0.0)));
var G__17929_18370 = ((G__17934_18359)?(G__17923_18364[(1)]):(cljs.core.truth_(G__17936_18361)?e1:cljs.core.nth.call(null,e1,(1),0.0)));
var G__17930_18371 = ((G__17934_18359)?(G__17923_18364[(2)]):(cljs.core.truth_(G__17936_18361)?e1:cljs.core.nth.call(null,e1,(2),0.0)));
var G__17931_18372 = ((G__17935_18360)?(G__17924_18365[(0)]):(cljs.core.truth_(G__17937_18362)?e2:cljs.core.nth.call(null,e2,(0),0.0)));
var G__17932_18373 = ((G__17935_18360)?(G__17924_18365[(1)]):(cljs.core.truth_(G__17937_18362)?e2:cljs.core.nth.call(null,e2,(1),0.0)));
var G__17933_18374 = ((G__17935_18360)?(G__17924_18365[(2)]):(cljs.core.truth_(G__17937_18362)?e2:cljs.core.nth.call(null,e2,(2),0.0)));
(b[(0)] = thi.ng.math.core.smoothstep_STAR_.call(null,G__17928_18369,G__17931_18372,G__17925_18366));

(b[(1)] = thi.ng.math.core.smoothstep_STAR_.call(null,G__17929_18370,G__17932_18373,G__17926_18367));

(b[(2)] = thi.ng.math.core.smoothstep_STAR_.call(null,G__17930_18371,G__17933_18374,G__17927_18368));

return (new thi.ng.geom.vector.Vec2(b,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
if(typeof k === 'number'){
return (((k >= (0))) && ((k <= (2))));
} else {
if(cljs.core.truth_(thi.ng.geom.vector.swizzle3_fns.call(null,k))){
return true;
} else {
return false;
}
}
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (_,k,v){
var self__ = this;
var ___$1 = this;
if(typeof k === 'number'){
if((((k >= (0))) && ((k <= (2))))){
var b = (new Float32Array(self__.buf));
(b[k] = v);

return (new thi.ng.geom.vector.Vec3(b,null,self__._meta));
} else {
if((k === (3))){
return cljs.core.conj.call(null,___$1,v);
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,k);
}
}
} else {
if((k instanceof cljs.core.Keyword)){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"w","w",354169001),k)){
return cljs.core.conj.call(null,___$1,v);
} else {
return (new thi.ng.geom.vector.Vec3(thi.ng.geom.vector.swizzle_assoc_STAR_.call(null,self__.buf,(new Float32Array(self__.buf)),new cljs.core.PersistentArrayMap(null, 3, ["x",(0),"y",(1),"z",(2)], null),k,v),null,self__._meta));
}
} else {
return null;
}
}
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMinMax$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMinMax$min$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var dest__15404__auto__ = (new Float32Array((3)));
var G__17938_18375 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__17939_18376 = v.buf;
(dest__15404__auto__[(0)] = (function (){var a__14807__auto__ = (G__17938_18375[(0)]);
var b__14808__auto__ = (G__17939_18376[(0)]);
if((a__14807__auto__ <= b__14808__auto__)){
return a__14807__auto__;
} else {
return b__14808__auto__;
}
})());

(dest__15404__auto__[(1)] = (function (){var a__14807__auto__ = (G__17938_18375[(1)]);
var b__14808__auto__ = (G__17939_18376[(1)]);
if((a__14807__auto__ <= b__14808__auto__)){
return a__14807__auto__;
} else {
return b__14808__auto__;
}
})());

(dest__15404__auto__[(2)] = (function (){var a__14807__auto__ = (G__17938_18375[(2)]);
var b__14808__auto__ = (G__17939_18376[(2)]);
if((a__14807__auto__ <= b__14808__auto__)){
return a__14807__auto__;
} else {
return b__14808__auto__;
}
})());
} else {
if(typeof v === 'number'){
(dest__15404__auto__[(0)] = (function (){var a__14807__auto__ = (G__17938_18375[(0)]);
var b__14808__auto__ = v;
if((a__14807__auto__ <= b__14808__auto__)){
return a__14807__auto__;
} else {
return b__14808__auto__;
}
})());

(dest__15404__auto__[(1)] = (function (){var a__14807__auto__ = (G__17938_18375[(1)]);
var b__14808__auto__ = v;
if((a__14807__auto__ <= b__14808__auto__)){
return a__14807__auto__;
} else {
return b__14808__auto__;
}
})());

(dest__15404__auto__[(2)] = (function (){var a__14807__auto__ = (G__17938_18375[(2)]);
var b__14808__auto__ = v;
if((a__14807__auto__ <= b__14808__auto__)){
return a__14807__auto__;
} else {
return b__14808__auto__;
}
})());
} else {
(dest__15404__auto__[(0)] = (function (){var a__14807__auto__ = (G__17938_18375[(0)]);
var b__14808__auto__ = cljs.core.nth.call(null,v,(0),0.0);
if((a__14807__auto__ <= b__14808__auto__)){
return a__14807__auto__;
} else {
return b__14808__auto__;
}
})());

(dest__15404__auto__[(1)] = (function (){var a__14807__auto__ = (G__17938_18375[(1)]);
var b__14808__auto__ = cljs.core.nth.call(null,v,(1),0.0);
if((a__14807__auto__ <= b__14808__auto__)){
return a__14807__auto__;
} else {
return b__14808__auto__;
}
})());

(dest__15404__auto__[(2)] = (function (){var a__14807__auto__ = (G__17938_18375[(2)]);
var b__14808__auto__ = cljs.core.nth.call(null,v,(2),0.0);
if((a__14807__auto__ <= b__14808__auto__)){
return a__14807__auto__;
} else {
return b__14808__auto__;
}
})());
}
}

return (new thi.ng.geom.vector.Vec3(dest__15404__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMinMax$min$arity$3 = (function (_,v,v2){
var self__ = this;
var ___$1 = this;
var dest__15415__auto__ = (new Float32Array((3)));
var G__17952_18377 = (v instanceof thi.ng.geom.vector.Vec3);
var G__17953_18378 = (v2 instanceof thi.ng.geom.vector.Vec3);
var G__17954_18379 = (((!(G__17952_18377)))?typeof v === 'number':null);
var G__17955_18380 = (((!(G__17953_18378)))?typeof v2 === 'number':null);
var G__17940_18381 = self__.buf;
var G__17941_18382 = ((G__17952_18377)?v.buf:null);
var G__17942_18383 = ((G__17953_18378)?v2.buf:null);
var G__17943_18384 = (G__17940_18381[(0)]);
var G__17944_18385 = (G__17940_18381[(1)]);
var G__17945_18386 = (G__17940_18381[(2)]);
var G__17946_18387 = ((G__17952_18377)?(G__17941_18382[(0)]):(cljs.core.truth_(G__17954_18379)?v:cljs.core.nth.call(null,v,(0),0.0)));
var G__17947_18388 = ((G__17952_18377)?(G__17941_18382[(1)]):(cljs.core.truth_(G__17954_18379)?v:cljs.core.nth.call(null,v,(1),0.0)));
var G__17948_18389 = ((G__17952_18377)?(G__17941_18382[(2)]):(cljs.core.truth_(G__17954_18379)?v:cljs.core.nth.call(null,v,(2),0.0)));
var G__17949_18390 = ((G__17953_18378)?(G__17942_18383[(0)]):(cljs.core.truth_(G__17955_18380)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__17950_18391 = ((G__17953_18378)?(G__17942_18383[(1)]):(cljs.core.truth_(G__17955_18380)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
var G__17951_18392 = ((G__17953_18378)?(G__17942_18383[(2)]):(cljs.core.truth_(G__17955_18380)?v2:cljs.core.nth.call(null,v2,(2),0.0)));
(dest__15415__auto__[(0)] = (function (){var a__14807__auto__ = (function (){var a__14807__auto__ = G__17943_18384;
var b__14808__auto__ = G__17946_18387;
if((a__14807__auto__ <= b__14808__auto__)){
return a__14807__auto__;
} else {
return b__14808__auto__;
}
})();
var b__14808__auto__ = G__17949_18390;
if((a__14807__auto__ <= b__14808__auto__)){
return a__14807__auto__;
} else {
return b__14808__auto__;
}
})());

(dest__15415__auto__[(1)] = (function (){var a__14807__auto__ = (function (){var a__14807__auto__ = G__17944_18385;
var b__14808__auto__ = G__17947_18388;
if((a__14807__auto__ <= b__14808__auto__)){
return a__14807__auto__;
} else {
return b__14808__auto__;
}
})();
var b__14808__auto__ = G__17950_18391;
if((a__14807__auto__ <= b__14808__auto__)){
return a__14807__auto__;
} else {
return b__14808__auto__;
}
})());

(dest__15415__auto__[(2)] = (function (){var a__14807__auto__ = (function (){var a__14807__auto__ = G__17945_18386;
var b__14808__auto__ = G__17948_18389;
if((a__14807__auto__ <= b__14808__auto__)){
return a__14807__auto__;
} else {
return b__14808__auto__;
}
})();
var b__14808__auto__ = G__17951_18392;
if((a__14807__auto__ <= b__14808__auto__)){
return a__14807__auto__;
} else {
return b__14808__auto__;
}
})());

return (new thi.ng.geom.vector.Vec3(dest__15415__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMinMax$max$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var dest__15404__auto__ = (new Float32Array((3)));
var G__17956_18393 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__17957_18394 = v.buf;
(dest__15404__auto__[(0)] = (function (){var a__14814__auto__ = (G__17956_18393[(0)]);
var b__14815__auto__ = (G__17957_18394[(0)]);
if((a__14814__auto__ >= b__14815__auto__)){
return a__14814__auto__;
} else {
return b__14815__auto__;
}
})());

(dest__15404__auto__[(1)] = (function (){var a__14814__auto__ = (G__17956_18393[(1)]);
var b__14815__auto__ = (G__17957_18394[(1)]);
if((a__14814__auto__ >= b__14815__auto__)){
return a__14814__auto__;
} else {
return b__14815__auto__;
}
})());

(dest__15404__auto__[(2)] = (function (){var a__14814__auto__ = (G__17956_18393[(2)]);
var b__14815__auto__ = (G__17957_18394[(2)]);
if((a__14814__auto__ >= b__14815__auto__)){
return a__14814__auto__;
} else {
return b__14815__auto__;
}
})());
} else {
if(typeof v === 'number'){
(dest__15404__auto__[(0)] = (function (){var a__14814__auto__ = (G__17956_18393[(0)]);
var b__14815__auto__ = v;
if((a__14814__auto__ >= b__14815__auto__)){
return a__14814__auto__;
} else {
return b__14815__auto__;
}
})());

(dest__15404__auto__[(1)] = (function (){var a__14814__auto__ = (G__17956_18393[(1)]);
var b__14815__auto__ = v;
if((a__14814__auto__ >= b__14815__auto__)){
return a__14814__auto__;
} else {
return b__14815__auto__;
}
})());

(dest__15404__auto__[(2)] = (function (){var a__14814__auto__ = (G__17956_18393[(2)]);
var b__14815__auto__ = v;
if((a__14814__auto__ >= b__14815__auto__)){
return a__14814__auto__;
} else {
return b__14815__auto__;
}
})());
} else {
(dest__15404__auto__[(0)] = (function (){var a__14814__auto__ = (G__17956_18393[(0)]);
var b__14815__auto__ = cljs.core.nth.call(null,v,(0),0.0);
if((a__14814__auto__ >= b__14815__auto__)){
return a__14814__auto__;
} else {
return b__14815__auto__;
}
})());

(dest__15404__auto__[(1)] = (function (){var a__14814__auto__ = (G__17956_18393[(1)]);
var b__14815__auto__ = cljs.core.nth.call(null,v,(1),0.0);
if((a__14814__auto__ >= b__14815__auto__)){
return a__14814__auto__;
} else {
return b__14815__auto__;
}
})());

(dest__15404__auto__[(2)] = (function (){var a__14814__auto__ = (G__17956_18393[(2)]);
var b__14815__auto__ = cljs.core.nth.call(null,v,(2),0.0);
if((a__14814__auto__ >= b__14815__auto__)){
return a__14814__auto__;
} else {
return b__14815__auto__;
}
})());
}
}

return (new thi.ng.geom.vector.Vec3(dest__15404__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMinMax$max$arity$3 = (function (_,v,v2){
var self__ = this;
var ___$1 = this;
var dest__15415__auto__ = (new Float32Array((3)));
var G__17970_18395 = (v instanceof thi.ng.geom.vector.Vec3);
var G__17971_18396 = (v2 instanceof thi.ng.geom.vector.Vec3);
var G__17972_18397 = (((!(G__17970_18395)))?typeof v === 'number':null);
var G__17973_18398 = (((!(G__17971_18396)))?typeof v2 === 'number':null);
var G__17958_18399 = self__.buf;
var G__17959_18400 = ((G__17970_18395)?v.buf:null);
var G__17960_18401 = ((G__17971_18396)?v2.buf:null);
var G__17961_18402 = (G__17958_18399[(0)]);
var G__17962_18403 = (G__17958_18399[(1)]);
var G__17963_18404 = (G__17958_18399[(2)]);
var G__17964_18405 = ((G__17970_18395)?(G__17959_18400[(0)]):(cljs.core.truth_(G__17972_18397)?v:cljs.core.nth.call(null,v,(0),0.0)));
var G__17965_18406 = ((G__17970_18395)?(G__17959_18400[(1)]):(cljs.core.truth_(G__17972_18397)?v:cljs.core.nth.call(null,v,(1),0.0)));
var G__17966_18407 = ((G__17970_18395)?(G__17959_18400[(2)]):(cljs.core.truth_(G__17972_18397)?v:cljs.core.nth.call(null,v,(2),0.0)));
var G__17967_18408 = ((G__17971_18396)?(G__17960_18401[(0)]):(cljs.core.truth_(G__17973_18398)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__17968_18409 = ((G__17971_18396)?(G__17960_18401[(1)]):(cljs.core.truth_(G__17973_18398)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
var G__17969_18410 = ((G__17971_18396)?(G__17960_18401[(2)]):(cljs.core.truth_(G__17973_18398)?v2:cljs.core.nth.call(null,v2,(2),0.0)));
(dest__15415__auto__[(0)] = (function (){var a__14814__auto__ = (function (){var a__14814__auto__ = G__17961_18402;
var b__14815__auto__ = G__17964_18405;
if((a__14814__auto__ >= b__14815__auto__)){
return a__14814__auto__;
} else {
return b__14815__auto__;
}
})();
var b__14815__auto__ = G__17967_18408;
if((a__14814__auto__ >= b__14815__auto__)){
return a__14814__auto__;
} else {
return b__14815__auto__;
}
})());

(dest__15415__auto__[(1)] = (function (){var a__14814__auto__ = (function (){var a__14814__auto__ = G__17962_18403;
var b__14815__auto__ = G__17965_18406;
if((a__14814__auto__ >= b__14815__auto__)){
return a__14814__auto__;
} else {
return b__14815__auto__;
}
})();
var b__14815__auto__ = G__17968_18409;
if((a__14814__auto__ >= b__14815__auto__)){
return a__14814__auto__;
} else {
return b__14815__auto__;
}
})());

(dest__15415__auto__[(2)] = (function (){var a__14814__auto__ = (function (){var a__14814__auto__ = G__17963_18404;
var b__14815__auto__ = G__17966_18407;
if((a__14814__auto__ >= b__14815__auto__)){
return a__14814__auto__;
} else {
return b__14815__auto__;
}
})();
var b__14815__auto__ = G__17969_18410;
if((a__14814__auto__ >= b__14815__auto__)){
return a__14814__auto__;
} else {
return b__14815__auto__;
}
})());

return (new thi.ng.geom.vector.Vec3(dest__15415__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IRotate3D$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IRotate3D$rotate_x$arity$2 = (function (_,theta){
var self__ = this;
var ___$1 = this;
var s = Math.sin(theta);
var c = Math.cos(theta);
var b = (new Float32Array((3)));
var G__17974 = self__.buf;
var G__17975 = (G__17974[(0)]);
var G__17976 = (G__17974[(1)]);
var G__17977 = (G__17974[(2)]);
(b[(0)] = G__17975);

(b[(1)] = ((G__17976 * c) - (G__17977 * s)));

(b[(2)] = ((G__17976 * s) + (G__17977 * c)));

return (new thi.ng.geom.vector.Vec3(b,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IRotate3D$rotate_y$arity$2 = (function (_,theta){
var self__ = this;
var ___$1 = this;
var s = Math.sin(theta);
var c = Math.cos(theta);
var b = (new Float32Array((3)));
var G__17978 = self__.buf;
var G__17979 = (G__17978[(0)]);
var G__17980 = (G__17978[(1)]);
var G__17981 = (G__17978[(2)]);
(b[(0)] = ((G__17979 * c) + (G__17981 * s)));

(b[(1)] = G__17980);

(b[(2)] = ((G__17981 * c) - (G__17979 * s)));

return (new thi.ng.geom.vector.Vec3(b,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IRotate3D$rotate_z$arity$2 = (function (_,theta){
var self__ = this;
var ___$1 = this;
var s = Math.sin(theta);
var c = Math.cos(theta);
var b = (new Float32Array((3)));
var G__17982 = self__.buf;
var G__17983 = (G__17982[(0)]);
var G__17984 = (G__17982[(1)]);
var G__17985 = (G__17982[(2)]);
(b[(0)] = ((G__17983 * c) - (G__17984 * s)));

(b[(1)] = ((G__17983 * s) + (G__17984 * c)));

(b[(2)] = G__17985);

return (new thi.ng.geom.vector.Vec3(b,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IRotate3D$rotate_around_axis$arity$3 = (function (_,v,theta){
var self__ = this;
var ___$1 = this;
var G__17986 = self__.buf;
var G__17988 = (G__17986[(0)]);
var G__17989 = (G__17986[(1)]);
var G__17990 = (G__17986[(2)]);
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__17987 = v.buf;
var G__17991 = (G__17987[(0)]);
var G__17992 = (G__17987[(1)]);
var G__17993 = (G__17987[(2)]);
var ux_SINGLEQUOTE_ = (G__17991 * G__17988);
var uy_SINGLEQUOTE_ = (G__17991 * G__17989);
var uz_SINGLEQUOTE_ = (G__17991 * G__17990);
var vx_SINGLEQUOTE_ = (G__17992 * G__17988);
var vy_SINGLEQUOTE_ = (G__17992 * G__17989);
var vz_SINGLEQUOTE_ = (G__17992 * G__17990);
var wx_SINGLEQUOTE_ = (G__17993 * G__17988);
var wy_SINGLEQUOTE_ = (G__17993 * G__17989);
var wz_SINGLEQUOTE_ = (G__17993 * G__17990);
var vx2 = (G__17991 * G__17991);
var vy2 = (G__17992 * G__17992);
var vz2 = (G__17993 * G__17993);
var s = Math.sin(theta);
var c = Math.cos(theta);
var uvw = ((ux_SINGLEQUOTE_ + vy_SINGLEQUOTE_) + wz_SINGLEQUOTE_);
var b = (new Float32Array((3)));
(b[(0)] = (((uvw * G__17991) + ((((vy2 + vz2) * G__17988) - ((vy_SINGLEQUOTE_ + wz_SINGLEQUOTE_) * G__17991)) * c)) + ((vz_SINGLEQUOTE_ - wy_SINGLEQUOTE_) * s)));

(b[(1)] = (((uvw * G__17992) + ((((vx2 + vz2) * G__17989) - ((ux_SINGLEQUOTE_ + wz_SINGLEQUOTE_) * G__17992)) * c)) + ((wx_SINGLEQUOTE_ - uz_SINGLEQUOTE_) * s)));

(b[(2)] = (((uvw * G__17993) + ((((vx2 + vy2) * G__17990) - ((ux_SINGLEQUOTE_ + vy_SINGLEQUOTE_) * G__17993)) * c)) + ((uy_SINGLEQUOTE_ - vx_SINGLEQUOTE_) * s)));

return (new thi.ng.geom.vector.Vec3(b,null,self__._meta));
} else {
var G__17991 = cljs.core.nth.call(null,v,(0),0.0);
var G__17992 = cljs.core.nth.call(null,v,(1),0.0);
var G__17993 = cljs.core.nth.call(null,v,(2),0.0);
var ux_SINGLEQUOTE_ = (G__17991 * G__17988);
var uy_SINGLEQUOTE_ = (G__17991 * G__17989);
var uz_SINGLEQUOTE_ = (G__17991 * G__17990);
var vx_SINGLEQUOTE_ = (G__17992 * G__17988);
var vy_SINGLEQUOTE_ = (G__17992 * G__17989);
var vz_SINGLEQUOTE_ = (G__17992 * G__17990);
var wx_SINGLEQUOTE_ = (G__17993 * G__17988);
var wy_SINGLEQUOTE_ = (G__17993 * G__17989);
var wz_SINGLEQUOTE_ = (G__17993 * G__17990);
var vx2 = (G__17991 * G__17991);
var vy2 = (G__17992 * G__17992);
var vz2 = (G__17993 * G__17993);
var s = Math.sin(theta);
var c = Math.cos(theta);
var uvw = ((ux_SINGLEQUOTE_ + vy_SINGLEQUOTE_) + wz_SINGLEQUOTE_);
var b = (new Float32Array((3)));
(b[(0)] = (((uvw * G__17991) + ((((vy2 + vz2) * G__17988) - ((vy_SINGLEQUOTE_ + wz_SINGLEQUOTE_) * G__17991)) * c)) + ((vz_SINGLEQUOTE_ - wy_SINGLEQUOTE_) * s)));

(b[(1)] = (((uvw * G__17992) + ((((vx2 + vz2) * G__17989) - ((ux_SINGLEQUOTE_ + wz_SINGLEQUOTE_) * G__17992)) * c)) + ((wx_SINGLEQUOTE_ - uz_SINGLEQUOTE_) * s)));

(b[(2)] = (((uvw * G__17993) + ((((vx2 + vy2) * G__17990) - ((ux_SINGLEQUOTE_ + vy_SINGLEQUOTE_) * G__17993)) * c)) + ((uy_SINGLEQUOTE_ - vx_SINGLEQUOTE_) * s)));

return (new thi.ng.geom.vector.Vec3(b,null,self__._meta));
}
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,m){
var self__ = this;
var ___$1 = this;
return (new thi.ng.geom.vector.Vec3((new Float32Array(self__.buf)),self__._hash,m));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IClear$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IClear$clear_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new thi.ng.geom.vector.Vec3((new Float32Array((3))),null,null));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IClear$clear_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
(self__.buf[(0)] = 0.0);

(self__.buf[(1)] = 0.0);

(self__.buf[(2)] = 0.0);

self__._hash = null;

return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$ICollection$_conj$arity$2 = (function (_,x){
var self__ = this;
var ___$1 = this;
return cljs.core.with_meta.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.buf[(0)]),(self__.buf[(1)]),(self__.buf[(2)]),x], null),self__._meta);
});

thi.ng.geom.vector.Vec3.prototype.call = (function() {
var G__18411 = null;
var G__18411__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
if((k instanceof cljs.core.Keyword)){
var temp__5802__auto__ = thi.ng.geom.vector.swizzle3_fns.call(null,k);
if(cljs.core.truth_(temp__5802__auto__)){
var f = temp__5802__auto__;
return f.call(null,_);
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,k);
}
} else {
if((((k >= (0))) && ((k <= (2))))){
return (self__.buf[k]);
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,k);
}
}
});
var G__18411__3 = (function (self__,k,nf){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
if((k instanceof cljs.core.Keyword)){
var temp__5802__auto__ = thi.ng.geom.vector.swizzle3_fns.call(null,k);
if(cljs.core.truth_(temp__5802__auto__)){
var f = temp__5802__auto__;
return f.call(null,_);
} else {
return nf;
}
} else {
if((((k >= (0))) && ((k <= (2))))){
return (self__.buf[k]);
} else {
return nf;
}
}
});
G__18411 = function(self__,k,nf){
switch(arguments.length){
case 2:
return G__18411__2.call(this,self__,k);
case 3:
return G__18411__3.call(this,self__,k,nf);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__18411.cljs$core$IFn$_invoke$arity$2 = G__18411__2;
G__18411.cljs$core$IFn$_invoke$arity$3 = G__18411__3;
return G__18411;
})()
;

thi.ng.geom.vector.Vec3.prototype.apply = (function (self__,args17701){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone.call(null,args17701)));
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var _ = this;
if((k instanceof cljs.core.Keyword)){
var temp__5802__auto__ = thi.ng.geom.vector.swizzle3_fns.call(null,k);
if(cljs.core.truth_(temp__5802__auto__)){
var f = temp__5802__auto__;
return f.call(null,_);
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,k);
}
} else {
if((((k >= (0))) && ((k <= (2))))){
return (self__.buf[k]);
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,k);
}
}
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,nf){
var self__ = this;
var _ = this;
if((k instanceof cljs.core.Keyword)){
var temp__5802__auto__ = thi.ng.geom.vector.swizzle3_fns.call(null,k);
if(cljs.core.truth_(temp__5802__auto__)){
var f = temp__5802__auto__;
return f.call(null,_);
} else {
return nf;
}
} else {
if((((k >= (0))) && ((k <= (2))))){
return (self__.buf[k]);
} else {
return nf;
}
}
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IPolar$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IPolar$as_polar$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var r = thi.ng.math.core.mag.call(null,___$1);
var b = (new Float32Array((3)));
(b[(0)] = r);

(b[(1)] = Math.asin(((self__.buf[(2)]) / r)));

(b[(2)] = Math.atan2((self__.buf[(1)]),(self__.buf[(0)])));

return (new thi.ng.geom.vector.Vec3(b,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$geom$core$IPolar$as_cartesian$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var b = self__.buf;
var x = (b[(0)]);
var y = (b[(1)]);
var z = (b[(2)]);
var rcos = (x * Math.cos(y));
var b_SINGLEQUOTE_ = (new Float32Array((3)));
(b_SINGLEQUOTE_[(0)] = (rcos * Math.cos(z)));

(b_SINGLEQUOTE_[(1)] = (rcos * Math.sin(z)));

(b_SINGLEQUOTE_[(2)] = (x * Math.sin(y)));

return (new thi.ng.geom.vector.Vec3(b_SINGLEQUOTE_,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.cljs$core$IComparable$_compare$arity$2 = (function (_,o){
var self__ = this;
var ___$1 = this;
if((o instanceof thi.ng.geom.vector.Vec3)){
var b_SINGLEQUOTE_ = o.buf;
var c = cljs.core.compare.call(null,(self__.buf[(0)]),(b_SINGLEQUOTE_[(0)]));
if(((0) === c)){
var c__$1 = cljs.core.compare.call(null,(self__.buf[(1)]),(b_SINGLEQUOTE_[(1)]));
if(((0) === c__$1)){
return cljs.core.compare.call(null,(self__.buf[(2)]),(b_SINGLEQUOTE_[(2)]));
} else {
return c__$1;
}
} else {
return c;
}
} else {
var c = cljs.core.count.call(null,o);
if(((3) === c)){
return (- cljs.core.compare.call(null,o,___$1));
} else {
return ((3) - c);
}
}
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$INormalize$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$INormalize$normalize$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var G__17994 = self__.buf;
var G__17995 = (G__17994[(0)]);
var G__17996 = (G__17994[(1)]);
var G__17997 = (G__17994[(2)]);
var l = Math.sqrt((((G__17995 * G__17995) + (G__17996 * G__17996)) + (G__17997 * G__17997)));
if((l > (0))){
var b = (new Float32Array((3)));
(b[(0)] = (G__17995 / l));

(b[(1)] = (G__17996 / l));

(b[(2)] = (G__17997 / l));

return (new thi.ng.geom.vector.Vec3(b,null,self__._meta));
} else {
return ___$1;
}
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$INormalize$normalize$arity$2 = (function (_,len){
var self__ = this;
var ___$1 = this;
var G__17998 = self__.buf;
var G__17999 = (G__17998[(0)]);
var G__18000 = (G__17998[(1)]);
var G__18001 = (G__17998[(2)]);
var l = Math.sqrt((((G__17999 * G__17999) + (G__18000 * G__18000)) + (G__18001 * G__18001)));
if((l > (0))){
var l__$1 = (len / l);
var b = (new Float32Array((3)));
(b[(0)] = (G__17999 * l__$1));

(b[(1)] = (G__18000 * l__$1));

(b[(2)] = (G__18001 * l__$1));

return (new thi.ng.geom.vector.Vec3(b,null,self__._meta));
} else {
return ___$1;
}
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$INormalize$normalized_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return thi.ng.math.core.delta_EQ_.call(null,1.0,thi.ng.math.core.mag_squared.call(null,___$1));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMagnitude$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMagnitude$mag$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var G__18002 = self__.buf;
var G__18003 = (G__18002[(0)]);
var G__18004 = (G__18002[(1)]);
var G__18005 = (G__18002[(2)]);
return Math.sqrt((((G__18003 * G__18003) + (G__18004 * G__18004)) + (G__18005 * G__18005)));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMagnitude$mag_squared$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var G__18006 = self__.buf;
var G__18007 = (G__18006[(0)]);
var G__18008 = (G__18006[(1)]);
var G__18009 = (G__18006[(2)]);
return (((G__18007 * G__18007) + (G__18008 * G__18008)) + (G__18009 * G__18009));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$ = cljs.core.PROTOCOL_SENTINEL;

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$msub$arity$3 = (function (_,a,b){
var self__ = this;
var ___$1 = this;
var dest__15415__auto__ = (new Float32Array((3)));
var G__18022_18412 = (a instanceof thi.ng.geom.vector.Vec3);
var G__18023_18413 = (b instanceof thi.ng.geom.vector.Vec3);
var G__18024_18414 = (((!(G__18022_18412)))?typeof a === 'number':null);
var G__18025_18415 = (((!(G__18023_18413)))?typeof b === 'number':null);
var G__18010_18416 = self__.buf;
var G__18011_18417 = ((G__18022_18412)?a.buf:null);
var G__18012_18418 = ((G__18023_18413)?b.buf:null);
var G__18013_18419 = (G__18010_18416[(0)]);
var G__18014_18420 = (G__18010_18416[(1)]);
var G__18015_18421 = (G__18010_18416[(2)]);
var G__18016_18422 = ((G__18022_18412)?(G__18011_18417[(0)]):(cljs.core.truth_(G__18024_18414)?a:cljs.core.nth.call(null,a,(0),1.0)));
var G__18017_18423 = ((G__18022_18412)?(G__18011_18417[(1)]):(cljs.core.truth_(G__18024_18414)?a:cljs.core.nth.call(null,a,(1),1.0)));
var G__18018_18424 = ((G__18022_18412)?(G__18011_18417[(2)]):(cljs.core.truth_(G__18024_18414)?a:cljs.core.nth.call(null,a,(2),1.0)));
var G__18019_18425 = ((G__18023_18413)?(G__18012_18418[(0)]):(cljs.core.truth_(G__18025_18415)?b:cljs.core.nth.call(null,b,(0),0.0)));
var G__18020_18426 = ((G__18023_18413)?(G__18012_18418[(1)]):(cljs.core.truth_(G__18025_18415)?b:cljs.core.nth.call(null,b,(1),0.0)));
var G__18021_18427 = ((G__18023_18413)?(G__18012_18418[(2)]):(cljs.core.truth_(G__18025_18415)?b:cljs.core.nth.call(null,b,(2),0.0)));
(dest__15415__auto__[(0)] = ((G__18013_18419 * G__18016_18422) - G__18019_18425));

(dest__15415__auto__[(1)] = ((G__18014_18420 * G__18017_18423) - G__18020_18426));

(dest__15415__auto__[(2)] = ((G__18015_18421 * G__18018_18424) - G__18021_18427));

return (new thi.ng.geom.vector.Vec3(dest__15415__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$_STAR_$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var dest__15404__auto__ = (new Float32Array((3)));
var G__18026_18428 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__18027_18429 = v.buf;
(dest__15404__auto__[(0)] = ((G__18026_18428[(0)]) * (G__18027_18429[(0)])));

(dest__15404__auto__[(1)] = ((G__18026_18428[(1)]) * (G__18027_18429[(1)])));

(dest__15404__auto__[(2)] = ((G__18026_18428[(2)]) * (G__18027_18429[(2)])));
} else {
if(typeof v === 'number'){
(dest__15404__auto__[(0)] = ((G__18026_18428[(0)]) * v));

(dest__15404__auto__[(1)] = ((G__18026_18428[(1)]) * v));

(dest__15404__auto__[(2)] = ((G__18026_18428[(2)]) * v));
} else {
(dest__15404__auto__[(0)] = ((G__18026_18428[(0)]) * cljs.core.nth.call(null,v,(0),0.0)));

(dest__15404__auto__[(1)] = ((G__18026_18428[(1)]) * cljs.core.nth.call(null,v,(1),0.0)));

(dest__15404__auto__[(2)] = ((G__18026_18428[(2)]) * cljs.core.nth.call(null,v,(2),0.0)));
}
}

return (new thi.ng.geom.vector.Vec3(dest__15404__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$_STAR_$arity$3 = (function (_,v1,v2){
var self__ = this;
var ___$1 = this;
var dest__15415__auto__ = (new Float32Array((3)));
var G__18040_18430 = (v1 instanceof thi.ng.geom.vector.Vec3);
var G__18041_18431 = (v2 instanceof thi.ng.geom.vector.Vec3);
var G__18042_18432 = (((!(G__18040_18430)))?typeof v1 === 'number':null);
var G__18043_18433 = (((!(G__18041_18431)))?typeof v2 === 'number':null);
var G__18028_18434 = self__.buf;
var G__18029_18435 = ((G__18040_18430)?v1.buf:null);
var G__18030_18436 = ((G__18041_18431)?v2.buf:null);
var G__18031_18437 = (G__18028_18434[(0)]);
var G__18032_18438 = (G__18028_18434[(1)]);
var G__18033_18439 = (G__18028_18434[(2)]);
var G__18034_18440 = ((G__18040_18430)?(G__18029_18435[(0)]):(cljs.core.truth_(G__18042_18432)?v1:cljs.core.nth.call(null,v1,(0),0.0)));
var G__18035_18441 = ((G__18040_18430)?(G__18029_18435[(1)]):(cljs.core.truth_(G__18042_18432)?v1:cljs.core.nth.call(null,v1,(1),0.0)));
var G__18036_18442 = ((G__18040_18430)?(G__18029_18435[(2)]):(cljs.core.truth_(G__18042_18432)?v1:cljs.core.nth.call(null,v1,(2),0.0)));
var G__18037_18443 = ((G__18041_18431)?(G__18030_18436[(0)]):(cljs.core.truth_(G__18043_18433)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__18038_18444 = ((G__18041_18431)?(G__18030_18436[(1)]):(cljs.core.truth_(G__18043_18433)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
var G__18039_18445 = ((G__18041_18431)?(G__18030_18436[(2)]):(cljs.core.truth_(G__18043_18433)?v2:cljs.core.nth.call(null,v2,(2),0.0)));
(dest__15415__auto__[(0)] = ((G__18031_18437 * G__18034_18440) * G__18037_18443));

(dest__15415__auto__[(1)] = ((G__18032_18438 * G__18035_18441) * G__18038_18444));

(dest__15415__auto__[(2)] = ((G__18033_18439 * G__18036_18442) * G__18039_18445));

return (new thi.ng.geom.vector.Vec3(dest__15415__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$_STAR_$arity$4 = (function (_,x,y,z){
var self__ = this;
var ___$1 = this;
var G__18044 = self__.buf;
var dest__15393__auto__ = (new Float32Array((3)));
(dest__15393__auto__[(0)] = ((G__18044[(0)]) * x));

(dest__15393__auto__[(1)] = ((G__18044[(1)]) * y));

(dest__15393__auto__[(2)] = ((G__18044[(2)]) * z));

return (new thi.ng.geom.vector.Vec3(dest__15393__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var dest__15387__auto__ = (new Float32Array((3)));
var G__18045_18446 = self__.buf;
(dest__15387__auto__[(0)] = (- (G__18045_18446[(0)])));

(dest__15387__auto__[(1)] = (- (G__18045_18446[(1)])));

(dest__15387__auto__[(2)] = (- (G__18045_18446[(2)])));

return (new thi.ng.geom.vector.Vec3(dest__15387__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$_$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var dest__15404__auto__ = (new Float32Array((3)));
var G__18046_18447 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__18047_18448 = v.buf;
(dest__15404__auto__[(0)] = ((G__18046_18447[(0)]) - (G__18047_18448[(0)])));

(dest__15404__auto__[(1)] = ((G__18046_18447[(1)]) - (G__18047_18448[(1)])));

(dest__15404__auto__[(2)] = ((G__18046_18447[(2)]) - (G__18047_18448[(2)])));
} else {
if(typeof v === 'number'){
(dest__15404__auto__[(0)] = ((G__18046_18447[(0)]) - v));

(dest__15404__auto__[(1)] = ((G__18046_18447[(1)]) - v));

(dest__15404__auto__[(2)] = ((G__18046_18447[(2)]) - v));
} else {
(dest__15404__auto__[(0)] = ((G__18046_18447[(0)]) - cljs.core.nth.call(null,v,(0),0.0)));

(dest__15404__auto__[(1)] = ((G__18046_18447[(1)]) - cljs.core.nth.call(null,v,(1),0.0)));

(dest__15404__auto__[(2)] = ((G__18046_18447[(2)]) - cljs.core.nth.call(null,v,(2),0.0)));
}
}

return (new thi.ng.geom.vector.Vec3(dest__15404__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$_$arity$3 = (function (_,v1,v2){
var self__ = this;
var ___$1 = this;
var dest__15415__auto__ = (new Float32Array((3)));
var G__18060_18449 = (v1 instanceof thi.ng.geom.vector.Vec3);
var G__18061_18450 = (v2 instanceof thi.ng.geom.vector.Vec3);
var G__18062_18451 = (((!(G__18060_18449)))?typeof v1 === 'number':null);
var G__18063_18452 = (((!(G__18061_18450)))?typeof v2 === 'number':null);
var G__18048_18453 = self__.buf;
var G__18049_18454 = ((G__18060_18449)?v1.buf:null);
var G__18050_18455 = ((G__18061_18450)?v2.buf:null);
var G__18051_18456 = (G__18048_18453[(0)]);
var G__18052_18457 = (G__18048_18453[(1)]);
var G__18053_18458 = (G__18048_18453[(2)]);
var G__18054_18459 = ((G__18060_18449)?(G__18049_18454[(0)]):(cljs.core.truth_(G__18062_18451)?v1:cljs.core.nth.call(null,v1,(0),0.0)));
var G__18055_18460 = ((G__18060_18449)?(G__18049_18454[(1)]):(cljs.core.truth_(G__18062_18451)?v1:cljs.core.nth.call(null,v1,(1),0.0)));
var G__18056_18461 = ((G__18060_18449)?(G__18049_18454[(2)]):(cljs.core.truth_(G__18062_18451)?v1:cljs.core.nth.call(null,v1,(2),0.0)));
var G__18057_18462 = ((G__18061_18450)?(G__18050_18455[(0)]):(cljs.core.truth_(G__18063_18452)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__18058_18463 = ((G__18061_18450)?(G__18050_18455[(1)]):(cljs.core.truth_(G__18063_18452)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
var G__18059_18464 = ((G__18061_18450)?(G__18050_18455[(2)]):(cljs.core.truth_(G__18063_18452)?v2:cljs.core.nth.call(null,v2,(2),0.0)));
(dest__15415__auto__[(0)] = ((G__18051_18456 - G__18054_18459) - G__18057_18462));

(dest__15415__auto__[(1)] = ((G__18052_18457 - G__18055_18460) - G__18058_18463));

(dest__15415__auto__[(2)] = ((G__18053_18458 - G__18056_18461) - G__18059_18464));

return (new thi.ng.geom.vector.Vec3(dest__15415__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$_$arity$4 = (function (_,x,y,z){
var self__ = this;
var ___$1 = this;
var G__18064 = self__.buf;
var dest__15393__auto__ = (new Float32Array((3)));
(dest__15393__auto__[(0)] = ((G__18064[(0)]) - x));

(dest__15393__auto__[(1)] = ((G__18064[(1)]) - y));

(dest__15393__auto__[(2)] = ((G__18064[(2)]) - z));

return (new thi.ng.geom.vector.Vec3(dest__15393__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$madd$arity$3 = (function (_,a,b){
var self__ = this;
var ___$1 = this;
var dest__15415__auto__ = (new Float32Array((3)));
var G__18077_18465 = (a instanceof thi.ng.geom.vector.Vec3);
var G__18078_18466 = (b instanceof thi.ng.geom.vector.Vec3);
var G__18079_18467 = (((!(G__18077_18465)))?typeof a === 'number':null);
var G__18080_18468 = (((!(G__18078_18466)))?typeof b === 'number':null);
var G__18065_18469 = self__.buf;
var G__18066_18470 = ((G__18077_18465)?a.buf:null);
var G__18067_18471 = ((G__18078_18466)?b.buf:null);
var G__18068_18472 = (G__18065_18469[(0)]);
var G__18069_18473 = (G__18065_18469[(1)]);
var G__18070_18474 = (G__18065_18469[(2)]);
var G__18071_18475 = ((G__18077_18465)?(G__18066_18470[(0)]):(cljs.core.truth_(G__18079_18467)?a:cljs.core.nth.call(null,a,(0),1.0)));
var G__18072_18476 = ((G__18077_18465)?(G__18066_18470[(1)]):(cljs.core.truth_(G__18079_18467)?a:cljs.core.nth.call(null,a,(1),1.0)));
var G__18073_18477 = ((G__18077_18465)?(G__18066_18470[(2)]):(cljs.core.truth_(G__18079_18467)?a:cljs.core.nth.call(null,a,(2),1.0)));
var G__18074_18478 = ((G__18078_18466)?(G__18067_18471[(0)]):(cljs.core.truth_(G__18080_18468)?b:cljs.core.nth.call(null,b,(0),0.0)));
var G__18075_18479 = ((G__18078_18466)?(G__18067_18471[(1)]):(cljs.core.truth_(G__18080_18468)?b:cljs.core.nth.call(null,b,(1),0.0)));
var G__18076_18480 = ((G__18078_18466)?(G__18067_18471[(2)]):(cljs.core.truth_(G__18080_18468)?b:cljs.core.nth.call(null,b,(2),0.0)));
(dest__15415__auto__[(0)] = ((G__18068_18472 * G__18071_18475) + G__18074_18478));

(dest__15415__auto__[(1)] = ((G__18069_18473 * G__18072_18476) + G__18075_18479));

(dest__15415__auto__[(2)] = ((G__18070_18474 * G__18073_18477) + G__18076_18480));

return (new thi.ng.geom.vector.Vec3(dest__15415__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$addm$arity$3 = (function (_,a,b){
var self__ = this;
var ___$1 = this;
var dest__15415__auto__ = (new Float32Array((3)));
var G__18093_18481 = (a instanceof thi.ng.geom.vector.Vec3);
var G__18094_18482 = (b instanceof thi.ng.geom.vector.Vec3);
var G__18095_18483 = (((!(G__18093_18481)))?typeof a === 'number':null);
var G__18096_18484 = (((!(G__18094_18482)))?typeof b === 'number':null);
var G__18081_18485 = self__.buf;
var G__18082_18486 = ((G__18093_18481)?a.buf:null);
var G__18083_18487 = ((G__18094_18482)?b.buf:null);
var G__18084_18488 = (G__18081_18485[(0)]);
var G__18085_18489 = (G__18081_18485[(1)]);
var G__18086_18490 = (G__18081_18485[(2)]);
var G__18087_18491 = ((G__18093_18481)?(G__18082_18486[(0)]):(cljs.core.truth_(G__18095_18483)?a:cljs.core.nth.call(null,a,(0),0.0)));
var G__18088_18492 = ((G__18093_18481)?(G__18082_18486[(1)]):(cljs.core.truth_(G__18095_18483)?a:cljs.core.nth.call(null,a,(1),0.0)));
var G__18089_18493 = ((G__18093_18481)?(G__18082_18486[(2)]):(cljs.core.truth_(G__18095_18483)?a:cljs.core.nth.call(null,a,(2),0.0)));
var G__18090_18494 = ((G__18094_18482)?(G__18083_18487[(0)]):(cljs.core.truth_(G__18096_18484)?b:cljs.core.nth.call(null,b,(0),1.0)));
var G__18091_18495 = ((G__18094_18482)?(G__18083_18487[(1)]):(cljs.core.truth_(G__18096_18484)?b:cljs.core.nth.call(null,b,(1),1.0)));
var G__18092_18496 = ((G__18094_18482)?(G__18083_18487[(2)]):(cljs.core.truth_(G__18096_18484)?b:cljs.core.nth.call(null,b,(2),1.0)));
(dest__15415__auto__[(0)] = ((G__18084_18488 + G__18087_18491) * G__18090_18494));

(dest__15415__auto__[(1)] = ((G__18085_18489 + G__18088_18492) * G__18091_18495));

(dest__15415__auto__[(2)] = ((G__18086_18490 + G__18089_18493) * G__18092_18496));

return (new thi.ng.geom.vector.Vec3(dest__15415__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$div$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var dest__15387__auto__ = (new Float32Array((3)));
var G__18097_18497 = self__.buf;
(dest__15387__auto__[(0)] = ((1) / (G__18097_18497[(0)])));

(dest__15387__auto__[(1)] = ((1) / (G__18097_18497[(1)])));

(dest__15387__auto__[(2)] = ((1) / (G__18097_18497[(2)])));

return (new thi.ng.geom.vector.Vec3(dest__15387__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$div$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var dest__15404__auto__ = (new Float32Array((3)));
var G__18098_18498 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__18099_18499 = v.buf;
(dest__15404__auto__[(0)] = ((G__18098_18498[(0)]) / (G__18099_18499[(0)])));

(dest__15404__auto__[(1)] = ((G__18098_18498[(1)]) / (G__18099_18499[(1)])));

(dest__15404__auto__[(2)] = ((G__18098_18498[(2)]) / (G__18099_18499[(2)])));
} else {
if(typeof v === 'number'){
(dest__15404__auto__[(0)] = ((G__18098_18498[(0)]) / v));

(dest__15404__auto__[(1)] = ((G__18098_18498[(1)]) / v));

(dest__15404__auto__[(2)] = ((G__18098_18498[(2)]) / v));
} else {
(dest__15404__auto__[(0)] = ((G__18098_18498[(0)]) / cljs.core.nth.call(null,v,(0),0.0)));

(dest__15404__auto__[(1)] = ((G__18098_18498[(1)]) / cljs.core.nth.call(null,v,(1),0.0)));

(dest__15404__auto__[(2)] = ((G__18098_18498[(2)]) / cljs.core.nth.call(null,v,(2),0.0)));
}
}

return (new thi.ng.geom.vector.Vec3(dest__15404__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$div$arity$3 = (function (_,v1,v2){
var self__ = this;
var ___$1 = this;
var dest__15415__auto__ = (new Float32Array((3)));
var G__18112_18500 = (v1 instanceof thi.ng.geom.vector.Vec3);
var G__18113_18501 = (v2 instanceof thi.ng.geom.vector.Vec3);
var G__18114_18502 = (((!(G__18112_18500)))?typeof v1 === 'number':null);
var G__18115_18503 = (((!(G__18113_18501)))?typeof v2 === 'number':null);
var G__18100_18504 = self__.buf;
var G__18101_18505 = ((G__18112_18500)?v1.buf:null);
var G__18102_18506 = ((G__18113_18501)?v2.buf:null);
var G__18103_18507 = (G__18100_18504[(0)]);
var G__18104_18508 = (G__18100_18504[(1)]);
var G__18105_18509 = (G__18100_18504[(2)]);
var G__18106_18510 = ((G__18112_18500)?(G__18101_18505[(0)]):(cljs.core.truth_(G__18114_18502)?v1:cljs.core.nth.call(null,v1,(0),0.0)));
var G__18107_18511 = ((G__18112_18500)?(G__18101_18505[(1)]):(cljs.core.truth_(G__18114_18502)?v1:cljs.core.nth.call(null,v1,(1),0.0)));
var G__18108_18512 = ((G__18112_18500)?(G__18101_18505[(2)]):(cljs.core.truth_(G__18114_18502)?v1:cljs.core.nth.call(null,v1,(2),0.0)));
var G__18109_18513 = ((G__18113_18501)?(G__18102_18506[(0)]):(cljs.core.truth_(G__18115_18503)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__18110_18514 = ((G__18113_18501)?(G__18102_18506[(1)]):(cljs.core.truth_(G__18115_18503)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
var G__18111_18515 = ((G__18113_18501)?(G__18102_18506[(2)]):(cljs.core.truth_(G__18115_18503)?v2:cljs.core.nth.call(null,v2,(2),0.0)));
(dest__15415__auto__[(0)] = ((G__18103_18507 / G__18106_18510) / G__18109_18513));

(dest__15415__auto__[(1)] = ((G__18104_18508 / G__18107_18511) / G__18110_18514));

(dest__15415__auto__[(2)] = ((G__18105_18509 / G__18108_18512) / G__18111_18515));

return (new thi.ng.geom.vector.Vec3(dest__15415__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$div$arity$4 = (function (_,x,y,z){
var self__ = this;
var ___$1 = this;
var G__18116 = self__.buf;
var dest__15393__auto__ = (new Float32Array((3)));
(dest__15393__auto__[(0)] = ((G__18116[(0)]) / x));

(dest__15393__auto__[(1)] = ((G__18116[(1)]) / y));

(dest__15393__auto__[(2)] = ((G__18116[(2)]) / z));

return (new thi.ng.geom.vector.Vec3(dest__15393__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$_PLUS_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return ___$1;
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$_PLUS_$arity$2 = (function (_,v){
var self__ = this;
var ___$1 = this;
var dest__15404__auto__ = (new Float32Array((3)));
var G__18117_18516 = self__.buf;
if((v instanceof thi.ng.geom.vector.Vec3)){
var G__18118_18517 = v.buf;
(dest__15404__auto__[(0)] = ((G__18117_18516[(0)]) + (G__18118_18517[(0)])));

(dest__15404__auto__[(1)] = ((G__18117_18516[(1)]) + (G__18118_18517[(1)])));

(dest__15404__auto__[(2)] = ((G__18117_18516[(2)]) + (G__18118_18517[(2)])));
} else {
if(typeof v === 'number'){
(dest__15404__auto__[(0)] = ((G__18117_18516[(0)]) + v));

(dest__15404__auto__[(1)] = ((G__18117_18516[(1)]) + v));

(dest__15404__auto__[(2)] = ((G__18117_18516[(2)]) + v));
} else {
(dest__15404__auto__[(0)] = ((G__18117_18516[(0)]) + cljs.core.nth.call(null,v,(0),0.0)));

(dest__15404__auto__[(1)] = ((G__18117_18516[(1)]) + cljs.core.nth.call(null,v,(1),0.0)));

(dest__15404__auto__[(2)] = ((G__18117_18516[(2)]) + cljs.core.nth.call(null,v,(2),0.0)));
}
}

return (new thi.ng.geom.vector.Vec3(dest__15404__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$_PLUS_$arity$3 = (function (_,v1,v2){
var self__ = this;
var ___$1 = this;
var dest__15415__auto__ = (new Float32Array((3)));
var G__18131_18518 = (v1 instanceof thi.ng.geom.vector.Vec3);
var G__18132_18519 = (v2 instanceof thi.ng.geom.vector.Vec3);
var G__18133_18520 = (((!(G__18131_18518)))?typeof v1 === 'number':null);
var G__18134_18521 = (((!(G__18132_18519)))?typeof v2 === 'number':null);
var G__18119_18522 = self__.buf;
var G__18120_18523 = ((G__18131_18518)?v1.buf:null);
var G__18121_18524 = ((G__18132_18519)?v2.buf:null);
var G__18122_18525 = (G__18119_18522[(0)]);
var G__18123_18526 = (G__18119_18522[(1)]);
var G__18124_18527 = (G__18119_18522[(2)]);
var G__18125_18528 = ((G__18131_18518)?(G__18120_18523[(0)]):(cljs.core.truth_(G__18133_18520)?v1:cljs.core.nth.call(null,v1,(0),0.0)));
var G__18126_18529 = ((G__18131_18518)?(G__18120_18523[(1)]):(cljs.core.truth_(G__18133_18520)?v1:cljs.core.nth.call(null,v1,(1),0.0)));
var G__18127_18530 = ((G__18131_18518)?(G__18120_18523[(2)]):(cljs.core.truth_(G__18133_18520)?v1:cljs.core.nth.call(null,v1,(2),0.0)));
var G__18128_18531 = ((G__18132_18519)?(G__18121_18524[(0)]):(cljs.core.truth_(G__18134_18521)?v2:cljs.core.nth.call(null,v2,(0),0.0)));
var G__18129_18532 = ((G__18132_18519)?(G__18121_18524[(1)]):(cljs.core.truth_(G__18134_18521)?v2:cljs.core.nth.call(null,v2,(1),0.0)));
var G__18130_18533 = ((G__18132_18519)?(G__18121_18524[(2)]):(cljs.core.truth_(G__18134_18521)?v2:cljs.core.nth.call(null,v2,(2),0.0)));
(dest__15415__auto__[(0)] = ((G__18122_18525 + G__18125_18528) + G__18128_18531));

(dest__15415__auto__[(1)] = ((G__18123_18526 + G__18126_18529) + G__18129_18532));

(dest__15415__auto__[(2)] = ((G__18124_18527 + G__18127_18530) + G__18130_18533));

return (new thi.ng.geom.vector.Vec3(dest__15415__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$_PLUS_$arity$4 = (function (_,x,y,z){
var self__ = this;
var ___$1 = this;
var G__18135 = self__.buf;
var dest__15393__auto__ = (new Float32Array((3)));
(dest__15393__auto__[(0)] = ((G__18135[(0)]) + x));

(dest__15393__auto__[(1)] = ((G__18135[(1)]) + y));

(dest__15393__auto__[(2)] = ((G__18135[(2)]) + z));

return (new thi.ng.geom.vector.Vec3(dest__15393__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$abs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var dest__15387__auto__ = (new Float32Array((3)));
var G__18136_18534 = self__.buf;
(dest__15387__auto__[(0)] = thi.ng.math.core.abs_STAR_.call(null,(G__18136_18534[(0)])));

(dest__15387__auto__[(1)] = thi.ng.math.core.abs_STAR_.call(null,(G__18136_18534[(1)])));

(dest__15387__auto__[(2)] = thi.ng.math.core.abs_STAR_.call(null,(G__18136_18534[(2)])));

return (new thi.ng.geom.vector.Vec3(dest__15387__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.prototype.thi$ng$math$core$IMathOps$subm$arity$3 = (function (_,a,b){
var self__ = this;
var ___$1 = this;
var dest__15415__auto__ = (new Float32Array((3)));
var G__18149_18535 = (a instanceof thi.ng.geom.vector.Vec3);
var G__18150_18536 = (b instanceof thi.ng.geom.vector.Vec3);
var G__18151_18537 = (((!(G__18149_18535)))?typeof a === 'number':null);
var G__18152_18538 = (((!(G__18150_18536)))?typeof b === 'number':null);
var G__18137_18539 = self__.buf;
var G__18138_18540 = ((G__18149_18535)?a.buf:null);
var G__18139_18541 = ((G__18150_18536)?b.buf:null);
var G__18140_18542 = (G__18137_18539[(0)]);
var G__18141_18543 = (G__18137_18539[(1)]);
var G__18142_18544 = (G__18137_18539[(2)]);
var G__18143_18545 = ((G__18149_18535)?(G__18138_18540[(0)]):(cljs.core.truth_(G__18151_18537)?a:cljs.core.nth.call(null,a,(0),0.0)));
var G__18144_18546 = ((G__18149_18535)?(G__18138_18540[(1)]):(cljs.core.truth_(G__18151_18537)?a:cljs.core.nth.call(null,a,(1),0.0)));
var G__18145_18547 = ((G__18149_18535)?(G__18138_18540[(2)]):(cljs.core.truth_(G__18151_18537)?a:cljs.core.nth.call(null,a,(2),0.0)));
var G__18146_18548 = ((G__18150_18536)?(G__18139_18541[(0)]):(cljs.core.truth_(G__18152_18538)?b:cljs.core.nth.call(null,b,(0),1.0)));
var G__18147_18549 = ((G__18150_18536)?(G__18139_18541[(1)]):(cljs.core.truth_(G__18152_18538)?b:cljs.core.nth.call(null,b,(1),1.0)));
var G__18148_18550 = ((G__18150_18536)?(G__18139_18541[(2)]):(cljs.core.truth_(G__18152_18538)?b:cljs.core.nth.call(null,b,(2),1.0)));
(dest__15415__auto__[(0)] = ((G__18140_18542 - G__18143_18545) * G__18146_18548));

(dest__15415__auto__[(1)] = ((G__18141_18543 - G__18144_18546) * G__18147_18549));

(dest__15415__auto__[(2)] = ((G__18142_18544 - G__18145_18547) * G__18148_18550));

return (new thi.ng.geom.vector.Vec3(dest__15415__auto__,null,self__._meta));
});

thi.ng.geom.vector.Vec3.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"buf","buf",1426618187,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_hash","_hash",-2130838312,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null)),new cljs.core.Symbol(null,"_meta","_meta",-1716892533,null)], null);
});

thi.ng.geom.vector.Vec3.cljs$lang$type = true;

thi.ng.geom.vector.Vec3.cljs$lang$ctorStr = "thi.ng.geom.vector/Vec3";

thi.ng.geom.vector.Vec3.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"thi.ng.geom.vector/Vec3");
});

/**
 * Positional factory function for thi.ng.geom.vector/Vec3.
 */
thi.ng.geom.vector.__GT_Vec3 = (function thi$ng$geom$vector$__GT_Vec3(buf,_hash,_meta){
return (new thi.ng.geom.vector.Vec3(buf,_hash,_meta));
});

thi.ng.geom.vector.x = (function thi$ng$geom$vector$x(G__18553){
var G__18551 = (((G__18553 instanceof thi.ng.geom.vector.Vec2))?G__18553.buf:G__18553.buf);
return (G__18551[(0)]);
});
thi.ng.geom.vector.xx = (function thi$ng$geom$vector$xx(G__18556){
var G__18554 = (((G__18556 instanceof thi.ng.geom.vector.Vec2))?G__18556.buf:G__18556.buf);
var G__18555 = (new Float32Array(2));
(G__18555[(0)] = (G__18554[(0)]));

(G__18555[(1)] = (G__18554[(0)]));

return (new thi.ng.geom.vector.Vec2(G__18555,null,cljs.core.meta.call(null,G__18556)));
});
thi.ng.geom.vector.xxx = (function thi$ng$geom$vector$xxx(G__18559){
var G__18557 = (((G__18559 instanceof thi.ng.geom.vector.Vec2))?G__18559.buf:G__18559.buf);
var G__18558 = (new Float32Array(3));
(G__18558[(0)] = (G__18557[(0)]));

(G__18558[(1)] = (G__18557[(0)]));

(G__18558[(2)] = (G__18557[(0)]));

return (new thi.ng.geom.vector.Vec3(G__18558,null,cljs.core.meta.call(null,G__18559)));
});
thi.ng.geom.vector.xxy = (function thi$ng$geom$vector$xxy(G__18562){
var G__18560 = (((G__18562 instanceof thi.ng.geom.vector.Vec2))?G__18562.buf:G__18562.buf);
var G__18561 = (new Float32Array(3));
(G__18561[(0)] = (G__18560[(0)]));

(G__18561[(1)] = (G__18560[(0)]));

(G__18561[(2)] = (G__18560[(1)]));

return (new thi.ng.geom.vector.Vec3(G__18561,null,cljs.core.meta.call(null,G__18562)));
});
thi.ng.geom.vector.xxz = (function thi$ng$geom$vector$xxz(G__18565){
var G__18563 = (((G__18565 instanceof thi.ng.geom.vector.Vec2))?G__18565.buf:G__18565.buf);
var G__18564 = (new Float32Array(3));
(G__18564[(0)] = (G__18563[(0)]));

(G__18564[(1)] = (G__18563[(0)]));

(G__18564[(2)] = (G__18563[(2)]));

return (new thi.ng.geom.vector.Vec3(G__18564,null,cljs.core.meta.call(null,G__18565)));
});
thi.ng.geom.vector.xy = (function thi$ng$geom$vector$xy(G__18568){
var G__18566 = (((G__18568 instanceof thi.ng.geom.vector.Vec2))?G__18568.buf:G__18568.buf);
var G__18567 = (new Float32Array(2));
(G__18567[(0)] = (G__18566[(0)]));

(G__18567[(1)] = (G__18566[(1)]));

return (new thi.ng.geom.vector.Vec2(G__18567,null,cljs.core.meta.call(null,G__18568)));
});
thi.ng.geom.vector.xyx = (function thi$ng$geom$vector$xyx(G__18571){
var G__18569 = (((G__18571 instanceof thi.ng.geom.vector.Vec2))?G__18571.buf:G__18571.buf);
var G__18570 = (new Float32Array(3));
(G__18570[(0)] = (G__18569[(0)]));

(G__18570[(1)] = (G__18569[(1)]));

(G__18570[(2)] = (G__18569[(0)]));

return (new thi.ng.geom.vector.Vec3(G__18570,null,cljs.core.meta.call(null,G__18571)));
});
thi.ng.geom.vector.xyy = (function thi$ng$geom$vector$xyy(G__18574){
var G__18572 = (((G__18574 instanceof thi.ng.geom.vector.Vec2))?G__18574.buf:G__18574.buf);
var G__18573 = (new Float32Array(3));
(G__18573[(0)] = (G__18572[(0)]));

(G__18573[(1)] = (G__18572[(1)]));

(G__18573[(2)] = (G__18572[(1)]));

return (new thi.ng.geom.vector.Vec3(G__18573,null,cljs.core.meta.call(null,G__18574)));
});
thi.ng.geom.vector.xyz = (function thi$ng$geom$vector$xyz(G__18577){
var G__18575 = (((G__18577 instanceof thi.ng.geom.vector.Vec2))?G__18577.buf:G__18577.buf);
var G__18576 = (new Float32Array(3));
(G__18576[(0)] = (G__18575[(0)]));

(G__18576[(1)] = (G__18575[(1)]));

(G__18576[(2)] = (G__18575[(2)]));

return (new thi.ng.geom.vector.Vec3(G__18576,null,cljs.core.meta.call(null,G__18577)));
});
thi.ng.geom.vector.xz = (function thi$ng$geom$vector$xz(G__18580){
var G__18578 = (((G__18580 instanceof thi.ng.geom.vector.Vec2))?G__18580.buf:G__18580.buf);
var G__18579 = (new Float32Array(2));
(G__18579[(0)] = (G__18578[(0)]));

(G__18579[(1)] = (G__18578[(2)]));

return (new thi.ng.geom.vector.Vec2(G__18579,null,cljs.core.meta.call(null,G__18580)));
});
thi.ng.geom.vector.xzx = (function thi$ng$geom$vector$xzx(G__18583){
var G__18581 = (((G__18583 instanceof thi.ng.geom.vector.Vec2))?G__18583.buf:G__18583.buf);
var G__18582 = (new Float32Array(3));
(G__18582[(0)] = (G__18581[(0)]));

(G__18582[(1)] = (G__18581[(2)]));

(G__18582[(2)] = (G__18581[(0)]));

return (new thi.ng.geom.vector.Vec3(G__18582,null,cljs.core.meta.call(null,G__18583)));
});
thi.ng.geom.vector.xzy = (function thi$ng$geom$vector$xzy(G__18586){
var G__18584 = (((G__18586 instanceof thi.ng.geom.vector.Vec2))?G__18586.buf:G__18586.buf);
var G__18585 = (new Float32Array(3));
(G__18585[(0)] = (G__18584[(0)]));

(G__18585[(1)] = (G__18584[(2)]));

(G__18585[(2)] = (G__18584[(1)]));

return (new thi.ng.geom.vector.Vec3(G__18585,null,cljs.core.meta.call(null,G__18586)));
});
thi.ng.geom.vector.xzz = (function thi$ng$geom$vector$xzz(G__18589){
var G__18587 = (((G__18589 instanceof thi.ng.geom.vector.Vec2))?G__18589.buf:G__18589.buf);
var G__18588 = (new Float32Array(3));
(G__18588[(0)] = (G__18587[(0)]));

(G__18588[(1)] = (G__18587[(2)]));

(G__18588[(2)] = (G__18587[(2)]));

return (new thi.ng.geom.vector.Vec3(G__18588,null,cljs.core.meta.call(null,G__18589)));
});
thi.ng.geom.vector.y = (function thi$ng$geom$vector$y(G__18592){
var G__18590 = (((G__18592 instanceof thi.ng.geom.vector.Vec2))?G__18592.buf:G__18592.buf);
return (G__18590[(1)]);
});
thi.ng.geom.vector.yx = (function thi$ng$geom$vector$yx(G__18595){
var G__18593 = (((G__18595 instanceof thi.ng.geom.vector.Vec2))?G__18595.buf:G__18595.buf);
var G__18594 = (new Float32Array(2));
(G__18594[(0)] = (G__18593[(1)]));

(G__18594[(1)] = (G__18593[(0)]));

return (new thi.ng.geom.vector.Vec2(G__18594,null,cljs.core.meta.call(null,G__18595)));
});
thi.ng.geom.vector.yxx = (function thi$ng$geom$vector$yxx(G__18598){
var G__18596 = (((G__18598 instanceof thi.ng.geom.vector.Vec2))?G__18598.buf:G__18598.buf);
var G__18597 = (new Float32Array(3));
(G__18597[(0)] = (G__18596[(1)]));

(G__18597[(1)] = (G__18596[(0)]));

(G__18597[(2)] = (G__18596[(0)]));

return (new thi.ng.geom.vector.Vec3(G__18597,null,cljs.core.meta.call(null,G__18598)));
});
thi.ng.geom.vector.yxy = (function thi$ng$geom$vector$yxy(G__18601){
var G__18599 = (((G__18601 instanceof thi.ng.geom.vector.Vec2))?G__18601.buf:G__18601.buf);
var G__18600 = (new Float32Array(3));
(G__18600[(0)] = (G__18599[(1)]));

(G__18600[(1)] = (G__18599[(0)]));

(G__18600[(2)] = (G__18599[(1)]));

return (new thi.ng.geom.vector.Vec3(G__18600,null,cljs.core.meta.call(null,G__18601)));
});
thi.ng.geom.vector.yxz = (function thi$ng$geom$vector$yxz(G__18604){
var G__18602 = (((G__18604 instanceof thi.ng.geom.vector.Vec2))?G__18604.buf:G__18604.buf);
var G__18603 = (new Float32Array(3));
(G__18603[(0)] = (G__18602[(1)]));

(G__18603[(1)] = (G__18602[(0)]));

(G__18603[(2)] = (G__18602[(2)]));

return (new thi.ng.geom.vector.Vec3(G__18603,null,cljs.core.meta.call(null,G__18604)));
});
thi.ng.geom.vector.yy = (function thi$ng$geom$vector$yy(G__18607){
var G__18605 = (((G__18607 instanceof thi.ng.geom.vector.Vec2))?G__18607.buf:G__18607.buf);
var G__18606 = (new Float32Array(2));
(G__18606[(0)] = (G__18605[(1)]));

(G__18606[(1)] = (G__18605[(1)]));

return (new thi.ng.geom.vector.Vec2(G__18606,null,cljs.core.meta.call(null,G__18607)));
});
thi.ng.geom.vector.yyx = (function thi$ng$geom$vector$yyx(G__18610){
var G__18608 = (((G__18610 instanceof thi.ng.geom.vector.Vec2))?G__18610.buf:G__18610.buf);
var G__18609 = (new Float32Array(3));
(G__18609[(0)] = (G__18608[(1)]));

(G__18609[(1)] = (G__18608[(1)]));

(G__18609[(2)] = (G__18608[(0)]));

return (new thi.ng.geom.vector.Vec3(G__18609,null,cljs.core.meta.call(null,G__18610)));
});
thi.ng.geom.vector.yyy = (function thi$ng$geom$vector$yyy(G__18613){
var G__18611 = (((G__18613 instanceof thi.ng.geom.vector.Vec2))?G__18613.buf:G__18613.buf);
var G__18612 = (new Float32Array(3));
(G__18612[(0)] = (G__18611[(1)]));

(G__18612[(1)] = (G__18611[(1)]));

(G__18612[(2)] = (G__18611[(1)]));

return (new thi.ng.geom.vector.Vec3(G__18612,null,cljs.core.meta.call(null,G__18613)));
});
thi.ng.geom.vector.yyz = (function thi$ng$geom$vector$yyz(G__18616){
var G__18614 = (((G__18616 instanceof thi.ng.geom.vector.Vec2))?G__18616.buf:G__18616.buf);
var G__18615 = (new Float32Array(3));
(G__18615[(0)] = (G__18614[(1)]));

(G__18615[(1)] = (G__18614[(1)]));

(G__18615[(2)] = (G__18614[(2)]));

return (new thi.ng.geom.vector.Vec3(G__18615,null,cljs.core.meta.call(null,G__18616)));
});
thi.ng.geom.vector.yz = (function thi$ng$geom$vector$yz(G__18619){
var G__18617 = (((G__18619 instanceof thi.ng.geom.vector.Vec2))?G__18619.buf:G__18619.buf);
var G__18618 = (new Float32Array(2));
(G__18618[(0)] = (G__18617[(1)]));

(G__18618[(1)] = (G__18617[(2)]));

return (new thi.ng.geom.vector.Vec2(G__18618,null,cljs.core.meta.call(null,G__18619)));
});
thi.ng.geom.vector.yzx = (function thi$ng$geom$vector$yzx(G__18622){
var G__18620 = (((G__18622 instanceof thi.ng.geom.vector.Vec2))?G__18622.buf:G__18622.buf);
var G__18621 = (new Float32Array(3));
(G__18621[(0)] = (G__18620[(1)]));

(G__18621[(1)] = (G__18620[(2)]));

(G__18621[(2)] = (G__18620[(0)]));

return (new thi.ng.geom.vector.Vec3(G__18621,null,cljs.core.meta.call(null,G__18622)));
});
thi.ng.geom.vector.yzy = (function thi$ng$geom$vector$yzy(G__18625){
var G__18623 = (((G__18625 instanceof thi.ng.geom.vector.Vec2))?G__18625.buf:G__18625.buf);
var G__18624 = (new Float32Array(3));
(G__18624[(0)] = (G__18623[(1)]));

(G__18624[(1)] = (G__18623[(2)]));

(G__18624[(2)] = (G__18623[(1)]));

return (new thi.ng.geom.vector.Vec3(G__18624,null,cljs.core.meta.call(null,G__18625)));
});
thi.ng.geom.vector.yzz = (function thi$ng$geom$vector$yzz(G__18628){
var G__18626 = (((G__18628 instanceof thi.ng.geom.vector.Vec2))?G__18628.buf:G__18628.buf);
var G__18627 = (new Float32Array(3));
(G__18627[(0)] = (G__18626[(1)]));

(G__18627[(1)] = (G__18626[(2)]));

(G__18627[(2)] = (G__18626[(2)]));

return (new thi.ng.geom.vector.Vec3(G__18627,null,cljs.core.meta.call(null,G__18628)));
});
thi.ng.geom.vector.z = (function thi$ng$geom$vector$z(G__18631){
var G__18629 = (((G__18631 instanceof thi.ng.geom.vector.Vec2))?G__18631.buf:G__18631.buf);
return (G__18629[(2)]);
});
thi.ng.geom.vector.zx = (function thi$ng$geom$vector$zx(G__18634){
var G__18632 = (((G__18634 instanceof thi.ng.geom.vector.Vec2))?G__18634.buf:G__18634.buf);
var G__18633 = (new Float32Array(2));
(G__18633[(0)] = (G__18632[(2)]));

(G__18633[(1)] = (G__18632[(0)]));

return (new thi.ng.geom.vector.Vec2(G__18633,null,cljs.core.meta.call(null,G__18634)));
});
thi.ng.geom.vector.zxx = (function thi$ng$geom$vector$zxx(G__18637){
var G__18635 = (((G__18637 instanceof thi.ng.geom.vector.Vec2))?G__18637.buf:G__18637.buf);
var G__18636 = (new Float32Array(3));
(G__18636[(0)] = (G__18635[(2)]));

(G__18636[(1)] = (G__18635[(0)]));

(G__18636[(2)] = (G__18635[(0)]));

return (new thi.ng.geom.vector.Vec3(G__18636,null,cljs.core.meta.call(null,G__18637)));
});
thi.ng.geom.vector.zxy = (function thi$ng$geom$vector$zxy(G__18640){
var G__18638 = (((G__18640 instanceof thi.ng.geom.vector.Vec2))?G__18640.buf:G__18640.buf);
var G__18639 = (new Float32Array(3));
(G__18639[(0)] = (G__18638[(2)]));

(G__18639[(1)] = (G__18638[(0)]));

(G__18639[(2)] = (G__18638[(1)]));

return (new thi.ng.geom.vector.Vec3(G__18639,null,cljs.core.meta.call(null,G__18640)));
});
thi.ng.geom.vector.zxz = (function thi$ng$geom$vector$zxz(G__18643){
var G__18641 = (((G__18643 instanceof thi.ng.geom.vector.Vec2))?G__18643.buf:G__18643.buf);
var G__18642 = (new Float32Array(3));
(G__18642[(0)] = (G__18641[(2)]));

(G__18642[(1)] = (G__18641[(0)]));

(G__18642[(2)] = (G__18641[(2)]));

return (new thi.ng.geom.vector.Vec3(G__18642,null,cljs.core.meta.call(null,G__18643)));
});
thi.ng.geom.vector.zy = (function thi$ng$geom$vector$zy(G__18646){
var G__18644 = (((G__18646 instanceof thi.ng.geom.vector.Vec2))?G__18646.buf:G__18646.buf);
var G__18645 = (new Float32Array(2));
(G__18645[(0)] = (G__18644[(2)]));

(G__18645[(1)] = (G__18644[(1)]));

return (new thi.ng.geom.vector.Vec2(G__18645,null,cljs.core.meta.call(null,G__18646)));
});
thi.ng.geom.vector.zyx = (function thi$ng$geom$vector$zyx(G__18649){
var G__18647 = (((G__18649 instanceof thi.ng.geom.vector.Vec2))?G__18649.buf:G__18649.buf);
var G__18648 = (new Float32Array(3));
(G__18648[(0)] = (G__18647[(2)]));

(G__18648[(1)] = (G__18647[(1)]));

(G__18648[(2)] = (G__18647[(0)]));

return (new thi.ng.geom.vector.Vec3(G__18648,null,cljs.core.meta.call(null,G__18649)));
});
thi.ng.geom.vector.zyy = (function thi$ng$geom$vector$zyy(G__18652){
var G__18650 = (((G__18652 instanceof thi.ng.geom.vector.Vec2))?G__18652.buf:G__18652.buf);
var G__18651 = (new Float32Array(3));
(G__18651[(0)] = (G__18650[(2)]));

(G__18651[(1)] = (G__18650[(1)]));

(G__18651[(2)] = (G__18650[(1)]));

return (new thi.ng.geom.vector.Vec3(G__18651,null,cljs.core.meta.call(null,G__18652)));
});
thi.ng.geom.vector.zyz = (function thi$ng$geom$vector$zyz(G__18655){
var G__18653 = (((G__18655 instanceof thi.ng.geom.vector.Vec2))?G__18655.buf:G__18655.buf);
var G__18654 = (new Float32Array(3));
(G__18654[(0)] = (G__18653[(2)]));

(G__18654[(1)] = (G__18653[(1)]));

(G__18654[(2)] = (G__18653[(2)]));

return (new thi.ng.geom.vector.Vec3(G__18654,null,cljs.core.meta.call(null,G__18655)));
});
thi.ng.geom.vector.zz = (function thi$ng$geom$vector$zz(G__18658){
var G__18656 = (((G__18658 instanceof thi.ng.geom.vector.Vec2))?G__18658.buf:G__18658.buf);
var G__18657 = (new Float32Array(2));
(G__18657[(0)] = (G__18656[(2)]));

(G__18657[(1)] = (G__18656[(2)]));

return (new thi.ng.geom.vector.Vec2(G__18657,null,cljs.core.meta.call(null,G__18658)));
});
thi.ng.geom.vector.zzx = (function thi$ng$geom$vector$zzx(G__18661){
var G__18659 = (((G__18661 instanceof thi.ng.geom.vector.Vec2))?G__18661.buf:G__18661.buf);
var G__18660 = (new Float32Array(3));
(G__18660[(0)] = (G__18659[(2)]));

(G__18660[(1)] = (G__18659[(2)]));

(G__18660[(2)] = (G__18659[(0)]));

return (new thi.ng.geom.vector.Vec3(G__18660,null,cljs.core.meta.call(null,G__18661)));
});
thi.ng.geom.vector.zzy = (function thi$ng$geom$vector$zzy(G__18664){
var G__18662 = (((G__18664 instanceof thi.ng.geom.vector.Vec2))?G__18664.buf:G__18664.buf);
var G__18663 = (new Float32Array(3));
(G__18663[(0)] = (G__18662[(2)]));

(G__18663[(1)] = (G__18662[(2)]));

(G__18663[(2)] = (G__18662[(1)]));

return (new thi.ng.geom.vector.Vec3(G__18663,null,cljs.core.meta.call(null,G__18664)));
});
thi.ng.geom.vector.zzz = (function thi$ng$geom$vector$zzz(G__18667){
var G__18665 = (((G__18667 instanceof thi.ng.geom.vector.Vec2))?G__18667.buf:G__18667.buf);
var G__18666 = (new Float32Array(3));
(G__18666[(0)] = (G__18665[(2)]));

(G__18666[(1)] = (G__18665[(2)]));

(G__18666[(2)] = (G__18665[(2)]));

return (new thi.ng.geom.vector.Vec3(G__18666,null,cljs.core.meta.call(null,G__18667)));
});
thi.ng.geom.vector.swizzle2_fns = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"x","x",2099068185),thi.ng.geom.vector.x,new cljs.core.Keyword(null,"xx","xx",-1542203733),thi.ng.geom.vector.xx,new cljs.core.Keyword(null,"xy","xy",-696978232),thi.ng.geom.vector.xy,new cljs.core.Keyword(null,"y","y",-1757859776),thi.ng.geom.vector.y,new cljs.core.Keyword(null,"yx","yx",1696579752),thi.ng.geom.vector.yx,new cljs.core.Keyword(null,"yy","yy",-1432012814),thi.ng.geom.vector.yy], null);
thi.ng.geom.vector.swizzle3_fns = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"y","y",-1757859776),new cljs.core.Keyword(null,"xzx","xzx",-1000197983),new cljs.core.Keyword(null,"xyz","xyz",-1605570015),new cljs.core.Keyword(null,"zzy","zzy",-874287326),new cljs.core.Keyword(null,"yx","yx",1696579752),new cljs.core.Keyword(null,"xy","xy",-696978232),new cljs.core.Keyword(null,"yyz","yyz",1133968296),new cljs.core.Keyword(null,"zxy","zxy",-1258840183),new cljs.core.Keyword(null,"xzy","xzy",1043177385),new cljs.core.Keyword(null,"zxz","zxz",1026042602),new cljs.core.Keyword(null,"zx","zx",-933582998),new cljs.core.Keyword(null,"xx","xx",-1542203733),new cljs.core.Keyword(null,"xxx","xxx",-1019301908),new cljs.core.Keyword(null,"zy","zy",-1975963090),new cljs.core.Keyword(null,"zzx","zzx",20750383),new cljs.core.Keyword(null,"zyx","zyx",1752527951),new cljs.core.Keyword(null,"yzx","yzx",-1496223025),new cljs.core.Keyword(null,"z","z",-789527183),new cljs.core.Keyword(null,"yyx","yyx",-1318218191),new cljs.core.Keyword(null,"xz","xz",426487154),new cljs.core.Keyword(null,"zyz","zyz",-1838068142),new cljs.core.Keyword(null,"yy","yy",-1432012814),new cljs.core.Keyword(null,"xxz","xxz",129827699),new cljs.core.Keyword(null,"yzy","yzy",-179510251),new cljs.core.Keyword(null,"yz","yz",679015029),new cljs.core.Keyword(null,"yxx","yxx",-332290091),new cljs.core.Keyword(null,"xyy","xyy",996073014),new cljs.core.Keyword(null,"xxy","xxy",-650102026),new cljs.core.Keyword(null,"zz","zz",122901783),new cljs.core.Keyword(null,"zzz","zzz",-77420552),new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"xzz","xzz",-643126693),new cljs.core.Keyword(null,"yxz","yxz",1786796508),new cljs.core.Keyword(null,"zxx","zxx",-61980804),new cljs.core.Keyword(null,"yzz","yzz",-1034441732),new cljs.core.Keyword(null,"xyx","xyx",1899467293),new cljs.core.Keyword(null,"yxy","yxy",1369901661),new cljs.core.Keyword(null,"yyy","yyy",780595422),new cljs.core.Keyword(null,"zyy","zyy",1946268991)],[thi.ng.geom.vector.y,thi.ng.geom.vector.xzx,thi.ng.geom.vector.xyz,thi.ng.geom.vector.zzy,thi.ng.geom.vector.yx,thi.ng.geom.vector.xy,thi.ng.geom.vector.yyz,thi.ng.geom.vector.zxy,thi.ng.geom.vector.xzy,thi.ng.geom.vector.zxz,thi.ng.geom.vector.zx,thi.ng.geom.vector.xx,thi.ng.geom.vector.xxx,thi.ng.geom.vector.zy,thi.ng.geom.vector.zzx,thi.ng.geom.vector.zyx,thi.ng.geom.vector.yzx,thi.ng.geom.vector.z,thi.ng.geom.vector.yyx,thi.ng.geom.vector.xz,thi.ng.geom.vector.zyz,thi.ng.geom.vector.yy,thi.ng.geom.vector.xxz,thi.ng.geom.vector.yzy,thi.ng.geom.vector.yz,thi.ng.geom.vector.yxx,thi.ng.geom.vector.xyy,thi.ng.geom.vector.xxy,thi.ng.geom.vector.zz,thi.ng.geom.vector.zzz,thi.ng.geom.vector.x,thi.ng.geom.vector.xzz,thi.ng.geom.vector.yxz,thi.ng.geom.vector.zxx,thi.ng.geom.vector.yzz,thi.ng.geom.vector.xyx,thi.ng.geom.vector.yxy,thi.ng.geom.vector.yyy,thi.ng.geom.vector.zyy]);
thi.ng.geom.vector.swizzle_assoc_STAR_ = (function thi$ng$geom$vector$swizzle_assoc_STAR_(src,dest,keymap,k,v){
var n = cljs.core.name.call(null,k);
var c = cljs.core.count.call(null,n);
var temp__5802__auto__ = (function (){var and__4120__auto__ = ((1) === c);
if(and__4120__auto__){
return keymap.call(null,cljs.core.first.call(null,n));
} else {
return and__4120__auto__;
}
})();
if(cljs.core.truth_(temp__5802__auto__)){
var idx = temp__5802__auto__;
(dest[(idx | (0))] = v);

return dest;
} else {
if((((c <= cljs.core.count.call(null,keymap))) && ((((c === cljs.core.count.call(null,v))) && ((cljs.core.count.call(null,v) === cljs.core.count.call(null,cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,n)))))))){
var i = (0);
var n__$1 = n;
while(true){
if(cljs.core.truth_(n__$1)){
var temp__5802__auto____$1 = keymap.call(null,cljs.core.first.call(null,n__$1));
if(cljs.core.truth_(temp__5802__auto____$1)){
var idx = temp__5802__auto____$1;
(dest[(idx | (0))] = v.call(null,i));

var G__18668 = (i + (1));
var G__18669 = cljs.core.next.call(null,n__$1);
i = G__18668;
n__$1 = G__18669;
continue;
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,k);
}
} else {
return dest;
}
break;
}
} else {
return thi.ng.xerror.core.key_error_BANG_.call(null,k);
}
}
});
thi.ng.geom.vector.vec2_reduce_STAR_ = (function thi$ng$geom$vector$vec2_reduce_STAR_(op,acc,xs){
return cljs.core.transduce.call(null,cljs.core.map.call(null,(function (x){
return x.buf;
})),(function() {
var G__18670 = null;
var G__18670__1 = (function (a){
return a;
});
var G__18670__2 = (function (a,b){
(a[(0)] = op.call(null,(a[(0)]),(b[(0)])));

(a[(1)] = op.call(null,(a[(1)]),(b[(1)])));

return a;
});
G__18670 = function(a,b){
switch(arguments.length){
case 1:
return G__18670__1.call(this,a);
case 2:
return G__18670__2.call(this,a,b);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18670.cljs$core$IFn$_invoke$arity$1 = G__18670__1;
G__18670.cljs$core$IFn$_invoke$arity$2 = G__18670__2;
return G__18670;
})()
,acc,xs);
});
thi.ng.geom.vector.vec3_reduce_STAR_ = (function thi$ng$geom$vector$vec3_reduce_STAR_(op,acc,xs){
return cljs.core.transduce.call(null,cljs.core.map.call(null,(function (x){
return x.buf;
})),(function() {
var G__18671 = null;
var G__18671__1 = (function (a){
return a;
});
var G__18671__2 = (function (a,b){
(a[(0)] = op.call(null,(a[(0)]),(b[(0)])));

(a[(1)] = op.call(null,(a[(1)]),(b[(1)])));

(a[(2)] = op.call(null,(a[(2)]),(b[(2)])));

return a;
});
G__18671 = function(a,b){
switch(arguments.length){
case 1:
return G__18671__1.call(this,a);
case 2:
return G__18671__2.call(this,a,b);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18671.cljs$core$IFn$_invoke$arity$1 = G__18671__1;
G__18671.cljs$core$IFn$_invoke$arity$2 = G__18671__2;
return G__18671;
})()
,acc,xs);
});
thi.ng.geom.vector.V2 = (new thi.ng.geom.vector.Vec2((new Float32Array((2))),null,null));
thi.ng.geom.vector.V3 = (new thi.ng.geom.vector.Vec3((new Float32Array((3))),null,null));
thi.ng.geom.vector.vec2 = (function thi$ng$geom$vector$vec2(var_args){
var G__18673 = arguments.length;
switch (G__18673) {
case 0:
return thi.ng.geom.vector.vec2.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return thi.ng.geom.vector.vec2.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return thi.ng.geom.vector.vec2.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

thi.ng.geom.vector.vec2.cljs$core$IFn$_invoke$arity$0 = (function (){
return thi.ng.geom.vector.V2;
});

thi.ng.geom.vector.vec2.cljs$core$IFn$_invoke$arity$1 = (function (v){
if((v instanceof thi.ng.geom.vector.Vec2)){
return v;
} else {
if(typeof v === 'number'){
return thi.ng.geom.vector.vec2.call(null,v,v);
} else {
if(cljs.core.sequential_QMARK_.call(null,v)){
return thi.ng.geom.vector.vec2.call(null,cljs.core.nth.call(null,v,(0),0.0),cljs.core.nth.call(null,v,(1),0.0));
} else {
if(cljs.core.map_QMARK_.call(null,v)){
return thi.ng.geom.vector.vec2.call(null,cljs.core.get.call(null,v,new cljs.core.Keyword(null,"x","x",2099068185),(0)),cljs.core.get.call(null,v,new cljs.core.Keyword(null,"y","y",-1757859776),(0)));
} else {
return thi.ng.xerror.core.type_error_BANG_.call(null,"Vec2",v);

}
}
}
}
});

thi.ng.geom.vector.vec2.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
var b = (new Float32Array((2)));
(b[(0)] = x);

(b[(1)] = y);

return (new thi.ng.geom.vector.Vec2(b,null,null));
});

thi.ng.geom.vector.vec2.cljs$lang$maxFixedArity = 2;

thi.ng.geom.vector.vec3 = (function thi$ng$geom$vector$vec3(var_args){
var G__18676 = arguments.length;
switch (G__18676) {
case 0:
return thi.ng.geom.vector.vec3.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return thi.ng.geom.vector.vec3.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return thi.ng.geom.vector.vec3.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return thi.ng.geom.vector.vec3.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

thi.ng.geom.vector.vec3.cljs$core$IFn$_invoke$arity$0 = (function (){
return thi.ng.geom.vector.V3;
});

thi.ng.geom.vector.vec3.cljs$core$IFn$_invoke$arity$1 = (function (v){
if((v instanceof thi.ng.geom.vector.Vec3)){
return v;
} else {
if(typeof v === 'number'){
return thi.ng.geom.vector.vec3.call(null,v,v,v);
} else {
if(cljs.core.sequential_QMARK_.call(null,v)){
return thi.ng.geom.vector.vec3.call(null,cljs.core.nth.call(null,v,(0),0.0),cljs.core.nth.call(null,v,(1),0.0),cljs.core.nth.call(null,v,(2),0.0));
} else {
if(cljs.core.map_QMARK_.call(null,v)){
return thi.ng.geom.vector.vec3.call(null,cljs.core.get.call(null,v,new cljs.core.Keyword(null,"x","x",2099068185),0.0),cljs.core.get.call(null,v,new cljs.core.Keyword(null,"y","y",-1757859776),0.0),cljs.core.get.call(null,v,new cljs.core.Keyword(null,"z","z",-789527183),0.0));
} else {
return thi.ng.xerror.core.type_error_BANG_.call(null,"Vec3",v);

}
}
}
}
});

thi.ng.geom.vector.vec3.cljs$core$IFn$_invoke$arity$2 = (function (v,z){
if(cljs.core.sequential_QMARK_.call(null,v)){
return thi.ng.geom.vector.vec3.call(null,cljs.core.nth.call(null,v,(0),0.0),cljs.core.nth.call(null,v,(1),0.0),z);
} else {
if(cljs.core.map_QMARK_.call(null,v)){
return thi.ng.geom.vector.vec3.call(null,cljs.core.get.call(null,v,new cljs.core.Keyword(null,"x","x",2099068185),0.0),cljs.core.get.call(null,v,new cljs.core.Keyword(null,"y","y",-1757859776),0.0),z);
} else {
if(typeof v === 'number'){
return thi.ng.geom.vector.vec3.call(null,v,z,(0));
} else {
return thi.ng.xerror.core.type_error_BANG_.call(null,"Vec3",v);

}
}
}
});

thi.ng.geom.vector.vec3.cljs$core$IFn$_invoke$arity$3 = (function (x,y,z){
var b = (new Float32Array((3)));
(b[(0)] = x);

(b[(1)] = y);

(b[(2)] = z);

return (new thi.ng.geom.vector.Vec3(b,null,null));
});

thi.ng.geom.vector.vec3.cljs$lang$maxFixedArity = 3;

thi.ng.geom.vector.vec2_with_meta = (function thi$ng$geom$vector$vec2_with_meta(var_args){
var G__18679 = arguments.length;
switch (G__18679) {
case 2:
return thi.ng.geom.vector.vec2_with_meta.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return thi.ng.geom.vector.vec2_with_meta.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

thi.ng.geom.vector.vec2_with_meta.cljs$core$IFn$_invoke$arity$2 = (function (v,meta){
if((v instanceof thi.ng.geom.vector.Vec2)){
return cljs.core.with_meta.call(null,v,meta);
} else {
if(typeof v === 'number'){
return thi.ng.geom.vector.vec2_with_meta.call(null,v,v,meta);
} else {
if(cljs.core.sequential_QMARK_.call(null,v)){
return thi.ng.geom.vector.vec2_with_meta.call(null,cljs.core.nth.call(null,v,(0),0.0),cljs.core.nth.call(null,v,(1),0.0),meta);
} else {
if(cljs.core.map_QMARK_.call(null,v)){
return thi.ng.geom.vector.vec2_with_meta.call(null,cljs.core.get.call(null,v,new cljs.core.Keyword(null,"x","x",2099068185),0.0),cljs.core.get.call(null,v,new cljs.core.Keyword(null,"y","y",-1757859776),0.0),meta);
} else {
return thi.ng.xerror.core.type_error_BANG_.call(null,"Vec2",v);

}
}
}
}
});

thi.ng.geom.vector.vec2_with_meta.cljs$core$IFn$_invoke$arity$3 = (function (x,y,meta){
var b = (new Float32Array((2)));
(b[(0)] = x);

(b[(1)] = y);

return (new thi.ng.geom.vector.Vec2(b,null,meta));
});

thi.ng.geom.vector.vec2_with_meta.cljs$lang$maxFixedArity = 3;

thi.ng.geom.vector.vec3_with_meta = (function thi$ng$geom$vector$vec3_with_meta(var_args){
var G__18682 = arguments.length;
switch (G__18682) {
case 2:
return thi.ng.geom.vector.vec3_with_meta.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return thi.ng.geom.vector.vec3_with_meta.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

thi.ng.geom.vector.vec3_with_meta.cljs$core$IFn$_invoke$arity$2 = (function (v,meta){
if((v instanceof thi.ng.geom.vector.Vec3)){
return cljs.core.with_meta.call(null,v,meta);
} else {
if(typeof v === 'number'){
return thi.ng.geom.vector.vec3_with_meta.call(null,v,v,v,meta);
} else {
if(cljs.core.sequential_QMARK_.call(null,v)){
return thi.ng.geom.vector.vec3_with_meta.call(null,cljs.core.nth.call(null,v,(0),0.0),cljs.core.nth.call(null,v,(1),0.0),cljs.core.nth.call(null,v,(2),0.0),meta);
} else {
if(cljs.core.map_QMARK_.call(null,v)){
return thi.ng.geom.vector.vec3_with_meta.call(null,cljs.core.get.call(null,v,new cljs.core.Keyword(null,"x","x",2099068185),0.0),cljs.core.get.call(null,v,new cljs.core.Keyword(null,"y","y",-1757859776),0.0),cljs.core.get.call(null,v,new cljs.core.Keyword(null,"z","z",-789527183),0.0),meta);
} else {
return thi.ng.xerror.core.type_error_BANG_.call(null,"Vec3",v);

}
}
}
}
});

thi.ng.geom.vector.vec3_with_meta.cljs$core$IFn$_invoke$arity$4 = (function (x,y,z,meta){
var b = (new Float32Array((3)));
(b[(0)] = x);

(b[(1)] = y);

(b[(2)] = z);

return (new thi.ng.geom.vector.Vec3(b,null,meta));
});

thi.ng.geom.vector.vec3_with_meta.cljs$lang$maxFixedArity = 4;

thi.ng.geom.vector.vec2_QMARK_ = (function thi$ng$geom$vector$vec2_QMARK_(x){
return (x instanceof thi.ng.geom.vector.Vec2);
});
thi.ng.geom.vector.vec3_QMARK_ = (function thi$ng$geom$vector$vec3_QMARK_(x){
return (x instanceof thi.ng.geom.vector.Vec3);
});
thi.ng.geom.vector.V2X = thi.ng.geom.vector.vec2.call(null,(1),(0));
thi.ng.geom.vector.V2Y = thi.ng.geom.vector.vec2.call(null,(0),(1));
thi.ng.geom.vector.V3X = thi.ng.geom.vector.vec3.call(null,(1),(0),(0));
thi.ng.geom.vector.V3Y = thi.ng.geom.vector.vec3.call(null,(0),(1),(0));
thi.ng.geom.vector.V3Z = thi.ng.geom.vector.vec3.call(null,(0),(0),(1));
thi.ng.geom.vector.V2INF_ = thi.ng.geom.vector.vec2.call(null,thi.ng.math.core.INF_);
thi.ng.geom.vector.V2INF_PLUS_ = thi.ng.geom.vector.vec2.call(null,thi.ng.math.core.INF_PLUS_);
thi.ng.geom.vector.V3INF_ = thi.ng.geom.vector.vec3.call(null,thi.ng.math.core.INF_);
thi.ng.geom.vector.V3INF_PLUS_ = thi.ng.geom.vector.vec3.call(null,thi.ng.math.core.INF_PLUS_);
thi.ng.geom.vector.randvec2 = (function thi$ng$geom$vector$randvec2(var_args){
var G__18685 = arguments.length;
switch (G__18685) {
case 0:
return thi.ng.geom.vector.randvec2.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return thi.ng.geom.vector.randvec2.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

thi.ng.geom.vector.randvec2.cljs$core$IFn$_invoke$arity$0 = (function (){
return thi.ng.math.core.normalize.call(null,thi.ng.geom.vector.vec2.call(null,thi.ng.math.core.randnorm.call(null),thi.ng.math.core.randnorm.call(null)));
});

thi.ng.geom.vector.randvec2.cljs$core$IFn$_invoke$arity$1 = (function (n){
return thi.ng.math.core.normalize.call(null,thi.ng.geom.vector.vec2.call(null,thi.ng.math.core.randnorm.call(null),thi.ng.math.core.randnorm.call(null)),n);
});

thi.ng.geom.vector.randvec2.cljs$lang$maxFixedArity = 1;

thi.ng.geom.vector.randvec3 = (function thi$ng$geom$vector$randvec3(var_args){
var G__18688 = arguments.length;
switch (G__18688) {
case 0:
return thi.ng.geom.vector.randvec3.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return thi.ng.geom.vector.randvec3.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

thi.ng.geom.vector.randvec3.cljs$core$IFn$_invoke$arity$0 = (function (){
return thi.ng.math.core.normalize.call(null,thi.ng.geom.vector.vec3.call(null,thi.ng.math.core.randnorm.call(null),thi.ng.math.core.randnorm.call(null),thi.ng.math.core.randnorm.call(null)));
});

thi.ng.geom.vector.randvec3.cljs$core$IFn$_invoke$arity$1 = (function (n){
return thi.ng.math.core.normalize.call(null,thi.ng.geom.vector.vec3.call(null,thi.ng.math.core.randnorm.call(null),thi.ng.math.core.randnorm.call(null),thi.ng.math.core.randnorm.call(null)),n);
});

thi.ng.geom.vector.randvec3.cljs$lang$maxFixedArity = 1;


//# sourceMappingURL=vector.js.map
