// Compiled by ClojureScript 1.10.516 {}
goog.provide('reagent.dom');
goog.require('cljs.core');
goog.require('react_dom');
goog.require('reagent.impl.util');
goog.require('reagent.impl.template');
goog.require('reagent.impl.batching');
goog.require('reagent.impl.protocols');
goog.require('reagent.ratom');
reagent.dom.global$module$react_dom = goog.global["ReactDOM"];
if((typeof reagent !== 'undefined') && (typeof reagent.dom !== 'undefined') && (typeof reagent.dom.roots !== 'undefined')){
} else {
reagent.dom.roots = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
reagent.dom.unmount_comp = (function reagent$dom$unmount_comp(container){
cljs.core.swap_BANG_.call(null,reagent.dom.roots,cljs.core.dissoc,container);

return reagent.dom.global$module$react_dom.unmountComponentAtNode.call(null,container);
});
reagent.dom.render_comp = (function reagent$dom$render_comp(comp,container,callback){
var _STAR_always_update_STAR__orig_val__23342 = reagent.impl.util._STAR_always_update_STAR_;
var _STAR_always_update_STAR__temp_val__23343 = true;
reagent.impl.util._STAR_always_update_STAR_ = _STAR_always_update_STAR__temp_val__23343;

try{return reagent.dom.global$module$react_dom.render.call(null,comp.call(null),container,((function (_STAR_always_update_STAR__orig_val__23342,_STAR_always_update_STAR__temp_val__23343){
return (function (){
var _STAR_always_update_STAR__orig_val__23344 = reagent.impl.util._STAR_always_update_STAR_;
var _STAR_always_update_STAR__temp_val__23345 = false;
reagent.impl.util._STAR_always_update_STAR_ = _STAR_always_update_STAR__temp_val__23345;

try{cljs.core.swap_BANG_.call(null,reagent.dom.roots,cljs.core.assoc,container,comp);

reagent.impl.batching.flush_after_render.call(null);

if((!((callback == null)))){
return callback.call(null);
} else {
return null;
}
}finally {reagent.impl.util._STAR_always_update_STAR_ = _STAR_always_update_STAR__orig_val__23344;
}});})(_STAR_always_update_STAR__orig_val__23342,_STAR_always_update_STAR__temp_val__23343))
);
}finally {reagent.impl.util._STAR_always_update_STAR_ = _STAR_always_update_STAR__orig_val__23342;
}});
reagent.dom.re_render_component = (function reagent$dom$re_render_component(comp,container){
return reagent.dom.render_comp.call(null,comp,container,null);
});
/**
 * Render a Reagent component into the DOM. The first argument may be
 *   either a vector (using Reagent's Hiccup syntax), or a React element.
 *   The second argument should be a DOM node.
 * 
 *   Optionally takes a callback that is called when the component is in place.
 * 
 *   Returns the mounted component instance.
 */
reagent.dom.render = (function reagent$dom$render(var_args){
var G__23347 = arguments.length;
switch (G__23347) {
case 2:
return reagent.dom.render.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return reagent.dom.render.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

reagent.dom.render.cljs$core$IFn$_invoke$arity$2 = (function (comp,container){
return reagent.dom.render.call(null,comp,container,reagent.impl.template._STAR_current_default_compiler_STAR_);
});

reagent.dom.render.cljs$core$IFn$_invoke$arity$3 = (function (comp,container,callback_or_compiler){
reagent.ratom.flush_BANG_.call(null);

var vec__23348 = ((cljs.core.map_QMARK_.call(null,callback_or_compiler))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compiler","compiler",-267926731).cljs$core$IFn$_invoke$arity$1(callback_or_compiler),new cljs.core.Keyword(null,"callback","callback",-705136228).cljs$core$IFn$_invoke$arity$1(callback_or_compiler)], null):((cljs.core.fn_QMARK_.call(null,callback_or_compiler))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [reagent.impl.template._STAR_current_default_compiler_STAR_,callback_or_compiler], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [callback_or_compiler,null], null)
));
var compiler = cljs.core.nth.call(null,vec__23348,(0),null);
var callback = cljs.core.nth.call(null,vec__23348,(1),null);
var f = ((function (vec__23348,compiler,callback){
return (function (){
return reagent.impl.protocols.as_element.call(null,compiler,((cljs.core.fn_QMARK_.call(null,comp))?comp.call(null):comp));
});})(vec__23348,compiler,callback))
;
return reagent.dom.render_comp.call(null,f,container,callback);
});

reagent.dom.render.cljs$lang$maxFixedArity = 3;

/**
 * Remove a component from the given DOM node.
 */
reagent.dom.unmount_component_at_node = (function reagent$dom$unmount_component_at_node(container){
return reagent.dom.unmount_comp.call(null,container);
});
/**
 * Returns the root DOM node of a mounted component.
 */
reagent.dom.dom_node = (function reagent$dom$dom_node(this$){
return reagent.dom.global$module$react_dom.findDOMNode.call(null,this$);
});
/**
 * Force re-rendering of all mounted Reagent components. This is
 *   probably only useful in a development environment, when you want to
 *   update components in response to some dynamic changes to code.
 * 
 *   Note that force-update-all may not update root components. This
 *   happens if a component 'foo' is mounted with `(render [foo])` (since
 *   functions are passed by value, and not by reference, in
 *   ClojureScript). To get around this you'll have to introduce a layer
 *   of indirection, for example by using `(render [#'foo])` instead.
 */
reagent.dom.force_update_all = (function reagent$dom$force_update_all(){
reagent.ratom.flush_BANG_.call(null);

var seq__23352_23368 = cljs.core.seq.call(null,cljs.core.deref.call(null,reagent.dom.roots));
var chunk__23353_23369 = null;
var count__23354_23370 = (0);
var i__23355_23371 = (0);
while(true){
if((i__23355_23371 < count__23354_23370)){
var vec__23362_23372 = cljs.core._nth.call(null,chunk__23353_23369,i__23355_23371);
var container_23373 = cljs.core.nth.call(null,vec__23362_23372,(0),null);
var comp_23374 = cljs.core.nth.call(null,vec__23362_23372,(1),null);
reagent.dom.re_render_component.call(null,comp_23374,container_23373);


var G__23375 = seq__23352_23368;
var G__23376 = chunk__23353_23369;
var G__23377 = count__23354_23370;
var G__23378 = (i__23355_23371 + (1));
seq__23352_23368 = G__23375;
chunk__23353_23369 = G__23376;
count__23354_23370 = G__23377;
i__23355_23371 = G__23378;
continue;
} else {
var temp__5804__auto___23379 = cljs.core.seq.call(null,seq__23352_23368);
if(temp__5804__auto___23379){
var seq__23352_23380__$1 = temp__5804__auto___23379;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__23352_23380__$1)){
var c__4550__auto___23381 = cljs.core.chunk_first.call(null,seq__23352_23380__$1);
var G__23382 = cljs.core.chunk_rest.call(null,seq__23352_23380__$1);
var G__23383 = c__4550__auto___23381;
var G__23384 = cljs.core.count.call(null,c__4550__auto___23381);
var G__23385 = (0);
seq__23352_23368 = G__23382;
chunk__23353_23369 = G__23383;
count__23354_23370 = G__23384;
i__23355_23371 = G__23385;
continue;
} else {
var vec__23365_23386 = cljs.core.first.call(null,seq__23352_23380__$1);
var container_23387 = cljs.core.nth.call(null,vec__23365_23386,(0),null);
var comp_23388 = cljs.core.nth.call(null,vec__23365_23386,(1),null);
reagent.dom.re_render_component.call(null,comp_23388,container_23387);


var G__23389 = cljs.core.next.call(null,seq__23352_23380__$1);
var G__23390 = null;
var G__23391 = (0);
var G__23392 = (0);
seq__23352_23368 = G__23389;
chunk__23353_23369 = G__23390;
count__23354_23370 = G__23391;
i__23355_23371 = G__23392;
continue;
}
} else {
}
}
break;
}

return reagent.impl.batching.flush_after_render.call(null);
});

//# sourceMappingURL=dom.js.map
