// Compiled by ClojureScript 1.10.516 {}
goog.provide('net.mynarz.az_kviz.view');
goog.require('cljs.core');
goog.require('net.mynarz.az_kviz.logic');
goog.require('net.mynarz.az_kviz.spec');
goog.require('net.mynarz.az_kviz.util');
goog.require('cljs.spec.alpha');
goog.require('goog.string.format');
goog.require('thi.ng.color.core');
goog.require('thi.ng.geom.svg.core');
goog.require('thi.ng.math.core');
net.mynarz.az_kviz.view.board_config = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),(function (_){
return null;
}),new cljs.core.Keyword(null,"side","side",389652279),(7),new cljs.core.Keyword(null,"tile-config","tile-config",626525118),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"colours","colours",659341642),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"active","active",1895962068),"#dedede",new cljs.core.Keyword(null,"default","default",-1987822328),"#ccc",new cljs.core.Keyword(null,"hover","hover",-341141711),"#dedede",new cljs.core.Keyword(null,"hover-missed","hover-missed",-1243612131),"#4d4d4d",new cljs.core.Keyword(null,"missed","missed",-318745819),"#333",new cljs.core.Keyword(null,"player-1","player-1",-857374100),"#e40000",new cljs.core.Keyword(null,"player-2","player-2",-227455796),"#354d65"], null),new cljs.core.Keyword(null,"hex-shade","hex-shade",-423751210),0.8,new cljs.core.Keyword(null,"inner-hex-size","inner-hex-size",-1374708855),0.87,new cljs.core.Keyword(null,"radius","radius",-2073122258),(35),new cljs.core.Keyword(null,"spacing","spacing",204422175),0.05,new cljs.core.Keyword(null,"stroke-width","stroke-width",716836435),(1)], null)], null);
net.mynarz.az_kviz.view.format = goog.string.format;
net.mynarz.az_kviz.view.right_angle = (Math.PI / (2));
net.mynarz.az_kviz.view.sqrt_3 = Math.sqrt((3));
net.mynarz.az_kviz.view.drop_shadow = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"filter#drop-shadow","filter#drop-shadow",1010220226),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"feDropShadow","feDropShadow",1235689578),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"dx","dx",-381796732),(1),new cljs.core.Keyword(null,"dy","dy",1719547243),(1),new cljs.core.Keyword(null,"floodColor","floodColor",836634770),"#000",new cljs.core.Keyword(null,"stdDeviation","stdDeviation",1418775521),(2)], null)], null)], null);
net.mynarz.az_kviz.view.white_etch = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"filter#white-etch","filter#white-etch",1070983955),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"feDropShadow","feDropShadow",1235689578),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"dx","dx",-381796732),(0),new cljs.core.Keyword(null,"dy","dy",1719547243),(2),new cljs.core.Keyword(null,"floodColor","floodColor",836634770),"#fff",new cljs.core.Keyword(null,"stdDeviation","stdDeviation",1418775521),(0)], null)], null)], null);
/**
 * Lighten a CSS `colour`, such as #ff69b4, by `amount` from [0, 1].
 */
net.mynarz.az_kviz.view.lighten = (function net$mynarz$az_kviz$view$lighten(colour,amount){
return cljs.core.deref.call(null,thi.ng.color.core.as_css.call(null,thi.ng.math.core.mix.call(null,thi.ng.color.core.css.call(null,colour),thi.ng.color.core.WHITE,amount)));
});
/**
 * Generate points of a regular polygon that has a number of `sides`,
 *   is centered at the `center` [x, y], and spans the `radius`.
 */
net.mynarz.az_kviz.view.regular_polygon = (function net$mynarz$az_kviz$view$regular_polygon(sides,radius,p__23254){
var vec__23255 = p__23254;
var x = cljs.core.nth.call(null,vec__23255,(0),null);
var y = cljs.core.nth.call(null,vec__23255,(1),null);
var inner_angle = (((2) * Math.PI) / sides);
var point_x = ((function (inner_angle,vec__23255,x,y){
return (function (angle){
return (x + (radius * Math.cos(angle)));
});})(inner_angle,vec__23255,x,y))
;
var point_y = ((function (inner_angle,point_x,vec__23255,x,y){
return (function (angle){
return (y + (radius * Math.sin(angle)));
});})(inner_angle,point_x,vec__23255,x,y))
;
var point = ((function (inner_angle,point_x,point_y,vec__23255,x,y){
return (function (side){
var angle = (net.mynarz.az_kviz.view.right_angle + (inner_angle * side));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [point_x.call(null,angle),point_y.call(null,angle)], null);
});})(inner_angle,point_x,point_y,vec__23255,x,y))
;
return cljs.core.map.call(null,point,cljs.core.rest.call(null,cljs.core.range.call(null,(sides + (1)))));
});
net.mynarz.az_kviz.view.hexagon = cljs.core.partial.call(null,net.mynarz.az_kviz.view.regular_polygon,(6));
/**
 * An AZ-kvíz tile.
 *   `center` are the [x y] coordinates of the tile.
 *   `inner` is the collection of [x y] points for the inner hexagon.
 *   `outer` is the collection of [x y] points for the outer hexagon.
 *   `radius` is the tile radius from its centre to its edge.
 *   `status` is the state of the tile as a keyword.
 *   `svg` is the custom SVG markup to show in the tile.
 *   `svg-attrs` are the pre-computed attributes (position) for `svg`.
 *   `text` is the text to show in the tile.
 */
net.mynarz.az_kviz.view.tile = (function net$mynarz$az_kviz$view$tile(p__23258){
var map__23259 = p__23258;
var map__23259__$1 = (((((!((map__23259 == null))))?(((((map__23259.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23259.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23259):map__23259);
var outer = cljs.core.get.call(null,map__23259__$1,new cljs.core.Keyword(null,"outer","outer",-375185956));
var classes = cljs.core.get.call(null,map__23259__$1,new cljs.core.Keyword(null,"classes","classes",2037804510));
var text = cljs.core.get.call(null,map__23259__$1,new cljs.core.Keyword(null,"text","text",-1790561697));
var svg_attrs = cljs.core.get.call(null,map__23259__$1,new cljs.core.Keyword(null,"svg-attrs","svg-attrs",524765772));
var radius = cljs.core.get.call(null,map__23259__$1,new cljs.core.Keyword(null,"radius","radius",-2073122258));
var center = cljs.core.get.call(null,map__23259__$1,new cljs.core.Keyword(null,"center","center",-748944368));
var inner = cljs.core.get.call(null,map__23259__$1,new cljs.core.Keyword(null,"inner","inner",-1383171215));
var status = cljs.core.get.call(null,map__23259__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var id = cljs.core.get.call(null,map__23259__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var svg = cljs.core.get.call(null,map__23259__$1,new cljs.core.Keyword(null,"svg","svg",856789142));
var outer_fill = net.mynarz.az_kviz.view.format.call(null,"url(#%s-outer)",cljs.core.name.call(null,status));
var inner_fill = net.mynarz.az_kviz.view.format.call(null,"url(#%s-inner)",cljs.core.name.call(null,status));
var font_size = (((cljs.core.count.call(null,text) < (3)))?radius:(radius * ((2) / (3))));
var available_QMARK_ = cljs.core.not.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"player-2","player-2",-227455796),null,new cljs.core.Keyword(null,"player-1","player-1",-857374100),null], null), null).call(null,status));
var all_classes = (function (){var G__23261 = cljs.core.conj.call(null,classes,"tile",cljs.core.name.call(null,status));
if(available_QMARK_){
return cljs.core.conj.call(null,G__23261,"available");
} else {
return G__23261;
}
})();
var transform_origin = cljs.core.apply.call(null,net.mynarz.az_kviz.view.format,"%dpx %dpx",center);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [thi.ng.geom.svg.core.group,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"class","class",-2030961996),all_classes,new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"transform-origin","transform-origin",-586167370),transform_origin], null)], null),cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [thi.ng.geom.svg.core.polygon,outer,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"class","class",-2030961996),"outer",new cljs.core.Keyword(null,"fill","fill",883462889),outer_fill], null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),"outer"], null)),cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [thi.ng.geom.svg.core.polygon,inner,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"class","class",-2030961996),"inner",new cljs.core.Keyword(null,"fill","fill",883462889),inner_fill], null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),"inner"], null)),(cljs.core.truth_(svg)?cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Keyword(null,"svg","svg",856789142),cljs.core.cons.call(null,svg_attrs,cljs.core.drop.call(null,(2),svg)))):new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [thi.ng.geom.svg.core.text,center,text,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"font-size","font-size",-1847940346),font_size], null)], null))], null);
});
/**
 * Generate SVG gradients for the given `status` and `colour`.
 *   Gradient shading amount is controlled by `hex-shade`.
 */
net.mynarz.az_kviz.view.status_gradients = (function net$mynarz$az_kviz$view$status_gradients(hex_shade,p__23262){
var vec__23263 = p__23262;
var status = cljs.core.nth.call(null,vec__23263,(0),null);
var colour = cljs.core.nth.call(null,vec__23263,(1),null);
var lighter_colour = net.mynarz.az_kviz.view.lighten.call(null,colour,hex_shade);
var stop = ((function (lighter_colour,vec__23263,status,colour){
return (function (offset,colour__$1){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"stop","stop",-2140911342),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"offset","offset",296498311),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset),"%"].join(''),new cljs.core.Keyword(null,"stop-color","stop-color",316173955),colour__$1], null)], null);
});})(lighter_colour,vec__23263,status,colour))
;
var start = stop.call(null,(0),colour);
var end = stop.call(null,(100),lighter_colour);
var gradient = ((function (lighter_colour,stop,start,end,vec__23263,status,colour){
return (function (suffix,attrs){
var id = [cljs.core.name.call(null,status),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(suffix)].join('');
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"linearGradient","linearGradient",1711964727),cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"id","id",-1388402092),id], null),attrs),start,end], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),id], null));
});})(lighter_colour,stop,start,end,vec__23263,status,colour))
;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gradient.call(null,"inner",new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"x1","x1",-1863922247),(0),new cljs.core.Keyword(null,"x2","x2",-1362513475),(0),new cljs.core.Keyword(null,"y1","y1",589123466),(0),new cljs.core.Keyword(null,"y2","y2",-718691301),(1)], null)),gradient.call(null,"outer",new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"x1","x1",-1863922247),(0),new cljs.core.Keyword(null,"x2","x2",-1362513475),(0),new cljs.core.Keyword(null,"y1","y1",589123466),(1),new cljs.core.Keyword(null,"y2","y2",-718691301),(0)], null))], null);
});
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("net.mynarz.az-kviz.view","board-args","net.mynarz.az-kviz.view/board-args",-149900957),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"tile-config","tile-config",626525118),new cljs.core.Keyword("net.mynarz.az-kviz.spec","tile-config","net.mynarz.az-kviz.spec/tile-config",-1942268785),new cljs.core.Keyword(null,"board-state","board-state",1654825192),new cljs.core.Keyword("net.mynarz.az-kviz.spec","board-state","net.mynarz.az-kviz.spec/board-state",-880676585)),cljs.spec.alpha.cat_impl.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tile-config","tile-config",626525118),new cljs.core.Keyword(null,"board-state","board-state",1654825192)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("net.mynarz.az-kviz.spec","tile-config","net.mynarz.az-kviz.spec/tile-config",-1942268785),new cljs.core.Keyword("net.mynarz.az-kviz.spec","board-state","net.mynarz.az-kviz.spec/board-state",-880676585)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("net.mynarz.az-kviz.spec","tile-config","net.mynarz.az-kviz.spec/tile-config",-1942268785),new cljs.core.Keyword("net.mynarz.az-kviz.spec","board-state","net.mynarz.az-kviz.spec/board-state",-880676585)], null)));
cljs.spec.alpha.def_impl.call(null,new cljs.core.Symbol("net.mynarz.az-kviz.view","board","net.mynarz.az-kviz.view/board",422579041,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","fspec","cljs.spec.alpha/fspec",-1289128341,null),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword("net.mynarz.az-kviz.view","board-args","net.mynarz.az-kviz.view/board-args",-149900957),new cljs.core.Keyword(null,"ret","ret",-468222814),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","fspec","cljs.spec.alpha/fspec",-1289128341,null),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword("net.mynarz.az-kviz.view","board-args","net.mynarz.az-kviz.view/board-args",-149900957),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Keyword("net.mynarz.az-kviz.spec","hiccup","net.mynarz.az-kviz.spec/hiccup",-1278917763))),cljs.spec.alpha.fspec_impl.call(null,cljs.spec.alpha.spec_impl.call(null,new cljs.core.Keyword("net.mynarz.az-kviz.view","board-args","net.mynarz.az-kviz.view/board-args",-149900957),new cljs.core.Keyword("net.mynarz.az-kviz.view","board-args","net.mynarz.az-kviz.view/board-args",-149900957),null,null),new cljs.core.Keyword("net.mynarz.az-kviz.view","board-args","net.mynarz.az-kviz.view/board-args",-149900957),cljs.spec.alpha.spec_impl.call(null,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","fspec","cljs.spec.alpha/fspec",-1289128341,null),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword("net.mynarz.az-kviz.view","board-args","net.mynarz.az-kviz.view/board-args",-149900957),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Keyword("net.mynarz.az-kviz.spec","hiccup","net.mynarz.az-kviz.spec/hiccup",-1278917763)),cljs.spec.alpha.fspec_impl.call(null,cljs.spec.alpha.spec_impl.call(null,new cljs.core.Keyword("net.mynarz.az-kviz.view","board-args","net.mynarz.az-kviz.view/board-args",-149900957),new cljs.core.Keyword("net.mynarz.az-kviz.view","board-args","net.mynarz.az-kviz.view/board-args",-149900957),null,null),new cljs.core.Keyword("net.mynarz.az-kviz.view","board-args","net.mynarz.az-kviz.view/board-args",-149900957),cljs.spec.alpha.spec_impl.call(null,new cljs.core.Keyword("net.mynarz.az-kviz.spec","hiccup","net.mynarz.az-kviz.spec/hiccup",-1278917763),new cljs.core.Keyword("net.mynarz.az-kviz.spec","hiccup","net.mynarz.az-kviz.spec/hiccup",-1278917763),null,null),new cljs.core.Keyword("net.mynarz.az-kviz.spec","hiccup","net.mynarz.az-kviz.spec/hiccup",-1278917763),null,null,null),null,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","fspec","cljs.spec.alpha/fspec",-1289128341,null),new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword("net.mynarz.az-kviz.view","board-args","net.mynarz.az-kviz.view/board-args",-149900957),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Keyword("net.mynarz.az-kviz.spec","hiccup","net.mynarz.az-kviz.spec/hiccup",-1278917763)),null,null,null));
net.mynarz.az_kviz.view.board = (function net$mynarz$az_kviz$view$board(config,state){
var map__23266 = ((cljs.core.seq.call(null,config))?net.mynarz.az_kviz.util.deep_merge.call(null,net.mynarz.az_kviz.view.board_config,config):net.mynarz.az_kviz.view.board_config);
var map__23266__$1 = (((((!((map__23266 == null))))?(((((map__23266.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23266.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23266):map__23266);
var map__23267 = cljs.core.get.call(null,map__23266__$1,new cljs.core.Keyword(null,"tile-config","tile-config",626525118));
var map__23267__$1 = (((((!((map__23267 == null))))?(((((map__23267.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23267.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23267):map__23267);
var r = cljs.core.get.call(null,map__23267__$1,new cljs.core.Keyword(null,"radius","radius",-2073122258));
var colours = cljs.core.get.call(null,map__23267__$1,new cljs.core.Keyword(null,"colours","colours",659341642));
var hex_shade = cljs.core.get.call(null,map__23267__$1,new cljs.core.Keyword(null,"hex-shade","hex-shade",-423751210));
var inner_hex_size = cljs.core.get.call(null,map__23267__$1,new cljs.core.Keyword(null,"inner-hex-size","inner-hex-size",-1374708855));
var spacing = cljs.core.get.call(null,map__23267__$1,new cljs.core.Keyword(null,"spacing","spacing",204422175));
var stroke_width = cljs.core.get.call(null,map__23267__$1,new cljs.core.Keyword(null,"stroke-width","stroke-width",716836435));
var n = cljs.core.get.call(null,map__23266__$1,new cljs.core.Keyword(null,"side","side",389652279));
var on_click = cljs.core.get.call(null,map__23266__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543));
var padding = r;
var inner_r = (r * inner_hex_size);
var y_space = (((2) * r) * spacing);
var x_space = (y_space * (net.mynarz.az_kviz.view.sqrt_3 / (2)));
var w = ((net.mynarz.az_kviz.view.sqrt_3 * r) + ((2) * stroke_width));
var h = (((2) * r) + ((2) * stroke_width));
var board_width = (((n * w) + ((n + (1)) * x_space)) + ((2) * padding));
var board_height = (((((2) * r) + ((((3) / (2)) * (n - (1))) * r)) + ((n + (1)) * y_space)) + ((2) * padding));
var x_offset = ((function (map__23266,map__23266__$1,map__23267,map__23267__$1,r,colours,hex_shade,inner_hex_size,spacing,stroke_width,n,on_click,padding,inner_r,y_space,x_space,w,h,board_width,board_height){
return (function (p__23270){
var vec__23271 = p__23270;
var x = cljs.core.nth.call(null,vec__23271,(0),null);
var y = cljs.core.nth.call(null,vec__23271,(1),null);
return (((((w / (2)) + (x * (w + x_space))) + ((n - (y + (1))) * (w / (2)))) + ((n - y) * (x_space / (2)))) + padding);
});})(map__23266,map__23266__$1,map__23267,map__23267__$1,r,colours,hex_shade,inner_hex_size,spacing,stroke_width,n,on_click,padding,inner_r,y_space,x_space,w,h,board_width,board_height))
;
var y_offset = ((function (map__23266,map__23266__$1,map__23267,map__23267__$1,r,colours,hex_shade,inner_hex_size,spacing,stroke_width,n,on_click,padding,inner_r,y_space,x_space,w,h,board_width,board_height,x_offset){
return (function (p__23274){
var vec__23275 = p__23274;
var _ = cljs.core.nth.call(null,vec__23275,(0),null);
var y = cljs.core.nth.call(null,vec__23275,(1),null);
return (((r + ((((3) / (2)) * r) * y)) + ((y + (1)) * y_space)) + padding);
});})(map__23266,map__23266__$1,map__23267,map__23267__$1,r,colours,hex_shade,inner_hex_size,spacing,stroke_width,n,on_click,padding,inner_r,y_space,x_space,w,h,board_width,board_height,x_offset))
;
var tile_points = ((function (map__23266,map__23266__$1,map__23267,map__23267__$1,r,colours,hex_shade,inner_hex_size,spacing,stroke_width,n,on_click,padding,inner_r,y_space,x_space,w,h,board_width,board_height,x_offset,y_offset){
return (function (p__23278){
var map__23279 = p__23278;
var map__23279__$1 = (((((!((map__23279 == null))))?(((((map__23279.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23279.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23279):map__23279);
var coords = cljs.core.get.call(null,map__23279__$1,new cljs.core.Keyword(null,"coords","coords",-599429112));
var id = cljs.core.get.call(null,map__23279__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var vec__23281 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x_offset.call(null,coords),y_offset.call(null,coords)], null);
var x = cljs.core.nth.call(null,vec__23281,(0),null);
var y = cljs.core.nth.call(null,vec__23281,(1),null);
var center = vec__23281;
var side = (r * ((3) - net.mynarz.az_kviz.view.sqrt_3));
var inner_side = (side * 0.8);
var half_side = (inner_side * 0.5);
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"center","center",-748944368),center,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"inner","inner",-1383171215),net.mynarz.az_kviz.view.hexagon.call(null,inner_r,center),new cljs.core.Keyword(null,"outer","outer",-375185956),net.mynarz.az_kviz.view.hexagon.call(null,r,center),new cljs.core.Keyword(null,"radius","radius",-2073122258),r,new cljs.core.Keyword(null,"svg-attrs","svg-attrs",524765772),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"width","width",-384071477),inner_side,new cljs.core.Keyword(null,"height","height",1025178622),inner_side,new cljs.core.Keyword(null,"view-box","view-box",-1792199155),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(100),(100)], null),new cljs.core.Keyword(null,"x","x",2099068185),(x - half_side),new cljs.core.Keyword(null,"y","y",-1757859776),(y - half_side)], null)], null);
});})(map__23266,map__23266__$1,map__23267,map__23267__$1,r,colours,hex_shade,inner_hex_size,spacing,stroke_width,n,on_click,padding,inner_r,y_space,x_space,w,h,board_width,board_height,x_offset,y_offset))
;
var board_data = cljs.core.map.call(null,tile_points,state);
var gradients = cljs.core.mapcat.call(null,cljs.core.partial.call(null,net.mynarz.az_kviz.view.status_gradients,hex_shade),colours);
var click_handler = ((function (map__23266,map__23266__$1,map__23267,map__23267__$1,r,colours,hex_shade,inner_hex_size,spacing,stroke_width,n,on_click,padding,inner_r,y_space,x_space,w,h,board_width,board_height,x_offset,y_offset,tile_points,board_data,gradients){
return (function (e){
var temp__5804__auto__ = e.target.closest("g.tile.available");
if(cljs.core.truth_(temp__5804__auto__)){
var tile = temp__5804__auto__;
return on_click.call(null,parseInt(tile.id));
} else {
return null;
}
});})(map__23266,map__23266__$1,map__23267,map__23267__$1,r,colours,hex_shade,inner_hex_size,spacing,stroke_width,n,on_click,padding,inner_r,y_space,x_space,w,h,board_width,board_height,x_offset,y_offset,tile_points,board_data,gradients))
;
var tile_fn = ((function (map__23266,map__23266__$1,map__23267,map__23267__$1,r,colours,hex_shade,inner_hex_size,spacing,stroke_width,n,on_click,padding,inner_r,y_space,x_space,w,h,board_width,board_height,x_offset,y_offset,tile_points,board_data,gradients,click_handler){
return (function (p__23284){
var map__23285 = p__23284;
var map__23285__$1 = (((((!((map__23285 == null))))?(((((map__23285.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23285.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23285):map__23285);
var args = map__23285__$1;
var id = cljs.core.get.call(null,map__23285__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [net.mynarz.az_kviz.view.tile,args], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),id], null));
});})(map__23266,map__23266__$1,map__23267,map__23267__$1,r,colours,hex_shade,inner_hex_size,spacing,stroke_width,n,on_click,padding,inner_r,y_space,x_space,w,h,board_width,board_height,x_offset,y_offset,tile_points,board_data,gradients,click_handler))
;
return ((function (map__23266,map__23266__$1,map__23267,map__23267__$1,r,colours,hex_shade,inner_hex_size,spacing,stroke_width,n,on_click,padding,inner_r,y_space,x_space,w,h,board_width,board_height,x_offset,y_offset,tile_points,board_data,gradients,click_handler,tile_fn){
return (function (_,state__$1){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg#az-kviz","svg#az-kviz",1322366947),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),click_handler,new cljs.core.Keyword(null,"viewBox","viewBox",-469489477),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),board_width,board_height], null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"defs","defs",1398449717),net.mynarz.az_kviz.view.drop_shadow,net.mynarz.az_kviz.view.white_etch,gradients], null),cljs.core.map.call(null,cljs.core.comp.call(null,tile_fn,cljs.core.merge),board_data,state__$1)], null);
});
;})(map__23266,map__23266__$1,map__23267,map__23267__$1,r,colours,hex_shade,inner_hex_size,spacing,stroke_width,n,on_click,padding,inner_r,y_space,x_space,w,h,board_width,board_height,x_offset,y_offset,tile_points,board_data,gradients,click_handler,tile_fn))
});

//# sourceMappingURL=view.js.map
