// Compiled by ClojureScript 1.10.516 {}
goog.provide('cljs.repl');
goog.require('cljs.core');
goog.require('cljs.spec.alpha');
goog.require('goog.string');
goog.require('goog.string.format');
cljs.repl.print_doc = (function cljs$repl$print_doc(p__19304){
var map__19305 = p__19304;
var map__19305__$1 = (((((!((map__19305 == null))))?(((((map__19305.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19305.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19305):map__19305);
var m = map__19305__$1;
var n = cljs.core.get.call(null,map__19305__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var nm = cljs.core.get.call(null,map__19305__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.println.call(null,"-------------------------");

cljs.core.println.call(null,(function (){var or__4131__auto__ = new cljs.core.Keyword(null,"spec","spec",347520401).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return [(function (){var temp__5720__auto__ = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(temp__5720__auto__)){
var ns = temp__5720__auto__;
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/"].join('');
} else {
return null;
}
})(),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(m))].join('');
}
})());

if(cljs.core.truth_(new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Protocol");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"forms","forms",2045992350).cljs$core$IFn$_invoke$arity$1(m))){
var seq__19307_19339 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"forms","forms",2045992350).cljs$core$IFn$_invoke$arity$1(m));
var chunk__19308_19340 = null;
var count__19309_19341 = (0);
var i__19310_19342 = (0);
while(true){
if((i__19310_19342 < count__19309_19341)){
var f_19343 = cljs.core._nth.call(null,chunk__19308_19340,i__19310_19342);
cljs.core.println.call(null,"  ",f_19343);


var G__19344 = seq__19307_19339;
var G__19345 = chunk__19308_19340;
var G__19346 = count__19309_19341;
var G__19347 = (i__19310_19342 + (1));
seq__19307_19339 = G__19344;
chunk__19308_19340 = G__19345;
count__19309_19341 = G__19346;
i__19310_19342 = G__19347;
continue;
} else {
var temp__5720__auto___19348 = cljs.core.seq.call(null,seq__19307_19339);
if(temp__5720__auto___19348){
var seq__19307_19349__$1 = temp__5720__auto___19348;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__19307_19349__$1)){
var c__4550__auto___19350 = cljs.core.chunk_first.call(null,seq__19307_19349__$1);
var G__19351 = cljs.core.chunk_rest.call(null,seq__19307_19349__$1);
var G__19352 = c__4550__auto___19350;
var G__19353 = cljs.core.count.call(null,c__4550__auto___19350);
var G__19354 = (0);
seq__19307_19339 = G__19351;
chunk__19308_19340 = G__19352;
count__19309_19341 = G__19353;
i__19310_19342 = G__19354;
continue;
} else {
var f_19355 = cljs.core.first.call(null,seq__19307_19349__$1);
cljs.core.println.call(null,"  ",f_19355);


var G__19356 = cljs.core.next.call(null,seq__19307_19349__$1);
var G__19357 = null;
var G__19358 = (0);
var G__19359 = (0);
seq__19307_19339 = G__19356;
chunk__19308_19340 = G__19357;
count__19309_19341 = G__19358;
i__19310_19342 = G__19359;
continue;
}
} else {
}
}
break;
}
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"arglists","arglists",1661989754).cljs$core$IFn$_invoke$arity$1(m))){
var arglists_19360 = new cljs.core.Keyword(null,"arglists","arglists",1661989754).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_((function (){var or__4131__auto__ = new cljs.core.Keyword(null,"macro","macro",-867863404).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return new cljs.core.Keyword(null,"repl-special-function","repl-special-function",1262603725).cljs$core$IFn$_invoke$arity$1(m);
}
})())){
cljs.core.prn.call(null,arglists_19360);
} else {
cljs.core.prn.call(null,((cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.first.call(null,arglists_19360)))?cljs.core.second.call(null,arglists_19360):arglists_19360));
}
} else {
}
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"special-form","special-form",-1326536374).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Special Form");

cljs.core.println.call(null," ",new cljs.core.Keyword(null,"doc","doc",1913296891).cljs$core$IFn$_invoke$arity$1(m));

if(cljs.core.contains_QMARK_.call(null,m,new cljs.core.Keyword(null,"url","url",276297046))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(m))){
return cljs.core.println.call(null,["\n  Please see http://clojure.org/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(m))].join(''));
} else {
return null;
}
} else {
return cljs.core.println.call(null,["\n  Please see http://clojure.org/special_forms#",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(m))].join(''));
}
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"macro","macro",-867863404).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Macro");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"spec","spec",347520401).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Spec");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-special-function","repl-special-function",1262603725).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"REPL Special Function");
} else {
}

cljs.core.println.call(null," ",new cljs.core.Keyword(null,"doc","doc",1913296891).cljs$core$IFn$_invoke$arity$1(m));

if(cljs.core.truth_(new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(m))){
var seq__19311_19361 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"methods","methods",453930866).cljs$core$IFn$_invoke$arity$1(m));
var chunk__19312_19362 = null;
var count__19313_19363 = (0);
var i__19314_19364 = (0);
while(true){
if((i__19314_19364 < count__19313_19363)){
var vec__19325_19365 = cljs.core._nth.call(null,chunk__19312_19362,i__19314_19364);
var name_19366 = cljs.core.nth.call(null,vec__19325_19365,(0),null);
var map__19328_19367 = cljs.core.nth.call(null,vec__19325_19365,(1),null);
var map__19328_19368__$1 = (((((!((map__19328_19367 == null))))?(((((map__19328_19367.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19328_19367.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19328_19367):map__19328_19367);
var doc_19369 = cljs.core.get.call(null,map__19328_19368__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var arglists_19370 = cljs.core.get.call(null,map__19328_19368__$1,new cljs.core.Keyword(null,"arglists","arglists",1661989754));
cljs.core.println.call(null);

cljs.core.println.call(null," ",name_19366);

cljs.core.println.call(null," ",arglists_19370);

if(cljs.core.truth_(doc_19369)){
cljs.core.println.call(null," ",doc_19369);
} else {
}


var G__19371 = seq__19311_19361;
var G__19372 = chunk__19312_19362;
var G__19373 = count__19313_19363;
var G__19374 = (i__19314_19364 + (1));
seq__19311_19361 = G__19371;
chunk__19312_19362 = G__19372;
count__19313_19363 = G__19373;
i__19314_19364 = G__19374;
continue;
} else {
var temp__5720__auto___19375 = cljs.core.seq.call(null,seq__19311_19361);
if(temp__5720__auto___19375){
var seq__19311_19376__$1 = temp__5720__auto___19375;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__19311_19376__$1)){
var c__4550__auto___19377 = cljs.core.chunk_first.call(null,seq__19311_19376__$1);
var G__19378 = cljs.core.chunk_rest.call(null,seq__19311_19376__$1);
var G__19379 = c__4550__auto___19377;
var G__19380 = cljs.core.count.call(null,c__4550__auto___19377);
var G__19381 = (0);
seq__19311_19361 = G__19378;
chunk__19312_19362 = G__19379;
count__19313_19363 = G__19380;
i__19314_19364 = G__19381;
continue;
} else {
var vec__19330_19382 = cljs.core.first.call(null,seq__19311_19376__$1);
var name_19383 = cljs.core.nth.call(null,vec__19330_19382,(0),null);
var map__19333_19384 = cljs.core.nth.call(null,vec__19330_19382,(1),null);
var map__19333_19385__$1 = (((((!((map__19333_19384 == null))))?(((((map__19333_19384.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19333_19384.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19333_19384):map__19333_19384);
var doc_19386 = cljs.core.get.call(null,map__19333_19385__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var arglists_19387 = cljs.core.get.call(null,map__19333_19385__$1,new cljs.core.Keyword(null,"arglists","arglists",1661989754));
cljs.core.println.call(null);

cljs.core.println.call(null," ",name_19383);

cljs.core.println.call(null," ",arglists_19387);

if(cljs.core.truth_(doc_19386)){
cljs.core.println.call(null," ",doc_19386);
} else {
}


var G__19388 = cljs.core.next.call(null,seq__19311_19376__$1);
var G__19389 = null;
var G__19390 = (0);
var G__19391 = (0);
seq__19311_19361 = G__19388;
chunk__19312_19362 = G__19389;
count__19313_19363 = G__19390;
i__19314_19364 = G__19391;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(n)){
var temp__5720__auto__ = cljs.spec.alpha.get_spec.call(null,cljs.core.symbol.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.ns_name.call(null,n)),cljs.core.name.call(null,nm)));
if(cljs.core.truth_(temp__5720__auto__)){
var fnspec = temp__5720__auto__;
cljs.core.print.call(null,"Spec");

var seq__19335 = cljs.core.seq.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Keyword(null,"fn","fn",-1175266204)], null));
var chunk__19336 = null;
var count__19337 = (0);
var i__19338 = (0);
while(true){
if((i__19338 < count__19337)){
var role = cljs.core._nth.call(null,chunk__19336,i__19338);
var temp__5720__auto___19392__$1 = cljs.core.get.call(null,fnspec,role);
if(cljs.core.truth_(temp__5720__auto___19392__$1)){
var spec_19393 = temp__5720__auto___19392__$1;
cljs.core.print.call(null,["\n ",cljs.core.name.call(null,role),":"].join(''),cljs.spec.alpha.describe.call(null,spec_19393));
} else {
}


var G__19394 = seq__19335;
var G__19395 = chunk__19336;
var G__19396 = count__19337;
var G__19397 = (i__19338 + (1));
seq__19335 = G__19394;
chunk__19336 = G__19395;
count__19337 = G__19396;
i__19338 = G__19397;
continue;
} else {
var temp__5720__auto____$1 = cljs.core.seq.call(null,seq__19335);
if(temp__5720__auto____$1){
var seq__19335__$1 = temp__5720__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__19335__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__19335__$1);
var G__19398 = cljs.core.chunk_rest.call(null,seq__19335__$1);
var G__19399 = c__4550__auto__;
var G__19400 = cljs.core.count.call(null,c__4550__auto__);
var G__19401 = (0);
seq__19335 = G__19398;
chunk__19336 = G__19399;
count__19337 = G__19400;
i__19338 = G__19401;
continue;
} else {
var role = cljs.core.first.call(null,seq__19335__$1);
var temp__5720__auto___19402__$2 = cljs.core.get.call(null,fnspec,role);
if(cljs.core.truth_(temp__5720__auto___19402__$2)){
var spec_19403 = temp__5720__auto___19402__$2;
cljs.core.print.call(null,["\n ",cljs.core.name.call(null,role),":"].join(''),cljs.spec.alpha.describe.call(null,spec_19403));
} else {
}


var G__19404 = cljs.core.next.call(null,seq__19335__$1);
var G__19405 = null;
var G__19406 = (0);
var G__19407 = (0);
seq__19335 = G__19404;
chunk__19336 = G__19405;
count__19337 = G__19406;
i__19338 = G__19407;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Constructs a data representation for a Error with keys:
 *  :cause - root cause message
 *  :phase - error phase
 *  :via - cause chain, with cause keys:
 *           :type - exception class symbol
 *           :message - exception message
 *           :data - ex-data
 *           :at - top stack element
 *  :trace - root cause stack elements
 */
cljs.repl.Error__GT_map = (function cljs$repl$Error__GT_map(o){
var base = (function (t){
return cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"type","type",1174270348),(((t instanceof cljs.core.ExceptionInfo))?new cljs.core.Symbol(null,"ExceptionInfo","ExceptionInfo",294935087,null):(((t instanceof EvalError))?new cljs.core.Symbol("js","EvalError","js/EvalError",1793498501,null):(((t instanceof RangeError))?new cljs.core.Symbol("js","RangeError","js/RangeError",1703848089,null):(((t instanceof ReferenceError))?new cljs.core.Symbol("js","ReferenceError","js/ReferenceError",-198403224,null):(((t instanceof SyntaxError))?new cljs.core.Symbol("js","SyntaxError","js/SyntaxError",-1527651665,null):(((t instanceof URIError))?new cljs.core.Symbol("js","URIError","js/URIError",505061350,null):(((t instanceof Error))?new cljs.core.Symbol("js","Error","js/Error",-1692659266,null):null
)))))))], null),(function (){var temp__5720__auto__ = cljs.core.ex_message.call(null,t);
if(cljs.core.truth_(temp__5720__auto__)){
var msg = temp__5720__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"message","message",-406056002),msg], null);
} else {
return null;
}
})(),(function (){var temp__5720__auto__ = cljs.core.ex_data.call(null,t);
if(cljs.core.truth_(temp__5720__auto__)){
var ed = temp__5720__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),ed], null);
} else {
return null;
}
})());
});
var via = (function (){var via = cljs.core.PersistentVector.EMPTY;
var t = o;
while(true){
if(cljs.core.truth_(t)){
var G__19408 = cljs.core.conj.call(null,via,t);
var G__19409 = cljs.core.ex_cause.call(null,t);
via = G__19408;
t = G__19409;
continue;
} else {
return via;
}
break;
}
})();
var root = cljs.core.peek.call(null,via);
return cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"via","via",-1904457336),cljs.core.vec.call(null,cljs.core.map.call(null,base,via)),new cljs.core.Keyword(null,"trace","trace",-1082747415),null], null),(function (){var temp__5720__auto__ = cljs.core.ex_message.call(null,root);
if(cljs.core.truth_(temp__5720__auto__)){
var root_msg = temp__5720__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cause","cause",231901252),root_msg], null);
} else {
return null;
}
})(),(function (){var temp__5720__auto__ = cljs.core.ex_data.call(null,root);
if(cljs.core.truth_(temp__5720__auto__)){
var data = temp__5720__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),data], null);
} else {
return null;
}
})(),(function (){var temp__5720__auto__ = new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358).cljs$core$IFn$_invoke$arity$1(cljs.core.ex_data.call(null,o));
if(cljs.core.truth_(temp__5720__auto__)){
var phase = temp__5720__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"phase","phase",575722892),phase], null);
} else {
return null;
}
})());
});
/**
 * Returns an analysis of the phase, error, cause, and location of an error that occurred
 *   based on Throwable data, as returned by Throwable->map. All attributes other than phase
 *   are optional:
 *  :clojure.error/phase - keyword phase indicator, one of:
 *    :read-source :compile-syntax-check :compilation :macro-syntax-check :macroexpansion
 *    :execution :read-eval-result :print-eval-result
 *  :clojure.error/source - file name (no path)
 *  :clojure.error/line - integer line number
 *  :clojure.error/column - integer column number
 *  :clojure.error/symbol - symbol being expanded/compiled/invoked
 *  :clojure.error/class - cause exception class symbol
 *  :clojure.error/cause - cause exception message
 *  :clojure.error/spec - explain-data for spec error
 */
cljs.repl.ex_triage = (function cljs$repl$ex_triage(datafied_throwable){
var map__19412 = datafied_throwable;
var map__19412__$1 = (((((!((map__19412 == null))))?(((((map__19412.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19412.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19412):map__19412);
var via = cljs.core.get.call(null,map__19412__$1,new cljs.core.Keyword(null,"via","via",-1904457336));
var trace = cljs.core.get.call(null,map__19412__$1,new cljs.core.Keyword(null,"trace","trace",-1082747415));
var phase = cljs.core.get.call(null,map__19412__$1,new cljs.core.Keyword(null,"phase","phase",575722892),new cljs.core.Keyword(null,"execution","execution",253283524));
var map__19413 = cljs.core.last.call(null,via);
var map__19413__$1 = (((((!((map__19413 == null))))?(((((map__19413.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19413.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19413):map__19413);
var type = cljs.core.get.call(null,map__19413__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var message = cljs.core.get.call(null,map__19413__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var data = cljs.core.get.call(null,map__19413__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var map__19414 = data;
var map__19414__$1 = (((((!((map__19414 == null))))?(((((map__19414.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19414.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19414):map__19414);
var problems = cljs.core.get.call(null,map__19414__$1,new cljs.core.Keyword("cljs.spec.alpha","problems","cljs.spec.alpha/problems",447400814));
var fn = cljs.core.get.call(null,map__19414__$1,new cljs.core.Keyword("cljs.spec.alpha","fn","cljs.spec.alpha/fn",408600443));
var caller = cljs.core.get.call(null,map__19414__$1,new cljs.core.Keyword("cljs.spec.test.alpha","caller","cljs.spec.test.alpha/caller",-398302390));
var map__19415 = new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,via));
var map__19415__$1 = (((((!((map__19415 == null))))?(((((map__19415.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19415.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19415):map__19415);
var top_data = map__19415__$1;
var source = cljs.core.get.call(null,map__19415__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397));
return cljs.core.assoc.call(null,(function (){var G__19420 = phase;
var G__19420__$1 = (((G__19420 instanceof cljs.core.Keyword))?G__19420.fqn:null);
switch (G__19420__$1) {
case "read-source":
var map__19421 = data;
var map__19421__$1 = (((((!((map__19421 == null))))?(((((map__19421.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19421.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19421):map__19421);
var line = cljs.core.get.call(null,map__19421__$1,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471));
var column = cljs.core.get.call(null,map__19421__$1,new cljs.core.Keyword("clojure.error","column","clojure.error/column",304721553));
var G__19423 = cljs.core.merge.call(null,new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,via)),top_data);
var G__19423__$1 = (cljs.core.truth_(source)?cljs.core.assoc.call(null,G__19423,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),source):G__19423);
var G__19423__$2 = (cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["NO_SOURCE_PATH",null,"NO_SOURCE_FILE",null], null), null).call(null,source))?cljs.core.dissoc.call(null,G__19423__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397)):G__19423__$1);
if(cljs.core.truth_(message)){
return cljs.core.assoc.call(null,G__19423__$2,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message);
} else {
return G__19423__$2;
}

break;
case "compile-syntax-check":
case "compilation":
case "macro-syntax-check":
case "macroexpansion":
var G__19424 = top_data;
var G__19424__$1 = (cljs.core.truth_(source)?cljs.core.assoc.call(null,G__19424,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),source):G__19424);
var G__19424__$2 = (cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["NO_SOURCE_PATH",null,"NO_SOURCE_FILE",null], null), null).call(null,source))?cljs.core.dissoc.call(null,G__19424__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397)):G__19424__$1);
var G__19424__$3 = (cljs.core.truth_(type)?cljs.core.assoc.call(null,G__19424__$2,new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890),type):G__19424__$2);
var G__19424__$4 = (cljs.core.truth_(message)?cljs.core.assoc.call(null,G__19424__$3,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message):G__19424__$3);
if(cljs.core.truth_(problems)){
return cljs.core.assoc.call(null,G__19424__$4,new cljs.core.Keyword("clojure.error","spec","clojure.error/spec",2055032595),data);
} else {
return G__19424__$4;
}

break;
case "read-eval-result":
case "print-eval-result":
var vec__19425 = cljs.core.first.call(null,trace);
var source__$1 = cljs.core.nth.call(null,vec__19425,(0),null);
var method = cljs.core.nth.call(null,vec__19425,(1),null);
var file = cljs.core.nth.call(null,vec__19425,(2),null);
var line = cljs.core.nth.call(null,vec__19425,(3),null);
var G__19428 = top_data;
var G__19428__$1 = (cljs.core.truth_(line)?cljs.core.assoc.call(null,G__19428,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471),line):G__19428);
var G__19428__$2 = (cljs.core.truth_(file)?cljs.core.assoc.call(null,G__19428__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),file):G__19428__$1);
var G__19428__$3 = (cljs.core.truth_((function (){var and__4120__auto__ = source__$1;
if(cljs.core.truth_(and__4120__auto__)){
return method;
} else {
return and__4120__auto__;
}
})())?cljs.core.assoc.call(null,G__19428__$2,new cljs.core.Keyword("clojure.error","symbol","clojure.error/symbol",1544821994),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[source__$1,method],null))):G__19428__$2);
var G__19428__$4 = (cljs.core.truth_(type)?cljs.core.assoc.call(null,G__19428__$3,new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890),type):G__19428__$3);
if(cljs.core.truth_(message)){
return cljs.core.assoc.call(null,G__19428__$4,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message);
} else {
return G__19428__$4;
}

break;
case "execution":
var vec__19429 = cljs.core.first.call(null,trace);
var source__$1 = cljs.core.nth.call(null,vec__19429,(0),null);
var method = cljs.core.nth.call(null,vec__19429,(1),null);
var file = cljs.core.nth.call(null,vec__19429,(2),null);
var line = cljs.core.nth.call(null,vec__19429,(3),null);
var file__$1 = cljs.core.first.call(null,cljs.core.remove.call(null,((function (vec__19429,source__$1,method,file,line,G__19420,G__19420__$1,map__19412,map__19412__$1,via,trace,phase,map__19413,map__19413__$1,type,message,data,map__19414,map__19414__$1,problems,fn,caller,map__19415,map__19415__$1,top_data,source){
return (function (p1__19411_SHARP_){
var or__4131__auto__ = (p1__19411_SHARP_ == null);
if(or__4131__auto__){
return or__4131__auto__;
} else {
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["NO_SOURCE_PATH",null,"NO_SOURCE_FILE",null], null), null).call(null,p1__19411_SHARP_);
}
});})(vec__19429,source__$1,method,file,line,G__19420,G__19420__$1,map__19412,map__19412__$1,via,trace,phase,map__19413,map__19413__$1,type,message,data,map__19414,map__19414__$1,problems,fn,caller,map__19415,map__19415__$1,top_data,source))
,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(caller),file], null)));
var err_line = (function (){var or__4131__auto__ = new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(caller);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return line;
}
})();
var G__19432 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890),type], null);
var G__19432__$1 = (cljs.core.truth_(err_line)?cljs.core.assoc.call(null,G__19432,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471),err_line):G__19432);
var G__19432__$2 = (cljs.core.truth_(message)?cljs.core.assoc.call(null,G__19432__$1,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message):G__19432__$1);
var G__19432__$3 = (cljs.core.truth_((function (){var or__4131__auto__ = fn;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var and__4120__auto__ = source__$1;
if(cljs.core.truth_(and__4120__auto__)){
return method;
} else {
return and__4120__auto__;
}
}
})())?cljs.core.assoc.call(null,G__19432__$2,new cljs.core.Keyword("clojure.error","symbol","clojure.error/symbol",1544821994),(function (){var or__4131__auto__ = fn;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[source__$1,method],null));
}
})()):G__19432__$2);
var G__19432__$4 = (cljs.core.truth_(file__$1)?cljs.core.assoc.call(null,G__19432__$3,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),file__$1):G__19432__$3);
if(cljs.core.truth_(problems)){
return cljs.core.assoc.call(null,G__19432__$4,new cljs.core.Keyword("clojure.error","spec","clojure.error/spec",2055032595),data);
} else {
return G__19432__$4;
}

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__19420__$1)].join('')));

}
})(),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),phase);
});
/**
 * Returns a string from exception data, as produced by ex-triage.
 *   The first line summarizes the exception phase and location.
 *   The subsequent lines describe the cause.
 */
cljs.repl.ex_str = (function cljs$repl$ex_str(p__19436){
var map__19437 = p__19436;
var map__19437__$1 = (((((!((map__19437 == null))))?(((((map__19437.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19437.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19437):map__19437);
var triage_data = map__19437__$1;
var phase = cljs.core.get.call(null,map__19437__$1,new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358));
var source = cljs.core.get.call(null,map__19437__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397));
var line = cljs.core.get.call(null,map__19437__$1,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471));
var column = cljs.core.get.call(null,map__19437__$1,new cljs.core.Keyword("clojure.error","column","clojure.error/column",304721553));
var symbol = cljs.core.get.call(null,map__19437__$1,new cljs.core.Keyword("clojure.error","symbol","clojure.error/symbol",1544821994));
var class$ = cljs.core.get.call(null,map__19437__$1,new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890));
var cause = cljs.core.get.call(null,map__19437__$1,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742));
var spec = cljs.core.get.call(null,map__19437__$1,new cljs.core.Keyword("clojure.error","spec","clojure.error/spec",2055032595));
var loc = [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4131__auto__ = source;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return "<cljs repl>";
}
})()),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4131__auto__ = line;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (1);
}
})()),(cljs.core.truth_(column)?[":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column)].join(''):"")].join('');
var class_name = cljs.core.name.call(null,(function (){var or__4131__auto__ = class$;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return "";
}
})());
var simple_class = class_name;
var cause_type = ((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["RuntimeException",null,"Exception",null], null), null),simple_class))?"":[" (",simple_class,")"].join(''));
var format = goog.string.format;
var G__19439 = phase;
var G__19439__$1 = (((G__19439 instanceof cljs.core.Keyword))?G__19439.fqn:null);
switch (G__19439__$1) {
case "read-source":
return format.call(null,"Syntax error reading source at (%s).\n%s\n",loc,cause);

break;
case "macro-syntax-check":
return format.call(null,"Syntax error macroexpanding %sat (%s).\n%s",(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,(cljs.core.truth_(spec)?(function (){var sb__4661__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__19440_19449 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__19441_19450 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__19442_19451 = true;
var _STAR_print_fn_STAR__temp_val__19443_19452 = ((function (_STAR_print_newline_STAR__orig_val__19440_19449,_STAR_print_fn_STAR__orig_val__19441_19450,_STAR_print_newline_STAR__temp_val__19442_19451,sb__4661__auto__,G__19439,G__19439__$1,loc,class_name,simple_class,cause_type,format,map__19437,map__19437__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec){
return (function (x__4662__auto__){
return sb__4661__auto__.append(x__4662__auto__);
});})(_STAR_print_newline_STAR__orig_val__19440_19449,_STAR_print_fn_STAR__orig_val__19441_19450,_STAR_print_newline_STAR__temp_val__19442_19451,sb__4661__auto__,G__19439,G__19439__$1,loc,class_name,simple_class,cause_type,format,map__19437,map__19437__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec))
;
cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__19442_19451;

cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__19443_19452;

try{cljs.spec.alpha.explain_out.call(null,cljs.core.update.call(null,spec,new cljs.core.Keyword("cljs.spec.alpha","problems","cljs.spec.alpha/problems",447400814),((function (_STAR_print_newline_STAR__orig_val__19440_19449,_STAR_print_fn_STAR__orig_val__19441_19450,_STAR_print_newline_STAR__temp_val__19442_19451,_STAR_print_fn_STAR__temp_val__19443_19452,sb__4661__auto__,G__19439,G__19439__$1,loc,class_name,simple_class,cause_type,format,map__19437,map__19437__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec){
return (function (probs){
return cljs.core.map.call(null,((function (_STAR_print_newline_STAR__orig_val__19440_19449,_STAR_print_fn_STAR__orig_val__19441_19450,_STAR_print_newline_STAR__temp_val__19442_19451,_STAR_print_fn_STAR__temp_val__19443_19452,sb__4661__auto__,G__19439,G__19439__$1,loc,class_name,simple_class,cause_type,format,map__19437,map__19437__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec){
return (function (p1__19434_SHARP_){
return cljs.core.dissoc.call(null,p1__19434_SHARP_,new cljs.core.Keyword(null,"in","in",-1531184865));
});})(_STAR_print_newline_STAR__orig_val__19440_19449,_STAR_print_fn_STAR__orig_val__19441_19450,_STAR_print_newline_STAR__temp_val__19442_19451,_STAR_print_fn_STAR__temp_val__19443_19452,sb__4661__auto__,G__19439,G__19439__$1,loc,class_name,simple_class,cause_type,format,map__19437,map__19437__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec))
,probs);
});})(_STAR_print_newline_STAR__orig_val__19440_19449,_STAR_print_fn_STAR__orig_val__19441_19450,_STAR_print_newline_STAR__temp_val__19442_19451,_STAR_print_fn_STAR__temp_val__19443_19452,sb__4661__auto__,G__19439,G__19439__$1,loc,class_name,simple_class,cause_type,format,map__19437,map__19437__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec))
)
);
}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__19441_19450;

cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__19440_19449;
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4661__auto__);
})():format.call(null,"%s\n",cause)));

break;
case "macroexpansion":
return format.call(null,"Unexpected error%s macroexpanding %sat (%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);

break;
case "compile-syntax-check":
return format.call(null,"Syntax error%s compiling %sat (%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);

break;
case "compilation":
return format.call(null,"Unexpected error%s compiling %sat (%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);

break;
case "read-eval-result":
return format.call(null,"Error reading eval result%s at %s (%s).\n%s\n",cause_type,symbol,loc,cause);

break;
case "print-eval-result":
return format.call(null,"Error printing return value%s at %s (%s).\n%s\n",cause_type,symbol,loc,cause);

break;
case "execution":
if(cljs.core.truth_(spec)){
return format.call(null,"Execution error - invalid arguments to %s at (%s).\n%s",symbol,loc,(function (){var sb__4661__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__19444_19453 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__19445_19454 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__19446_19455 = true;
var _STAR_print_fn_STAR__temp_val__19447_19456 = ((function (_STAR_print_newline_STAR__orig_val__19444_19453,_STAR_print_fn_STAR__orig_val__19445_19454,_STAR_print_newline_STAR__temp_val__19446_19455,sb__4661__auto__,G__19439,G__19439__$1,loc,class_name,simple_class,cause_type,format,map__19437,map__19437__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec){
return (function (x__4662__auto__){
return sb__4661__auto__.append(x__4662__auto__);
});})(_STAR_print_newline_STAR__orig_val__19444_19453,_STAR_print_fn_STAR__orig_val__19445_19454,_STAR_print_newline_STAR__temp_val__19446_19455,sb__4661__auto__,G__19439,G__19439__$1,loc,class_name,simple_class,cause_type,format,map__19437,map__19437__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec))
;
cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__19446_19455;

cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__19447_19456;

try{cljs.spec.alpha.explain_out.call(null,cljs.core.update.call(null,spec,new cljs.core.Keyword("cljs.spec.alpha","problems","cljs.spec.alpha/problems",447400814),((function (_STAR_print_newline_STAR__orig_val__19444_19453,_STAR_print_fn_STAR__orig_val__19445_19454,_STAR_print_newline_STAR__temp_val__19446_19455,_STAR_print_fn_STAR__temp_val__19447_19456,sb__4661__auto__,G__19439,G__19439__$1,loc,class_name,simple_class,cause_type,format,map__19437,map__19437__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec){
return (function (probs){
return cljs.core.map.call(null,((function (_STAR_print_newline_STAR__orig_val__19444_19453,_STAR_print_fn_STAR__orig_val__19445_19454,_STAR_print_newline_STAR__temp_val__19446_19455,_STAR_print_fn_STAR__temp_val__19447_19456,sb__4661__auto__,G__19439,G__19439__$1,loc,class_name,simple_class,cause_type,format,map__19437,map__19437__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec){
return (function (p1__19435_SHARP_){
return cljs.core.dissoc.call(null,p1__19435_SHARP_,new cljs.core.Keyword(null,"in","in",-1531184865));
});})(_STAR_print_newline_STAR__orig_val__19444_19453,_STAR_print_fn_STAR__orig_val__19445_19454,_STAR_print_newline_STAR__temp_val__19446_19455,_STAR_print_fn_STAR__temp_val__19447_19456,sb__4661__auto__,G__19439,G__19439__$1,loc,class_name,simple_class,cause_type,format,map__19437,map__19437__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec))
,probs);
});})(_STAR_print_newline_STAR__orig_val__19444_19453,_STAR_print_fn_STAR__orig_val__19445_19454,_STAR_print_newline_STAR__temp_val__19446_19455,_STAR_print_fn_STAR__temp_val__19447_19456,sb__4661__auto__,G__19439,G__19439__$1,loc,class_name,simple_class,cause_type,format,map__19437,map__19437__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec))
)
);
}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__19445_19454;

cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__19444_19453;
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4661__auto__);
})());
} else {
return format.call(null,"Execution error%s at %s(%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);
}

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__19439__$1)].join('')));

}
});
cljs.repl.error__GT_str = (function cljs$repl$error__GT_str(error){
return cljs.repl.ex_str.call(null,cljs.repl.ex_triage.call(null,cljs.repl.Error__GT_map.call(null,error)));
});

//# sourceMappingURL=repl.js.map
