// Compiled by ClojureScript 1.10.516 {}
goog.provide('thi.ng.typedarrays.core');
goog.require('cljs.core');
/**
 * Returns true if JS runtime supports typed arrays
 */
thi.ng.typedarrays.core.typed_arrays_supported_QMARK_ = (function thi$ng$typedarrays$core$typed_arrays_supported_QMARK_(){
return (!(((window["ArrayBuffer"]) == null)));
});
thi.ng.typedarrays.core.array_types = cljs.core.PersistentHashMap.fromArrays(["Float64Array","Uint8Array","Int8Array","Uint8ClampedArray","Uint16Array","Int16Array","Uint32Array","Float32Array","Int32Array"],[new cljs.core.Keyword(null,"float64","float64",1881838306),new cljs.core.Keyword(null,"uint8","uint8",956521151),new cljs.core.Keyword(null,"int8","int8",-1834023920),new cljs.core.Keyword(null,"uint8-clamped","uint8-clamped",1439331936),new cljs.core.Keyword(null,"uint16","uint16",-588869202),new cljs.core.Keyword(null,"int16","int16",-188764863),new cljs.core.Keyword(null,"uint32","uint32",-418789486),new cljs.core.Keyword(null,"float32","float32",-2119815775),new cljs.core.Keyword(null,"int32","int32",1718804896)]);
/**
 * Returns truthy value if the given arg is a typed array instance
 */
thi.ng.typedarrays.core.typed_array_QMARK_ = (function thi$ng$typedarrays$core$typed_array_QMARK_(x){
if(cljs.core._EQ_.call(null,"object",goog.typeOf(x))){
if(typeof x.BYTES_PER_ELEMENT === 'number'){
return x.buffer;
} else {
return null;
}
} else {
return null;
}
});
thi.ng.typedarrays.core.array_type = (function thi$ng$typedarrays$core$array_type(x){
if(cljs.core.array_QMARK_.call(null,x)){
return new cljs.core.Keyword(null,"array","array",-2080713842);
} else {
if(cljs.core.truth_(thi.ng.typedarrays.core.typed_array_QMARK_.call(null,x))){
return cljs.core.get.call(null,thi.ng.typedarrays.core.array_types,cljs.core.first.call(null,cljs.core.re_find.call(null,/((Uint|Int|Float)\d+(Clamped)?Array)/,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x.constructor))));
} else {
return null;
}
}
});
/**
 * Creates a native Int8Array of the given size or from `coll`.
 */
thi.ng.typedarrays.core.int8 = (function thi$ng$typedarrays$core$int8(size_or_coll){
if(typeof size_or_coll === 'number'){
return (new Int8Array(size_or_coll));
} else {
if(cljs.core.truth_(thi.ng.typedarrays.core.typed_array_QMARK_.call(null,size_or_coll))){
return size_or_coll;
} else {
var len = cljs.core.count.call(null,size_or_coll);
var buf = (new Int8Array(len));
var i_16877 = (0);
var coll_16878 = size_or_coll;
while(true){
if((i_16877 < len)){
(buf[i_16877] = cljs.core.first.call(null,coll_16878));

var G__16879 = (i_16877 + (1));
var G__16880 = cljs.core.next.call(null,coll_16878);
i_16877 = G__16879;
coll_16878 = G__16880;
continue;
} else {
}
break;
}

return buf;

}
}
});
/**
 * Creates a native Uint8Array of the given size or from `coll`.
 */
thi.ng.typedarrays.core.uint8 = (function thi$ng$typedarrays$core$uint8(size_or_coll){
if(typeof size_or_coll === 'number'){
return (new Uint8Array(size_or_coll));
} else {
if(cljs.core.truth_(thi.ng.typedarrays.core.typed_array_QMARK_.call(null,size_or_coll))){
return size_or_coll;
} else {
var len = cljs.core.count.call(null,size_or_coll);
var buf = (new Uint8Array(len));
var i_16881 = (0);
var coll_16882 = size_or_coll;
while(true){
if((i_16881 < len)){
(buf[i_16881] = cljs.core.first.call(null,coll_16882));

var G__16883 = (i_16881 + (1));
var G__16884 = cljs.core.next.call(null,coll_16882);
i_16881 = G__16883;
coll_16882 = G__16884;
continue;
} else {
}
break;
}

return buf;

}
}
});
/**
 * Creates a native Uint8ClampedArray of the given size or from `coll`.
 */
thi.ng.typedarrays.core.uint8_clamped = (function thi$ng$typedarrays$core$uint8_clamped(size_or_coll){
if(typeof size_or_coll === 'number'){
return (new Uint8ClampedArray(size_or_coll));
} else {
if(cljs.core.truth_(thi.ng.typedarrays.core.typed_array_QMARK_.call(null,size_or_coll))){
return size_or_coll;
} else {
var len = cljs.core.count.call(null,size_or_coll);
var buf = (new Uint8ClampedArray(len));
var i_16885 = (0);
var coll_16886 = size_or_coll;
while(true){
if((i_16885 < len)){
(buf[i_16885] = cljs.core.first.call(null,coll_16886));

var G__16887 = (i_16885 + (1));
var G__16888 = cljs.core.next.call(null,coll_16886);
i_16885 = G__16887;
coll_16886 = G__16888;
continue;
} else {
}
break;
}

return buf;

}
}
});
/**
 * Creates a native Int16Array of the given size or from `coll`.
 */
thi.ng.typedarrays.core.int16 = (function thi$ng$typedarrays$core$int16(size_or_coll){
if(typeof size_or_coll === 'number'){
return (new Int16Array(size_or_coll));
} else {
if(cljs.core.truth_(thi.ng.typedarrays.core.typed_array_QMARK_.call(null,size_or_coll))){
return size_or_coll;
} else {
var len = cljs.core.count.call(null,size_or_coll);
var buf = (new Int16Array(len));
var i_16889 = (0);
var coll_16890 = size_or_coll;
while(true){
if((i_16889 < len)){
(buf[i_16889] = cljs.core.first.call(null,coll_16890));

var G__16891 = (i_16889 + (1));
var G__16892 = cljs.core.next.call(null,coll_16890);
i_16889 = G__16891;
coll_16890 = G__16892;
continue;
} else {
}
break;
}

return buf;

}
}
});
/**
 * Creates a native Uint16Array of the given size or from `coll`.
 */
thi.ng.typedarrays.core.uint16 = (function thi$ng$typedarrays$core$uint16(size_or_coll){
if(typeof size_or_coll === 'number'){
return (new Uint16Array(size_or_coll));
} else {
if(cljs.core.truth_(thi.ng.typedarrays.core.typed_array_QMARK_.call(null,size_or_coll))){
return size_or_coll;
} else {
var len = cljs.core.count.call(null,size_or_coll);
var buf = (new Uint16Array(len));
var i_16893 = (0);
var coll_16894 = size_or_coll;
while(true){
if((i_16893 < len)){
(buf[i_16893] = cljs.core.first.call(null,coll_16894));

var G__16895 = (i_16893 + (1));
var G__16896 = cljs.core.next.call(null,coll_16894);
i_16893 = G__16895;
coll_16894 = G__16896;
continue;
} else {
}
break;
}

return buf;

}
}
});
/**
 * Creates a native Int32Array of the given size or from `coll`.
 */
thi.ng.typedarrays.core.int32 = (function thi$ng$typedarrays$core$int32(size_or_coll){
if(typeof size_or_coll === 'number'){
return (new Int32Array(size_or_coll));
} else {
if(cljs.core.truth_(thi.ng.typedarrays.core.typed_array_QMARK_.call(null,size_or_coll))){
return size_or_coll;
} else {
var len = cljs.core.count.call(null,size_or_coll);
var buf = (new Int32Array(len));
var i_16897 = (0);
var coll_16898 = size_or_coll;
while(true){
if((i_16897 < len)){
(buf[i_16897] = cljs.core.first.call(null,coll_16898));

var G__16899 = (i_16897 + (1));
var G__16900 = cljs.core.next.call(null,coll_16898);
i_16897 = G__16899;
coll_16898 = G__16900;
continue;
} else {
}
break;
}

return buf;

}
}
});
/**
 * Creates a native Uint32Array of the given size or from `coll`.
 */
thi.ng.typedarrays.core.uint32 = (function thi$ng$typedarrays$core$uint32(size_or_coll){
if(typeof size_or_coll === 'number'){
return (new Uint32Array(size_or_coll));
} else {
if(cljs.core.truth_(thi.ng.typedarrays.core.typed_array_QMARK_.call(null,size_or_coll))){
return size_or_coll;
} else {
var len = cljs.core.count.call(null,size_or_coll);
var buf = (new Uint32Array(len));
var i_16901 = (0);
var coll_16902 = size_or_coll;
while(true){
if((i_16901 < len)){
(buf[i_16901] = cljs.core.first.call(null,coll_16902));

var G__16903 = (i_16901 + (1));
var G__16904 = cljs.core.next.call(null,coll_16902);
i_16901 = G__16903;
coll_16902 = G__16904;
continue;
} else {
}
break;
}

return buf;

}
}
});
/**
 * Creates a native Float32Array of the given size or from `coll`.
 */
thi.ng.typedarrays.core.float32 = (function thi$ng$typedarrays$core$float32(size_or_coll){
if(typeof size_or_coll === 'number'){
return (new Float32Array(size_or_coll));
} else {
if(cljs.core.truth_(thi.ng.typedarrays.core.typed_array_QMARK_.call(null,size_or_coll))){
return size_or_coll;
} else {
var len = cljs.core.count.call(null,size_or_coll);
var buf = (new Float32Array(len));
var i_16905 = (0);
var coll_16906 = size_or_coll;
while(true){
if((i_16905 < len)){
(buf[i_16905] = cljs.core.first.call(null,coll_16906));

var G__16907 = (i_16905 + (1));
var G__16908 = cljs.core.next.call(null,coll_16906);
i_16905 = G__16907;
coll_16906 = G__16908;
continue;
} else {
}
break;
}

return buf;

}
}
});
/**
 * Creates a native Float64Array of the given size or from `coll`.
 */
thi.ng.typedarrays.core.float64 = (function thi$ng$typedarrays$core$float64(size_or_coll){
if(typeof size_or_coll === 'number'){
return (new Float64Array(size_or_coll));
} else {
if(cljs.core.truth_(thi.ng.typedarrays.core.typed_array_QMARK_.call(null,size_or_coll))){
return size_or_coll;
} else {
var len = cljs.core.count.call(null,size_or_coll);
var buf = (new Float64Array(len));
var i_16909 = (0);
var coll_16910 = size_or_coll;
while(true){
if((i_16909 < len)){
(buf[i_16909] = cljs.core.first.call(null,coll_16910));

var G__16911 = (i_16909 + (1));
var G__16912 = cljs.core.next.call(null,coll_16910);
i_16909 = G__16911;
coll_16910 = G__16912;
continue;
} else {
}
break;
}

return buf;

}
}
});

//# sourceMappingURL=core.js.map
