// Compiled by ClojureScript 1.10.516 {}
goog.provide('reagent.dom');
goog.require('cljs.core');
goog.require('react_dom');
goog.require('reagent.impl.util');
goog.require('reagent.impl.template');
goog.require('reagent.impl.batching');
goog.require('reagent.impl.protocols');
goog.require('reagent.ratom');
reagent.dom.global$module$react_dom = goog.global["ReactDOM"];
if((typeof reagent !== 'undefined') && (typeof reagent.dom !== 'undefined') && (typeof reagent.dom.roots !== 'undefined')){
} else {
reagent.dom.roots = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
reagent.dom.unmount_comp = (function reagent$dom$unmount_comp(container){
cljs.core.swap_BANG_.call(null,reagent.dom.roots,cljs.core.dissoc,container);

return reagent.dom.global$module$react_dom.unmountComponentAtNode.call(null,container);
});
reagent.dom.render_comp = (function reagent$dom$render_comp(comp,container,callback){
var _STAR_always_update_STAR__orig_val__10375 = reagent.impl.util._STAR_always_update_STAR_;
var _STAR_always_update_STAR__temp_val__10376 = true;
reagent.impl.util._STAR_always_update_STAR_ = _STAR_always_update_STAR__temp_val__10376;

try{return reagent.dom.global$module$react_dom.render.call(null,comp.call(null),container,((function (_STAR_always_update_STAR__orig_val__10375,_STAR_always_update_STAR__temp_val__10376){
return (function (){
var _STAR_always_update_STAR__orig_val__10377 = reagent.impl.util._STAR_always_update_STAR_;
var _STAR_always_update_STAR__temp_val__10378 = false;
reagent.impl.util._STAR_always_update_STAR_ = _STAR_always_update_STAR__temp_val__10378;

try{cljs.core.swap_BANG_.call(null,reagent.dom.roots,cljs.core.assoc,container,comp);

reagent.impl.batching.flush_after_render.call(null);

if((!((callback == null)))){
return callback.call(null);
} else {
return null;
}
}finally {reagent.impl.util._STAR_always_update_STAR_ = _STAR_always_update_STAR__orig_val__10377;
}});})(_STAR_always_update_STAR__orig_val__10375,_STAR_always_update_STAR__temp_val__10376))
);
}finally {reagent.impl.util._STAR_always_update_STAR_ = _STAR_always_update_STAR__orig_val__10375;
}});
reagent.dom.re_render_component = (function reagent$dom$re_render_component(comp,container){
return reagent.dom.render_comp.call(null,comp,container,null);
});
/**
 * Render a Reagent component into the DOM. The first argument may be
 *   either a vector (using Reagent's Hiccup syntax), or a React element.
 *   The second argument should be a DOM node.
 * 
 *   Optionally takes a callback that is called when the component is in place.
 * 
 *   Returns the mounted component instance.
 */
reagent.dom.render = (function reagent$dom$render(var_args){
var G__10380 = arguments.length;
switch (G__10380) {
case 2:
return reagent.dom.render.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return reagent.dom.render.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

reagent.dom.render.cljs$core$IFn$_invoke$arity$2 = (function (comp,container){
return reagent.dom.render.call(null,comp,container,reagent.impl.template._STAR_current_default_compiler_STAR_);
});

reagent.dom.render.cljs$core$IFn$_invoke$arity$3 = (function (comp,container,callback_or_compiler){
reagent.ratom.flush_BANG_.call(null);

var vec__10381 = ((cljs.core.map_QMARK_.call(null,callback_or_compiler))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compiler","compiler",-267926731).cljs$core$IFn$_invoke$arity$1(callback_or_compiler),new cljs.core.Keyword(null,"callback","callback",-705136228).cljs$core$IFn$_invoke$arity$1(callback_or_compiler)], null):((cljs.core.fn_QMARK_.call(null,callback_or_compiler))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [reagent.impl.template._STAR_current_default_compiler_STAR_,callback_or_compiler], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [callback_or_compiler,null], null)
));
var compiler = cljs.core.nth.call(null,vec__10381,(0),null);
var callback = cljs.core.nth.call(null,vec__10381,(1),null);
var f = ((function (vec__10381,compiler,callback){
return (function (){
return reagent.impl.protocols.as_element.call(null,compiler,((cljs.core.fn_QMARK_.call(null,comp))?comp.call(null):comp));
});})(vec__10381,compiler,callback))
;
return reagent.dom.render_comp.call(null,f,container,callback);
});

reagent.dom.render.cljs$lang$maxFixedArity = 3;

/**
 * Remove a component from the given DOM node.
 */
reagent.dom.unmount_component_at_node = (function reagent$dom$unmount_component_at_node(container){
return reagent.dom.unmount_comp.call(null,container);
});
/**
 * Returns the root DOM node of a mounted component.
 */
reagent.dom.dom_node = (function reagent$dom$dom_node(this$){
return reagent.dom.global$module$react_dom.findDOMNode.call(null,this$);
});
/**
 * Force re-rendering of all mounted Reagent components. This is
 *   probably only useful in a development environment, when you want to
 *   update components in response to some dynamic changes to code.
 * 
 *   Note that force-update-all may not update root components. This
 *   happens if a component 'foo' is mounted with `(render [foo])` (since
 *   functions are passed by value, and not by reference, in
 *   ClojureScript). To get around this you'll have to introduce a layer
 *   of indirection, for example by using `(render [#'foo])` instead.
 */
reagent.dom.force_update_all = (function reagent$dom$force_update_all(){
reagent.ratom.flush_BANG_.call(null);

var seq__10385_10401 = cljs.core.seq.call(null,cljs.core.deref.call(null,reagent.dom.roots));
var chunk__10386_10402 = null;
var count__10387_10403 = (0);
var i__10388_10404 = (0);
while(true){
if((i__10388_10404 < count__10387_10403)){
var vec__10395_10405 = cljs.core._nth.call(null,chunk__10386_10402,i__10388_10404);
var container_10406 = cljs.core.nth.call(null,vec__10395_10405,(0),null);
var comp_10407 = cljs.core.nth.call(null,vec__10395_10405,(1),null);
reagent.dom.re_render_component.call(null,comp_10407,container_10406);


var G__10408 = seq__10385_10401;
var G__10409 = chunk__10386_10402;
var G__10410 = count__10387_10403;
var G__10411 = (i__10388_10404 + (1));
seq__10385_10401 = G__10408;
chunk__10386_10402 = G__10409;
count__10387_10403 = G__10410;
i__10388_10404 = G__10411;
continue;
} else {
var temp__5720__auto___10412 = cljs.core.seq.call(null,seq__10385_10401);
if(temp__5720__auto___10412){
var seq__10385_10413__$1 = temp__5720__auto___10412;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__10385_10413__$1)){
var c__4550__auto___10414 = cljs.core.chunk_first.call(null,seq__10385_10413__$1);
var G__10415 = cljs.core.chunk_rest.call(null,seq__10385_10413__$1);
var G__10416 = c__4550__auto___10414;
var G__10417 = cljs.core.count.call(null,c__4550__auto___10414);
var G__10418 = (0);
seq__10385_10401 = G__10415;
chunk__10386_10402 = G__10416;
count__10387_10403 = G__10417;
i__10388_10404 = G__10418;
continue;
} else {
var vec__10398_10419 = cljs.core.first.call(null,seq__10385_10413__$1);
var container_10420 = cljs.core.nth.call(null,vec__10398_10419,(0),null);
var comp_10421 = cljs.core.nth.call(null,vec__10398_10419,(1),null);
reagent.dom.re_render_component.call(null,comp_10421,container_10420);


var G__10422 = cljs.core.next.call(null,seq__10385_10413__$1);
var G__10423 = null;
var G__10424 = (0);
var G__10425 = (0);
seq__10385_10401 = G__10422;
chunk__10386_10402 = G__10423;
count__10387_10403 = G__10424;
i__10388_10404 = G__10425;
continue;
}
} else {
}
}
break;
}

return reagent.impl.batching.flush_after_render.call(null);
});

//# sourceMappingURL=dom.js.map
