// Compiled by ClojureScript 1.10.516 {}
goog.provide('figwheel.core');
goog.require('cljs.core');
goog.require('figwheel.tools.heads_up');
goog.require('goog.object');
goog.require('goog.string');
goog.require('goog.string.format');
goog.require('goog.log');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('goog.debug.Console');
goog.require('goog.async.Deferred');
goog.require('goog.Promise');
goog.require('goog.events.EventTarget');
goog.require('goog.events.Event');
figwheel.core.distinct_by = (function figwheel$core$distinct_by(f,coll){
var seen = cljs.core.volatile_BANG_.call(null,cljs.core.PersistentHashSet.EMPTY);
return cljs.core.filter.call(null,((function (seen){
return (function (p1__12452_SHARP_){
var k = f.call(null,p1__12452_SHARP_);
var res = cljs.core.not.call(null,cljs.core.deref.call(null,seen).call(null,k));
cljs.core._vreset_BANG_.call(null,seen,cljs.core.conj.call(null,cljs.core._deref.call(null,seen),k));

return res;
});})(seen))
,coll);
});
figwheel.core.map_keys = (function figwheel$core$map_keys(f,coll){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,(function (p__12453){
var vec__12454 = p__12453;
var k = cljs.core.nth.call(null,vec__12454,(0),null);
var v = cljs.core.nth.call(null,vec__12454,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f.call(null,k),v], null);
})),coll);
});
figwheel.core._STAR_inline_code_message_max_column_STAR_ = (80);
figwheel.core.wrap_line = (function figwheel$core$wrap_line(text,size){
return cljs.core.re_seq.call(null,cljs.core.re_pattern.call(null,[".{1,",cljs.core.str.cljs$core$IFn$_invoke$arity$1(size),"}\\s|.{1,",cljs.core.str.cljs$core$IFn$_invoke$arity$1(size),"}"].join('')),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.replace.call(null,text,/\n/," "))," "].join(''));
});
figwheel.core.cross_format = (function figwheel$core$cross_format(var_args){
var args__4736__auto__ = [];
var len__4730__auto___12458 = arguments.length;
var i__4731__auto___12459 = (0);
while(true){
if((i__4731__auto___12459 < len__4730__auto___12458)){
args__4736__auto__.push((arguments[i__4731__auto___12459]));

var G__12460 = (i__4731__auto___12459 + (1));
i__4731__auto___12459 = G__12460;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return figwheel.core.cross_format.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

figwheel.core.cross_format.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.call(null,goog.string.format,args);
});

figwheel.core.cross_format.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
figwheel.core.cross_format.cljs$lang$applyTo = (function (seq12457){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq12457));
});

figwheel.core.pointer_message_lines = (function figwheel$core$pointer_message_lines(p__12463){
var map__12464 = p__12463;
var map__12464__$1 = (((((!((map__12464 == null))))?(((((map__12464.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12464.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12464):map__12464);
var message = cljs.core.get.call(null,map__12464__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var column = cljs.core.get.call(null,map__12464__$1,new cljs.core.Keyword(null,"column","column",2078222095));
if(((column + cljs.core.count.call(null,message)) > figwheel.core._STAR_inline_code_message_max_column_STAR_)){
return cljs.core.mapv.call(null,((function (map__12464,map__12464__$1,message,column){
return (function (p1__12462_SHARP_){
return cljs.core.vec.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"error-message","error-message",1756021561),null], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__12462_SHARP_], null)));
});})(map__12464,map__12464__$1,message,column))
,cljs.core.cons.call(null,figwheel.core.cross_format.call(null,(function (){var col = (column - (1));
return ["%",cljs.core.str.cljs$core$IFn$_invoke$arity$1((((col === (0)))?null:col)),"s%s"].join('');
})(),"","^---"),cljs.core.map.call(null,((function (map__12464,map__12464__$1,message,column){
return (function (p1__12461_SHARP_){
return figwheel.core.cross_format.call(null,["%",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.core._STAR_inline_code_message_max_column_STAR_),"s"].join(''),p1__12461_SHARP_);
});})(map__12464,map__12464__$1,message,column))
,figwheel.core.wrap_line.call(null,message,(figwheel.core._STAR_inline_code_message_max_column_STAR_ - (10))))));
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"error-message","error-message",1756021561),null,figwheel.core.cross_format.call(null,(function (){var col = (column - (1));
return ["%",cljs.core.str.cljs$core$IFn$_invoke$arity$1((((col === (0)))?null:col)),"s%s %s"].join('');
})(),"","^---",message)], null)], null);
}
});
figwheel.core.inline_message_display_data = (function figwheel$core$inline_message_display_data(p__12467){
var map__12468 = p__12467;
var map__12468__$1 = (((((!((map__12468 == null))))?(((((map__12468.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12468.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12468):map__12468);
var message_data = map__12468__$1;
var message = cljs.core.get.call(null,map__12468__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var line = cljs.core.get.call(null,map__12468__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.call(null,map__12468__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var file_excerpt = cljs.core.get.call(null,map__12468__$1,new cljs.core.Keyword(null,"file-excerpt","file-excerpt",-1132330744));
if(cljs.core.truth_(file_excerpt)){
var map__12470 = file_excerpt;
var map__12470__$1 = (((((!((map__12470 == null))))?(((((map__12470.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12470.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12470):map__12470);
var start_line = cljs.core.get.call(null,map__12470__$1,new cljs.core.Keyword(null,"start-line","start-line",-41746654));
var path = cljs.core.get.call(null,map__12470__$1,new cljs.core.Keyword(null,"path","path",-188191168));
var excerpt = cljs.core.get.call(null,map__12470__$1,new cljs.core.Keyword(null,"excerpt","excerpt",219850763));
var lines = cljs.core.map_indexed.call(null,((function (map__12470,map__12470__$1,start_line,path,excerpt,map__12468,map__12468__$1,message_data,message,line,column,file_excerpt){
return (function (i,l){
var ln = (i + start_line);
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[((cljs.core._EQ_.call(null,line,ln))?new cljs.core.Keyword(null,"error-in-code","error-in-code",-1661931357):new cljs.core.Keyword(null,"code-line","code-line",-2138627853)),ln,l],null));
});})(map__12470,map__12470__$1,start_line,path,excerpt,map__12468,map__12468__$1,message_data,message,line,column,file_excerpt))
,clojure.string.split_lines.call(null,excerpt));
var vec__12471 = cljs.core.split_with.call(null,((function (map__12470,map__12470__$1,start_line,path,excerpt,lines,map__12468,map__12468__$1,message_data,message,line,column,file_excerpt){
return (function (p1__12466_SHARP_){
return cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"error-in-code","error-in-code",-1661931357),cljs.core.first.call(null,p1__12466_SHARP_));
});})(map__12470,map__12470__$1,start_line,path,excerpt,lines,map__12468,map__12468__$1,message_data,message,line,column,file_excerpt))
,lines);
var begin = cljs.core.nth.call(null,vec__12471,(0),null);
var end = cljs.core.nth.call(null,vec__12471,(1),null);
return cljs.core.concat.call(null,cljs.core.take_last.call(null,(5),begin),cljs.core.take.call(null,(1),end),figwheel.core.pointer_message_lines.call(null,message_data),cljs.core.take.call(null,(5),cljs.core.rest.call(null,end)));
} else {
return null;
}
});
figwheel.core.file_line_column = (function figwheel$core$file_line_column(p__12475){
var map__12476 = p__12475;
var map__12476__$1 = (((((!((map__12476 == null))))?(((((map__12476.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12476.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12476):map__12476);
var file = cljs.core.get.call(null,map__12476__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var line = cljs.core.get.call(null,map__12476__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.call(null,map__12476__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var G__12478 = "";
var G__12478__$1 = (cljs.core.truth_(file)?[G__12478,"file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''):G__12478);
var G__12478__$2 = (cljs.core.truth_(line)?[G__12478__$1," at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line)].join(''):G__12478__$1);
if(cljs.core.truth_((function (){var and__4120__auto__ = line;
if(cljs.core.truth_(and__4120__auto__)){
return column;
} else {
return and__4120__auto__;
}
})())){
return [G__12478__$2,", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column)].join('');
} else {
return G__12478__$2;
}
});
if((typeof figwheel !== 'undefined') && (typeof figwheel.core !== 'undefined') && (typeof figwheel.core.logger !== 'undefined')){
} else {
figwheel.core.logger = goog.log.getLogger.call(null,"Figwheel");
}

figwheel.core.glog_info = (function figwheel$core$glog_info(log,msg){
return goog.log.info.call(null,log,msg);
});

figwheel.core.glog_warning = (function figwheel$core$glog_warning(log,msg){
return goog.log.warning.call(null,log,msg);
});

figwheel.core.glog_error = (function figwheel$core$glog_error(log,msg){
return goog.log.error.call(null,log,msg);
});

figwheel.core.console_logging = (function figwheel$core$console_logging(){
if(cljs.core.truth_(goog.object.get(goog.debug.Console,"instance"))){
} else {
var c_12537 = (new goog.debug.Console());
var G__12485_12538 = c_12537.getFormatter();
goog.object.set(G__12485_12538,"showAbsoluteTime",false);

goog.object.set(G__12485_12538,"showRelativeTime",false);


goog.object.set(goog.debug.Console,"instance",c_12537);

}

var temp__5804__auto__ = goog.object.get(goog.debug.Console,"instance");
if(cljs.core.truth_(temp__5804__auto__)){
var console_instance = temp__5804__auto__;
console_instance.setCapturing(true);

return true;
} else {
return null;
}
});
goog.exportSymbol('figwheel.core.console_logging', figwheel.core.console_logging);

if((typeof figwheel !== 'undefined') && (typeof figwheel.core !== 'undefined') && (typeof figwheel.core.log_console !== 'undefined')){
} else {
figwheel.core.log_console = figwheel.core.console_logging.call(null);
}

figwheel.core.event_target = (((typeof document !== 'undefined'))?document:(new goog.events.EventTarget()));
goog.exportSymbol('figwheel.core.event_target', figwheel.core.event_target);

if((typeof figwheel !== 'undefined') && (typeof figwheel.core !== 'undefined') && (typeof figwheel.core.listener_key_map !== 'undefined')){
} else {
figwheel.core.listener_key_map = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}

figwheel.core.unlisten = (function figwheel$core$unlisten(ky,event_name){
var temp__5804__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.core.listener_key_map),ky);
if(cljs.core.truth_(temp__5804__auto__)){
var f = temp__5804__auto__;
return figwheel.core.event_target.removeEventListener(cljs.core.name.call(null,event_name),f);
} else {
return null;
}
});

figwheel.core.listen = (function figwheel$core$listen(ky,event_name,f){
figwheel.core.unlisten.call(null,ky,event_name);

figwheel.core.event_target.addEventListener(cljs.core.name.call(null,event_name),f);

return cljs.core.swap_BANG_.call(null,figwheel.core.listener_key_map,cljs.core.assoc,ky,f);
});

figwheel.core.dispatch_event = (function figwheel$core$dispatch_event(event_name,data){
return figwheel.core.event_target.dispatchEvent((function (){var G__12486 = (((figwheel.core.event_target instanceof goog.events.EventTarget))?(new goog.events.Event(cljs.core.name.call(null,event_name),figwheel.core.event_target)):(new Event(cljs.core.name.call(null,event_name),figwheel.core.event_target)));
goog.object.add(G__12486,"data",(function (){var or__4131__auto__ = data;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})());

return G__12486;
})());
});

figwheel.core.event_data = (function figwheel$core$event_data(e){
return goog.object.get((function (){var temp__5802__auto__ = e.event_;
if(cljs.core.truth_(temp__5802__auto__)){
var e__$1 = temp__5802__auto__;
return e__$1;
} else {
return e;
}
})(),"data");
});


/** @define {boolean} */
goog.define("figwheel.core.load_warninged_code",false);


/** @define {boolean} */
goog.define("figwheel.core.heads_up_display",true);

if((typeof figwheel !== 'undefined') && (typeof figwheel.core !== 'undefined') && (typeof figwheel.core.state !== 'undefined')){
} else {
figwheel.core.state = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("figwheel.core","reload-state","figwheel.core/reload-state",1887223715),cljs.core.PersistentArrayMap.EMPTY], null));
}

figwheel.core.heads_up_display_QMARK_ = (function figwheel$core$heads_up_display_QMARK_(){
return ((figwheel.core.heads_up_display) && ((!((goog.global.document == null)))));
});

var last_reload_timestamp_12539 = cljs.core.atom.call(null,(0));
var promise_chain_12540 = (new goog.Promise(((function (last_reload_timestamp_12539){
return (function (r,_){
return r.call(null,true);
});})(last_reload_timestamp_12539))
));
figwheel.core.render_watcher = ((function (last_reload_timestamp_12539,promise_chain_12540){
return (function figwheel$core$render_watcher(_,___$1,o,n){
if(figwheel.core.heads_up_display_QMARK_.call(null)){
var temp__5802__auto__ = (function (){var temp__5804__auto__ = cljs.core.get_in.call(null,n,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("figwheel.core","reload-state","figwheel.core/reload-state",1887223715),new cljs.core.Keyword(null,"reload-started","reload-started",-1932451477)], null));
if(cljs.core.truth_(temp__5804__auto__)){
var ts = temp__5804__auto__;
var and__4120__auto__ = (cljs.core.deref.call(null,last_reload_timestamp_12539) < ts);
if(and__4120__auto__){
return ts;
} else {
return and__4120__auto__;
}
} else {
return null;
}
})();
if(cljs.core.truth_(temp__5802__auto__)){
var ts = temp__5802__auto__;
var warnings = cljs.core.not_empty.call(null,cljs.core.get_in.call(null,n,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("figwheel.core","reload-state","figwheel.core/reload-state",1887223715),new cljs.core.Keyword(null,"warnings","warnings",-735437651)], null)));
var exception = cljs.core.get_in.call(null,n,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("figwheel.core","reload-state","figwheel.core/reload-state",1887223715),new cljs.core.Keyword(null,"exception","exception",-335277064)], null));
cljs.core.reset_BANG_.call(null,last_reload_timestamp_12539,ts);

if(cljs.core.truth_(warnings)){
return promise_chain_12540.then(((function (warnings,exception,ts,temp__5802__auto__,last_reload_timestamp_12539,promise_chain_12540){
return (function (){
var warn = cljs.core.first.call(null,warnings);
var _STAR_inline_code_message_max_column_STAR__orig_val__12487 = figwheel.core._STAR_inline_code_message_max_column_STAR_;
var _STAR_inline_code_message_max_column_STAR__temp_val__12488 = (132);
figwheel.core._STAR_inline_code_message_max_column_STAR_ = _STAR_inline_code_message_max_column_STAR__temp_val__12488;

try{return figwheel.tools.heads_up.display_warning.call(null,cljs.core.assoc.call(null,warn,new cljs.core.Keyword(null,"error-inline","error-inline",1073987185),figwheel.core.inline_message_display_data.call(null,warn))).then(((function (_STAR_inline_code_message_max_column_STAR__orig_val__12487,_STAR_inline_code_message_max_column_STAR__temp_val__12488,warn,warnings,exception,ts,temp__5802__auto__,last_reload_timestamp_12539,promise_chain_12540){
return (function (){
var seq__12489 = cljs.core.seq.call(null,cljs.core.rest.call(null,warnings));
var chunk__12490 = null;
var count__12491 = (0);
var i__12492 = (0);
while(true){
if((i__12492 < count__12491)){
var w = cljs.core._nth.call(null,chunk__12490,i__12492);
figwheel.tools.heads_up.append_warning_message.call(null,w);


var G__12541 = seq__12489;
var G__12542 = chunk__12490;
var G__12543 = count__12491;
var G__12544 = (i__12492 + (1));
seq__12489 = G__12541;
chunk__12490 = G__12542;
count__12491 = G__12543;
i__12492 = G__12544;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq.call(null,seq__12489);
if(temp__5804__auto__){
var seq__12489__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12489__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__12489__$1);
var G__12545 = cljs.core.chunk_rest.call(null,seq__12489__$1);
var G__12546 = c__4550__auto__;
var G__12547 = cljs.core.count.call(null,c__4550__auto__);
var G__12548 = (0);
seq__12489 = G__12545;
chunk__12490 = G__12546;
count__12491 = G__12547;
i__12492 = G__12548;
continue;
} else {
var w = cljs.core.first.call(null,seq__12489__$1);
figwheel.tools.heads_up.append_warning_message.call(null,w);


var G__12549 = cljs.core.next.call(null,seq__12489__$1);
var G__12550 = null;
var G__12551 = (0);
var G__12552 = (0);
seq__12489 = G__12549;
chunk__12490 = G__12550;
count__12491 = G__12551;
i__12492 = G__12552;
continue;
}
} else {
return null;
}
}
break;
}
});})(_STAR_inline_code_message_max_column_STAR__orig_val__12487,_STAR_inline_code_message_max_column_STAR__temp_val__12488,warn,warnings,exception,ts,temp__5802__auto__,last_reload_timestamp_12539,promise_chain_12540))
);
}finally {figwheel.core._STAR_inline_code_message_max_column_STAR_ = _STAR_inline_code_message_max_column_STAR__orig_val__12487;
}});})(warnings,exception,ts,temp__5802__auto__,last_reload_timestamp_12539,promise_chain_12540))
);
} else {
if(cljs.core.truth_(exception)){
return promise_chain_12540.then(((function (warnings,exception,ts,temp__5802__auto__,last_reload_timestamp_12539,promise_chain_12540){
return (function (){
var _STAR_inline_code_message_max_column_STAR__orig_val__12493 = figwheel.core._STAR_inline_code_message_max_column_STAR_;
var _STAR_inline_code_message_max_column_STAR__temp_val__12494 = (132);
figwheel.core._STAR_inline_code_message_max_column_STAR_ = _STAR_inline_code_message_max_column_STAR__temp_val__12494;

try{return figwheel.tools.heads_up.display_exception.call(null,cljs.core.assoc.call(null,exception,new cljs.core.Keyword(null,"error-inline","error-inline",1073987185),figwheel.core.inline_message_display_data.call(null,exception)));
}finally {figwheel.core._STAR_inline_code_message_max_column_STAR_ = _STAR_inline_code_message_max_column_STAR__orig_val__12493;
}});})(warnings,exception,ts,temp__5802__auto__,last_reload_timestamp_12539,promise_chain_12540))
);
} else {
return promise_chain_12540.then(((function (warnings,exception,ts,temp__5802__auto__,last_reload_timestamp_12539,promise_chain_12540){
return (function (){
return figwheel.tools.heads_up.flash_loaded.call(null);
});})(warnings,exception,ts,temp__5802__auto__,last_reload_timestamp_12539,promise_chain_12540))
);

}
}
} else {
return null;
}
} else {
return null;
}
});})(last_reload_timestamp_12539,promise_chain_12540))
;

cljs.core.add_watch.call(null,figwheel.core.state,new cljs.core.Keyword("figwheel.core","render-watcher","figwheel.core/render-watcher",2046135910),figwheel.core.render_watcher);

figwheel.core.immutable_ns_QMARK_ = (function figwheel$core$immutable_ns_QMARK_(ns){
var ns__$1 = cljs.core.name.call(null,ns);
var or__4131__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, ["cljs.nodejs",null,"goog",null,"figwheel.connect",null,"cljs.core",null,"figwheel.preload",null], null), null).call(null,ns__$1);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var or__4131__auto____$1 = goog.string.startsWith("clojure.",ns__$1);
if(cljs.core.truth_(or__4131__auto____$1)){
return or__4131__auto____$1;
} else {
return goog.string.startsWith("goog.",ns__$1);
}
}
});

figwheel.core.ns_exists_QMARK_ = (function figwheel$core$ns_exists_QMARK_(ns){
return (!((cljs.core.reduce.call(null,cljs.core.fnil.call(null,goog.object.get,({})),goog.global,clojure.string.split.call(null,cljs.core.name.call(null,ns),".")) == null)));
});

figwheel.core.reload_ns_QMARK_ = (function figwheel$core$reload_ns_QMARK_(namespace){
var meta_data = cljs.core.meta.call(null,namespace);
var and__4120__auto__ = cljs.core.not.call(null,figwheel.core.immutable_ns_QMARK_.call(null,namespace));
if(and__4120__auto__){
var and__4120__auto____$1 = cljs.core.not.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_data));
if(and__4120__auto____$1){
var or__4131__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_data);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var or__4131__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_data);
if(cljs.core.truth_(or__4131__auto____$1)){
return or__4131__auto____$1;
} else {
return figwheel.core.ns_exists_QMARK_.call(null,namespace);
}
}
} else {
return and__4120__auto____$1;
}
} else {
return and__4120__auto__;
}
});

figwheel.core.call_hooks = (function figwheel$core$call_hooks(var_args){
var args__4736__auto__ = [];
var len__4730__auto___12553 = arguments.length;
var i__4731__auto___12554 = (0);
while(true){
if((i__4731__auto___12554 < len__4730__auto___12553)){
args__4736__auto__.push((arguments[i__4731__auto___12554]));

var G__12555 = (i__4731__auto___12554 + (1));
i__4731__auto___12554 = G__12555;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return figwheel.core.call_hooks.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

figwheel.core.call_hooks.cljs$core$IFn$_invoke$arity$variadic = (function (hook_key,args){
var hooks = cljs.core.keep.call(null,(function (p__12497){
var vec__12498 = p__12497;
var n = cljs.core.nth.call(null,vec__12498,(0),null);
var mdata = cljs.core.nth.call(null,vec__12498,(1),null);
var temp__5804__auto__ = cljs.core.get_in.call(null,mdata,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"figwheel-hooks","figwheel-hooks",720015356),hook_key], null));
if(cljs.core.truth_(temp__5804__auto__)){
var f = temp__5804__auto__;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [n,f], null);
} else {
return null;
}
}),new cljs.core.Keyword("figwheel.core","metadata","figwheel.core/metadata",-720139885).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,figwheel.core.state)));
var seq__12501 = cljs.core.seq.call(null,hooks);
var chunk__12502 = null;
var count__12503 = (0);
var i__12504 = (0);
while(true){
if((i__12504 < count__12503)){
var vec__12513 = cljs.core._nth.call(null,chunk__12502,i__12504);
var n = cljs.core.nth.call(null,vec__12513,(0),null);
var f = cljs.core.nth.call(null,vec__12513,(1),null);
var temp__5802__auto___12556 = cljs.core.reduce.call(null,((function (seq__12501,chunk__12502,count__12503,i__12504,vec__12513,n,f,hooks){
return (function (p1__12479_SHARP_,p2__12480_SHARP_){
if(cljs.core.truth_(p1__12479_SHARP_)){
return goog.object.get(p1__12479_SHARP_,p2__12480_SHARP_);
} else {
return null;
}
});})(seq__12501,chunk__12502,count__12503,i__12504,vec__12513,n,f,hooks))
,goog.global,cljs.core.map.call(null,cljs.core.str,cljs.core.concat.call(null,clojure.string.split.call(null,n,/\./),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [f], null))));
if(cljs.core.truth_(temp__5802__auto___12556)){
var hook_12557 = temp__5802__auto___12556;
figwheel.core.glog_info.call(null,figwheel.core.logger,["Calling ",cljs.core.pr_str.call(null,hook_key)," hook - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(n),".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(f)].join(''));

try{cljs.core.apply.call(null,hook_12557,args);
}catch (e12516){if((e12516 instanceof Error)){
var e_12558 = e12516;
figwheel.core.glog_error.call(null,figwheel.core.logger,e_12558);
} else {
throw e12516;

}
}} else {
figwheel.core.glog_warning.call(null,figwheel.core.logger,["Unable to find ",cljs.core.pr_str.call(null,hook_key)," hook - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(n),".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(f)].join(''));
}


var G__12559 = seq__12501;
var G__12560 = chunk__12502;
var G__12561 = count__12503;
var G__12562 = (i__12504 + (1));
seq__12501 = G__12559;
chunk__12502 = G__12560;
count__12503 = G__12561;
i__12504 = G__12562;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq.call(null,seq__12501);
if(temp__5804__auto__){
var seq__12501__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12501__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__12501__$1);
var G__12563 = cljs.core.chunk_rest.call(null,seq__12501__$1);
var G__12564 = c__4550__auto__;
var G__12565 = cljs.core.count.call(null,c__4550__auto__);
var G__12566 = (0);
seq__12501 = G__12563;
chunk__12502 = G__12564;
count__12503 = G__12565;
i__12504 = G__12566;
continue;
} else {
var vec__12517 = cljs.core.first.call(null,seq__12501__$1);
var n = cljs.core.nth.call(null,vec__12517,(0),null);
var f = cljs.core.nth.call(null,vec__12517,(1),null);
var temp__5802__auto___12567 = cljs.core.reduce.call(null,((function (seq__12501,chunk__12502,count__12503,i__12504,vec__12517,n,f,seq__12501__$1,temp__5804__auto__,hooks){
return (function (p1__12479_SHARP_,p2__12480_SHARP_){
if(cljs.core.truth_(p1__12479_SHARP_)){
return goog.object.get(p1__12479_SHARP_,p2__12480_SHARP_);
} else {
return null;
}
});})(seq__12501,chunk__12502,count__12503,i__12504,vec__12517,n,f,seq__12501__$1,temp__5804__auto__,hooks))
,goog.global,cljs.core.map.call(null,cljs.core.str,cljs.core.concat.call(null,clojure.string.split.call(null,n,/\./),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [f], null))));
if(cljs.core.truth_(temp__5802__auto___12567)){
var hook_12568 = temp__5802__auto___12567;
figwheel.core.glog_info.call(null,figwheel.core.logger,["Calling ",cljs.core.pr_str.call(null,hook_key)," hook - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(n),".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(f)].join(''));

try{cljs.core.apply.call(null,hook_12568,args);
}catch (e12520){if((e12520 instanceof Error)){
var e_12569 = e12520;
figwheel.core.glog_error.call(null,figwheel.core.logger,e_12569);
} else {
throw e12520;

}
}} else {
figwheel.core.glog_warning.call(null,figwheel.core.logger,["Unable to find ",cljs.core.pr_str.call(null,hook_key)," hook - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(n),".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(f)].join(''));
}


var G__12570 = cljs.core.next.call(null,seq__12501__$1);
var G__12571 = null;
var G__12572 = (0);
var G__12573 = (0);
seq__12501 = G__12570;
chunk__12502 = G__12571;
count__12503 = G__12572;
i__12504 = G__12573;
continue;
}
} else {
return null;
}
}
break;
}
});

figwheel.core.call_hooks.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
figwheel.core.call_hooks.cljs$lang$applyTo = (function (seq12495){
var G__12496 = cljs.core.first.call(null,seq12495);
var seq12495__$1 = cljs.core.next.call(null,seq12495);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12496,seq12495__$1);
});


figwheel.core.reload_namespaces = (function figwheel$core$reload_namespaces(namespaces,figwheel_meta){
var figwheel_meta__$1 = cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,(function (p__12521){
var vec__12522 = p__12521;
var k = cljs.core.nth.call(null,vec__12522,(0),null);
var v = cljs.core.nth.call(null,vec__12522,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.name.call(null,k),v], null);
})),cljs.core.js__GT_clj.call(null,figwheel_meta,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true));
var namespaces__$1 = cljs.core.map.call(null,((function (figwheel_meta__$1){
return (function (p1__12481_SHARP_){
return cljs.core.with_meta.call(null,cljs.core.symbol.call(null,p1__12481_SHARP_),cljs.core.get.call(null,figwheel_meta__$1,p1__12481_SHARP_));
});})(figwheel_meta__$1))
,namespaces);
cljs.core.swap_BANG_.call(null,figwheel.core.state,((function (figwheel_meta__$1,namespaces__$1){
return (function (p1__12482_SHARP_){
return cljs.core.assoc_in.call(null,cljs.core.assoc.call(null,p1__12482_SHARP_,new cljs.core.Keyword("figwheel.core","metadata","figwheel.core/metadata",-720139885),figwheel_meta__$1),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("figwheel.core","reload-state","figwheel.core/reload-state",1887223715),new cljs.core.Keyword(null,"reload-started","reload-started",-1932451477)], null),(new Date()).getTime());
});})(figwheel_meta__$1,namespaces__$1))
);

var to_reload = (cljs.core.truth_((function (){var and__4120__auto__ = (!(figwheel.core.load_warninged_code));
if(and__4120__auto__){
return cljs.core.not_empty.call(null,cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.core.state),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("figwheel.core","reload-state","figwheel.core/reload-state",1887223715),new cljs.core.Keyword(null,"warnings","warnings",-735437651)], null)));
} else {
return and__4120__auto__;
}
})())?null:cljs.core.filter.call(null,((function (figwheel_meta__$1,namespaces__$1){
return (function (p1__12483_SHARP_){
return figwheel.core.reload_ns_QMARK_.call(null,p1__12483_SHARP_);
});})(figwheel_meta__$1,namespaces__$1))
,namespaces__$1));
if(cljs.core.empty_QMARK_.call(null,to_reload)){
} else {
figwheel.core.call_hooks.call(null,new cljs.core.Keyword(null,"before-load","before-load",-2060117064),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),namespaces__$1], null));

setTimeout(((function (to_reload,figwheel_meta__$1,namespaces__$1){
return (function (){
return figwheel.core.dispatch_event.call(null,new cljs.core.Keyword(null,"figwheel.before-load","figwheel.before-load",58978771),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),namespaces__$1], null));
});})(to_reload,figwheel_meta__$1,namespaces__$1))
,(0));
}

var seq__12525_12574 = cljs.core.seq.call(null,to_reload);
var chunk__12526_12575 = null;
var count__12527_12576 = (0);
var i__12528_12577 = (0);
while(true){
if((i__12528_12577 < count__12527_12576)){
var ns_12578 = cljs.core._nth.call(null,chunk__12526_12575,i__12528_12577);
goog.require(cljs.core.name.call(null,ns_12578),true);


var G__12579 = seq__12525_12574;
var G__12580 = chunk__12526_12575;
var G__12581 = count__12527_12576;
var G__12582 = (i__12528_12577 + (1));
seq__12525_12574 = G__12579;
chunk__12526_12575 = G__12580;
count__12527_12576 = G__12581;
i__12528_12577 = G__12582;
continue;
} else {
var temp__5804__auto___12583 = cljs.core.seq.call(null,seq__12525_12574);
if(temp__5804__auto___12583){
var seq__12525_12584__$1 = temp__5804__auto___12583;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12525_12584__$1)){
var c__4550__auto___12585 = cljs.core.chunk_first.call(null,seq__12525_12584__$1);
var G__12586 = cljs.core.chunk_rest.call(null,seq__12525_12584__$1);
var G__12587 = c__4550__auto___12585;
var G__12588 = cljs.core.count.call(null,c__4550__auto___12585);
var G__12589 = (0);
seq__12525_12574 = G__12586;
chunk__12526_12575 = G__12587;
count__12527_12576 = G__12588;
i__12528_12577 = G__12589;
continue;
} else {
var ns_12590 = cljs.core.first.call(null,seq__12525_12584__$1);
goog.require(cljs.core.name.call(null,ns_12590),true);


var G__12591 = cljs.core.next.call(null,seq__12525_12584__$1);
var G__12592 = null;
var G__12593 = (0);
var G__12594 = (0);
seq__12525_12574 = G__12591;
chunk__12526_12575 = G__12592;
count__12527_12576 = G__12593;
i__12528_12577 = G__12594;
continue;
}
} else {
}
}
break;
}

var after_reload_fn_12595 = ((function (to_reload,figwheel_meta__$1,namespaces__$1){
return (function (){
try{if(cljs.core.truth_(cljs.core.not_empty.call(null,to_reload))){
figwheel.core.glog_info.call(null,figwheel.core.logger,["loaded ",cljs.core.pr_str.call(null,to_reload)].join(''));

figwheel.core.call_hooks.call(null,new cljs.core.Keyword(null,"after-load","after-load",-1278503285),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"reloaded-namespaces","reloaded-namespaces",1589557425),to_reload], null));

figwheel.core.dispatch_event.call(null,new cljs.core.Keyword(null,"figwheel.after-load","figwheel.after-load",-1913099389),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"reloaded-namespaces","reloaded-namespaces",1589557425),to_reload], null));
} else {
}

var temp__5804__auto__ = cljs.core.not_empty.call(null,cljs.core.filter.call(null,cljs.core.complement.call(null,cljs.core.set.call(null,to_reload)),namespaces__$1));
if(cljs.core.truth_(temp__5804__auto__)){
var not_loaded = temp__5804__auto__;
return figwheel.core.glog_info.call(null,figwheel.core.logger,["did not load ",cljs.core.pr_str.call(null,not_loaded)].join(''));
} else {
return null;
}
}finally {cljs.core.swap_BANG_.call(null,figwheel.core.state,cljs.core.assoc,new cljs.core.Keyword("figwheel.core","reload-state","figwheel.core/reload-state",1887223715),cljs.core.PersistentArrayMap.EMPTY);
}});})(to_reload,figwheel_meta__$1,namespaces__$1))
;
if((((typeof figwheel !== 'undefined') && (typeof figwheel.repl !== 'undefined')) && ((typeof figwheel !== 'undefined') && (typeof figwheel.repl !== 'undefined') && (typeof figwheel.repl.after_reloads !== 'undefined')))){
figwheel.repl.after_reloads(after_reload_fn_12595);
} else {
setTimeout(after_reload_fn_12595,(100));
}

return null;
});
goog.exportSymbol('figwheel.core.reload_namespaces', figwheel.core.reload_namespaces);

figwheel.core.compile_warnings = (function figwheel$core$compile_warnings(warnings){
if(cljs.core.empty_QMARK_.call(null,warnings)){
} else {
setTimeout((function (){
return figwheel.core.dispatch_event.call(null,new cljs.core.Keyword(null,"figwheel.compile-warnings","figwheel.compile-warnings",-2015032448),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"warnings","warnings",-735437651),warnings], null));
}),(0));
}

cljs.core.swap_BANG_.call(null,figwheel.core.state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("figwheel.core","reload-state","figwheel.core/reload-state",1887223715),new cljs.core.Keyword(null,"warnings","warnings",-735437651)], null),cljs.core.concat,warnings);

var seq__12529 = cljs.core.seq.call(null,warnings);
var chunk__12530 = null;
var count__12531 = (0);
var i__12532 = (0);
while(true){
if((i__12532 < count__12531)){
var warning = cljs.core._nth.call(null,chunk__12530,i__12532);
figwheel.core.glog_warning.call(null,figwheel.core.logger,["Compile Warning - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(warning))," in ",figwheel.core.file_line_column.call(null,warning)].join(''));


var G__12596 = seq__12529;
var G__12597 = chunk__12530;
var G__12598 = count__12531;
var G__12599 = (i__12532 + (1));
seq__12529 = G__12596;
chunk__12530 = G__12597;
count__12531 = G__12598;
i__12532 = G__12599;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq.call(null,seq__12529);
if(temp__5804__auto__){
var seq__12529__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__12529__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__12529__$1);
var G__12600 = cljs.core.chunk_rest.call(null,seq__12529__$1);
var G__12601 = c__4550__auto__;
var G__12602 = cljs.core.count.call(null,c__4550__auto__);
var G__12603 = (0);
seq__12529 = G__12600;
chunk__12530 = G__12601;
count__12531 = G__12602;
i__12532 = G__12603;
continue;
} else {
var warning = cljs.core.first.call(null,seq__12529__$1);
figwheel.core.glog_warning.call(null,figwheel.core.logger,["Compile Warning - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(warning))," in ",figwheel.core.file_line_column.call(null,warning)].join(''));


var G__12604 = cljs.core.next.call(null,seq__12529__$1);
var G__12605 = null;
var G__12606 = (0);
var G__12607 = (0);
seq__12529 = G__12604;
chunk__12530 = G__12605;
count__12531 = G__12606;
i__12532 = G__12607;
continue;
}
} else {
return null;
}
}
break;
}
});
goog.exportSymbol('figwheel.core.compile_warnings', figwheel.core.compile_warnings);

figwheel.core.compile_warnings_remote = (function figwheel$core$compile_warnings_remote(warnings_json){
return figwheel.core.compile_warnings.call(null,cljs.core.js__GT_clj.call(null,warnings_json,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true));
});
goog.exportSymbol('figwheel.core.compile_warnings_remote', figwheel.core.compile_warnings_remote);

figwheel.core.handle_exception = (function figwheel$core$handle_exception(p__12533){
var map__12534 = p__12533;
var map__12534__$1 = (((((!((map__12534 == null))))?(((((map__12534.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12534.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12534):map__12534);
var exception_data = map__12534__$1;
var file = cljs.core.get.call(null,map__12534__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var type = cljs.core.get.call(null,map__12534__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var message = cljs.core.get.call(null,map__12534__$1,new cljs.core.Keyword(null,"message","message",-406056002));
try{setTimeout(((function (map__12534,map__12534__$1,exception_data,file,type,message){
return (function (){
return figwheel.core.dispatch_event.call(null,new cljs.core.Keyword(null,"figwheel.compile-exception","figwheel.compile-exception",1092880746),exception_data);
});})(map__12534,map__12534__$1,exception_data,file,type,message))
,(0));

cljs.core.swap_BANG_.call(null,figwheel.core.state,((function (map__12534,map__12534__$1,exception_data,file,type,message){
return (function (p1__12484_SHARP_){
return cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,p1__12484_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("figwheel.core","reload-state","figwheel.core/reload-state",1887223715),new cljs.core.Keyword(null,"reload-started","reload-started",-1932451477)], null),(new Date()).getTime()),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("figwheel.core","reload-state","figwheel.core/reload-state",1887223715),new cljs.core.Keyword(null,"exception","exception",-335277064)], null),exception_data);
});})(map__12534,map__12534__$1,exception_data,file,type,message))
);

return figwheel.core.glog_warning.call(null,figwheel.core.logger,(function (){var G__12536 = "Compile Exception - ";
var G__12536__$1 = (cljs.core.truth_((function (){var or__4131__auto__ = type;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return message;
}
})())?[G__12536,cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.call(null," : ",cljs.core.filter.call(null,cljs.core.some_QMARK_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [type,message], null))))].join(''):G__12536);
if(cljs.core.truth_(file)){
return [G__12536__$1," in ",figwheel.core.file_line_column.call(null,exception_data)].join('');
} else {
return G__12536__$1;
}
})());
}finally {cljs.core.swap_BANG_.call(null,figwheel.core.state,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("figwheel.core","reload-state","figwheel.core/reload-state",1887223715)], null),cljs.core.PersistentArrayMap.EMPTY);
}});
goog.exportSymbol('figwheel.core.handle_exception', figwheel.core.handle_exception);

figwheel.core.handle_exception_remote = (function figwheel$core$handle_exception_remote(exception_data){
return figwheel.core.handle_exception.call(null,cljs.core.js__GT_clj.call(null,exception_data,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true));
});
goog.exportSymbol('figwheel.core.handle_exception_remote', figwheel.core.handle_exception_remote);

//# sourceMappingURL=core.js.map
