// Compiled by ClojureScript 1.10.516 {}
goog.provide('cljs.repl');
goog.require('cljs.core');
goog.require('cljs.spec.alpha');
goog.require('goog.string');
goog.require('goog.string.format');
cljs.repl.print_doc = (function cljs$repl$print_doc(p__17964){
var map__17965 = p__17964;
var map__17965__$1 = (((((!((map__17965 == null))))?(((((map__17965.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17965.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17965):map__17965);
var m = map__17965__$1;
var n = cljs.core.get.call(null,map__17965__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var nm = cljs.core.get.call(null,map__17965__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.println.call(null,"-------------------------");

cljs.core.println.call(null,(function (){var or__4131__auto__ = new cljs.core.Keyword(null,"spec","spec",347520401).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return [(function (){var temp__5720__auto__ = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(temp__5720__auto__)){
var ns = temp__5720__auto__;
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/"].join('');
} else {
return null;
}
})(),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(m))].join('');
}
})());

if(cljs.core.truth_(new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Protocol");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"forms","forms",2045992350).cljs$core$IFn$_invoke$arity$1(m))){
var seq__17967_17999 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"forms","forms",2045992350).cljs$core$IFn$_invoke$arity$1(m));
var chunk__17968_18000 = null;
var count__17969_18001 = (0);
var i__17970_18002 = (0);
while(true){
if((i__17970_18002 < count__17969_18001)){
var f_18003 = cljs.core._nth.call(null,chunk__17968_18000,i__17970_18002);
cljs.core.println.call(null,"  ",f_18003);


var G__18004 = seq__17967_17999;
var G__18005 = chunk__17968_18000;
var G__18006 = count__17969_18001;
var G__18007 = (i__17970_18002 + (1));
seq__17967_17999 = G__18004;
chunk__17968_18000 = G__18005;
count__17969_18001 = G__18006;
i__17970_18002 = G__18007;
continue;
} else {
var temp__5720__auto___18008 = cljs.core.seq.call(null,seq__17967_17999);
if(temp__5720__auto___18008){
var seq__17967_18009__$1 = temp__5720__auto___18008;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__17967_18009__$1)){
var c__4550__auto___18010 = cljs.core.chunk_first.call(null,seq__17967_18009__$1);
var G__18011 = cljs.core.chunk_rest.call(null,seq__17967_18009__$1);
var G__18012 = c__4550__auto___18010;
var G__18013 = cljs.core.count.call(null,c__4550__auto___18010);
var G__18014 = (0);
seq__17967_17999 = G__18011;
chunk__17968_18000 = G__18012;
count__17969_18001 = G__18013;
i__17970_18002 = G__18014;
continue;
} else {
var f_18015 = cljs.core.first.call(null,seq__17967_18009__$1);
cljs.core.println.call(null,"  ",f_18015);


var G__18016 = cljs.core.next.call(null,seq__17967_18009__$1);
var G__18017 = null;
var G__18018 = (0);
var G__18019 = (0);
seq__17967_17999 = G__18016;
chunk__17968_18000 = G__18017;
count__17969_18001 = G__18018;
i__17970_18002 = G__18019;
continue;
}
} else {
}
}
break;
}
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"arglists","arglists",1661989754).cljs$core$IFn$_invoke$arity$1(m))){
var arglists_18020 = new cljs.core.Keyword(null,"arglists","arglists",1661989754).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_((function (){var or__4131__auto__ = new cljs.core.Keyword(null,"macro","macro",-867863404).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return new cljs.core.Keyword(null,"repl-special-function","repl-special-function",1262603725).cljs$core$IFn$_invoke$arity$1(m);
}
})())){
cljs.core.prn.call(null,arglists_18020);
} else {
cljs.core.prn.call(null,((cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.first.call(null,arglists_18020)))?cljs.core.second.call(null,arglists_18020):arglists_18020));
}
} else {
}
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"special-form","special-form",-1326536374).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Special Form");

cljs.core.println.call(null," ",new cljs.core.Keyword(null,"doc","doc",1913296891).cljs$core$IFn$_invoke$arity$1(m));

if(cljs.core.contains_QMARK_.call(null,m,new cljs.core.Keyword(null,"url","url",276297046))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(m))){
return cljs.core.println.call(null,["\n  Please see http://clojure.org/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(m))].join(''));
} else {
return null;
}
} else {
return cljs.core.println.call(null,["\n  Please see http://clojure.org/special_forms#",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(m))].join(''));
}
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"macro","macro",-867863404).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Macro");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"spec","spec",347520401).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Spec");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-special-function","repl-special-function",1262603725).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"REPL Special Function");
} else {
}

cljs.core.println.call(null," ",new cljs.core.Keyword(null,"doc","doc",1913296891).cljs$core$IFn$_invoke$arity$1(m));

if(cljs.core.truth_(new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(m))){
var seq__17971_18021 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"methods","methods",453930866).cljs$core$IFn$_invoke$arity$1(m));
var chunk__17972_18022 = null;
var count__17973_18023 = (0);
var i__17974_18024 = (0);
while(true){
if((i__17974_18024 < count__17973_18023)){
var vec__17985_18025 = cljs.core._nth.call(null,chunk__17972_18022,i__17974_18024);
var name_18026 = cljs.core.nth.call(null,vec__17985_18025,(0),null);
var map__17988_18027 = cljs.core.nth.call(null,vec__17985_18025,(1),null);
var map__17988_18028__$1 = (((((!((map__17988_18027 == null))))?(((((map__17988_18027.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17988_18027.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17988_18027):map__17988_18027);
var doc_18029 = cljs.core.get.call(null,map__17988_18028__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var arglists_18030 = cljs.core.get.call(null,map__17988_18028__$1,new cljs.core.Keyword(null,"arglists","arglists",1661989754));
cljs.core.println.call(null);

cljs.core.println.call(null," ",name_18026);

cljs.core.println.call(null," ",arglists_18030);

if(cljs.core.truth_(doc_18029)){
cljs.core.println.call(null," ",doc_18029);
} else {
}


var G__18031 = seq__17971_18021;
var G__18032 = chunk__17972_18022;
var G__18033 = count__17973_18023;
var G__18034 = (i__17974_18024 + (1));
seq__17971_18021 = G__18031;
chunk__17972_18022 = G__18032;
count__17973_18023 = G__18033;
i__17974_18024 = G__18034;
continue;
} else {
var temp__5720__auto___18035 = cljs.core.seq.call(null,seq__17971_18021);
if(temp__5720__auto___18035){
var seq__17971_18036__$1 = temp__5720__auto___18035;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__17971_18036__$1)){
var c__4550__auto___18037 = cljs.core.chunk_first.call(null,seq__17971_18036__$1);
var G__18038 = cljs.core.chunk_rest.call(null,seq__17971_18036__$1);
var G__18039 = c__4550__auto___18037;
var G__18040 = cljs.core.count.call(null,c__4550__auto___18037);
var G__18041 = (0);
seq__17971_18021 = G__18038;
chunk__17972_18022 = G__18039;
count__17973_18023 = G__18040;
i__17974_18024 = G__18041;
continue;
} else {
var vec__17990_18042 = cljs.core.first.call(null,seq__17971_18036__$1);
var name_18043 = cljs.core.nth.call(null,vec__17990_18042,(0),null);
var map__17993_18044 = cljs.core.nth.call(null,vec__17990_18042,(1),null);
var map__17993_18045__$1 = (((((!((map__17993_18044 == null))))?(((((map__17993_18044.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17993_18044.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17993_18044):map__17993_18044);
var doc_18046 = cljs.core.get.call(null,map__17993_18045__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var arglists_18047 = cljs.core.get.call(null,map__17993_18045__$1,new cljs.core.Keyword(null,"arglists","arglists",1661989754));
cljs.core.println.call(null);

cljs.core.println.call(null," ",name_18043);

cljs.core.println.call(null," ",arglists_18047);

if(cljs.core.truth_(doc_18046)){
cljs.core.println.call(null," ",doc_18046);
} else {
}


var G__18048 = cljs.core.next.call(null,seq__17971_18036__$1);
var G__18049 = null;
var G__18050 = (0);
var G__18051 = (0);
seq__17971_18021 = G__18048;
chunk__17972_18022 = G__18049;
count__17973_18023 = G__18050;
i__17974_18024 = G__18051;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(n)){
var temp__5720__auto__ = cljs.spec.alpha.get_spec.call(null,cljs.core.symbol.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.ns_name.call(null,n)),cljs.core.name.call(null,nm)));
if(cljs.core.truth_(temp__5720__auto__)){
var fnspec = temp__5720__auto__;
cljs.core.print.call(null,"Spec");

var seq__17995 = cljs.core.seq.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Keyword(null,"fn","fn",-1175266204)], null));
var chunk__17996 = null;
var count__17997 = (0);
var i__17998 = (0);
while(true){
if((i__17998 < count__17997)){
var role = cljs.core._nth.call(null,chunk__17996,i__17998);
var temp__5720__auto___18052__$1 = cljs.core.get.call(null,fnspec,role);
if(cljs.core.truth_(temp__5720__auto___18052__$1)){
var spec_18053 = temp__5720__auto___18052__$1;
cljs.core.print.call(null,["\n ",cljs.core.name.call(null,role),":"].join(''),cljs.spec.alpha.describe.call(null,spec_18053));
} else {
}


var G__18054 = seq__17995;
var G__18055 = chunk__17996;
var G__18056 = count__17997;
var G__18057 = (i__17998 + (1));
seq__17995 = G__18054;
chunk__17996 = G__18055;
count__17997 = G__18056;
i__17998 = G__18057;
continue;
} else {
var temp__5720__auto____$1 = cljs.core.seq.call(null,seq__17995);
if(temp__5720__auto____$1){
var seq__17995__$1 = temp__5720__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__17995__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__17995__$1);
var G__18058 = cljs.core.chunk_rest.call(null,seq__17995__$1);
var G__18059 = c__4550__auto__;
var G__18060 = cljs.core.count.call(null,c__4550__auto__);
var G__18061 = (0);
seq__17995 = G__18058;
chunk__17996 = G__18059;
count__17997 = G__18060;
i__17998 = G__18061;
continue;
} else {
var role = cljs.core.first.call(null,seq__17995__$1);
var temp__5720__auto___18062__$2 = cljs.core.get.call(null,fnspec,role);
if(cljs.core.truth_(temp__5720__auto___18062__$2)){
var spec_18063 = temp__5720__auto___18062__$2;
cljs.core.print.call(null,["\n ",cljs.core.name.call(null,role),":"].join(''),cljs.spec.alpha.describe.call(null,spec_18063));
} else {
}


var G__18064 = cljs.core.next.call(null,seq__17995__$1);
var G__18065 = null;
var G__18066 = (0);
var G__18067 = (0);
seq__17995 = G__18064;
chunk__17996 = G__18065;
count__17997 = G__18066;
i__17998 = G__18067;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Constructs a data representation for a Error with keys:
 *  :cause - root cause message
 *  :phase - error phase
 *  :via - cause chain, with cause keys:
 *           :type - exception class symbol
 *           :message - exception message
 *           :data - ex-data
 *           :at - top stack element
 *  :trace - root cause stack elements
 */
cljs.repl.Error__GT_map = (function cljs$repl$Error__GT_map(o){
var base = (function (t){
return cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"type","type",1174270348),(((t instanceof cljs.core.ExceptionInfo))?new cljs.core.Symbol(null,"ExceptionInfo","ExceptionInfo",294935087,null):(((t instanceof EvalError))?new cljs.core.Symbol("js","EvalError","js/EvalError",1793498501,null):(((t instanceof RangeError))?new cljs.core.Symbol("js","RangeError","js/RangeError",1703848089,null):(((t instanceof ReferenceError))?new cljs.core.Symbol("js","ReferenceError","js/ReferenceError",-198403224,null):(((t instanceof SyntaxError))?new cljs.core.Symbol("js","SyntaxError","js/SyntaxError",-1527651665,null):(((t instanceof URIError))?new cljs.core.Symbol("js","URIError","js/URIError",505061350,null):(((t instanceof Error))?new cljs.core.Symbol("js","Error","js/Error",-1692659266,null):null
)))))))], null),(function (){var temp__5720__auto__ = cljs.core.ex_message.call(null,t);
if(cljs.core.truth_(temp__5720__auto__)){
var msg = temp__5720__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"message","message",-406056002),msg], null);
} else {
return null;
}
})(),(function (){var temp__5720__auto__ = cljs.core.ex_data.call(null,t);
if(cljs.core.truth_(temp__5720__auto__)){
var ed = temp__5720__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),ed], null);
} else {
return null;
}
})());
});
var via = (function (){var via = cljs.core.PersistentVector.EMPTY;
var t = o;
while(true){
if(cljs.core.truth_(t)){
var G__18068 = cljs.core.conj.call(null,via,t);
var G__18069 = cljs.core.ex_cause.call(null,t);
via = G__18068;
t = G__18069;
continue;
} else {
return via;
}
break;
}
})();
var root = cljs.core.peek.call(null,via);
return cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"via","via",-1904457336),cljs.core.vec.call(null,cljs.core.map.call(null,base,via)),new cljs.core.Keyword(null,"trace","trace",-1082747415),null], null),(function (){var temp__5720__auto__ = cljs.core.ex_message.call(null,root);
if(cljs.core.truth_(temp__5720__auto__)){
var root_msg = temp__5720__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cause","cause",231901252),root_msg], null);
} else {
return null;
}
})(),(function (){var temp__5720__auto__ = cljs.core.ex_data.call(null,root);
if(cljs.core.truth_(temp__5720__auto__)){
var data = temp__5720__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),data], null);
} else {
return null;
}
})(),(function (){var temp__5720__auto__ = new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358).cljs$core$IFn$_invoke$arity$1(cljs.core.ex_data.call(null,o));
if(cljs.core.truth_(temp__5720__auto__)){
var phase = temp__5720__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"phase","phase",575722892),phase], null);
} else {
return null;
}
})());
});
/**
 * Returns an analysis of the phase, error, cause, and location of an error that occurred
 *   based on Throwable data, as returned by Throwable->map. All attributes other than phase
 *   are optional:
 *  :clojure.error/phase - keyword phase indicator, one of:
 *    :read-source :compile-syntax-check :compilation :macro-syntax-check :macroexpansion
 *    :execution :read-eval-result :print-eval-result
 *  :clojure.error/source - file name (no path)
 *  :clojure.error/line - integer line number
 *  :clojure.error/column - integer column number
 *  :clojure.error/symbol - symbol being expanded/compiled/invoked
 *  :clojure.error/class - cause exception class symbol
 *  :clojure.error/cause - cause exception message
 *  :clojure.error/spec - explain-data for spec error
 */
cljs.repl.ex_triage = (function cljs$repl$ex_triage(datafied_throwable){
var map__18072 = datafied_throwable;
var map__18072__$1 = (((((!((map__18072 == null))))?(((((map__18072.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18072.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18072):map__18072);
var via = cljs.core.get.call(null,map__18072__$1,new cljs.core.Keyword(null,"via","via",-1904457336));
var trace = cljs.core.get.call(null,map__18072__$1,new cljs.core.Keyword(null,"trace","trace",-1082747415));
var phase = cljs.core.get.call(null,map__18072__$1,new cljs.core.Keyword(null,"phase","phase",575722892),new cljs.core.Keyword(null,"execution","execution",253283524));
var map__18073 = cljs.core.last.call(null,via);
var map__18073__$1 = (((((!((map__18073 == null))))?(((((map__18073.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18073.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18073):map__18073);
var type = cljs.core.get.call(null,map__18073__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var message = cljs.core.get.call(null,map__18073__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var data = cljs.core.get.call(null,map__18073__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var map__18074 = data;
var map__18074__$1 = (((((!((map__18074 == null))))?(((((map__18074.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18074.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18074):map__18074);
var problems = cljs.core.get.call(null,map__18074__$1,new cljs.core.Keyword("cljs.spec.alpha","problems","cljs.spec.alpha/problems",447400814));
var fn = cljs.core.get.call(null,map__18074__$1,new cljs.core.Keyword("cljs.spec.alpha","fn","cljs.spec.alpha/fn",408600443));
var caller = cljs.core.get.call(null,map__18074__$1,new cljs.core.Keyword("cljs.spec.test.alpha","caller","cljs.spec.test.alpha/caller",-398302390));
var map__18075 = new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,via));
var map__18075__$1 = (((((!((map__18075 == null))))?(((((map__18075.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18075.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18075):map__18075);
var top_data = map__18075__$1;
var source = cljs.core.get.call(null,map__18075__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397));
return cljs.core.assoc.call(null,(function (){var G__18080 = phase;
var G__18080__$1 = (((G__18080 instanceof cljs.core.Keyword))?G__18080.fqn:null);
switch (G__18080__$1) {
case "read-source":
var map__18081 = data;
var map__18081__$1 = (((((!((map__18081 == null))))?(((((map__18081.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18081.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18081):map__18081);
var line = cljs.core.get.call(null,map__18081__$1,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471));
var column = cljs.core.get.call(null,map__18081__$1,new cljs.core.Keyword("clojure.error","column","clojure.error/column",304721553));
var G__18083 = cljs.core.merge.call(null,new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,via)),top_data);
var G__18083__$1 = (cljs.core.truth_(source)?cljs.core.assoc.call(null,G__18083,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),source):G__18083);
var G__18083__$2 = (cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["NO_SOURCE_PATH",null,"NO_SOURCE_FILE",null], null), null).call(null,source))?cljs.core.dissoc.call(null,G__18083__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397)):G__18083__$1);
if(cljs.core.truth_(message)){
return cljs.core.assoc.call(null,G__18083__$2,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message);
} else {
return G__18083__$2;
}

break;
case "compile-syntax-check":
case "compilation":
case "macro-syntax-check":
case "macroexpansion":
var G__18084 = top_data;
var G__18084__$1 = (cljs.core.truth_(source)?cljs.core.assoc.call(null,G__18084,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),source):G__18084);
var G__18084__$2 = (cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["NO_SOURCE_PATH",null,"NO_SOURCE_FILE",null], null), null).call(null,source))?cljs.core.dissoc.call(null,G__18084__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397)):G__18084__$1);
var G__18084__$3 = (cljs.core.truth_(type)?cljs.core.assoc.call(null,G__18084__$2,new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890),type):G__18084__$2);
var G__18084__$4 = (cljs.core.truth_(message)?cljs.core.assoc.call(null,G__18084__$3,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message):G__18084__$3);
if(cljs.core.truth_(problems)){
return cljs.core.assoc.call(null,G__18084__$4,new cljs.core.Keyword("clojure.error","spec","clojure.error/spec",2055032595),data);
} else {
return G__18084__$4;
}

break;
case "read-eval-result":
case "print-eval-result":
var vec__18085 = cljs.core.first.call(null,trace);
var source__$1 = cljs.core.nth.call(null,vec__18085,(0),null);
var method = cljs.core.nth.call(null,vec__18085,(1),null);
var file = cljs.core.nth.call(null,vec__18085,(2),null);
var line = cljs.core.nth.call(null,vec__18085,(3),null);
var G__18088 = top_data;
var G__18088__$1 = (cljs.core.truth_(line)?cljs.core.assoc.call(null,G__18088,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471),line):G__18088);
var G__18088__$2 = (cljs.core.truth_(file)?cljs.core.assoc.call(null,G__18088__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),file):G__18088__$1);
var G__18088__$3 = (cljs.core.truth_((function (){var and__4120__auto__ = source__$1;
if(cljs.core.truth_(and__4120__auto__)){
return method;
} else {
return and__4120__auto__;
}
})())?cljs.core.assoc.call(null,G__18088__$2,new cljs.core.Keyword("clojure.error","symbol","clojure.error/symbol",1544821994),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[source__$1,method],null))):G__18088__$2);
var G__18088__$4 = (cljs.core.truth_(type)?cljs.core.assoc.call(null,G__18088__$3,new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890),type):G__18088__$3);
if(cljs.core.truth_(message)){
return cljs.core.assoc.call(null,G__18088__$4,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message);
} else {
return G__18088__$4;
}

break;
case "execution":
var vec__18089 = cljs.core.first.call(null,trace);
var source__$1 = cljs.core.nth.call(null,vec__18089,(0),null);
var method = cljs.core.nth.call(null,vec__18089,(1),null);
var file = cljs.core.nth.call(null,vec__18089,(2),null);
var line = cljs.core.nth.call(null,vec__18089,(3),null);
var file__$1 = cljs.core.first.call(null,cljs.core.remove.call(null,((function (vec__18089,source__$1,method,file,line,G__18080,G__18080__$1,map__18072,map__18072__$1,via,trace,phase,map__18073,map__18073__$1,type,message,data,map__18074,map__18074__$1,problems,fn,caller,map__18075,map__18075__$1,top_data,source){
return (function (p1__18071_SHARP_){
var or__4131__auto__ = (p1__18071_SHARP_ == null);
if(or__4131__auto__){
return or__4131__auto__;
} else {
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["NO_SOURCE_PATH",null,"NO_SOURCE_FILE",null], null), null).call(null,p1__18071_SHARP_);
}
});})(vec__18089,source__$1,method,file,line,G__18080,G__18080__$1,map__18072,map__18072__$1,via,trace,phase,map__18073,map__18073__$1,type,message,data,map__18074,map__18074__$1,problems,fn,caller,map__18075,map__18075__$1,top_data,source))
,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(caller),file], null)));
var err_line = (function (){var or__4131__auto__ = new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(caller);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return line;
}
})();
var G__18092 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890),type], null);
var G__18092__$1 = (cljs.core.truth_(err_line)?cljs.core.assoc.call(null,G__18092,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471),err_line):G__18092);
var G__18092__$2 = (cljs.core.truth_(message)?cljs.core.assoc.call(null,G__18092__$1,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message):G__18092__$1);
var G__18092__$3 = (cljs.core.truth_((function (){var or__4131__auto__ = fn;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var and__4120__auto__ = source__$1;
if(cljs.core.truth_(and__4120__auto__)){
return method;
} else {
return and__4120__auto__;
}
}
})())?cljs.core.assoc.call(null,G__18092__$2,new cljs.core.Keyword("clojure.error","symbol","clojure.error/symbol",1544821994),(function (){var or__4131__auto__ = fn;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[source__$1,method],null));
}
})()):G__18092__$2);
var G__18092__$4 = (cljs.core.truth_(file__$1)?cljs.core.assoc.call(null,G__18092__$3,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),file__$1):G__18092__$3);
if(cljs.core.truth_(problems)){
return cljs.core.assoc.call(null,G__18092__$4,new cljs.core.Keyword("clojure.error","spec","clojure.error/spec",2055032595),data);
} else {
return G__18092__$4;
}

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__18080__$1)].join('')));

}
})(),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),phase);
});
/**
 * Returns a string from exception data, as produced by ex-triage.
 *   The first line summarizes the exception phase and location.
 *   The subsequent lines describe the cause.
 */
cljs.repl.ex_str = (function cljs$repl$ex_str(p__18096){
var map__18097 = p__18096;
var map__18097__$1 = (((((!((map__18097 == null))))?(((((map__18097.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18097.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18097):map__18097);
var triage_data = map__18097__$1;
var phase = cljs.core.get.call(null,map__18097__$1,new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358));
var source = cljs.core.get.call(null,map__18097__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397));
var line = cljs.core.get.call(null,map__18097__$1,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471));
var column = cljs.core.get.call(null,map__18097__$1,new cljs.core.Keyword("clojure.error","column","clojure.error/column",304721553));
var symbol = cljs.core.get.call(null,map__18097__$1,new cljs.core.Keyword("clojure.error","symbol","clojure.error/symbol",1544821994));
var class$ = cljs.core.get.call(null,map__18097__$1,new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890));
var cause = cljs.core.get.call(null,map__18097__$1,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742));
var spec = cljs.core.get.call(null,map__18097__$1,new cljs.core.Keyword("clojure.error","spec","clojure.error/spec",2055032595));
var loc = [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4131__auto__ = source;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return "<cljs repl>";
}
})()),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4131__auto__ = line;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (1);
}
})()),(cljs.core.truth_(column)?[":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column)].join(''):"")].join('');
var class_name = cljs.core.name.call(null,(function (){var or__4131__auto__ = class$;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return "";
}
})());
var simple_class = class_name;
var cause_type = ((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["RuntimeException",null,"Exception",null], null), null),simple_class))?"":[" (",simple_class,")"].join(''));
var format = goog.string.format;
var G__18099 = phase;
var G__18099__$1 = (((G__18099 instanceof cljs.core.Keyword))?G__18099.fqn:null);
switch (G__18099__$1) {
case "read-source":
return format.call(null,"Syntax error reading source at (%s).\n%s\n",loc,cause);

break;
case "macro-syntax-check":
return format.call(null,"Syntax error macroexpanding %sat (%s).\n%s",(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,(cljs.core.truth_(spec)?(function (){var sb__4661__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__18100_18109 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__18101_18110 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__18102_18111 = true;
var _STAR_print_fn_STAR__temp_val__18103_18112 = ((function (_STAR_print_newline_STAR__orig_val__18100_18109,_STAR_print_fn_STAR__orig_val__18101_18110,_STAR_print_newline_STAR__temp_val__18102_18111,sb__4661__auto__,G__18099,G__18099__$1,loc,class_name,simple_class,cause_type,format,map__18097,map__18097__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec){
return (function (x__4662__auto__){
return sb__4661__auto__.append(x__4662__auto__);
});})(_STAR_print_newline_STAR__orig_val__18100_18109,_STAR_print_fn_STAR__orig_val__18101_18110,_STAR_print_newline_STAR__temp_val__18102_18111,sb__4661__auto__,G__18099,G__18099__$1,loc,class_name,simple_class,cause_type,format,map__18097,map__18097__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec))
;
cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__18102_18111;

cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__18103_18112;

try{cljs.spec.alpha.explain_out.call(null,cljs.core.update.call(null,spec,new cljs.core.Keyword("cljs.spec.alpha","problems","cljs.spec.alpha/problems",447400814),((function (_STAR_print_newline_STAR__orig_val__18100_18109,_STAR_print_fn_STAR__orig_val__18101_18110,_STAR_print_newline_STAR__temp_val__18102_18111,_STAR_print_fn_STAR__temp_val__18103_18112,sb__4661__auto__,G__18099,G__18099__$1,loc,class_name,simple_class,cause_type,format,map__18097,map__18097__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec){
return (function (probs){
return cljs.core.map.call(null,((function (_STAR_print_newline_STAR__orig_val__18100_18109,_STAR_print_fn_STAR__orig_val__18101_18110,_STAR_print_newline_STAR__temp_val__18102_18111,_STAR_print_fn_STAR__temp_val__18103_18112,sb__4661__auto__,G__18099,G__18099__$1,loc,class_name,simple_class,cause_type,format,map__18097,map__18097__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec){
return (function (p1__18094_SHARP_){
return cljs.core.dissoc.call(null,p1__18094_SHARP_,new cljs.core.Keyword(null,"in","in",-1531184865));
});})(_STAR_print_newline_STAR__orig_val__18100_18109,_STAR_print_fn_STAR__orig_val__18101_18110,_STAR_print_newline_STAR__temp_val__18102_18111,_STAR_print_fn_STAR__temp_val__18103_18112,sb__4661__auto__,G__18099,G__18099__$1,loc,class_name,simple_class,cause_type,format,map__18097,map__18097__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec))
,probs);
});})(_STAR_print_newline_STAR__orig_val__18100_18109,_STAR_print_fn_STAR__orig_val__18101_18110,_STAR_print_newline_STAR__temp_val__18102_18111,_STAR_print_fn_STAR__temp_val__18103_18112,sb__4661__auto__,G__18099,G__18099__$1,loc,class_name,simple_class,cause_type,format,map__18097,map__18097__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec))
)
);
}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__18101_18110;

cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__18100_18109;
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4661__auto__);
})():format.call(null,"%s\n",cause)));

break;
case "macroexpansion":
return format.call(null,"Unexpected error%s macroexpanding %sat (%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);

break;
case "compile-syntax-check":
return format.call(null,"Syntax error%s compiling %sat (%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);

break;
case "compilation":
return format.call(null,"Unexpected error%s compiling %sat (%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);

break;
case "read-eval-result":
return format.call(null,"Error reading eval result%s at %s (%s).\n%s\n",cause_type,symbol,loc,cause);

break;
case "print-eval-result":
return format.call(null,"Error printing return value%s at %s (%s).\n%s\n",cause_type,symbol,loc,cause);

break;
case "execution":
if(cljs.core.truth_(spec)){
return format.call(null,"Execution error - invalid arguments to %s at (%s).\n%s",symbol,loc,(function (){var sb__4661__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__18104_18113 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__18105_18114 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__18106_18115 = true;
var _STAR_print_fn_STAR__temp_val__18107_18116 = ((function (_STAR_print_newline_STAR__orig_val__18104_18113,_STAR_print_fn_STAR__orig_val__18105_18114,_STAR_print_newline_STAR__temp_val__18106_18115,sb__4661__auto__,G__18099,G__18099__$1,loc,class_name,simple_class,cause_type,format,map__18097,map__18097__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec){
return (function (x__4662__auto__){
return sb__4661__auto__.append(x__4662__auto__);
});})(_STAR_print_newline_STAR__orig_val__18104_18113,_STAR_print_fn_STAR__orig_val__18105_18114,_STAR_print_newline_STAR__temp_val__18106_18115,sb__4661__auto__,G__18099,G__18099__$1,loc,class_name,simple_class,cause_type,format,map__18097,map__18097__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec))
;
cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__18106_18115;

cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__18107_18116;

try{cljs.spec.alpha.explain_out.call(null,cljs.core.update.call(null,spec,new cljs.core.Keyword("cljs.spec.alpha","problems","cljs.spec.alpha/problems",447400814),((function (_STAR_print_newline_STAR__orig_val__18104_18113,_STAR_print_fn_STAR__orig_val__18105_18114,_STAR_print_newline_STAR__temp_val__18106_18115,_STAR_print_fn_STAR__temp_val__18107_18116,sb__4661__auto__,G__18099,G__18099__$1,loc,class_name,simple_class,cause_type,format,map__18097,map__18097__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec){
return (function (probs){
return cljs.core.map.call(null,((function (_STAR_print_newline_STAR__orig_val__18104_18113,_STAR_print_fn_STAR__orig_val__18105_18114,_STAR_print_newline_STAR__temp_val__18106_18115,_STAR_print_fn_STAR__temp_val__18107_18116,sb__4661__auto__,G__18099,G__18099__$1,loc,class_name,simple_class,cause_type,format,map__18097,map__18097__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec){
return (function (p1__18095_SHARP_){
return cljs.core.dissoc.call(null,p1__18095_SHARP_,new cljs.core.Keyword(null,"in","in",-1531184865));
});})(_STAR_print_newline_STAR__orig_val__18104_18113,_STAR_print_fn_STAR__orig_val__18105_18114,_STAR_print_newline_STAR__temp_val__18106_18115,_STAR_print_fn_STAR__temp_val__18107_18116,sb__4661__auto__,G__18099,G__18099__$1,loc,class_name,simple_class,cause_type,format,map__18097,map__18097__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec))
,probs);
});})(_STAR_print_newline_STAR__orig_val__18104_18113,_STAR_print_fn_STAR__orig_val__18105_18114,_STAR_print_newline_STAR__temp_val__18106_18115,_STAR_print_fn_STAR__temp_val__18107_18116,sb__4661__auto__,G__18099,G__18099__$1,loc,class_name,simple_class,cause_type,format,map__18097,map__18097__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec))
)
);
}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__18105_18114;

cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__18104_18113;
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4661__auto__);
})());
} else {
return format.call(null,"Execution error%s at %s(%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);
}

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__18099__$1)].join('')));

}
});
cljs.repl.error__GT_str = (function cljs$repl$error__GT_str(error){
return cljs.repl.ex_str.call(null,cljs.repl.ex_triage.call(null,cljs.repl.Error__GT_map.call(null,error)));
});

//# sourceMappingURL=repl.js.map
