/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz.impl;

import java.util.Arrays;
import mikera.indexz.Index;
import mikera.vectorz.AVector;
import mikera.vectorz.ArrayVector;
import mikera.vectorz.Vector;
import mikera.vectorz.impl.ASparseVector;
import mikera.vectorz.util.VectorzException;

public class SparseIndexedVector
extends ASparseVector {
    private static final long serialVersionUID = 750093598603613879L;
    private final int length;
    public final Index index;
    public final double[] data;

    private SparseIndexedVector(int length, Index index) {
        this(length, index, new double[index.length()]);
    }

    private SparseIndexedVector(int length, Index index, double[] data) {
        this.length = length;
        this.index = index;
        this.data = data;
    }

    private SparseIndexedVector(int length, Index index, AVector data) {
        this.length = length;
        this.index = index;
        this.data = new double[index.length()];
        data.copyTo(this.data, 0);
    }

    public static SparseIndexedVector wrap(int length, Index index, double[] data) {
        assert (index.length() == data.length);
        assert (index.isDistinctSorted());
        return new SparseIndexedVector(length, index, data);
    }

    public static SparseIndexedVector create(int length, Index index, double[] data) {
        if (!index.isDistinctSorted()) {
            throw new VectorzException("Index must be sorted and distinct");
        }
        if (index.length() != data.length) {
            throw new VectorzException("Length of index: mismatch woth data");
        }
        return new SparseIndexedVector(length, index, data);
    }

    public static SparseIndexedVector create(int length, Index index, AVector data) {
        SparseIndexedVector sv = SparseIndexedVector.create(length, index, new double[index.length()]);
        data.copyTo(sv.data, 0);
        return sv;
    }

    @Override
    public int nonSparseElementCount() {
        return this.data.length;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public void multiply(AVector v) {
        if (v instanceof ArrayVector) {
            this.multiply((ArrayVector)v);
            return;
        }
        for (int i = 0; i < this.data.length; ++i) {
            int n = i;
            this.data[n] = this.data[n] * v.get(this.index.data[i]);
        }
    }

    public void multiply(ArrayVector v) {
        this.multiply(v.getArray(), v.getArrayOffset());
    }

    @Override
    public void multiply(double[] array, int offset) {
        for (int i = 0; i < this.data.length; ++i) {
            int n = i;
            this.data[n] = this.data[n] * array[offset + this.index.data[i]];
        }
    }

    @Override
    public double magnitudeSquared() {
        double result = 0.0;
        for (int i = 0; i < this.data.length; ++i) {
            double d = this.data[i];
            result += d * d;
        }
        return result;
    }

    @Override
    public boolean isZeroVector() {
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] == 0.0) continue;
            return false;
        }
        return true;
    }

    @Override
    public double maxAbsElement() {
        double result = 0.0;
        for (int i = 0; i < this.data.length; ++i) {
            double d = Math.abs(this.data[i]);
            if (!(d > result)) continue;
            result = d;
        }
        return result;
    }

    @Override
    public void negate() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = -this.data[i];
        }
    }

    @Override
    public void absolute() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = Math.abs(this.data[i]);
        }
    }

    @Override
    public double get(int i) {
        int ip = this.index.indexPosition(i);
        if (ip < 0) {
            return 0.0;
        }
        return this.data[ip];
    }

    @Override
    public boolean isFullyMutable() {
        return false;
    }

    @Override
    public double elementSum() {
        double result = 0.0;
        for (int i = 0; i < this.data.length; ++i) {
            result += this.data[i];
        }
        return result;
    }

    @Override
    public double dotProduct(AVector v) {
        double result = 0.0;
        for (int i = 0; i < this.data.length; ++i) {
            result += this.data[i] * v.get(this.index.data[i]);
        }
        return result;
    }

    public double dotProduct(ArrayVector v) {
        double[] array = v.getArray();
        int offset = v.getArrayOffset();
        double result = 0.0;
        for (int i = 0; i < this.data.length; ++i) {
            result += this.data[i] * array[offset + this.index.data[i]];
        }
        return result;
    }

    @Override
    public void addMultipleToArray(double factor, int offset, double[] array, int arrayOffset, int length) {
        int start;
        for (int i = start = this.index.seekPosition(offset); i < this.data.length; ++i) {
            int di = this.index.data[i];
            if (di >= offset + length) {
                return;
            }
            int n = di + arrayOffset;
            array[n] = array[n] + factor * this.data[i];
        }
    }

    @Override
    public void addToArray(int offset, double[] array, int arrayOffset, int length) {
        int start;
        for (int i = start = this.index.seekPosition(offset); i < this.data.length; ++i) {
            int di = this.index.data[i];
            if (di >= offset + length) {
                return;
            }
            int n = di + arrayOffset;
            array[n] = array[n] + this.data[i];
        }
    }

    @Override
    public void copyTo(double[] array, int offset) {
        Arrays.fill(array, offset, offset + this.length, 0.0);
        this.copySparseValuesTo(array, offset);
    }

    public void copySparseValuesTo(double[] array, int offset) {
        for (int i = 0; i < this.data.length; ++i) {
            array[offset + this.index.data[i]] = this.data[i];
        }
    }

    @Override
    public void copyTo(AVector v, int offset) {
        if (v instanceof ArrayVector) {
            ArrayVector av = (ArrayVector)v;
            this.copyTo(av.getArray(), av.getArrayOffset() + offset);
        }
        v.fillRange(offset, this.length, 0.0);
        for (int i = 0; i < this.data.length; ++i) {
            v.set(offset + this.index.data[i], this.data[i]);
        }
    }

    @Override
    public void set(int i, double value) {
        int ip = this.index.indexPosition(i);
        if (ip < 0) {
            throw new VectorzException("Can't set SparseIndexedVector at non-indexed position: " + i);
        }
        this.data[ip] = value;
    }

    @Override
    public Vector nonSparseValues() {
        return Vector.wrap(this.data);
    }

    @Override
    public boolean includesIndex(int i) {
        return this.index.indexPosition(i) >= 0;
    }
}

