/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz;

import mikera.vectorz.AVector;
import mikera.vectorz.ArrayVector;
import mikera.vectorz.Vectorz;

public final class GrowableVector
extends ArrayVector {
    private static final long serialVersionUID = -4560854157937758671L;
    private double[] data;
    private int length;

    public GrowableVector(AVector v) {
        this(v.length());
        this.append(v);
    }

    private GrowableVector(int initialCapacity) {
        this(new double[initialCapacity], 0);
    }

    public GrowableVector() {
        this(4);
    }

    public static GrowableVector ofInitialCapacity(int capacity) {
        return new GrowableVector(capacity);
    }

    private GrowableVector(double[] array, int length) {
        this.data = array;
        this.length = length;
    }

    @Override
    public double[] getArray() {
        return this.data;
    }

    @Override
    public int getArrayOffset() {
        return 0;
    }

    @Override
    public int length() {
        return this.length;
    }

    public int currentCapacity() {
        return this.data.length;
    }

    public void ensureCapacity(int capacity) {
        int cc = this.currentCapacity();
        if (capacity <= cc) {
            return;
        }
        double[] newData = new double[Math.max(capacity + 5, cc * 2)];
        System.arraycopy(this.data, 0, newData, 0, this.length);
        this.data = newData;
    }

    @Override
    public double get(int i) {
        if (i < 0 || i >= this.length) {
            throw new IndexOutOfBoundsException("Index: " + i);
        }
        return this.data[i];
    }

    @Override
    public void set(int i, double value) {
        if (i < 0) {
            throw new IndexOutOfBoundsException("Index: " + i);
        }
        this.ensureCapacity(i + 1);
        this.data[i] = value;
    }

    @Override
    public boolean isView() {
        return false;
    }

    public void append(double v) {
        this.ensureCapacity(this.length + 1);
        this.data[this.length++] = v;
    }

    public void append(AVector v) {
        int vl = v.length();
        this.ensureCapacity(this.length + vl);
        v.copyTo(this.data, this.length);
        this.length += vl;
    }

    public AVector build() {
        return Vectorz.create(this);
    }

    @Override
    public GrowableVector clone() {
        return new GrowableVector((double[])this.data.clone(), this.length);
    }

    public void clear() {
        this.length = 0;
    }
}

