/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz.impl;

import java.util.Iterator;
import mikera.vectorz.AVector;
import mikera.vectorz.VectorIterator;

public final class WrappedSubVector
extends AVector {
    private static final long serialVersionUID = 2323553136938665228L;
    private final AVector wrapped;
    private final int offset;
    private final int length;

    public WrappedSubVector(AVector source, int offset, int length) {
        if (offset < 0) {
            throw new IndexOutOfBoundsException("Start Index: " + offset);
        }
        if (offset + length > source.length()) {
            throw new IndexOutOfBoundsException("End Index: " + (offset + length));
        }
        if (source instanceof WrappedSubVector) {
            WrappedSubVector v = (WrappedSubVector)source;
            this.wrapped = v.wrapped;
            this.offset = offset + v.offset;
            this.length = length;
        } else {
            this.wrapped = source;
            this.offset = offset;
            this.length = length;
        }
    }

    @Override
    public Iterator<Double> iterator() {
        return new VectorIterator(this.wrapped, this.offset, this.length);
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public boolean isView() {
        return true;
    }

    @Override
    public double get(int i) {
        if (i < 0 || i >= this.length) {
            throw new IndexOutOfBoundsException("Index: " + i);
        }
        return this.wrapped.get(i + this.offset);
    }

    @Override
    public void set(int i, double value) {
        if (i < 0 || i >= this.length) {
            throw new IndexOutOfBoundsException("Index: " + i);
        }
        this.wrapped.set(i + this.offset, value);
    }

    @Override
    public WrappedSubVector subVector(int offset, int length) {
        if (offset < 0) {
            throw new IndexOutOfBoundsException("Start Index: " + offset);
        }
        if (offset + length > this.length) {
            throw new IndexOutOfBoundsException("End Index: " + (offset + length));
        }
        return new WrappedSubVector(this.wrapped, this.offset + offset, length);
    }
}

