/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz.impl;

import mikera.vectorz.AVector;

public final class JoinedVector
extends AVector {
    private static final long serialVersionUID = -5535850407701653222L;
    private final AVector left;
    private final AVector right;
    private final int split;
    private final int length;

    private JoinedVector(AVector left, AVector right) {
        this.left = left;
        this.right = right;
        this.split = left.length();
        this.length = this.split + right.length();
    }

    public static AVector join(AVector left, AVector right) {
        while (left.length() > right.length() * 2 && left instanceof JoinedVector) {
            JoinedVector bigLeft = (JoinedVector)left;
            left = bigLeft.left;
            right = JoinedVector.join(bigLeft.right, right);
        }
        while (left.length() * 2 < right.length() && right instanceof JoinedVector) {
            JoinedVector bigRight = (JoinedVector)right;
            left = JoinedVector.join(left, bigRight.left);
            right = bigRight.right;
        }
        return new JoinedVector(left, right);
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public boolean isView() {
        return true;
    }

    @Override
    public boolean isFullyMutable() {
        return this.left.isFullyMutable() && this.right.isFullyMutable();
    }

    @Override
    public void copyTo(AVector dest, int offset) {
        this.left.copyTo(dest, offset);
        this.right.copyTo(dest, offset + this.split);
    }

    @Override
    public void addToArray(int offset, double[] array, int arrayOffset, int length) {
        assert (arrayOffset + length <= array.length);
        assert (offset + length <= this.length());
        if (offset >= this.split) {
            this.right.addToArray(offset - this.split, array, arrayOffset, length);
        } else if (offset + length <= this.split) {
            this.left.addToArray(offset, array, arrayOffset, length);
        } else {
            this.left.addToArray(offset, array, arrayOffset, this.split - offset);
            this.right.addToArray(0, array, arrayOffset + (this.split - offset), length - (this.split - offset));
        }
    }

    @Override
    public void addMultipleToArray(double factor, int offset, double[] array, int arrayOffset, int length) {
        assert (arrayOffset + length <= array.length);
        assert (offset + length <= this.length());
        if (offset >= this.split) {
            this.right.addMultipleToArray(factor, offset - this.split, array, arrayOffset, length);
        } else if (offset + length <= this.split) {
            this.left.addMultipleToArray(factor, offset, array, arrayOffset, length);
        } else {
            this.left.addMultipleToArray(factor, offset, array, arrayOffset, this.split - offset);
            this.right.addMultipleToArray(factor, 0, array, arrayOffset + (this.split - offset), length - (this.split - offset));
        }
    }

    @Override
    public void copyTo(double[] data, int offset) {
        this.left.copyTo(data, offset);
        this.right.copyTo(data, offset + this.split);
    }

    @Override
    public void multiplyTo(double[] data, int offset) {
        this.left.multiplyTo(data, offset);
        this.right.multiplyTo(data, offset + this.split);
    }

    @Override
    public void divideTo(double[] data, int offset) {
        this.left.divideTo(data, offset);
        this.right.divideTo(data, offset + this.split);
    }

    @Override
    public void copy(int start, int length, AVector dest, int destOffset) {
        this.subVector(start, length).copyTo(dest, destOffset);
    }

    @Override
    public AVector subVector(int start, int length) {
        assert (start >= 0);
        assert (start + length <= this.length);
        if (start == 0 && length == this.length) {
            return this;
        }
        if (start >= this.split) {
            return this.right.subVector(start - this.split, length);
        }
        if (start + length <= this.split) {
            return this.left.subVector(start, length);
        }
        AVector v1 = this.left.subVector(start, this.split - start);
        AVector v2 = this.right.subVector(0, length - (this.split - start));
        return new JoinedVector(v1, v2);
    }

    @Override
    public void add(AVector a) {
        assert (this.length() == a.length());
        if (a instanceof JoinedVector) {
            this.add((JoinedVector)a);
        } else {
            this.add(a, 0);
        }
    }

    public void add(JoinedVector a) {
        if (this.split == a.split) {
            this.left.add(a.left);
            this.right.add(a.right);
        } else {
            this.add(a, 0);
        }
    }

    @Override
    public double dotProduct(AVector v) {
        if (v instanceof JoinedVector) {
            JoinedVector jv = (JoinedVector)v;
            return this.dotProduct(jv);
        }
        return super.dotProduct(v);
    }

    public double dotProduct(JoinedVector jv) {
        if (jv.left.length() == this.left.length()) {
            return this.left.dotProduct(jv.left) + this.right.dotProduct(jv.right);
        }
        return super.dotProduct(jv);
    }

    @Override
    public void add(AVector a, int offset) {
        this.left.add(a, offset);
        this.right.add(a, offset + this.split);
    }

    @Override
    public void addMultiple(AVector a, double factor) {
        if (a instanceof JoinedVector) {
            this.addMultiple((JoinedVector)a, factor);
        } else {
            this.left.addMultiple(a, factor, 0);
            this.right.addMultiple(a, factor, this.split);
        }
    }

    public void addMultiple(JoinedVector a, double factor) {
        if (this.split == a.split) {
            this.left.addMultiple(a.left, factor);
            this.right.addMultiple(a.right, factor);
        } else {
            this.left.addMultiple(a, factor, 0);
            this.right.addMultiple(a, factor, this.split);
        }
    }

    @Override
    public void addMultiple(AVector a, double factor, int offset) {
        this.left.addMultiple(a, factor, offset);
        this.right.addMultiple(a, factor, offset + this.split);
    }

    @Override
    public void addProduct(AVector a, AVector b, double factor) {
        this.left.addProduct(a, 0, b, 0, factor);
        this.right.addProduct(a, this.split, b, this.split, factor);
    }

    @Override
    public void addProduct(AVector a, int aOffset, AVector b, int bOffset, double factor) {
        this.left.addProduct(a, aOffset, b, bOffset, factor);
        this.right.addProduct(a, aOffset + this.split, b, bOffset + this.split, factor);
    }

    @Override
    public double elementSum() {
        return this.left.elementSum() + this.right.elementSum();
    }

    @Override
    public double get(int i) {
        if (i < this.split) {
            return this.left.get(i);
        }
        return this.right.get(i - this.split);
    }

    @Override
    public void set(AVector src) {
        this.set(src, 0);
    }

    @Override
    public void set(AVector src, int offset) {
        this.left.set(src, offset);
        this.right.set(src, offset + this.split);
    }

    @Override
    public void set(int i, double value) {
        if (i < this.split) {
            this.left.set(i, value);
        } else {
            this.right.set(i - this.split, value);
        }
    }

    @Override
    public void fill(double value) {
        this.left.fill(value);
        this.right.fill(value);
    }

    @Override
    public void multiply(double value) {
        this.left.multiply(value);
        this.right.multiply(value);
    }

    public static int depthCalc(AVector v) {
        if (v instanceof JoinedVector) {
            JoinedVector jv = (JoinedVector)v;
            return 1 + Math.max(JoinedVector.depthCalc(jv.left), JoinedVector.depthCalc(jv.right));
        }
        return 1;
    }

    public int depth() {
        return JoinedVector.depthCalc(this);
    }
}

