/*
 * Decompiled with CFR 0.152.
 */
package mikera.matrixx.impl;

import mikera.indexz.Index;
import mikera.matrixx.AMatrix;
import mikera.vectorz.AVector;

public final class SubsetMatrix
extends AMatrix {
    private int dims;
    private Index components;

    private SubsetMatrix(int inputDimensions, Index components) {
        this.dims = inputDimensions;
        this.components = components;
    }

    public static SubsetMatrix create(Index components, int inputDimensions) {
        return new SubsetMatrix(inputDimensions, components);
    }

    @Override
    public void transform(AVector source, AVector dest) {
        dest.set(source, this.components);
    }

    @Override
    public int inputDimensions() {
        return this.dims;
    }

    @Override
    public int outputDimensions() {
        return this.components.length();
    }

    @Override
    public double elementSum() {
        return this.rowCount();
    }

    @Override
    public int rowCount() {
        return this.outputDimensions();
    }

    @Override
    public int columnCount() {
        return this.inputDimensions();
    }

    @Override
    public double get(int row, int column) {
        return column == this.components.get(row) ? 1.0 : 0.0;
    }

    @Override
    public void set(int row, int column, double value) {
        throw new UnsupportedOperationException("Can't set matrix values on: " + this.getClass().getName());
    }
}

