/*
 * Decompiled with CFR 0.152.
 */
package mikera.matrixx.impl;

import mikera.matrixx.AMatrix;
import mikera.matrixx.Matrixx;
import mikera.transformz.ATransform;
import mikera.vectorz.AVector;
import mikera.vectorz.Tools;

public final class ZeroMatrix
extends AMatrix {
    private final int inputDimensions;
    private final int outputDimensions;

    @Override
    public boolean isFullyMutable() {
        return false;
    }

    private ZeroMatrix(int rows, int columns) {
        this.outputDimensions = rows;
        this.inputDimensions = columns;
    }

    @Override
    public int inputDimensions() {
        return this.inputDimensions;
    }

    @Override
    public void scale(double factor) {
    }

    @Override
    public int outputDimensions() {
        return this.outputDimensions;
    }

    @Override
    public int rowCount() {
        return this.outputDimensions;
    }

    @Override
    public int columnCount() {
        return this.inputDimensions;
    }

    @Override
    public double determinant() {
        assert (this.isSquare());
        return 0.0;
    }

    @Override
    public double calculateElement(int i, AVector v) {
        assert (i >= 0);
        assert (i < this.outputDimensions);
        return 0.0;
    }

    @Override
    public double get(int row, int column) {
        return 0.0;
    }

    @Override
    public void set(int row, int column, double value) {
        throw new UnsupportedOperationException("ZeroMatrix is immutable!");
    }

    @Override
    public AMatrix clone() {
        return Matrixx.newMatrix(this.outputDimensions, this.inputDimensions);
    }

    @Override
    public boolean isZeroMatrix() {
        return true;
    }

    @Override
    public int hashCode() {
        return Tools.zeroVectorHash(this.inputDimensions * this.outputDimensions);
    }

    @Override
    public void transform(AVector input, AVector output) {
        assert (output.length() == this.outputDimensions);
        output.fill(0.0);
    }

    @Override
    public boolean isInvertible() {
        return false;
    }

    @Override
    public AMatrix compose(ATransform t) {
        assert (this.inputDimensions() == t.outputDimensions());
        return ZeroMatrix.create(this.outputDimensions, t.inputDimensions());
    }

    @Override
    public AMatrix compose(AMatrix m) {
        assert (this.inputDimensions() == m.outputDimensions());
        return ZeroMatrix.create(this.outputDimensions, m.inputDimensions());
    }

    @Override
    public void composeWith(ATransform t) {
        assert (t.inputDimensions() == t.outputDimensions());
    }

    @Override
    public void composeWith(AMatrix t) {
        assert (t.inputDimensions() == t.outputDimensions());
    }

    @Override
    public void entrywiseMul(AMatrix m) {
    }

    @Override
    public boolean equals(AMatrix m) {
        return m.isZeroMatrix();
    }

    @Override
    public ZeroMatrix getTranspose() {
        return ZeroMatrix.create(this.inputDimensions, this.outputDimensions);
    }

    public static ZeroMatrix create(int rows, int columns) {
        return new ZeroMatrix(rows, columns);
    }
}

