/*
 * Decompiled with CFR 0.152.
 */
package mikera.matrixx.impl;

import mikera.matrixx.AMatrix;
import mikera.matrixx.impl.ADiagonalMatrix;
import mikera.vectorz.AVector;
import mikera.vectorz.Vectorz;

public final class DiagonalMatrix
extends ADiagonalMatrix {
    private final double[] data;

    public DiagonalMatrix(int dimensions) {
        super(dimensions);
        this.data = new double[dimensions];
    }

    private DiagonalMatrix(double ... values) {
        super(values.length);
        this.data = values;
    }

    public static DiagonalMatrix create(double ... values) {
        int dimensions = values.length;
        double[] data = new double[dimensions];
        System.arraycopy(values, 0, data, 0, dimensions);
        return new DiagonalMatrix(data);
    }

    public static DiagonalMatrix wrap(double[] data) {
        return new DiagonalMatrix(data);
    }

    @Override
    public double get(int row, int column) {
        if (row != column) {
            return 0.0;
        }
        return this.data[row];
    }

    @Override
    public void set(int row, int column, double value) {
        if (row != column) {
            if (value != 0.0) {
                throw new UnsupportedOperationException("Diagonal matrix cannot be set to non-zero value at position (" + row + "," + column + ")!");
            }
        } else {
            this.data[row] = value;
        }
    }

    @Override
    public double calculateComponent(int i, AVector v) {
        return this.data[i] * v.get(i);
    }

    @Override
    public void transformInPlace(AVector v) {
        if (v.length() != this.dimensions) {
            throw new IllegalArgumentException("Wrong length vector: " + v.length());
        }
        for (int i = 0; i < this.dimensions; ++i) {
            v.set(i, v.get(i) * this.data[i]);
        }
    }

    @Override
    public boolean isIdentity() {
        for (int i = 0; i < this.dimensions; ++i) {
            if (this.data[i] == 1.0) continue;
            return false;
        }
        return true;
    }

    @Override
    public DiagonalMatrix clone() {
        DiagonalMatrix m = new DiagonalMatrix(this.data);
        return m;
    }

    @Override
    public double determinant() {
        double det = 1.0;
        for (int i = 0; i < this.dimensions; ++i) {
            det *= this.data[i];
        }
        return det;
    }

    @Override
    public DiagonalMatrix inverse() {
        double[] newData = new double[this.dimensions];
        for (int i = 0; i < this.dimensions; ++i) {
            newData[i] = 1.0 / this.data[i];
        }
        return new DiagonalMatrix(newData);
    }

    @Override
    public double getDiagonalValue(int i) {
        return this.data[i];
    }

    @Override
    public AVector getLeadingDiagonal() {
        return Vectorz.create(this.data);
    }

    @Override
    public AMatrix compose(AMatrix a) {
        if (a instanceof ADiagonalMatrix) {
            return this.compose((ADiagonalMatrix)a);
        }
        return super.compose(a);
    }

    public AMatrix compose(ADiagonalMatrix a) {
        if (this.dimensions != a.dimensions) {
            throw new IllegalArgumentException("Matrix dimensions not compatible!");
        }
        DiagonalMatrix result = DiagonalMatrix.create(this.data);
        for (int i = 0; i < this.dimensions; ++i) {
            int n = i;
            result.data[n] = result.data[n] * a.getDiagonalValue(i);
        }
        return result;
    }
}

