/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz.impl;

import mikera.vectorz.AVector;

public final class SingleComponentVector
extends AVector {
    private final int dimensions;
    private final int index;
    private double value;

    public SingleComponentVector(int componentIndex, int dimensions) {
        this.dimensions = dimensions;
        this.index = componentIndex;
    }

    @Override
    public int length() {
        return this.dimensions;
    }

    @Override
    public double magnitude() {
        return this.value;
    }

    @Override
    public double magnitudeSquared() {
        return this.value * this.value;
    }

    @Override
    public double normalise() {
        double ret = this.value;
        if (this.value > 0.0) {
            this.value = 1.0;
        } else if (this.value < 0.0) {
            this.value = -1.0;
        }
        return ret;
    }

    @Override
    public boolean isFullyMutable() {
        return false;
    }

    @Override
    public double get(int i) {
        assert (i >= 0 && i < this.dimensions);
        return i == this.index ? this.value : 0.0;
    }

    @Override
    public void set(int i, double value) {
        assert (i >= 0 && i < this.dimensions);
        if (i == this.index) {
            this.value = value;
        }
    }
}

