/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz;

import mikera.vectorz.APrimitiveVector;
import mikera.vectorz.AVector;
import mikera.vectorz.Tools;

public final class Vector3
extends APrimitiveVector {
    private static final long serialVersionUID = 2338611313487869443L;
    public double x;
    public double y;
    public double z;

    public Vector3() {
    }

    public Vector3(Vector3 source) {
        this.x = source.x;
        this.y = source.y;
        this.z = source.z;
    }

    public Vector3(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public double normalise() {
        double d = this.magnitude();
        if (d > 0.0) {
            this.multiply(1.0 / d);
        }
        return d;
    }

    public Vector3(double ... values) {
        if (values.length != this.length()) {
            throw new IllegalArgumentException("Can't create " + this.length() + "D vector from: " + values);
        }
        this.x = values[0];
        this.y = values[1];
        this.z = values[2];
    }

    public Vector3(AVector v) {
        assert (v.length() == 3);
        this.set(v);
    }

    public static Vector3 of(double x, double y, double z) {
        return new Vector3(x, y, z);
    }

    public static Vector3 of(double ... values) {
        return new Vector3(values);
    }

    @Override
    public double angle(AVector v) {
        if (v instanceof Vector3) {
            return this.angle((Vector3)v);
        }
        return super.angle(v);
    }

    public double angle(Vector3 v) {
        double mag2 = this.x * this.x + this.y * this.y + this.z * this.z;
        double vmag2 = v.x * v.x + v.y * v.y + v.z * v.z;
        double dot = this.x * v.x + this.y * v.y + this.z * v.z;
        return Math.acos(dot / Math.sqrt(mag2 * vmag2));
    }

    public void add(double dx, double dy, double dz) {
        this.x += dx;
        this.y += dy;
        this.z += dz;
    }

    @Override
    public double magnitudeSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    @Override
    public double magnitude() {
        return Math.sqrt(this.magnitudeSquared());
    }

    public void set(Vector3 a) {
        this.x = a.x;
        this.y = a.y;
        this.z = a.z;
    }

    public void addMultiple(double dx, double dy, double dz, double factor) {
        this.x += dx * factor;
        this.y += dy * factor;
        this.z += dz * factor;
    }

    public void addMultiple(Vector3 v, double factor) {
        this.x += v.x * factor;
        this.y += v.y * factor;
        this.z += v.z * factor;
    }

    public void subtractMultiple(Vector3 v, double factor) {
        this.x -= v.x * factor;
        this.y -= v.y * factor;
        this.z -= v.z * factor;
    }

    public void add(Vector3 v) {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
    }

    public void sub(Vector3 v) {
        this.x -= v.x;
        this.y -= v.y;
        this.z -= v.z;
    }

    public void subMultiple(Vector3 v, double factor) {
        this.addMultiple(v, -factor);
    }

    public double dotProduct(Vector3 a) {
        return this.x * a.x + this.y * a.y + this.z * a.z;
    }

    public void crossProduct(Vector3 a) {
        double tx = this.y * a.z - this.z * a.y;
        double ty = this.z * a.x - this.x * a.z;
        double tz = this.x * a.y - this.y * a.x;
        this.x = tx;
        this.y = ty;
        this.z = tz;
    }

    @Override
    public void projectToPlane(AVector normal, double distance) {
        if (normal instanceof Vector3) {
            this.projectToPlane((Vector3)normal, distance);
            return;
        }
        super.projectToPlane(normal, distance);
    }

    public void projectToPlane(Vector3 normal, double distance) {
        assert (Tools.epsilonEquals(normal.magnitude(), 1.0));
        double d = this.dotProduct(normal);
        this.addMultiple(normal, distance - d);
    }

    @Override
    public int length() {
        return 3;
    }

    @Override
    public double get(int i) {
        switch (i) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new IndexOutOfBoundsException("Index: " + i);
    }

    @Override
    public void set(AVector v) {
        assert (v.length() == 3);
        this.x = v.get(0);
        this.y = v.get(1);
        this.z = v.get(2);
    }

    @Override
    public void set(int i, double value) {
        switch (i) {
            case 0: {
                this.x = value;
                return;
            }
            case 1: {
                this.y = value;
                return;
            }
            case 2: {
                this.z = value;
                return;
            }
        }
        throw new IndexOutOfBoundsException("Index: i");
    }

    public void setValues(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public Vector3 clone() {
        return new Vector3(this.x, this.y, this.z);
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }
}

