/*
 * Decompiled with CFR 0.152.
 */
package mikera.transformz;

import mikera.matrixx.AMatrix;
import mikera.transformz.ALinearTransform;
import mikera.transformz.ATransform;
import mikera.transformz.ATranslation;
import mikera.transformz.AffineMN;
import mikera.transformz.Transformz;
import mikera.vectorz.AVector;

public abstract class AAffineTransform
extends ALinearTransform {
    public abstract AMatrix getMatrixComponent();

    public abstract ATranslation getTranslationComponent();

    public AVector copyOfTranslationVector() {
        return this.getTranslationComponent().getTranslationVector().clone();
    }

    public AMatrix copyOfMatrix() {
        return this.getMatrixComponent().clone();
    }

    @Override
    public boolean isIdentity() {
        return this.getMatrixComponent().isIdentity() && this.getTranslationComponent().isIdentity();
    }

    @Override
    public ATransform compose(ATransform a) {
        if (a instanceof AAffineTransform) {
            return this.compose((AAffineTransform)a);
        }
        return super.compose(a);
    }

    public ATransform compose(AAffineTransform a) {
        AVector v = a.copyOfTranslationVector();
        AMatrix thisM = this.getMatrixComponent();
        thisM.transformInPlace(v);
        v.add(this.getTranslationComponent().getTranslationVector());
        AMatrix m = thisM.compose(a.getMatrixComponent());
        return Transformz.createAffineTransform(m, v);
    }

    @Override
    public void transform(AVector source, AVector dest) {
        this.getMatrixComponent().transform(source, dest);
        this.getTranslationComponent().transformInPlace(dest);
    }

    @Override
    public double calculateComponent(int i, AVector v) {
        return this.getMatrixComponent().calculateComponent(i, v) + this.getTranslationComponent().getTranslationComponent(i);
    }

    @Override
    public void transformInPlace(AVector v) {
        this.getMatrixComponent().transformInPlace(v);
        this.getTranslationComponent().transformInPlace(v);
    }

    public AAffineTransform toAffineTransform() {
        return new AffineMN(this);
    }

    public int hashCode() {
        return this.getMatrixComponent().hashCode() + this.getTranslationComponent().hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof AAffineTransform)) {
            return false;
        }
        return this.equals((AAffineTransform)o);
    }

    public boolean equals(AAffineTransform a) {
        return a.getMatrixComponent().equals(this.getMatrixComponent()) && a.getTranslationComponent().equals(this.getTranslationComponent());
    }

    @Override
    public AAffineTransform inverse() {
        AMatrix m = this.getMatrixComponent().inverse();
        AVector v = this.getTranslationComponent().getTranslationVector().clone();
        v.negate();
        m.transformInPlace(v);
        return Transformz.createAffineTransform(m, v);
    }
}

