/*
 * Decompiled with CFR 0.152.
 */
package mikera.transformz;

import mikera.matrixx.AMatrix;
import mikera.matrixx.Matrixx;
import mikera.transformz.AAffineTransform;
import mikera.transformz.AffineMN;
import mikera.transformz.Transformz;
import mikera.vectorz.AVector;

public abstract class ATranslation
extends AAffineTransform {
    public abstract AVector getTranslationVector();

    public int dimensions() {
        return this.getTranslationVector().length();
    }

    @Override
    public void transform(AVector source, AVector dest) {
        dest.set(source);
        dest.add(this.getTranslationVector());
    }

    @Override
    public void transformInPlace(AVector v) {
        v.add(this.getTranslationVector());
    }

    @Override
    public AAffineTransform toAffineTransform() {
        return new AffineMN((AMatrix)Matrixx.createImmutableIdentityMatrix(this.dimensions()), this);
    }

    public ATranslation toMutableTranslation() {
        return Transformz.createMutableTranslation(this);
    }

    @Override
    public boolean isIdentity() {
        return this.getTranslationVector().isZeroVector();
    }

    public boolean equals(ATranslation a) {
        return this.getTranslationVector().equals(a.getTranslationVector());
    }

    @Override
    public boolean equals(AAffineTransform a) {
        return this.equals(a.getTranslationComponent()) && a.getMatrixComponent().isIdentity();
    }

    @Override
    public ATranslation inverse() {
        AVector v = this.getTranslationVector().clone();
        v.negate();
        return Transformz.createTranslation(v);
    }

    @Override
    public int hashCode() {
        return this.getTranslationVector().hashCode();
    }
}

