/*
 * Decompiled with CFR 0.152.
 */
package mikera.matrixx.impl;

import mikera.matrixx.AMatrix;
import mikera.vectorz.AVector;
import mikera.vectorz.Vectorz;

public class IdentityMatrix
extends AMatrix {
    private final int dimensions;
    private static final int INSTANCE_COUNT = 6;
    private static final IdentityMatrix[] INSTANCES = new IdentityMatrix[6];

    private IdentityMatrix(int dimensions) {
        this.dimensions = dimensions;
    }

    public static IdentityMatrix create(int i) {
        if (i < 6) {
            return INSTANCES[i];
        }
        return new IdentityMatrix(i);
    }

    @Override
    public int rowCount() {
        return this.dimensions;
    }

    @Override
    public int columnCount() {
        return this.dimensions;
    }

    @Override
    public double get(int row, int column) {
        assert (row >= 0);
        assert (column >= 0);
        assert (row < this.dimensions);
        assert (column < this.dimensions);
        return row == column ? 1.0 : 0.0;
    }

    @Override
    public void set(int row, int column, double value) {
        throw new UnsupportedOperationException("Identity matrix is immutable!");
    }

    @Override
    public void transform(AVector source, AVector dest) {
        dest.set(source);
    }

    @Override
    public boolean isFullyMutable() {
        return false;
    }

    @Override
    public AVector getLeadingDiagonal() {
        AVector v = Vectorz.newVector(this.dimensions);
        v.fill(1.0);
        return v;
    }

    @Override
    public boolean isSquare() {
        return true;
    }

    @Override
    public boolean isIdentity() {
        return true;
    }

    @Override
    public AMatrix inverse() {
        return this;
    }

    @Override
    public AMatrix getTranspose() {
        return this;
    }

    @Override
    public void transposeInPlace() {
    }

    static {
        for (int i = 0; i < 6; ++i) {
            IdentityMatrix.INSTANCES[i] = new IdentityMatrix(i);
        }
    }
}

