/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mikera.indexz.Index;
import mikera.vectorz.IVector;
import mikera.vectorz.Tools;
import mikera.vectorz.Vector;
import mikera.vectorz.VectorIterator;
import mikera.vectorz.Vectorz;
import mikera.vectorz.impl.JoinedVector;
import mikera.vectorz.impl.ListWrapper;
import mikera.vectorz.impl.WrappedSubVector;
import mikera.vectorz.util.VectorzException;

public abstract class AVector
implements IVector,
Cloneable,
Comparable<AVector>,
Serializable,
Iterable<Double> {
    @Override
    public abstract int length();

    @Override
    public abstract double get(int var1);

    @Override
    public abstract void set(int var1, double var2);

    public AVector subVector(int offset, int length) {
        return new WrappedSubVector(this, offset, length);
    }

    public AVector join(AVector second) {
        return JoinedVector.join(this, second);
    }

    @Override
    public int compareTo(AVector a) {
        int len = this.length();
        if (len != a.length()) {
            throw new IllegalArgumentException("Vectors must be same length for comparison");
        }
        for (int i = 0; i < len; ++i) {
            double diff = this.get(i) - a.get(i);
            if (diff < 0.0) {
                return -1;
            }
            if (!(diff > 0.0)) continue;
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AVector)) {
            return false;
        }
        AVector v = (AVector)o;
        int len = this.length();
        if (len != v.length()) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (this.get(i) == v.get(i)) continue;
            return false;
        }
        return true;
    }

    public List<Double> toList() {
        ArrayList<Double> al = new ArrayList<Double>();
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            al.add(this.get(i));
        }
        return al;
    }

    public boolean epsilonEquals(AVector v) {
        return this.epsilonEquals(v, 1.0E-7);
    }

    public boolean epsilonEquals(AVector v, double tolerance) {
        if (this == v) {
            return true;
        }
        int len = this.length();
        if (len != v.length()) {
            throw new VectorzException("Mismatched vector sizes!");
        }
        for (int i = 0; i < len; ++i) {
            if (Tools.epsilonEquals(this.get(i), v.get(i), tolerance)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            hashCode = 31 * hashCode + Tools.hashCode(this.get(i));
        }
        return hashCode;
    }

    public void copyTo(double[] data, int offset) {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            data[i + offset] = this.get(i);
        }
    }

    public double[] toArray() {
        double[] result = new double[this.length()];
        this.copyTo(result, 0);
        return result;
    }

    public void copyTo(AVector dest, int offset) {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            dest.set(offset + i, this.get(i));
        }
    }

    public void copy(int start, int length, AVector dest, int destOffset) {
        for (int i = 0; i < length; ++i) {
            dest.set(destOffset + i, this.get(start + i));
        }
    }

    public void fill(double value) {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            this.set(i, value);
        }
    }

    public void fillRange(int offset, int length, double value) {
        this.subVector(offset, length).fill(value);
    }

    public void clamp(double min, double max) {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            double v = this.get(i);
            if (v < min) {
                this.set(i, min);
                continue;
            }
            if (!(v > max)) continue;
            this.set(i, max);
        }
    }

    public void clampMax(double max) {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            double v = this.get(i);
            if (!(v > max)) continue;
            this.set(i, max);
        }
    }

    public void clampMin(double min) {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            double v = this.get(i);
            if (!(v < min)) continue;
            this.set(i, min);
        }
    }

    public void multiply(double factor) {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            this.set(i, this.get(i) * factor);
        }
    }

    public void multiply(AVector v) {
        int len = this.length();
        assert (len == v.length());
        for (int i = 0; i < len; ++i) {
            this.set(i, this.get(i) * v.get(i));
        }
    }

    public void multiply(double[] data, int offset) {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            this.set(i, this.get(i) * data[i + offset]);
        }
    }

    public void multiplyTo(double[] data, int offset) {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            int n = i + offset;
            data[n] = data[n] * this.get(i);
        }
    }

    public void divide(double factor) {
        this.multiply(1.0 / factor);
    }

    public void divide(AVector v) {
        int len = this.length();
        assert (len == v.length());
        for (int i = 0; i < len; ++i) {
            this.set(i, this.get(i) / v.get(i));
        }
    }

    public void divide(double[] data, int offset) {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            this.set(i, this.get(i) / data[i + offset]);
        }
    }

    public void divideTo(double[] data, int offset) {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            int n = i + offset;
            data[n] = data[n] / this.get(i);
        }
    }

    public void absolute() {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            this.set(i, Math.abs(this.get(i)));
        }
    }

    public void scale(double factor) {
        this.multiply(factor);
    }

    public void scaleAdd(double factor, AVector v) {
        this.multiply(factor);
        this.add(v);
    }

    public void interpolate(AVector v, double alpha) {
        this.multiply(1.0 - alpha);
        this.addMultiple(v, alpha);
    }

    public void interpolate(AVector a, AVector b, double alpha) {
        this.set(a);
        this.interpolate(b, alpha);
    }

    public double magnitudeSquared() {
        int len = this.length();
        double total = 0.0;
        for (int i = 0; i < len; ++i) {
            double x = this.get(i);
            total += x * x;
        }
        return total;
    }

    public double dotProduct(AVector v) {
        int len = this.length();
        double total = 0.0;
        for (int i = 0; i < len; ++i) {
            total += this.get(i) * v.get(i);
        }
        return total;
    }

    public double dotProduct(AVector v, Index ix) {
        int vl = v.length();
        assert (v.length() == ix.length());
        double result = 0.0;
        for (int i = 0; i < vl; ++i) {
            result += this.get(ix.get(i)) * v.get(i);
        }
        return result;
    }

    public double magnitude() {
        return Math.sqrt(this.magnitudeSquared());
    }

    public double distanceSquared(AVector v) {
        int len = this.length();
        double total = 0.0;
        for (int i = 0; i < len; ++i) {
            double d = this.get(i) - v.get(i);
            total += d * d;
        }
        return total;
    }

    public double distance(AVector v) {
        return Math.sqrt(this.distanceSquared(v));
    }

    public double distanceL1(AVector v) {
        int len = this.length();
        double total = 0.0;
        for (int i = 0; i < len; ++i) {
            double d = this.get(i) - v.get(i);
            total += Math.abs(d);
        }
        return total;
    }

    public double distanceLinf(AVector v) {
        int len = this.length();
        double result = 0.0;
        for (int i = 0; i < len; ++i) {
            double d = Math.abs(this.get(i) - v.get(i));
            result = Math.max(result, d);
        }
        return result;
    }

    public double angle(AVector v) {
        return Math.acos(this.dotProduct(v) / (v.magnitude() * this.magnitude()));
    }

    public void normalise() {
        double d = this.magnitude();
        if (d > 0.0) {
            this.multiply(1.0 / d);
        }
    }

    public void negate() {
        this.multiply(-1.0);
    }

    public void set(AVector a) {
        int len = this.length();
        if (a.length() != len) {
            throw new IllegalArgumentException("Source Vector of wrong size: " + a.length());
        }
        for (int i = 0; i < len; ++i) {
            this.set(i, a.get(i));
        }
    }

    public void set(AVector a, int offset) {
        int len = this.length();
        assert (len + offset <= a.length());
        for (int i = 0; i < len; ++i) {
            this.set(i, a.get(offset + i));
        }
    }

    public void setValues(double ... values) {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            this.set(i, values[i]);
        }
    }

    public AVector clone() {
        return Vectorz.create(this);
    }

    public boolean isReference() {
        return true;
    }

    public boolean isMutable() {
        return true;
    }

    public boolean isFullyMutable() {
        return this.isMutable();
    }

    public void add(AVector v) {
        int length;
        int vlength = v.length();
        if (vlength != (length = this.length())) {
            throw new IllegalArgumentException("Source vector has different size: " + vlength);
        }
        for (int i = 0; i < length; ++i) {
            double x = this.get(i) + v.get(i);
            this.set(i, x);
        }
    }

    public void add(AVector v, int offset) {
        int length = this.length();
        assert (offset >= 0);
        assert (offset + length <= v.length());
        for (int i = 0; i < length; ++i) {
            double x = this.get(i) + v.get(offset + i);
            this.set(i, x);
        }
    }

    public void addProduct(AVector a, AVector b) {
        this.addProduct(a, b, 1.0);
    }

    public void addProduct(AVector a, AVector b, double factor) {
        int length = this.length();
        assert (a.length() == length && b.length() == length);
        for (int i = 0; i < length; ++i) {
            double x = this.get(i) + a.get(i) * b.get(i) * factor;
            this.set(i, x);
        }
    }

    public void addMultiple(AVector v, double factor) {
        int length;
        int vlength = v.length();
        if (vlength != (length = this.length())) {
            throw new IllegalArgumentException("Source vector has different size: " + vlength);
        }
        for (int i = 0; i < length; ++i) {
            double x = this.get(i) + v.get(i) * factor;
            this.set(i, x);
        }
    }

    public void addWeighted(AVector v, double factor) {
        this.multiply(1.0 - factor);
        this.addMultiple(v, factor);
    }

    public void sub(AVector v) {
        this.addMultiple(v, -1.0);
    }

    public boolean isZeroVector() {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            if (this.get(i) == 0.0) continue;
            return false;
        }
        return true;
    }

    public boolean isUnitLengthVector() {
        double mag = this.magnitudeSquared();
        return Math.abs(mag - 1.0) < 1.0E-7;
    }

    public void projectToPlane(AVector normal, double distance) {
        assert (Tools.epsilonEquals(normal.magnitude(), 1.0));
        double d = this.dotProduct(normal);
        this.addMultiple(normal, distance - d);
    }

    public void subMultiple(AVector v, double factor) {
        this.addMultiple(v, -factor);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int length = this.length();
        sb.append('[');
        if (length > 0) {
            sb.append(this.get(0));
            for (int i = 1; i < length; ++i) {
                sb.append(',');
                sb.append(this.get(i));
            }
        }
        sb.append(']');
        return sb.toString();
    }

    public List<Double> asList() {
        return new ListWrapper(this);
    }

    @Override
    public Iterator<Double> iterator() {
        return new VectorIterator(this);
    }

    public void set(IVector vector) {
        int len = this.length();
        assert (len == vector.length());
        for (int i = 0; i < len; ++i) {
            this.set(i, vector.get(i));
        }
    }

    public void addMultiple(Vector vector, Index index, double factor) {
        int len = vector.length();
        assert (len == index.length());
        for (int i = 0; i < len; ++i) {
            int j = index.data[i];
            this.set(j, this.get(j) + vector.data[i] * factor);
        }
    }
}

