/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz;

import mikera.vectorz.AVector;
import mikera.vectorz.Vectorz;

public final class BitVector
extends AVector {
    private static final long serialVersionUID = 349277216077562294L;
    public static final double BIT_ON = 1.0;
    public static final double BIT_OFF = 0.0;
    public static final double BIT_THRESHOLD = 0.5;
    private final int length;
    private final long[] data;

    public BitVector(int length) {
        this.length = length;
        this.data = new long[this.requiredArraySize(length)];
    }

    private int requiredArraySize(int length) {
        assert (length >= 0);
        return (length + 63) / 64;
    }

    public BitVector(AVector source) {
        this(source.length());
        this.set(source);
    }

    public BitVector(BitVector source) {
        this(source.data, source.length());
    }

    private BitVector(long[] data, int length) {
        this.length = length;
        this.data = data;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public double get(int i) {
        return (this.data[i >>> 6] >>> i % 64 & 1L) == 0L ? 0.0 : 1.0;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public void copyTo(double[] data, int offset) {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            data[i + offset] = this.get(i);
        }
    }

    @Override
    public boolean isFullyMutable() {
        return false;
    }

    @Override
    public boolean isReference() {
        return false;
    }

    @Override
    public void set(int i, double value) {
        if (i < 0 || i >= this.length) {
            throw new IndexOutOfBoundsException("Index: " + i);
        }
        int bit = i % 64;
        long mask = 1L << bit;
        int p = i >>> 6;
        this.data[p] = (this.data[p] & (mask ^ 0xFFFFFFFFFFFFFFFFL)) + (value >= 0.5 ? mask : 0L);
    }

    @Override
    public AVector clone() {
        AVector v = Vectorz.newVector(this.length);
        v.set(this);
        return v;
    }

    public static BitVector of(double ... values) {
        int len = values.length;
        BitVector b = new BitVector(len);
        b.setValues(values);
        return b;
    }
}

