/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz;

import java.util.Arrays;
import mikera.vectorz.AVector;
import mikera.vectorz.impl.ArraySubVector;

public abstract class ArrayVector
extends AVector {
    public abstract double[] getArray();

    public abstract int getArrayOffset();

    @Override
    public ArraySubVector subVector(int offset, int length) {
        int len = this.length();
        if (offset + length > len) {
            throw new IndexOutOfBoundsException("Upper bound " + len + " breached:" + (offset + length));
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException("Lower bound breached:" + offset);
        }
        return new ArraySubVector(this, offset, length);
    }

    @Override
    public void copyTo(double[] data, int offset) {
        System.arraycopy(this.getArray(), this.getArrayOffset(), data, offset, this.length());
    }

    @Override
    public void fillRange(int offset, int length, double value) {
        if (offset < 0 || offset + length > this.length()) {
            throw new IndexOutOfBoundsException("Filling range offset=" + offset + " length=" + length);
        }
        double[] arr = this.getArray();
        int off = this.getArrayOffset();
        Arrays.fill(arr, off + offset, off + offset + length, value);
    }

    @Override
    public void set(AVector a) {
        assert (a.length() == this.length());
        a.copyTo(this.getArray(), this.getArrayOffset());
    }

    @Override
    public void set(AVector a, int offset) {
        assert (offset >= 0);
        assert (offset + this.length() <= a.length());
        a.copy(offset, this.length(), this, 0);
    }

    public void add(ArrayVector v) {
        assert (this.length() == v.length());
        this.add(v, 0);
    }

    public void add(ArrayVector src, int srcOffset) {
        int length = this.length();
        double[] vdata = src.getArray();
        double[] data = this.getArray();
        int offset = this.getArrayOffset();
        int voffset = src.getArrayOffset() + srcOffset;
        for (int i = 0; i < length; ++i) {
            int n = offset + i;
            data[n] = data[n] + vdata[voffset + i];
        }
    }

    @Override
    public void copy(int start, int length, AVector dest, int destOffset) {
        if (dest instanceof ArrayVector) {
            this.copy(start, length, (ArrayVector)dest, destOffset);
            return;
        }
        double[] src = this.getArray();
        int off = this.getArrayOffset();
        for (int i = 0; i < length; ++i) {
            dest.set(destOffset + i, src[off + start + i]);
        }
    }

    public void copy(int start, int length, ArrayVector dest, int destOffset) {
        double[] src = this.getArray();
        int off = this.getArrayOffset();
        double[] dst = dest.getArray();
        System.arraycopy(src, off + start, dst, destOffset, length);
    }

    public void addMultiple(ArrayVector v, double factor) {
        int length;
        int vlength = v.length();
        if (vlength != (length = this.length())) {
            throw new Error("Source vector has different size: " + vlength);
        }
        double[] data = this.getArray();
        int offset = this.getArrayOffset();
        double[] vdata = v.getArray();
        int voffset = v.getArrayOffset();
        for (int i = 0; i < length; ++i) {
            int n = offset + i;
            data[n] = data[n] + vdata[voffset + i] * factor;
        }
    }

    @Override
    public double magnitudeSquared() {
        int length = this.length();
        double[] data = this.getArray();
        int offset = this.getArrayOffset();
        double result = 0.0;
        for (int i = 0; i < length; ++i) {
            double v = data[offset + i];
            result += v * v;
        }
        return result;
    }

    @Override
    public double magnitude() {
        return Math.sqrt(this.magnitudeSquared());
    }
}

