/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz.impl;

import java.util.Iterator;
import mikera.vectorz.AVector;
import mikera.vectorz.impl.AWrappedVector;
import mikera.vectorz.impl.Vector0;
import mikera.vectorz.impl.VectorIterator;
import mikera.vectorz.util.ErrorMessages;

public final class WrappedSubVector
extends AWrappedVector<AVector> {
    private static final long serialVersionUID = 2323553136938665228L;
    private final AVector wrapped;
    private final int offset;
    private final int length;

    public WrappedSubVector(AVector source, int offset, int length) {
        if (source instanceof WrappedSubVector) {
            WrappedSubVector v = (WrappedSubVector)source;
            this.wrapped = v.wrapped;
            this.offset = offset + v.offset;
            this.length = length;
        } else {
            this.wrapped = source;
            this.offset = offset;
            this.length = length;
        }
    }

    @Override
    public Iterator<Double> iterator() {
        return new VectorIterator(this.wrapped, this.offset, this.length);
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public boolean isFullyMutable() {
        return this.wrapped.isFullyMutable();
    }

    @Override
    public boolean isElementConstrained() {
        return this.wrapped.isElementConstrained();
    }

    @Override
    public boolean isView() {
        return true;
    }

    @Override
    public double get(int i) {
        if (i < 0 || i >= this.length) {
            throw new IndexOutOfBoundsException(ErrorMessages.invalidIndex(this, i));
        }
        return this.wrapped.unsafeGet(i + this.offset);
    }

    @Override
    public void set(int i, double value) {
        if (i < 0 || i >= this.length) {
            throw new IndexOutOfBoundsException(ErrorMessages.invalidIndex(this, i));
        }
        this.wrapped.unsafeSet(i + this.offset, value);
    }

    @Override
    public double unsafeGet(int i) {
        return this.wrapped.unsafeGet(i + this.offset);
    }

    @Override
    public void unsafeSet(int i, double value) {
        this.wrapped.unsafeSet(i + this.offset, value);
    }

    @Override
    public AVector subVector(int offset, int length) {
        if (offset < 0 || offset + length > this.length) {
            throw new IndexOutOfBoundsException(ErrorMessages.invalidRange(this, offset, length));
        }
        if (length == 0) {
            return Vector0.INSTANCE;
        }
        if (length == this.length) {
            return this;
        }
        return this.wrapped.subVector(this.offset + offset, length);
    }

    @Override
    public AVector join(AVector a) {
        if (a instanceof WrappedSubVector) {
            return this.join((WrappedSubVector)a);
        }
        return super.join(a);
    }

    public AVector join(WrappedSubVector a) {
        if (a.wrapped == this.wrapped && a.offset == this.offset + this.length) {
            int newLength = this.length + a.length;
            if (this.offset == 0 && newLength == this.wrapped.length()) {
                return this.wrapped;
            }
            return new WrappedSubVector(this.wrapped, this.offset, newLength);
        }
        return super.join(a);
    }

    @Override
    public WrappedSubVector exactClone() {
        return new WrappedSubVector(this.wrapped.exactClone(), this.offset, this.length);
    }

    @Override
    public AVector getWrappedObject() {
        return this.wrapped;
    }
}

