/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz.impl;

import mikera.arrayz.ISparse;
import mikera.vectorz.AVector;
import mikera.vectorz.Vectorz;
import mikera.vectorz.impl.AConstrainedVector;
import mikera.vectorz.util.ErrorMessages;
import mikera.vectorz.util.VectorzException;

public final class SingleElementVector
extends AConstrainedVector
implements ISparse {
    private final int dimensions;
    private final int index;
    private double value;

    public SingleElementVector(int componentIndex, int dimensions) {
        this(componentIndex, dimensions, 0.0);
    }

    public SingleElementVector(int componentIndex, int dimensions, double value) {
        if (dimensions <= 0) {
            throw new IllegalArgumentException("SingleElementVEctor must have >= 1 dimensions");
        }
        if (componentIndex < 0 || componentIndex >= dimensions) {
            throw new IllegalArgumentException("Invalid non-zero component index: " + componentIndex);
        }
        this.dimensions = dimensions;
        this.index = componentIndex;
        this.value = value;
    }

    @Override
    public int length() {
        return this.dimensions;
    }

    @Override
    public double magnitude() {
        return this.value;
    }

    @Override
    public double elementSum() {
        return this.value;
    }

    @Override
    public double magnitudeSquared() {
        return this.value * this.value;
    }

    @Override
    public void square() {
        this.value *= this.value;
    }

    @Override
    public double normalise() {
        double ret = this.value;
        if (this.value > 0.0) {
            this.value = 1.0;
        } else if (this.value < 0.0) {
            this.value = -1.0;
        }
        return ret;
    }

    @Override
    public boolean isFullyMutable() {
        return this.dimensions <= 1;
    }

    @Override
    public boolean isElementConstrained() {
        return this.dimensions > 1;
    }

    @Override
    public void multiply(double factor) {
        this.value *= factor;
    }

    @Override
    public double density() {
        return 1.0 / (double)this.length();
    }

    @Override
    public double get(int i) {
        if (i < 0 || i >= this.dimensions) {
            throw new IndexOutOfBoundsException();
        }
        return i == this.index ? this.value : 0.0;
    }

    @Override
    public double unsafeGet(int i) {
        return i == this.index ? this.value : 0.0;
    }

    @Override
    public void set(int i, double value) {
        if (i < 0 || i >= this.dimensions) {
            throw new IndexOutOfBoundsException();
        }
        if (i == this.index) {
            this.value = value;
        } else if (value != 0.0) {
            throw new VectorzException("SingleElementVector not mutable at position: " + i);
        }
    }

    @Override
    public AVector subVector(int offset, int length) {
        int end = offset + length;
        if (offset > this.index || end <= this.index) {
            if (offset < 0 || end > this.length()) {
                throw new IndexOutOfBoundsException(ErrorMessages.invalidRange(this, offset, length));
            }
            return Vectorz.createZeroVector(length);
        }
        return super.subVector(offset, length);
    }

    @Override
    public SingleElementVector exactClone() {
        return new SingleElementVector(this.index, this.dimensions, this.value);
    }
}

