/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz.impl;

import mikera.vectorz.AVector;
import mikera.vectorz.impl.AConstrainedVector;
import mikera.vectorz.impl.Vector0;
import mikera.vectorz.util.ErrorMessages;

public final class RepeatedElementVector
extends AConstrainedVector {
    private final int length;
    private final double value;

    public RepeatedElementVector(int dims, double value) {
        this.length = dims;
        this.value = value;
    }

    public static RepeatedElementVector create(int dims, double value) {
        RepeatedElementVector r = new RepeatedElementVector(dims, value);
        return r;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public boolean isFullyMutable() {
        return false;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public double get(int i) {
        if (i < 0 || i >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.value;
    }

    @Override
    public double unsafeGet(int i) {
        return this.value;
    }

    @Override
    public double elementSum() {
        return (double)this.length * this.value;
    }

    @Override
    public long nonZeroCount() {
        return this.value == 0.0 ? 0L : (long)this.length;
    }

    @Override
    public void set(int i, double value) {
        throw new UnsupportedOperationException(this.getClass().toString() + " is not mutable");
    }

    @Override
    public AVector subVector(int offset, int length) {
        if (offset < 0 || offset + length > this.length) {
            throw new IndexOutOfBoundsException(ErrorMessages.invalidRange(this, offset, length));
        }
        if (length == this.length) {
            return this;
        }
        if (length == 0) {
            return Vector0.INSTANCE;
        }
        return RepeatedElementVector.create(length, this.value);
    }

    @Override
    public RepeatedElementVector exactClone() {
        return new RepeatedElementVector(this.length, this.value);
    }
}

