/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz.impl;

import mikera.vectorz.AVector;
import mikera.vectorz.impl.AComputedVector;
import mikera.vectorz.impl.Vector0;
import mikera.vectorz.util.ErrorMessages;

public class RangeVector
extends AComputedVector {
    private static final long serialVersionUID = 2068299118332621781L;
    private final int start;
    private final int length;

    private RangeVector(int start, int length) {
        this.start = start;
        this.length = length;
    }

    public static RangeVector create(int start, int length) {
        if (length < 0) {
            throw new IllegalArgumentException(ErrorMessages.illegalSize(length));
        }
        return new RangeVector(start, length);
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public double get(int i) {
        if (i < 0 || i >= this.length) {
            throw new IndexOutOfBoundsException(ErrorMessages.invalidIndex(this, i));
        }
        return this.start + i;
    }

    @Override
    public double unsafeGet(int i) {
        return this.start + i;
    }

    @Override
    public double dotProduct(double[] data, int offset) {
        double res = 0.0;
        for (int i = 0; i < this.length; ++i) {
            res += (double)(i + this.start) * data[i + offset];
        }
        return res;
    }

    @Override
    public AVector subVector(int start, int length) {
        if (start < 0 || start + length > this.length) {
            throw new IndexOutOfBoundsException(ErrorMessages.invalidRange(this, start, length));
        }
        if (length == 0) {
            return Vector0.INSTANCE;
        }
        if (length == this.length) {
            return this;
        }
        return RangeVector.create(this.start + start, length);
    }
}

