/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz.impl;

import java.util.AbstractList;
import java.util.Iterator;
import mikera.vectorz.AVector;
import mikera.vectorz.util.ErrorMessages;

public final class ListWrapper
extends AbstractList<Double> {
    private final AVector wrappedVector;
    private final int length;

    public ListWrapper(AVector v) {
        this.wrappedVector = v;
        this.length = v.length();
    }

    @Override
    public Double get(int index) {
        if (index < 0 || index >= this.length) {
            throw new IndexOutOfBoundsException(ErrorMessages.invalidIndex(this.wrappedVector, index));
        }
        return this.wrappedVector.unsafeGet(index);
    }

    @Override
    public Double set(int index, Double value) {
        if (index < 0 || index >= this.length) {
            throw new IndexOutOfBoundsException(ErrorMessages.invalidIndex(this.wrappedVector, index));
        }
        this.wrappedVector.unsafeSet(index, value);
        return null;
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public Iterator<Double> iterator() {
        return this.wrappedVector.iterator();
    }
}

