/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz.impl;

import mikera.vectorz.AVector;
import mikera.vectorz.impl.AIndexedVector;
import mikera.vectorz.impl.Vector0;
import mikera.vectorz.util.ErrorMessages;
import mikera.vectorz.util.VectorzException;

public final class IndexedSubVector
extends AIndexedVector {
    private static final long serialVersionUID = -1411109918028367417L;
    private final AVector data;

    private IndexedSubVector(AVector source, int[] indexes) {
        super(indexes);
        this.data = source;
    }

    public static IndexedSubVector wrap(AVector source, int[] indexes) {
        return new IndexedSubVector(source, indexes);
    }

    @Override
    public double get(int i) {
        return this.data.unsafeGet(this.indexes[i]);
    }

    @Override
    public void set(int i, double value) {
        this.data.unsafeSet(this.indexes[i], value);
    }

    @Override
    public double unsafeGet(int i) {
        return this.data.unsafeGet(this.indexes[i]);
    }

    @Override
    public void unsafeSet(int i, double value) {
        this.data.unsafeSet(this.indexes[i], value);
    }

    @Override
    public AVector subVector(int offset, int length) {
        if (offset < 0 || offset + length > this.length) {
            throw new IndexOutOfBoundsException(ErrorMessages.invalidRange(this, offset, length));
        }
        if (length == 0) {
            return Vector0.INSTANCE;
        }
        if (length == this.length) {
            return this;
        }
        int[] newIndexes = new int[length];
        for (int i = 0; i < length; ++i) {
            newIndexes[i] = this.indexes[offset + i];
        }
        return IndexedSubVector.wrap(this.data, newIndexes);
    }

    @Override
    public IndexedSubVector exactClone() {
        return IndexedSubVector.wrap(this.data.exactClone(), (int[])this.indexes.clone());
    }

    @Override
    public void validate() {
        super.validate();
        int slen = this.data.length();
        for (int i = 0; i < this.length; ++i) {
            if (this.indexes[i] >= 0 && this.indexes[i] < slen) continue;
            throw new VectorzException("Indexes out of range");
        }
    }
}

