/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz.impl;

import mikera.vectorz.AVector;
import mikera.vectorz.impl.AIndexedVector;
import mikera.vectorz.impl.Vector0;
import mikera.vectorz.util.ErrorMessages;

public final class IndexedArrayVector
extends AIndexedVector {
    private static final long serialVersionUID = -1411109918028367417L;
    private final double[] data;

    private IndexedArrayVector(double[] source, int[] indexes) {
        super(indexes);
        this.data = source;
    }

    public static IndexedArrayVector wrap(double[] data, int[] indexes) {
        return new IndexedArrayVector(data, indexes);
    }

    @Override
    public double get(int i) {
        return this.data[this.indexes[i]];
    }

    @Override
    public void set(int i, double value) {
        this.data[this.indexes[i]] = value;
    }

    @Override
    public AVector subVector(int offset, int length) {
        if (offset < 0 || offset + length > this.length) {
            throw new IndexOutOfBoundsException(ErrorMessages.invalidRange(this, offset, length));
        }
        if (length == 0) {
            return Vector0.INSTANCE;
        }
        if (length == this.length) {
            return this;
        }
        int[] newIndexes = new int[length];
        for (int i = 0; i < length; ++i) {
            newIndexes[i] = this.indexes[offset + i];
        }
        return IndexedArrayVector.wrap(this.data, newIndexes);
    }

    @Override
    public IndexedArrayVector exactClone() {
        return IndexedArrayVector.wrap((double[])this.data.clone(), (int[])this.indexes.clone());
    }
}

