/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz.impl;

import mikera.indexz.Index;
import mikera.vectorz.AVector;
import mikera.vectorz.impl.AConstrainedVector;
import mikera.vectorz.util.IntArrays;
import mikera.vectorz.util.VectorzException;

public class IndexVector
extends AConstrainedVector {
    private final Index index;
    private final int length;

    private IndexVector(Index index) {
        this.index = index;
        this.length = index.length();
    }

    public static IndexVector of(int ... values) {
        return new IndexVector(Index.of(values));
    }

    public IndexVector ofDoubles(double ... values) {
        return new IndexVector(Index.wrap(IntArrays.create(values)));
    }

    public static IndexVector wrap(Index a) {
        return new IndexVector(a);
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public double get(int i) {
        return this.index.get(i);
    }

    @Override
    public double unsafeGet(int i) {
        return this.index.unsafeGet(i);
    }

    @Override
    public void set(int i, double value) {
        int v = (int)value;
        if ((double)v != value) {
            throw new IllegalArgumentException("Can't convert to an integer index value: " + value);
        }
        this.index.set(i, v);
    }

    @Override
    public void unsafeSet(int i, double value) {
        int v = (int)value;
        this.index.set(i, v);
    }

    @Override
    public void getElements(double[] data, int offset) {
        for (int i = 0; i < this.length; ++i) {
            data[offset + i] = this.index.unsafeGet(i);
        }
    }

    @Override
    public AVector exactClone() {
        return new IndexVector(this.index.clone());
    }

    @Override
    public void validate() {
        if (this.length != this.index.length()) {
            throw new VectorzException("Incorrect index length!!");
        }
        super.validate();
    }
}

