/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz.impl;

import mikera.arrayz.ISparse;
import mikera.vectorz.AVector;
import mikera.vectorz.Vector;
import mikera.vectorz.Vector2;
import mikera.vectorz.Vector3;
import mikera.vectorz.Vectorz;
import mikera.vectorz.impl.AComputedVector;
import mikera.vectorz.util.ErrorMessages;
import mikera.vectorz.util.VectorzException;

public class AxisVector
extends AComputedVector
implements ISparse {
    private static final long serialVersionUID = 6767495113060894804L;
    private final int axis;
    private final int length;

    public AxisVector(int axisIndex, int length) {
        assert (length >= 1);
        assert (axisIndex >= 0 && axisIndex < length);
        this.axis = axisIndex;
        this.length = length;
    }

    public static AxisVector create(int axisIndex, int dimensions) {
        return new AxisVector(axisIndex, dimensions);
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public double magnitude() {
        return 1.0;
    }

    @Override
    public double magnitudeSquared() {
        return 1.0;
    }

    @Override
    public double normalise() {
        return 1.0;
    }

    @Override
    public void square() {
    }

    @Override
    public void abs() {
    }

    @Override
    public void sqrt() {
    }

    @Override
    public void signum() {
    }

    @Override
    public double elementSum() {
        return 1.0;
    }

    @Override
    public long nonZeroCount() {
        return 1L;
    }

    @Override
    public boolean isZero() {
        return false;
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public boolean isUnitLengthVector() {
        return true;
    }

    @Override
    public double dotProduct(AVector v) {
        if (v.length() != this.length) {
            throw new IllegalArgumentException("Mismatched vector sizes");
        }
        return v.unsafeGet(this.axis);
    }

    @Override
    public double dotProduct(double[] data, int offset) {
        return data[offset + this.axis];
    }

    @Override
    public double dotProduct(Vector v) {
        assert (this.length == v.length());
        return v.data[this.axis];
    }

    public double dotProduct(Vector3 v) {
        assert (this.length == 3);
        switch (this.axis) {
            case 0: {
                return v.x;
            }
            case 1: {
                return v.y;
            }
            case 2: {
                return v.z;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public double dotProduct(Vector2 v) {
        assert (this.length == 2);
        switch (this.axis) {
            case 0: {
                return v.x;
            }
            case 1: {
                return v.y;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public double get(int i) {
        if (i < 0 || i >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        return i == this.axis ? 1.0 : 0.0;
    }

    @Override
    public double unsafeGet(int i) {
        return i == this.axis ? 1.0 : 0.0;
    }

    @Override
    public Vector toNormal() {
        return this.toVector();
    }

    @Override
    public Vector toVector() {
        Vector v = Vector.createLength(this.length);
        v.data[this.axis] = 1.0;
        return v;
    }

    @Override
    public AVector subVector(int start, int length) {
        if (start < 0 || start + length > this.length) {
            throw new IndexOutOfBoundsException(ErrorMessages.invalidRange(this, start, length));
        }
        if (length == this.length) {
            return this;
        }
        if (start <= this.axis && start + length > this.axis) {
            return AxisVector.create(this.axis - start, length);
        }
        return Vectorz.createZeroVector(length);
    }

    @Override
    public AxisVector exactClone() {
        return this;
    }

    @Override
    public double density() {
        return 1.0 / (double)this.length;
    }

    @Override
    public void validate() {
        if (this.length <= 0) {
            throw new VectorzException("Axis vector length is too small: " + this.length);
        }
        if (this.axis < 0 || this.axis > this.length) {
            throw new VectorzException("Axis index out of bounds");
        }
        super.validate();
    }
}

