/*
 * Decompiled with CFR 0.152.
 */
package mikera.matrixx.impl;

import mikera.matrixx.AMatrix;
import mikera.matrixx.Matrix;
import mikera.matrixx.Matrixx;
import mikera.matrixx.impl.AStridedMatrix;
import mikera.vectorz.AVector;
import mikera.vectorz.Op;
import mikera.vectorz.Vector;
import mikera.vectorz.Vectorz;
import mikera.vectorz.impl.AStridedVector;
import mikera.vectorz.impl.StridedVector;
import mikera.vectorz.util.ErrorMessages;
import mikera.vectorz.util.VectorzException;

public final class StridedMatrix
extends AStridedMatrix {
    private final int rowStride;
    private final int colStride;
    private final int offset;

    private StridedMatrix(double[] data, int rowCount, int columnCount, int offset, int rowStride, int columnStride) {
        super(data, rowCount, columnCount);
        this.offset = offset;
        this.rowStride = rowStride;
        this.colStride = columnStride;
    }

    public static StridedMatrix create(int rowCount, int columnCount) {
        double[] data = new double[rowCount * columnCount];
        return new StridedMatrix(data, rowCount, columnCount, 0, columnCount, 1);
    }

    @Override
    public AStridedVector getRow(int i) {
        return StridedVector.wrap(this.data, this.offset + i * this.rowStride, this.cols, this.colStride);
    }

    @Override
    public AStridedVector getColumn(int i) {
        return StridedVector.wrap(this.data, this.offset + i * this.colStride, this.rows, this.rowStride);
    }

    @Override
    public void copyRowTo(int row, double[] dest, int destOffset) {
        int rowOffset = this.offset + row * this.rowStride;
        for (int i = 0; i < this.cols; ++i) {
            dest[destOffset + i] = this.data[rowOffset + i * this.colStride];
        }
    }

    @Override
    public void copyColumnTo(int col, double[] dest, int destOffset) {
        int colOffset = this.offset + col * this.colStride;
        for (int i = 0; i < this.rows; ++i) {
            dest[destOffset + i] = this.data[colOffset + i * this.rowStride];
        }
    }

    @Override
    public int rowStride() {
        return this.rowStride;
    }

    @Override
    public int columnStride() {
        return this.colStride;
    }

    @Override
    public int getArrayOffset() {
        return this.offset;
    }

    @Override
    public boolean isPackedArray() {
        return this.offset == 0 && this.colStride == 1 && this.rowStride == this.cols && this.data.length == this.rows * this.cols;
    }

    @Override
    public AStridedMatrix subMatrix(int rowStart, int rowCount, int colStart, int colCount) {
        if (rowStart < 0 || rowStart >= this.rows || colStart < 0 || colStart >= this.cols) {
            throw new IndexOutOfBoundsException(ErrorMessages.position(rowStart, colStart));
        }
        if (rowStart + rowCount > this.rows || colStart + colCount > this.cols) {
            throw new IndexOutOfBoundsException(ErrorMessages.position(rowStart + rowCount, colStart + colCount));
        }
        if (rowCount < 1 || colCount < 1) {
            throw new IllegalArgumentException(ErrorMessages.illegalSize(rowCount, colCount));
        }
        return new StridedMatrix(this.data, rowCount, colCount, this.offset + rowStart * this.rowStride + colStart * this.colStride, this.rowStride, this.colStride);
    }

    @Override
    public void applyOp(Op op) {
        int rc = this.rowCount();
        int cc = this.columnCount();
        for (int row = 0; row < rc; ++row) {
            for (int col = 0; col < cc; ++col) {
                int index = this.index(row, col);
                double v = this.data[index];
                this.data[index] = op.apply(v);
            }
        }
    }

    @Override
    public void getElements(double[] dest, int destOffset) {
        int rc = this.rowCount();
        int cc = this.columnCount();
        int di = destOffset;
        for (int row = 0; row < rc; ++row) {
            for (int col = 0; col < cc; ++col) {
                int index = this.index(row, col);
                double v = this.data[index];
                dest[di++] = v;
            }
        }
    }

    @Override
    public AMatrix getTranspose() {
        return Matrixx.wrapStrided(this.data, this.cols, this.rows, this.offset, this.colStride, this.rowStride);
    }

    @Override
    public AMatrix getTransposeView() {
        return Matrixx.wrapStrided(this.data, this.cols, this.rows, this.offset, this.colStride, this.rowStride);
    }

    @Override
    public double get(int row, int column) {
        if (row < 0 || column < 0 || row >= this.rows || column >= this.cols) {
            throw new IndexOutOfBoundsException(ErrorMessages.invalidIndex(this, row, column));
        }
        return this.data[this.index(row, column)];
    }

    @Override
    public double unsafeGet(int row, int column) {
        return this.data[this.index(row, column)];
    }

    @Override
    public AVector asVector() {
        if (this.isPackedArray()) {
            return Vector.wrap(this.data);
        }
        if (this.cols == 1) {
            return Vectorz.wrapStrided(this.data, this.offset, this.rows, this.rowStride);
        }
        if (this.rows == 1) {
            return Vectorz.wrapStrided(this.data, this.offset, this.cols, this.colStride);
        }
        return super.asVector();
    }

    @Override
    public void set(int row, int column, double value) {
        if (row < 0 || column < 0 || row >= this.rows || column >= this.cols) {
            throw new IndexOutOfBoundsException("[" + row + "," + column + "]");
        }
        this.data[this.index((int)row, (int)column)] = value;
    }

    @Override
    public void unsafeSet(int row, int column, double value) {
        this.data[this.index((int)row, (int)column)] = value;
    }

    @Override
    public AMatrix exactClone() {
        return new StridedMatrix((double[])this.data.clone(), this.rows, this.cols, this.offset, this.rowStride, this.colStride);
    }

    public static StridedMatrix create(AMatrix m) {
        StridedMatrix sm = StridedMatrix.create(m.rowCount(), m.columnCount());
        sm.set(m);
        return sm;
    }

    public static StridedMatrix wrap(Matrix m) {
        return new StridedMatrix(m.data, m.rowCount(), m.columnCount(), 0, m.columnCount(), 1);
    }

    public static StridedMatrix wrap(double[] data, int rows, int columns, int offset, int rowStride, int columnStride) {
        return new StridedMatrix(data, rows, columns, offset, rowStride, columnStride);
    }

    @Override
    public void validate() {
        super.validate();
        if (!this.equals(this)) {
            throw new VectorzException("Universe destroyed: thing not equal to itself");
        }
        if (this.offset < 0) {
            throw new VectorzException("Negative offset! [" + this.offset + "]");
        }
        if (this.index(this.rows - 1, this.cols - 1) >= this.data.length) {
            throw new VectorzException("Negative offset! [" + this.offset + "]");
        }
    }

    @Override
    protected final int index(int row, int col) {
        return this.offset + row * this.rowStride + col * this.colStride;
    }

    @Override
    public Matrix clone() {
        return Matrix.create(this);
    }
}

