/*
 * Decompiled with CFR 0.152.
 */
package mikera.matrixx.impl;

import java.util.List;
import mikera.matrixx.AMatrix;
import mikera.matrixx.impl.AMatrixSubVector;
import mikera.vectorz.AVector;
import mikera.vectorz.Op;
import mikera.vectorz.util.ErrorMessages;

public class MatrixViewVector
extends AMatrixSubVector {
    final AMatrix source;
    final int rows;
    final int columns;
    final int length;

    public MatrixViewVector(AMatrix a) {
        this.source = a;
        this.rows = a.rowCount();
        this.columns = a.columnCount();
        this.length = this.rows * this.columns;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public double get(int i) {
        if (i < 0 || i >= this.length) {
            throw new IndexOutOfBoundsException(ErrorMessages.invalidIndex(this, i));
        }
        return this.source.unsafeGet(i / this.columns, i % this.columns);
    }

    @Override
    public void set(int i, double value) {
        if (i < 0 || i >= this.length) {
            throw new IndexOutOfBoundsException(ErrorMessages.invalidIndex(this, i));
        }
        this.source.unsafeSet(i / this.columns, i % this.columns, value);
    }

    @Override
    public double unsafeGet(int i) {
        return this.source.unsafeGet(i / this.columns, i % this.columns);
    }

    @Override
    public void unsafeSet(int i, double value) {
        this.source.unsafeSet(i / this.columns, i % this.columns, value);
    }

    @Override
    public AVector exactClone() {
        return new MatrixViewVector(this.source.exactClone());
    }

    @Override
    public void fill(double v) {
        this.source.fill(v);
    }

    @Override
    public boolean isFullyMutable() {
        return this.source.isFullyMutable();
    }

    @Override
    public boolean isMutable() {
        return this.source.isMutable();
    }

    @Override
    public boolean isView() {
        return true;
    }

    @Override
    public boolean isZero() {
        return this.source.isZero();
    }

    @Override
    public void getElements(double[] data, int offset) {
        this.source.getElements(data, offset);
    }

    @Override
    public List<Double> asElementList() {
        return this.source.asElementList();
    }

    @Override
    public void clamp(double min, double max) {
        this.source.clamp(min, max);
    }

    @Override
    public double elementSum() {
        return this.source.elementSum();
    }

    @Override
    public double magnitudeSquared() {
        return this.source.elementSquaredSum();
    }

    @Override
    public void applyOp(Op op) {
        this.source.applyOp(op);
    }

    @Override
    public void abs() {
        this.source.abs();
    }

    @Override
    public void signum() {
        this.source.signum();
    }

    @Override
    public void negate() {
        this.source.negate();
    }

    @Override
    public void exp() {
        this.source.exp();
    }

    @Override
    public void log() {
        this.source.log();
    }

    @Override
    public void square() {
        this.source.square();
    }

    @Override
    public void sqrt() {
        this.source.sqrt();
    }

    @Override
    public void pow(double exponent) {
        this.source.pow(exponent);
    }
}

