/*
 * Decompiled with CFR 0.152.
 */
package mikera.matrixx.impl;

import java.nio.DoubleBuffer;
import mikera.arrayz.INDArray;
import mikera.matrixx.AMatrix;
import mikera.matrixx.Matrix;
import mikera.vectorz.AVector;
import mikera.vectorz.Vector;
import mikera.vectorz.util.DoubleArrays;
import mikera.vectorz.util.ErrorMessages;

public final class ImmutableMatrix
extends AMatrix {
    private double[] data;
    private int rows;
    private int cols;

    private ImmutableMatrix(int rows, int cols, double[] data) {
        this.rows = rows;
        this.cols = cols;
        this.data = data;
    }

    public ImmutableMatrix(AMatrix m) {
        this.rows = m.rowCount();
        this.cols = m.columnCount();
        this.data = m.toDoubleArray();
    }

    public static ImmutableMatrix wrap(Matrix source) {
        double[] data = source.data;
        return new ImmutableMatrix(source.rowCount(), source.columnCount(), data);
    }

    public static ImmutableMatrix wrap(int rows, int cols, double[] data) {
        return new ImmutableMatrix(rows, cols, data);
    }

    @Override
    public int rowCount() {
        return this.rows;
    }

    @Override
    public int columnCount() {
        return this.cols;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public boolean isFullyMutable() {
        return false;
    }

    @Override
    public boolean isView() {
        return false;
    }

    @Override
    public long nonZeroCount() {
        return DoubleArrays.nonZeroCount(this.data);
    }

    @Override
    public boolean isBoolean() {
        return DoubleArrays.isBoolean(this.data, 0, this.data.length);
    }

    @Override
    public boolean isZero() {
        return DoubleArrays.isZero(this.data, 0, this.data.length);
    }

    @Override
    public double get(int row, int column) {
        if (row < 0 || row >= this.rows || column < 0 || column >= this.cols) {
            throw new IndexOutOfBoundsException(ErrorMessages.invalidIndex(this, row, column));
        }
        return this.unsafeGet(row, column);
    }

    @Override
    public double unsafeGet(int i, int j) {
        return this.data[i * this.cols + j];
    }

    @Override
    public void set(int row, int column, double value) {
        throw new UnsupportedOperationException(ErrorMessages.immutable(this));
    }

    @Override
    public final void copyRowTo(int row, double[] dest, int destOffset) {
        int srcOffset = row * this.cols;
        System.arraycopy(this.data, srcOffset, dest, destOffset, this.cols);
    }

    @Override
    public Vector innerProduct(AVector a) {
        if (a instanceof Vector) {
            return this.innerProduct((Vector)a);
        }
        return this.transform(a);
    }

    @Override
    public Vector transform(AVector a) {
        Vector v = Vector.createLength(this.rows);
        for (int i = 0; i < this.rows; ++i) {
            v.data[i] = a.dotProduct(this.data, i * this.cols);
        }
        return v;
    }

    @Override
    public void transform(Vector source, Vector dest) {
        int rc = this.rowCount();
        int cc = this.columnCount();
        if (source.length() != cc) {
            throw new IllegalArgumentException(ErrorMessages.wrongSourceLength(source));
        }
        if (dest.length() != rc) {
            throw new IllegalArgumentException(ErrorMessages.wrongDestLength(dest));
        }
        int di = 0;
        for (int row = 0; row < rc; ++row) {
            double total = 0.0;
            for (int column = 0; column < cc; ++column) {
                total += this.data[di + column] * source.data[column];
            }
            di += cc;
            dest.data[row] = total;
        }
    }

    @Override
    public final void copyColumnTo(int col, double[] dest, int destOffset) {
        int colOffset = col;
        for (int i = 0; i < this.rows; ++i) {
            dest[destOffset + i] = this.data[colOffset + i * this.cols];
        }
    }

    @Override
    public double elementSum() {
        return DoubleArrays.elementSum(this.data);
    }

    @Override
    public double elementSquaredSum() {
        return DoubleArrays.elementSquaredSum(this.data);
    }

    @Override
    public Vector toVector() {
        return Vector.create(this.data);
    }

    @Override
    public Matrix toMatrix() {
        return Matrix.wrap(this.rows, this.cols, DoubleArrays.copyOf(this.data));
    }

    @Override
    public Matrix toMatrixTranspose() {
        int di = 0;
        Matrix m = Matrix.create(this.cols, this.rows);
        for (int j = 0; j < this.rows; ++j) {
            for (int i = 0; i < this.cols; ++i) {
                m.unsafeSet(i, j, this.data[di++]);
            }
        }
        return m;
    }

    @Override
    public void toDoubleBuffer(DoubleBuffer dest) {
        dest.put(this.data);
    }

    @Override
    public void getElements(double[] dest, int offset) {
        System.arraycopy(this.data, 0, dest, offset, this.data.length);
    }

    @Override
    public Matrix clone() {
        return Matrix.create(this);
    }

    @Override
    public AMatrix exactClone() {
        return new ImmutableMatrix(this);
    }

    public double[] getInternalData() {
        return this.data;
    }

    public static INDArray create(AMatrix a) {
        int rows = a.rowCount();
        int cols = a.columnCount();
        int n = rows * cols;
        double[] data = new double[n];
        a.getElements(data, 0);
        return ImmutableMatrix.wrap(rows, cols, data);
    }
}

