/*
 * Decompiled with CFR 0.152.
 */
package mikera.matrixx.impl;

import mikera.matrixx.AMatrix;
import mikera.matrixx.Matrix;
import mikera.matrixx.impl.RowMatrix;
import mikera.vectorz.AVector;
import mikera.vectorz.Op;
import mikera.vectorz.Vector;
import mikera.vectorz.util.ErrorMessages;

public class ColumnMatrix
extends AMatrix {
    private final AVector vector;

    public ColumnMatrix(AVector v) {
        this.vector = v;
    }

    public static ColumnMatrix wrap(AVector v) {
        return new ColumnMatrix(v);
    }

    @Override
    public int rowCount() {
        return this.vector.length();
    }

    @Override
    public int columnCount() {
        return 1;
    }

    @Override
    public void copyColumnTo(int col, double[] dest, int destOffset) {
        if (col != 0) {
            throw new IndexOutOfBoundsException("Column out of range: " + col);
        }
        this.vector.getElements(dest, destOffset);
    }

    @Override
    public void copyRowTo(int row, double[] dest, int destOffset) {
        dest[destOffset] = this.vector.get(row);
    }

    @Override
    public void getElements(double[] data, int offset) {
        this.vector.getElements(data, offset);
    }

    @Override
    public void applyOp(Op op) {
        this.vector.applyOp(op);
    }

    @Override
    public void multiply(double factor) {
        this.vector.scale(factor);
    }

    @Override
    public double elementSum() {
        return this.vector.elementSum();
    }

    @Override
    public long nonZeroCount() {
        return this.vector.nonZeroCount();
    }

    @Override
    public double get(int row, int column) {
        if (column != 0) {
            throw new IndexOutOfBoundsException(ErrorMessages.position(row, column));
        }
        return this.vector.get(row);
    }

    @Override
    public void set(int row, int column, double value) {
        if (column != 0) {
            throw new IndexOutOfBoundsException(ErrorMessages.position(row, column));
        }
        this.vector.set(row, value);
    }

    @Override
    public double unsafeGet(int row, int column) {
        return this.vector.unsafeGet(row);
    }

    @Override
    public void unsafeSet(int row, int column, double value) {
        this.vector.unsafeSet(row, value);
    }

    @Override
    public RowMatrix getTranspose() {
        return new RowMatrix(this.vector);
    }

    @Override
    public Vector toVector() {
        return this.vector.toVector();
    }

    @Override
    public AVector asVector() {
        return this.vector;
    }

    @Override
    public ColumnMatrix exactClone() {
        return new ColumnMatrix(this.vector.exactClone());
    }

    @Override
    public Matrix transposeInnerProduct(Matrix s) {
        Vector v = this.vector.innerProduct(s).toVector();
        return Matrix.wrap(1, s.columnCount(), v.asDoubleArray());
    }
}

