/*
 * Decompiled with CFR 0.152.
 */
package mikera.matrixx;

import mikera.matrixx.AMatrix;
import mikera.vectorz.util.ErrorMessages;

public final class Matrix11
extends AMatrix {
    private double value;

    public Matrix11() {
        this(0.0);
    }

    public Matrix11(double value) {
        this.value = value;
    }

    @Override
    public int rowCount() {
        return 1;
    }

    @Override
    public int columnCount() {
        return 1;
    }

    @Override
    public double determinant() {
        return this.value;
    }

    @Override
    public double elementSum() {
        return this.value;
    }

    @Override
    public double elementSquaredSum() {
        return this.value * this.value;
    }

    @Override
    public long nonZeroCount() {
        return this.value == 0.0 ? 0L : 1L;
    }

    @Override
    public long elementCount() {
        return 1L;
    }

    @Override
    public boolean isSquare() {
        return true;
    }

    @Override
    public boolean isDiagonal() {
        return true;
    }

    @Override
    public boolean isZero() {
        return this.value == 0.0;
    }

    @Override
    public boolean isIdentity() {
        return this.value == 1.0;
    }

    @Override
    public double trace() {
        return this.value;
    }

    @Override
    public double get(int row, int column) {
        if (row != 0 || column != 0) {
            throw new IndexOutOfBoundsException(ErrorMessages.invalidIndex(this, row, column));
        }
        return this.value;
    }

    @Override
    public void set(int row, int column, double value) {
        if (row != 0 || column != 0) {
            throw new IndexOutOfBoundsException(ErrorMessages.invalidIndex(this, row, column));
        }
        this.value = value;
    }

    @Override
    public void addAt(int i, int j, double value) {
        this.value += value;
    }

    @Override
    public void multiply(double factor) {
        this.value *= factor;
    }

    @Override
    public double unsafeGet(int row, int column) {
        return this.value;
    }

    @Override
    public void unsafeSet(int row, int column, double value) {
        this.value = value;
    }

    @Override
    public void getElements(double[] data, int offset) {
        data[offset] = this.value;
    }

    @Override
    public void copyRowTo(int row, double[] dest, int destOffset) {
        dest[destOffset] = this.value;
    }

    @Override
    public void copyColumnTo(int col, double[] dest, int destOffset) {
        dest[destOffset] = this.value;
    }

    @Override
    public AMatrix exactClone() {
        return new Matrix11(this.value);
    }
}

